<?php
class CaBehavior extends CActiveRecordBehavior
{
    public function afterSave($event)
    {
        $this->_updateCache();
        return true;
    }
    
    public function afterDelete($event)
    {
        $this->_updateCache();
        return true;
    }
    
    private function _updateCache()
    {
        $cacheFile = ROOT_PATH . 'cache/bbs/forums/forums_type.php';
        $types = TopicTypes::model()->findAll(array('order'=>'vieworder DESC'));
        
        $array = array();
        if (!empty($types))
        {
            foreach ($types as $type)
            { 
                $array[$type->fid][$type->id] = array('id'=>$type->id,'fid'=>$type->fid,'name'=>$type->name,'vieworder'=>$type->vieworder);
            }
        }
        file_put_contents($cacheFile, "<?php\nreturn ".var_export($array,true).';');
    }
}