<?php
/**
 * 封装前端的一些操作
 * @author yzxh24
 */
require_once ROOT_PATH . 'model/model.php';
class Front
{
    /**
     * 修改密码后产生一个新的密钥串
     * @static
     * @return string
     */
    public static function getNewIorange()
    {
        return uuid();
    }

    /**
     * 刷新书会缓存信息
     * @param int $bookId
     * @return void
     */
    public static function updateBookForum($bookId)
    {
        updateBookForum($bookId);
    }
    
    /**
     * 获取系统的根路径
     * @return string
     */
    public static function getBasePath()
    {
        return ROOT_PATH;
    }
    
    public static function getCoverPath($bookId)
    {
        return Book::getCoverSavePath($bookId);
    }
    
    /**
     * 获取小说封面保存根路径
     * @return string
     */
    public static function getCoverBasePath()
    {
        return self::getBasePath() . 'data/cover/';
    }
    
    /**
     * 获取小说封面的URL根地址
     * @return string
     */
    public static function getCoverBaseUrl()
    {
        return Yii::app()->params['coverUrl'];
    }
    
    public static function getMd($param, $start = 0, $len = 1)
    {
        return substr(md5($param), $start, $len);
    }

    /**
     * 获取章节内容存取目录
     * @param int $bookId
     * @return string
     */
    public static function getBookFileSavePath($bookId)
    {
        $path = Chapter::getContentPath($bookId);
        if (!is_dir($path))
        {
            IFileHelper::createDir($path);
        }
        
        return $path;
    }

    /**
     * 更新小说缓存
     * @param int $bookId
     * @return void
     */
    public static function updateBookInfo($bookId)
    {
        updateBookInfo($bookId);
    }
    
    /**
     * 更新章节列表缓存
     * @param int $bookId
     * @return void
     */
    public static function updateChapterCache($bookId)
    {
        Chapter::single()->updateCache($bookId);
    }

    /**
     * 读取一个章节的内容
     * @static
     * @param  $bookId
     * @param  $chapterId
     * @return string
     */
    public static function getChapterContent($bookId, $chapterId)
    {
        return Chapter::single()->getContent($bookId, $chapterId);
    }

    /**
     * 写入章节内容
     * @static
     * @param  $bookId
     * @param  $chapterId
     * @param  $content
     * @return void
     */
    public static function setChapterContent($bookId, $chapterId,$content)
    {
        Chapter::single()->setContent($bookId, $chapterId, $content);
    }

    /**
     * 获取章节内容的大小
     * @static
     * @param  $content
     * @return int
     */
    public static function getChapterSize($content)
    {
        return Chapter::single()->getChapterSize($content);
    }

    /**
     * 删除一个章节
     * @static
     * @param  $chapterId
     * @param  $bookId
     * @return void
     */
    public static function deleteChapter($chapterId, $bookId)
    {
        Chapter::single()->delete($chapterId, $bookId);
    }

    /**
     * 修改章节
     * @static
     * @param $chapterId
     * @param $bookId
     * @param $data
     */
    public static function updateChapter($chapterId, $bookId, $data)
    {
        Chapter::single()->update($chapterId, $bookId, $data);
    }

    /**
     * 重新排序章节
     * @static
     * @param $from
     * @param $to
     * @param $bookId
     */
    public static function sortChapter($from, $to, $bookId)
    {
        Chapter::single()->sort($from, $to, $bookId);
    }

    /**
     * 更新高级贴缓存
     * @param int $bookId
     * @param int $num
     * @return void
     */
    public static function updateAdvancePost($bookId, $num = 3)
    {
        require_once ROOT_PATH . 'model/bookpost.php';
        updateAdvancePost($bookId, $num);
    }
    
    /**
     * 获取管理组ID
     * @return array
     */
    public static function getAdminGroup()
    {
        return getAdminGroup();
    }
    
    /**
     * 刷新前台广告缓存
     * @return void
     */
    public static function updateAdCache()
    {
        update_ad();
    }

    /**
     * 刷新书管缓存
     * @static
     * @param $bookId
     */
    public static function updateBookManage($bookId)
    {
        require_once ROOT_PATH . 'model/bookmanagers.php';

        updateBookManage($bookId);
    }
    
    public static function getWeekRange($week, $year)
    {
        return getWeekRange($week, $year);
    }
    
    public static function getDates($start, $end)
    {
        $dates = getDates($start, $end);
        return array(date('Y-m-d', strtotime($dates[0])),date('Y-m-d', strtotime($dates[6])));
    }

    /**
     * 获取一个配置的值
     * @static
     * @param $key
     * @return mixd
     */
    public static function setting($key)
    {
        return setting($key);
    }

    /**
     * 获取勋章列表
     * @static
     * @param $medals
     * @return array|bool
     */
    public static function getMemberMedals($medals)
    {
        require_once ROOT_PATH . 'libs/class/iMedals.php';

        $return = false;
        $result = iMedals::single()->getMedalsString($medals);
        $baseUrl = dirname(Yii::app()->params['imageUrl']);
        if (false !== $result)
        {
            foreach ($result['images'] as $image)
            {
                preg_match('/src=\"(.*?)\"/i', $image, $match);
                $return[] = $baseUrl . '/' . $match[1];
            }
        }

        return $return;
    }

    /**
     * 获取一个勋章的信息
     * @static
     * @param $id
     * @return array
     */
    public static function getMedal($id)
    {
        // 非常搓的代码，凑合着用吧
        $medal = iMedals::single()->getMedal($id);

        return array('id' => $id, 'image' => dirname(Yii::app()->params['imageUrl']) . '/' . iMedals::getImage($medal['image']), 'title' => $medal['title']);
    }

    /**
     * 获取前台的图片路径
     * @static
     * @param $image
     * @param bool $tpl
     * @return string
     */
    public static function getImageFile($image, $tpl = false)
    {
        return getImageFile($image, $tpl);
    }

    /**
     * 刷新前台用户的缓存
     * @static
     * @param $uid
     */
    public static function updateMemberCache($uid)
    {
        require_once ROOT_PATH . 'model/members.php';
        Members::single()->updateOneCache($uid);
    }

    /**
     * 更新未阅读的短信条数到用户newpm字段
     * @static
     * @param $uid
     */
    public static function updateNewCount($uid)
    {
        Message::single()->updateNewCount($uid);
    }

    /**
     * 操作用户组
     * @static
     * @param $member
     * @param $expire
     * @param int $groupid
     */
    public static function groupOperate($member, $expire, $groupid = 5)
    {
        //require_once ROOT_PATH . 'model/members.php';
        //require_once ROOT_PATH . 'model/memberfields.php';
        groupOperate($member, $expire, $groupid);
    }
}