<?php
/**
 * 后台管理人员登录Identity
 * 
 * @author yzxh24
 *
 */
class ManagerIdentity extends CUserIdentity
{
	private $id;

	public function authenticate()
    {
		$manager = Manager::model()->findByAttributes(array('username' => $this->username));
		if (null === $manager)
        {
			$this->errorCode = self::ERROR_USERNAME_INVALID;
		}
        elseif (md5($this->password) !== $manager->password)
        {
			$this->errorCode = self::ERROR_PASSWORD_INVALID;
		}
        else
        {
			$this->id = $manager->id;
			$this->setState('name', $manager->username);
			$this->errorCode = self::ERROR_NONE;
		}

		return ! $this->errorCode;
	}

	public function getId()
    {
		return $this->id;
	}
}