<?php
/**
 * Descriptions
 * @author yzxh24
 * @email yzxh24@gmail.com
 * @created 2010-06-07 15:10:02
 */
class AdController extends BackendController
{
    /**
     * 面包屑导航
     * @var array
     */
    public $breadcrumbs = array('广告列表'=>array('/admin/ad/list'));
    
    /**
     * action路径前缀
     */
	protected $actionPrefix = 'admin.controllers.Ad.';

    /**
     * action对应表
     */
    protected $actionMap = array(
        'list' => 'ListAction',
        'ads' => 'AdsAction',
        'detail' => 'DetailAction',
        'create' => 'CreateAction',
        'update' => 'UpdateAction',
        'delete' => 'DeleteAction',
    );

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax'] === 'ad-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}