<?php
/**
 * 后台部门授权公共授控制器
 * 请阅读Yii RBAC权限管理
 * 角色(Role) 任务(Task) 操作(Operation)
 * 本系统中Modules_Controller_Actions为一组操作(Operation)格式固定.
 * 任务(Task):为部门
 *
 * 本系统规则:
 * 角色可以包含一组任务(Task).
 * 角色可以包含一组操作(Operation).
 * 角色不可能包含角色
 *
 * 任务可以包含一组操作(Operation)
 * 任务不可以包含任务.
 *
 * 操作具有原子性,不可以再分.
 * @author ouyang
 */
class AuthorController extends BackendController
{
    protected $actionPrefix = 'admin.controllers.Author.';

	protected $actionMap = array(
			'createrole' => 'CreateRoleAction',
            'listroles' => 'ListRolesAction',
            'roleassign'=>'RoleAssignAction',
            'roleaddchild'=>'RoleAddChildAction',
           
			'createoperation' => 'CreateOperationAction',
            'listoperations' => 'ListOperationsAction',
         
			'taskaddchild' => 'TaskAddChildAction',
			'taskassign' => 'TaskAssignAction',
			'listdepartments' => 'ListDepartmentsAction',
           
			'listusers' => 'ListUsersAction',
            'userassign'=>'UserAssignAction',
            'assignuser'=>'AssignUserAction',

            'authorityassign' => 'AuthorityAssignAction',
        
    );

    /**
     * 索引是否在数组里
     * @param <string> $key
     * @param <array> $arr
     * @return <object> 存在返回该数组里的值,否则返回空
     */
    private function isExist($key,$arr)
    {
        if(array_key_exists ($key,$arr))
        {
            $value = $arr[$key];
            return $value;
        }
        return null;
    }
    
    /**
     * 得到Yii全部的授权角色
     * @return array(<string> $name,<CAuthItem> $role)
     */
    public function getRoles($user = null)
    {
        $auth = Yii::app()->getAuthManager();
        $roles = $auth->getRoles($user);
        return $roles;
    }

    /**
     * 根据名称得到授权角色实例
     * @param <string> $name
     * @return CAuthItem 如果存在返回该实例,否则为空
     */
    public function getRole($name)
    {
        $roles = $this->getRoles();
        return $this->isExist($name, $roles);
    }

     /**
     * 根据角色获取所有行为
     * @param <CAuthItem> $role
     * @return array() 返回该角色所有授权行为,否则为空
     */

    public function getAssign(CAuthItem $auth)
    {
      //  $role=$this->getRole($name);
        if(isset($auth))
        {
            #得到该用户的所有授权行为
            $childs = $auth->children;
            return $childs;
        }
        return null;
    }

    /**
     * 移取该角色的授权行为.
     * 返回$arr
     * @param <CAuthItem> $role
     */
    public function removeAssign(CAuthItem $auth,$arr = null)
    {
       // $role=$this->getRole($name);
        $childs = $this->getAssign($auth);
        foreach($childs as $child)
        {
            $name = $child->name;
            if(isset($arr) && in_array($name, $arr))
            {
                unset ($arr[array_search($name ,$arr)]);
            }else
            {
                $auth->removeChild($name);
            }
        }
        return $arr;
    }

      /**
     * 得到Yii全部的授权部门
     * @return array(<string> $name,<CAuthItem> $role)
     */
    public function getTasks($user = null)
    {
        $auth = Yii::app()->getAuthManager();
        $tasks = $auth->getTasks($user);
        return $tasks;
    }

    /**
     * 根据名称得到授权角色实例
     * @param <string> $name
     * @return CAuthItem 如果存在返回该实例,否则为空
     */
    public function getTask($name)
    {
        $tasks = $this->getTasks();
        return $this->isExist($name, $tasks);
    }
   
    /**
     * 得到所有的行为操作
     * @author ouyang
     */

    public function getOperations($user = null)
    {
        $auth = Yii::app()->getAuthManager();
        $operations = $auth->getOperations($user);
        return $operations;
    }

    /**
     * 删除$arr中不存在的行为操作
     * 返回未被启动的行为
     * 主要用于创建行为操作.
     * @author ouyang
     */
    public function removeOperations($arr = null)
    {
        $operations = $this->getOperations();
        foreach($operations as $name=>$operation)
        {
            if(isset($arr)&&in_array($name, $arr))
            {
                unset ($arr[array_search($name ,$arr)]);
            }else
            {
                $auth = Yii::app()->getAuthManager();
                $auth->removeAuthItem($name);
            }         
        }
        return $arr;
    }

     /**
     * 指派授权行为.
     * @param <CAuthItem> $auth
     * @param array $assign
     */
    public function assign(CAuthItem $auth,$assign)
    {
        if(!isset($auth) || !isset($assign))
        {
            return;
        }
        foreach($assign as $name)
        {
            try
            {
                $auth->addChild($name);
            }
            catch (Exception $e)
            {
            // Yii RBAC authitem表的name字段的值不能重复，但本身又没提供一个检测重复的机制，所以此处抛出异常后不做任何处理
            }
        }  
    }

    /**
     *取消用户的权限
     * @param <string> $user ID
     * @param <array> $arr
     * @return array
     */

    public function removeUserAssign($user,$arr = null)
    {
        $auth = Yii::app()->authManager;
        $assigns = $auth->getAuthAssignments($user);
        foreach ($assigns as $assign)
        {
            $name = $assign->itemName;
            if(isset($arr)&&in_array($name, $arr))
            {
                unset ($arr[array_search($name ,$arr)]);
            }else
            {
                 $auth->revoke($name,$user);
            }
        }
        return $arr;
    }

    /**
     *$opeations 保存着N条M_C_A格式的字符串
     * 返回按M和C分类汇总的array('M'=>array('C'=>array('A")))
     * @param <array> $operations
     * @return <array>
     */

    public function buildList()
    {
        $operations = $this->getOperations();
        $list = array();
        foreach ($operations as $item)
        {
            $tmp = explode('_', $item->name);
            $list[$tmp[0]][$tmp[1]][] = $tmp[2];
        }
        return $list;
    }

}