<?php
class ChaptersAction extends BaseAction
{
    public function run()
    {
        $bookId = Yii::app()->request->getQuery('id');
        $criteria = $this->_buildCriteria(new CDbCriteria(array('condition'=>'bookid='.$bookId)));
        
        $dataProvider = new CActiveDataProvider('Chapters',array(
        	'pagination' => array(
        		'pageSize' => 20
        	),
        	'sort' => array(
        		'defaultOrder' => 'sort DESC',
        	),
        ));
        $dataProvider->setCriteria($criteria);
        
		$this->getController()->render('chapters', array(
			'dataProvider' => $dataProvider,
		));
    }
    
	/**
     * 根据url后面传递进来的参数获取一个查询条件
     * @param CDbCriteria $criteria
     * @return CDbCriteria
     */
    private function _buildCriteria(CDbCriteria $criteria)
    {
    	// 完善此功能
    	return Helper::buildCriteria($criteria, $_GET);
    }
}