<?php
/**
 * Descriptions
 * @author yzxh24
 * @email yzxh24@gmail.com
 * @created 2010-06-05 18:49:09
 */
class ListAction extends BaseAction
{
    public function run()
    {
    	$criteria = $this->_buildCriteria(new CDbCriteria(array('with'=>array('book','reply'=>array('joinType'=>'LEFT JOIN')))));
        //$criteria->select = 't.id,t.postid,t.subject,t.content,t.author,t.authorid,t.uid,t.username,t.createdate,t.bookid,reply.ispunish';
        //put your code here
        $dataProvider = new CActiveDataProvider('BookPostComplaint',array(
        	'pagination' => array(
        		'pageSize' => 20
        	),
        	'sort' => array(
        		'defaultOrder' => 't.id DESC',
        	),
        ));
        $dataProvider->setCriteria($criteria);
        
		$this->getController()->render('list', array(
			'dataProvider' => $dataProvider,
		));
    }
    
    /**
     * 根据url后面传递进来的参数获取一个查询条件
     * @param CDbCriteria $criteria
     * @return CDbCriteria
     */
    private function _buildCriteria(CDbCriteria $criteria)
    {
        $parmas = $_GET;
        if (isset($parmas['t-RangeStart_createdate']['value']))
        {
            $parmas['t-RangeStart_createdate']['value'] = strtotime($parmas['t-RangeStart_createdate']['value']);
        }

        if (isset($parmas['t-RangeEnd_createdate']['value']))
        {
            $parmas['t-RangeEnd_createdate']['value'] = strtotime($parmas['t-RangeEnd_createdate']['value']);
        }

        return Helper::buildCriteria($criteria, $parmas);
    }
}