<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ListAction
 *
 * @author yzxh24
 */
class ListAction extends BaseAction
{
    public function run()
    {
        $criteria = $this->_buildCriteria(new CDbCriteria(array('condition'=>'isfirst=1','with'=>array('book'))));
        $sort = new CSort('BookPostReplys');
		$sort->defaultOrder = 'id DESC';
        $sort->attributes = array(
            'id' => array('asc'=>'id','desc'=>'id DESC'),
            'createdate' => array('asc'=>'createdate','desc'=>'createdate DESC'),
            'lastreply' => array('asc'=>'lastreply','desc'=>'lastreply DESC'),
            'price' => array('asc'=>'price','desc'=>'price DESC'),
            'replycount' => array('asc'=>'replycount','desc'=>'replycount DESC'),
        );

		$sort->applyOrder($criteria);

        $dataProvider = new CActiveDataProvider('BookPostReplys',array('pagination' => array('pageSize' => 20)));
        $dataProvider->setCriteria($criteria);
        $dataProvider->setSort($sort);

		$this->getController()->render('list', array(
			'dataProvider' => $dataProvider,
		));
    }

    private function _buildCriteria(CDbCriteria $criteria)
    {
        $parmas = $_GET;
        if (isset($parmas['t-RangeStart_createdate']['value']))
        {
            $parmas['t-RangeStart_createdate']['value'] = strtotime($parmas['t-RangeStart_createdate']['value']);
        }

        if (isset($parmas['t-RangeEnd_createdate']['value']))
        {
            $parmas['t-RangeEnd_createdate']['value'] = strtotime($parmas['t-RangeEnd_createdate']['value']);
        }

        return Helper::buildCriteria($criteria, $parmas);
    }
}