<?php
/**
 * Descriptions
 * @author yzxh24
 * @email yzxh24@gmail.com
 * @created 2010-06-06 09:10:55
 */
class ListAction extends BaseAction
{
    public function run()
    {
    	$criteria = $this->_buildCriteria(new CDbCriteria());
        //put your code here
        $dataProvider = new CActiveDataProvider('BookVotes',array(
        	'pagination' => array(
        		'pageSize' => 20
        	),
        	'sort' => array(
        		'defaultOrder' => 'id DESC',
        	),
        ));
        $dataProvider->setCriteria($criteria);
        
		$this->getController()->render('list', array(
			'dataProvider' => $dataProvider,
		));
    }
    
    /**
     * 根据url后面传递进来的参数获取一个查询条件
     * @param CDbCriteria $criteria
     * @return CDbCriteria
     */
    private function _buildCriteria(CDbCriteria $criteria)
    {
        $parmas = $_GET;
        if (isset($parmas['t-RangeStart_createdate']['value']))
        {
            $parmas['t-RangeStart_createdate']['value'] = strtotime($parmas['t-RangeStart_createdate']['value']);
        }

        if (isset($parmas['t-RangeEnd_createdate']['value']))
        {
            $parmas['t-RangeEnd_createdate']['value'] = strtotime($parmas['t-RangeEnd_createdate']['value']);
        }

        return Helper::buildCriteria($criteria, $parmas);
    }
}