<?php
class SearchAction extends BaseAction
{
    public function run()
    {
        $bookName = trim(Yii::app()->request->getPost('bookname'));
        $spiderName = trim(Yii::app()->request->getPost('spider'));
        
        $book = Books::model()->find('bookname=:bookname',array(':bookname'=>$bookName));
        if (empty($book))
        {
            echo '站内不存在《'.$bookName.'》这本小说';
            Yii::app()->end();
        }
        
        $collect = Collects::model()->find('bookid=:bookid',array(':bookid'=>$book->bookid));
        if (empty($collect))
        {
            echo '此书没有采集信息，不能转换';
            Yii::app()->end();
        }
        
        $count = Chapters::model()->count('bookid=:bookid',array(':bookid'=>$book->bookid));
        $bookInfo = '小说名: '.$bookName.'<br/>小说ID: '.$book->bookid.'<br/>站内章节总数: '.$count;
        $bookInfo .= '<br/>采集目标站点: '.Front::getSpiderName($collect->spider).'<br/>采集记录总数: '.$collect->count;
        $bookInfo .= '<br/>站内最新章节: '.$book->lastchaptername.'<br/>最后更新时间: '.$book->updatedate;
        
        
        Front::spider();
        $url = Spider::search($spiderName, $bookName, $book->author);
        $siteName = Front::getSpiderName($spiderName);
        
        if (false === $url)
        {
            echo $bookInfo . '<br/><br/>目标站'.$siteName.'找不到此书';
            Yii::app()->end();
        }
        
        $spiderObj = Spider::factory($url,$spiderName);
        $spiderObj->getInfoFile();
        $listurl = $spiderObj->getChapterListUrl();
        $chapterurl = $spiderObj->getChapterList();
        foreach ($chapterurl as $key => $value)
        {
            if (!empty($key))
            {
                $sourceurls[] = $spiderObj->getChapterContentUrl($key);
            }
        }
        
        $sourceurlCount = count($sourceurls);
        $bookInfo .= '<br/><br/>目标站点: '.$siteName.'<br/>目标地址: ' . CHtml::link($url,$url,array('target'=>'_blank')) . '<br/>章节地址: '.CHtml::link($listurl, $listurl,array('target'=>'_blank')) . '<br/>目标章节数: '.$sourceurlCount;
        if (!empty($sourceurls))
        {
            $lastFive = array_splice($sourceurls, (count($sourceurlCount) - 6));
            if (!empty($lastFive))
            {
                foreach ($lastFive as $last)
                {
                    $content = $spiderObj->getChapterContent($last);
                    $chapterNames[] = $spiderObj->getChapterName($content);
                }
                $bookInfo .= "<br/>最后五章: <br/>" . implode("<br/>  ", $chapterNames);
            }
        }
        
        $bookInfo .= CHtml::hiddenField('bookid',$book->bookid);
        $bookInfo .= CHtml::hiddenField('spider',$spiderName);
        $bookInfo .= CHtml::hiddenField('listurl',$listurl);
        $bookInfo .= CHtml::hiddenField('detialurl',$url);
        $bookInfo .= CHtml::hiddenField('count',$sourceurlCount);
        $bookInfo .= '<br/><br/>补充数量: '.CHtml::textField('new', 0, array('size'=>4)).' '. CHtml::button('提交',array('onclick'=>'fetchNew();')) .' ' . CHtml::button('对应正确',array('onclick'=>'sync()'));
        echo $bookInfo;
        Yii::app()->end();
    }
}