<?php
class RewardAction extends BaseAction
{
    public function run()
    {
        $criteria = $this->_buildCriteria(new CDbCriteria(array('with'=>array('member', 'ruidremark'))));
        $dataProvider = new CActiveDataProvider('RewardFlux',array('pagination' => array('pageSize' => 100), 'sort'=>array('defaultOrder'=>'pv DESC')));
        $dataProvider->setCriteria($criteria);
        
        $dataSum = RewardFlux::dataSum($criteria);
        $this->getController()->render('reward', array(
			'dataProvider' => $dataProvider,
            'date' => $this->_getDate(),
            'dataSum' => $dataSum,
		));
    }
    
    private function _buildCriteria(CDbCriteria $criteria)
    {
        $parmas = $_GET;
        $parmas['date']['value'] = $this->_getDate();
        $parmas['date']['operate'] = 1;
        
        return Helper::buildCriteria($criteria, $parmas);
    }
    
    private function _getDate()
    {
        return isset($_GET['date']) && $_GET['date']['value'] != date('Y-m-d') ? $_GET['date']['value'] : date('Y-m-d', strtotime('-1 day'));
    }
}