<?php
class RewardWeekAction extends BaseAction
{
    public function run()
    {
        $date = isset($_GET['date']) ? $_GET['date']['value'] : date('Y-m-d', strtotime('-1 day'));
        $year = date('Y', strtotime($date));
        $week = date('W', strtotime($date));
        $range = Front::getWeekRange($week, $year);
        $dates = Front::getDates($range[0], $range[1]);
        $start = $dates[0];
        $end = $dates[1];
        $criteria = new CDbCriteria();
        $criteria->addBetweenCondition('date', $start, $end);
        $flux = RewardSum::model()->findAll($criteria);
        
        $this->getController()->render('rewardweek', array(
                'flux' => $flux,
                'start' => $start,
                'end' => $end,
            )
        );
    }
}