<?php
/**
 * 增加版块
 * @author yzxh24
 */
class AddForumAction extends BaseAction
{
    public function run()
    {
        $fup = Yii::app()->request->getQuery('fup');
        if (empty($fup))
        {
            throw new CHttpException(500, '获取不到上级版块ID');
        }
        
        $parentForum = Forum::model()->findByPk($fup);
        if (empty($parentForum))
        {
            throw new CHttpException(500, '不存在的父版块');
        }
        
        if (Yii::app()->request->isPostRequest)
        {
            $type = $parentForum->type == 'category' ? 'forum' : ($parentForum->type == 'forum' ? 'sub' : 'sub2');
            $forums = Helper::arrayFlipKeys($_POST['forum']);
            foreach ($forums as $key => $value)
            {
                if (!empty($value['name']))
                {
                    $forum = new Forum();
                    $forum->name = $value['name'];
                    $forum->keywords = $value['keywords'];
                    $forum->description = $value['description'];
                    $forum->type = $type;
                    $forum->fup = $fup;
                    $forum->forumadmin = !empty($value['forumadmin']) ? ','.trim($value['forumadmin']).',' : '';
                    $forum->save();
                }
            }
            
            $this->getController()->redirect(array('index'));
        }
        $this->getController()->render('addforum',array(
                'parent' => $parentForum,
            )
        );
    }
}