<?php
/**
 * 删除版块
 * @author yzxh24
 */
class DeleteAction extends BaseAction
{
    public function run()
    {
        $fid = intval(Yii::app()->request->getQuery('fid'));
        $criteria = new CDbCriteria();
        $criteria->addCondition('type <> :category');
        $criteria->addCondition('fup=:fid');
        $criteria->params = array(':category'=>'category',':fid'=>$fid);
        $count = Forum::model()->count($criteria);
        if (0 < $count)
        {
            throw new CHttpException(500, '当前版块下还有子版块，请先删除');
        }
        
        // 删除版块
        $forum = Forum::model()->findByPk($fid);
        $forum->delete();
        
        // 删除权限
        Permission::model()->deleteAll("fid<>0 AND fid={$fid}");
        // TODO 删除相关版块下的主题贴、回复、附件，然后取消当前版块下版主的权限
        
        $this->getController()->redirect(array('index'));
    }
}