<?php
/**
 * 修改版块
 * @author yzxh24
 */
class EditAction extends BaseAction
{
    public function run()
    {
        $fid = intval(Yii::app()->request->getQuery('fid'));
        $forum = Forum::model()->findByPk($fid);
        if (Yii::app()->request->isPostRequest)
        {
            $checkBoxs = array('allowvisit', 'allowread', 'allowpost', 'allowrp', 'allowdownload', 'allowupload');
            foreach ($_POST['forum'] as $key => $value)
            {
                if (in_array($key, array('forumset', 'creditset')))
                {
                    $forum->$key = serialize($value);
                }
                else if (in_array($key, $checkBoxs))
                {
                    $forum->$key = (empty($value)) ? '' : ','.implode(',', $value).',';
                }
                else
                {
                    $forum->$key = $value;
                }
            }
            //print_r($forum);die;
            // 处理checkbox
            foreach ($checkBoxs as $checkBox)
            {
                if (!array_key_exists($checkBox, $_POST['forum']))
                {
                    $forum->$checkBox = '';
                }
            }
            
            $forum->save();
            //Yii::app()->end();
            
            // 处理新分类
            /**/
            if (!empty($_POST['topictype']))
            {
                $types = Helper::arrayFlipKeys($_POST['topictype']);
                foreach ($types as $type)
                {
                    if (!empty($type['name']))
                    {
                        $topicType = new TopicTypes();
                        $topicType->fid = $fid;
                        $topicType->name = $type['name'];
                        $topicType->vieworder = $type['view'] ? intval($type['view']) : 0;
                        $topicType->save();
                    }
                }
            }
            /**/
            $this->getController()->redirect(array('edit','fid'=>$fid));
        }

        $userGroups = UserGroup::model()->findAll();
        $credits = Settings::model()->find("var='cfg_extcredits'");
        $forumTypes = TopicTypes::model()->findAll('fid='.$fid);
        
        $this->getController()->render('edit', array(
                'forum' => $forum,
                'groups' => $userGroups,
                'credits' => $credits->value,
                'forumTypes' => $forumTypes,
            )
        );
    }
}