<?php

class LabelController extends BackendController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction = 'index';
	
	/**
	 * @var CActiveRecord the currently loaded data model instance.
	 */
	private $_model;
	
	protected $actionPrefix = 'admin.controllers.Label.';
    
	protected $actionMap = array(
		'create' => 'CreateAction',
		'list' => 'ListAction',
        'update' => 'UpdateAction',
        'delete' => 'DeleteAction',
	);
	
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the primary key value. Defaults to null, meaning using the 'id' GET variable
	 */
	public function loadLabel($id = null)
	{
		if ($this->_model === null)
		{
			if ($id !== null || isset($_GET['id']))
			{
				$this->_model = Label::model()->findbyPk($id !== null ? $id : $_GET['id']);
			}
			if ($this->_model === null)
			{
				throw new CHttpException(404, 'The requested page does not exist.');
			}
		}
		return $this->_model;
	}
	
	/**
	 * Executes any command triggered on the admin page.
	 */
	protected function processAdminCommand()
	{
		if (isset($_POST['command'], $_POST['id']) && $_POST['command'] === 'delete')
		{
			$this->loadLabel($_POST['id'])->delete();
			$this->refresh();
		}
	}
}
