<?php
class AddItemAction extends BaseAction
{
    public function run()
    {
        if (Yii::app()->request->isPostRequest)
        {
            $post = Helper::arrayFlipKeys($_POST['medals']);
            if (!empty($post))
            {
                foreach ($post as $value)
                {
                    $medal = new Medal();
                    $medal->setAttributes($value);
                    $medal->available = (isset($value['available']) && !empty($value['available']) ? 1 : 0);
                    $file = $medal->getImageFile();
                    if (is_file($file))
                    {
                        $medal->save();
                    }
                }
            }
            
            $this->getController()->redirect(array('index'));
        }
        else
        {
            throw new CHttpException('非法操作');
        }
    }
}