<?php
class IndexAction extends BaseAction
{
    public function run()
    {
        $criteria = $this->_buildCriteria(new CDbCriteria(array('with'=>array('group'))));
        $members = array();
        
        $dataProvider = new CActiveDataProvider('Member',array('pagination' => array('pageSize' => 20),'sort'=>array('defaultOrder' => 'uid DESC')));
        $dataProvider->setCriteria($criteria);
        
        $groups = UserGroup::model()->findAll("gptype <> 'member' AND groupid NOT IN (1,2)");
        $this->getController()->render('index',array(
                'dataProvider' => $dataProvider,
                'groups' => $groups
            )
        );
    }
    
	/**
     * 根据url后面传递进来的参数获取一个查询条件
     * @param CDbCriteria $criteria
     * @return CDbCriteria
     */
    private function _buildCriteria(CDbCriteria $criteria)
    {
        $parmas = $_GET;
        if (isset($parmas['t-RangeStart_regdate']['value']))
        {
            $parmas['t-RangeStart_regdate']['value'] = strtotime($parmas['t-RangeStart_regdate']['value']);
        }

        if (isset($parmas['t-RangeEnd_regdate']['value']))
        {
            $parmas['t-RangeEnd_regdate']['value'] = strtotime($parmas['t-RangeEnd_regdate']['value']);
        }
        
    	return Helper::buildCriteria($criteria, $parmas);
    }
}