<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * 参与竞拍的用户列表
 *
 * @author yzxh24
 */
class JoinListAction extends BaseAction
{
    public function run()
    {
        $id = intval($_GET['id']);

        $sale = Sale::model()->findByPk($id);
        $criteria = new CDbCriteria();
        $criteria->addCondition('sale_id='.$id);
        $criteria->select = 'SUM(amount) AS userAmount,COUNT(1) AS count,uid,username';
        $criteria->group = 'uid';

        $sort = new CSort('SaleJoin');
		$sort->defaultOrder = 'id DESC';
        $sort->attributes = array(
            'uid' => array('asc'=>'uid','desc'=>'uid DESC'),
            'userAmount' => array('asc'=>'userAmount','desc'=>'userAmount DESC'),
            'count' => array('asc'=>'count','desc'=>'count DESC'),
        );
		$sort->applyOrder($criteria);
        
        $dataProvider = new CActiveDataProvider('SaleJoin',array(
        	'pagination' => array(
        		'pageSize' => 20
        	),
        	'sort' => array(
        		'defaultOrder' => 'id DESC',
        	),
        ));
        $dataProvider->setCriteria($criteria);
        $dataProvider->setSort($sort);

		$this->getController()->render('joinlist', array(
			'dataProvider' => $dataProvider,
            'sale' => $sale,
		));
    }
}
