<?php
/**
 * 添加新表情
 * @author yzxh24
 */
class AddItemAction extends BaseAction
{
    public function run()
    {
        if (Yii::app()->request->isPostRequest)
        {
            $new = $_POST['new'];
            $code = $_POST['code'];
            $id = intval($_GET['id']);
            $category = Smiles::model()->findByPk($id);
            
            if (empty($new))
            {
                throw new CHttpException(500, '请选择要添加的表情');
            }
            if (empty($code))
            {
                throw new CHttpException(500, '请填写相应的表情代码');
            }
            
            foreach ($new as $item)
            {
                if (key_exists($item, $code))
                {
                    $check = Smiles::model()->find('code=:code', array(':code'=>$code[$item]));
                    if (!empty($check))
                    {
                        throw new CHttpException(500, '图片'.$item.'的表情代码'.$code[$item].'已经存在，请换一个');
                    }
                    $smile = new Smiles();
                    $smile->type = $id;
                    $smile->path = $item;
                    $smile->code = $code[$item];
                    $smile->save();
                }
            }
            
            $this->getController()->redirect(array('/admin/smiles/list','id'=>$id));
        }
        else
        {
            throw new CHttpException(500, '非法操作');
        }
    }
}