<?php
/**
 * 表情分类内容
 * @author yzxh24
 */
class ListAction extends BaseAction
{
    public function run()
    {
        $id = intval(Yii::app()->request->getQuery('id'));
        
        $category = Smiles::model()->findByPk($id);
        $smiles = Smiles::model()->findAll(array('condition'=>'type='.$id,'order'=>'displayorder DESC'));
        $files = $others = array();
        if (!empty($smiles))
        {
            foreach ($smiles as $smile)
            {
                $files[] = $smile->path;
            }
        }
        
        $path = Smiles::model()->getSmilePath($category->path);
        $dir = new DirectoryIterator($path);
        foreach ($dir as $item)
        {
            if ($item->isFile() && 'gif' == CFileHelper::getExtension($item->getFilename()) && !in_array($item->getFilename(), $files))
            {
                $others[] = $item->getFilename();
            }
        }
        
        $this->getController()->render('list', array(
                'category' => $category,
                'smiles' => $smiles,
                'others' => $others,
            )
        );
    }
}