<?php
/**
 * Descriptions
 * @author yzxh24
 * @email yzxh24@gmail.com
 * @created 2011-10-08 15:55:29
 */
class SoftcontentController extends BackendController
{
    /**
     * 面包屑导航
     * @var array
     */
    public $breadcrumbs = array('软件列表'=>array('/admin/softcontent/list'));
    
    /**
     * action路径前缀
     */
	protected $actionPrefix = 'admin.controllers.SoftContent.';

    /**
     * action对应表
     */
    protected $actionMap = array(
        'list' => 'ListAction',
        'create' => 'CreateAction',
        'update' => 'UpdateAction',
        'delete' => 'DeleteAction',
        'view' => 'ViewAction',
        'copy' => 'CopyAction',
        'ajaxchangetype' => 'AjaxChangeTypeAction',
        'uploadimage' => 'UploadImageAction',
        'deleteimage' => 'DeleteImageAction',
    );

    public function loadModel()
    {
        $id = Yii::app()->request->getQuery('id');
        $model=SoftContent::model()->findByPk((int)$id);
		if($model===null)
        {
			throw new CHttpException(404,'The requested page does not exist.');
        }
        
		return $model;
    }
    
	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax'] === 'soft-content-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}