<?php
/**
 * 修改用户组的权限
 * @author yzxh24
 */
class PermissionAction extends BaseAction
{
    public function run()
    {
        $gid = Yii::app()->request->getQuery('gid');
        $group = UserGroup::model()->findByPk($gid);
        
        $criteria = new CDbCriteria();
        $criteria->addCondition('gid=:gid');
        $criteria->addCondition('type=:type');
        $criteria->params = array(':gid'=>$gid,':type'=>'systemforum');
        
        if (Yii::app()->request->isPostRequest)
        {
            $array = $_POST['p'];
            Permission::model()->deleteAll($criteria);
            
            // 处理checkbox
            $checkBoxs = array('editadminset','deladminset');
            foreach ($checkBoxs as $checkBox)
            {
                if (key_exists($checkBox,$array))
                {
                    $array[$checkBox] = implode(',',$array[$checkBox]);
                }
                else
                {
                    $array[$checkBox] = '';
                }
            }

            foreach ($array as $key => $value)
            {
                $item = new Permission();
                $item->gid = $gid;
                $item->uid = 0;
                $item->fid = 0;
                $item->rkey = $key;
                $item->rvalue = $value;
                $item->type = 'systemforum';
                $item->save();
            }
            $group->save();
            $this->getController()->redirect(array('index'));
        }
        
        $permission = array();
        $result = Permission::model()->findAll($criteria);
        if (!empty($result))
        {
            foreach ($result as $item)
            {
                $permission[$item->rkey] = $item->rvalue;
            }
        }
        else
        {
            $id = $group->gptype == 'system' && in_array($group->groupid, Front::getAdminGroup())? '00' : '0';
            $permission = UserGroup::getGroupCache($id);
        }
        
        $adminGroup = Front::getAdminGroup();
        $admin = UserGroup::model()->findAll(array('condition' => 'groupid IN ('.implode(',',$adminGroup).')'));
        $this->getController()->render('permission', array(
                'group' => $group,
        		'permission' => $permission,
                'admin' => $admin,
            )
        );
    }
}