<?php
/**
 * 登录Form
 * @author yzxh24
 */
class AdminLoginForm extends CFormModel
{
	public $username;
	public $password;

	public function rules()
    {
		return array(
			array('username, password', 'required'),
			array('password', 'authenticate'),
		);
	}

	public function attributeLabels()
    {
		return array(
			'username' => '用户名',
			'password' => '密码'
		);
	}

	/**
	 * 检查密码
	 */
	public function authenticate($attribute,$params)
    {
		if(!$this->hasErrors())
        {
			$identity = new ManagerIdentity($this->username, $this->password);
			$identity->authenticate();
			switch($identity->errorCode)
            {
				case CUserIdentity::ERROR_NONE:
					// 系统记录登录状态
					Yii::app()->adminUser->login($identity);
					break;
				case CUserIdentity::ERROR_USERNAME_INVALID:
					$this->addError('username','Username is incorrect.');
					break;
				default: // UserIdentity::ERROR_PASSWORD_INVALID
					$this->addError('password','Password is incorrect.');
					break;
			}
		}
	}
}
