<?php $this->widget('admin.widgets.TableCover');?>
<?php $this->renderPartial('_search');?>
<?php $this->widget('zii.widgets.grid.CGridView', array(
	'dataProvider'=>$dataProvider,
    'itemsCssClass' => 'widefat post',
    'summaryText'=>'显示{start}-{end}条 总共{count}条',
    'columns' => array(
        'bookid',
        array(
            'name' => 'bookname',
            'type' => 'raw',
            'value' => 'CHtml::link($data->bookname, array("/admin/chapters/list", "id"=>$data->bookid))'
        ),
        'author',
        array(
            'name' => 'type',
            'header' => '分类',
            'type' => 'raw',
            'htmlOptions' => array('class'=>'tName'),
            'value' => 'CHtml::link($data->types->typename, "", array("onclick" => "changeType($data->bookid, this);"))',
        ),
        'lastchaptername',
        'updatedate',
        'click',
        array(
            'name' => 'status',
            'type' => 'raw',
            'value' => 'CHtml::link($data->getStatus($data->status), "", array("onclick" => "changeStatus($data->bookid, this)"))',
        ),
        array(
            'name' => 'size',
            'value' => '$data->getSize($data->size)',
        ),
        array(
            'name' => 'view',
            'type' => 'raw',
            'value' => 'CHtml::link($data->getView($data->view), "", array("onclick" => "changeView($data->bookid, this)"))',
        ),
        array(
            'name' => 'nature',
            'value' => 'Books::$_nature[$data->nature]',
        ),
        array(
            'class'=>'CButtonColumn',
            'header' => '操作',
            'template' => '{update} {delete}'
        ),
    ),
));
?>

<script type="text/javascript">
function changeStatus(bookId, obj) {
	$.ajax({
		type: 'GET',
		url: '<?php echo Yii::app()->controller->createUrl('/admin/book/changestatus');?>',
		data: 'id='+ bookId,
		success: function(msg) {
			$(obj).parent().html(msg);
		}
	});
}

function changeType(bookId, obj) {
	$.ajax({
		type: 'GET',
		url: '<?php echo Yii::app()->controller->createUrl('/admin/book/changetype');?>',
		data: 'id='+bookId,
		success: function(html) {
			$(obj).parent().html(html);
		}
	});
}

function typeOnChange(bookId, obj) {
	var newType = $(obj).val();
	$.ajax({
		type: 'POST',
		url: '<?php echo Yii::app()->controller->createUrl('/admin/book/changetype');?>',
		data: 'id='+bookId+'&type='+newType,
		success: function(html) {
			$(obj).parent().html(html);
		}
	});
}

function changeView(bookId, obj) {
	$.ajax({
		type: 'GET',
		url: '<?php echo Yii::app()->controller->createUrl('/admin/book/changeview');?>',
		data: 'id='+ bookId,
		success: function(msg) {
			$(obj).parent().html(msg);
		}
	});
}
</script>