<?php $this->widget('admin.widgets.TableCover');?>
<h3>原创书籍列表</h3>
<?php $this->renderPartial('_search');?>
<?php $this->widget('zii.widgets.grid.CGridView', array(
	'dataProvider'=>$dataProvider,
    'itemsCssClass' => 'widefat post',
    'summaryText'=>'显示{start}-{end}条 总共{count}条',
    'columns' => array(
        'bookid',
        'bookname',
        'author',
        'uid' => array(
            'header' => 'UID',
            'value' => '$data->authors->uid',
        ),
        array(
            'name' => 'type',
            'header' => '分类',
            'value' => '$data->types->typename',
        ),
        'lastchaptername',
        'updatedate',
        array(
            'name' => 'status',
            'type' => 'raw',
            'value' => 'CHtml::link($data->getStatus($data->status), "", array("onclick" => "changeStatus($data->bookid, this)"))',
        ),
        array(
            'name' => 'size',
            'value' => '$data->getSize($data->size)',
        ),
        'favorites',
        'red',
        'black',
        array(
            'name' => 'nature',
            'value' => 'Books::$_nature[$data->nature]',
        ),
        array(
            'name' => 'isvip',
            'value' => '$data->isVip($data->isvip)',
        ),
        array(
            'name' => 'view',
            'type' => 'raw',
            'value' => 'CHtml::link($data->getView($data->view), "", array("onclick" => "changeView($data->bookid, this)"))',
        ),
        array(
            'class'=>'CButtonColumn',
            'header' => '操作',
            'template' => '{view}'
        ),
    ),
));
?>

<script type="text/javascript">
function changeStatus(bookId, obj) {
	$.ajax({
		type: 'GET',
		url: '<?php echo Yii::app()->controller->createUrl('/admin/book/changestatus');?>',
		data: 'id='+ bookId,
		success: function(msg) {
			$(obj).parent().html(msg);
		}
	});
}

function changeView(bookId, obj) {
	$.ajax({
		type: 'GET',
		url: '<?php echo Yii::app()->controller->createUrl('/admin/book/changeview');?>',
		data: 'id='+ bookId,
		success: function(msg) {
			$(obj).parent().html(msg);
		}
	});
}
</script>