<?php
Yii::import('zii.widgets.grid.CButtonColumn');

class UpdateButtonColumn extends CButtonColumn
{
    public $buttons = array(
        'update' => array(
            'label' => '修改',
            'url' => 'Yii::app()->controller->createUrl("/admin/chapters/update", array("id"=>$data->chapterid))',
            'type' => 'raw',
            'options' => array('class'=>'update'),
        ),
        'delete' => array(
            'label' => '删除',
            'url' => 'Yii::app()->controller->createUrl("/admin/chapters/delete",array("id"=>$data->chapterid))',
            'type' => 'raw',
        ),
    );
    
    protected function initDefaultButtons()
    {
        $confirmation = "if(!confirm(".CJavaScript::encode(Yii::t('zii','确定要删除吗?')).")) return false;";
        $this->buttons['delete']['click']=<<<EOD
function() {
	$confirmation
	$.fn.yiiGridView.update('{$this->grid->id}', {
		type:'POST',
		url:$(this).attr('href'),
		success:function() {
			$.fn.yiiGridView.update('{$this->grid->id}');
		}
	});
	return false;
}
EOD;
    }
}