<?php
Yii::app()->clientScript->registerScript('gii.crud',"
$('#CrudCode_controller').change(function(){
	$(this).data('changed',$(this).val()!='');
});
$('#CrudCode_model').bind('keyup change', function(){
	var controller=$('#CrudCode_controller');
	if(!controller.data('changed')) {
		var id=new String($(this).val().match(/\\w*$/));
		if(id.length>0)
			id=id.substring(0,1).toLowerCase()+id.substring(1);
		controller.val(id);
	}
});
");
?>


<?php $form=$this->beginWidget('application.modules.gii.iCodeForm', array('model'=>$model,'title'=>'CRUD工具')); ?>
	<div class="row">
		<?php echo $form->labelEx($model,'model'); ?>
		<?php echo $form->textField($model,'model',array('size'=>65)); ?>
		<div class="tooltip">
			Model class 区分大小写. 可以是一个类的名称 (如: <code>Post</code>)
            <br/>
		    或类文件的路径别名(如: <code>application.models.Post</code>)
            <br/>
		    注意:如果是前者，类必须被自动加载
		</div>
		<?php echo $form->error($model,'model'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'controller'); ?>
		<?php echo $form->textField($model,'controller',array('size'=>65)); ?>
		<div class="tooltip">
			<ul>
				<li><code>post</code> 生成 <code>PostController.php</code></li>
				<li><code>postTag</code> 生成 <code>PostTagController.php</code></li>
				<li><code>admin/user</code> 生成 <code>admin/UserController.php</code></li>
			</ul>
		</div>
		<?php echo $form->error($model,'controller'); ?>
	</div>

	<div class="row sticky">
		<?php echo $form->labelEx($model,'baseControllerClass'); ?>
		<?php echo $form->textField($model,'baseControllerClass',array('size'=>65)); ?>
		<div class="tooltip">
			CRUD controller 继承的父类
            <br/>
			注意:父类必须确实存在
		</div>
		<?php echo $form->error($model,'baseControllerClass'); ?>
	</div>

<?php $this->endWidget(); ?>