<?php
/**
 * 主要是将里面的一些英文翻译过来
 * 这样可以不用直接修改框架，方便之后升级
 * @author yzxh24
 */

class iCodeForm extends CActiveForm
{
    public $model;

    public $title;
    
	/**
	 * 重写方法进行翻译
	 */
	public function init()
	{
        $baseUrl = Yii::app()->baseUrl;
        echo <<<EOD
<link type="stylesheet" type="text/css" href="{$baseUrl}/js/admin/fancybox/jquery.fancybox-1.3.1.css" />
<script type="text/javascript" src="{$baseUrl}/js/admin/tools.tooltip-1.1.3.min.js"></script>
<script type="text/javascript" src="{$baseUrl}/js/admin/fancybox/jquery.fancybox-1.3.1.pack.js"></script>
<script type="text/javascript" src="{$baseUrl}/js/admin/main.js"></script>
<div class="form gii">
<fieldset>
    <legend>{$this->title}</legend>
	<p class="note">
		<span class="required">*</span> 为必填字段.
		点击<span class="sticky">高亮字段</span>进行编辑.
	</p>
EOD;
        parent::init();
	}

	/**
	 * Runs the widget.
	 */
	public function run()
	{
		$templates=array();
        foreach($this->model->getTemplates() as $i=>$template)
        {
            $templates[$i]=basename($template).' ('.$template.')';
        }
		

		$this->renderFile(Yii::getPathOfAlias('application.modules.gii.views.common.generator').'.php',array(
			'model'=>$this->model,
			'templates'=>$templates,
		));

        parent::run();
		echo "</fieldset></div>";
	}
}