<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * 侧边栏的基础类
 *
 * @author yzxh24
 */
class BaseLeftMenu extends CWidget
{
    public function run()
    {
        $this->header();
        $route = $this->getController()->route;

        // 将没有权限使用的侧边链接过滤掉
        $lists = $this->_checkAccess($this->_list);

        foreach ($lists as $list)
        {
            echo '<li class="'.$list['class'].'" id="'.$list['id'].'">';
            //echo '<div class="wp-menu-image">'.CHtml::link('<br/>',array('/'.$list['route'])).'</div>';
            echo '<div class="wp-menu-image"></div>';
            echo '<div class="wp-menu-toggle"><br /></div>';
            echo CHtml::link($list['name'],'#',array('class'=>$list['class']));
            //echo $list['name'];
            echo <<<EOT
            <div class='wp-submenu'>
      <div class='wp-submenu-head'>$list[name]</div>
      <ul>
EOT;
            // 发布时过滤掉gii相关链接
            $filter = array('生成CRUD','生成Model');
            if (is_array($list['submenu']['links']))
            {
                foreach ($list['submenu']['links'] as $link)
                {
                    if (!YII_DEBUG && in_array($link['name'], $filter))
                    {
                        continue;
                    }
                    echo '<li'.($route == $link['route'] ? ' class="current"' : '').'>'.CHtml::link($link['name'],array('/'.$link['route']),($route == $link['route'] ?array('class'=>'current') : '')).'</li>';
                }
                echo '</ul></div></li>';
            }
        }
        echo <<<EOT
<li class="wp-menu-separator-last"><a class="separator" href="?unfoldmenu=1"><br /></a></li></ul>
EOT;
    }

    /**
     * 登录进来的时候检查侧边栏的权限，将没有权限的链接过滤掉
     * 最终返回一个可运行的列表，然后存到一个叫BackendRBAC的session数组中
     * @param string $list
     * @return array|empty
     */
    private function _checkAccess($list)
    {
        $session = Yii::app()->getSession();
        if (isset($session['BackendRBAC']))
        {
            return $session['BackendRBAC'];
        }

        foreach ($list as &$value)
        {
            if (is_array($value['submenu']['links']))
            {
                foreach ($value['submenu']['links'] as $key => $link)
                {
                    $route = str_replace('/', '_', $link['route']);
                    if (!Yii::app()->adminUser->checkAccess($route))
                    {
                        unset($value['submenu']['links'][$key]);
                    }
                }
            }
        }

        // 再循环一次，将links为空的顶级目录也隐藏掉
        foreach ($list as $k => &$v)
        {
            if (empty($v['submenu']['links']))
            {
                unset($list[$k]);
            }
        }

        $session['BackendRBAC'] = $list;
        return $list;
    }

    /**
     * 输出菜单栏的头
     * @return void
     */
    protected function header()
    {
        $toggle = CHtml::link('控制板',array('/admin/default/index'),array('class'=>'wp-first-item menu-top menu-top-first menu-top-last','tabindex'=>1));
        echo <<<EOT
<ul id="adminmenu">
  <li class="wp-first-item menu-top menu-top-first menu-top-last" id="menu-dashboard">
    <div class='wp-menu-image'><a href='index.php'><br /></a></div>
    <div class="wp-menu-toggle"><br /></div>
    $toggle
</li>
<li class="wp-menu-separator"><a class="separator" href="?unfoldmenu=1"><br /></a></li>
EOT;
    }
}