<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
define('IN_IORANGE', true);
require 'include/init.php';

if (URL_REWRITE)
{
    $pathInfo = iRequest::getPathInfo();
    if (!empty($pathInfo))
    {
        if (preg_match('/type-(\d+)-(\d+)/s', $pathInfo, $match))
        {
            $_GET['tid'] = $match[1];
            $_GET['page'] = $match[2];
        }
        else if (preg_match('/type-(\d+)/s', $pathInfo, $match))
        {
            $_GET['tid'] = $match[1];
        }
    }
}

$params = $jumpParams = array();
$typeid = S::gp('tid', 'G', 2);
$typename = bookTypeName($typeid);

$isOriginal = $_GET['s'] == 1 ? true : false;

$typearray = get_type();

$sortKey = array(
    'favorites' => '收藏',
    'size' => '字数',
    'click' => '点击',
    'flower' => '鲜花',
    'egg' => '板砖',
    'over' => '全本'
);

$sort = empty($_GET['sort']) || !key_exists($_GET['sort'], $sortKey) ? 'createdate' : S::gp('sort', 'G');
foreach ($sortKey as $key => $value)
{
    if ($key == $sort)
    {
        $nav[] = $value;
    }
    else
    {
        $params = array('tid' => $typeid, 'sort' => $key);
        if ($isOriginal)
        {
            $params = array_merge($params, array('s'=>1));
        }
        $nav[] = ilink($value, url('booktype', $params));
    }
}
$navString = implode('.', $nav);

$jumpParams = array('tid' => $typeid);
$condition = "`typeid`='$typeid' AND `view` = 1";
if ($isOriginal)
{
    $condition .= ' AND type = 2';
    $jumpParams = array_merge($jumpParams, array('s'=>1));
}

switch ($_GET['sort'])
{
    case 'over':
        $sort = 'updatedate';
        $condition .= ' AND status = 1';
}

$pageSize = isWebRequest() ? 40 : 10;
$count = $db->getValue("SELECT COUNT(*) FROM ".Book::table()." WHERE {$condition}");
$pageObj = new iPage();
$pageObj->setPageSize($pageSize);
$pageObj->setTotalRecord($count);
$offset = $pageObj->getOffset();

$firstPageView = false;
$fields = 'bookid,bookname,bookinfo,`status`,author,size,lastchapterid,lastchaptername,updatedate';
if ($firstPageView && 'over' !== $_GET['sort'])
{
    $condition1 = $condition;
    $condition .= ' AND `type` = 2';
    $offset = 0;
}

$sql = "SELECT {$fields} FROM `".Book::table()."` WHERE {$condition} ORDER BY $sort DESC ".S::sqlLimit($pageObj->getOffset(),$pageObj->getPageSize());
$array = $db->setQueryString($sql)->find();
if (!empty($array))
{
    if ($firstPageView && $pageObj->getPageSize() > $count = count($array))
    {
        $addCount = $pageObj->getPageSize() - $count;
        $notIn = array();
        foreach ($array as $value)
        {
            $notIn[] = $value['bookid'];
        }
        $addSql = "SELECT $fields FROM ".Book::table()." WHERE {$condition1} AND bookid NOT IN (".implode(',', $notIn).") ORDER BY {$sort} DESC ".S::sqlLimit($count, $addCount);
        $addArray = $db->setQueryString($addSql)->find();
        if (!empty($addArray))
        {
            $array = array_merge($array, $addArray);
        }
    }
    
    foreach ($array as &$book)
    {
        $book['bookinfo'] = preg_replace('/\s/i', '', preg_replace("/\n/i", '', preg_replace("/　/i", '', $book['bookinfo'])));
        $book['bookinfo'] = iSubstr($book['bookinfo'], 0, 40, '...');
    }
}
$floor = $pageObj->getFloor();

include_once tpl('booktype');