<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class Cache
{
    static $_selfObj = null;

    protected $_cacheObj;

    static $_core = array('File', 'Memcache');

    private function __construct($cacheConfig)
    {
        $class = 'Cache' . $cacheConfig['core'];
        require_once 'cache/'.$cacheConfig['core'] . '.php';

        $this->_cacheObj = new $class($cacheConfig);
    }

    static public function getSingleton($cacheConfig)
    {
        if (empty($cacheConfig))
        {
            throw new CacheException('缓存类设置选项为空');
        }

        if (empty($cacheConfig['core']) || !in_array($cacheConfig['core'], self::$_core))
        {
            throw new CacheException('缓存类模块为空');
        }

        if (is_null(self::$_selfObj))
        {
            self::$_selfObj = new self($cacheConfig);
        }

        return self::$_selfObj;
    }

    public function get($key)
    {
        return $this->_cacheObj->get($key);
    }

    public function set($key, $data, $expire = 300)
    {
        $this->_cacheObj->set($key, $data, $expire);
    }

    public function remove($key)
    {
        $this->_cacheObj->remove($key);
    }
}
class CacheException extends Exception {}