<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
require_once 'Abstract.php';
class CacheMemcache extends CacheAbstract
{
    protected $_defaultConfig = array(
        'host' => 'localhost',
        'port' => '11211',
        'expire' => 300
    );

    private $_memcacheObj = null;

    public function __construct($cacheConfig)
    {
        if (!extension_loaded('memcache'))
        {
            throw new CacheException('服务器没有加载Memcache扩展');
        }

        if (empty($cacheConfig) || !is_array($cacheConfig))
        {
            throw new CacheException('Memcache配置选项错误');
        }

        $this->_defaultConfig = array_merge($this->_defaultConfig, $cacheConfig);
        $this->_memcacheObj = new Memcache();
        if ($this->_memcacheObj->connect($this->_defaultConfig['host']) == false)
        {
            throw new CacheException('Memcache服务器连接失败');
        }
    }

    /**
     * 禁止对象被克隆
     * @return void
     */
    private function __clone()
    {
        throw new CacheException('禁止克隆');
    }

    /**
     * 取得缓存数据
     * @param string $key
     * @return mix
     */
    public function get($key)
    {
        return $this->_memcacheObj->get($key);
    }

    /**
     * 设置缓存数据
     * @param string $key
     * @param mix $data
     * @param int $expire
     * @return mix
     */
    public function set($key, $data, $expire = 300)
    {
        if (empty($key))
        {
            throw new CacheException('请设置缓存KEY');
        }

        $this->_memcacheObj->set($key, $data, $expire);
    }

    /**
     * 删除缓存
     * @param string $key
     * @return void
     */
    public function remove($key)
    {
        $this->_memcacheObj->delete($key);
    }
}