/*
 Navicat Premium Data Transfer

 Source Server Type    : MySQL
 Source Server Version : 50144

 Target Server Type    : MySQL
 Target Server Version : 50144
 File Encoding         : utf-8

 Date: 02/14/2012 12:27:24 PM
*/

SET NAMES utf8;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
--  Table structure for `ig_ad`
-- ----------------------------
DROP TABLE IF EXISTS `ig_ad`;
CREATE TABLE `ig_ad` (
  `adid` int(11) NOT NULL AUTO_INCREMENT,
  `title` char(255) NOT NULL,
  `url` char(255) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `day` int(11) NOT NULL DEFAULT '0',
  `day_valid` int(10) NOT NULL DEFAULT '0',
  `createdate` datetime NOT NULL,
  `quota` int(10) NOT NULL DEFAULT '0' COMMENT,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `isrand` tinyint(1) NOT NULL DEFAULT '1',
  `spaces` enum('index','show','read','chapter','forum','bbs','member','other') NOT NULL DEFAULT 'other',
  PRIMARY KEY (`adid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_adflux`
-- ----------------------------
DROP TABLE IF EXISTS `ig_adflux`;
CREATE TABLE `ig_adflux` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `adid` int(10) NOT NULL,
  `click` int(10) NOT NULL DEFAULT '0',
  `valid_click` int(10) NOT NULL,
  `u_click` int(10) NOT NULL DEFAULT '0',
  `u_valid_click` int(10) NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_adfluxsum`
-- ----------------------------
DROP TABLE IF EXISTS `ig_adfluxsum`;
CREATE TABLE `ig_adfluxsum` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `click` int(10) NOT NULL DEFAULT '0',
  `valid_click` int(10) NOT NULL DEFAULT '0',
  `u_click` int(10) NOT NULL DEFAULT '0',
  `u_valid_click` int(10) NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `month` varchar(2) NOT NULL,
  `type` tinyint(2) NOT NULL DEFAULT '4',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_adip`
-- ----------------------------
DROP TABLE IF EXISTS `ig_adip`;
CREATE TABLE `ig_adip` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ip` char(15) NOT NULL,
  `sid` char(12) NOT NULL,
  `createdate` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_adlog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_adlog`;
CREATE TABLE `ig_adlog` (
  `adlogid` int(11) NOT NULL AUTO_INCREMENT,
  `adid` int(11) NOT NULL,
  `ip` char(16) DEFAULT NULL,
  `date` date NOT NULL,
  `space` varchar(20) NOT NULL DEFAULT '',
  `valid` tinyint(1) NOT NULL DEFAULT '1',
  `uid` int(10) NOT NULL DEFAULT '0',
  `ruid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`adlogid`),
  KEY `ip` (`ip`),
  KEY `adid` (`adid`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_admin`
-- ----------------------------
DROP TABLE IF EXISTS `ig_admin`;
CREATE TABLE `ig_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `password` varchar(32) NOT NULL,
  `email` varchar(70) DEFAULT NULL,
  `createdate` datetime NOT NULL,
  `updatedate` datetime NOT NULL,
  `login_ip` varchar(15) NOT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1' ,
  `remark` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `ig_admin`
-- ----------------------------
BEGIN;
INSERT INTO `ig_admin` VALUES ('1', 'admin', 'e10adc3949ba59abbe56e057f20f883e', 'yzxh24@gmail.com', '2010-07-18 19:20:24', '2010-07-18 19:20:27', '', '0', '1', null), ('2', 'test', 'e10adc3949ba59abbe56e057f20f883e', null, '2010-07-18 19:24:25', '0000-00-00 00:00:00', '', '0', '1', '测试帐号');
COMMIT;

-- ----------------------------
--  Table structure for `ig_adspaceflux`
-- ----------------------------
DROP TABLE IF EXISTS `ig_adspaceflux`;
CREATE TABLE `ig_adspaceflux` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `space` varchar(20) NOT NULL DEFAULT '' ,
  `click` int(10) NOT NULL DEFAULT '0',
  `valid_click` int(10) NOT NULL,
  `u_click` int(10) NOT NULL DEFAULT '0',
  `u_valid_click` int(10) NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_adtmp`
-- ----------------------------
DROP TABLE IF EXISTS `ig_adtmp`;
CREATE TABLE `ig_adtmp` (
  `ads_tmp_id` int(11) NOT NULL AUTO_INCREMENT,
  `valid_key` char(20) NOT NULL,
  `uid` int(11) NOT NULL,
  `point` int(2) NOT NULL,
  `createdate` datetime NOT NULL,
  PRIMARY KEY (`ads_tmp_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_applywriter`
-- ----------------------------
DROP TABLE IF EXISTS `ig_applywriter`;
CREATE TABLE `ig_applywriter` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `username` char(16) NOT NULL,
  `content` text NOT NULL,
  `size` int(10) NOT NULL DEFAULT '0',
  `createdate` datetime NOT NULL,
  `updatedate` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0' ,
  `done` tinyint(1) NOT NULL DEFAULT '0' ,
  `remark` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_attachbuy`
-- ----------------------------
DROP TABLE IF EXISTS `ig_attachbuy`;
CREATE TABLE `ig_attachbuy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `aid` int(10) NOT NULL,
  `ctype` enum('1','2','3','4','5','6','7','8') NOT NULL DEFAULT '1' ,
  `amount` smallint(5) NOT NULL,
  `createdate` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `thread` (`uid`,`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_attachdownload`
-- ----------------------------
DROP TABLE IF EXISTS `ig_attachdownload`;
CREATE TABLE `ig_attachdownload` (
  `aid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `date` date NOT NULL,
  UNIQUE KEY `unique` (`aid`,`uid`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Table structure for `ig_attachment`
-- ----------------------------
DROP TABLE IF EXISTS `ig_attachment`;
CREATE TABLE `ig_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tid` int(10) NOT NULL,
  `pid` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL,
  `price` smallint(6) NOT NULL DEFAULT '0',
  `subject` varchar(100) NOT NULL ,
  `filename` varchar(100) NOT NULL DEFAULT '' ,
  `attachname` varchar(100) NOT NULL ,
  `remark` varchar(100) NOT NULL,
  `createdate` int(10) NOT NULL,
  `isimage` tinyint(1) NOT NULL DEFAULT '0' ,
  `isthumb` tinyint(1) NOT NULL DEFAULT '0' ,
  `downloads` mediumint(8) NOT NULL DEFAULT '0',
  `filetype` varchar(50) NOT NULL DEFAULT '',
  `filesize` int(10) NOT NULL DEFAULT '0',
  `isremote` tinyint(1) NOT NULL DEFAULT '0' ,
  `date` date NOT NULL,
  `isdelete` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_auth_assignment`
-- ----------------------------
DROP TABLE IF EXISTS `ig_auth_assignment`;
CREATE TABLE `ig_auth_assignment` (
  `itemname` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `userid` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bizrule` text COLLATE utf8_unicode_ci,
  `data` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`itemname`,`userid`),
  CONSTRAINT `ig_auth_assignment_ibfk_1` FOREIGN KEY (`itemname`) REFERENCES `ig_auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

-- ----------------------------
--  Records of `ig_auth_assignment`
-- ----------------------------
BEGIN;
INSERT INTO `ig_auth_assignment` VALUES ('admin', 'admin', null, 'N;'), ('admin', 'yzxh24', null, 'N;'), ('Nav', 'xiaoxia', null, 'N;');
COMMIT;

-- ----------------------------
--  Table structure for `ig_auth_item`
-- ----------------------------
DROP TABLE IF EXISTS `ig_auth_item`;
CREATE TABLE `ig_auth_item` (
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(11) NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `bizrule` text COLLATE utf8_unicode_ci,
  `data` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

-- ----------------------------
--  Records of `ig_auth_item`
-- ----------------------------
BEGIN;
INSERT INTO `ig_auth_item` VALUES ('admin', '2', '超级管理员角色，拥有后台最高权限', '', 'N;'), ('admin_ad_ads', '0', '', null, 'N;'), ('admin_ad_create', '0', '', null, 'N;'), ('admin_ad_delete', '0', '', null, 'N;'), ('admin_ad_detail', '0', '', null, 'N;'), ('admin_ad_list', '0', '', null, 'N;'), ('admin_ad_update', '0', '', null, 'N;'), ('admin_applybm_list', '0', '', null, 'N;'), ('admin_author_assignuser', '0', '', null, 'N;'), ('admin_author_authorityassign', '0', '', null, 'N;'), ('admin_author_createoperation', '0', '', null, 'N;'), ('admin_author_createrole', '0', '', null, 'N;'), ('admin_author_listdepartments', '0', '', null, 'N;'), ('admin_author_listoperations', '0', '', null, 'N;'), ('admin_author_listroles', '0', '', null, 'N;'), ('admin_author_listusers', '0', '', null, 'N;'), ('admin_author_roleaddchild', '0', '', null, 'N;'), ('admin_author_roleassign', '0', '', null, 'N;'), ('admin_author_taskaddchild', '0', '', null, 'N;'), ('admin_author_taskassign', '0', '', null, 'N;'), ('admin_author_userassign', '0', '', null, 'N;'), ('admin_book_create', '0', '', null, 'N;'), ('admin_book_delete', '0', '', null, 'N;'), ('admin_book_list', '0', '', null, 'N;'), ('admin_book_update', '0', '', null, 'N;'), ('admin_book_view', '0', '', null, 'N;'), ('admin_bookgaglog_list', '0', '', null, 'N;'), ('admin_bookpostcomplaints_award', '0', '', null, 'N;'), ('admin_bookpostcomplaints_create', '0', '', null, 'N;'), ('admin_bookpostcomplaints_delete', '0', '', null, 'N;'), ('admin_bookpostcomplaints_list', '0', '', null, 'N;'), ('admin_bookpostcomplaints_update', '0', '', null, 'N;'), ('admin_bookpostcomplaints_view', '0', '', null, 'N;'), ('admin_bookpostreply_delete', '0', '', null, 'N;'), ('admin_bookpostreply_list', '0', '', null, 'N;'), ('admin_bookpostreply_punish', '0', '', null, 'N;'), ('admin_bookpostreply_view', '0', '', null, 'N;'), ('admin_bookvote_create', '0', '', null, 'N;'), ('admin_bookvote_delete', '0', '', null, 'N;'), ('admin_bookvote_list', '0', '', null, 'N;'), ('admin_bookvote_update', '0', '', null, 'N;'), ('admin_bookvote_view', '0', '', null, 'N;'), ('admin_chapters_createbyid', '0', '', null, 'N;'), ('admin_chapters_createbytime', '0', '', null, 'N;'), ('admin_chapters_html', '0', '', null, 'N;'), ('admin_default_index', '0', '', null, 'N;'), ('admin_default_login', '0', '', null, 'N;'), ('admin_default_logout', '0', '', null, 'N;'), ('admin_flux_index', '0', '', null, 'N;'), ('admin_flux_timesharing', '0', '', null, 'N;'), ('admin_forums_addcategory', '0', '', null, 'N;'), ('admin_forums_addforum', '0', '', null, 'N;'), ('admin_forums_delete', '0', '', null, 'N;'), ('admin_forums_edit', '0', '', null, 'N;'), ('admin_forums_editforumadmin', '0', '', null, 'N;'), ('admin_forums_editname', '0', '', null, 'N;'), ('admin_forums_editorder', '0', '', null, 'N;'), ('admin_forums_index', '0', '', null, 'N;'), ('admin_label_create', '0', '', null, 'N;'), ('admin_label_default', '0', '', null, 'N;'), ('admin_label_delete', '0', '', null, 'N;'), ('admin_label_list', '0', '', null, 'N;'), ('admin_label_update', '0', '', null, 'N;'), ('admin_manager_create', '0', '', null, 'N;'), ('admin_manager_delete', '0', '', null, 'N;'), ('admin_manager_list', '0', '', null, 'N;'), ('admin_manager_resetpassword', '0', '', null, 'N;'), ('admin_manager_update', '0', '', null, 'N;'), ('admin_member_index', '0', '', null, 'N;'), ('admin_navlinks_create', '0', '', null, 'N;'), ('admin_navlinks_delete', '0', '', null, 'N;'), ('admin_navlinks_list', '0', '', null, 'N;'), ('admin_navlinks_update', '0', '', null, 'N;'), ('admin_navlinks_view', '0', '', null, 'N;'), ('admin_navpage_create', '0', '', null, 'N;'), ('admin_navpage_delete', '0', '', null, 'N;'), ('admin_navpage_list', '0', '', null, 'N;'), ('admin_navpage_update', '0', '', null, 'N;'), ('admin_navtype_create', '0', '', null, 'N;'), ('admin_navtype_delete', '0', '', null, 'N;'), ('admin_navtype_list', '0', '', null, 'N;'), ('admin_navtype_update', '0', '', null, 'N;'), ('admin_navtype_view', '0', '', null, 'N;'), ('admin_news_create', '0', '', null, 'N;'), ('admin_news_list', '0', '', null, 'N;'), ('admin_original_list', '0', '', null, 'N;'), ('admin_pmlink_create', '0', '', null, 'N;'), ('admin_pmlink_delete', '0', '', null, 'N;'), ('admin_pmlink_list', '0', '', null, 'N;'), ('admin_pmlink_update', '0', '', null, 'N;'), ('admin_sale_complete', '0', '', null, 'N;'), ('admin_sale_create', '0', '', null, 'N;'), ('admin_sale_delete', '0', '', null, 'N;'), ('admin_sale_joinlist', '0', '', null, 'N;'), ('admin_sale_list', '0', '', null, 'N;'), ('admin_sale_update', '0', '', null, 'N;'), ('admin_sale_view', '0', '', null, 'N;'), ('admin_settings_index', '0', '', null, 'N;'), ('admin_smiles_addcategory', '0', '', null, 'N;'), ('admin_smiles_additem', '0', '', null, 'N;'), ('admin_smiles_deleteitem', '0', '', null, 'N;'), ('admin_smiles_editcode', '0', '', null, 'N;'), ('admin_smiles_editdisplayorder', '0', '', null, 'N;'), ('admin_smiles_index', '0', '', null, 'N;'), ('admin_smiles_list', '0', '', null, 'N;'), ('admin_usergroups_create', '0', '', null, 'N;'), ('admin_usergroups_delete', '0', '', null, 'N;'), ('admin_usergroups_index', '0', '', null, 'N;'), ('admin_usergroups_member', '0', '', null, 'N;'), ('admin_usergroups_permission', '0', '', null, 'N;'), ('admin_vote_create', '0', '', null, 'N;'), ('admin_vote_delete', '0', '', null, 'N;'), ('admin_vote_deloption', '0', '', null, 'N;'), ('admin_vote_list', '0', '', null, 'N;'), ('admin_vote_update', '0', '', null, 'N;'), ('admin_worldcup2010_create', '0', '', null, 'N;'), ('admin_worldcup2010_delete', '0', '', null, 'N;'), ('admin_worldcup2010_list', '0', '', null, 'N;'), ('admin_worldcup2010_update', '0', '', null, 'N;'), ('admin_worldcup2010_view', '0', '', null, 'N;'), ('admin_worldcup2010comment_create', '0', '', null, 'N;'), ('admin_worldcup2010comment_delete', '0', '', null, 'N;'), ('admin_worldcup2010comment_list', '0', '', null, 'N;'), ('admin_worldcup2010comment_update', '0', '', null, 'N;'), ('admin_worldcup2010comment_view', '0', '', null, 'N;'), ('admin_worldcup2010option_create', '0', '', null, 'N;'), ('admin_worldcup2010option_delete', '0', '', null, 'N;'), ('admin_worldcup2010option_list', '0', '', null, 'N;'), ('admin_worldcup2010option_update', '0', '', null, 'N;'), ('admin_worldcup2010option_view', '0', '', null, 'N;'), ('Guest', '2', '匿名角色，用来登录', '', 'N;'), ('Nav', '2', '导航站推广', '', 'N;');
COMMIT;

-- ----------------------------
--  Table structure for `ig_auth_item_child`
-- ----------------------------
DROP TABLE IF EXISTS `ig_auth_item_child`;
CREATE TABLE `ig_auth_item_child` (
  `parent` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `child` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`parent`,`child`),
  KEY `child` (`child`),
  CONSTRAINT `ig_auth_item_child_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `ig_auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ig_auth_item_child_ibfk_2` FOREIGN KEY (`child`) REFERENCES `ig_auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

-- ----------------------------
--  Records of `ig_auth_item_child`
-- ----------------------------
BEGIN;
INSERT INTO `ig_auth_item_child` VALUES ('admin', 'admin_ad_ads'), ('admin', 'admin_ad_create'), ('admin', 'admin_ad_delete'), ('admin', 'admin_ad_detail'), ('admin', 'admin_ad_list'), ('admin', 'admin_ad_update'), ('admin', 'admin_applybm_list'), ('admin', 'admin_author_assignuser'), ('admin', 'admin_author_authorityassign'), ('admin', 'admin_author_createoperation'), ('admin', 'admin_author_createrole'), ('admin', 'admin_author_listdepartments'), ('admin', 'admin_author_listoperations'), ('admin', 'admin_author_listroles'), ('admin', 'admin_author_listusers'), ('admin', 'admin_author_roleaddchild'), ('admin', 'admin_author_roleassign'), ('admin', 'admin_author_taskaddchild'), ('admin', 'admin_author_taskassign'), ('admin', 'admin_author_userassign'), ('admin', 'admin_book_create'), ('admin', 'admin_book_delete'), ('admin', 'admin_book_list'), ('admin', 'admin_book_update'), ('admin', 'admin_book_view'), ('admin', 'admin_bookgaglog_list'), ('admin', 'admin_bookpostcomplaints_award'), ('admin', 'admin_bookpostcomplaints_create'), ('admin', 'admin_bookpostcomplaints_delete'), ('admin', 'admin_bookpostcomplaints_list'), ('admin', 'admin_bookpostcomplaints_update'), ('admin', 'admin_bookpostcomplaints_view'), ('admin', 'admin_bookpostreply_delete'), ('admin', 'admin_bookpostreply_list'), ('admin', 'admin_bookpostreply_punish'), ('admin', 'admin_bookpostreply_view'), ('admin', 'admin_bookvote_create'), ('admin', 'admin_bookvote_delete'), ('admin', 'admin_bookvote_list'), ('admin', 'admin_bookvote_update'), ('admin', 'admin_bookvote_view'), ('admin', 'admin_chapters_createbyid'), ('admin', 'admin_chapters_createbytime'), ('admin', 'admin_chapters_html'), ('admin', 'admin_default_index'), ('Nav', 'admin_default_index'), ('admin', 'admin_default_login'), ('Guest', 'admin_default_login'), ('Nav', 'admin_default_login'), ('admin', 'admin_default_logout'), ('Nav', 'admin_default_logout'), ('admin', 'admin_flux_index'), ('admin', 'admin_flux_timesharing'), ('admin', 'admin_forums_addcategory'), ('admin', 'admin_forums_addforum'), ('admin', 'admin_forums_delete'), ('admin', 'admin_forums_edit'), ('admin', 'admin_forums_editforumadmin'), ('admin', 'admin_forums_editname'), ('admin', 'admin_forums_editorder'), ('admin', 'admin_forums_index'), ('admin', 'admin_label_create'), ('admin', 'admin_label_default'), ('admin', 'admin_label_delete'), ('admin', 'admin_label_list'), ('admin', 'admin_label_update'), ('admin', 'admin_manager_create'), ('admin', 'admin_manager_delete'), ('admin', 'admin_manager_list'), ('admin', 'admin_manager_resetpassword'), ('admin', 'admin_manager_update'), ('admin', 'admin_member_index'), ('admin', 'admin_navlinks_create'), ('Nav', 'admin_navlinks_create'), ('admin', 'admin_navlinks_delete'), ('Nav', 'admin_navlinks_delete'), ('admin', 'admin_navlinks_list'), ('Nav', 'admin_navlinks_list'), ('admin', 'admin_navlinks_update'), ('Nav', 'admin_navlinks_update'), ('admin', 'admin_navlinks_view'), ('Nav', 'admin_navlinks_view'), ('admin', 'admin_navpage_create'), ('Nav', 'admin_navpage_create'), ('admin', 'admin_navpage_delete'), ('Nav', 'admin_navpage_delete'), ('admin', 'admin_navpage_list'), ('Nav', 'admin_navpage_list'), ('admin', 'admin_navpage_update'), ('Nav', 'admin_navpage_update'), ('admin', 'admin_navtype_create'), ('Nav', 'admin_navtype_create'), ('admin', 'admin_navtype_delete'), ('Nav', 'admin_navtype_delete'), ('admin', 'admin_navtype_list'), ('Nav', 'admin_navtype_list'), ('admin', 'admin_navtype_update'), ('Nav', 'admin_navtype_update'), ('admin', 'admin_navtype_view'), ('Nav', 'admin_navtype_view'), ('admin', 'admin_news_create'), ('admin', 'admin_news_list'), ('admin', 'admin_original_list'), ('admin', 'admin_pmlink_create'), ('admin', 'admin_pmlink_delete'), ('admin', 'admin_pmlink_list'), ('admin', 'admin_pmlink_update'), ('admin', 'admin_sale_complete'), ('admin', 'admin_sale_create'), ('admin', 'admin_sale_delete'), ('admin', 'admin_sale_joinlist'), ('admin', 'admin_sale_list'), ('admin', 'admin_sale_update'), ('admin', 'admin_sale_view'), ('admin', 'admin_settings_index'), ('admin', 'admin_smiles_addcategory'), ('admin', 'admin_smiles_additem'), ('admin', 'admin_smiles_deleteitem'), ('admin', 'admin_smiles_editcode'), ('admin', 'admin_smiles_editdisplayorder'), ('admin', 'admin_smiles_index'), ('admin', 'admin_smiles_list'), ('admin', 'admin_usergroups_create'), ('admin', 'admin_usergroups_delete'), ('admin', 'admin_usergroups_index'), ('admin', 'admin_usergroups_member'), ('admin', 'admin_usergroups_permission'), ('admin', 'admin_vote_create'), ('admin', 'admin_vote_delete'), ('admin', 'admin_vote_deloption'), ('admin', 'admin_vote_list'), ('admin', 'admin_vote_update'), ('admin', 'admin_worldcup2010_create'), ('admin', 'admin_worldcup2010_delete'), ('admin', 'admin_worldcup2010_list'), ('admin', 'admin_worldcup2010_update'), ('admin', 'admin_worldcup2010_view'), ('admin', 'admin_worldcup2010comment_create'), ('admin', 'admin_worldcup2010comment_delete'), ('admin', 'admin_worldcup2010comment_list'), ('admin', 'admin_worldcup2010comment_update'), ('admin', 'admin_worldcup2010comment_view'), ('admin', 'admin_worldcup2010option_create'), ('admin', 'admin_worldcup2010option_delete'), ('admin', 'admin_worldcup2010option_list'), ('admin', 'admin_worldcup2010option_update'), ('admin', 'admin_worldcup2010option_view');
COMMIT;

-- ----------------------------
--  Table structure for `ig_author`
-- ----------------------------
DROP TABLE IF EXISTS `ig_author`;
CREATE TABLE `ig_author` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` char(16) NOT NULL,
  `uid` int(10) DEFAULT NULL,
  `createdate` datetime NOT NULL,
  `updatedate` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0' ,
  `remark` mediumtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_banuser`
-- ----------------------------
DROP TABLE IF EXISTS `ig_banuser`;
CREATE TABLE `ig_banuser` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `fid` smallint(5) NOT NULL DEFAULT '0' ,
  `bid` int(10) NOT NULL DEFAULT '0' ,
  `type` enum('visit','post') NOT NULL DEFAULT 'post',
  `startdate` int(10) NOT NULL,
  `days` smallint(4) NOT NULL DEFAULT '0',
  `operator_id` int(10) NOT NULL,
  `reason` varchar(100) NOT NULL ,
  `module` enum('all','bbs','forum') NOT NULL DEFAULT 'bbs' ,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bbsinfo`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bbsinfo`;
CREATE TABLE `ig_bbsinfo` (
  `id` smallint(3) NOT NULL AUTO_INCREMENT,
  `newmember` varchar(100) NOT NULL DEFAULT '' ,
  `totalmember` int(10) NOT NULL DEFAULT '0' ,
  `higholnum` int(10) NOT NULL DEFAULT '0' ,
  `higholtime` int(10) NOT NULL DEFAULT '0' ,
  `yposts` mediumint(8) NOT NULL DEFAULT '0',
  `hposts` mediumint(8) NOT NULL DEFAULT '0' ,
  `posts` int(10) NOT NULL DEFAULT '0' ,
  `tposts` int(11) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `ig_bbsinfo`
-- ----------------------------
BEGIN;
INSERT INTO `ig_bbsinfo` VALUES ('1', 'iusdu913	363794', '204614', '0', '0', '0', '136', '82307', '136');
COMMIT;

-- ----------------------------
--  Table structure for `ig_bcart`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bcart`;
CREATE TABLE `ig_bcart` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `subject` varchar(200) NOT NULL DEFAULT '',
  `description` text NOT NULL ,
  `uid` int(10) NOT NULL,
  `tid` smallint(4) NOT NULL,
  `createdate` datetime NOT NULL,
  `updatedate` datetime DEFAULT NULL,
  `comment` int(10) NOT NULL DEFAULT '0' ,
  `share` int(10) NOT NULL DEFAULT '0' ,
  `favorite` int(10) NOT NULL DEFAULT '0' ,
  `commend` tinyint(1) NOT NULL DEFAULT '0' ,
  `isdelete` tinyint(1) NOT NULL DEFAULT '0',
  `click` int(10) NOT NULL DEFAULT '0',
  `d_click` smallint(5) NOT NULL DEFAULT '0',
  `w_click` smallint(6) NOT NULL,
  `m_click` int(10) NOT NULL DEFAULT '0',
  `score` int(10) NOT NULL DEFAULT '0' ,
  `scores` int(10) NOT NULL DEFAULT '0' ,
  `bnum` smallint(5) NOT NULL DEFAULT '0' ,
  `display` tinyint(1) NOT NULL DEFAULT '0' ,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bcartcomment`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bcartcomment`;
CREATE TABLE `ig_bcartcomment` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `bcid` int(10) NOT NULL DEFAULT '0',
  `createdate` datetime NOT NULL,
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `bcart` (`bcid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bcartscore`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bcartscore`;
CREATE TABLE `ig_bcartscore` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `bcid` int(10) NOT NULL,
  `createdate` datetime NOT NULL,
  `score` tinyint(1) NOT NULL DEFAULT '1' ,
  `ip` varchar(15) NOT NULL DEFAULT '',
  `valid` tinyint(1) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `bcid` (`bcid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bcartsubject`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bcartsubject`;
CREATE TABLE `ig_bcartsubject` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bcid` int(10) NOT NULL,
  `bid` int(10) NOT NULL DEFAULT '0' ,
  `description` text NOT NULL ,
  `createdate` datetime NOT NULL,
  `updatedate` datetime DEFAULT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `isdelete` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `bcid` (`bcid`),
  KEY `bid` (`bid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_book`
-- ----------------------------
DROP TABLE IF EXISTS `ig_book`;
CREATE TABLE `ig_book` (
  `bookid` int(11) NOT NULL AUTO_INCREMENT,
  `cmbid` int(10) NOT NULL DEFAULT '0' ,
  `cmstatus` tinyint(1) NOT NULL DEFAULT '1' ,
  `bookname` varchar(50) NOT NULL,
  `aliasname` varchar(100) DEFAULT NULL,
  `typeid` int(11) NOT NULL,
  `author` varchar(30) NOT NULL,
  `authorid` int(10) DEFAULT '0',
  `bookinfo` mediumtext NOT NULL,
  `keywords` varchar(100) NOT NULL DEFAULT '',
  `createdate` datetime NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `flower` int(11) NOT NULL DEFAULT '0',
  `egg` int(11) NOT NULL DEFAULT '0',
  `commends` int(10) NOT NULL DEFAULT '0',
  `isvip` tinyint(1) NOT NULL DEFAULT '0' ,
  `commend` int(11) NOT NULL DEFAULT '0' ,
  `datatype` smallint(1) NOT NULL DEFAULT '0',
  `view` tinyint(1) NOT NULL,
  `chapters` int(11) NOT NULL,
  `lastchapterid` int(11) NOT NULL,
  `lastchaptername` char(100) NOT NULL,
  `wlastchapterid` int(10) NOT NULL DEFAULT '0' ,
  `wlastchaptername` char(200) NOT NULL DEFAULT '' ,
  `updatedate` datetime NOT NULL,
  `image` char(16) DEFAULT NULL,
  `bookforum` tinyint(1) NOT NULL DEFAULT '0',
  `nature` tinyint(1) DEFAULT '1' ,
  `type` tinyint(1) DEFAULT '1' ,
  `stopcollect` tinyint(1) DEFAULT '0' ,
  `tipping` tinyint(1) DEFAULT '0' ,
  `d_black` smallint(4) NOT NULL DEFAULT '0' ,
  `w_black` smallint(6) NOT NULL DEFAULT '0' ,
  `m_black` int(10) NOT NULL DEFAULT '0' ,
  `black` int(10) NOT NULL DEFAULT '0' ,
  `d_red` smallint(5) NOT NULL DEFAULT '0' ,
  `w_red` smallint(6) NOT NULL DEFAULT '0' ,
  `m_red` int(10) NOT NULL DEFAULT '0' ,
  `red` int(10) NOT NULL DEFAULT '0' ,
  `d_size` smallint(6) NOT NULL DEFAULT '0' ,
  `w_size` int(10) NOT NULL DEFAULT '0' ,
  `m_size` int(10) NOT NULL DEFAULT '0' ,
  `size` int(11) NOT NULL DEFAULT '0' ,
  `day` int(11) NOT NULL DEFAULT '0' ,
  `week` int(11) NOT NULL DEFAULT '0' ,
  `month` int(11) NOT NULL DEFAULT '0' ,
  `click` int(11) NOT NULL DEFAULT '0' ,
  `u_d_click` smallint(6) NOT NULL DEFAULT '0' ,
  `u_w_click` smallint(8) NOT NULL DEFAULT '0' ,
  `u_m_click` int(10) NOT NULL DEFAULT '0' ,
  `u_click` int(11) NOT NULL DEFAULT '0' ,
  `u_v_d_click` smallint(6) NOT NULL DEFAULT '0' ,
  `u_v_w_click` smallint(8) NOT NULL DEFAULT '0' ,
  `u_v_m_click` int(10) NOT NULL DEFAULT '0' ,
  `u_v_click` int(10) NOT NULL DEFAULT '0' ,
  `favorites` int(10) NOT NULL DEFAULT '0',
  `isreadtop` tinyint(1) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`bookid`),
  KEY `typeid` (`typeid`),
  KEY `view` (`view`),
  KEY `type` (`type`),
  KEY `updatedate` (`updatedate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookapplybm`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookapplybm`;
CREATE TABLE `ig_bookapplybm` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `username` char(16) NOT NULL,
  `createdate` int(10) NOT NULL,
  `issuper` tinyint(1) NOT NULL DEFAULT '0',
  `bookid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_bookbanned`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookbanned`;
CREATE TABLE `ig_bookbanned` (
  `uid` int(11) NOT NULL,
  `bookid` int(11) NOT NULL,
  `createdate` datetime NOT NULL,
  `username` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `operate_user` varchar(30) NOT NULL,
  `operate_uid` int(10) NOT NULL DEFAULT '0',
  `expiry` int(10) NOT NULL DEFAULT '0',
  `islock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`bookid`),
  UNIQUE KEY `uid` (`uid`,`bookid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookclick`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookclick`;
CREATE TABLE `ig_bookclick` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL,
  `uid` int(10) NOT NULL DEFAULT '0' ,
  `ip` varchar(15) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1' ,
  `ua` varchar(255) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `createdate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookcreditslog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookcreditslog`;
CREATE TABLE `ig_bookcreditslog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `username` varchar(20) NOT NULL,
  `operater_id` int(10) NOT NULL,
  `operater` varchar(20) NOT NULL,
  `createdate` datetime NOT NULL,
  `date` date NOT NULL,
  `credit` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`bid`),
  KEY `date` (`bid`,`date`),
  KEY `user` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookdraft`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookdraft`;
CREATE TABLE `ig_bookdraft` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `authorid` int(10) NOT NULL,
  `author` char(16) NOT NULL,
  `uid` int(10) NOT NULL,
  `username` char(16) NOT NULL,
  `bookid` int(10) DEFAULT NULL,
  `chapterid` int(10) DEFAULT '0' ,
  `subject` char(255) NOT NULL,
  `content` text NOT NULL,
  `size` mediumint(5) NOT NULL DEFAULT '0',
  `createdate` datetime NOT NULL,
  `updatedate` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `status` tinyint(1) DEFAULT '0' ,
  `sort` mediumint(5) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `author` (`authorid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookdraftcron`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookdraftcron`;
CREATE TABLE `ig_bookdraftcron` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL,
  `cid` int(10) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0' ,
  `createdate` datetime NOT NULL,
  `updatedate` datetime DEFAULT NULL,
  `year` smallint(4) NOT NULL,
  `month` smallint(2) NOT NULL,
  `day` smallint(2) NOT NULL,
  `hour` smallint(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `book` (`bid`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Table structure for `ig_bookfavorites`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookfavorites`;
CREATE TABLE `ig_bookfavorites` (
  `favoritesid` int(11) NOT NULL AUTO_INCREMENT,
  `memberid` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  `bid` int(11) NOT NULL,
  `cid` int(11) DEFAULT NULL,
  `sp` int(11) DEFAULT NULL,
  `tp` int(11) DEFAULT NULL,
  `page` int(11) DEFAULT NULL,
  `createdate` datetime NOT NULL,
  `sort` mediumint(5) NOT NULL DEFAULT '1',
  PRIMARY KEY (`favoritesid`),
  UNIQUE KEY `bookid` (`bid`,`memberid`),
  KEY `member` (`memberid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_bookfloor`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookfloor`;
CREATE TABLE `ig_bookfloor` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bookid` int(10) NOT NULL,
  `postid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `operate_uid` int(10) NOT NULL DEFAULT '0',
  `content` mediumtext NOT NULL,
  `createdate` datetime NOT NULL,
  `updatedate` datetime NOT NULL,
  `date` date NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1' ,
  `floor` int(10) NOT NULL DEFAULT '100' ,
  `credits` smallint(6) NOT NULL DEFAULT '0' ,
  `status` tinyint(1) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`bookid`),
  KEY `date` (`date`),
  KEY `floor` (`floor`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookforum`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookforum`;
CREATE TABLE `ig_bookforum` (
  `bookforumid` int(11) NOT NULL AUTO_INCREMENT,
  `bookid` int(11) NOT NULL,
  `forumname` char(255) NOT NULL,
  `comments` int(11) NOT NULL DEFAULT '0',
  `level` int(2) NOT NULL DEFAULT '1',
  `digests` int(11) NOT NULL DEFAULT '0',
  `income` decimal(20,1) DEFAULT '0.0',
  `mcount` int(11) NOT NULL,
  `click` int(11) NOT NULL DEFAULT '0',
  `highest` int(11) NOT NULL DEFAULT '500' ,
  `posts` int(11) NOT NULL DEFAULT '0',
  `todayposts` int(11) NOT NULL DEFAULT '0',
  `digest` int(11) DEFAULT '0',
  `createdate` datetime NOT NULL,
  `monthmcount` int(10) NOT NULL DEFAULT '0',
  `monthdigests` int(10) NOT NULL DEFAULT '0',
  `monthposts` int(10) NOT NULL DEFAULT '0',
  `chat` tinyint(1) DEFAULT '0',
  `advance` int(10) NOT NULL DEFAULT '0',
  `monthadvance` int(10) NOT NULL DEFAULT '0',
  `floor` varchar(200) NOT NULL DEFAULT 'a:2:{i:1;a:3:{i:1;i:10;i:2;i:200;i:3;i:500;}i:2;a:3:{i:1;i:5;i:2;i:100;i:3;i:200;}}',
  `commends` int(10) NOT NULL DEFAULT '0',
  `shard` tinyint(1) NOT NULL DEFAULT '0' ,
  `floors` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bookforumid`),
  UNIQUE KEY `book` (`bookid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookforummonth`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookforummonth`;
CREATE TABLE `ig_bookforummonth` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `forumid` int(10) NOT NULL,
  `mcount` int(10) DEFAULT '0',
  `diegsts` int(10) DEFAULT '0',
  `posts` int(10) NOT NULL DEFAULT '0',
  `date` char(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `forum` (`forumid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_bookgaglog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookgaglog`;
CREATE TABLE `ig_bookgaglog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `username` varchar(20) NOT NULL,
  `operate_uid` int(10) NOT NULL,
  `operate_username` varchar(20) NOT NULL,
  `bookid` int(11) NOT NULL DEFAULT '0' ,
  `day` smallint(5) NOT NULL DEFAULT '0' ,
  `remark` varchar(200) NOT NULL,
  `createdate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookmanage`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookmanage`;
CREATE TABLE `ig_bookmanage` (
  `bookmanageid` int(11) NOT NULL AUTO_INCREMENT,
  `bookid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `username` char(20) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `digest` tinyint(2) NOT NULL DEFAULT '5' ,
  `createdate` datetime NOT NULL,
  `updatedate` datetime NOT NULL,
  `remarks` varchar(200) NOT NULL DEFAULT '',
  `canceltime` datetime DEFAULT NULL,
  PRIMARY KEY (`bookmanageid`),
  UNIQUE KEY `uid` (`uid`,`bookid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookmanagedeputy`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookmanagedeputy`;
CREATE TABLE `ig_bookmanagedeputy` (
  `bookid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `ouid` int(10) NOT NULL DEFAULT '0' ,
  `createdate` datetime NOT NULL,
  `expiry` int(10) NOT NULL DEFAULT '0' ,
  `remark` varchar(200) NOT NULL DEFAULT '',
  UNIQUE KEY `book` (`bookid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookmanagelog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookmanagelog`;
CREATE TABLE `ig_bookmanagelog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bookid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `createdate` datetime NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `ouid` int(10) unsigned NOT NULL DEFAULT '0',
  `remark` varchar(100) NOT NULL DEFAULT '',
  `credit` smallint(4) NOT NULL DEFAULT '0',
  `message` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `bookid` (`bookid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookmembers`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookmembers`;
CREATE TABLE `ig_bookmembers` (
  `bookmembersid` int(11) NOT NULL AUTO_INCREMENT,
  `bookid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `username` char(50) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `createdate` datetime DEFAULT NULL,
  `updatedate` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bookmembersid`),
  KEY `bookid` (`bookid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_bookpaylog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpaylog`;
CREATE TABLE `ig_bookpaylog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bookname` varchar(200) NOT NULL,
  `bid` int(10) NOT NULL,
  `credits` int(10) NOT NULL DEFAULT '0',
  `price` int(10) NOT NULL DEFAULT '0' ,
  `size` int(10) NOT NULL DEFAULT '0' ,
  `uid` int(10) NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL,
  `createdate` datetime NOT NULL,
  `edate` date NOT NULL ,
  `sdate` date NOT NULL ,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`uid`),
  KEY `date` (`date`),
  KEY `book` (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookpostauto`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpostauto`;
CREATE TABLE `ig_bookpostauto` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `num` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`num`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Records of `ig_bookpostauto`
-- ----------------------------
BEGIN;
INSERT INTO `ig_bookpostauto` VALUES ('1', '1');
COMMIT;

-- ----------------------------
--  Table structure for `ig_bookpostcomplaints`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpostcomplaints`;
CREATE TABLE `ig_bookpostcomplaints` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bookid` int(10) NOT NULL,
  `postid` int(10) NOT NULL,
  `subject` char(200) NOT NULL,
  `authorid` int(10) NOT NULL,
  `author` char(20) NOT NULL,
  `uid` int(11) NOT NULL,
  `username` char(20) NOT NULL,
  `content` char(200) NOT NULL,
  `createdate` int(10) NOT NULL,
  `isaward` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`uid`,`postid`),
  KEY `book` (`bookid`),
  KEY `post` (`postid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Table structure for `ig_bookpostdigest`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpostdigest`;
CREATE TABLE `ig_bookpostdigest` (
  `postid` int(10) NOT NULL,
  `bookid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `message` text NOT NULL,
  `createdate` datetime NOT NULL,
  `postdate` date NOT NULL ,
  UNIQUE KEY `postid` (`postid`),
  KEY `book` (`bookid`),
  KEY `user` (`uid`),
  KEY `date` (`postdate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookpostreply`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpostreply`;
CREATE TABLE `ig_bookpostreply` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `postid` int(20) DEFAULT '0',
  `bookid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `username` char(20) NOT NULL,
  `subject` char(200) DEFAULT NULL,
  `content` mediumtext NOT NULL,
  `createdate` int(10) NOT NULL,
  `lastreply` int(10) DEFAULT NULL,
  `isfirst` tinyint(1) NOT NULL DEFAULT '0' ,
  `price` tinyint(2) DEFAULT '0' ,
  `buyer` mediumtext ,
  `loginip` char(20) DEFAULT NULL,
  `replycount` int(10) NOT NULL DEFAULT '0',
  `viewcount` int(10) NOT NULL DEFAULT '0',
  `bad` mediumtext ,
  `good` mediumtext ,
  `complaints` mediumtext ,
  `ispunish` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `post` (`postid`),
  KEY `book` (`bookid`),
  KEY `user` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookposts`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookposts`;
CREATE TABLE `ig_bookposts` (
  `bookpostsid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `bookid` int(11) NOT NULL,
  `message` mediumtext NOT NULL,
  `loginip` char(20) NOT NULL,
  `createdate` datetime NOT NULL,
  `date` date DEFAULT NULL,
  `digest` tinyint(1) NOT NULL DEFAULT '0',
  `remarks` char(255) DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `applydigest` tinyint(1) NOT NULL DEFAULT '0' ,
  `isadvance` tinyint(1) DEFAULT '0' ,
  `lastpost` int(10) NOT NULL,
  `floor` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`bookpostsid`),
  KEY `digest` (`digest`),
  KEY `date` (`date`),
  KEY `advance` (`isadvance`),
  KEY `bookid` (`bookid`,`lastpost`),
  KEY `last` (`lastpost`),
  KEY `postid` (`bookpostsid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookpostscleanlog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpostscleanlog`;
CREATE TABLE `ig_bookpostscleanlog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `operate_uid` int(10) NOT NULL DEFAULT '0' ,
  `bookid` int(10) NOT NULL DEFAULT '0',
  `count` int(10) NOT NULL DEFAULT '0' ,
  `date` date NOT NULL,
  `createdate` datetime NOT NULL,
  `type` smallint(1) NOT NULL DEFAULT '1' ,
  `month` smallint(2) NOT NULL DEFAULT '0' ,
  `week` smallint(2) NOT NULL DEFAULT '0' ,
  `isbackend` tinyint(1) NOT NULL DEFAULT '0' ,
  `remark` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookpostsdelete`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpostsdelete`;
CREATE TABLE `ig_bookpostsdelete` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) NOT NULL,
  `book_id` int(10) NOT NULL,
  `author_id` int(10) NOT NULL,
  `author` varchar(20) NOT NULL,
  `delete_uid` int(10) NOT NULL,
  `delete_username` varchar(20) NOT NULL,
  `message` mediumtext NOT NULL,
  `remark` varchar(100) NOT NULL,
  `createdate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookpostsmonth`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookpostsmonth`;
CREATE TABLE `ig_bookpostsmonth` (
  `bookpostsid` int(11) unsigned NOT NULL,
  `uid` int(11) NOT NULL,
  `bookid` int(11) NOT NULL,
  `message` mediumtext NOT NULL,
  `loginip` varchar(20) NOT NULL DEFAULT '',
  `createdate` datetime NOT NULL,
  `date` date DEFAULT NULL,
  `digest` tinyint(1) NOT NULL DEFAULT '0',
  `isadvance` tinyint(1) NOT NULL DEFAULT '0' ,
  `credit` decimal(2,1) NOT NULL DEFAULT '0.0',
  `stable` varchar(20) NOT NULL DEFAULT 'bookposts' ,
  `week` smallint(2) NOT NULL DEFAULT '0' ,
  KEY `digest` (`digest`),
  KEY `date` (`date`),
  KEY `advance` (`isadvance`),
  KEY `bookid` (`bookid`),
  KEY `postid` (`bookpostsid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_booksearch`
-- ----------------------------
DROP TABLE IF EXISTS `ig_booksearch`;
CREATE TABLE `ig_booksearch` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `keyword` char(200) NOT NULL,
  `createdate` datetime NOT NULL,
  `ip` varchar(16) NOT NULL,
  `date` date NOT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `valid` tinyint(1) NOT NULL DEFAULT '0',
  `count` smallint(5) NOT NULL DEFAULT '0' ,
  `ruid` int(10) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1' ,
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookshelf`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookshelf`;
CREATE TABLE `ig_bookshelf` (
  `bid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `sid` int(11) NOT NULL,
  UNIQUE KEY `only` (`bid`,`uid`),
  KEY `uid` (`uid`,`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_bookstick`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookstick`;
CREATE TABLE `ig_bookstick` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `forumid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `username` char(12) NOT NULL,
  `subject` char(255) NOT NULL,
  `content` text NOT NULL,
  `sort` smallint(6) DEFAULT '0',
  `createdate` datetime NOT NULL,
  `updatedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`uid`,`username`),
  KEY `forum` (`forumid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_booktags`
-- ----------------------------
DROP TABLE IF EXISTS `ig_booktags`;
CREATE TABLE `ig_booktags` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_booktipping`
-- ----------------------------
DROP TABLE IF EXISTS `ig_booktipping`;
CREATE TABLE `ig_booktipping` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `username` char(16) NOT NULL,
  `bookid` int(10) NOT NULL,
  `num` int(10) NOT NULL,
  `createdate` datetime NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`uid`,`username`),
  KEY `bookid` (`bookid`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_bookurge`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookurge`;
CREATE TABLE `ig_bookurge` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `username` varchar(20) NOT NULL,
  `author_id` int(10) NOT NULL,
  `price` int(10) NOT NULL,
  `date` date NOT NULL,
  `createdate` datetime NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id`),
  KEY `book` (`bid`,`date`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_bookvote`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookvote`;
CREATE TABLE `ig_bookvote` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` char(100) NOT NULL,
  `bookid` int(10) DEFAULT '0',
  `uid` int(10) NOT NULL,
  `username` char(16) NOT NULL,
  `expire` int(10) NOT NULL,
  `issuper` tinyint(1) NOT NULL DEFAULT '0',
  `isbook` tinyint(1) NOT NULL DEFAULT '0',
  `maxchoices` tinyint(2) NOT NULL DEFAULT '0',
  `createdate` int(10) NOT NULL,
  `voterids` mediumtext,
  `award` tinyint(3) NOT NULL DEFAULT '0',
  `description` char(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookvoteoption`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookvoteoption`;
CREATE TABLE `ig_bookvoteoption` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `voteid` int(10) NOT NULL,
  `votes` int(10) NOT NULL DEFAULT '0',
  `displayorder` tinyint(2) NOT NULL,
  `option` char(200) NOT NULL,
  `voterids` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_bookvoterecommend`
-- ----------------------------
DROP TABLE IF EXISTS `ig_bookvoterecommend`;
CREATE TABLE `ig_bookvoterecommend` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1' ,
  `date` date NOT NULL,
  `createdate` datetime NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `date` (`bid`,`date`),
  KEY `d` (`date`),
  KEY `b` (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_chapter`
-- ----------------------------
DROP TABLE IF EXISTS `ig_chapter`;
CREATE TABLE `ig_chapter` (
  `chapterid` int(11) NOT NULL AUTO_INCREMENT,
  `bookid` int(11) NOT NULL,
  `chaptername` varchar(100) NOT NULL,
  `createdate` datetime NOT NULL,
  `size` int(11) NOT NULL DEFAULT '0' ,
  `updatedate` datetime DEFAULT NULL,
  `date` date DEFAULT NULL,
  `sort` mediumint(4) DEFAULT NULL,
  `display` tinyint(1) DEFAULT '1',
  `isimage` tinyint(1) NOT NULL DEFAULT '0' ,
  `isvip` tinyint(1) NOT NULL DEFAULT '0' ,
  `vid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`chapterid`),
  KEY `idx_book` (`bookid`),
  KEY `idx_date` (`date`),
  KEY `idx_sort` (`bookid`,`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_chapterchange`
-- ----------------------------
DROP TABLE IF EXISTS `ig_chapterchange`;
CREATE TABLE `ig_chapterchange` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bookname` varchar(100) NOT NULL ,
  `chaptername` varchar(255) NOT NULL ,
  `date` date NOT NULL,
  `createdate` int(10) NOT NULL,
  `bid` int(10) NOT NULL,
  `cid` int(10) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1' ,
  PRIMARY KEY (`id`),
  UNIQUE KEY `only` (`id`,`bid`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_chapterlog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_chapterlog`;
CREATE TABLE `ig_chapterlog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL DEFAULT '0',
  `cid` int(10) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0' ,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `book` (`bid`,`cid`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Table structure for `ig_chapterorder`
-- ----------------------------
DROP TABLE IF EXISTS `ig_chapterorder`;
CREATE TABLE `ig_chapterorder` (
  `bid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `cid` int(10) NOT NULL,
  `price` smallint(4) NOT NULL,
  `date` date NOT NULL,
  `createdate` int(10) NOT NULL,
  UNIQUE KEY `u` (`uid`,`cid`),
  KEY `book` (`bid`),
  KEY `chapter` (`cid`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Table structure for `ig_chaptertask`
-- ----------------------------
DROP TABLE IF EXISTS `ig_chaptertask`;
CREATE TABLE `ig_chaptertask` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL DEFAULT '0',
  `cid` int(10) NOT NULL DEFAULT '0',
  `chaptername` varchar(200) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `createdate` datetime NOT NULL,
  `updatedate` datetime NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0' ,
  `url` varchar(255) NOT NULL DEFAULT '' ,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_bid_cid` (`bid`,`cid`),
  KEY `idx_date` (`date`),
  KEY `idx_bid` (`bid`),
  KEY `idx_bid_status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_cmreadlogs`
-- ----------------------------
DROP TABLE IF EXISTS `ig_cmreadlogs`;
CREATE TABLE `ig_cmreadlogs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cmid` int(10) NOT NULL DEFAULT '0',
  `ua` varchar(200) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `createdate` datetime NOT NULL,
  `date` date NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '0' ,
  `ruid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `ig_collectdelete`
-- ----------------------------
DROP TABLE IF EXISTS `ig_collectdelete`;
CREATE TABLE `ig_collectdelete` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL DEFAULT '0',
  `cid` int(10) NOT NULL,
  `name` varchar(200) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bid` (`bid`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_collectlist`
-- ----------------------------
DROP TABLE IF EXISTS `ig_collectlist`;
CREATE TABLE `ig_collectlist` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bookid` int(10) NOT NULL,
  `spider` varchar(20) NOT NULL,
  `listurl` varchar(200) NOT NULL,
  `detailurl` varchar(200) NOT NULL,
  `createdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `book` (`bookid`,`spider`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_collectlock`
-- ----------------------------
DROP TABLE IF EXISTS `ig_collectlock`;
CREATE TABLE `ig_collectlock` (
  `bid` int(10) NOT NULL,
  `site` varchar(20) NOT NULL,
  `start` datetime NOT NULL,
  UNIQUE KEY `book` (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_collectlogs`
-- ----------------------------
DROP TABLE IF EXISTS `ig_collectlogs`;
CREATE TABLE `ig_collectlogs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL,
  `cid` int(10) NOT NULL,
  `spider` varchar(20) NOT NULL,
  `url` varchar(200) NOT NULL,
  `detialurl` varchar(200) NOT NULL,
  `listurl` varchar(200) NOT NULL,
  `createdate` datetime NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_creditlog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_creditlog`;
CREATE TABLE `ig_creditlog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `username` char(14) NOT NULL,
  `credit1` int(10) NOT NULL,
  `credit2` int(10) NOT NULL,
  `createdate` datetime NOT NULL,
  `action` varchar(40) DEFAULT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_demand`
-- ----------------------------
DROP TABLE IF EXISTS `ig_demand`;
CREATE TABLE `ig_demand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `username` varchar(20) NOT NULL,
  `bookname` varchar(150) NOT NULL,
  `author` varchar(50) NOT NULL DEFAULT '',
  `createdate` int(10) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_denybugle`
-- ----------------------------
DROP TABLE IF EXISTS `ig_denybugle`;
CREATE TABLE `ig_denybugle` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `createdate` datetime NOT NULL,
  `expiry` int(10) NOT NULL DEFAULT '0' ,
  `operate_uid` int(10) NOT NULL DEFAULT '0' ,
  `remark` varchar(200) NOT NULL ,
  PRIMARY KEY (`id`),
  KEY `user` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_diary`
-- ----------------------------
DROP TABLE IF EXISTS `ig_diary`;
CREATE TABLE `ig_diary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `tid` int(10) NOT NULL,
  `aid` int(10) NOT NULL DEFAULT '0' ,
  `privacy` tinyint(4) NOT NULL DEFAULT '0' ,
  `subject` varchar(150) NOT NULL,
  `abstract` varchar(255) NOT NULL DEFAULT '' ,
  `views` int(10) NOT NULL DEFAULT '0',
  `comments` int(10) NOT NULL DEFAULT '0',
  `password` varchar(10) NOT NULL DEFAULT '' ,
  `createdate` int(10) NOT NULL DEFAULT '0',
  `isupload` tinyint(1) NOT NULL DEFAULT '0' ,
  `istoped` tinyint(1) NOT NULL DEFAULT '0' ,
  `iscomment` tinyint(1) NOT NULL DEFAULT '2' ,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_diarycomment`
-- ----------------------------
DROP TABLE IF EXISTS `ig_diarycomment`;
CREATE TABLE `ig_diarycomment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `did` int(10) NOT NULL,
  `content` varchar(200) NOT NULL DEFAULT '',
  `createdate` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `did` (`did`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_diarydata`
-- ----------------------------
DROP TABLE IF EXISTS `ig_diarydata`;
CREATE TABLE `ig_diarydata` (
  `did` int(10) NOT NULL,
  `content` text NOT NULL,
  `createdate` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`did`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_diarytype`
-- ----------------------------
DROP TABLE IF EXISTS `ig_diarytype`;
CREATE TABLE `ig_diarytype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `name` varchar(10) NOT NULL,
  `num` mediumint(8) NOT NULL DEFAULT '0' ,
  `privacy` tinyint(4) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_easoulogs`
-- ----------------------------
DROP TABLE IF EXISTS `ig_easoulogs`;
CREATE TABLE `ig_easoulogs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `valid` tinyint(1) NOT NULL DEFAULT '0' ,
  `uid` int(10) NOT NULL DEFAULT '0',
  `ua` varchar(200) NOT NULL DEFAULT '',
  `createdate` datetime NOT NULL,
  `key` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_entrancelogs`
-- ----------------------------
DROP TABLE IF EXISTS `ig_entrancelogs`;
CREATE TABLE `ig_entrancelogs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL DEFAULT '0' ,
  `ruid` int(10) NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '',
  `createdate` datetime NOT NULL,
  `date` date NOT NULL,
  `isspider` tinyint(1) NOT NULL DEFAULT '0' ,
  `ua` varchar(200) NOT NULL DEFAULT '',
  `valid` tinyint(1) NOT NULL DEFAULT '0' ,
  `isvalid` tinyint(1) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_favorites`
-- ----------------------------
DROP TABLE IF EXISTS `ig_favorites`;
CREATE TABLE `ig_favorites` (
  `fid` int(10) NOT NULL AUTO_INCREMENT,
  `id` int(10) NOT NULL DEFAULT '0' ,
  `type` enum('thread','bcart') NOT NULL DEFAULT 'bcart' ,
  `uid` int(10) NOT NULL DEFAULT '0',
  `createdate` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`),
  KEY `user` (`uid`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Table structure for `ig_feed`
-- ----------------------------
DROP TABLE IF EXISTS `ig_feed`;
CREATE TABLE `ig_feed` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `feed` text NOT NULL,
  `createdate` int(10) NOT NULL,
  `type` enum('bbs','member','zone','book','forum') NOT NULL DEFAULT 'bbs',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_fluxsum`
-- ----------------------------
DROP TABLE IF EXISTS `ig_fluxsum`;
CREATE TABLE `ig_fluxsum` (
  `date` date NOT NULL,
  `year` char(4) NOT NULL,
  `month` char(2) NOT NULL,
  `pv` int(10) NOT NULL DEFAULT '0',
  `valid_pv` int(10) NOT NULL DEFAULT '0',
  `uv` int(10) NOT NULL DEFAULT '0' ,
  `valid_uv` int(10) NOT NULL DEFAULT '0' ,
  `u_pv` int(10) NOT NULL DEFAULT '0',
  `u_valid_pv` int(10) NOT NULL,
  `spider` int(10) NOT NULL DEFAULT '0' ,
  `register` smallint(6) NOT NULL DEFAULT '0' ,
  `verify` smallint(6) NOT NULL DEFAULT '0' ,
  `login` int(10) NOT NULL DEFAULT '0' ,
  `threads` smallint(6) NOT NULL DEFAULT '0' ,
  `posts` smallint(8) NOT NULL DEFAULT '0' ,
  `bookposts` int(10) NOT NULL DEFAULT '0' ,
  `wap` int(10) NOT NULL DEFAULT '0' ,
  `tg` int(10) NOT NULL DEFAULT '0' ,
  `web` int(10) NOT NULL DEFAULT '0' ,
  `feed` int(10) NOT NULL DEFAULT '0' ,
  UNIQUE KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED ;

-- ----------------------------
--  Table structure for `ig_forumlog`
-- ----------------------------
DROP TABLE IF EXISTS `ig_forumlog`;
CREATE TABLE `ig_forumlog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `fid` int(10) NOT NULL DEFAULT '0',
  `tid` int(10) NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '' ,
  `ouid` int(10) NOT NULL DEFAULT '0' ,
  `uid` int(10) NOT NULL DEFAULT '0' ,
  `createdate` datetime NOT NULL,
  `date` date NOT NULL,
  `remark` text NOT NULL,
  `ip` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `fid` (`fid`),
  KEY `u1` (`ouid`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_forums`
-- ----------------------------
DROP TABLE IF EXISTS `ig_forums`;
CREATE TABLE `ig_forums` (
  `fid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `fup` smallint(6) NOT NULL DEFAULT '0' ,
  `ifsub` tinyint(1) NOT NULL DEFAULT '0' ,
  `childid` tinyint(1) NOT NULL DEFAULT '0' ,
  `type` enum('category','forum','sub','sub2') NOT NULL,
  `logo` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  `rule` text NOT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `threads` int(10) NOT NULL DEFAULT '0',
  `posts` int(10) NOT NULL DEFAULT '0',
  `lastpost` char(200) NOT NULL DEFAULT '',
  `vieworder` smallint(6) NOT NULL DEFAULT '0',
  `forumadmin` varchar(255) NOT NULL DEFAULT '' ,
  `fupadmin` varchar(255) NOT NULL DEFAULT '' ,
  `allowhide` tinyint(1) NOT NULL DEFAULT '1' ,
  `allowsell` tinyint(1) NOT NULL DEFAULT '0' ,
  `allowvisit` varchar(255) NOT NULL DEFAULT '' ,
  `allowread` varchar(255) NOT NULL DEFAULT '' ,
  `allowpost` varchar(255) NOT NULL DEFAULT '' ,
  `allowrp` varchar(255) NOT NULL DEFAULT '' ,
  `allowdownload` varchar(255) NOT NULL DEFAULT '' ,
  `allowupload` varchar(255) NOT NULL DEFAULT '' ,
  `ispostcheck` tinyint(4) NOT NULL DEFAULT '0' ,
  `password` varchar(30) NOT NULL DEFAULT '',
  `forumset` text NOT NULL,
  `creditset` text NOT NULL,
  `todayposts` smallint(8) NOT NULL DEFAULT '0',
  `todaythreads` smallint(8) NOT NULL DEFAULT '0',
  `topthreads` text NOT NULL,
  `f_check` tinyint(1) NOT NULL DEFAULT '0' ,
  `t_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC ;

-- ----------------------------
--  Table structure for `ig_friend`
-- ----------------------------
DROP TABLE IF EXISTS `ig_friend`;
CREATE TABLE `ig_friend` (
  `uid` int(11) NOT NULL,
  `fuid` int(11) NOT NULL,
  `createdate` int(10) NOT NULL,
  `ftid` smallint(8) NOT NULL,
  PRIMARY KEY (`uid`,`fuid`),
  KEY `ftid` (`ftid`),
  KEY `join` (`uid`,`createdate`),
  KEY `create` (`createdate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Table structure for `ig_gateway`
-- ----------------------------
DROP TABLE IF EXISTS `ig_gateway`;
CREATE TABLE `ig_gateway` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` char(15) NOT NULL,
  `province` varchar(20) NOT NULL,
  `type` char(10) DEFAULT '',
  `count` int(11) DEFAULT '0',
  `create_date` date DEFAULT NULL,
  `commited` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ipgateway_ip_province_index` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=19278 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `ig_gateway`
-- ----------------------------
BEGIN;
INSERT INTO `ig_gateway` VALUES ('4349', '221.235.65.223', '', '', '3', '2008-08-27', '0'), ('4350', '219.134.129.172', '', '', '17', '2008-08-27', '0'), ('4313', '218.22.28.211', '', '', '1', '2008-08-27', '0'), ('5536', '116.28.7.28', '', '', '1', '2008-09-04', '0'), ('4308', '221.232.135.54', '', '', '1', '2008-08-27', '0'), ('4309', '195.189.142.210', '', '', '1', '2008-08-27', '0'), ('4310', '121.29.8.139', '', '', '2', '2008-08-27', '0'), ('4311', '211.136.158.165', '', '', '2', '2008-08-27', '0'), ('4312', '121.9.80.185', '', '', '1', '2008-08-27', '0'), ('4306', '218.83.155.166', '', '', '8', '2008-08-27', '0'), ('4304', '220.176.6.124', '', '', '1', '2008-08-27', '0'), ('4305', '195.189.142.208', '', '', '2', '2008-08-27', '0'), ('4303', '74.6.18.215', '', '', '44', '2008-08-27', '0'), ('4302', '116.11.241.128', '', '', '3', '2008-08-27', '0'), ('4301', '218.19.85.102', '', '', '2', '2008-08-27', '0'), ('4300', '117.28.189.53', '', '', '2', '2008-08-27', '0'), ('4299', '125.91.150.165', '', '', '2', '2008-08-27', '0'), ('4296', '116.21.91.142', '', '', '1', '2008-08-27', '0'), ('4297', '211.137.63.112', '', '', '2', '2008-08-27', '0'), ('4298', '211.136.228.67', '', '', '19', '2008-08-27', '0'), ('4295', '195.189.142.58', '', '', '1', '2008-08-27', '0'), ('4294', '124.163.137.41', '', '', '1', '2008-08-27', '0'), ('4293', '116.25.206.169', '', '', '1', '2008-08-27', '0'), ('4291', '202.160.178.85', '', '', '1', '2008-08-27', '0'), ('4292', '119.126.92.146', '', '', '1', '2008-08-27', '0'), ('4283', '116.7.110.82', '', '', '2', '2008-08-27', '0'), ('4284', '220.206.246.38', '', '', '4', '2008-08-27', '0'), ('4285', '61.243.142.225', '', '', '8', '2008-08-27', '0'), ('4286', '60.177.225.84', '', '', '1', '2008-08-27', '0'), ('4287', '211.140.16.241', '', '', '62', '2008-08-27', '0'), ('4288', '211.136.158.179', '', '', '3', '2008-08-27', '0'), ('4289', '211.140.16.224', '', '', '30', '2008-08-27', '0'), ('4290', '220.179.65.13', '', '', '1', '2008-08-27', '0'), ('4282', '222.213.127.62', '', '', '1', '2008-08-27', '0'), ('4279', '219.136.218.101', '', '', '2', '2008-08-27', '0'), ('4280', '121.13.7.25', '', '', '1', '2008-08-27', '0'), ('4281', '202.160.178.43', '', '', '1', '2008-08-27', '0'), ('2257', '211.139.151.74', '广东', '移动', '0', '2008-08-18', '1'), ('2278', '211.143.171.143', '福建', '移动', '0', '2008-08-18', '1'), ('4340', '121.19.39.201', '', '', '1', '2008-08-27', '0'), ('4277', '202.160.180.146', '', '', '1', '2008-08-27', '0'), ('4278', '220.187.189.24', '', '', '1', '2008-08-27', '0'), ('4276', '211.137.13.40', '', '', '2', '2008-08-27', '0'), ('4275', '220.206.196.2', '', '', '48', '2008-08-27', '0'), ('4274', '74.6.18.227', '', '', '1', '2008-08-27', '0'), ('4273', '61.138.179.145', '', '', '1', '2008-08-27', '0'), ('4272', '211.136.158.230', '', '', '4', '2008-08-27', '0'), ('4271', '219.135.130.120', '', '', '1', '2008-08-27', '0'), ('4270', '60.211.187.18', '', '', '1', '2008-08-27', '0'), ('4269', '218.19.16.175', '', '', '2', '2008-08-27', '0'), ('4268', '211.136.228.85', '', '', '20', '2008-08-27', '0'), ('4267', '61.146.93.155', '', '', '19', '2008-08-27', '0'), ('2221', '211.136.23.43', '辽宁', '移动', '0', '2008-08-18', '1'), ('4266', '124.39.109.86', '', '', '6', '2008-08-27', '0'), ('4265', '211.136.75.67', '', '', '2', '2008-08-27', '0'), ('4264', '220.206.235.85', '', '', '1', '2008-08-27', '0'), ('4263', '116.25.183.236', '', '', '1', '2008-08-27', '0'), ('4262', '202.160.180.65', '', '', '2', '2008-08-27', '0'), ('4261', '211.136.158.177', '', '', '4', '2008-08-27', '0'), ('5535', '59.41.75.85', '', '', '2', '2008-09-04', '0'), ('2280', '211.143.58.46', '河北', '移动', '1', '2008-08-18', '1'), ('2281', '218.200.225.8', '四川', '移动', '0', '2008-08-18', '1'), ('4258', '202.160.180.191', '', '', '1', '2008-08-27', '0'), ('4259', '58.71.251.171', '', '', '1', '2008-08-27', '0'), ('4256', '211.139.162.130', '', '', '44', '2008-08-27', '0'), ('4257', '218.1.134.3', '', '', '2', '2008-08-27', '0'), ('2214', '211.136.222.66', '广东', '移动', '0', '2008-08-18', '1'), ('4255', '125.91.253.237', '', '移动', '0', '2008-10-15', '1'), ('4254', '59.61.76.90', '', '', '5', '2008-08-27', '0'), ('4248', '211.139.162.164', '', '', '11', '2008-08-27', '0'), ('4249', '202.160.180.59', '', '', '3', '2008-08-27', '0'), ('4250', '123.233.218.240', '', '', '1', '2008-08-27', '0'), ('4251', '219.150.239.29', '', '', '1', '2008-08-27', '0'), ('4252', '61.191.113.145', '', '', '1', '2008-08-27', '0'), ('4253', '58.240.74.36', '', '', '1', '2008-08-27', '0'), ('4247', '219.159.241.253', '', '', '1', '2008-08-27', '0'), ('4246', '222.70.193.32', '', '', '1', '2008-08-27', '0'), ('4244', '195.189.142.53', '', '', '2', '2008-08-26', '0'), ('4245', '202.160.178.189', '', '', '3', '2008-08-27', '0'), ('4242', '211.138.218.79', '', '', '1', '2008-08-26', '0'), ('4243', '124.207.224.81', '', '', '5', '2008-08-26', '0'), ('4241', '218.14.78.32', '', '', '1', '2008-08-26', '0'), ('4240', '58.60.172.219', '', '', '1', '2008-08-26', '0'), ('4239', '221.130.180.215', '', '', '2', '2008-08-26', '0'), ('4234', '202.160.179.172', '', '', '1', '2008-08-26', '0'), ('4235', '116.48.167.142', '', '', '1', '2008-08-26', '0'), ('4236', '220.206.246.35', '', '', '10', '2008-08-26', '0'), ('4237', '211.136.228.94', '', '', '19', '2008-08-26', '0'), ('4238', '218.205.249.143', '', '', '1', '2008-08-26', '0'), ('4233', '218.75.95.150', '', '', '1', '2008-08-26', '0'), ('4228', '123.121.59.72', '', '', '1', '2008-08-26', '0'), ('4229', '125.127.59.136', '', '', '5', '2008-08-26', '0'), ('4230', '211.138.28.178', '', '', '52', '2008-08-26', '0'), ('4231', '59.48.238.40', '', '', '2', '2008-08-26', '0'), ('4232', '203.81.19.19', '', '', '17', '2008-08-26', '0'), ('4226', '219.128.140.83', '', '', '1', '2008-08-26', '0'), ('4227', '195.189.142.154', '', '', '2', '2008-08-26', '0'), ('4224', '211.136.158.206', '', '', '2', '2008-08-26', '0'), ('4225', '202.160.178.182', '', '', '1', '2008-08-26', '0'), ('4223', '120.1.99.123', '', '', '1', '2008-08-26', '0'), ('2233', '211.137.33.167', '辽宁', '移动', '0', '2008-08-18', '1'), ('4347', '124.234.149.93', '', '', '1', '2008-08-27', '0'), ('4221', '211.140.16.239', '', '', '58', '2008-08-26', '0'), ('4222', '211.137.37.138', '', '', '5', '2008-08-26', '0'), ('2226', '211.137.119.232', '广东', '移动', '0', '2008-08-18', '1'), ('4362', '128.243.220.22', '', '', '2', '2008-08-27', '0'), ('4363', '218.56.98.86', '', '', '1', '2008-08-27', '0'), ('4364', '119.120.19.167', '', '', '1', '2008-08-27', '0'), ('4218', '60.219.29.225', '', '', '1', '2008-08-26', '0'), ('4219', '120.32.197.189', '', '', '1', '2008-08-26', '0'), ('4220', '58.211.21.81', '', '移动', '0', '2008-10-15', '1'), ('4217', '58.211.21.101', '', '移动', '0', '2008-10-15', '1'), ('4216', '211.137.163.27', '', '', '70', '2008-08-26', '0'), ('4215', '202.160.178.114', '', '', '1', '2008-08-26', '0'), ('4214', '211.137.163.26', '', '', '18', '2008-08-26', '0'), ('4213', '116.76.168.223', '', '', '2', '2008-08-26', '0'), ('4212', '61.156.202.202', '', '', '1', '2008-08-26', '0'), ('4211', '222.64.143.31', '', '', '1', '2008-08-26', '0'), ('4210', '220.181.32.16', '', '', '30', '2008-08-26', '0'), ('4209', '116.21.81.228', '', '', '1', '2008-08-26', '0'), ('2287', '218.202.4.135', '广东', '移动', '0', '2008-08-18', '1'), ('4208', '116.27.41.224', '', '', '1', '2008-08-26', '0'), ('5534', '121.227.254.131', '', '', '1', '2008-09-04', '0'), ('4206', '218.90.217.166', '', '', '1', '2008-08-26', '0'), ('4205', '211.138.218.69', '', '', '1', '2008-08-26', '0'), ('4203', '211.140.16.244', '', '', '17', '2008-08-26', '0'), ('4204', '218.22.30.98', '', '', '1', '2008-08-26', '0'), ('4202', '222.162.135.26', '', '', '2', '2008-08-26', '0'), ('4201', '121.13.222.45', '', '', '1', '2008-08-26', '0'), ('4200', '218.13.136.87', '', '', '3', '2008-08-26', '0'), ('2296', '221.130.183.227', '广东', '移动', '0', '2008-08-18', '1'), ('4199', '58.248.174.251', '', '', '1', '2008-08-26', '0'), ('4198', '218.58.68.94', '', '', '1', '2008-08-26', '0'), ('4196', '125.83.218.189', '', '', '2', '2008-08-26', '0'), ('4195', '121.12.224.157', '', '', '1', '2008-08-26', '0'), ('4192', '211.136.73.71', '', '', '12', '2008-08-26', '0'), ('4193', '219.135.129.30', '', '', '1', '2008-08-26', '0'), ('4194', '211.136.73.67', '', '', '41', '2008-08-26', '0'), ('4190', '116.76.170.182', '', '', '14', '2008-08-26', '0'), ('4191', '123.151.137.233', '', '', '1', '2008-08-26', '0'), ('4189', '125.109.17.236', '', '', '1', '2008-08-26', '0'), ('4188', '211.139.162.170', '', '', '22', '2008-08-26', '0'), ('4187', '218.1.21.254', '', '', '12', '2008-08-26', '0'), ('4186', '218.22.20.157', '', '', '1', '2008-08-26', '0'), ('4185', '116.52.54.98', '', '', '1', '2008-08-26', '0'), ('4184', '211.136.158.242', '', '', '4', '2008-08-26', '0'), ('4183', '211.136.73.73', '', '', '12', '2008-08-26', '0'), ('2244', '211.138.237.173', '湖南', '移动', '0', '2008-08-18', '1'), ('4353', '122.224.187.63', '', '', '2', '2008-08-27', '0'), ('4181', '211.136.75.144', '', '', '4', '2008-08-26', '0'), ('4182', '211.136.158.212', '', '', '1', '2008-08-26', '0'), ('4180', '59.33.175.90', '', '', '1', '2008-08-26', '0'), ('4179', '220.181.32.73', '', '', '1', '2008-08-26', '0'), ('4178', '124.76.2.48', '', '', '1', '2008-08-26', '0'), ('4177', '202.160.180.166', '', '', '4', '2008-08-26', '0'), ('4174', '58.83.127.203', '', '', '1', '2008-08-26', '0'), ('4175', '220.162.27.57', '', '', '1', '2008-08-26', '0'), ('4176', '218.18.115.194', '', '', '11', '2008-08-26', '0'), ('4173', '59.41.166.59', '', '', '1', '2008-08-26', '0'), ('4172', '121.34.111.155', '', '', '1', '2008-08-26', '0'), ('4171', '58.216.6.59', '', '', '1', '2008-08-26', '0'), ('2215', '211.136.222.74', '广东', '移动', '0', '2008-08-18', '1'), ('4170', '58.38.124.177', '', '', '3', '2008-08-26', '0'), ('4168', '195.189.143.57', '', '', '4', '2008-08-26', '0'), ('4169', '202.160.180.69', '', '', '2', '2008-08-26', '0'), ('4166', '221.221.98.140', '', '', '1', '2008-08-26', '0'), ('4167', '218.14.8.72', '', '', '1', '2008-08-26', '0'), ('4165', '91.203.96.25', '', '', '4', '2008-08-26', '0'), ('4164', '222.217.88.116', '', '', '2', '2008-08-26', '0'), ('4163', '59.51.48.30', '', '', '1', '2008-08-26', '0'), ('4162', '202.160.178.136', '', '', '1', '2008-08-26', '0'), ('4160', '116.16.229.135', '', '', '1', '2008-08-26', '0'), ('4161', '202.160.178.160', '', '', '1', '2008-08-26', '0'), ('4158', '202.160.178.235', '', '', '1', '2008-08-26', '0'), ('4159', '58.63.72.142', '', '', '2', '2008-08-26', '0'), ('4157', '59.37.4.3', '', '', '1', '2008-08-26', '0'), ('4155', '91.203.96.18', '', '', '4', '2008-08-26', '0'), ('4156', '123.232.113.166', '', '', '2', '2008-08-26', '0'), ('4154', '61.135.220.80', '', '', '1', '2008-08-26', '0'), ('4153', '211.137.41.29', '', '', '13', '2008-08-26', '0'), ('2267', '211.139.60.19', '重庆', '移动', '0', '2008-08-18', '1'), ('4150', '211.141.68.73', '', '', '6', '2008-08-26', '0'), ('4151', '220.163.9.243', '', '', '1', '2008-08-26', '0'), ('4152', '222.65.155.143', '', '', '1', '2008-08-26', '0'), ('4149', '58.211.21.89', '', '移动', '0', '2008-10-15', '1'), ('4148', '125.46.74.18', '', '', '1', '2008-08-26', '0'), ('2290', '218.203.63.66', '黑龙江', '移动', '0', '2008-08-18', '1'), ('4315', '218.57.221.34', '', '', '1', '2008-08-27', '0'), ('4146', '61.174.223.96', '', '', '2', '2008-08-26', '0'), ('4147', '119.4.112.235', '', '', '1', '2008-08-26', '0'), ('4144', '116.17.93.9', '', '', '2', '2008-08-26', '0'), ('4145', '219.136.15.197', '', '', '7', '2008-08-26', '0'), ('4143', '121.32.157.149', '', '', '1', '2008-08-26', '0'), ('4142', '125.120.99.146', '', '', '1', '2008-08-26', '0'), ('4140', '219.125.148.39', '', '', '1', '2008-08-26', '0'), ('4141', '61.135.220.35', '', '', '1', '2008-08-26', '0'), ('4137', '195.189.142.56', '', '', '2', '2008-08-26', '0'), ('4138', '125.69.24.175', '', '', '1', '2008-08-26', '0'), ('4139', '59.35.17.122', '', '', '2', '2008-08-26', '0'), ('4136', '59.36.68.236', '', '', '1', '2008-08-26', '0'), ('4135', '220.197.172.125', '', '', '1', '2008-08-26', '0'), ('4134', '222.190.5.6', '', '', '1', '2008-08-26', '0'), ('2285', '218.201.200.134', '贵州', '移动', '0', '2008-08-18', '1'), ('4133', '222.181.114.92', '', '', '1', '2008-08-26', '0'), ('4131', '219.140.247.186', '', '', '1', '2008-08-26', '0'), ('4132', '218.200.224.123', '', '', '1', '2008-08-26', '0'), ('4130', '202.160.178.241', '', '', '3', '2008-08-26', '0'), ('4129', '222.189.111.201', '', '', '1', '2008-08-26', '0'), ('4127', '200.91.165.130', '', '', '3', '2008-08-26', '0'), ('4128', '202.160.180.192', '', '', '2', '2008-08-26', '0'), ('2884', '125.127.48.65', '', '', '1', '2008-08-21', '0'), ('2885', '125.91.253.239', '', '移动', '0', '2008-10-15', '1'), ('2886', '211.139.148.40', '', '', '60', '2008-08-21', '0'), ('2205', '211.136.115.9', '上海', '移动', '0', '2008-08-18', '1'), ('2250', '211.139.145.222', '广东', '移动', '0', '2008-08-18', '1'), ('4126', '118.74.21.158', '', '', '1', '2008-08-26', '0'), ('4124', '61.135.168.95', '', '', '4', '2008-08-26', '0'), ('4123', '218.19.22.205', '', '', '2', '2008-08-26', '0'), ('4122', '211.137.197.62', '', '', '9', '2008-08-26', '0'), ('4121', '59.108.114.38', '', '', '3', '2008-08-26', '0'), ('4119', '121.235.243.23', '', '', '1', '2008-08-26', '0'), ('4120', '202.160.179.145', '', '', '1', '2008-08-26', '0'), ('4118', '222.125.66.197', '', '', '1', '2008-08-26', '0'), ('2269', '211.140.11.27', '浙江', '移动', '0', '2008-08-18', '1'), ('4117', '61.135.168.172', '', '', '1', '2008-08-26', '0'), ('4367', '121.232.63.6', '', '', '1', '2008-08-27', '0'), ('4333', '121.68.0.247', '', '', '4', '2008-08-27', '0'), ('4334', '211.139.162.197', '', '', '21', '2008-08-27', '0'), ('4335', '124.72.156.174', '', '', '1', '2008-08-27', '0'), ('4336', '209.85.238.4', '', '', '2', '2008-08-27', '0'), ('4114', '220.181.32.63', '', '', '8', '2008-08-26', '0'), ('4115', '123.124.194.65', '', '', '16', '2008-08-26', '0'), ('4116', '202.160.179.73', '', '', '1', '2008-08-26', '0'), ('4112', '202.160.178.127', '', '', '3', '2008-08-26', '0'), ('4113', '219.111.15.142', '', '', '1', '2008-08-26', '0'), ('4110', '222.135.4.248', '', '', '4', '2008-08-26', '0'), ('4111', '211.136.158.138', '', '', '7', '2008-08-26', '0'), ('4109', '203.113.138.123', '', '', '1', '2008-08-26', '0'), ('4108', '218.57.211.94', '', '', '1', '2008-08-26', '0'), ('4107', '202.156.8.14', '', '', '2', '2008-08-26', '0'), ('4106', '211.140.16.234', '', '', '50', '2008-08-26', '0'), ('4105', '124.130.168.67', '', '', '1', '2008-08-26', '0'), ('4104', '202.160.178.25', '', '', '4', '2008-08-26', '0'), ('4103', '202.160.178.116', '', '', '2', '2008-08-26', '0'), ('4102', '211.136.228.243', '', '', '35', '2008-08-26', '0'), ('4101', '202.160.179.171', '', '', '2', '2008-08-26', '0'), ('5533', '222.90.0.176', '', '', '1', '2008-09-04', '0'), ('4099', '202.160.178.238', '', '', '2', '2008-08-26', '0'), ('4100', '202.160.178.168', '', '', '2', '2008-08-26', '0'), ('4097', '58.252.81.115', '', '', '1', '2008-08-26', '0'), ('4094', '219.128.62.43', '', '', '1', '2008-08-26', '0'), ('4095', '211.136.73.64', '', '', '8', '2008-08-26', '0'), ('4096', '211.138.218.20', '', '', '1', '2008-08-26', '0'), ('4092', '202.160.178.177', '', '', '3', '2008-08-26', '0'), ('4093', '211.137.63.134', '', '', '3', '2008-08-26', '0'), ('2289', '218.203.63.190', '黑龙江', '移动', '0', '2008-08-18', '1'), ('2733', '61.141.5.33', '', '移动', '0', '2008-10-15', '1'), ('2744', '122.82.10.250', '', '', '1', '2008-08-21', '0'), ('2277', '211.142.189.78', '河南', '移动', '0', '2008-08-18', '1'), ('4316', '211.139.162.133', '', '', '43', '2008-08-27', '0'), ('4317', '58.59.135.119', '', '', '1', '2008-08-27', '0'), ('4318', '222.188.253.40', '', '', '4', '2008-08-27', '0'), ('4319', '121.33.69.216', '', '', '2', '2008-08-27', '0'), ('4320', '190.80.12.114', '', '', '2', '2008-08-27', '0'), ('4321', '211.139.162.131', '', '', '47', '2008-08-27', '0'), ('4090', '74.6.8.107', '', '', '21', '2008-08-26', '0'), ('4091', '203.142.126.148', '', '', '1', '2008-08-26', '0'), ('2258', '211.139.163.138', '广东', '移动', '0', '2008-08-18', '1'), ('4089', '211.137.62.251', '', '', '3', '2008-08-26', '0'), ('2276', '211.142.189.231', '河南', '移动', '0', '2008-08-18', '1'), ('4087', '220.194.47.85', '', '', '1', '2008-08-26', '0'), ('4088', '121.8.67.50', '', '', '1', '2008-08-26', '0'), ('4086', '211.137.62.226', '', '', '2', '2008-08-26', '0'), ('4085', '210.177.204.68', '', '', '8', '2008-08-26', '0'), ('4084', '202.160.179.164', '', '', '2', '2008-08-26', '0'), ('4082', '218.83.230.38', '', '', '1', '2008-08-26', '0'), ('4083', '125.45.120.169', '', '', '2', '2008-08-26', '0'), ('4078', '211.139.146.248', '', '', '21', '2008-08-26', '0'), ('4079', '93.189.56.218', '', '', '1', '2008-08-26', '0'), ('4080', '119.124.206.81', '', '', '1', '2008-08-26', '0'), ('4081', '219.137.111.230', '', '', '1', '2008-08-26', '0'), ('4076', '124.72.182.180', '', '', '1', '2008-08-26', '0'), ('4077', '211.136.158.164', '', '', '5', '2008-08-26', '0'), ('4075', '211.136.73.104', '', '', '23', '2008-08-26', '0'), ('4074', '211.136.158.172', '', '', '2', '2008-08-26', '0'), ('4073', '58.62.77.68', '', '', '1', '2008-08-26', '0'), ('4071', '218.30.110.163', '', '移动', '0', '2008-10-15', '1'), ('4072', '124.227.12.149', '', '', '16', '2008-08-26', '0'), ('4066', '211.137.63.189', '', '', '2', '2008-08-25', '0'), ('4067', '134.159.173.10', '', '', '1', '2008-08-25', '0'), ('4068', '125.91.253.250', '', '移动', '0', '2008-10-15', '1'), ('4069', '219.134.208.189', '', '', '1', '2008-08-26', '0'), ('4070', '125.69.188.180', '', '', '2', '2008-08-26', '0'), ('4065', '218.20.8.251', '', '', '2', '2008-08-25', '0'), ('4064', '220.181.32.30', '', '', '4', '2008-08-25', '0'), ('4063', '222.221.222.93', '', '', '1', '2008-08-25', '0'), ('5532', '222.126.127.122', '', '', '1', '2008-09-04', '0'), ('4059', '60.216.121.134', '', '', '1', '2008-08-25', '0'), ('4060', '125.93.35.123', '', '', '1', '2008-08-25', '0'), ('4061', '125.91.253.211', '', '移动', '0', '2008-10-15', '1'), ('4058', '61.143.198.73', '', '', '8', '2008-08-25', '0'), ('4055', '193.108.214.219', '', '', '1', '2008-08-25', '0'), ('4056', '61.50.142.190', '', '', '1', '2008-08-25', '0'), ('4057', '221.130.191.155', '', '', '1', '2008-08-25', '0'), ('4054', '123.65.193.162', '', '', '1', '2008-08-25', '0'), ('4053', '58.62.106.143', '', '', '1', '2008-08-25', '0'), ('4052', '220.179.48.149', '', '', '2', '2008-08-25', '0'), ('4051', '218.18.155.28', '', '', '1', '2008-08-25', '0'), ('4050', '222.90.113.192', '', '', '1', '2008-08-25', '0'), ('4049', '74.6.22.170', '', '', '10', '2008-08-25', '0'), ('5531', '222.89.182.59', '', '', '1', '2008-09-04', '0'), ('4047', '211.137.63.101', '', '', '1', '2008-08-25', '0'), ('4046', '220.178.241.118', '', '', '2', '2008-08-25', '0'), ('4045', '220.181.32.17', '', '', '1', '2008-08-25', '0'), ('4043', '220.166.129.23', '', '', '1', '2008-08-25', '0'), ('4044', '222.211.36.181', '', '', '2', '2008-08-25', '0'), ('4042', '61.132.92.210', '', '', '1', '2008-08-25', '0'), ('4041', '211.136.73.107', '', '', '7', '2008-08-25', '0'), ('4040', '59.61.173.34', '', '', '1', '2008-08-25', '0'), ('4039', '211.136.158.243', '', '', '1', '2008-08-25', '0'), ('5530', '211.136.73.108', '', '', '5', '2008-09-04', '0'), ('4038', '211.139.162.169', '', '', '22', '2008-08-25', '0'), ('4337', '219.237.137.246', '', '', '1', '2008-08-27', '0'), ('4035', '121.35.38.13', '', '', '1', '2008-08-25', '0'), ('4036', '220.200.68.149', '', '', '1', '2008-08-25', '0'), ('4033', '221.226.117.195', '', '', '2', '2008-08-25', '0'), ('4034', '116.4.60.218', '', '', '1', '2008-08-25', '0'), ('4032', '124.114.193.176', '', '', '2', '2008-08-25', '0'), ('4031', '59.33.40.157', '', '', '1', '2008-08-25', '0'), ('4030', '202.160.179.96', '', '', '3', '2008-08-25', '0'), ('4029', '58.42.195.209', '', '', '1', '2008-08-25', '0'), ('4028', '116.234.163.109', '', '', '2', '2008-08-25', '0'), ('4027', '222.79.151.29', '', '', '1', '2008-08-25', '0'), ('4023', '202.160.179.142', '', '', '1', '2008-08-25', '0'), ('4024', '211.136.158.196', '', '', '3', '2008-08-25', '0'), ('4025', '59.42.60.61', '', '', '2', '2008-08-25', '0'), ('4026', '117.92.27.30', '', '', '1', '2008-08-25', '0'), ('4022', '119.120.245.80', '', '', '1', '2008-08-25', '0'), ('4021', '218.9.175.201', '', '', '1', '2008-08-25', '0'), ('4019', '121.33.144.144', '', '', '2', '2008-08-25', '0'), ('4020', '219.131.20.118', '', '', '1', '2008-08-25', '0'), ('4017', '202.160.178.174', '', '', '2', '2008-08-25', '0'), ('4018', '117.84.205.248', '', '', '1', '2008-08-25', '0'), ('4016', '211.136.75.118', '', '', '1', '2008-08-25', '0'), ('4013', '67.195.37.154', '', '', '13', '2008-08-25', '0'), ('4014', '123.147.0.82', '', '', '12', '2008-08-25', '0'), ('4015', '218.90.234.98', '', '', '1', '2008-08-25', '0'), ('4009', '61.186.117.178', '', '', '1', '2008-08-25', '0'), ('4010', '220.181.32.47', '', '', '1', '2008-08-25', '0'), ('4011', '121.13.225.98', '', '', '4', '2008-08-25', '0'), ('4012', '123.184.174.8', '', '', '2', '2008-08-25', '0'), ('2211', '211.136.20.44', '广东', '移动', '0', '2008-08-18', '1'), ('4344', '61.129.192.169', '', '', '1', '2008-08-27', '0'), ('4008', '211.136.228.64', '', '', '13', '2008-08-25', '0'), ('4006', '202.160.180.9', '', '', '1', '2008-08-25', '0'), ('4007', '61.189.240.220', '', '', '1', '2008-08-25', '0'), ('4003', '218.79.21.93', '', '', '1', '2008-08-25', '0'), ('4004', '211.140.16.249', '', '', '34', '2008-08-25', '0'), ('4005', '219.136.13.101', '', '', '490', '2008-08-25', '0'), ('4002', '122.234.19.156', '', '', '1', '2008-08-25', '0'), ('4001', '219.132.112.67', '', '', '1', '2008-08-25', '0'), ('2210', '211.136.199.85', '广东', '移动', '0', '2008-08-18', '1'), ('4000', '211.137.37.131', '', '', '11', '2008-08-25', '0'), ('3999', '209.85.238.17', '', '', '2', '2008-08-25', '0'), ('3998', '61.133.63.215', '', '', '1', '2008-08-25', '0'), ('3997', '121.33.206.60', '', '', '8', '2008-08-25', '0'), ('3996', '60.166.222.232', '', '', '1', '2008-08-25', '0'), ('3995', '221.194.102.145', '', '', '1', '2008-08-25', '0'), ('3994', '58.211.21.94', '', '移动', '0', '2008-10-15', '1'), ('3993', '211.139.162.188', '', '', '24', '2008-08-25', '0'), ('3991', '123.175.183.188', '', '', '53', '2008-08-25', '0'), ('3992', '59.174.29.54', '', '', '1', '2008-08-25', '0'), ('3989', '219.136.218.199', '', '', '6', '2008-08-25', '0'), ('3990', '211.139.146.237', '', '', '29', '2008-08-25', '0'), ('3988', '211.90.119.27', '', '', '8', '2008-08-25', '0'), ('3985', '61.184.98.24', '', '', '1', '2008-08-25', '0'), ('3986', '125.92.34.187', '', '', '1', '2008-08-25', '0'), ('3987', '121.32.156.11', '', '', '1', '2008-08-25', '0'), ('3981', '116.207.162.161', '', '', '1', '2008-08-25', '0'), ('3983', '221.131.61.101', '', '', '2', '2008-08-25', '0'), ('3984', '122.102.9.143', '', '', '1', '2008-08-25', '0'), ('3979', '116.25.224.185', '', '', '1', '2008-08-25', '0'), ('3980', '202.160.179.91', '', '', '1', '2008-08-25', '0'), ('3975', '61.149.21.232', '', '', '1', '2008-08-25', '0'), ('3976', '219.150.121.3', '', '', '1', '2008-08-25', '0'), ('3977', '60.166.173.51', '', '', '1', '2008-08-25', '0'), ('3978', '219.128.212.219', '', '', '2', '2008-08-25', '0'), ('3974', '123.116.130.28', '', '', '1', '2008-08-25', '0'), ('3973', '58.211.21.104', '', '移动', '0', '2008-10-15', '1'), ('3972', '61.135.220.160', '', '', '1', '2008-08-25', '0'), ('3971', '210.241.199.205', '', '', '20', '2008-08-25', '0'), ('3969', '58.61.149.217', '', '', '12', '2008-08-25', '0'), ('3970', '60.178.104.221', '', '', '2', '2008-08-25', '0'), ('3968', '218.202.227.150', '', '', '14', '2008-08-25', '0'), ('3967', '218.58.156.74', '', '', '2', '2008-08-25', '0'), ('4327', '59.109.75.31', '', '', '1', '2008-08-27', '0'), ('3966', '125.91.4.179', '', '移动', '0', '2008-10-15', '1'), ('3964', '123.6.161.233', '', '', '2', '2008-08-25', '0'), ('3965', '202.160.179.12', '', '', '2', '2008-08-25', '0'), ('3963', '218.30.110.162', '', '移动', '0', '2008-10-15', '1'), ('3961', '125.91.253.209', '', '移动', '0', '2008-10-15', '1'), ('3962', '120.7.109.249', '', '', '1', '2008-08-25', '0'), ('3960', '61.148.97.86', '', '', '1', '2008-08-25', '0'), ('3959', '211.136.75.148', '', '', '3', '2008-08-25', '0'), ('3958', '61.144.230.197', '', '', '1', '2008-08-25', '0'), ('3953', '211.138.167.242', '', '', '48', '2008-08-25', '0'), ('3954', '202.160.178.152', '', '', '2', '2008-08-25', '0'), ('3955', '58.211.21.80', '', '移动', '0', '2008-10-15', '1'), ('3956', '211.136.73.100', '', '', '10', '2008-08-25', '0'), ('3957', '222.247.187.137', '', '', '2', '2008-08-25', '0'), ('3952', '61.141.5.38', '', '移动', '0', '2008-10-15', '1'), ('3951', '64.122.13.236', '', '', '7', '2008-08-25', '0'), ('3950', '124.94.127.215', '', '', '1', '2008-08-25', '0'), ('3949', '218.30.110.93', '', '移动', '0', '2008-10-15', '1'), ('2224', '211.136.28.135', '北京', '移动', '0', '2008-08-18', '1'), ('4371', '119.39.177.198', '', '', '1', '2008-08-27', '0'), ('5468', '61.135.168.13', '', '', '2', '2008-09-03', '0'), ('3947', '58.25.228.232', '', '', '1', '2008-08-25', '0'), ('3948', '222.70.0.238', '', '', '1', '2008-08-25', '0'), ('3945', '218.30.107.244', '', '移动', '0', '2008-10-15', '1'), ('3946', '222.246.219.102', '', '', '1', '2008-08-25', '0'), ('3944', '222.219.26.39', '', '', '1', '2008-08-25', '0'), ('3943', '119.141.173.85', '', '', '1', '2008-08-25', '0'), ('3941', '116.16.231.18', '', '', '1', '2008-08-25', '0'), ('3942', '219.145.94.138', '', '', '1', '2008-08-25', '0'), ('3939', '61.141.5.35', '', '移动', '0', '2008-10-15', '1'), ('3940', '222.218.6.141', '', '', '1', '2008-08-25', '0'), ('3937', '123.97.200.2', '', '', '1', '2008-08-25', '0'), ('3938', '211.136.158.33', '', '', '9', '2008-08-25', '0'), ('3936', '211.136.228.245', '', '', '73', '2008-08-25', '0'), ('2207', '211.136.16.4', '青海', '移动', '0', '2008-08-18', '1'), ('3935', '202.160.178.86', '', '', '3', '2008-08-25', '0'), ('3933', '125.81.87.244', '', '', '2', '2008-08-25', '0'), ('3934', '124.193.115.134', '', '', '4', '2008-08-25', '0'), ('5529', '120.87.198.238', '', '', '1', '2008-09-04', '0'), ('3929', '220.231.230.2', '', '', '1', '2008-08-25', '0'), ('3930', '211.137.63.190', '', '', '1', '2008-08-25', '0'), ('3928', '211.139.146.246', '', '', '40', '2008-08-25', '0'), ('3926', '222.210.196.171', '', '', '1', '2008-08-25', '0'), ('3927', '202.160.179.122', '', '', '2', '2008-08-25', '0'), ('2242', '211.138.184.201', '江苏', '移动', '0', '2008-08-18', '1'), ('3924', '202.160.179.51', '', '', '2', '2008-08-25', '0'), ('3925', '219.159.21.151', '', '', '1', '2008-08-25', '0'), ('2265', '211.139.190.202', '广东', '移动', '0', '2008-08-18', '1'), ('3923', '202.160.180.8', '', '', '1', '2008-08-25', '0'), ('3922', '211.139.162.200', '', '', '14', '2008-08-25', '0'), ('2249', '211.139.145.106', '广东', '移动', '0', '2008-08-18', '1'), ('4342', '116.22.143.98', '', '', '1', '2008-08-27', '0'), ('2213', '211.136.222.106', '河北', '移动', '0', '2008-08-18', '1'), ('4356', '116.16.177.140', '', '', '2', '2008-08-27', '0'), ('4331', '121.207.117.200', '', '', '6', '2008-08-27', '0'), ('4332', '218.16.75.86', '', '', '1', '2008-08-27', '0'), ('2256', '211.139.151.42', '广东', '移动', '0', '2008-08-18', '1'), ('4341', '123.112.199.30', '', '', '1', '2008-08-27', '0'), ('3921', '203.208.60.8', '', '', '1', '2008-08-25', '0'), ('3919', '218.20.50.12', '', '', '1', '2008-08-25', '0'), ('3920', '211.139.162.14', '', '', '28', '2008-08-25', '0'), ('2240', '211.138.147.33', '福建', '移动', '0', '2008-08-18', '1'), ('4365', '116.20.126.93', '', '', '2', '2008-08-27', '0'), ('3917', '81.33.52.201', '', '', '1', '2008-08-25', '0'), ('3918', '203.208.60.4', '', '', '3', '2008-08-25', '0'), ('3916', '211.136.75.69', '', '', '3', '2008-08-25', '0'), ('3915', '202.160.179.169', '', '', '1', '2008-08-25', '0'), ('3913', '211.136.75.203', '', '', '1', '2008-08-25', '0'), ('3914', '61.146.230.216', '', '', '1', '2008-08-25', '0'), ('3912', '211.140.16.216', '', '', '40', '2008-08-25', '0'), ('2218', '211.136.222.98', '广东', '移动', '0', '2008-08-18', '1'), ('3910', '203.208.60.1', '', '', '3', '2008-08-25', '0'), ('3911', '121.37.44.13', '', '', '2', '2008-08-25', '0'), ('3909', '220.206.210.252', '', '', '1', '2008-08-25', '0'), ('3908', '202.160.178.154', '', '', '4', '2008-08-25', '0'), ('3907', '211.139.162.11', '', '', '27', '2008-08-25', '0'), ('3906', '202.160.179.39', '', '', '1', '2008-08-25', '0'), ('3905', '202.160.180.100', '', '', '1', '2008-08-25', '0'), ('4323', '58.38.115.57', '', '', '1', '2008-08-27', '0'), ('2264', '211.139.190.125', '广东', '移动', '0', '2008-08-18', '1'), ('3904', '202.160.180.21', '', '', '1', '2008-08-25', '0'), ('3903', '202.160.178.186', '', '', '1', '2008-08-25', '0'), ('3900', '220.181.32.67', '', '', '1', '2008-08-25', '0'), ('3901', '202.160.181.186', '', '', '2', '2008-08-25', '0'), ('3902', '217.201.1.199', '', '', '1', '2008-08-25', '0'), ('3896', '211.138.218.108', '', '', '1', '2008-08-25', '0'), ('3897', '125.91.4.159', '', '移动', '0', '2008-10-15', '1'), ('3899', '202.160.178.105', '', '', '1', '2008-08-25', '0'), ('3895', '211.138.227.161', '', '', '1', '2008-08-25', '0'), ('3894', '74.6.22.179', '', '', '15', '2008-08-25', '0'), ('3893', '211.138.227.136', '', '', '1', '2008-08-25', '0'), ('3892', '222.209.210.57', '', '', '1', '2008-08-25', '0'), ('3891', '219.232.235.95', '', '', '1', '2008-08-25', '0'), ('3890', '219.134.161.79', '', '', '1', '2008-08-25', '0'), ('2291', '218.204.243.10', '广东', '移动', '0', '2008-08-18', '1'), ('3889', '58.60.187.121', '', '', '1', '2008-08-25', '0'), ('3888', '123.136.101.197', '', '', '6', '2008-08-25', '0'), ('3887', '218.30.110.180', '', '移动', '0', '2008-10-15', '1'), ('3886', '222.88.19.14', '', '', '2', '2008-08-25', '0'), ('3885', '58.253.94.60', '', '', '1', '2008-08-25', '0'), ('3884', '211.139.162.9', '', '', '53', '2008-08-25', '0'), ('3882', '116.16.230.106', '', '', '1', '2008-08-25', '0'), ('3883', '218.15.83.242', '', '', '1', '2008-08-25', '0'), ('3881', '58.61.141.24', '', '', '1', '2008-08-25', '0'), ('3879', '59.35.158.174', '', '', '1', '2008-08-25', '0'), ('3880', '217.118.82.46', '', '', '1', '2008-08-25', '0'), ('3878', '121.8.64.133', '', '移动', '1071', '2008-08-25', '1'), ('3877', '59.42.108.130', '', '', '1', '2008-08-25', '0'), ('3873', '202.3.213.212', '', '', '2', '2008-08-25', '0'), ('5528', '119.234.1.5', '', '', '1', '2008-09-03', '0'), ('3875', '120.87.203.219', '', '', '1', '2008-08-25', '0'), ('3876', '202.160.178.247', '', '', '2', '2008-08-25', '0'), ('3871', '116.10.84.241', '', '', '2', '2008-08-25', '0'), ('3872', '202.65.247.145', '', '', '52', '2008-08-25', '0'), ('3870', '116.4.4.201', '', '', '1', '2008-08-25', '0'), ('3869', '81.199.102.129', '', '', '1', '2008-08-25', '0'), ('3868', '203.208.60.28', '', '', '2', '2008-08-25', '0'), ('2246', '211.138.45.11', '新疆', '移动', '0', '2008-08-18', '1'), ('4357', '220.200.170.137', '', '', '1', '2008-08-27', '0'), ('3865', '220.206.246.19', '', '', '1', '2008-08-25', '0'), ('3866', '125.36.150.88', '', '', '1', '2008-08-25', '0'), ('3867', '203.208.60.12', '', '', '279', '2008-08-25', '0'), ('3864', '117.24.36.171', '', '', '1', '2008-08-25', '0'), ('3863', '121.11.241.170', '', '', '5', '2008-08-25', '0'), ('3862', '125.91.253.166', '', '移动', '0', '2008-10-15', '1'), ('3861', '58.211.21.76', '', '移动', '0', '2008-10-15', '1'), ('3860', '125.91.5.54', '', '移动', '0', '2008-10-15', '1'), ('3859', '220.194.55.46', '', '', '2', '2008-08-25', '0'), ('3857', '220.206.246.10', '', '', '1', '2008-08-24', '0'), ('3858', '119.112.251.117', '', '', '1', '2008-08-24', '0'), ('3856', '209.88.128.18', '', '', '1', '2008-08-24', '0'), ('3854', '58.211.21.92', '', '移动', '0', '2008-10-15', '1'), ('3855', '125.69.15.52', '', '', '1', '2008-08-24', '0'), ('2235', '211.137.62.197', '广西', '移动', '0', '2008-08-18', '1'), ('3853', '66.249.71.149', '', '', '1', '2008-08-24', '0'), ('3852', '211.136.73.75', '', '', '9', '2008-08-24', '0'), ('3851', '211.140.16.227', '', '', '40', '2008-08-24', '0'), ('3850', '211.137.62.211', '', '', '2', '2008-08-24', '0'), ('3849', '58.248.166.231', '', '', '1', '2008-08-24', '0'), ('5527', '211.137.41.25', '', '', '1', '2008-09-03', '0'), ('3847', '202.93.36.60', '', '', '22', '2008-08-24', '0'), ('3845', '59.35.109.14', '', '', '2', '2008-08-24', '0'), ('3846', '218.30.107.233', '', '移动', '0', '2008-10-15', '1'), ('3844', '219.131.117.108', '', '', '1', '2008-08-24', '0'), ('3843', '60.20.137.178', '', '', '1', '2008-08-24', '0'), ('3840', '121.228.29.187', '', '', '1', '2008-08-24', '0'), ('3841', '211.100.34.37', '', '', '52', '2008-08-24', '0'), ('3842', '218.57.57.52', '', '', '1', '2008-08-24', '0'), ('2506', '211.96.28.105', '广东', '联通', '0', '2008-08-20', '1'), ('3839', '117.84.120.45', '', '', '2', '2008-08-24', '0'), ('3838', '58.211.21.70', '', '移动', '0', '2008-10-15', '1'), ('3837', '218.30.110.185', '', '移动', '0', '2008-10-15', '1'), ('3836', '202.160.178.101', '', '', '2', '2008-08-24', '0'), ('2220', '211.136.228.89', '广东', '移动', '0', '2008-08-18', '1'), ('4360', '61.141.5.36', '', '移动', '0', '2008-10-15', '1'), ('3835', '220.231.121.31', '', '', '1', '2008-08-24', '0'), ('3834', '123.147.2.117', '', '', '1', '2008-08-24', '0'), ('3833', '125.91.253.243', '', '移动', '0', '2008-10-15', '1'), ('3829', '211.137.41.26', '', '', '2', '2008-08-24', '0'), ('3830', '58.211.21.85', '', '移动', '0', '2008-10-15', '1'), ('3831', '218.30.117.4', '', '移动', '0', '2008-10-15', '1'), ('3832', '211.137.197.61', '', '', '7', '2008-08-24', '0'), ('3828', '59.61.206.226', '', '', '2', '2008-08-24', '0'), ('3827', '59.37.33.206', '', '', '1', '2008-08-24', '0'), ('2286', '218.202.106.201', '辽宁', '移动', '0', '2008-08-18', '1'), ('4324', '116.16.157.159', '', '', '1', '2008-08-27', '0'), ('3826', '58.62.212.205', '', '', '1', '2008-08-24', '0'), ('3825', '211.136.199.74', '', '', '52', '2008-08-24', '0'), ('3824', '218.77.97.5', '', '', '1', '2008-08-24', '0'), ('3822', '211.140.16.209', '', '', '42', '2008-08-24', '0'), ('3823', '125.91.253.140', '', '移动', '0', '2008-10-15', '1'), ('3821', '202.160.179.27', '', '', '1', '2008-08-24', '0'), ('3820', '61.18.170.53', '', '', '1', '2008-08-24', '0'), ('3818', '218.14.187.6', '', '', '1', '2008-08-24', '0'), ('3819', '61.18.170.34', '', '', '1', '2008-08-24', '0'), ('3817', '221.13.89.124', '', '', '1', '2008-08-24', '0'), ('3816', '74.6.22.174', '', '', '1', '2008-08-24', '0'), ('3814', '123.11.24.33', '', '', '1', '2008-08-24', '0'), ('3815', '221.179.17.3', '', '', '42', '2008-08-24', '0'), ('3812', '125.67.184.193', '', '', '1', '2008-08-24', '0'), ('3813', '222.82.1.40', '', '', '1', '2008-08-24', '0'), ('3809', '221.130.33.197', '', '', '1', '2008-08-24', '0'), ('3810', '125.64.55.152', '', '', '1', '2008-08-24', '0'), ('3811', '121.29.0.82', '', '', '3', '2008-08-24', '0'), ('3808', '125.85.240.165', '', '', '1', '2008-08-24', '0'), ('3806', '202.160.178.206', '', '', '4', '2008-08-24', '0'), ('3807', '61.145.36.111', '', '', '1', '2008-08-24', '0'), ('3805', '219.132.115.145', '', '', '2', '2008-08-24', '0'), ('3798', '202.160.180.210', '', '', '2', '2008-08-24', '0'), ('3799', '61.152.153.106', '', '', '8', '2008-08-24', '0'), ('3800', '222.89.45.98', '', '', '1', '2008-08-24', '0'), ('3801', '220.181.32.51', '', '', '10', '2008-08-24', '0'), ('3802', '210.75.9.68', '', '', '1', '2008-08-24', '0'), ('3803', '125.34.21.50', '', '', '1', '2008-08-24', '0'), ('3804', '222.245.188.182', '', '', '1', '2008-08-24', '0'), ('3797', '119.121.4.120', '', '', '1', '2008-08-24', '0'), ('2254', '211.139.148.45', '广东', '移动', '0', '2008-08-18', '1'), ('2206', '211.136.158.34', '上海', '移动', '0', '2008-08-18', '1'), ('3796', '116.26.148.111', '', '', '1', '2008-08-24', '0'), ('3794', '123.151.137.156', '', '', '1', '2008-08-24', '0'), ('3795', '220.206.233.23', '', '', '1', '2008-08-24', '0'), ('2299', '221.130.33.135', '北京', '移动', '0', '2008-08-18', '1'), ('3793', '202.160.181.184', '', '', '4', '2008-08-24', '0'), ('3789', '58.61.206.29', '', '', '1', '2008-08-24', '0'), ('3790', '203.145.92.85', '', '', '1', '2008-08-24', '0'), ('3791', '219.135.145.148', '', '', '1', '2008-08-24', '0'), ('3792', '211.140.16.250', '', '', '21', '2008-08-24', '0'), ('3788', '61.135.168.50', '', '', '7', '2008-08-24', '0'), ('3785', '218.88.157.208', '', '', '1', '2008-08-24', '0'), ('3786', '58.211.21.79', '', '移动', '0', '2008-10-15', '1'), ('3787', '59.36.135.182', '', '', '1', '2008-08-24', '0'), ('3784', '59.37.233.226', '', '', '2', '2008-08-24', '0'), ('3783', '116.30.170.69', '', '', '1', '2008-08-24', '0'), ('3782', '221.9.52.204', '', '', '1', '2008-08-24', '0'), ('3780', '211.139.162.205', '', '', '16', '2008-08-24', '0'), ('3781', '211.140.16.231', '', '', '41', '2008-08-24', '0'), ('3778', '218.200.224.219', '', '', '2', '2008-08-24', '0'), ('3779', '220.181.32.62', '', '', '1', '2008-08-24', '0'), ('3776', '220.170.153.9', '', '', '1', '2008-08-24', '0'), ('3775', '218.15.88.81', '', '', '1', '2008-08-24', '0'), ('3774', '218.93.13.66', '', '', '1', '2008-08-24', '0'), ('3773', '202.160.180.201', '', '', '1', '2008-08-24', '0'), ('3771', '202.160.179.163', '', '', '2', '2008-08-24', '0'), ('3772', '219.93.152.130', '', '', '4', '2008-08-24', '0'), ('3769', '116.20.150.247', '', '', '3', '2008-08-24', '0'), ('3770', '125.91.4.148', '', '移动', '0', '2008-10-15', '1'), ('3768', '195.189.142.50', '', '', '3', '2008-08-24', '0'), ('3767', '203.208.60.30', '', '', '1', '2008-08-24', '0'), ('3766', '203.208.60.14', '', '', '2', '2008-08-24', '0'), ('3765', '125.91.253.213', '', '移动', '0', '2008-10-15', '1'), ('3764', '203.208.60.22', '', '', '35', '2008-08-24', '0'), ('3763', '60.48.57.181', '', '', '1', '2008-08-24', '0'), ('3762', '91.203.96.24', '', '', '2', '2008-08-24', '0'), ('3760', '125.45.50.170', '', '', '1', '2008-08-24', '0'), ('3761', '202.160.180.150', '', '', '3', '2008-08-24', '0'), ('3759', '211.140.16.204', '', '', '52', '2008-08-24', '0'), ('3758', '211.137.197.67', '', '', '61', '2008-08-24', '0'), ('3756', '58.211.21.100', '', '移动', '0', '2008-10-15', '1'), ('3757', '202.160.178.164', '', '', '1', '2008-08-24', '0'), ('3755', '60.173.146.10', '', '', '1', '2008-08-24', '0'), ('3754', '119.32.13.60', '', '', '4', '2008-08-24', '0'), ('3753', '222.141.170.207', '', '', '1', '2008-08-24', '0'), ('3752', '218.13.26.167', '', '', '1', '2008-08-24', '0'), ('3749', '221.15.104.33', '', '', '2', '2008-08-24', '0'), ('3750', '58.52.90.96', '', '', '3', '2008-08-24', '0'), ('3751', '211.139.146.198', '', '', '13', '2008-08-24', '0'), ('3748', '218.30.110.88', '', '移动', '0', '2008-10-15', '1'), ('3744', '211.139.190.122', '', '', '13', '2008-08-24', '0'), ('3745', '211.139.90.252', '', '', '46', '2008-08-24', '0'), ('3746', '211.136.158.249', '', '', '1', '2008-08-24', '0'), ('3747', '222.90.143.118', '', '', '2', '2008-08-24', '0'), ('3743', '60.211.64.189', '', '', '1', '2008-08-24', '0'), ('3741', '195.189.142.235', '', '', '2', '2008-08-24', '0'), ('3742', '211.136.158.182', '', '', '5', '2008-08-24', '0'), ('3740', '58.62.119.224', '', '', '7', '2008-08-24', '0'), ('2274', '211.141.86.10', '广东', '移动', '0', '2008-08-18', '1'), ('5526', '222.129.19.107', '', '', '1', '2008-09-03', '0'), ('3739', '202.93.37.88', '', '', '3', '2008-08-24', '0'), ('3736', '211.140.16.219', '', '', '26', '2008-08-24', '0'), ('3737', '123.128.200.226', '', '', '1', '2008-08-24', '0'), ('3735', '125.91.253.204', '', '移动', '0', '2008-10-15', '1'), ('3734', '61.144.118.116', '', '', '5', '2008-08-24', '0'), ('3733', '219.147.229.17', '', '', '1', '2008-08-24', '0'), ('3732', '220.181.61.225', '', '', '203', '2008-08-24', '0'), ('3731', '211.136.228.93', '', '', '20', '2008-08-24', '0'), ('3730', '222.35.120.86', '', '', '2', '2008-08-24', '0'), ('3729', '125.91.93.162', '', '', '13', '2008-08-24', '0'), ('3727', '222.221.247.194', '', '', '1', '2008-08-24', '0'), ('3728', '211.140.16.211', '', '', '30', '2008-08-24', '0'), ('3725', '218.59.54.134', '', '', '2', '2008-08-24', '0'), ('3726', '125.91.52.188', '', '', '2', '2008-08-24', '0'), ('3721', '211.139.90.250', '', '', '38', '2008-08-24', '0'), ('3722', '211.136.158.161', '', '', '4', '2008-08-24', '0'), ('3723', '211.138.201.149', '', '', '28', '2008-08-24', '0'), ('3724', '218.64.80.18', '', '', '2', '2008-08-24', '0'), ('3720', '61.135.168.21', '', '', '1', '2008-08-24', '0'), ('3719', '61.183.220.158', '', '', '7', '2008-08-24', '0'), ('3717', '202.160.179.133', '', '', '1', '2008-08-24', '0'), ('3718', '211.136.73.72', '', '', '18', '2008-08-24', '0'), ('3716', '60.187.52.170', '', '', '1', '2008-08-24', '0'), ('2282', '218.200.244.69', '广东', '移动', '0', '2008-08-18', '1'), ('4325', '211.136.75.145', '', '', '2', '2008-08-27', '0'), ('3715', '211.136.158.239', '', '', '3', '2008-08-24', '0'), ('3714', '211.138.205.197', '', '', '12', '2008-08-24', '0'), ('3713', '211.136.158.132', '', '', '3', '2008-08-24', '0'), ('3711', '124.129.49.245', '', '', '1', '2008-08-24', '0'), ('3712', '218.30.110.181', '', '移动', '0', '2008-10-15', '1'), ('3710', '218.6.128.28', '', '', '13', '2008-08-24', '0'), ('3707', '211.137.41.12', '', '', '1', '2008-08-24', '0'), ('3708', '116.25.130.250', '', '', '1', '2008-08-24', '0'), ('3709', '194.47.45.199', '', '', '1', '2008-08-24', '0'), ('3706', '202.160.178.57', '', '', '1', '2008-08-24', '0'), ('3705', '218.200.225.13', '', '', '3', '2008-08-24', '0'), ('3704', '60.19.132.27', '', '', '2', '2008-08-24', '0'), ('3703', '202.160.180.144', '', '', '4', '2008-08-24', '0'), ('2202', '211.103.89.81', '天津', '移动', '0', '2008-08-18', '1'), ('2751', '219.143.154.181', '', '', '4', '2008-08-21', '0'), ('3702', '211.139.16.180', '', '', '62', '2008-08-24', '0'), ('2248', '211.138.5.46', '河北', '移动', '0', '2008-08-18', '1'), ('3701', '119.234.0.15', '', '', '3', '2008-08-24', '0'), ('3700', '218.30.110.173', '', '移动', '0', '2008-10-15', '1'), ('3699', '211.139.146.222', '', '', '45', '2008-08-24', '0'), ('3698', '221.194.113.35', '', '', '20', '2008-08-24', '0'), ('2209', '211.136.199.84', '广东', '移动', '0', '2008-08-18', '1'), ('3695', '218.200.225.14', '', '', '7', '2008-08-24', '0'), ('3696', '202.160.178.175', '', '', '2', '2008-08-24', '0'), ('3697', '202.160.180.162', '', '', '4', '2008-08-24', '0'), ('5525', '221.221.29.124', '', '', '1', '2008-09-03', '0'), ('3693', '211.140.16.229', '', '', '29', '2008-08-24', '0'), ('3694', '202.160.178.210', '', '', '1', '2008-08-24', '0'), ('3691', '66.249.71.251', '', '', '1', '2008-08-24', '0'), ('3688', '211.136.228.71', '', '', '15', '2008-08-24', '0'), ('3689', '211.138.28.180', '', '', '62', '2008-08-24', '0'), ('3687', '211.136.158.51', '', '', '23', '2008-08-24', '0'), ('3686', '222.79.96.243', '', '', '4', '2008-08-24', '0'), ('3685', '195.189.142.243', '', '', '1', '2008-08-24', '0'), ('3684', '202.160.178.198', '', '', '5', '2008-08-24', '0'), ('3679', '211.138.218.41', '', '', '1', '2008-08-24', '0'), ('3680', '202.160.180.119', '', '', '1', '2008-08-24', '0'), ('3681', '202.160.179.161', '', '', '2', '2008-08-24', '0'), ('3682', '218.200.225.3', '', '', '8', '2008-08-24', '0'), ('3683', '222.77.138.42', '', '', '1', '2008-08-24', '0'), ('3678', '58.71.139.27', '', '', '17', '2008-08-24', '0'), ('3676', '218.30.110.175', '', '移动', '0', '2008-10-15', '1'), ('3677', '117.57.254.135', '', '', '1', '2008-08-24', '0'), ('3675', '202.160.179.110', '', '', '2', '2008-08-24', '0'), ('2275', '211.142.189.202', '广东', '移动', '0', '2008-08-18', '1'), ('3674', '211.140.16.226', '', '', '23', '2008-08-24', '0'), ('3673', '202.4.192.75', '', '', '11', '2008-08-24', '0'), ('3672', '221.179.17.5', '', '', '16', '2008-08-24', '0'), ('3671', '61.135.168.133', '', '', '156', '2008-08-24', '0'), ('3670', '211.137.197.53', '', '', '1', '2008-08-24', '0'), ('3669', '195.189.143.60', '', '', '2', '2008-08-24', '0'), ('2219', '211.136.228.249', '广东', '移动', '0', '2008-08-18', '1'), ('4370', '125.78.111.204', '', '', '1', '2008-08-27', '0'), ('3668', '211.139.162.177', '', '', '17', '2008-08-24', '0'), ('3667', '125.91.253.168', '', '移动', '0', '2008-10-15', '1'), ('3666', '202.93.37.90', '', '', '12', '2008-08-24', '0'), ('2292', '218.204.243.42', '广东', '移动', '0', '2008-08-18', '1'), ('3665', '211.139.146.230', '', '', '20', '2008-08-24', '0'), ('3664', '60.10.2.77', '', '', '4', '2008-08-24', '0'), ('3663', '125.91.253.254', '', '移动', '0', '2008-10-15', '1'), ('3661', '58.47.46.233', '', '', '4', '2008-08-24', '0'), ('3662', '202.91.19.201', '', '', '4', '2008-08-24', '0'), ('3660', '195.189.142.222', '', '', '2', '2008-08-24', '0'), ('3657', '125.91.253.246', '', '移动', '0', '2008-10-15', '1'), ('3658', '220.181.32.41', '', '', '1', '2008-08-24', '0'), ('3659', '125.91.253.220', '', '移动', '0', '2008-10-15', '1'), ('3656', '116.20.38.49', '', '', '2', '2008-08-24', '0'), ('3655', '218.30.107.229', '', '移动', '0', '2008-10-15', '1'), ('3654', '125.91.253.208', '', '移动', '0', '2008-10-15', '1'), ('3653', '211.139.162.13', '', '', '22', '2008-08-24', '0'), ('3652', '211.139.162.179', '', '', '17', '2008-08-24', '0'), ('3651', '61.141.5.22', '', '移动', '0', '2008-10-15', '1'), ('3650', '211.139.162.168', '', '', '21', '2008-08-24', '0'), ('3649', '218.30.110.164', '', '移动', '0', '2008-10-15', '1'), ('3648', '125.84.239.81', '', '', '1', '2008-08-24', '0'), ('3647', '122.224.187.52', '', '', '1', '2008-08-24', '0'), ('3645', '222.84.156.115', '', '', '1', '2008-08-24', '0'), ('3646', '211.136.199.77', '', '', '55', '2008-08-24', '0'), ('3644', '220.206.235.106', '', '', '5', '2008-08-24', '0'), ('3643', '125.91.253.205', '', '移动', '0', '2008-10-15', '1'), ('3642', '222.82.246.2', '', '', '2', '2008-08-23', '0'), ('3641', '218.30.110.170', '', '移动', '0', '2008-10-15', '1'), ('3638', '211.138.227.186', '', '', '1', '2008-08-23', '0'), ('3639', '125.91.253.223', '', '移动', '0', '2008-10-15', '1'), ('3640', '121.21.200.87', '', '', '10', '2008-08-23', '0'), ('5523', '121.8.7.76', '', '', '2', '2008-09-03', '0'), ('3636', '125.91.253.252', '', '移动', '0', '2008-10-15', '1'), ('3637', '211.139.190.133', '', '', '11', '2008-08-23', '0'), ('3634', '203.81.19.15', '', '', '16', '2008-08-23', '0'), ('5524', '195.189.143.59', '', '', '1', '2008-09-03', '0'), ('3631', '125.88.202.250', '', '', '1', '2008-08-23', '0'), ('3632', '116.16.70.27', '', '', '1', '2008-08-23', '0'), ('3633', '58.48.205.170', '', '', '1', '2008-08-23', '0'), ('3630', '202.160.180.74', '', '', '3', '2008-08-23', '0'), ('2304', '61.141.5.42', '广东', '移动', '0', '2008-08-18', '1'), ('5522', '220.206.235.14', '', '', '2', '2008-09-03', '0'), ('3628', '211.136.75.97', '', '', '7', '2008-08-23', '0'), ('3627', '125.91.253.206', '', '移动', '0', '2008-10-15', '1'), ('5521', '222.85.39.234', '', '', '8', '2008-09-03', '0'), ('3626', '58.211.21.98', '', '移动', '0', '2008-10-15', '1'), ('3624', '222.214.172.170', '', '', '1', '2008-08-23', '0'), ('3623', '125.91.52.13', '', '', '2', '2008-08-23', '0'), ('3622', '218.203.60.50', '', '', '29', '2008-08-23', '0'), ('3621', '219.130.15.31', '', '', '1', '2008-08-23', '0'), ('3620', '218.30.110.183', '', '移动', '0', '2008-10-15', '1'), ('2293', '218.205.237.10', '四川', '移动', '0', '2008-08-18', '1'), ('3619', '68.162.135.175', '', '', '1', '2008-08-23', '0'), ('3618', '211.140.16.217', '', '', '37', '2008-08-23', '0'), ('3617', '58.255.238.80', '', '', '1', '2008-08-23', '0'), ('3616', '211.96.20.46', '', '', '43', '2008-08-23', '0'), ('3614', '211.138.205.196', '', '', '25', '2008-08-23', '0'), ('3615', '59.61.205.194', '', '', '1', '2008-08-23', '0'), ('2234', '211.137.59.23', '湖北', '移动', '0', '2008-08-18', '1'), ('3613', '59.56.174.139', '', '', '10', '2008-08-23', '0'), ('3612', '116.23.50.150', '', '', '2', '2008-08-23', '0'), ('3611', '58.211.21.91', '', '移动', '0', '2008-10-15', '1'), ('5520', '211.137.197.60', '', '', '2', '2008-09-03', '0'), ('3610', '202.47.111.228', '', '', '77', '2008-08-23', '0'), ('3608', '211.139.146.203', '', '', '18', '2008-08-23', '0'), ('5519', '219.76.81.207', '', '', '2', '2008-09-03', '0'), ('3606', '202.160.42.73', '', '', '3', '2008-08-23', '0'), ('5518', '195.189.142.141', '', '', '2', '2008-09-03', '0'), ('3604', '116.4.147.246', '', '', '3', '2008-08-23', '0'), ('3603', '220.206.229.5', '', '', '80', '2008-08-23', '0'), ('3602', '58.211.21.73', '', '移动', '0', '2008-10-15', '1'), ('3601', '211.137.63.85', '', '', '2', '2008-08-23', '0'), ('3598', '122.231.87.62', '', '', '2', '2008-08-23', '0'), ('3599', '125.91.4.155', '', '移动', '0', '2008-10-15', '1'), ('3600', '220.113.91.197', '', '', '1', '2008-08-23', '0'), ('3597', '119.123.105.39', '', '', '1', '2008-08-23', '0'), ('5517', '203.78.120.137', '', '', '2', '2008-09-03', '0'), ('3592', '123.30.87.2', '', '', '1', '2008-08-23', '0'), ('3593', '195.189.142.228', '', '', '1', '2008-08-23', '0'), ('3594', '219.234.85.236', '', '', '3', '2008-08-23', '0'), ('3591', '218.30.110.172', '', '移动', '0', '2008-10-15', '1'), ('3590', '119.121.1.212', '', '', '1', '2008-08-23', '0'), ('3588', '202.105.248.107', '', '', '3', '2008-08-23', '0'), ('3589', '211.136.228.76', '', '', '15', '2008-08-23', '0'), ('5516', '74.6.22.158', '', '', '94', '2008-09-03', '0'), ('3586', '211.136.158.241', '', '', '5', '2008-08-23', '0'), ('3585', '121.35.101.4', '', '', '1', '2008-08-23', '0'), ('3584', '211.138.227.198', '', '', '1', '2008-08-23', '0'), ('3583', '218.30.110.176', '', '移动', '0', '2008-10-15', '1'), ('3582', '211.136.228.78', '', '', '27', '2008-08-23', '0'), ('3581', '211.140.16.236', '', '', '35', '2008-08-23', '0'), ('3580', '81.18.116.69', '', '', '6', '2008-08-23', '0'), ('2271', '211.140.16.2', '浙江', '移动', '0', '2008-08-18', '1'), ('3577', '218.30.107.238', '', '移动', '0', '2008-10-15', '1'), ('3578', '219.136.158.180', '', '', '4', '2008-08-23', '0'), ('3579', '218.30.110.182', '', '移动', '0', '2008-10-15', '1'), ('3573', '211.140.16.246', '', '', '37', '2008-08-23', '0'), ('3574', '211.137.62.241', '', '', '1', '2008-08-23', '0'), ('3575', '218.205.249.204', '', '', '1', '2008-08-23', '0'), ('3576', '119.234.1.1', '', '', '1', '2008-08-23', '0'), ('3571', '125.91.4.152', '', '移动', '0', '2008-10-15', '1'), ('3572', '211.139.146.214', '', '', '40', '2008-08-23', '0'), ('3570', '125.73.190.57', '', '', '1', '2008-08-23', '0'), ('3569', '220.206.246.44', '', '', '1', '2008-08-23', '0'), ('3568', '220.206.198.2', '', '', '36', '2008-08-23', '0'), ('3567', '117.91.33.161', '', '', '1', '2008-08-23', '0'), ('3565', '222.248.133.238', '', '', '1', '2008-08-23', '0'), ('3566', '121.34.249.97', '', '', '1', '2008-08-23', '0'), ('3564', '222.213.127.198', '', '', '1', '2008-08-23', '0'), ('2883', '61.141.5.34', '', '移动', '0', '2008-10-15', '1'), ('3562', '222.88.254.13', '', '', '1', '2008-08-23', '0'), ('3563', '211.139.190.117', '', '', '26', '2008-08-23', '0'), ('3561', '119.123.154.137', '', '', '1', '2008-08-23', '0'), ('3560', '116.16.26.233', '', '', '1', '2008-08-23', '0'), ('3559', '220.207.233.211', '', '', '1', '2008-08-23', '0'), ('3558', '125.91.253.219', '', '移动', '0', '2008-10-15', '1'), ('3557', '61.146.41.218', '', '', '1', '2008-08-23', '0'), ('3556', '211.139.146.212', '', '', '44', '2008-08-23', '0'), ('3555', '222.50.29.59', '', '', '1', '2008-08-23', '0'), ('3553', '218.30.110.87', '', '移动', '0', '2008-10-15', '1'), ('3554', '222.88.254.226', '', '', '1', '2008-08-23', '0'), ('2882', '61.135.168.161', '', '', '105', '2008-08-21', '0'), ('2881', '125.91.4.178', '', '移动', '0', '2008-10-15', '1'), ('2880', '219.134.136.49', '', '', '1', '2008-08-21', '0'), ('2879', '218.29.237.90', '', '', '1', '2008-08-21', '0'), ('2877', '58.211.21.88', '', '移动', '0', '2008-10-15', '1'), ('2878', '218.30.107.240', '', '移动', '0', '2008-10-15', '1'), ('2858', '211.137.197.69', '', '', '142', '2008-08-21', '0'), ('2859', '211.138.106.209', '', '', '231', '2008-08-21', '0'), ('2861', '220.174.192.202', '', '', '1', '2008-08-21', '0'), ('2862', '218.30.110.165', '', '移动', '0', '2008-10-15', '1'), ('2863', '211.139.146.216', '', '', '44', '2008-08-21', '0'), ('2864', '211.139.146.228', '', '', '38', '2008-08-21', '0'), ('2865', '218.202.227.157', '', '', '25', '2008-08-21', '0'), ('2866', '218.30.110.188', '', '移动', '0', '2008-10-15', '1'), ('2867', '61.135.166.31', '', '', '1', '2008-08-21', '0'), ('2868', '125.91.253.214', '', '移动', '0', '2008-10-15', '1'), ('2869', '211.139.146.235', '', '', '25', '2008-08-21', '0'), ('2870', '220.206.246.29', '', '', '10', '2008-08-21', '0'), ('2871', '219.234.85.223', '', '', '13', '2008-08-21', '0'), ('2872', '218.30.110.189', '', '移动', '0', '2008-10-15', '1'), ('2873', '211.140.16.205', '', '', '37', '2008-08-21', '0'), ('2874', '211.140.16.200', '', '', '59', '2008-08-21', '0'), ('2875', '117.67.154.28', '', '', '1', '2008-08-21', '0'), ('2876', '211.137.163.29', '', '', '22', '2008-08-21', '0'), ('2294', '218.205.237.42', '四川', '移动', '0', '2008-08-18', '1'), ('3551', '211.140.103.178', '', '', '1', '2008-08-23', '0'), ('3548', '202.160.178.161', '', '', '3', '2008-08-23', '0'), ('3549', '202.160.179.22', '', '', '1', '2008-08-23', '0'), ('3550', '220.206.206.3', '', '', '17', '2008-08-23', '0'), ('3547', '125.67.105.166', '', '', '1', '2008-08-23', '0'), ('3546', '211.137.197.49', '', '', '2', '2008-08-23', '0'), ('3545', '114.138.235.249', '', '', '1', '2008-08-23', '0'), ('3544', '211.139.162.175', '', '', '14', '2008-08-23', '0'), ('3543', '121.25.58.1', '', '', '1', '2008-08-23', '0'), ('3542', '116.4.177.48', '', '', '1', '2008-08-23', '0'), ('3541', '222.190.98.122', '', '', '1', '2008-08-23', '0'), ('3540', '211.136.158.49', '', '', '23', '2008-08-23', '0'), ('3539', '125.91.253.194', '', '移动', '0', '2008-10-15', '1'), ('3538', '220.255.7.228', '', '', '1', '2008-08-23', '0'), ('3536', '218.200.225.7', '', '', '13', '2008-08-23', '0'), ('3537', '121.33.147.129', '', '', '1', '2008-08-23', '0'), ('3535', '61.140.27.239', '', '', '1', '2008-08-23', '0'), ('3534', '211.140.16.228', '', '', '50', '2008-08-23', '0'), ('3533', '211.137.163.30', '', '', '12', '2008-08-23', '0'), ('3532', '125.91.253.248', '', '移动', '0', '2008-10-15', '1'), ('3530', '121.227.198.169', '', '', '1', '2008-08-23', '0'), ('3531', '125.91.253.167', '', '移动', '0', '2008-10-15', '1'), ('3528', '211.136.228.75', '', '', '29', '2008-08-23', '0'), ('3529', '202.160.179.83', '', '', '1', '2008-08-23', '0'), ('3526', '125.91.5.51', '', '移动', '0', '2008-10-15', '1'), ('3527', '61.135.168.129', '', '', '6', '2008-08-23', '0'), ('3524', '211.136.158.229', '', '', '6', '2008-08-23', '0'), ('3525', '125.91.253.240', '', '移动', '0', '2008-10-15', '1'), ('3523', '218.58.78.34', '', '', '1', '2008-08-23', '0'), ('3522', '219.134.87.31', '', '', '1', '2008-08-23', '0'), ('2297', '221.130.199.75', '广东', '移动', '0', '2008-08-18', '1'), ('3520', '116.208.188.166', '', '', '2', '2008-08-23', '0'), ('3518', '222.215.72.132', '', '', '1', '2008-08-23', '0'), ('3519', '91.203.96.20', '', '', '2', '2008-08-23', '0'), ('3517', '211.139.146.211', '', '', '47', '2008-08-23', '0'), ('3516', '120.129.93.84', '', '', '1', '2008-08-23', '0'), ('3515', '211.139.146.250', '', '', '32', '2008-08-23', '0'), ('3514', '61.145.46.35', '', '', '1', '2008-08-23', '0'), ('3513', '61.146.243.1', '', '', '1', '2008-08-23', '0'), ('5515', '121.15.12.113', '', '', '1', '2008-09-03', '0'), ('3511', '123.10.65.108', '', '', '2', '2008-08-23', '0'), ('3510', '60.168.116.230', '', '', '1', '2008-08-23', '0'), ('3509', '220.186.183.210', '', '', '1', '2008-08-23', '0'), ('3508', '218.24.12.22', '', '', '2', '2008-08-23', '0'), ('3506', '211.139.146.226', '', '', '32', '2008-08-23', '0'), ('3507', '211.139.90.251', '', '', '22', '2008-08-23', '0'), ('3505', '211.137.63.179', '', '', '1', '2008-08-23', '0'), ('3504', '125.91.253.238', '', '移动', '0', '2008-10-15', '1'), ('3503', '211.139.146.232', '', '', '31', '2008-08-23', '0'), ('3500', '125.91.253.236', '', '移动', '0', '2008-10-15', '1'), ('3501', '211.139.146.234', '', '', '22', '2008-08-23', '0'), ('3502', '222.217.224.96', '', '', '1', '2008-08-23', '0'), ('2263', '211.139.190.123', '广东', '移动', '0', '2008-08-18', '1'), ('3499', '116.23.40.72', '', '', '1', '2008-08-23', '0'), ('3495', '211.136.228.240', '', '', '98', '2008-08-23', '0'), ('3496', '211.137.63.155', '', '', '4', '2008-08-23', '0'), ('3497', '211.139.162.206', '', '', '36', '2008-08-23', '0'), ('5514', '222.183.73.17', '', '', '4', '2008-09-03', '0'), ('3494', '125.91.253.199', '', '移动', '0', '2008-10-15', '1'), ('3492', '211.136.199.82', '', '', '67', '2008-08-23', '0'), ('3493', '195.189.142.49', '', '', '2', '2008-08-23', '0'), ('3491', '123.114.173.206', '', '', '1', '2008-08-23', '0'), ('3488', '218.200.225.4', '', '', '8', '2008-08-23', '0'), ('3489', '218.79.226.100', '', '', '1', '2008-08-23', '0'), ('3490', '119.122.210.184', '', '', '2', '2008-08-23', '0'), ('5513', '125.115.219.95', '', '', '2', '2008-09-03', '0'), ('3485', '123.155.75.44', '', '', '2', '2008-08-23', '0'), ('3486', '121.9.173.222', '', '', '1', '2008-08-23', '0'), ('3487', '222.210.161.7', '', '', '1', '2008-08-23', '0'), ('3483', '61.135.168.168', '', '', '1', '2008-08-23', '0'), ('3480', '211.144.95.25', '', '', '4', '2008-08-23', '0'), ('3481', '125.91.253.242', '', '移动', '0', '2008-10-15', '1'), ('3482', '220.178.4.158', '', '', '1', '2008-08-23', '0'), ('3477', '125.91.253.234', '', '移动', '0', '2008-10-15', '1'), ('3478', '61.135.168.94', '', '', '6', '2008-08-23', '0'), ('3479', '211.137.181.253', '', '', '8', '2008-08-23', '0'), ('3475', '74.6.8.113', '', '', '33', '2008-08-23', '0'), ('3476', '195.189.142.83', '', '', '2', '2008-08-23', '0'), ('3474', '58.60.14.231', '', '', '3', '2008-08-23', '0'), ('3473', '121.14.96.153', '', '', '1', '2008-08-23', '0'), ('3472', '58.60.14.241', '', '', '3', '2008-08-23', '0'), ('3469', '59.36.63.226', '', '', '1', '2008-08-23', '0'), ('3470', '218.200.225.5', '', '', '3', '2008-08-23', '0'), ('3471', '211.139.146.238', '', '', '37', '2008-08-23', '0'), ('3467', '218.19.248.13', '', '', '2', '2008-08-23', '0'), ('3468', '219.129.83.13', '', '', '12', '2008-08-23', '0'), ('5512', '124.64.242.120', '', '', '4', '2008-09-03', '0'), ('3465', '218.30.110.178', '', '移动', '0', '2008-10-15', '1'), ('3464', '125.91.4.183', '', '移动', '0', '2008-10-15', '1'), ('3463', '60.167.242.172', '', '', '1', '2008-08-23', '0'), ('3462', '218.30.110.169', '', '移动', '0', '2008-10-15', '1'), ('3460', '125.91.253.165', '', '移动', '0', '2008-10-15', '1'), ('3461', '222.70.184.35', '', '', '2', '2008-08-23', '0'), ('3459', '211.136.228.233', '', '', '31', '2008-08-23', '0'), ('3458', '123.234.53.69', '', '', '1', '2008-08-23', '0'), ('3457', '125.91.253.149', '', '移动', '0', '2008-10-15', '1'), ('2268', '211.139.92.11', '甘肃', '移动', '0', '2008-08-18', '1'), ('2678', '218.16.242.66', '', '', '3', '2008-08-21', '0'), ('2679', '218.19.65.179', '', '', '2', '2008-08-21', '0'), ('2680', '220.181.31.45', '', '', '13', '2008-08-21', '0'), ('2681', '211.139.146.204', '', '', '32', '2008-08-21', '0'), ('2682', '211.139.146.206', '', '', '24', '2008-08-21', '0'), ('2683', '221.130.195.69', '', '移动', '1448', '2008-08-21', '1'), ('2684', '74.6.22.178', '', '', '29', '2008-08-21', '0'), ('2685', '58.248.170.234', '', '', '1', '2008-08-21', '0'), ('2686', '211.94.164.200', '', '移动', '1047', '2008-08-21', '1'), ('3456', '211.137.41.14', '', '', '4', '2008-08-23', '0'), ('3455', '195.189.142.181', '', '', '2', '2008-08-23', '0'), ('3454', '61.146.235.123', '', '', '1', '2008-08-23', '0'), ('3453', '58.211.21.95', '', '移动', '0', '2008-10-15', '1'), ('3452', '221.232.173.231', '', '', '11', '2008-08-23', '0'), ('3450', '121.34.36.180', '', '', '7', '2008-08-23', '0'), ('3451', '211.145.14.196', '', '', '2', '2008-08-23', '0'), ('3449', '125.91.253.221', '', '移动', '0', '2008-10-15', '1'), ('3448', '211.136.158.254', '', '', '9', '2008-08-23', '0'), ('3447', '220.206.246.60', '', '', '2', '2008-08-23', '0'), ('3446', '58.211.21.99', '', '移动', '0', '2008-10-15', '1'), ('3444', '211.136.73.66', '', '', '9', '2008-08-23', '0'), ('3445', '211.139.90.254', '', '', '45', '2008-08-23', '0'), ('3443', '220.249.119.137', '', '', '11', '2008-08-23', '0'), ('3442', '220.206.235.2', '', '', '1', '2008-08-23', '0'), ('3440', '125.79.142.228', '', '', '6', '2008-08-23', '0'), ('3441', '211.139.146.239', '', '', '27', '2008-08-23', '0'), ('3438', '222.125.136.122', '', '', '1', '2008-08-23', '0'), ('3439', '99.225.232.189', '', '', '1', '2008-08-23', '0'), ('3435', '221.179.17.1', '', '', '18', '2008-08-23', '0'), ('3436', '211.136.158.223', '', '', '3', '2008-08-23', '0'), ('3437', '211.136.75.38', '', '', '2', '2008-08-23', '0'), ('3432', '211.138.73.9', '', '', '12', '2008-08-23', '0'), ('3433', '124.13.233.153', '', '', '2', '2008-08-23', '0'), ('3434', '116.16.208.121', '', '', '2', '2008-08-23', '0'), ('3431', '218.16.54.222', '', '', '1', '2008-08-23', '0'), ('3430', '91.203.96.35', '', '', '5', '2008-08-23', '0'), ('3429', '211.138.36.203', '', '', '67', '2008-08-23', '0'), ('3427', '211.136.158.174', '', '', '6', '2008-08-23', '0'), ('3428', '58.71.139.28', '', '', '17', '2008-08-23', '0'), ('3424', '211.139.162.12', '', '', '43', '2008-08-23', '0'), ('3425', '61.135.220.44', '', '', '1', '2008-08-23', '0'), ('3426', '220.192.243.71', '', '', '1', '2008-08-23', '0'), ('3422', '221.5.161.249', '', '', '1', '2008-08-23', '0'), ('3423', '218.19.84.158', '', '', '5', '2008-08-23', '0'), ('3421', '211.95.66.81', '', '', '5', '2008-08-23', '0'), ('3420', '222.191.196.200', '', '', '11', '2008-08-23', '0'), ('3419', '211.136.158.248', '', '', '7', '2008-08-23', '0'), ('4343', '117.92.80.234', '', '', '1', '2008-08-27', '0'), ('2237', '211.138.100.173', '山西', '移动', '0', '2008-08-18', '1'), ('4366', '203.81.19.16', '', '', '37', '2008-08-27', '0'), ('3418', '211.139.146.217', '', '', '48', '2008-08-23', '0'), ('3417', '218.201.201.17', '', '', '10', '2008-08-23', '0'), ('3415', '211.100.34.36', '', '', '41', '2008-08-23', '0'), ('3416', '222.217.236.246', '', '', '1', '2008-08-23', '0'), ('3414', '202.160.180.207', '', '', '1', '2008-08-23', '0'), ('3413', '218.30.110.190', '', '移动', '0', '2008-10-15', '1'), ('2295', '218.207.218.135', '福建', '移动', '0', '2008-08-18', '1'), ('2298', '221.130.202.168', '广东', '移动', '0', '2008-08-18', '1'), ('3412', '218.30.107.236', '', '移动', '0', '2008-10-15', '1'), ('3409', '202.108.7.210', '', '', '3', '2008-08-23', '0'), ('3410', '218.30.110.84', '', '移动', '0', '2008-10-15', '1'), ('3411', '211.141.68.67', '', '', '7', '2008-08-23', '0'), ('3408', '220.206.245.1', '', '', '3', '2008-08-23', '0'), ('3406', '211.139.148.42', '', '', '61', '2008-08-23', '0'), ('3407', '58.71.139.25', '', '', '16', '2008-08-23', '0'), ('3404', '211.139.71.142', '', '', '10', '2008-08-23', '0'), ('3402', '211.137.63.150', '', '', '2', '2008-08-23', '0'), ('3403', '211.136.228.84', '', '', '22', '2008-08-23', '0'), ('3400', '211.136.228.79', '', '', '25', '2008-08-23', '0'), ('3401', '211.139.71.139', '', '', '10', '2008-08-23', '0'), ('3399', '122.224.187.53', '', '', '1', '2008-08-23', '0'), ('3398', '220.181.5.33', '', '', '1', '2008-08-23', '0'), ('2272', '211.140.18.130', '浙江', '移动', '0', '2008-08-18', '1'), ('4348', '122.156.17.157', '', '', '1', '2008-08-27', '0'), ('3397', '211.139.148.43', '', '', '61', '2008-08-23', '0'), ('3396', '61.141.5.32', '', '移动', '0', '2008-10-15', '1'), ('3395', '61.129.251.88', '', '', '1', '2008-08-23', '0'), ('3394', '125.91.253.230', '', '移动', '0', '2008-10-15', '1'), ('3392', '218.200.225.2', '', '', '8', '2008-08-23', '0'), ('3393', '211.136.158.133', '', '', '105', '2008-08-23', '0'), ('3391', '211.95.66.93', '', '', '51', '2008-08-23', '0'), ('3390', '58.211.21.69', '', '移动', '0', '2008-10-15', '1'), ('3389', '61.135.168.134', '', '', '6', '2008-08-23', '0'), ('5511', '202.160.178.149', '', '', '1', '2008-09-03', '0'), ('3387', '118.120.15.201', '', '', '1', '2008-08-23', '0'), ('3386', '196.207.33.198', '', '', '92', '2008-08-23', '0'), ('3385', '125.91.253.229', '', '移动', '0', '2008-10-15', '1'), ('3384', '211.138.227.8', '', '', '1', '2008-08-23', '0'), ('3383', '220.181.32.81', '', '', '3', '2008-08-23', '0'), ('3382', '218.30.110.184', '', '移动', '0', '2008-10-15', '1'), ('3380', '125.91.253.195', '', '移动', '0', '2008-10-15', '1'), ('3381', '61.135.168.34', '', '', '13', '2008-08-23', '0'), ('2266', '211.139.190.234', '广东', '移动', '0', '2008-08-18', '1'), ('3379', '206.49.165.96', '', '', '44', '2008-08-23', '0'), ('2230', '211.137.199.3', '山东', '移动', '0', '2008-08-18', '1'), ('4369', '58.83.127.206', '', '', '1', '2008-08-27', '0'), ('3377', '211.139.162.198', '', '', '23', '2008-08-23', '0'), ('3378', '79.124.192.19', '', '', '1', '2008-08-23', '0'), ('3375', '211.136.73.99', '', '', '8', '2008-08-23', '0'), ('3376', '125.91.253.139', '', '移动', '0', '2008-10-15', '1'), ('2251', '211.139.146.107', '广东', '移动', '0', '2008-08-18', '1'), ('4346', '219.148.48.106', '', '', '2', '2008-08-27', '0'), ('3374', '211.139.146.253', '', '', '26', '2008-08-23', '0'), ('2232', '211.137.211.137', '吉林', '移动', '0', '2008-08-18', '1'), ('3373', '211.138.201.146', '', '', '48', '2008-08-23', '0'), ('3372', '211.79.36.249', '', '', '82', '2008-08-23', '0'), ('3371', '59.107.8.120', '', '', '1', '2008-08-23', '0'), ('3370', '218.205.249.217', '', '', '1', '2008-08-23', '0'), ('3369', '211.139.162.161', '', '', '16', '2008-08-23', '0'), ('3368', '211.141.68.76', '', '', '4', '2008-08-23', '0'), ('3367', '125.91.253.163', '', '移动', '0', '2008-10-15', '1'), ('3366', '211.137.41.10', '', '', '2', '2008-08-23', '0'), ('3365', '211.136.228.90', '', '', '24', '2008-08-23', '0'), ('3363', '58.211.21.71', '', '移动', '0', '2008-10-15', '1');
INSERT INTO `ig_gateway` VALUES ('3362', '203.209.252.74', '', '', '2', '2008-08-23', '0'), ('3361', '211.136.73.78', '', '', '11', '2008-08-23', '0'), ('3360', '125.91.253.198', '', '移动', '0', '2008-10-15', '1'), ('3359', '220.181.61.207', '', '', '8', '2008-08-23', '0'), ('3358', '59.33.80.76', '', '', '1', '2008-08-23', '0'), ('3356', '116.24.87.254', '', '', '1', '2008-08-23', '0'), ('3357', '58.71.139.22', '', '', '20', '2008-08-23', '0'), ('3355', '58.71.139.29', '', '', '20', '2008-08-23', '0'), ('3354', '211.138.36.89', '', '', '31', '2008-08-23', '0'), ('2247', '211.138.5.36', '河北', '移动', '1', '2008-08-18', '1'), ('2259', '211.139.163.153', '广东', '移动', '0', '2008-08-18', '1'), ('4351', '211.95.176.6', '', '', '38', '2008-08-27', '0'), ('3351', '211.137.62.231', '', '', '2', '2008-08-23', '0'), ('3352', '211.139.146.240', '', '', '32', '2008-08-23', '0'), ('3353', '211.139.146.195', '', '', '25', '2008-08-23', '0'), ('3350', '125.91.253.249', '', '移动', '0', '2008-10-15', '1'), ('3346', '211.136.75.101', '', '', '3', '2008-08-23', '0'), ('3347', '211.137.197.51', '', '', '2', '2008-08-23', '0'), ('3348', '211.140.16.206', '', '', '81', '2008-08-23', '0'), ('3349', '211.136.75.62', '', '', '1', '2008-08-23', '0'), ('3345', '211.141.161.53', '', '', '26', '2008-08-23', '0'), ('3342', '211.136.228.248', '', '', '25', '2008-08-23', '0'), ('3343', '195.189.142.249', '', '', '1', '2008-08-23', '0'), ('3344', '211.136.228.80', '', '', '10', '2008-08-23', '0'), ('3341', '203.145.92.91', '', '', '1', '2008-08-23', '0'), ('3340', '125.91.253.210', '', '移动', '0', '2008-10-15', '1'), ('3339', '58.71.139.24', '', '', '23', '2008-08-23', '0'), ('3338', '211.136.199.76', '', '', '61', '2008-08-23', '0'), ('3337', '125.91.253.218', '', '移动', '0', '2008-10-15', '1'), ('3335', '116.52.77.13', '', '', '6', '2008-08-23', '0'), ('3336', '211.138.205.243', '', '', '63', '2008-08-23', '0'), ('3334', '211.137.197.56', '', '', '17', '2008-08-22', '0'), ('3332', '218.30.107.242', '', '移动', '0', '2008-10-15', '1'), ('3333', '221.218.51.132', '', '', '1', '2008-08-22', '0'), ('3329', '61.141.5.28', '', '移动', '0', '2008-10-15', '1'), ('3330', '218.71.165.104', '', '', '1', '2008-08-22', '0'), ('3331', '116.29.107.23', '', '', '1', '2008-08-22', '0'), ('3327', '125.67.125.58', '', '', '1', '2008-08-22', '0'), ('3328', '210.241.199.201', '', '', '19', '2008-08-22', '0'), ('3326', '211.136.228.92', '', '', '26', '2008-08-22', '0'), ('3325', '220.206.204.177', '', '', '1', '2008-08-22', '0'), ('2236', '211.137.69.234', '湖北', '移动', '0', '2008-08-18', '1'), ('3324', '220.206.246.21', '', '', '2', '2008-08-22', '0'), ('3323', '211.139.148.44', '', '', '54', '2008-08-22', '0'), ('3322', '218.30.107.235', '', '移动', '0', '2008-10-15', '1'), ('3320', '211.138.201.145', '', '', '46', '2008-08-22', '0'), ('3321', '58.71.195.253', '', '', '1', '2008-08-22', '0'), ('3319', '193.253.141.80', '', '', '1', '2008-08-22', '0'), ('3317', '116.20.28.131', '', '', '7', '2008-08-22', '0'), ('3318', '79.170.111.20', '', '', '1', '2008-08-22', '0'), ('3316', '58.211.21.87', '', '移动', '0', '2008-10-15', '1'), ('3315', '91.203.96.23', '', '', '1', '2008-08-22', '0'), ('3314', '211.137.62.201', '', '', '2', '2008-08-22', '0'), ('5510', '114.120.37.201', '', '', '1', '2008-09-03', '0'), ('3312', '123.6.82.110', '', '', '1', '2008-08-22', '0'), ('3308', '211.139.148.36', '', '', '63', '2008-08-22', '0'), ('3309', '211.139.148.34', '', '', '63', '2008-08-22', '0'), ('3310', '58.211.21.86', '', '移动', '0', '2008-10-15', '1'), ('3311', '211.139.148.37', '', '', '62', '2008-08-22', '0'), ('3307', '125.91.253.251', '', '移动', '0', '2008-10-15', '1'), ('3306', '211.139.146.220', '', '', '48', '2008-08-22', '0'), ('5509', '195.189.142.196', '', '', '1', '2008-09-03', '0'), ('3304', '202.160.180.152', '', '', '2', '2008-08-22', '0'), ('3303', '221.225.148.202', '', '', '1', '2008-08-22', '0'), ('3302', '221.179.17.2', '', '', '35', '2008-08-22', '0'), ('3301', '91.203.96.27', '', '', '1', '2008-08-22', '0'), ('3300', '125.91.253.160', '', '移动', '0', '2008-10-15', '1'), ('3299', '123.8.209.255', '', '', '1', '2008-08-22', '0'), ('3298', '122.200.102.238', '', '', '1', '2008-08-22', '0'), ('3297', '58.211.21.93', '', '移动', '0', '2008-10-15', '1'), ('5508', '218.88.169.196', '', '', '1', '2008-09-03', '0'), ('3295', '125.91.253.162', '', '移动', '0', '2008-10-15', '1'), ('3294', '222.92.6.114', '', '', '1', '2008-08-22', '0'), ('5507', '218.69.178.125', '', '', '1', '2008-09-03', '0'), ('3292', '218.16.113.197', '', '', '1', '2008-08-22', '0'), ('3290', '211.137.41.7', '', '', '4', '2008-08-22', '0'), ('3291', '120.32.242.248', '', '', '1', '2008-08-22', '0'), ('3289', '211.139.146.221', '', '', '48', '2008-08-22', '0'), ('3288', '123.249.94.178', '', '', '2', '2008-08-22', '0'), ('3287', '220.181.32.38', '', '', '4', '2008-08-22', '0'), ('3286', '218.202.65.61', '', '', '113', '2008-08-22', '0'), ('3285', '220.206.221.2', '', '', '28', '2008-08-22', '0'), ('3284', '211.139.14.98', '', '', '46', '2008-08-22', '0'), ('3283', '211.139.148.38', '', '', '67', '2008-08-22', '0'), ('5506', '222.72.179.111', '', '', '1', '2008-09-03', '0'), ('3282', '220.194.45.6', '', '', '1', '2008-08-22', '0'), ('3280', '211.138.201.242', '', '', '51', '2008-08-22', '0'), ('3279', '116.28.19.46', '', '', '1', '2008-08-22', '0'), ('3278', '211.143.149.229', '', '', '1', '2008-08-22', '0'), ('3277', '123.136.98.69', '', '', '50', '2008-08-22', '0'), ('3276', '202.101.6.92', '', '', '408', '2008-08-22', '0'), ('3275', '211.139.146.229', '', '', '29', '2008-08-22', '0'), ('3274', '211.139.190.126', '', '', '106', '2008-08-22', '0'), ('3273', '61.141.5.26', '', '移动', '0', '2008-10-15', '1'), ('3272', '211.136.228.246', '', '', '110', '2008-08-22', '0'), ('3271', '125.91.253.137', '', '移动', '0', '2008-10-15', '1'), ('3269', '220.181.32.9', '', '', '1', '2008-08-22', '0'), ('5505', '221.5.45.146', '', '', '1', '2008-09-03', '0'), ('3268', '218.202.227.169', '', '', '761', '2008-08-22', '0'), ('3267', '218.202.227.173', '', '', '666', '2008-08-22', '0'), ('3265', '202.108.7.215', '', '', '14', '2008-08-22', '0'), ('3266', '203.142.100.17', '', '', '319', '2008-08-22', '0'), ('3263', '61.154.10.210', '', '', '9', '2008-08-22', '0'), ('3264', '116.26.216.169', '', '', '1', '2008-08-22', '0'), ('2228', '211.137.180.233', '山东', '移动', '0', '2008-08-18', '1'), ('4354', '122.13.200.165', '', '', '1', '2008-08-27', '0'), ('4355', '60.165.239.115', '', '', '1', '2008-08-27', '0'), ('3259', '211.139.162.173', '', '', '8', '2008-08-22', '0'), ('3260', '58.71.139.20', '', '', '19', '2008-08-22', '0'), ('3261', '203.208.60.9', '', '', '4', '2008-08-22', '0'), ('3262', '220.181.61.223', '', '', '7', '2008-08-22', '0'), ('3258', '221.217.54.232', '', '', '1', '2008-08-22', '0'), ('3257', '211.139.189.182', '', '', '38', '2008-08-22', '0'), ('3256', '124.254.63.245', '', '', '7', '2008-08-22', '0'), ('3249', '218.202.227.174', '', '', '745', '2008-08-22', '0'), ('3250', '58.211.21.90', '', '移动', '0', '2008-10-15', '1'), ('3251', '123.249.69.118', '', '', '1', '2008-08-22', '0'), ('3252', '218.202.227.172', '', '', '680', '2008-08-22', '0'), ('3253', '211.141.161.54', '', '', '19', '2008-08-22', '0'), ('3254', '211.139.190.128', '', '', '86', '2008-08-22', '0'), ('3255', '219.133.68.219', '', '', '1', '2008-08-22', '0'), ('3248', '211.139.162.178', '', '', '33', '2008-08-22', '0'), ('3247', '211.138.227.145', '', '', '1', '2008-08-22', '0'), ('3246', '211.140.16.243', '', '', '33', '2008-08-22', '0'), ('3244', '58.211.21.72', '', '移动', '0', '2008-10-15', '1'), ('2243', '211.138.237.135', '湖南', '移动', '0', '2008-08-18', '1'), ('3243', '125.91.4.150', '', '移动', '0', '2008-10-15', '1'), ('3238', '61.145.171.86', '', '', '4', '2008-08-22', '0'), ('3239', '123.4.61.40', '', '', '1', '2008-08-22', '0'), ('3240', '125.91.253.231', '', '移动', '0', '2008-10-15', '1'), ('3241', '220.181.61.203', '', '', '9', '2008-08-22', '0'), ('3242', '211.143.149.105', '', '', '2', '2008-08-22', '0'), ('3237', '125.91.253.244', '', '移动', '0', '2008-10-15', '1'), ('3236', '125.91.253.217', '', '移动', '0', '2008-10-15', '1'), ('3235', '220.194.47.88', '', '移动', '1002', '2008-08-22', '1'), ('3234', '221.130.176.134', '', '', '215', '2008-08-22', '0'), ('2279', '211.143.58.36', '河北', '移动', '1', '2008-08-18', '1'), ('3233', '211.136.228.73', '', '', '31', '2008-08-22', '0'), ('3232', '218.30.110.94', '', '移动', '0', '2008-10-15', '1'), ('3231', '121.29.1.193', '', '', '1', '2008-08-22', '0'), ('2225', '211.136.28.167', '北京', '移动', '0', '2008-08-18', '1'), ('3230', '117.93.34.154', '', '', '1', '2008-08-22', '0'), ('5504', '118.245.146.62', '', '', '1', '2008-09-03', '0'), ('3227', '211.136.105.212', '', '', '243', '2008-08-22', '0'), ('3228', '211.139.162.15', '', '', '56', '2008-08-22', '0'), ('5503', '123.54.73.189', '', '', '1', '2008-09-03', '0'), ('3225', '218.202.227.175', '', '', '678', '2008-08-22', '0'), ('3223', '202.152.84.2', '', '', '7', '2008-08-22', '0'), ('3224', '125.66.79.26', '', '', '1', '2008-08-22', '0'), ('3221', '222.217.243.229', '', '', '1', '2008-08-22', '0'), ('3218', '211.139.162.8', '', '', '28', '2008-08-22', '0'), ('3219', '61.135.168.53', '', '', '4', '2008-08-22', '0'), ('3220', '211.139.146.245', '', '', '31', '2008-08-22', '0'), ('3217', '124.29.140.193', '', '', '83', '2008-08-22', '0'), ('3216', '218.30.110.90', '', '移动', '0', '2008-10-15', '1'), ('3215', '220.194.47.89', '', '', '195', '2008-08-22', '0'), ('3214', '211.136.158.52', '', '', '3', '2008-08-22', '0'), ('3213', '60.28.164.121', '', '', '4', '2008-08-22', '0'), ('3212', '125.91.4.171', '', '移动', '0', '2008-10-15', '1'), ('3210', '211.136.158.181', '', '', '3', '2008-08-22', '0'), ('3211', '211.139.147.51', '', '', '133', '2008-08-22', '0'), ('4359', '116.25.187.165', '', '', '2', '2008-08-27', '0'), ('2223', '211.136.253.102', '广东', '移动', '0', '2008-08-18', '1'), ('4322', '218.28.97.3', '', '', '1', '2008-08-27', '0'), ('3209', '195.112.227.234', '', '', '4', '2008-08-22', '0'), ('3208', '59.50.137.247', '', '', '1', '2008-08-22', '0'), ('4358', '125.92.70.42', '', '', '4', '2008-08-27', '0'), ('3207', '221.221.176.210', '', '', '2', '2008-08-22', '0'), ('3206', '58.211.21.103', '', '移动', '0', '2008-10-15', '1'), ('3205', '222.140.147.96', '', '', '1', '2008-08-22', '0'), ('3204', '121.35.118.178', '', '', '1', '2008-08-22', '0'), ('3203', '211.139.148.35', '', '', '69', '2008-08-22', '0'), ('3202', '125.91.253.207', '', '移动', '0', '2008-10-15', '1'), ('3199', '220.181.32.98', '', '', '2', '2008-08-22', '0'), ('3200', '218.30.110.89', '', '移动', '0', '2008-10-15', '1'), ('3201', '211.139.147.53', '', '', '147', '2008-08-22', '0'), ('3198', '211.138.36.202', '', '', '75', '2008-08-22', '0'), ('3197', '220.194.137.4', '', '', '2', '2008-08-22', '0'), ('3196', '221.11.8.238', '', '', '1', '2008-08-22', '0'), ('3194', '209.85.170.136', '', '', '1', '2008-08-22', '0'), ('3195', '211.147.248.72', '', '', '1', '2008-08-22', '0'), ('3193', '61.141.5.29', '', '移动', '0', '2008-10-15', '1'), ('3192', '74.125.74.35', '', '', '19', '2008-08-22', '0'), ('3191', '114.138.231.25', '', '', '1', '2008-08-22', '0'), ('3190', '116.16.245.138', '', '', '1', '2008-08-22', '0'), ('3189', '125.91.253.136', '', '移动', '0', '2008-10-15', '1'), ('3188', '121.1.18.241', '', '', '1', '2008-08-22', '0'), ('3187', '218.20.48.18', '', '', '1', '2008-08-22', '0'), ('3186', '211.140.16.223', '', '', '17', '2008-08-22', '0'), ('3185', '211.136.228.247', '', '', '82', '2008-08-22', '0'), ('2216', '211.136.222.82', '广东', '移动', '0', '2008-08-18', '1'), ('5502', '211.136.158.188', '', '', '4', '2008-09-03', '0'), ('3183', '124.227.71.203', '', '', '1', '2008-08-22', '0'), ('4338', '59.49.224.205', '', '', '3', '2008-08-27', '0'), ('4339', '211.139.146.233', '', '', '27', '2008-08-27', '0'), ('3182', '60.3.23.37', '', '', '1', '2008-08-22', '0'), ('3181', '203.82.67.205', '', '', '3', '2008-08-22', '0'), ('3180', '121.229.193.164', '', '', '1', '2008-08-22', '0'), ('3179', '59.151.46.183', '', '', '15', '2008-08-22', '0'), ('3178', '218.200.224.162', '', '', '2', '2008-08-22', '0'), ('3177', '60.217.174.88', '', '', '2', '2008-08-22', '0'), ('3176', '117.81.133.104', '', '', '2', '2008-08-22', '0'), ('3175', '116.232.168.224', '', '', '4', '2008-08-22', '0'), ('3174', '61.141.5.24', '', '移动', '0', '2008-10-15', '1'), ('3172', '218.30.107.234', '', '移动', '0', '2008-10-15', '1'), ('5501', '218.1.101.246', '', '', '1', '2008-09-03', '0'), ('3171', '116.197.223.133', '', '', '1', '2008-08-22', '0'), ('3170', '221.221.149.87', '', '', '1', '2008-08-22', '0'), ('3169', '211.138.6.180', '', '', '153', '2008-08-22', '0'), ('3166', '192.118.11.101', '', '', '135', '2008-08-22', '0'), ('3167', '61.135.168.22', '', '', '1', '2008-08-22', '0'), ('3168', '211.139.148.39', '', '', '67', '2008-08-22', '0'), ('5500', '222.5.63.16', '', '', '1', '2008-09-03', '0'), ('3164', '211.139.162.183', '', '', '15', '2008-08-22', '0'), ('3162', '195.189.142.40', '', '', '2', '2008-08-22', '0'), ('3163', '211.140.16.218', '', '', '35', '2008-08-22', '0'), ('3160', '58.211.21.78', '', '移动', '0', '2008-10-15', '1'), ('3161', '125.91.253.216', '', '移动', '0', '2008-10-15', '1'), ('3159', '211.138.167.241', '', '', '53', '2008-08-22', '0'), ('3158', '211.138.28.177', '', '', '62', '2008-08-22', '0'), ('3154', '211.137.63.103', '', '', '3', '2008-08-22', '0'), ('3155', '203.86.47.194', '', '', '22', '2008-08-22', '0'), ('3156', '59.41.223.22', '', '', '41', '2008-08-22', '0'), ('3157', '67.195.37.181', '', '', '10', '2008-08-22', '0'), ('5499', '202.160.178.95', '', '', '2', '2008-09-03', '0'), ('2204', '211.136.115.68', '上海', '移动', '0', '2008-08-18', '1'), ('3152', '61.144.216.169', '', '', '9', '2008-08-22', '0'), ('3151', '125.91.130.223', '', '', '1', '2008-08-22', '0'), ('2238', '211.138.104.18', '山西', '移动', '0', '2008-08-18', '1'), ('3150', '219.143.33.119', '', '', '1', '2008-08-22', '0'), ('3149', '58.60.14.236', '', '', '1', '2008-08-22', '0'), ('3148', '58.60.187.9', '', '', '2', '2008-08-22', '0'), ('3146', '220.181.5.34', '', '', '3', '2008-08-22', '0'), ('3147', '218.30.117.3', '', '移动', '0', '2008-10-15', '1'), ('3145', '58.211.21.74', '', '移动', '0', '2008-10-15', '1'), ('3144', '211.136.199.83', '', '', '65', '2008-08-22', '0'), ('2844', '121.207.35.27', '', '', '1', '2008-08-21', '0'), ('2845', '58.211.21.82', '', '移动', '0', '2008-10-15', '1'), ('2846', '211.136.158.48', '', '', '35', '2008-08-21', '0'), ('2847', '211.139.145.221', '', '', '60', '2008-08-21', '0'), ('5498', '60.163.143.53', '', '', '2', '2008-09-03', '0'), ('2849', '211.138.6.181', '', '', '165', '2008-08-21', '0'), ('2850', '125.91.253.201', '', '移动', '0', '2008-10-15', '1'), ('2851', '211.136.228.95', '', '', '27', '2008-08-21', '0'), ('2852', '211.92.33.163', '', '', '1', '2008-08-21', '0'), ('2853', '125.91.253.146', '', '移动', '0', '2008-10-15', '1'), ('2854', '211.137.141.1', '', '', '95', '2008-08-21', '0'), ('2855', '202.160.178.126', '', '', '1', '2008-08-21', '0'), ('2856', '211.139.71.140', '', '', '9', '2008-08-21', '0'), ('2857', '211.139.146.231', '', '', '21', '2008-08-21', '0'), ('2255', '211.139.151.10', '广东', '移动', '0', '2008-08-18', '1'), ('3143', '211.136.199.86', '', '', '60', '2008-08-22', '0'), ('3142', '125.91.253.151', '', '移动', '0', '2008-10-15', '1'), ('3141', '123.112.196.139', '', '', '1', '2008-08-22', '0'), ('3140', '58.251.59.5', '', '', '3', '2008-08-22', '0'), ('4330', '123.6.80.185', '', '', '2', '2008-08-27', '0'), ('5497', '125.83.217.210', '', '', '1', '2008-09-03', '0'), ('3137', '221.130.197.84', '', '', '16', '2008-08-22', '0'), ('3138', '59.36.186.102', '', '', '1', '2008-08-22', '0'), ('3136', '64.122.13.252', '', '', '2', '2008-08-22', '0'), ('3132', '211.140.16.215', '', '', '32', '2008-08-22', '0'), ('3133', '61.141.5.30', '', '移动', '0', '2008-10-15', '1'), ('3134', '220.166.61.17', '', '', '1', '2008-08-22', '0'), ('3135', '211.136.228.216', '', '', '32', '2008-08-22', '0'), ('2239', '211.138.147.158', '福建', '移动', '0', '2008-08-18', '1'), ('4314', '61.161.73.23', '', '', '1', '2008-08-27', '0'), ('3131', '125.91.253.164', '', '移动', '0', '2008-10-15', '1'), ('3130', '222.139.187.56', '', '', '1', '2008-08-22', '0'), ('3129', '125.91.253.170', '', '移动', '0', '2008-10-15', '1'), ('3128', '125.83.15.121', '', '', '1', '2008-08-22', '0'), ('3127', '218.30.107.241', '', '移动', '0', '2008-10-15', '1'), ('3126', '218.85.92.37', '', '', '1', '2008-08-22', '0'), ('3125', '211.139.148.46', '', '', '81', '2008-08-22', '0'), ('3123', '211.139.162.172', '', '', '18', '2008-08-22', '0'), ('3124', '211.136.199.75', '', '', '75', '2008-08-22', '0'), ('3121', '203.81.19.26', '', '', '157', '2008-08-22', '0'), ('3122', '218.30.110.177', '', '移动', '0', '2008-10-15', '1'), ('2841', '211.139.190.118', '', '', '30', '2008-08-21', '0'), ('2842', '211.138.201.148', '', '', '43', '2008-08-21', '0'), ('2843', '211.136.228.72', '', '', '35', '2008-08-21', '0'), ('2302', '221.131.143.50', '江苏', '移动', '0', '2008-08-18', '1'), ('2303', '221.176.1.75', '河北', '移动', '0', '2008-08-18', '1'), ('3120', '211.139.146.218', '', '', '48', '2008-08-22', '0'), ('3118', '211.136.228.70', '', '', '29', '2008-08-22', '0'), ('3119', '211.139.146.227', '', '', '28', '2008-08-22', '0'), ('3117', '211.140.16.214', '', '', '44', '2008-08-22', '0'), ('2252', '211.139.146.138', '广东', '移动', '0', '2008-08-18', '1'), ('3114', '218.30.117.2', '', '移动', '0', '2008-10-15', '1'), ('3115', '58.61.225.175', '', '', '1', '2008-08-22', '0'), ('3113', '123.131.53.138', '', '', '2', '2008-08-22', '0'), ('3112', '58.42.60.127', '', '', '1', '2008-08-22', '0'), ('3111', '220.104.108.88', '', '', '1', '2008-08-22', '0'), ('2301', '221.131.128.199', '江苏', '移动', '0', '2008-08-18', '1'), ('3108', '203.208.60.39', '', '', '23', '2008-08-22', '0'), ('5496', '211.136.75.155', '', '', '1', '2008-09-03', '0'), ('3110', '221.179.17.0', '', '', '23', '2008-08-22', '0'), ('2288', '218.203.123.41', '甘肃', '移动', '0', '2008-08-18', '1'), ('3107', '121.56.250.233', '', '', '2', '2008-08-22', '0'), ('3106', '59.38.150.238', '', '', '4', '2008-08-22', '0'), ('3105', '203.81.19.13', '', '', '39', '2008-08-22', '0'), ('3104', '220.196.52.95', '', '', '152', '2008-08-22', '0'), ('3103', '211.139.146.244', '', '', '30', '2008-08-22', '0'), ('2253', '211.139.146.180', '广东', '移动', '0', '2008-08-18', '1'), ('2819', '218.200.225.6', '', '', '3', '2008-08-21', '0'), ('2820', '218.30.110.83', '', '移动', '0', '2008-10-15', '1'), ('2821', '211.139.146.241', '', '', '44', '2008-08-21', '0'), ('2822', '211.140.16.240', '', '', '46', '2008-08-21', '0'), ('2823', '195.189.143.51', '', '', '1', '2008-08-21', '0'), ('2824', '125.91.253.202', '', '移动', '0', '2008-10-15', '1'), ('2825', '202.160.180.31', '', '', '2', '2008-08-21', '0'), ('2826', '211.139.162.181', '', '', '15', '2008-08-21', '0'), ('2827', '125.91.253.143', '', '移动', '0', '2008-10-15', '1'), ('2828', '220.192.210.218', '', '', '1', '2008-08-21', '0'), ('2829', '202.93.37.93', '', '', '2', '2008-08-21', '0'), ('2830', '203.208.60.37', '', '', '33', '2008-08-21', '0'), ('5495', '58.62.107.14', '', '', '3', '2008-09-03', '0'), ('2832', '211.139.162.207', '', '', '23', '2008-08-21', '0'), ('2833', '121.18.158.36', '', '', '1', '2008-08-21', '0'), ('2834', '58.19.210.4', '', '', '2', '2008-08-21', '0'), ('2835', '211.136.228.81', '', '', '97', '2008-08-21', '0'), ('2836', '59.35.164.211', '', '', '4', '2008-08-21', '0'), ('2837', '125.91.253.135', '', '移动', '0', '2008-10-15', '1'), ('2838', '211.138.152.123', '', '', '2', '2008-08-21', '0'), ('2839', '211.139.162.195', '', '', '20', '2008-08-21', '0'), ('2818', '218.30.110.174', '', '移动', '0', '2008-10-15', '1'), ('2817', '222.214.218.85', '', '', '100', '2008-08-21', '0'), ('2816', '211.140.16.213', '', '', '28', '2008-08-21', '0'), ('2815', '211.139.190.120', '', '', '40', '2008-08-21', '0'), ('2814', '218.30.110.91', '', '移动', '0', '2008-10-15', '1'), ('2813', '61.141.5.31', '', '移动', '0', '2008-10-15', '1'), ('2812', '116.213.64.49', '', '', '3', '2008-08-21', '0'), ('2811', '203.81.19.27', '', '', '222', '2008-08-21', '0'), ('2810', '211.140.16.208', '', '', '67', '2008-08-21', '0'), ('2809', '211.139.162.203', '', '', '19', '2008-08-21', '0'), ('2808', '211.96.20.41', '', '', '61', '2008-08-21', '0'), ('2807', '196.207.40.238', '', '', '92', '2008-08-21', '0'), ('3102', '202.160.180.163', '', '', '5', '2008-08-22', '0'), ('3099', '121.229.24.21', '', '', '3', '2008-08-22', '0'), ('3100', '220.249.88.228', '', '', '1', '2008-08-22', '0'), ('3101', '58.211.21.96', '', '移动', '0', '2008-10-15', '1'), ('3098', '211.136.158.154', '', '', '1', '2008-08-22', '0'), ('3097', '202.160.178.67', '', '', '1', '2008-08-22', '0'), ('4352', '58.83.127.198', '', '', '7', '2008-08-27', '0'), ('4328', '58.49.227.16', '', '', '2', '2008-08-27', '0'), ('4329', '222.133.176.138', '', '', '1', '2008-08-27', '0'), ('3094', '211.140.16.207', '', '', '54', '2008-08-22', '0'), ('3095', '125.91.4.172', '', '移动', '0', '2008-10-15', '1'), ('3096', '116.252.169.131', '', '', '3', '2008-08-22', '0'), ('3092', '203.81.19.23', '', '', '216', '2008-08-22', '0'), ('3093', '125.208.6.174', '', '', '13', '2008-08-22', '0'), ('3091', '221.179.17.6', '', '', '21', '2008-08-22', '0'), ('3089', '202.160.178.70', '', '', '2', '2008-08-22', '0'), ('3090', '211.139.147.52', '', '', '151', '2008-08-22', '0'), ('3088', '125.73.189.139', '', '', '1', '2008-08-22', '0'), ('3082', '211.136.228.77', '', '', '23', '2008-08-22', '0'), ('3083', '24.66.94.144', '', '', '1', '2008-08-22', '0'), ('3084', '24.79.153.214', '', '', '1', '2008-08-22', '0'), ('3085', '211.136.228.241', '', '', '41', '2008-08-22', '0'), ('3086', '74.6.17.188', '', '', '34', '2008-08-22', '0'), ('3087', '125.92.112.190', '', '', '1', '2008-08-22', '0'), ('3080', '125.91.253.197', '', '移动', '0', '2008-10-15', '1'), ('3081', '211.137.197.54', '', '', '4', '2008-08-22', '0'), ('3079', '211.139.146.197', '', '', '18', '2008-08-22', '0'), ('3077', '218.240.218.83', '', '', '6', '2008-08-22', '0'), ('3078', '125.77.88.189', '', '', '1', '2008-08-22', '0'), ('2261', '211.139.163.183', '广东', '移动', '0', '2008-08-18', '1'), ('3076', '219.136.207.58', '', '', '14', '2008-08-22', '0'), ('3074', '211.143.204.194', '', '', '16', '2008-08-22', '0'), ('3075', '220.195.15.149', '', '', '20', '2008-08-22', '0'), ('3073', '211.136.228.83', '', '', '15', '2008-08-22', '0'), ('4361', '202.175.11.197', '', '', '3', '2008-08-27', '0'), ('2245', '211.138.250.103', '广西', '移动', '0', '2008-08-18', '1'), ('3072', '211.139.148.33', '', '', '62', '2008-08-22', '0'), ('3071', '202.160.178.97', '', '', '1', '2008-08-22', '0'), ('3070', '125.91.253.200', '', '移动', '0', '2008-10-15', '1'), ('3069', '203.81.19.24', '', '', '227', '2008-08-22', '0'), ('3068', '60.14.153.85', '', '', '1', '2008-08-22', '0'), ('3067', '219.134.255.71', '', '', '1', '2008-08-22', '0'), ('3066', '211.140.16.245', '', '', '29', '2008-08-22', '0'), ('3065', '58.62.225.62', '', '', '1', '2008-08-22', '0'), ('3063', '211.138.201.243', '', '', '65', '2008-08-22', '0'), ('3064', '219.136.217.26', '', '', '1', '2008-08-22', '0'), ('2227', '211.137.170.18', '天津', '移动', '0', '2008-08-18', '1'), ('3062', '211.140.16.230', '', '', '85', '2008-08-22', '0'), ('3061', '211.140.16.238', '', '', '48', '2008-08-22', '0'), ('3060', '202.160.179.153', '', '', '1', '2008-08-22', '0'), ('3058', '150.70.84.28', '', '', '2', '2008-08-22', '0'), ('3059', '123.130.208.149', '', '', '1', '2008-08-22', '0'), ('3057', '218.60.75.76', '', '', '1', '2008-08-22', '0'), ('3056', '125.91.253.228', '', '移动', '0', '2008-10-15', '1'), ('3055', '125.91.253.235', '', '移动', '0', '2008-10-15', '1'), ('3054', '211.139.162.190', '', '', '20', '2008-08-22', '0'), ('3053', '211.139.146.215', '', '', '56', '2008-08-22', '0'), ('3052', '211.92.61.158', '', '', '45', '2008-08-22', '0'), ('3051', '61.135.168.160', '', '', '32', '2008-08-22', '0'), ('3050', '218.19.20.172', '', '', '6', '2008-08-22', '0'), ('3049', '220.173.194.191', '', '', '1', '2008-08-22', '0'), ('3048', '211.136.199.81', '', '', '65', '2008-08-22', '0'), ('3047', '125.91.253.232', '', '移动', '0', '2008-10-15', '1'), ('3046', '122.224.26.58', '', '', '2', '2008-08-22', '0'), ('3045', '211.140.16.202', '', '', '52', '2008-08-22', '0'), ('5494', '202.38.240.89', '', '', '2', '2008-09-03', '0'), ('3044', '58.211.21.68', '', '移动', '0', '2008-10-15', '1'), ('3040', '211.140.16.201', '', '', '65', '2008-08-22', '0'), ('3041', '125.91.253.224', '', '移动', '0', '2008-10-15', '1'), ('3042', '211.139.162.165', '', '', '18', '2008-08-22', '0'), ('3039', '219.137.52.224', '', '', '1', '2008-08-22', '0'), ('3038', '211.136.228.87', '', '', '12', '2008-08-22', '0'), ('3037', '61.135.168.52', '', '', '2', '2008-08-22', '0'), ('3036', '211.140.16.203', '', '', '46', '2008-08-22', '0'), ('3035', '116.25.139.254', '', '', '1', '2008-08-22', '0'), ('3034', '211.139.146.209', '', '', '34', '2008-08-22', '0'), ('2262', '211.139.190.119', '广东', '移动', '0', '2008-08-18', '1'), ('3032', '211.138.227.135', '', '', '1', '2008-08-22', '0'), ('3033', '125.91.253.215', '', '移动', '0', '2008-10-15', '1'), ('3031', '211.138.255.243', '', '', '255', '2008-08-22', '0'), ('3029', '203.81.19.18', '', '', '20', '2008-08-22', '0'), ('3028', '220.206.246.20', '', '', '3', '2008-08-22', '0'), ('3027', '203.117.71.3', '', '', '69', '2008-08-22', '0'), ('3025', '125.91.253.241', '', '移动', '0', '2008-10-15', '1'), ('3026', '211.139.146.249', '', '', '32', '2008-08-22', '0'), ('3024', '211.136.228.68', '', '', '26', '2008-08-22', '0'), ('3022', '211.136.199.73', '', '', '68', '2008-08-22', '0'), ('3023', '59.38.196.242', '', '', '1', '2008-08-22', '0'), ('5493', '195.189.142.44', '', '', '3', '2008-09-03', '0'), ('3020', '211.138.201.150', '', '', '34', '2008-08-22', '0'), ('3021', '125.91.253.247', '', '移动', '0', '2008-10-15', '1'), ('3016', '61.135.168.18', '', '', '5', '2008-08-22', '0'), ('3017', '211.139.146.205', '', '', '14', '2008-08-22', '0'), ('3018', '203.208.60.36', '', '', '15', '2008-08-22', '0'), ('3015', '116.232.173.54', '', '', '1', '2008-08-22', '0'), ('3014', '211.139.146.196', '', '', '21', '2008-08-22', '0'), ('2806', '220.201.8.217', '', '', '62', '2008-08-21', '0'), ('2805', '125.91.253.148', '', '移动', '0', '2008-10-15', '1'), ('2804', '203.208.60.7', '', '移动', '1867', '2008-08-21', '1'), ('2803', '58.71.192.51', '', '', '1', '2008-08-21', '0'), ('2799', '125.91.253.138', '', '移动', '0', '2008-10-15', '1'), ('2798', '125.91.253.142', '', '移动', '0', '2008-10-15', '1'), ('2795', '66.131.17.34', '', '', '1', '2008-08-21', '0'), ('2796', '211.91.132.11', '', '', '179', '2008-08-21', '0'), ('2797', '211.139.146.219', '', '', '34', '2008-08-21', '0'), ('2273', '211.140.3.110', '浙江', '移动', '0', '2008-08-18', '1'), ('4326', '60.172.219.28', '', '', '1', '2008-08-27', '0'), ('3013', '211.139.90.253', '', '', '29', '2008-08-22', '0'), ('3011', '211.137.41.24', '', '', '4', '2008-08-22', '0'), ('3012', '125.91.253.144', '', '移动', '0', '2008-10-15', '1'), ('3010', '125.91.253.253', '', '移动', '0', '2008-10-15', '1'), ('3009', '211.137.62.233', '', '', '1', '2008-08-22', '0'), ('3008', '211.137.41.20', '', '', '1', '2008-08-22', '0'), ('3007', '211.139.146.202', '', '', '20', '2008-08-22', '0'), ('3006', '58.71.139.26', '', '', '17', '2008-08-22', '0'), ('3004', '61.135.168.96', '', '', '38', '2008-08-22', '0'), ('3005', '211.141.161.51', '', '', '14', '2008-08-22', '0'), ('3003', '125.91.253.161', '', '移动', '0', '2008-10-15', '1'), ('3002', '125.91.253.196', '', '移动', '0', '2008-10-15', '1'), ('3001', '61.142.66.52', '', '', '327', '2008-08-22', '0'), ('3000', '219.140.177.86', '', '', '154', '2008-08-22', '0'), ('2998', '211.139.162.10', '', '', '31', '2008-08-22', '0'), ('2999', '67.195.37.180', '', '', '2', '2008-08-22', '0'), ('2997', '202.160.179.5', '', '', '1', '2008-08-22', '0'), ('2996', '125.91.253.147', '', '移动', '0', '2008-10-15', '1'), ('2994', '211.139.146.252', '', '', '25', '2008-08-22', '0'), ('2995', '211.139.146.213', '', '', '41', '2008-08-22', '0'), ('2993', '211.139.162.196', '', '', '81', '2008-08-22', '0'), ('2992', '222.142.20.219', '', '', '1', '2008-08-22', '0'), ('2991', '211.138.6.179', '', '', '141', '2008-08-22', '0'), ('5492', '219.139.54.153', '', '', '3', '2008-09-03', '0'), ('2990', '218.200.225.12', '', '', '10', '2008-08-22', '0'), ('2987', '58.71.139.21', '', '', '14', '2008-08-22', '0'), ('2988', '222.141.10.49', '', '', '1', '2008-08-22', '0'), ('2986', '58.71.139.23', '', '', '17', '2008-08-22', '0'), ('2229', '211.137.181.40', '山东', '移动', '0', '2008-08-18', '1'), ('2984', '218.200.225.9', '', '', '11', '2008-08-22', '0'), ('2985', '220.181.32.82', '', '', '113', '2008-08-22', '0'), ('2983', '211.139.146.243', '', '', '27', '2008-08-22', '0'), ('2982', '218.30.110.85', '', '移动', '0', '2008-10-15', '1'), ('2981', '211.136.228.97', '', '', '84', '2008-08-22', '0'), ('2979', '211.139.162.185', '', '', '14', '2008-08-22', '0'), ('2980', '219.129.250.245', '', '', '1', '2008-08-22', '0'), ('2978', '218.202.227.159', '', '', '716', '2008-08-22', '0'), ('2977', '211.136.228.242', '', '', '57', '2008-08-22', '0'), ('2976', '121.14.89.166', '', '', '34', '2008-08-22', '0'), ('2975', '59.42.32.187', '', '', '1', '2008-08-22', '0'), ('2974', '218.14.34.164', '', '', '1', '2008-08-22', '0'), ('2972', '211.138.36.86', '', '', '57', '2008-08-22', '0'), ('2973', '203.81.19.25', '', '', '294', '2008-08-22', '0'), ('2971', '124.72.198.48', '', '', '1', '2008-08-22', '0'), ('2970', '91.203.96.34', '', '', '3', '2008-08-22', '0'), ('2969', '125.91.253.222', '', '移动', '0', '2008-10-15', '1'), ('2968', '116.215.229.86', '', '', '1', '2008-08-22', '0'), ('2967', '202.160.180.44', '', '', '1', '2008-08-22', '0'), ('2966', '60.210.50.103', '', '', '2', '2008-08-22', '0'), ('2965', '121.11.241.243', '', '', '1', '2008-08-22', '0'), ('2964', '211.139.146.210', '', '', '35', '2008-08-22', '0'), ('2963', '125.91.4.157', '', '移动', '0', '2008-10-15', '1'), ('2961', '125.91.4.153', '', '移动', '0', '2008-10-15', '1'), ('2962', '202.160.179.9', '', '', '2', '2008-08-22', '0'), ('2217', '211.136.222.90', '广东', '移动', '0', '2008-08-18', '1'), ('2960', '125.91.4.174', '', '移动', '0', '2008-10-15', '1'), ('2958', '211.139.146.200', '', '', '20', '2008-08-22', '0'), ('2959', '211.136.158.220', '', '', '3', '2008-08-22', '0'), ('2957', '61.142.66.3', '', '', '220', '2008-08-22', '0'), ('2956', '211.139.146.201', '', '', '14', '2008-08-22', '0'), ('2955', '218.17.235.5', '', '', '1', '2008-08-22', '0'), ('2954', '211.136.228.250', '', '', '40', '2008-08-22', '0'), ('2953', '218.64.72.125', '', '', '24', '2008-08-22', '0'), ('2951', '218.30.110.82', '', '移动', '0', '2008-10-15', '1'), ('2952', '211.139.162.204', '', '', '16', '2008-08-22', '0'), ('5491', '218.202.227.154', '', '', '268', '2008-09-03', '0'), ('2949', '211.140.16.232', '', '', '43', '2008-08-22', '0'), ('2300', '221.130.33.39', '北京', '移动', '0', '2008-08-18', '1'), ('2947', '211.156.250.61', '', '', '1', '2008-08-22', '0'), ('2946', '125.91.253.145', '', '移动', '0', '2008-10-15', '1'), ('2945', '211.136.158.37', '', '', '7', '2008-08-22', '0'), ('2944', '218.30.110.186', '', '移动', '0', '2008-10-15', '1'), ('2943', '218.201.40.117', '', '', '1', '2008-08-22', '0'), ('2941', '125.91.253.245', '', '移动', '0', '2008-10-15', '1'), ('2942', '211.140.16.221', '', '', '29', '2008-08-22', '0'), ('2940', '211.139.146.251', '', '', '27', '2008-08-22', '0'), ('2939', '218.200.225.10', '', '', '17', '2008-08-22', '0'), ('2938', '125.91.253.169', '', '移动', '0', '2008-10-15', '1'), ('2937', '211.138.6.178', '', '', '184', '2008-08-22', '0'), ('2935', '58.208.87.181', '', '', '1', '2008-08-22', '0'), ('2936', '218.6.243.123', '', '', '1', '2008-08-22', '0'), ('2212', '211.136.221.42', '上海', '移动', '0', '2008-08-18', '1'), ('2933', '211.143.204.193', '', '', '65', '2008-08-22', '0'), ('2934', '211.139.146.247', '', '', '25', '2008-08-22', '0'), ('2932', '211.139.148.41', '', '', '62', '2008-08-22', '0'), ('2931', '211.138.205.195', '', '', '8', '2008-08-22', '0'), ('2930', '211.139.146.236', '', '', '31', '2008-08-22', '0'), ('2928', '61.141.5.39', '', '移动', '0', '2008-10-15', '1'), ('2231', '211.137.199.53', '山东', '移动', '0', '2008-08-18', '1'), ('4345', '211.138.28.179', '', '', '59', '2008-08-27', '0'), ('2927', '125.91.253.225', '', '移动', '0', '2008-10-15', '1'), ('2926', '125.91.253.233', '', '移动', '0', '2008-10-15', '1'), ('5490', '116.252.57.172', '', '', '10', '2008-09-03', '0'), ('2925', '219.143.85.140', '', '', '2', '2008-08-22', '0'), ('2923', '125.91.253.212', '', '移动', '0', '2008-10-15', '1'), ('2921', '218.30.107.232', '', '移动', '0', '2008-10-15', '1'), ('2922', '60.0.75.159', '', '', '1', '2008-08-22', '0'), ('2920', '211.140.16.210', '', '', '37', '2008-08-21', '0'), ('2919', '203.92.154.37', '', '', '75', '2008-08-21', '0'), ('2918', '221.232.69.4', '', '', '1', '2008-08-21', '0'), ('2915', '218.200.224.238', '', '', '1', '2008-08-21', '0'), ('2916', '211.139.162.166', '', '', '15', '2008-08-21', '0'), ('2914', '67.228.166.99', '', '移动', '0', '2008-10-15', '1'), ('2913', '202.108.254.105', '', '', '48', '2008-08-21', '0'), ('5489', '116.25.34.104', '', '', '1', '2008-09-03', '0'), ('2910', '122.88.129.124', '', '', '2', '2008-08-21', '0'), ('2911', '218.15.100.159', '', '', '5', '2008-08-21', '0'), ('2908', '218.202.227.158', '', '', '24', '2008-08-21', '0'), ('2909', '211.139.162.162', '', '', '39', '2008-08-21', '0'), ('2907', '211.90.119.144', '', '联通', '1001', '2008-08-21', '1'), ('2904', '61.135.168.132', '', '', '8', '2008-08-21', '0'), ('2905', '116.25.234.53', '', '', '1', '2008-08-21', '0'), ('2906', '218.30.107.237', '', '移动', '0', '2008-10-15', '1'), ('2903', '211.97.65.179', '', '联通', '874', '2008-08-21', '0'), ('2902', '211.137.63.137', '', '', '2', '2008-08-21', '0'), ('2901', '211.140.16.251', '', '', '27', '2008-08-21', '0'), ('2900', '116.30.110.239', '', '', '1', '2008-08-21', '0'), ('2899', '125.91.253.152', '', '移动', '0', '2008-10-15', '1'), ('2898', '58.62.104.246', '', '', '1', '2008-08-21', '0'), ('2896', '221.130.197.160', '', '', '663', '2008-08-21', '0'), ('2897', '211.137.197.47', '', '', '3', '2008-08-21', '0'), ('2241', '211.138.172.201', '广东', '移动', '0', '2008-08-18', '1'), ('2895', '222.213.120.248', '', '', '1', '2008-08-21', '0'), ('2893', '211.136.228.244', '', '', '29', '2008-08-21', '0'), ('2894', '61.141.5.27', '', '移动', '0', '2008-10-15', '1'), ('2892', '211.136.75.8', '', '', '3', '2008-08-21', '0'), ('2890', '218.0.112.147', '', '', '1', '2008-08-21', '0'), ('2891', '211.136.228.82', '', '', '19', '2008-08-21', '0'), ('2794', '211.136.158.189', '', '', '30', '2008-08-21', '0'), ('2793', '211.140.16.225', '', '', '44', '2008-08-21', '0'), ('2792', '116.25.185.203', '', '', '1', '2008-08-21', '0'), ('2791', '211.139.146.199', '', '', '29', '2008-08-21', '0'), ('2790', '211.139.146.254', '', '', '26', '2008-08-21', '0'), ('2789', '211.140.16.242', '', '', '43', '2008-08-21', '0'), ('2788', '211.136.158.35', '', '', '25', '2008-08-21', '0'), ('2787', '114.241.14.24', '', '', '1', '2008-08-21', '0'), ('2786', '218.204.252.118', '', '移动', '0', '2008-10-15', '1'), ('2785', '116.213.64.53', '', '', '10', '2008-08-21', '0'), ('2784', '61.141.5.23', '', '移动', '0', '2008-10-15', '1'), ('2783', '58.211.115.116', '', '', '566', '2008-08-21', '0'), ('2781', '202.108.254.104', '', '', '40', '2008-08-21', '0'), ('2780', '125.91.253.227', '', '移动', '0', '2008-10-15', '1'), ('2779', '211.138.218.113', '', '', '1', '2008-08-21', '0'), ('2778', '211.138.201.147', '', '', '68', '2008-08-21', '0'), ('2777', '222.92.117.68', '', '', '154', '2008-08-21', '0'), ('2776', '218.30.107.230', '', '移动', '0', '2008-10-15', '1'), ('2775', '211.136.228.251', '', '', '42', '2008-08-21', '0'), ('2774', '222.92.117.67', '', '', '220', '2008-08-21', '0'), ('2773', '81.18.116.66', '', '', '54', '2008-08-21', '0'), ('2772', '203.81.19.17', '', '', '27', '2008-08-21', '0'), ('2752', '218.30.110.92', '', '移动', '0', '2008-10-15', '1'), ('2728', '203.86.77.147', '', '', '1', '2008-08-21', '0'), ('2712', '222.185.91.9', '', '', '2', '2008-08-21', '0'), ('2713', '59.64.171.75', '', '', '1', '2008-08-21', '0'), ('2203', '211.136.115.39', '上海', '移动', '0', '2008-08-18', '1'), ('2771', '211.137.163.28', '', '', '9', '2008-08-21', '0'), ('2770', '221.224.131.186', '', '', '67', '2008-08-21', '0'), ('2753', '222.245.34.102', '', '', '1', '2008-08-21', '0'), ('2741', '125.91.253.141', '', '移动', '0', '2008-10-15', '1'), ('2742', '64.122.13.248', '', '', '8', '2008-08-21', '0'), ('2729', '125.91.253.203', '', '移动', '0', '2008-10-15', '1'), ('2730', '116.26.247.94', '', '', '2', '2008-08-21', '0'), ('2731', '218.30.107.239', '', '移动', '0', '2008-10-15', '1'), ('2732', '125.66.74.107', '', '', '3', '2008-08-21', '0'), ('2769', '217.65.192.65', '', '', '4', '2008-08-21', '0'), ('2768', '203.81.19.14', '', '', '25', '2008-08-21', '0'), ('2767', '211.140.16.248', '', '', '116', '2008-08-21', '0'), ('2766', '196.11.241.97', '', '', '8', '2008-08-21', '0'), ('2765', '221.130.185.220', '', '', '1', '2008-08-21', '0'), ('2760', '220.181.32.84', '', '', '4', '2008-08-21', '0'), ('2761', '221.6.5.159', '', '', '161', '2008-08-21', '0'), ('2762', '220.164.174.251', '', '', '1', '2008-08-21', '0'), ('2763', '211.138.201.241', '', '', '61', '2008-08-21', '0'), ('2764', '221.222.239.149', '', '', '1', '2008-08-21', '0'), ('2260', '211.139.163.168', '广东', '移动', '0', '2008-08-18', '1'), ('2887', '211.138.201.244', '', '', '55', '2008-08-21', '0'), ('2888', '221.179.17.4', '', '', '46', '2008-08-21', '0'), ('2889', '221.229.163.219', '', '', '1', '2008-08-21', '0'), ('2759', '219.234.85.219', '', '', '77', '2008-08-21', '0'), ('2735', '218.30.107.243', '', '移动', '0', '2008-10-15', '1'), ('2736', '202.160.179.66', '', '', '1', '2008-08-21', '0'), ('2737', '218.30.107.231', '', '移动', '0', '2008-10-15', '1'), ('2738', '211.143.60.99', '', '', '328', '2008-08-21', '0'), ('5488', '58.216.203.138', '', '', '2', '2008-09-03', '0'), ('2740', '218.30.110.86', '', '移动', '0', '2008-10-15', '1'), ('2714', '211.137.62.236', '', '', '1', '2008-08-21', '0'), ('2715', '211.136.75.45', '', '', '1', '2008-08-21', '0'), ('2716', '99.236.105.48', '', '', '24', '2008-08-21', '0'), ('2717', '211.94.66.39', '', '', '364', '2008-08-21', '0'), ('2718', '203.81.19.28', '', '', '208', '2008-08-21', '0'), ('2719', '221.238.4.23', '', '', '1', '2008-08-21', '0'), ('2720', '116.25.28.57', '', '', '1', '2008-08-21', '0'), ('2721', '222.89.163.229', '', '', '1', '2008-08-21', '0'), ('2722', '220.193.98.245', '', '联通', '778', '2008-08-21', '0'), ('2723', '91.203.96.30', '', '', '5', '2008-08-21', '0'), ('2724', '195.189.142.200', '', '', '1', '2008-08-21', '0'), ('2725', '211.136.158.158', '', '', '2', '2008-08-21', '0'), ('2726', '196.207.32.38', '', '', '85', '2008-08-21', '0'), ('2687', '202.160.179.35', '', '', '1', '2008-08-21', '0'), ('2688', '218.30.110.179', '', '移动', '0', '2008-10-15', '1'), ('2689', '203.81.19.22', '', '', '215', '2008-08-21', '0'), ('2690', '59.151.46.184', '', '', '27', '2008-08-21', '0'), ('2691', '203.92.128.185', '', '', '263', '2008-08-21', '0'), ('2692', '202.160.178.163', '', '', '3', '2008-08-21', '0'), ('2693', '124.64.147.2', '', '', '1', '2008-08-21', '0'), ('2694', '211.136.228.86', '', '', '25', '2008-08-21', '0'), ('2695', '203.208.60.40', '', '', '21', '2008-08-21', '0'), ('2697', '203.81.19.20', '', '', '22', '2008-08-21', '0'), ('2698', '211.136.228.88', '', '', '28', '2008-08-21', '0'), ('2699', '203.208.60.35', '', '', '29', '2008-08-21', '0'), ('2700', '58.211.21.77', '', '移动', '0', '2008-10-15', '1'), ('2701', '203.208.60.31', '', '', '25', '2008-08-21', '0'), ('5487', '116.209.65.213', '', '', '2', '2008-09-03', '0'), ('2703', '203.208.60.38', '', '', '24', '2008-08-21', '0'), ('2704', '203.81.19.21', '', '', '211', '2008-08-21', '0'), ('2705', '67.195.37.185', '', '', '2', '2008-08-21', '0'), ('17284', '124.160.209.147', '浙江省嘉兴市', '联通', '0', '2011-04-26', '1'), ('2707', '220.181.32.33', '', '', '357', '2008-08-21', '0'), ('2708', '211.139.146.225', '', '', '32', '2008-08-21', '0'), ('2709', '211.138.103.66', '', '', '259', '2008-08-21', '0'), ('2710', '210.245.10.100', '', '', '2', '2008-08-21', '0'), ('2711', '61.141.5.25', '', '移动', '0', '2008-10-15', '1'), ('2754', '219.151.58.234', '', '', '2', '2008-08-21', '0'), ('2755', '125.91.4.176', '', '移动', '0', '2008-10-15', '1'), ('2757', '218.13.95.250', '', '', '2', '2008-08-21', '0'), ('2758', '219.129.165.254', '', '', '14', '2008-08-21', '0'), ('2743', '211.139.190.127', '', '', '102', '2008-08-21', '0'), ('2746', '123.108.237.1', '', '', '1', '2008-08-21', '0'), ('2747', '218.30.110.171', '', '移动', '0', '2008-10-15', '1'), ('2748', '125.91.253.150', '', '移动', '0', '2008-10-15', '1'), ('2749', '125.72.192.26', '', '', '2', '2008-08-21', '0'), ('2750', '211.139.146.242', '', '', '28', '2008-08-21', '0'), ('2199', '116.19.158.115', '广东', '移动', '0', '2008-08-18', '1'), ('2200', '116.26.168.185', '广东', '移动', '0', '2008-08-18', '1'), ('2201', '2.137.59.23', '湖北', '移动', '0', '2008-08-18', '1'), ('4372', '221.206.74.225', '', '', '1', '2008-08-27', '0'), ('4373', '121.15.2.122', '', '', '1', '2008-08-27', '0'), ('4374', '211.139.189.181', '', '', '24', '2008-08-27', '0'), ('4375', '58.217.222.121', '', '', '10', '2008-08-27', '0'), ('4376', '125.92.237.100', '', '', '1', '2008-08-27', '0'), ('4377', '221.179.17.7', '', '', '43', '2008-08-27', '0'), ('4378', '117.66.74.14', '', '', '1', '2008-08-27', '0'), ('4379', '202.144.209.2', '', '', '57', '2008-08-27', '0'), ('4380', '222.130.170.107', '', '', '1', '2008-08-27', '0'), ('4381', '219.137.111.81', '', '', '1', '2008-08-27', '0'), ('4382', '123.184.174.1', '', '', '3', '2008-08-27', '0'), ('4383', '221.206.107.114', '', '', '4', '2008-08-27', '0'), ('4384', '121.32.14.108', '', '', '1', '2008-08-27', '0'), ('4385', '211.145.97.213', '', '', '1', '2008-08-27', '0'), ('4386', '222.68.164.32', '', '', '1', '2008-08-27', '0'), ('4387', '220.114.45.193', '', '', '1', '2008-08-27', '0'), ('4388', '61.141.5.37', '', '移动', '0', '2008-10-15', '1'), ('4389', '59.36.182.155', '', '', '3', '2008-08-27', '0'), ('4390', '119.181.50.149', '', '', '1', '2008-08-27', '0'), ('4391', '58.48.107.150', '', '', '1', '2008-08-27', '0'), ('4392', '121.14.136.33', '', '', '3', '2008-08-27', '0'), ('4393', '211.137.181.254', '', '', '11', '2008-08-27', '0'), ('4394', '211.139.162.136', '', '', '68', '2008-08-27', '0'), ('4395', '123.175.194.165', '', '', '2', '2008-08-27', '0'), ('4396', '59.40.186.53', '', '', '13', '2008-08-27', '0'), ('4397', '58.59.198.52', '', '', '1', '2008-08-27', '0'), ('4398', '211.137.63.144', '', '', '10', '2008-08-27', '0'), ('4399', '58.248.168.146', '', '', '1', '2008-08-28', '0'), ('4400', '123.112.53.146', '', '', '2', '2008-08-28', '0'), ('4401', '116.17.53.109', '', '', '1', '2008-08-28', '0'), ('4402', '58.212.80.224', '', '', '1', '2008-08-28', '0'), ('4403', '116.4.37.213', '', '', '1', '2008-08-28', '0'), ('4404', '218.3.146.183', '', '', '1', '2008-08-28', '0'), ('4405', '58.211.21.84', '', '移动', '0', '2008-10-15', '1'), ('5486', '58.211.21.102', '', '移动', '0', '2008-10-15', '1'), ('4407', '211.136.158.183', '', '', '2', '2008-08-28', '0'), ('4408', '218.30.110.167', '', '移动', '0', '2008-10-15', '1'), ('4409', '202.86.145.77', '', '', '1', '2008-08-28', '0'), ('4410', '211.139.162.202', '', '', '23', '2008-08-28', '0'), ('4411', '58.253.144.244', '', '', '1', '2008-08-28', '0'), ('4412', '121.28.205.46', '', '', '1', '2008-08-28', '0'), ('4413', '211.94.69.233', '', '', '16', '2008-08-28', '0'), ('4414', '211.136.73.97', '', '', '8', '2008-08-28', '0'), ('4415', '222.130.85.139', '', '', '2', '2008-08-28', '0'), ('4416', '202.160.179.53', '', '', '3', '2008-08-28', '0'), ('4417', '202.160.178.167', '', '', '1', '2008-08-28', '0'), ('4418', '116.52.116.77', '', '', '1', '2008-08-28', '0'), ('4419', '220.206.246.54', '', '', '2', '2008-08-28', '0'), ('4420', '210.14.67.77', '', '', '2', '2008-08-28', '0'), ('4421', '116.5.255.37', '', '', '2', '2008-08-28', '0'), ('4422', '222.244.47.128', '', '', '1', '2008-08-28', '0'), ('4423', '219.131.186.185', '', '', '1', '2008-08-28', '0'), ('4424', '118.88.176.65', '', '', '1', '2008-08-28', '0'), ('4425', '211.140.16.235', '', '', '53', '2008-08-28', '0'), ('4426', '211.136.73.96', '', '', '7', '2008-08-28', '0'), ('4427', '202.149.24.129', '', '', '1', '2008-08-28', '0'), ('4428', '202.160.180.80', '', '', '1', '2008-08-28', '0'), ('4429', '211.137.63.152', '', '', '1', '2008-08-28', '0'), ('4430', '61.144.113.145', '', '', '3', '2008-08-28', '0'), ('4431', '220.192.112.136', '', '', '1', '2008-08-28', '0'), ('4432', '203.208.60.18', '', '', '3', '2008-08-28', '0'), ('4433', '61.141.157.116', '', '', '2', '2008-08-28', '0'), ('4434', '202.149.24.161', '', '', '2', '2008-08-28', '0'), ('4435', '123.175.248.132', '', '', '16', '2008-08-28', '0'), ('4436', '220.206.213.99', '', '', '1', '2008-08-28', '0'), ('4437', '63.173.173.253', '', '', '1', '2008-08-28', '0'), ('4438', '202.156.8.9', '', '', '2', '2008-08-28', '0'), ('4439', '122.234.24.141', '', '', '1', '2008-08-28', '0'), ('4440', '119.39.177.92', '', '', '6', '2008-08-28', '0'), ('4441', '80.232.117.40', '', '', '1', '2008-08-28', '0'), ('4442', '211.136.73.105', '', '', '20', '2008-08-28', '0'), ('4443', '202.160.178.203', '', '', '1', '2008-08-28', '0'), ('4444', '220.194.137.13', '', '', '2', '2008-08-28', '0'), ('4445', '218.86.127.42', '', '', '7', '2008-08-28', '0'), ('4446', '58.83.127.201', '', '', '4', '2008-08-28', '0'), ('4447', '59.36.40.2', '', '', '1', '2008-08-28', '0'), ('4624', '124.227.101.68', '', '', '1', '2008-08-29', '0'), ('4449', '121.8.64.118', '', '', '1', '2008-08-28', '0'), ('4450', '218.59.125.202', '', '', '1', '2008-08-28', '0'), ('4451', '211.139.162.135', '', '', '43', '2008-08-28', '0'), ('4452', '202.108.7.202', '', '', '3', '2008-08-28', '0'), ('4453', '116.16.163.105', '', '', '1', '2008-08-28', '0'), ('4454', '203.142.123.140', '', '', '1', '2008-08-28', '0'), ('4455', '125.124.243.56', '', '', '1', '2008-08-28', '0'), ('4456', '116.26.226.252', '', '', '1', '2008-08-28', '0'), ('4457', '219.135.80.15', '', '', '1', '2008-08-28', '0'), ('4458', '222.132.119.90', '', '', '1', '2008-08-28', '0'), ('4459', '123.129.40.211', '', '', '1', '2008-08-28', '0'), ('4460', '61.130.79.186', '', '', '2', '2008-08-28', '0'), ('4461', '91.203.96.32', '', '', '1', '2008-08-28', '0'), ('4462', '116.60.32.94', '', '', '1', '2008-08-28', '0'), ('4463', '211.138.167.178', '', '', '28', '2008-08-28', '0'), ('4464', '211.137.197.58', '', '', '19', '2008-08-28', '0'), ('4465', '211.139.71.141', '', '', '14', '2008-08-28', '0'), ('4466', '219.152.11.98', '', '', '1', '2008-08-28', '0'), ('4467', '211.137.63.181', '', '', '1', '2008-08-28', '0'), ('4468', '211.139.162.189', '', '', '21', '2008-08-28', '0'), ('4469', '221.215.218.14', '', '', '4', '2008-08-28', '0'), ('4470', '221.222.200.102', '', '', '2', '2008-08-28', '0'), ('4471', '218.20.50.159', '', '', '1', '2008-08-28', '0'), ('4472', '222.64.135.175', '', '', '1', '2008-08-28', '0'), ('4473', '122.246.185.121', '', '', '1', '2008-08-28', '0'), ('4474', '218.200.224.190', '', '', '1', '2008-08-28', '0'), ('4475', '211.139.162.193', '', '', '18', '2008-08-28', '0'), ('4476', '58.83.127.205', '', '', '1', '2008-08-28', '0'), ('4477', '202.160.180.75', '', '', '2', '2008-08-28', '0'), ('4478', '61.187.123.74', '', '', '1', '2008-08-28', '0'), ('4479', '211.139.16.182', '', '', '16', '2008-08-28', '0'), ('4480', '219.136.97.79', '', '', '5', '2008-08-28', '0'), ('4481', '59.51.114.34', '', '', '15', '2008-08-28', '0'), ('4482', '202.160.180.174', '', '', '1', '2008-08-28', '0'), ('4483', '58.50.29.100', '', '', '1', '2008-08-28', '0'), ('4484', '220.181.5.59', '', '', '1', '2008-08-28', '0'), ('4485', '222.66.155.34', '', '', '1', '2008-08-28', '0'), ('4486', '60.1.37.78', '', '', '1', '2008-08-28', '0'), ('4487', '116.235.159.200', '', '', '1', '2008-08-28', '0'), ('4488', '116.31.158.162', '', '', '1', '2008-08-28', '0'), ('4489', '116.23.27.117', '', '', '1', '2008-08-28', '0'), ('4490', '125.121.193.14', '', '', '1', '2008-08-28', '0'), ('4491', '60.29.123.62', '', '', '6', '2008-08-28', '0'), ('4492', '60.179.12.89', '', '', '1', '2008-08-28', '0'), ('4493', '121.13.134.229', '', '', '1', '2008-08-28', '0'), ('4494', '211.140.16.237', '', '', '43', '2008-08-28', '0'), ('4495', '221.7.77.12', '', '', '1', '2008-08-28', '0'), ('4496', '121.29.126.200', '', '', '1', '2008-08-28', '0'), ('4497', '202.160.179.79', '', '', '2', '2008-08-28', '0'), ('4498', '121.33.174.54', '', '', '1', '2008-08-28', '0'), ('4499', '61.149.77.93', '', '', '1', '2008-08-28', '0'), ('4500', '221.206.235.245', '', '', '1', '2008-08-28', '0'), ('4501', '123.127.114.194', '', '', '1', '2008-08-28', '0'), ('4502', '123.175.197.212', '', '', '193', '2008-08-28', '0'), ('4503', '121.32.86.182', '', '', '1', '2008-08-28', '0'), ('4504', '119.141.222.206', '', '', '5', '2008-08-28', '0'), ('4505', '125.95.44.19', '', '', '1', '2008-08-28', '0'), ('4506', '116.25.185.91', '', '', '2', '2008-08-28', '0'), ('4507', '125.77.118.81', '', '', '1', '2008-08-28', '0'), ('4508', '211.136.158.250', '', '', '1', '2008-08-28', '0'), ('4509', '60.165.209.235', '', '', '1', '2008-08-28', '0'), ('4510', '122.100.162.99', '', '', '1', '2008-08-28', '0'), ('4511', '202.175.4.130', '', '', '17', '2008-08-28', '0'), ('4512', '220.255.7.209', '', '', '1', '2008-08-28', '0'), ('4513', '122.236.240.73', '', '', '1', '2008-08-28', '0'), ('4514', '222.88.242.98', '', '', '3', '2008-08-28', '0'), ('4515', '116.17.54.243', '', '', '2', '2008-08-28', '0'), ('4516', '119.122.17.32', '', '', '1', '2008-08-28', '0'), ('4517', '121.15.232.106', '', '', '1', '2008-08-28', '0'), ('4518', '59.41.170.155', '', '', '1', '2008-08-28', '0'), ('4519', '219.133.174.57', '', '', '1', '2008-08-28', '0'), ('4520', '121.207.21.177', '', '', '1', '2008-08-28', '0'), ('4521', '58.252.203.182', '', '', '1', '2008-08-28', '0'), ('4522', '211.90.241.245', '', '', '1', '2008-08-28', '0'), ('4523', '116.4.50.252', '', '', '1', '2008-08-28', '0'), ('4524', '222.90.143.154', '', '', '1', '2008-08-28', '0'), ('4525', '121.68.29.48', '', '', '1', '2008-08-28', '0'), ('4526', '220.194.137.8', '', '', '1', '2008-08-28', '0'), ('4527', '91.203.96.14', '', '', '3', '2008-08-28', '0'), ('4528', '195.189.142.142', '', '', '2', '2008-08-28', '0'), ('4529', '125.78.215.194', '', '', '1', '2008-08-28', '0'), ('4530', '116.209.229.37', '', '', '1', '2008-08-28', '0'), ('4531', '121.68.0.243', '', '', '1', '2008-08-28', '0'), ('4532', '60.215.96.24', '', '', '2', '2008-08-28', '0'), ('4533', '219.78.30.95', '', '', '1', '2008-08-28', '0'), ('4534', '119.163.113.2', '', '', '1', '2008-08-28', '0'), ('4535', '211.136.73.70', '', '', '11', '2008-08-28', '0'), ('4536', '91.203.96.17', '', '', '2', '2008-08-28', '0'), ('4537', '125.78.73.128', '', '', '1', '2008-08-28', '0'), ('4538', '210.14.64.103', '', '', '1', '2008-08-28', '0'), ('4539', '125.93.35.39', '', '', '1', '2008-08-28', '0'), ('4540', '219.135.35.103', '', '', '1', '2008-08-28', '0'), ('5485', '123.116.206.194', '', '', '1', '2008-09-03', '0'), ('4542', '220.206.246.17', '', '', '4', '2008-08-29', '0'), ('4543', '202.160.178.171', '', '', '2', '2008-08-29', '0'), ('4544', '211.136.158.50', '', '', '8', '2008-08-29', '0'), ('4545', '217.201.74.61', '', '', '1', '2008-08-29', '0'), ('4546', '116.21.177.79', '', '', '1', '2008-08-29', '0'), ('4547', '219.134.109.76', '', '', '2', '2008-08-29', '0'), ('4548', '220.181.32.61', '', '', '5', '2008-08-29', '0'), ('4549', '202.160.180.199', '', '', '1', '2008-08-29', '0'), ('4550', '211.139.162.180', '', '', '17', '2008-08-29', '0'), ('4551', '211.136.75.51', '', '', '5', '2008-08-29', '0'), ('4552', '58.209.40.96', '', '', '1', '2008-08-29', '0'), ('4553', '211.136.75.76', '', '', '25', '2008-08-29', '0'), ('4554', '59.38.5.233', '', '', '1', '2008-08-29', '0'), ('4555', '125.68.18.236', '', '', '1', '2008-08-29', '0'), ('4556', '211.136.228.69', '', '', '12', '2008-08-29', '0'), ('4557', '202.101.70.109', '', '', '1', '2008-08-29', '0'), ('4558', '211.139.71.143', '', '', '8', '2008-08-29', '0'), ('4559', '221.10.19.242', '', '', '2', '2008-08-29', '0'), ('4560', '218.202.6.164', '', '', '4', '2008-08-29', '0'), ('4561', '211.136.158.144', '', '', '4', '2008-08-29', '0'), ('4562', '211.139.16.183', '', '', '20', '2008-08-29', '0'), ('4563', '202.160.180.104', '', '', '1', '2008-08-29', '0'), ('4564', '119.123.20.73', '', '', '1', '2008-08-29', '0'), ('4565', '59.172.158.230', '', '', '1', '2008-08-29', '0'), ('4566', '125.36.72.180', '', '', '1', '2008-08-29', '0'), ('4567', '221.125.215.229', '', '', '1', '2008-08-29', '0'), ('4568', '220.206.246.27', '', '', '1', '2008-08-29', '0'), ('4569', '61.142.247.138', '', '', '43', '2008-08-29', '0'), ('4570', '125.91.96.14', '', '', '5', '2008-08-29', '0'), ('4571', '203.208.60.10', '', '', '8', '2008-08-29', '0'), ('4572', '82.114.165.170', '', '', '1', '2008-08-29', '0'), ('4573', '116.25.27.26', '', '', '1', '2008-08-29', '0'), ('4574', '60.174.115.213', '', '', '1', '2008-08-29', '0'), ('4575', '202.160.178.139', '', '', '1', '2008-08-29', '0'), ('4576', '211.138.227.70', '', '', '1', '2008-08-29', '0'), ('4577', '116.209.224.18', '', '', '1', '2008-08-29', '0'), ('4578', '220.207.82.114', '', '', '1', '2008-08-29', '0'), ('4579', '116.204.53.0', '', '', '1', '2008-08-29', '0'), ('4580', '59.56.110.167', '', '', '1', '2008-08-29', '0'), ('4581', '220.180.90.190', '', '', '1', '2008-08-29', '0'), ('4582', '121.9.128.208', '', '', '3', '2008-08-29', '0'), ('4583', '202.160.179.115', '', '', '1', '2008-08-29', '0'), ('4584', '58.211.21.97', '', '移动', '0', '2008-10-15', '1'), ('4585', '211.136.73.65', '', '', '13', '2008-08-29', '0'), ('4586', '58.255.253.196', '', '', '3', '2008-08-29', '0'), ('4587', '218.19.66.31', '', '', '15', '2008-08-29', '0'), ('4588', '60.166.221.209', '', '', '1', '2008-08-29', '0'), ('4589', '202.160.178.141', '', '', '1', '2008-08-29', '0'), ('4590', '58.253.158.83', '', '', '1', '2008-08-29', '0'), ('4591', '120.87.198.126', '', '', '1', '2008-08-29', '0'), ('4592', '122.4.111.249', '', '', '1', '2008-08-29', '0'), ('4593', '218.249.83.87', '', '', '1', '2008-08-29', '0'), ('4594', '123.112.36.196', '', '', '1', '2008-08-29', '0'), ('4595', '61.144.118.163', '', '', '2', '2008-08-29', '0'), ('4596', '221.195.44.6', '', '', '1', '2008-08-29', '0'), ('4597', '211.141.161.50', '', '', '20', '2008-08-29', '0'), ('4598', '61.135.166.30', '', '', '4', '2008-08-29', '0'), ('4599', '123.8.213.235', '', '', '1', '2008-08-29', '0'), ('4600', '58.211.21.83', '', '移动', '0', '2008-10-15', '1'), ('4601', '58.33.247.202', '', '', '2', '2008-08-29', '0'), ('4602', '123.147.11.230', '', '', '1', '2008-08-29', '0'), ('4603', '195.189.142.51', '', '', '4', '2008-08-29', '0'), ('4604', '211.138.227.163', '', '', '1', '2008-08-29', '0'), ('4605', '202.160.178.155', '', '', '1', '2008-08-29', '0'), ('4606', '211.136.73.98', '', '', '9', '2008-08-29', '0'), ('4607', '218.19.207.31', '', '', '1', '2008-08-29', '0'), ('4608', '221.0.82.216', '', '', '2', '2008-08-29', '0'), ('4609', '58.255.170.27', '', '', '1', '2008-08-29', '0'), ('4610', '211.140.16.252', '', '', '48', '2008-08-29', '0'), ('4611', '218.205.238.106', '', '', '2', '2008-08-29', '0'), ('5484', '208.65.73.103', '', '', '26', '2008-09-03', '0'), ('4613', '220.181.32.23', '', '', '3', '2008-08-29', '0'), ('4614', '117.95.50.6', '', '', '2', '2008-08-29', '0'), ('4615', '211.140.16.247', '', '', '25', '2008-08-29', '0'), ('4616', '124.64.147.92', '', '', '1', '2008-08-29', '0'), ('4617', '218.30.110.166', '', '移动', '0', '2008-10-15', '1'), ('4618', '120.10.140.58', '', '', '1', '2008-08-29', '0'), ('4619', '121.68.0.254', '', '', '1', '2008-08-29', '0'), ('4620', '202.160.178.77', '', '', '2', '2008-08-29', '0'), ('4621', '125.91.4.156', '', '移动', '0', '2008-10-15', '1'), ('4622', '221.212.165.62', '', '', '1', '2008-08-29', '0'), ('4623', '220.206.235.117', '', '', '8', '2008-08-29', '0'), ('4625', '124.147.145.88', '', '', '2', '2008-08-29', '0'), ('4626', '220.206.235.100', '', '', '2', '2008-08-29', '0'), ('4627', '219.136.156.180', '', '', '1', '2008-08-29', '0'), ('4628', '218.75.108.66', '', '', '1', '2008-08-29', '0'), ('4629', '123.15.47.25', '', '', '1', '2008-08-29', '0'), ('4630', '218.200.224.133', '', '', '1', '2008-08-29', '0'), ('4631', '117.26.214.176', '', '', '1', '2008-08-29', '0'), ('4632', '123.244.82.138', '', '', '1', '2008-08-29', '0'), ('4633', '203.208.60.23', '', '', '36', '2008-08-29', '0'), ('5483', '58.211.155.114', '', '', '1', '2008-09-03', '0'), ('4635', '218.19.231.10', '', '', '1', '2008-08-29', '0'), ('4636', '59.41.45.233', '', '', '1', '2008-08-29', '0'), ('4637', '59.41.70.222', '', '', '1', '2008-08-29', '0'), ('4638', '203.208.60.26', '', '', '21', '2008-08-29', '0'), ('4639', '118.147.39.242', '', '', '1', '2008-08-29', '0'), ('4640', '59.41.188.103', '', '', '1', '2008-08-29', '0'), ('4641', '222.73.95.28', '', '', '1', '2008-08-29', '0'), ('4642', '202.160.178.199', '', '', '1', '2008-08-29', '0'), ('4643', '66.249.67.180', '', '', '35', '2008-08-29', '0'), ('4644', '61.145.143.160', '', '', '1', '2008-08-29', '0'), ('4645', '123.52.7.217', '', '', '1', '2008-08-29', '0'), ('4646', '202.160.180.112', '', '', '2', '2008-08-29', '0'), ('4647', '218.207.20.26', '', '', '1', '2008-08-29', '0'), ('4648', '211.139.16.184', '', '', '25', '2008-08-29', '0'), ('4649', '59.57.139.70', '', '', '1', '2008-08-29', '0'), ('4650', '220.206.246.63', '', '', '6', '2008-08-29', '0'), ('4651', '218.200.224.49', '', '', '1', '2008-08-29', '0'), ('4652', '203.208.60.21', '', '', '30', '2008-08-29', '0'), ('4653', '121.68.0.241', '', '', '2', '2008-08-29', '0'), ('4654', '114.120.63.17', '', '', '1', '2008-08-29', '0'), ('4655', '58.62.172.243', '', '', '1', '2008-08-29', '0'), ('4656', '218.205.249.102', '', '', '1', '2008-08-29', '0'), ('4657', '203.88.8.6', '', '', '1', '2008-08-29', '0'), ('4658', '119.120.218.183', '', '', '1', '2008-08-29', '0'), ('4659', '202.160.179.130', '', '', '1', '2008-08-29', '0'), ('4660', '123.184.174.2', '', '', '1', '2008-08-29', '0'), ('4661', '202.160.178.28', '', '', '1', '2008-08-29', '0'), ('4662', '116.17.94.1', '', '', '1', '2008-08-29', '0'), ('4663', '219.130.51.92', '', '', '1', '2008-08-29', '0'), ('4664', '221.193.196.92', '', '', '1', '2008-08-29', '0'), ('4665', '116.235.224.76', '', '', '2', '2008-08-29', '0'), ('4666', '220.178.61.195', '', '', '2', '2008-08-29', '0'), ('4667', '220.206.235.4', '', '', '1', '2008-08-29', '0'), ('4668', '122.5.84.89', '', '', '2', '2008-08-29', '0'), ('4669', '124.132.189.121', '', '', '2', '2008-08-29', '0'), ('4670', '58.60.184.67', '', '', '2', '2008-08-29', '0'), ('4671', '117.85.65.119', '', '', '1', '2008-08-29', '0'), ('4672', '116.26.240.247', '', '', '2', '2008-08-29', '0'), ('4673', '218.15.106.120', '', '', '1', '2008-08-29', '0'), ('4674', '125.124.22.3', '', '', '1', '2008-08-29', '0'), ('4675', '219.136.12.116', '', '', '1', '2008-08-29', '0'), ('4676', '218.27.58.151', '', '', '2', '2008-08-29', '0'), ('4677', '61.135.220.23', '', '', '2', '2008-08-29', '0'), ('4678', '116.25.255.56', '', '', '1', '2008-08-29', '0'), ('4679', '58.61.182.110', '', '', '2', '2008-08-29', '0'), ('4680', '116.27.29.73', '', '', '1', '2008-08-29', '0'), ('4681', '219.130.183.219', '', '', '2', '2008-08-29', '0'), ('4682', '211.139.162.134', '', '', '45', '2008-08-29', '0'), ('4683', '221.221.182.142', '', '', '1', '2008-08-29', '0'), ('4684', '58.61.8.167', '', '', '1', '2008-08-29', '0'), ('4685', '125.89.111.42', '', '', '1', '2008-08-29', '0'), ('4686', '220.206.235.65', '', '', '1', '2008-08-29', '0'), ('4687', '220.206.218.1', '', '', '100', '2008-08-29', '0'), ('4688', '125.87.118.40', '', '', '1', '2008-08-29', '0'), ('4689', '218.205.249.150', '', '', '1', '2008-08-29', '0'), ('4690', '211.138.227.120', '', '', '3', '2008-08-29', '0'), ('4691', '221.11.7.174', '', '', '3', '2008-08-29', '0'), ('4692', '220.206.246.57', '', '', '3', '2008-08-29', '0'), ('5482', '124.67.39.102', '', '', '1', '2008-09-03', '0'), ('4694', '218.200.224.32', '', '', '3', '2008-08-29', '0'), ('4695', '220.179.150.99', '', '', '1', '2008-08-29', '0'), ('4696', '74.6.17.190', '', '', '13', '2008-08-29', '0'), ('4697', '202.156.9.2', '', '', '2', '2008-08-29', '0'), ('4698', '222.70.234.203', '', '', '1', '2008-08-29', '0'), ('4699', '123.120.99.132', '', '', '1', '2008-08-30', '0'), ('4700', '121.205.49.62', '', '', '1', '2008-08-30', '0'), ('4701', '121.32.114.149', '', '', '1', '2008-08-30', '0'), ('4702', '219.130.8.254', '', '', '1', '2008-08-30', '0'), ('4703', '211.136.158.148', '', '', '6', '2008-08-30', '0'), ('4704', '203.208.60.25', '', '', '25', '2008-08-30', '0'), ('4705', '60.166.227.234', '', '', '1', '2008-08-30', '0'), ('4706', '61.181.87.170', '', '', '10', '2008-08-30', '0'), ('4707', '221.221.219.148', '', '', '1', '2008-08-30', '0'), ('4708', '211.136.75.197', '', '', '21', '2008-08-30', '0'), ('5481', '219.133.88.161', '', '', '2', '2008-09-03', '0'), ('4710', '222.248.74.100', '', '', '2', '2008-08-30', '0'), ('4711', '58.255.81.62', '', '', '1', '2008-08-30', '0'), ('4712', '211.100.222.116', '', '', '13', '2008-08-30', '0'), ('4713', '211.139.16.177', '', '', '13', '2008-08-30', '0'), ('4714', '116.29.176.158', '', '', '1', '2008-08-30', '0'), ('4715', '121.12.179.42', '', '', '1', '2008-08-30', '0'), ('4716', '58.255.149.118', '', '', '1', '2008-08-30', '0'), ('4717', '203.208.60.13', '', '', '5', '2008-08-30', '0'), ('4718', '219.137.58.214', '', '', '2', '2008-08-30', '0'), ('4719', '220.175.138.49', '', '', '1', '2008-08-30', '0'), ('4720', '59.175.17.234', '', '', '1', '2008-08-30', '0'), ('4721', '190.73.25.216', '', '', '1', '2008-08-30', '0'), ('4722', '218.66.14.153', '', '', '1', '2008-08-30', '0'), ('4723', '202.160.42.76', '', '', '18', '2008-08-30', '0'), ('4724', '211.136.73.77', '', '', '4', '2008-08-30', '0'), ('4725', '58.63.193.67', '', '', '1', '2008-08-30', '0'), ('4726', '116.25.141.151', '', '', '1', '2008-08-30', '0'), ('4727', '218.30.103.147', '', '', '4', '2008-08-30', '0'), ('4728', '203.116.22.182', '', '', '2', '2008-08-30', '0'), ('4729', '66.249.72.18', '', '', '6', '2008-08-30', '0'), ('4730', '66.249.70.108', '', '', '1938', '2008-08-30', '0'), ('4731', '219.137.217.152', '', '', '3', '2008-08-30', '0'), ('4732', '123.151.56.44', '', '', '1', '2008-08-30', '0'), ('4733', '211.141.68.68', '', '', '11', '2008-08-30', '0'), ('4734', '203.208.60.6', '', '', '154', '2008-08-30', '0'), ('4735', '60.15.80.203', '', '', '1', '2008-08-30', '0'), ('4736', '61.145.99.248', '', '', '1', '2008-08-30', '0'), ('4737', '59.36.15.41', '', '', '1', '2008-08-30', '0'), ('4738', '218.71.106.10', '', '', '2', '2008-08-30', '0'), ('4739', '121.14.255.195', '', '', '1', '2008-08-30', '0'), ('4740', '76.67.186.216', '', '', '1', '2008-08-30', '0'), ('4741', '221.217.194.171', '', '', '1', '2008-08-30', '0'), ('4742', '218.205.249.82', '', '', '2', '2008-08-30', '0'), ('4743', '121.35.82.183', '', '', '1', '2008-08-30', '0'), ('4744', '222.188.131.92', '', '', '1', '2008-08-30', '0'), ('4745', '216.9.243.104', '', '', '4', '2008-08-30', '0'), ('4746', '219.136.49.221', '', '', '2', '2008-08-30', '0'), ('4747', '211.136.158.153', '', '', '2', '2008-08-30', '0'), ('4748', '211.141.161.52', '', '', '22', '2008-08-30', '0'), ('4749', '218.20.225.6', '', '', '6', '2008-08-30', '0'), ('4750', '74.6.17.185', '', '', '85', '2008-08-30', '0'), ('4751', '79.84.63.187', '', '', '1', '2008-08-30', '0'), ('4752', '121.33.138.245', '', '', '1', '2008-08-30', '0'), ('4753', '221.130.199.13', '', '', '4', '2008-08-30', '0'), ('4754', '125.88.216.67', '', '', '1', '2008-08-30', '0'), ('4755', '220.194.137.1', '', '', '4', '2008-08-30', '0'), ('4756', '121.29.31.225', '', '', '1', '2008-08-30', '0'), ('4757', '121.35.250.125', '', '', '1', '2008-08-30', '0'), ('4758', '218.59.22.41', '', '', '2', '2008-08-30', '0'), ('4759', '121.14.96.152', '', '', '2', '2008-08-30', '0'), ('4760', '220.181.32.12', '', '', '6', '2008-08-30', '0'), ('4761', '122.88.129.145', '', '', '1', '2008-08-30', '0'), ('4762', '119.128.162.184', '', '', '1', '2008-08-30', '0'), ('4763', '125.91.156.47', '', '', '1', '2008-08-30', '0'), ('4764', '218.15.230.5', '', '', '1', '2008-08-30', '0'), ('4765', '58.214.232.50', '', '', '1', '2008-08-30', '0'), ('4766', '211.137.62.254', '', '', '1', '2008-08-30', '0'), ('4767', '211.138.205.194', '', '', '19', '2008-08-30', '0'), ('4768', '116.26.255.206', '', '', '3', '2008-08-30', '0'), ('4769', '211.140.16.220', '', '', '32', '2008-08-30', '0'), ('4770', '211.136.75.109', '', '', '1', '2008-08-30', '0'), ('4771', '66.249.70.100', '', '', '1', '2008-08-30', '0'), ('4772', '66.249.70.86', '', '', '1', '2008-08-30', '0'), ('4773', '116.16.229.24', '', '', '1', '2008-08-30', '0'), ('5480', '58.242.206.124', '', '', '1', '2008-09-03', '0'), ('4775', '202.160.180.160', '', '', '1', '2008-08-30', '0'), ('4776', '122.7.29.31', '', '', '1', '2008-08-30', '0'), ('4777', '218.28.62.242', '', '', '1', '2008-08-30', '0'), ('4778', '220.206.246.4', '', '', '2', '2008-08-30', '0'), ('4779', '211.139.162.191', '', '', '23', '2008-08-30', '0'), ('4780', '219.135.129.40', '', '', '1', '2008-08-30', '0'), ('4781', '195.189.143.52', '', '', '1', '2008-08-30', '0'), ('4782', '211.143.149.106', '', '', '1', '2008-08-30', '0');
INSERT INTO `ig_gateway` VALUES ('4783', '123.132.7.157', '', '', '2', '2008-08-30', '0'), ('4784', '125.79.137.172', '', '', '9', '2008-08-30', '0'), ('4785', '125.65.56.247', '', '', '1', '2008-08-30', '0'), ('4786', '41.208.11.193', '', '', '1', '2008-08-30', '0'), ('4787', '114.92.168.61', '', '', '1', '2008-08-30', '0'), ('4788', '221.236.60.81', '', '', '1', '2008-08-30', '0'), ('4789', '211.136.75.80', '', '', '2', '2008-08-30', '0'), ('4790', '60.177.19.27', '', '', '1', '2008-08-30', '0'), ('4791', '202.149.25.234', '', '', '2', '2008-08-30', '0'), ('4792', '61.146.41.74', '', '', '1', '2008-08-30', '0'), ('4793', '202.160.180.11', '', '', '1', '2008-08-30', '0'), ('4794', '202.149.25.233', '', '', '2', '2008-08-30', '0'), ('4795', '222.88.11.30', '', '', '3', '2008-08-30', '0'), ('4796', '120.137.78.20', '', '', '1', '2008-08-30', '0'), ('4797', '125.119.111.174', '', '', '1', '2008-08-30', '0'), ('4798', '116.24.29.252', '', '', '2', '2008-08-30', '0'), ('4799', '60.52.154.181', '', '', '1', '2008-08-30', '0'), ('4800', '202.160.180.161', '', '', '1', '2008-08-30', '0'), ('4801', '59.42.99.182', '', '', '3', '2008-08-30', '0'), ('4802', '116.213.64.46', '', '', '1', '2008-08-30', '0'), ('4803', '218.23.245.190', '', '', '2', '2008-08-30', '0'), ('4804', '124.155.209.164', '', '', '2', '2008-08-30', '0'), ('4805', '119.128.9.100', '', '', '1', '2008-08-30', '0'), ('4806', '124.227.1.177', '', '', '24', '2008-08-30', '0'), ('4807', '116.77.179.120', '', '', '1', '2008-08-30', '0'), ('4808', '220.192.137.208', '', '', '2', '2008-08-30', '0'), ('4809', '220.181.61.229', '', '', '1', '2008-08-30', '0'), ('4810', '116.16.162.43', '', '', '1', '2008-08-30', '0'), ('4811', '121.29.15.195', '', '', '2', '2008-08-30', '0'), ('4812', '121.90.243.135', '', '', '2', '2008-08-30', '0'), ('4813', '123.232.113.130', '', '', '1', '2008-08-30', '0'), ('4814', '222.175.53.198', '', '', '6', '2008-08-30', '0'), ('4815', '58.63.100.118', '', '', '1', '2008-08-30', '0'), ('4816', '124.15.25.158', '', '', '1', '2008-08-30', '0'), ('4817', '125.78.193.98', '', '', '1', '2008-08-30', '0'), ('4818', '221.5.78.205', '', '', '3', '2008-08-30', '0'), ('4819', '58.211.114.66', '', '', '5', '2008-08-30', '0'), ('4820', '219.130.174.93', '', '', '1', '2008-08-30', '0'), ('4821', '125.93.129.225', '', '', '1', '2008-08-30', '0'), ('4822', '119.122.2.87', '', '', '2', '2008-08-30', '0'), ('4823', '121.21.151.117', '', '', '1', '2008-08-30', '0'), ('4824', '211.136.75.147', '', '', '4', '2008-08-30', '0'), ('4825', '116.25.185.94', '', '', '2', '2008-08-30', '0'), ('4826', '202.160.178.251', '', '', '1', '2008-08-30', '0'), ('4827', '220.232.80.160', '', '', '1', '2008-08-30', '0'), ('4828', '219.130.4.110', '', '', '2', '2008-08-30', '0'), ('4829', '59.33.20.218', '', '', '2', '2008-08-30', '0'), ('4830', '61.135.168.55', '', '', '1', '2008-08-30', '0'), ('4831', '58.42.230.17', '', '', '1', '2008-08-30', '0'), ('4832', '219.137.116.8', '', '', '30', '2008-08-30', '0'), ('4833', '60.191.21.26', '', '', '1', '2008-08-30', '0'), ('4834', '61.180.71.143', '', '', '1', '2008-08-30', '0'), ('4835', '119.132.31.88', '', '', '1', '2008-08-30', '0'), ('4836', '211.136.75.253', '', '', '2', '2008-08-30', '0'), ('4837', '211.141.68.66', '', '', '8', '2008-08-30', '0'), ('4838', '211.139.162.187', '', '', '20', '2008-08-30', '0'), ('4839', '116.19.157.26', '', '', '2', '2008-08-30', '0'), ('4840', '211.136.75.153', '', '', '6', '2008-08-30', '0'), ('4841', '125.127.50.43', '', '', '2', '2008-08-30', '0'), ('4842', '211.137.63.139', '', '', '3', '2008-08-30', '0'), ('4843', '116.26.168.107', '', '', '2', '2008-08-30', '0'), ('4844', '119.39.178.234', '', '', '3', '2008-08-30', '0'), ('4845', '125.66.67.79', '', '', '4', '2008-08-30', '0'), ('4846', '219.152.241.217', '', '', '1', '2008-08-30', '0'), ('4847', '218.2.58.94', '', '', '1', '2008-08-30', '0'), ('4848', '121.12.227.112', '', '', '1', '2008-08-30', '0'), ('4849', '222.69.231.178', '', '', '1', '2008-08-30', '0'), ('4850', '121.35.117.118', '', '', '1', '2008-08-30', '0'), ('4851', '218.20.60.49', '', '', '1', '2008-08-30', '0'), ('4852', '211.138.227.1', '', '', '2', '2008-08-30', '0'), ('4853', '195.189.143.54', '', '', '2', '2008-08-30', '0'), ('4854', '122.158.84.22', '', '', '3', '2008-08-30', '0'), ('4855', '220.206.205.174', '', '', '1', '2008-08-30', '0'), ('4856', '222.185.12.253', '', '', '1', '2008-08-30', '0'), ('4857', '64.122.13.196', '', '', '2', '2008-08-31', '0'), ('4858', '58.41.60.222', '', '', '1', '2008-08-31', '0'), ('4860', '60.166.140.71', '', '', '2', '2008-08-31', '0'), ('4861', '121.34.134.11', '', '', '1', '2008-08-31', '0'), ('4862', '222.213.107.53', '', '', '2', '2008-08-31', '0'), ('4863', '58.214.233.218', '', '', '2', '2008-08-31', '0'), ('4864', '202.160.178.60', '', '', '2', '2008-08-31', '0'), ('4865', '58.253.58.33', '', '', '1', '2008-08-31', '0'), ('4866', '221.221.52.191', '', '', '2', '2008-08-31', '0'), ('4867', '59.42.254.95', '', '', '1', '2008-08-31', '0'), ('4868', '61.178.173.81', '', '', '1', '2008-08-31', '0'), ('4869', '119.125.24.237', '', '', '1', '2008-08-31', '0'), ('5478', '123.131.97.126', '', '', '1', '2008-09-03', '0'), ('4871', '59.60.219.87', '', '', '2', '2008-08-31', '0'), ('4872', '125.71.156.28', '', '', '1', '2008-08-31', '0'), ('4873', '58.253.17.2', '', '', '1', '2008-08-31', '0'), ('4874', '121.204.201.189', '', '', '1', '2008-08-31', '0'), ('4875', '208.65.73.200', '', '', '2', '2008-08-31', '0'), ('4876', '218.81.122.33', '', '', '1', '2008-08-31', '0'), ('4877', '222.175.52.2', '', '', '12', '2008-08-31', '0'), ('4878', '218.85.32.15', '', '', '1', '2008-08-31', '0'), ('4879', '58.61.90.136', '', '', '1', '2008-08-31', '0'), ('4880', '67.195.37.159', '', '', '6', '2008-08-31', '0'), ('4881', '202.160.178.41', '', '', '1', '2008-08-31', '0'), ('4882', '218.14.150.166', '', '', '1', '2008-08-31', '0'), ('4883', '121.41.232.107', '', '', '1', '2008-08-31', '0'), ('4884', '219.135.149.219', '', '', '1', '2008-08-31', '0'), ('4885', '61.135.168.86', '', '', '1', '2008-08-31', '0'), ('4886', '125.123.166.94', '', '', '3', '2008-08-31', '0'), ('4887', '119.129.252.119', '', '', '1', '2008-08-31', '0'), ('4888', '218.15.1.171', '', '', '1', '2008-08-31', '0'), ('4889', '202.160.179.65', '', '', '1', '2008-08-31', '0'), ('4890', '211.137.63.167', '', '', '1', '2008-08-31', '0'), ('4891', '202.160.178.194', '', '', '1', '2008-08-31', '0'), ('5477', '222.141.170.249', '', '', '1', '2008-09-03', '0'), ('4893', '61.142.123.236', '', '', '1', '2008-08-31', '0'), ('4894', '222.76.86.153', '', '', '4', '2008-08-31', '0'), ('4895', '218.90.171.161', '', '', '4', '2008-08-31', '0'), ('4896', '119.120.39.155', '', '', '3', '2008-08-31', '0'), ('4897', '222.172.249.210', '', '', '1', '2008-08-31', '0'), ('4898', '219.134.187.185', '', '', '67', '2008-08-31', '0'), ('4899', '219.130.49.102', '', '', '1', '2008-08-31', '0'), ('4900', '121.12.44.86', '', '', '1', '2008-08-31', '0'), ('4901', '121.204.2.68', '', '', '3', '2008-08-31', '0'), ('4902', '210.72.205.146', '', '', '1', '2008-08-31', '0'), ('4903', '222.69.179.93', '', '', '5', '2008-08-31', '0'), ('4904', '59.40.243.153', '', '', '1', '2008-08-31', '0'), ('4905', '221.4.150.154', '', '', '1', '2008-08-31', '0'), ('4906', '125.42.18.72', '', '', '1', '2008-08-31', '0'), ('4907', '121.95.158.22', '', '', '1', '2008-08-31', '0'), ('4908', '218.22.255.134', '', '', '4', '2008-08-31', '0'), ('4909', '59.56.232.98', '', '', '1', '2008-08-31', '0'), ('4910', '218.200.224.29', '', '', '1', '2008-08-31', '0'), ('4911', '60.177.34.114', '', '', '1', '2008-08-31', '0'), ('4912', '121.28.15.12', '', '', '7', '2008-08-31', '0'), ('4913', '218.30.110.187', '', '移动', '0', '2008-10-15', '1'), ('4914', '222.186.121.118', '', '', '2', '2008-08-31', '0'), ('4915', '59.41.36.132', '', '', '1', '2008-08-31', '0'), ('4916', '58.44.145.38', '', '', '1', '2008-08-31', '0'), ('4917', '72.14.252.136', '', '', '1', '2008-08-31', '0'), ('4918', '58.214.1.74', '', '', '60', '2008-08-31', '0'), ('4919', '220.231.227.35', '', '', '1', '2008-08-31', '0'), ('4920', '117.88.187.188', '', '', '1', '2008-08-31', '0'), ('4921', '61.144.118.83', '', '', '2', '2008-08-31', '0'), ('4922', '60.23.53.34', '', '', '2', '2008-08-31', '0'), ('4923', '58.19.92.74', '', '', '3', '2008-08-31', '0'), ('4924', '125.85.136.98', '', '', '2', '2008-08-31', '0'), ('4925', '220.206.235.17', '', '', '2', '2008-08-31', '0'), ('4926', '58.61.64.36', '', '', '1', '2008-08-31', '0'), ('4927', '123.5.74.200', '', '', '4', '2008-08-31', '0'), ('4928', '221.10.254.43', '', '', '1', '2008-08-31', '0'), ('4929', '125.73.223.84', '', '', '1', '2008-08-31', '0'), ('4930', '220.181.55.102', '', '', '1', '2008-08-31', '0'), ('4931', '218.27.148.66', '', '', '1', '2008-08-31', '0'), ('4932', '60.17.179.241', '', '', '2', '2008-08-31', '0'), ('4933', '121.8.51.92', '', '', '3', '2008-08-31', '0'), ('4934', '220.200.170.34', '', '', '1', '2008-08-31', '0'), ('4935', '218.202.6.163', '', '', '14', '2008-08-31', '0'), ('4936', '121.32.73.130', '', '', '1', '2008-08-31', '0'), ('4937', '116.21.182.101', '', '', '1', '2008-08-31', '0'), ('4938', '202.160.179.54', '', '', '2', '2008-08-31', '0'), ('4939', '220.206.240.1', '', '', '1', '2008-08-31', '0'), ('4940', '121.23.156.70', '', '', '1', '2008-08-31', '0'), ('4941', '202.152.84.1', '', '', '5', '2008-08-31', '0'), ('4942', '211.137.197.52', '', '', '1', '2008-08-31', '0'), ('4943', '202.160.180.186', '', '', '3', '2008-08-31', '0'), ('4944', '222.177.13.189', '', '', '1', '2008-08-31', '0'), ('4945', '58.217.210.79', '', '', '2', '2008-08-31', '0'), ('4946', '219.130.106.145', '', '', '1', '2008-08-31', '0'), ('4947', '202.160.179.71', '', '', '1', '2008-08-31', '0'), ('4948', '202.160.178.225', '', '', '1', '2008-08-31', '0'), ('4949', '124.249.173.60', '', '', '1', '2008-08-31', '0'), ('4950', '218.80.214.22', '', '', '2', '2008-08-31', '0'), ('4951', '202.91.18.206', '', '', '1', '2008-08-31', '0'), ('4952', '121.32.81.75', '', '', '1', '2008-08-31', '0'), ('4953', '123.155.137.162', '', '', '1', '2008-08-31', '0'), ('4954', '116.31.165.97', '', '', '1', '2008-08-31', '0'), ('4955', '85.26.223.101', '', '', '3', '2008-08-31', '0'), ('4956', '211.138.218.124', '', '', '2', '2008-08-31', '0'), ('4957', '121.32.91.45', '', '', '3', '2008-08-31', '0'), ('4958', '116.209.206.223', '', '', '1', '2008-08-31', '0'), ('4959', '125.92.95.160', '', '', '2', '2008-08-31', '0'), ('4960', '58.241.92.172', '', '', '1', '2008-08-31', '0'), ('4961', '211.136.75.36', '', '', '6', '2008-08-31', '0'), ('4962', '61.135.168.99', '', '', '2', '2008-08-31', '0'), ('4963', '222.185.18.246', '', '', '4', '2008-08-31', '0'), ('4964', '202.160.179.72', '', '', '2', '2008-08-31', '0'), ('4965', '222.138.135.253', '', '', '2', '2008-08-31', '0'), ('4966', '211.139.127.94', '', '', '1', '2008-08-31', '0'), ('4967', '125.36.151.228', '', '', '1', '2008-08-31', '0'), ('4968', '221.225.94.131', '', '', '1', '2008-08-31', '0'), ('4969', '218.14.113.97', '', '', '1', '2008-08-31', '0'), ('4970', '221.225.245.251', '', '', '1', '2008-08-31', '0'), ('4971', '116.26.60.11', '', '', '1', '2008-08-31', '0'), ('4972', '116.213.64.39', '', '', '1', '2008-08-31', '0'), ('4973', '203.145.92.73', '', '', '2', '2008-08-31', '0'), ('4974', '116.20.176.28', '', '', '7', '2008-08-31', '0'), ('4975', '123.118.125.8', '', '', '2', '2008-08-31', '0'), ('4976', '211.136.75.89', '', '', '3', '2008-08-31', '0'), ('4977', '119.133.108.106', '', '', '1', '2008-08-31', '0'), ('4978', '119.127.243.10', '', '', '2', '2008-08-31', '0'), ('4979', '58.252.246.110', '', '', '1', '2008-08-31', '0'), ('4980', '202.160.181.183', '', '', '1', '2008-08-31', '0'), ('4981', '210.51.23.73', '', '', '2', '2008-08-31', '0'), ('4982', '211.90.119.118', '', '', '3', '2008-08-31', '0'), ('4983', '220.206.235.93', '', '', '2', '2008-08-31', '0'), ('4984', '219.130.211.19', '', '', '1', '2008-08-31', '0'), ('4985', '125.78.208.36', '', '', '1', '2008-08-31', '0'), ('4986', '195.189.142.74', '', '', '1', '2008-08-31', '0'), ('4987', '219.135.132.242', '', '', '1', '2008-08-31', '0'), ('4988', '116.4.84.99', '', '', '1', '2008-08-31', '0'), ('4989', '60.28.138.129', '', '', '1', '2008-08-31', '0'), ('4990', '116.16.79.238', '', '', '1', '2008-08-31', '0'), ('4991', '220.192.113.46', '', '', '7', '2008-08-31', '0'), ('4992', '211.136.75.22', '', '', '1', '2008-08-31', '0'), ('4993', '117.28.4.162', '', '', '1', '2008-08-31', '0'), ('4994', '195.189.142.135', '', '', '3', '2008-08-31', '0'), ('4995', '119.39.177.127', '', '', '1', '2008-08-31', '0'), ('4996', '221.221.183.84', '', '', '3', '2008-08-31', '0'), ('4997', '211.136.73.102', '', '', '11', '2008-08-31', '0'), ('4998', '220.206.235.15', '', '', '8', '2008-08-31', '0'), ('4999', '222.62.103.51', '', '', '1', '2008-08-31', '0'), ('5000', '59.35.85.72', '', '', '1', '2008-08-31', '0'), ('5001', '59.35.196.25', '', '', '1', '2008-08-31', '0'), ('5002', '202.160.180.121', '', '', '2', '2008-08-31', '0'), ('5003', '218.14.157.144', '', '', '1', '2008-08-31', '0'), ('5004', '211.136.158.205', '', '', '4', '2008-08-31', '0'), ('5005', '218.63.71.65', '', '', '1', '2008-09-01', '0'), ('5006', '211.138.227.33', '', '', '2', '2008-09-01', '0'), ('5007', '80.232.117.20', '', '', '2', '2008-09-01', '0'), ('5008', '59.32.252.21', '', '', '1', '2008-09-01', '0'), ('5009', '211.136.158.36', '', '', '22', '2008-09-01', '0'), ('5010', '124.237.58.168', '', '', '2', '2008-09-01', '0'), ('5011', '203.92.115.200', '', '', '1', '2008-09-01', '0'), ('5012', '125.83.74.218', '', '', '1', '2008-09-01', '0'), ('5013', '218.242.136.2', '', '', '1', '2008-09-01', '0'), ('5014', '220.206.235.35', '', '', '7', '2008-09-01', '0'), ('5015', '211.136.158.139', '', '', '3', '2008-09-01', '0'), ('5016', '121.11.236.235', '', '', '3', '2008-09-01', '0'), ('5017', '58.62.127.193', '', '', '1', '2008-09-01', '0'), ('5018', '116.22.210.135', '', '', '1', '2008-09-01', '0'), ('5019', '203.116.22.138', '', '', '1', '2008-09-01', '0'), ('5020', '211.136.75.150', '', '', '1', '2008-09-01', '0'), ('5021', '61.141.93.7', '', '', '2', '2008-09-01', '0'), ('5022', '222.172.191.29', '', '', '2', '2008-09-01', '0'), ('5023', '222.93.141.193', '', '', '1', '2008-09-01', '0'), ('5024', '218.200.224.185', '', '', '1', '2008-09-01', '0'), ('5025', '211.139.162.176', '', '', '22', '2008-09-01', '0'), ('5026', '124.88.223.214', '', '', '1', '2008-09-01', '0'), ('5027', '125.64.67.142', '', '', '1', '2008-09-01', '0'), ('5028', '220.181.32.26', '', '', '3', '2008-09-01', '0'), ('5029', '211.139.16.61', '', '', '5', '2008-09-01', '0'), ('5030', '60.222.37.183', '', '', '2', '2008-09-01', '0'), ('5031', '58.252.44.147', '', '', '1', '2008-09-01', '0'), ('5032', '221.130.195.75', '', '', '193', '2008-09-01', '0'), ('5033', '211.137.62.210', '', '', '1', '2008-09-01', '0'), ('5034', '59.41.72.12', '', '', '1', '2008-09-01', '0'), ('5035', '220.206.235.45', '', '', '1', '2008-09-01', '0'), ('5036', '124.90.130.234', '', '', '2', '2008-09-01', '0'), ('5037', '202.160.179.24', '', '', '1', '2008-09-01', '0'), ('5038', '220.188.66.241', '', '', '1', '2008-09-01', '0'), ('5039', '58.62.206.98', '', '', '5', '2008-09-01', '0'), ('5040', '121.35.85.45', '', '', '1', '2008-09-01', '0'), ('5041', '211.140.16.212', '', '', '34', '2008-09-01', '0'), ('5042', '124.16.150.1', '', '', '1', '2008-09-01', '0'), ('5043', '61.241.199.13', '', '联通', '21', '2008-09-01', '0'), ('5044', '121.51.154.133', '', '', '1', '2008-09-01', '0'), ('5045', '211.136.73.79', '', '', '11', '2008-09-01', '0'), ('5046', '59.37.244.184', '', '', '1', '2008-09-01', '0'), ('5047', '218.207.136.10', '', '', '1', '2008-09-01', '0'), ('5048', '220.115.42.150', '', '', '1', '2008-09-01', '0'), ('5049', '125.112.182.105', '', '', '1', '2008-09-01', '0'), ('5050', '124.13.102.123', '', '', '1', '2008-09-01', '0'), ('5476', '123.127.134.57', '', '', '1', '2008-09-03', '0'), ('5052', '220.206.235.19', '', '', '2', '2008-09-01', '0'), ('5053', '219.136.186.131', '', '', '1', '2008-09-01', '0'), ('5054', '125.73.128.207', '', '', '2', '2008-09-01', '0'), ('5055', '119.119.211.155', '', '', '1', '2008-09-01', '0'), ('5056', '60.168.120.133', '', '', '1', '2008-09-01', '0'), ('5057', '211.136.158.221', '', '', '3', '2008-09-01', '0'), ('5058', '211.136.73.76', '', '', '13', '2008-09-01', '0'), ('5059', '218.59.130.35', '', '', '2', '2008-09-01', '0'), ('5060', '218.200.224.239', '', '', '1', '2008-09-01', '0'), ('5061', '220.206.235.12', '', '', '1', '2008-09-01', '0'), ('5062', '222.80.180.187', '', '', '1', '2008-09-01', '0'), ('5063', '219.152.241.207', '', '', '2', '2008-09-01', '0'), ('5064', '218.81.56.118', '', '', '3', '2008-09-01', '0'), ('5065', '220.206.219.10', '', '', '7', '2008-09-01', '0'), ('5066', '211.136.158.143', '', '', '4', '2008-09-01', '0'), ('5067', '218.19.68.14', '', '', '3', '2008-09-01', '0'), ('5068', '202.105.142.53', '', '', '1', '2008-09-01', '0'), ('5069', '119.128.84.104', '', '', '1', '2008-09-01', '0'), ('5070', '202.160.180.193', '', '', '1', '2008-09-01', '0'), ('5071', '61.135.168.59', '', '', '1', '2008-09-01', '0'), ('5475', '117.28.191.199', '', '', '3', '2008-09-03', '0'), ('5073', '119.121.15.118', '', '', '1', '2008-09-01', '0'), ('5074', '119.138.249.44', '', '', '1', '2008-09-01', '0'), ('5075', '211.137.63.120', '', '', '1', '2008-09-01', '0'), ('5076', '220.165.179.155', '', '', '2', '2008-09-01', '0'), ('5077', '124.227.221.174', '', '', '1', '2008-09-01', '0'), ('5078', '222.73.37.4', '', '', '1', '2008-09-01', '0'), ('5079', '211.136.75.151', '', '', '2', '2008-09-01', '0'), ('5080', '218.19.22.183', '', '', '6', '2008-09-01', '0'), ('5081', '211.138.218.9', '', '', '1', '2008-09-01', '0'), ('5082', '222.72.203.40', '', '', '1', '2008-09-01', '0'), ('5083', '210.14.66.185', '', '', '1', '2008-09-01', '0'), ('5084', '119.39.179.228', '', '', '1', '2008-09-01', '0'), ('5085', '60.14.151.195', '', '', '1', '2008-09-01', '0'), ('5086', '220.194.137.10', '', '', '2', '2008-09-01', '0'), ('5087', '202.160.178.222', '', '', '1', '2008-09-01', '0'), ('5088', '221.221.154.205', '', '', '2', '2008-09-01', '0'), ('5089', '122.139.155.13', '', '', '2', '2008-09-01', '0'), ('5090', '211.137.62.218', '', '', '2', '2008-09-01', '0'), ('5091', '123.159.22.107', '', '', '2', '2008-09-01', '0'), ('5092', '117.80.244.77', '', '', '1', '2008-09-01', '0'), ('5093', '116.60.248.32', '', '', '1', '2008-09-01', '0'), ('5094', '124.224.173.177', '', '', '1', '2008-09-01', '0'), ('5095', '116.21.57.12', '', '', '1', '2008-09-01', '0'), ('5096', '120.1.198.144', '', '', '1', '2008-09-01', '0'), ('5097', '218.93.20.246', '', '', '1', '2008-09-01', '0'), ('5098', '123.154.235.3', '', '', '1', '2008-09-01', '0'), ('5099', '203.208.60.55', '', '', '11', '2008-09-01', '0'), ('5100', '203.208.60.57', '', '', '20', '2008-09-01', '0'), ('5101', '221.239.158.121', '', '', '1', '2008-09-01', '0'), ('5102', '219.128.157.99', '', '', '2', '2008-09-01', '0'), ('5103', '77.117.175.70', '', '', '1', '2008-09-01', '0'), ('5104', '58.53.96.156', '', '', '1', '2008-09-01', '0'), ('5105', '58.253.55.111', '', '', '1', '2008-09-01', '0'), ('5106', '211.145.126.133', '', '', '1', '2008-09-01', '0'), ('5107', '222.45.184.187', '', '', '1', '2008-09-01', '0'), ('5108', '203.208.60.54', '', '', '18', '2008-09-01', '0'), ('5109', '211.140.16.222', '', '', '28', '2008-09-01', '0'), ('5110', '211.136.75.142', '', '', '1', '2008-09-01', '0'), ('5111', '218.16.138.50', '', '', '1', '2008-09-01', '0'), ('5112', '59.41.173.36', '', '', '8', '2008-09-01', '0'), ('5113', '121.235.59.126', '', '', '1', '2008-09-01', '0'), ('5114', '211.136.75.32', '', '', '2', '2008-09-01', '0'), ('5115', '59.41.189.94', '', '', '1', '2008-09-01', '0'), ('5116', '123.112.42.63', '', '', '1', '2008-09-01', '0'), ('5117', '211.137.62.250', '', '', '1', '2008-09-01', '0'), ('5118', '203.208.60.58', '', '', '19', '2008-09-01', '0'), ('5119', '222.213.127.9', '', '', '2', '2008-09-01', '0'), ('5120', '124.72.158.105', '', '', '1', '2008-09-01', '0'), ('5121', '219.128.155.9', '', '', '1', '2008-09-01', '0'), ('5122', '61.146.4.140', '', '', '1', '2008-09-01', '0'), ('5123', '195.189.142.215', '', '', '1', '2008-09-01', '0'), ('5124', '119.120.35.217', '', '', '2', '2008-09-01', '0'), ('5125', '123.147.2.87', '', '', '1', '2008-09-01', '0'), ('5126', '220.231.230.102', '', '', '1', '2008-09-01', '0'), ('5127', '91.203.96.42', '', '', '2', '2008-09-01', '0'), ('5128', '120.137.73.101', '', '', '2', '2008-09-01', '0'), ('5129', '58.242.169.94', '', '', '1', '2008-09-01', '0'), ('5130', '60.11.20.19', '', '', '2', '2008-09-01', '0'), ('5131', '125.78.220.172', '', '', '1', '2008-09-01', '0'), ('5132', '91.203.96.31', '', '', '5', '2008-09-01', '0'), ('5133', '212.71.32.94', '', '', '4', '2008-09-01', '0'), ('5134', '59.33.138.223', '', '', '7', '2008-09-01', '0'), ('5135', '64.62.138.101', '', '', '1', '2008-09-01', '0'), ('5136', '124.133.86.134', '', '', '1', '2008-09-01', '0'), ('5137', '220.206.235.41', '', '', '1', '2008-09-01', '0'), ('5138', '218.20.217.147', '', '', '1', '2008-09-01', '0'), ('5139', '217.113.75.60', '', '', '1', '2008-09-01', '0'), ('5140', '116.17.50.213', '', '', '1', '2008-09-01', '0'), ('5141', '116.199.71.55', '', '', '1', '2008-09-01', '0'), ('5142', '58.62.116.134', '', '', '1', '2008-09-01', '0'), ('5143', '121.207.92.82', '', '', '1', '2008-09-01', '0'), ('5144', '202.160.180.23', '', '', '1', '2008-09-01', '0'), ('5145', '116.21.229.229', '', '', '1', '2008-09-01', '0'), ('5146', '221.11.8.236', '', '', '1', '2008-09-01', '0'), ('5147', '219.128.82.63', '', '', '1', '2008-09-01', '0'), ('5148', '60.211.20.226', '', '', '1', '2008-09-01', '0'), ('5149', '122.5.165.68', '', '', '1', '2008-09-01', '0'), ('5150', '124.114.212.205', '', '', '1', '2008-09-01', '0'), ('5151', '218.207.136.4', '', '', '1', '2008-09-01', '0'), ('5152', '60.14.108.200', '', '', '2', '2008-09-01', '0'), ('5153', '41.208.48.176', '', '', '11', '2008-09-01', '0'), ('5154', '211.138.227.227', '', '', '1', '2008-09-01', '0'), ('5155', '59.38.107.87', '', '', '1', '2008-09-01', '0'), ('5156', '60.181.145.180', '', '', '1', '2008-09-01', '0'), ('5157', '116.16.145.144', '', '', '1', '2008-09-01', '0'), ('5158', '222.73.95.19', '', '', '1', '2008-09-01', '0'), ('5159', '125.93.123.165', '', '', '1', '2008-09-01', '0'), ('5160', '59.41.74.232', '', '', '1', '2008-09-01', '0'), ('5161', '125.93.12.92', '', '', '1', '2008-09-01', '0'), ('5162', '211.138.167.177', '', '', '4', '2008-09-01', '0'), ('5163', '220.206.235.69', '', '', '5', '2008-09-01', '0'), ('5164', '58.251.57.87', '', '', '1', '2008-09-01', '0'), ('5165', '59.57.40.22', '', '', '2', '2008-09-01', '0'), ('5166', '116.25.127.87', '', '', '1', '2008-09-01', '0'), ('5167', '211.136.158.145', '', '', '4', '2008-09-01', '0'), ('5474', '60.215.86.112', '', '', '1', '2008-09-03', '0'), ('5169', '211.136.75.212', '', '', '1', '2008-09-01', '0'), ('5170', '211.139.162.192', '', '', '14', '2008-09-01', '0'), ('5171', '116.4.139.176', '', '', '1', '2008-09-01', '0'), ('5172', '211.136.73.110', '', '', '8', '2008-09-01', '0'), ('5173', '119.39.179.165', '', '', '1', '2008-09-01', '0'), ('5174', '221.239.203.235', '', '', '3', '2008-09-01', '0'), ('5175', '124.72.152.103', '', '', '1', '2008-09-01', '0'), ('5176', '61.135.168.124', '', '', '4', '2008-09-01', '0'), ('5177', '195.189.142.252', '', '', '2', '2008-09-01', '0'), ('5178', '211.136.73.68', '', '', '4', '2008-09-01', '0'), ('5179', '211.94.253.97', '', '', '13', '2008-09-01', '0'), ('5180', '121.33.250.186', '', '', '1', '2008-09-01', '0'), ('5181', '58.18.39.28', '', '', '4', '2008-09-01', '0'), ('5182', '61.243.111.49', '', '', '6', '2008-09-01', '0'), ('5183', '220.206.235.103', '', '', '3', '2008-09-01', '0'), ('5184', '218.205.249.25', '', '', '1', '2008-09-01', '0'), ('5185', '116.77.8.144', '', '', '1', '2008-09-01', '0'), ('5186', '59.42.154.217', '', '', '1', '2008-09-01', '0'), ('5187', '211.137.63.122', '', '', '1', '2008-09-01', '0'), ('5188', '83.149.9.165', '', '', '1', '2008-09-01', '0'), ('5189', '219.128.63.47', '', '', '1', '2008-09-01', '0'), ('5190', '195.189.142.133', '', '', '1', '2008-09-02', '0'), ('5191', '124.64.121.169', '', '', '1', '2008-09-02', '0'), ('5192', '211.136.75.42', '', '', '2', '2008-09-02', '0'), ('5193', '114.241.128.174', '', '', '1', '2008-09-02', '0'), ('5194', '65.208.122.57', '', '', '8', '2008-09-02', '0'), ('5195', '92.60.228.89', '', '', '1', '2008-09-02', '0'), ('5196', '116.24.21.7', '', '', '1', '2008-09-02', '0'), ('5197', '211.136.75.209', '', '', '1', '2008-09-02', '0'), ('5198', '202.160.179.74', '', '', '1', '2008-09-02', '0'), ('5199', '58.255.47.203', '', '', '1', '2008-09-02', '0'), ('5200', '211.139.71.138', '', '', '4', '2008-09-02', '0'), ('5201', '121.228.210.61', '', '', '4', '2008-09-02', '0'), ('5202', '120.0.219.231', '', '', '1', '2008-09-02', '0'), ('5203', '91.203.96.15', '', '', '3', '2008-09-02', '0'), ('5204', '77.117.253.117', '', '', '1', '2008-09-02', '0'), ('5205', '116.23.82.82', '', '', '1', '2008-09-02', '0'), ('5206', '218.85.65.14', '', '', '1', '2008-09-02', '0'), ('5207', '211.137.63.68', '', '', '2', '2008-09-02', '0'), ('5208', '211.136.158.142', '', '', '70', '2008-09-02', '0'), ('5209', '41.208.11.160', '', '', '2', '2008-09-02', '0'), ('5210', '211.137.63.118', '', '', '1', '2008-09-02', '0'), ('5211', '220.206.206.4', '', '', '11', '2008-09-02', '0'), ('5212', '117.26.244.41', '', '', '1', '2008-09-02', '0'), ('5213', '203.92.154.39', '', '', '16', '2008-09-02', '0'), ('5214', '218.13.138.51', '', '', '1', '2008-09-02', '0'), ('5215', '60.214.91.28', '', '', '1', '2008-09-02', '0'), ('5216', '116.4.178.236', '', '', '2', '2008-09-02', '0'), ('5217', '59.37.139.248', '', '', '2', '2008-09-02', '0'), ('5218', '211.137.62.244', '', '', '3', '2008-09-02', '0'), ('5219', '203.142.110.19', '', '', '1', '2008-09-02', '0'), ('5220', '60.6.210.169', '', '', '1', '2008-09-02', '0'), ('5221', '211.138.227.101', '', '', '1', '2008-09-02', '0'), ('5222', '58.252.44.136', '', '', '1', '2008-09-02', '0'), ('5223', '202.160.180.109', '', '', '2', '2008-09-02', '0'), ('5224', '220.194.137.12', '', '', '3', '2008-09-02', '0'), ('5225', '211.136.75.213', '', '', '2', '2008-09-02', '0'), ('5226', '202.149.25.241', '', '', '1', '2008-09-02', '0'), ('5227', '202.160.180.38', '', '', '1', '2008-09-02', '0'), ('5228', '59.108.107.133', '', '', '1', '2008-09-02', '0'), ('5229', '218.20.225.3', '', '', '6', '2008-09-02', '0'), ('5230', '125.36.155.47', '', '', '1', '2008-09-02', '0'), ('5231', '211.139.162.171', '', '', '12', '2008-09-02', '0'), ('5232', '123.14.67.41', '', '', '1', '2008-09-02', '0'), ('5233', '61.155.85.118', '', '', '1', '2008-09-02', '0'), ('5234', '219.145.4.225', '', '', '2', '2008-09-02', '0'), ('5235', '211.137.41.13', '', '', '37', '2008-09-02', '0'), ('5236', '220.181.5.67', '', '', '1', '2008-09-02', '0'), ('5237', '211.136.158.156', '', '', '1', '2008-09-02', '0'), ('5238', '122.13.205.111', '', '', '1', '2008-09-02', '0'), ('5239', '220.206.246.58', '', '', '2', '2008-09-02', '0'), ('5240', '58.61.95.156', '', '', '1', '2008-09-02', '0'), ('5241', '219.137.138.145', '', '', '1', '2008-09-02', '0'), ('5242', '211.136.228.91', '', '', '28', '2008-09-02', '0'), ('5243', '211.141.223.234', '', '', '1', '2008-09-02', '0'), ('5244', '222.130.51.160', '', '', '5', '2008-09-02', '0'), ('5245', '219.130.18.239', '', '', '1', '2008-09-02', '0'), ('5246', '218.204.70.217', '', '', '2', '2008-09-02', '0'), ('5247', '219.137.116.15', '', '', '54', '2008-09-02', '0'), ('5248', '59.41.168.72', '', '', '2', '2008-09-02', '0'), ('5249', '116.112.35.130', '', '', '2', '2008-09-02', '0'), ('5250', '211.139.162.129', '', '', '48', '2008-09-02', '0'), ('5251', '116.245.82.86', '', '', '5', '2008-09-02', '0'), ('5252', '123.61.165.6', '', '', '1', '2008-09-02', '0'), ('5253', '125.86.93.229', '', '', '1', '2008-09-02', '0'), ('5254', '123.6.171.223', '', '', '2', '2008-09-02', '0'), ('5255', '165.21.42.84', '', '', '8', '2008-09-02', '0'), ('5256', '121.68.0.244', '', '', '2', '2008-09-02', '0'), ('5257', '122.70.15.102', '', '', '1', '2008-09-02', '0'), ('5258', '125.123.239.116', '', '', '1', '2008-09-02', '0'), ('5259', '218.20.221.212', '', '', '6', '2008-09-02', '0'), ('5260', '123.8.198.215', '', '', '2', '2008-09-02', '0'), ('5261', '61.174.126.133', '', '', '1', '2008-09-02', '0'), ('5262', '59.35.90.245', '', '', '1', '2008-09-02', '0'), ('5263', '222.80.238.196', '', '', '2', '2008-09-02', '0'), ('5264', '61.135.168.125', '', '', '1', '2008-09-02', '0'), ('5265', '125.64.226.28', '', '', '1', '2008-09-02', '0'), ('5266', '195.189.142.47', '', '', '9', '2008-09-02', '0'), ('5267', '165.21.155.11', '', '', '1', '2008-09-02', '0'), ('5268', '220.206.235.33', '', '', '1', '2008-09-02', '0'), ('5269', '211.143.149.226', '', '', '3', '2008-09-02', '0'), ('5270', '202.160.178.176', '', '', '1', '2008-09-02', '0'), ('5271', '60.210.197.135', '', '', '1', '2008-09-02', '0'), ('5272', '218.8.46.199', '', '', '1', '2008-09-02', '0'), ('5273', '218.90.156.2', '', '', '1', '2008-09-02', '0'), ('5274', '211.137.41.30', '', '', '3', '2008-09-02', '0'), ('5275', '218.19.161.183', '', '', '10', '2008-09-02', '0'), ('5276', '202.160.180.138', '', '', '1', '2008-09-02', '0'), ('5277', '61.178.101.10', '', '', '3', '2008-09-02', '0'), ('5278', '202.160.178.162', '', '', '1', '2008-09-02', '0'), ('5279', '211.138.63.68', '', '', '3', '2008-09-02', '0'), ('5280', '60.166.111.246', '', '', '1', '2008-09-02', '0'), ('5281', '221.237.150.125', '', '', '1', '2008-09-02', '0'), ('5282', '202.160.179.156', '', '', '4', '2008-09-02', '0'), ('5283', '222.189.116.104', '', '', '1', '2008-09-02', '0'), ('5284', '219.133.16.73', '', '', '1', '2008-09-02', '0'), ('5285', '211.136.75.195', '', '', '1', '2008-09-02', '0'), ('5286', '60.165.221.12', '', '', '2', '2008-09-02', '0'), ('5287', '61.152.249.48', '', '', '5', '2008-09-02', '0'), ('5288', '218.206.7.130', '', '', '117', '2008-09-02', '0'), ('5289', '116.24.26.70', '', '', '1', '2008-09-02', '0'), ('5290', '211.139.162.132', '', '', '32', '2008-09-02', '0'), ('5291', '203.77.250.44', '', '', '2', '2008-09-02', '0'), ('5292', '125.64.82.134', '', '', '1', '2008-09-02', '0'), ('5293', '119.123.155.17', '', '', '2', '2008-09-02', '0'), ('5294', '219.128.208.82', '', '', '3', '2008-09-02', '0'), ('5295', '61.168.213.20', '', '', '87', '2008-09-02', '0'), ('5296', '58.71.215.98', '', '', '1', '2008-09-02', '0'), ('5297', '211.143.149.232', '', '', '1', '2008-09-02', '0'), ('5298', '59.41.252.228', '', '', '1', '2008-09-02', '0'), ('5299', '222.77.119.177', '', '', '4', '2008-09-02', '0'), ('5300', '125.91.146.243', '', '', '1', '2008-09-02', '0'), ('5301', '210.241.199.204', '', '', '3', '2008-09-02', '0'), ('5302', '116.16.150.182', '', '', '1', '2008-09-02', '0'), ('5303', '122.230.96.74', '', '', '1', '2008-09-02', '0'), ('5304', '58.71.215.84', '', '', '1', '2008-09-02', '0'), ('5305', '60.2.81.52', '', '', '1', '2008-09-02', '0'), ('5306', '211.136.75.23', '', '', '3', '2008-09-02', '0'), ('5307', '122.158.87.154', '', '', '1', '2008-09-02', '0'), ('5308', '221.212.98.3', '', '', '4', '2008-09-02', '0'), ('5309', '41.208.50.176', '', '', '4', '2008-09-02', '0'), ('5310', '116.17.147.140', '', '', '4', '2008-09-02', '0'), ('5311', '211.139.162.182', '', '', '15', '2008-09-02', '0'), ('5312', '121.235.42.155', '', '', '1', '2008-09-02', '0'), ('5313', '218.16.75.39', '', '', '1', '2008-09-02', '0'), ('5314', '125.91.94.161', '', '', '1', '2008-09-02', '0'), ('5315', '59.42.131.12', '', '', '12', '2008-09-02', '0'), ('5317', '60.183.202.219', '', '', '1', '2008-09-02', '0'), ('5318', '202.73.206.32', '', '', '1', '2008-09-02', '0'), ('5319', '202.160.180.88', '', '', '1', '2008-09-02', '0'), ('5320', '218.205.249.96', '', '', '1', '2008-09-02', '0'), ('5321', '211.136.85.130', '', '', '1', '2008-09-02', '0'), ('5322', '61.138.107.102', '', '', '2', '2008-09-02', '0'), ('5323', '58.62.100.193', '', '', '3', '2008-09-02', '0'), ('5324', '202.160.179.90', '', '', '1', '2008-09-02', '0'), ('5325', '211.136.158.140', '', '', '4', '2008-09-02', '0'), ('5326', '209.85.238.24', '', '', '1', '2008-09-02', '0'), ('5327', '219.128.71.70', '', '', '1', '2008-09-02', '0'), ('5328', '220.194.137.9', '', '', '1', '2008-09-02', '0'), ('5329', '59.35.252.127', '', '', '2', '2008-09-02', '0'), ('5330', '211.139.162.194', '', '', '15', '2008-09-02', '0'), ('5331', '222.45.184.235', '', '', '1', '2008-09-02', '0'), ('5332', '202.156.8.10', '', '', '1', '2008-09-02', '0'), ('5333', '123.114.208.208', '', '', '1', '2008-09-02', '0'), ('5334', '125.86.90.203', '', '', '2', '2008-09-02', '0'), ('5335', '222.62.100.251', '', '', '1', '2008-09-02', '0'), ('5336', '220.242.75.225', '', '', '2', '2008-09-02', '0'), ('5337', '202.160.181.182', '', '', '1', '2008-09-02', '0'), ('5338', '211.136.75.72', '', '', '2', '2008-09-02', '0'), ('5339', '124.94.7.48', '', '', '2', '2008-09-02', '0'), ('5340', '202.160.178.120', '', '', '2', '2008-09-02', '0'), ('5341', '114.138.250.90', '', '', '1', '2008-09-02', '0'), ('5342', '117.26.212.104', '', '', '1', '2008-09-02', '0'), ('5343', '116.17.156.14', '', '', '2', '2008-09-02', '0'), ('5344', '119.130.32.46', '', '', '1', '2008-09-02', '0'), ('5345', '60.1.8.143', '', '', '1', '2008-09-02', '0'), ('5346', '121.32.162.142', '', '', '1', '2008-09-02', '0'), ('5347', '220.194.46.74', '', '', '5', '2008-09-02', '0'), ('5348', '211.139.16.181', '', '', '8', '2008-09-02', '0'), ('5349', '74.6.8.89', '', '', '28', '2008-09-02', '0'), ('5350', '218.31.151.18', '', '', '1', '2008-09-02', '0'), ('5351', '121.9.32.67', '', '', '2', '2008-09-02', '0'), ('5352', '221.206.107.111', '', '', '1', '2008-09-02', '0'), ('5353', '211.137.62.219', '', '', '1', '2008-09-02', '0'), ('5354', '221.131.116.148', '', '', '5', '2008-09-02', '0'), ('5356', '195.189.142.150', '', '', '2', '2008-09-03', '0'), ('5357', '195.189.142.52', '', '', '5', '2008-09-03', '0'), ('5358', '219.137.83.25', '', '', '1', '2008-09-03', '0'), ('5359', '211.138.205.193', '', '', '15', '2008-09-03', '0'), ('5360', '190.80.12.113', '', '', '1', '2008-09-03', '0'), ('5361', '222.70.164.144', '', '', '3', '2008-09-03', '0'), ('5362', '202.160.178.169', '', '', '2', '2008-09-03', '0'), ('5363', '59.38.133.174', '', '', '2', '2008-09-03', '0'), ('5364', '116.25.92.200', '', '', '1', '2008-09-03', '0'), ('5365', '211.139.162.174', '', '', '15', '2008-09-03', '0'), ('5366', '114.120.75.109', '', '', '1', '2008-09-03', '0'), ('5367', '121.9.116.119', '', '', '2', '2008-09-03', '0'), ('5368', '220.192.67.194', '', '', '1', '2008-09-03', '0'), ('5369', '117.65.70.188', '', '', '4', '2008-09-03', '0'), ('5370', '203.208.60.53', '', '', '9', '2008-09-03', '0'), ('5371', '211.138.218.56', '', '', '2', '2008-09-03', '0'), ('5372', '202.160.178.245', '', '', '1', '2008-09-03', '0'), ('5373', '219.159.159.153', '', '', '3', '2008-09-03', '0'), ('5374', '58.216.224.194', '', '', '9', '2008-09-03', '0'), ('5375', '121.207.69.237', '', '', '1', '2008-09-03', '0'), ('5376', '119.127.245.168', '', '', '4', '2008-09-03', '0'), ('5377', '220.167.30.35', '', '', '1', '2008-09-03', '0'), ('5378', '202.160.178.227', '', '', '1', '2008-09-03', '0'), ('5379', '202.160.178.118', '', '', '1', '2008-09-03', '0'), ('5380', '202.160.178.151', '', '', '1', '2008-09-03', '0'), ('5381', '61.182.68.26', '', '', '1', '2008-09-03', '0'), ('5382', '222.88.4.78', '', '', '1', '2008-09-03', '0'), ('5383', '211.137.37.132', '', '', '5', '2008-09-03', '0'), ('5384', '61.145.126.155', '', '', '1', '2008-09-03', '0'), ('5385', '61.135.220.84', '', '', '1', '2008-09-03', '0'), ('5386', '211.139.162.160', '', '', '12', '2008-09-03', '0'), ('5387', '202.160.179.127', '', '', '1', '2008-09-03', '0'), ('5388', '219.78.44.75', '', '', '2', '2008-09-03', '0'), ('5389', '123.232.113.12', '', '', '1', '2008-09-03', '0'), ('5390', '202.160.179.17', '', '', '1', '2008-09-03', '0'), ('5391', '202.160.179.126', '', '', '1', '2008-09-03', '0'), ('5392', '151.80.217.103', '', '', '1', '2008-09-03', '0'), ('5393', '119.39.177.101', '', '', '2', '2008-09-03', '0'), ('5394', '202.160.178.214', '', '', '1', '2008-09-03', '0'), ('5395', '61.168.213.109', '', '', '38', '2008-09-03', '0'), ('5396', '61.130.114.210', '', '', '1', '2008-09-03', '0'), ('5397', '218.19.22.130', '', '', '7', '2008-09-03', '0'), ('5398', '210.153.84.9', '', '', '1', '2008-09-03', '0'), ('5399', '202.108.7.213', '', '', '1', '2008-09-03', '0'), ('5400', '202.160.179.211', '', '', '1', '2008-09-03', '0'), ('5401', '202.104.17.212', '', '', '17', '2008-09-03', '0'), ('5402', '211.143.203.129', '', '', '11', '2008-09-03', '0'), ('5403', '218.19.126.117', '', '', '1', '2008-09-03', '0'), ('5404', '64.62.138.99', '', '', '1', '2008-09-03', '0'), ('5405', '118.25.184.39', '', '', '1', '2008-09-03', '0'), ('5406', '116.17.52.183', '', '', '7', '2008-09-03', '0'), ('5407', '203.93.225.141', '', '', '1', '2008-09-03', '0'), ('5408', '58.63.134.128', '', '', '3', '2008-09-03', '0'), ('5409', '124.163.246.7', '', '', '1', '2008-09-03', '0'), ('5410', '123.113.81.91', '', '', '2', '2008-09-03', '0'), ('5411', '220.206.235.50', '', '', '2', '2008-09-03', '0'), ('5412', '58.59.245.111', '', '', '15', '2008-09-03', '0'), ('5413', '61.135.168.138', '', '', '1', '2008-09-03', '0'), ('5414', '211.136.158.178', '', '', '4', '2008-09-03', '0'), ('5415', '211.143.203.194', '', '', '8', '2008-09-03', '0'), ('5416', '58.53.109.77', '', '', '2', '2008-09-03', '0'), ('5417', '201.195.82.150', '', '', '1', '2008-09-03', '0'), ('5418', '125.95.232.232', '', '', '42', '2008-09-03', '0'), ('5419', '125.93.184.146', '', '', '1', '2008-09-03', '0'), ('5420', '219.131.16.196', '', '', '2', '2008-09-03', '0'), ('5421', '121.68.0.253', '', '', '1', '2008-09-03', '0'), ('5422', '116.28.208.9', '', '', '1', '2008-09-03', '0'), ('5423', '202.160.179.57', '', '', '1', '2008-09-03', '0'), ('5424', '203.142.121.205', '', '', '1', '2008-09-03', '0'), ('5425', '211.136.73.111', '', '', '4', '2008-09-03', '0'), ('5426', '123.147.4.137', '', '', '2', '2008-09-03', '0'), ('5427', '218.30.21.39', '', '', '1', '2008-09-03', '0'), ('5428', '211.136.75.10', '', '', '1', '2008-09-03', '0'), ('5429', '218.205.249.26', '', '', '1', '2008-09-03', '0'), ('5430', '60.13.10.86', '', '', '2', '2008-09-03', '0'), ('5431', '218.5.9.253', '', '', '1', '2008-09-03', '0'), ('5473', '222.131.153.194', '', '', '1', '2008-09-03', '0'), ('5433', '122.231.42.200', '', '', '1', '2008-09-03', '0'), ('5434', '220.206.246.51', '', '', '4', '2008-09-03', '0'), ('5435', '125.91.184.174', '', '', '1', '2008-09-03', '0'), ('5436', '125.89.210.198', '', '', '1', '2008-09-03', '0'), ('5437', '220.207.36.114', '', '', '1', '2008-09-03', '0'), ('5472', '222.91.74.34', '', '', '1', '2008-09-03', '0'), ('5439', '125.68.17.151', '', '', '5', '2008-09-03', '0'), ('5440', '121.204.201.129', '', '', '2', '2008-09-03', '0'), ('5441', '218.193.190.168', '', '', '1', '2008-09-03', '0'), ('5442', '222.217.104.132', '', '', '1', '2008-09-03', '0'), ('5443', '222.245.102.185', '', '', '1', '2008-09-03', '0'), ('5444', '121.41.234.232', '', '', '1', '2008-09-03', '0'), ('5445', '58.251.190.200', '', '', '1', '2008-09-03', '0'), ('5446', '218.23.205.250', '', '', '1', '2008-09-03', '0'), ('5447', '119.129.131.11', '', '', '1', '2008-09-03', '0'), ('5448', '58.61.130.94', '', '', '1', '2008-09-03', '0'), ('5449', '218.75.100.146', '', '', '2', '2008-09-03', '0'), ('5450', '220.206.235.86', '', '', '1', '2008-09-03', '0'), ('5451', '119.127.232.149', '', '', '1', '2008-09-03', '0'), ('5452', '220.162.29.199', '', '', '1', '2008-09-03', '0'), ('5453', '211.138.227.24', '', '', '2', '2008-09-03', '0'), ('5454', '211.137.63.166', '', '', '15', '2008-09-03', '0'), ('5455', '120.12.72.200', '', '', '1', '2008-09-03', '0'), ('5456', '124.227.142.187', '', '', '13', '2008-09-03', '0'), ('5457', '220.194.137.3', '', '', '3', '2008-09-03', '0'), ('5458', '222.81.47.13', '', '', '2', '2008-09-03', '0'), ('5459', '202.103.139.212', '', '', '6', '2008-09-03', '0'), ('5460', '219.133.59.158', '', '', '36', '2008-09-03', '0'), ('5471', '122.224.187.56', '', '', '1', '2008-09-03', '0'), ('5462', '119.160.153.136', '', '', '5', '2008-09-03', '0'), ('5463', '117.93.169.120', '', '', '1', '2008-09-03', '0'), ('5464', '61.144.205.239', '', '', '1', '2008-09-03', '0'), ('5465', '221.131.116.142', '', '', '5', '2008-09-03', '0'), ('5466', '202.160.178.87', '', '', '4', '2008-09-03', '0'), ('5467', '119.141.252.76', '', '', '2', '2008-09-03', '0'), ('5469', '61.176.47.5', '', '', '1', '2008-09-03', '0'), ('5470', '202.160.180.83', '', '', '1', '2008-09-03', '0'), ('5537', '221.225.144.82', '', '', '1', '2008-09-04', '0'), ('5538', '218.249.151.6', '', '', '1', '2008-09-04', '0'), ('5539', '119.123.23.155', '', '', '1', '2008-09-04', '0'), ('5540', '220.243.54.71', '', '', '2', '2008-09-04', '0'), ('5541', '195.189.142.41', '', '', '1', '2008-09-04', '0'), ('5542', '218.205.249.157', '', '', '1', '2008-09-04', '0'), ('5543', '59.40.243.1', '', '', '4', '2008-09-04', '0'), ('5544', '211.136.75.68', '', '', '2', '2008-09-04', '0'), ('5545', '59.35.133.41', '', '', '3', '2008-09-04', '0'), ('5546', '211.136.75.196', '', '', '3', '2008-09-04', '0'), ('5547', '118.74.21.66', '', '', '1', '2008-09-04', '0'), ('5548', '202.160.179.33', '', '', '1', '2008-09-04', '0'), ('5549', '41.207.45.220', '', '', '1', '2008-09-04', '0'), ('5550', '119.128.206.191', '', '', '1', '2008-09-04', '0'), ('5551', '116.226.128.247', '', '', '1', '2008-09-04', '0'), ('5552', '85.185.37.42', '', '', '2', '2008-09-04', '0'), ('5553', '203.208.60.5', '', '', '24', '2008-09-04', '0'), ('5554', '202.160.178.187', '', '', '1', '2008-09-04', '0'), ('5555', '196.207.47.60', '', '', '7', '2008-09-04', '0'), ('5556', '202.160.178.185', '', '', '2', '2008-09-04', '0'), ('5557', '219.131.176.80', '', '', '1', '2008-09-04', '0'), ('5558', '217.202.26.202', '', '', '1', '2008-09-04', '0'), ('5559', '222.183.46.51', '', '', '2', '2008-09-04', '0'), ('5560', '58.55.26.20', '', '', '2', '2008-09-04', '0'), ('5561', '202.160.179.101', '', '', '1', '2008-09-04', '0'), ('5562', '202.160.178.72', '', '', '1', '2008-09-04', '0'), ('5563', '61.135.220.61', '', '', '2', '2008-09-04', '0'), ('5564', '202.160.180.135', '', '', '2', '2008-09-04', '0'), ('5565', '218.15.200.98', '', '', '1', '2008-09-04', '0'), ('5566', '66.249.72.164', '', '', '58', '2008-09-04', '0'), ('5567', '222.214.171.249', '', '', '1', '2008-09-04', '0'), ('5568', '151.80.31.136', '', '', '1', '2008-09-04', '0'), ('5569', '220.202.97.5', '', '', '21', '2008-09-04', '0'), ('5570', '211.136.158.141', '', '', '2', '2008-09-04', '0'), ('5571', '202.160.178.207', '', '', '1', '2008-09-04', '0'), ('5572', '211.138.167.179', '', '', '2', '2008-09-04', '0'), ('5573', '202.160.179.102', '', '', '1', '2008-09-04', '0'), ('5574', '65.161.73.240', '', '', '1', '2008-09-04', '0'), ('5575', '58.63.113.110', '', '', '1', '2008-09-04', '0'), ('5576', '218.104.139.106', '', '', '1', '2008-09-04', '0'), ('5577', '116.24.40.244', '', '', '3', '2008-09-04', '0'), ('5578', '202.160.180.56', '', '', '4', '2008-09-04', '0'), ('5579', '202.160.178.74', '', '', '1', '2008-09-04', '0'), ('5580', '221.131.116.159', '', '', '14', '2008-09-04', '0'), ('5581', '58.60.84.18', '', '', '1', '2008-09-04', '0'), ('5582', '125.67.151.117', '', '', '1', '2008-09-04', '0'), ('5583', '202.160.178.92', '', '', '1', '2008-09-04', '0'), ('5584', '59.56.109.141', '', '', '2', '2008-09-04', '0'), ('5585', '61.146.253.227', '', '', '1', '2008-09-04', '0'), ('5586', '124.114.95.216', '', '', '1', '2008-09-04', '0'), ('5587', '220.181.32.48', '', '', '10', '2008-09-04', '0'), ('5588', '222.84.41.59', '', '', '20', '2008-09-04', '0'), ('5590', '125.92.4.128', '广西', '移动', '1', '2008-09-04', '0'), ('5591', '211.138.227.225', '', '', '1', '2008-09-04', '0'), ('5592', '116.25.105.136', '', '', '1', '2008-09-04', '0'), ('5593', '59.46.88.34', '', '', '1', '2008-09-04', '0'), ('5594', '222.130.130.62', '', '', '1', '2008-09-04', '0'), ('5595', '116.4.139.154', '', '', '1', '2008-09-04', '0'), ('5596', '60.4.158.233', '', '', '1', '2008-09-04', '0'), ('5597', '219.137.38.10', '', '', '7', '2008-09-04', '0'), ('5598', '211.136.75.12', '', '', '2', '2008-09-04', '0'), ('5599', '74.6.22.190', '', '', '6', '2008-09-04', '0'), ('5600', '124.28.224.9', '', '', '1', '2008-09-04', '0'), ('5601', '218.20.225.27', '', '', '1', '2008-09-04', '0'), ('5602', '125.89.25.107', '', '', '2', '2008-09-04', '0'), ('5603', '61.141.155.176', '', '', '1', '2008-09-04', '0'), ('5604', '121.9.250.134', '', '', '4', '2008-09-04', '0'), ('5605', '211.137.37.140', '', '', '26', '2008-09-04', '0'), ('5606', '218.249.229.60', '', '', '2', '2008-09-04', '0'), ('5607', '121.33.108.204', '', '', '1', '2008-09-04', '0'), ('5608', '221.205.33.219', '', '', '1', '2008-09-04', '0'), ('5609', '218.59.233.226', '', '', '3', '2008-09-04', '0'), ('5610', '218.22.174.226', '', '', '1', '2008-09-04', '0'), ('5611', '121.68.0.251', '', '', '2', '2008-09-04', '0'), ('5612', '89.4.108.126', '', '', '1', '2008-09-04', '0'), ('5613', '125.91.4.177', '', '移动', '0', '2008-10-15', '1'), ('5614', '117.11.187.163', '', '', '2', '2008-09-04', '0'), ('5615', '221.0.235.232', '', '', '1', '2008-09-04', '0'), ('5616', '58.71.240.246', '', '', '1', '2008-09-04', '0'), ('5617', '220.206.216.1', '', '', '28', '2008-09-04', '0'), ('5618', '59.107.9.164', '', '', '1', '2008-09-04', '0'), ('5619', '222.133.175.171', '', '', '1', '2008-09-04', '0'), ('5620', '211.137.125.32', '', '', '1', '2008-09-04', '0'), ('5621', '211.138.218.32', '', '', '1', '2008-09-04', '0'), ('5622', '218.94.124.42', '', '', '1', '2008-09-04', '0'), ('5623', '125.106.77.62', '', '', '2', '2008-09-04', '0'), ('5624', '221.0.170.130', '', '', '5', '2008-09-04', '0'), ('5625', '124.164.48.91', '', '', '2', '2008-09-04', '0'), ('5626', '117.24.28.170', '', '', '9', '2008-09-04', '0'), ('5628', '219.136.9.111', '', '', '3', '2008-09-04', '0'), ('5629', '116.245.41.161', '', '', '1', '2008-09-04', '0'), ('5630', '59.108.51.14', '', '', '3', '2008-09-04', '0'), ('5631', '125.93.7.21', '', '', '1', '2008-09-04', '0'), ('5632', '60.208.217.252', '', '', '1', '2008-09-04', '0'), ('5633', '116.76.166.5', '', '', '1', '2008-09-04', '0'), ('5634', '220.231.55.67', '', '', '1', '2008-09-04', '0'), ('5635', '211.136.73.101', '', '', '7', '2008-09-04', '0'), ('5636', '203.145.134.213', '', '', '3', '2008-09-04', '0'), ('5637', '218.15.251.36', '', '', '1', '2008-09-04', '0'), ('5638', '218.13.146.56', '', '', '2', '2008-09-04', '0'), ('5639', '211.137.63.171', '', '', '2', '2008-09-04', '0'), ('5640', '206.49.165.171', '', '', '6', '2008-09-04', '0'), ('5641', '211.138.218.62', '', '', '1', '2008-09-04', '0'), ('5642', '121.11.164.242', '', '', '4', '2008-09-04', '0'), ('5643', '125.86.90.85', '', '', '1', '2008-09-04', '0'), ('5644', '58.38.160.37', '', '', '1', '2008-09-04', '0'), ('5645', '124.116.176.105', '', '', '1', '2008-09-04', '0'), ('5646', '116.24.3.223', '', '', '1', '2008-09-04', '0'), ('5648', '122.224.187.50', '', '', '1', '2008-09-04', '0'), ('5650', '222.141.14.68', '', '', '1', '2008-09-04', '0'), ('5651', '124.226.3.251', '', '', '5', '2008-09-04', '0'), ('5652', '211.136.75.112', '', '', '1', '2008-09-04', '0'), ('5653', '58.49.244.249', '', '', '1', '2008-09-04', '0'), ('5654', '211.137.63.153', '', '', '2', '2008-09-04', '0'), ('5655', '219.136.171.1', '', '', '1', '2008-09-04', '0'), ('5656', '121.29.117.247', '', '', '2', '2008-09-04', '0'), ('5657', '59.107.11.250', '', '', '1', '2008-09-04', '0'), ('5658', '123.147.6.78', '', '', '1', '2008-09-04', '0'), ('5659', '61.164.96.114', '', '', '1', '2008-09-04', '0'), ('5660', '211.136.158.184', '', '', '2', '2008-09-04', '0'), ('5661', '125.70.78.187', '', '', '1', '2008-09-04', '0'), ('5662', '121.207.127.144', '', '', '1', '2008-09-04', '0'), ('5663', '119.39.179.167', '', '', '1', '2008-09-04', '0'), ('5664', '220.206.235.29', '', '', '1', '2008-09-04', '0'), ('5665', '59.59.201.152', '', '', '1', '2008-09-04', '0'), ('5666', '124.206.159.247', '', '', '1', '2008-09-04', '0'), ('5667', '116.18.153.13', '', '', '1', '2008-09-04', '0'), ('5668', '121.205.183.120', '', '', '1', '2008-09-04', '0'), ('5669', '116.25.120.118', '', '', '4', '2008-09-04', '0'), ('5670', '222.77.162.17', '', '', '1', '2008-09-04', '0'), ('5671', '202.160.178.195', '', '', '1', '2008-09-04', '0'), ('5672', '125.33.53.147', '', '', '3', '2008-09-04', '0'), ('5673', '58.42.7.127', '', '', '2', '2008-09-04', '0'), ('5674', '119.122.27.218', '', '', '1', '2008-09-04', '0'), ('5675', '202.190.154.185', '', '', '1', '2008-09-04', '0'), ('5676', '61.150.89.18', '', '', '1', '2008-09-04', '0'), ('5677', '116.24.9.194', '', '', '1', '2008-09-04', '0'), ('5678', '222.183.73.88', '', '', '2', '2008-09-04', '0'), ('5679', '222.219.49.188', '', '', '1', '2008-09-04', '0'), ('5680', '119.163.114.49', '', '', '1', '2008-09-04', '0'), ('5681', '116.232.17.209', '', '', '1', '2008-09-04', '0'), ('5682', '219.128.128.116', '', '', '1', '2008-09-04', '0'), ('5683', '202.160.179.148', '', '', '1', '2008-09-04', '0'), ('5684', '219.133.17.201', '', '', '1', '2008-09-04', '0'), ('5685', '211.136.75.137', '', '', '2', '2008-09-04', '0'), ('5686', '125.73.117.240', '', '', '1', '2008-09-04', '0'), ('5687', '211.95.72.184', '', '', '1', '2008-09-04', '0'), ('5688', '222.175.129.83', '', '', '4', '2008-09-04', '0'), ('5689', '218.79.102.178', '', '', '1', '2008-09-04', '0'), ('5690', '58.209.214.109', '', '', '1', '2008-09-04', '0'), ('5691', '218.30.126.173', '', '', '1', '2008-09-04', '0'), ('5692', '61.168.213.59', '', '', '3', '2008-09-04', '0'), ('5693', '62.154.160.83', '', '', '1', '2008-09-04', '0'), ('5694', '121.33.136.55', '', '', '1', '2008-09-04', '0'), ('5695', '211.136.73.74', '', '', '7', '2008-09-04', '0'), ('5696', '60.1.43.146', '', '', '6', '2008-09-04', '0'), ('5697', '116.28.55.210', '', '', '1', '2008-09-04', '0'), ('5698', '61.135.220.16', '', '', '1', '2008-09-04', '0'), ('5699', '59.42.113.147', '', '', '2', '2008-09-04', '0'), ('5700', '220.181.32.29', '', '', '1', '2008-09-04', '0'), ('5701', '58.51.137.147', '', '', '2', '2008-09-04', '0'), ('5702', '59.39.201.242', '', '', '1', '2008-09-04', '0'), ('5703', '59.33.137.16', '', '', '1', '2008-09-04', '0'), ('5704', '58.65.203.33', '', '', '3', '2008-09-04', '0'), ('5705', '125.42.185.208', '', '', '1', '2008-09-04', '0'), ('5706', '60.173.173.203', '', '', '1', '2008-09-04', '0'), ('5707', '59.42.54.232', '', '', '1', '2008-09-04', '0'), ('5708', '125.91.33.115', '', '', '2', '2008-09-04', '0'), ('5709', '202.160.180.187', '', '', '1', '2008-09-04', '0'), ('5710', '202.160.178.45', '', '', '1', '2008-09-04', '0'), ('5711', '202.160.180.175', '', '', '1', '2008-09-04', '0'), ('5712', '124.236.140.192', '', '', '2', '2008-09-04', '0'), ('5713', '58.62.117.221', '', '', '1', '2008-09-04', '0'), ('5714', '121.30.234.70', '', '', '2', '2008-09-04', '0'), ('5715', '59.36.42.37', '', '', '1', '2008-09-04', '0'), ('5716', '123.131.125.36', '', '', '1', '2008-09-04', '0'), ('5717', '125.91.253.134', '', '移动', '0', '2008-10-15', '1'), ('5718', '124.226.40.251', '', '', '2', '2008-09-04', '0'), ('5719', '116.20.244.178', '', '', '2', '2008-09-04', '0'), ('5720', '218.200.224.80', '', '', '1', '2008-09-04', '0'), ('5721', '211.139.162.201', '', '', '21', '2008-09-04', '0'), ('5722', '195.189.142.234', '', '', '2', '2008-09-04', '0'), ('5723', '61.144.230.122', '', '', '1', '2008-09-04', '0'), ('5724', '218.205.252.48', '', '', '1', '2008-09-04', '0'), ('5725', '121.205.46.180', '', '', '1', '2008-09-04', '0'), ('5726', '218.205.252.56', '', '', '1', '2008-09-04', '0'), ('5727', '222.84.40.253', '', '', '51', '2008-09-04', '0'), ('5728', '117.91.19.169', '', '', '1', '2008-09-04', '0'), ('5729', '211.137.63.66', '', '', '1', '2008-09-04', '0'), ('5730', '124.236.137.17', '', '', '2', '2008-09-04', '0'), ('5731', '119.141.204.167', '', '', '1', '2008-09-04', '0'), ('5732', '220.178.74.110', '', '', '3', '2008-09-04', '0'), ('5733', '60.1.42.69', '', '', '3', '2008-09-04', '0'), ('5734', '74.6.18.245', '', '', '4', '2008-09-04', '0'), ('5735', '116.18.204.79', '', '', '1', '2008-09-04', '0'), ('5736', '119.39.177.73', '', '', '1', '2008-09-04', '0'), ('5737', '59.35.82.174', '', '', '1', '2008-09-04', '0'), ('5738', '218.69.6.101', '', '', '2', '2008-09-04', '0'), ('5739', '220.161.165.173', '', '', '2', '2008-09-04', '0'), ('5740', '220.161.122.67', '', '', '2', '2008-09-04', '0'), ('5741', '211.137.41.18', '', '', '2', '2008-09-04', '0'), ('5742', '121.32.9.227', '', '', '1', '2008-09-04', '0'), ('5743', '125.119.107.39', '', '', '2', '2008-09-04', '0'), ('5744', '211.138.227.14', '', '', '1', '2008-09-04', '0'), ('5745', '218.192.20.207', '', '', '1', '2008-09-04', '0'), ('5746', '118.24.208.139', '', '', '1', '2008-09-04', '0'), ('5747', '124.225.31.47', '', '', '1', '2008-09-04', '0'), ('5748', '99.255.212.171', '', '', '1', '2008-09-04', '0'), ('5749', '118.192.105.129', '', '', '3', '2008-09-04', '0'), ('5750', '119.234.0.1', '', '', '2', '2008-09-04', '0'), ('5751', '116.24.159.48', '', '', '3', '2008-09-04', '0'), ('5752', '59.42.156.37', '', '', '1', '2008-09-05', '0'), ('5753', '58.210.96.67', '', '', '2', '2008-09-05', '0'), ('5754', '61.171.40.213', '', '', '2', '2008-09-05', '0'), ('5755', '116.21.55.92', '', '', '1', '2008-09-05', '0'), ('5756', '121.31.52.246', '', '', '1', '2008-09-05', '0'), ('5757', '221.216.187.44', '', '', '2', '2008-09-05', '0'), ('5758', '211.154.45.102', '', '', '14', '2008-09-05', '0'), ('5759', '125.86.88.114', '', '', '2', '2008-09-05', '0'), ('5760', '211.136.158.186', '', '', '14', '2008-09-05', '0'), ('5761', '119.163.114.125', '', '', '4', '2008-09-05', '0'), ('5762', '211.136.75.74', '', '', '1', '2008-09-05', '0'), ('5763', '220.206.246.50', '', '', '2', '2008-09-05', '0'), ('5764', '60.176.44.119', '', '', '1', '2008-09-05', '0'), ('5765', '222.70.168.252', '', '', '1', '2008-09-05', '0'), ('5766', '220.181.32.52', '', '', '2', '2008-09-05', '0'), ('5767', '211.136.75.240', '', '', '1', '2008-09-05', '0'), ('5768', '59.34.182.113', '', '', '1', '2008-09-05', '0'), ('5769', '211.136.158.170', '', '', '2', '2008-09-05', '0'), ('5770', '116.26.247.110', '', '', '1', '2008-09-05', '0'), ('5771', '209.183.55.7', '', '', '1', '2008-09-05', '0'), ('5772', '220.176.162.16', '', '', '2', '2008-09-05', '0'), ('5773', '122.240.86.126', '', '', '1', '2008-09-05', '0'), ('5774', '219.78.34.41', '', '', '2', '2008-09-05', '0'), ('5775', '217.118.78.105', '', '', '1', '2008-09-05', '0'), ('5776', '219.78.35.60', '', '', '3', '2008-09-05', '0'), ('5777', '119.32.49.188', '', '', '1', '2008-09-05', '0'), ('5778', '116.21.34.38', '', '', '1', '2008-09-05', '0'), ('5779', '219.129.183.162', '', '', '2', '2008-09-05', '0'), ('5780', '61.135.168.14', '', '', '3', '2008-09-05', '0'), ('5781', '202.160.178.111', '', '', '2', '2008-09-05', '0'), ('5782', '219.131.19.8', '', '', '1', '2008-09-05', '0'), ('5783', '211.138.218.115', '', '', '1', '2008-09-05', '0'), ('5784', '58.241.21.157', '', '', '1', '2008-09-05', '0'), ('5785', '219.131.195.218', '', '', '2', '2008-09-05', '0'), ('5786', '202.160.179.160', '', '', '1', '2008-09-05', '0'), ('5787', '220.181.65.67', '', '', '1', '2008-09-05', '0'), ('5788', '196.30.118.78', '', '', '3', '2008-09-05', '0'), ('5789', '210.153.84.12', '', '', '1', '2008-09-05', '0'), ('5790', '203.208.60.129', '', '', '1468', '2008-09-05', '1'), ('5791', '61.240.196.200', '', '', '1', '2008-09-05', '0'), ('5792', '211.136.73.103', '', '', '2', '2008-09-05', '0'), ('5793', '125.91.4.160', '', '移动', '0', '2008-10-15', '1'), ('5794', '124.236.137.220', '', '', '4', '2008-09-05', '0'), ('5795', '121.13.217.98', '', '', '2', '2008-09-05', '0'), ('5796', '58.31.83.47', '', '', '1', '2008-09-05', '0'), ('5797', '211.136.158.146', '', '', '1', '2008-09-05', '0'), ('5798', '218.247.44.18', '', '', '1', '2008-09-05', '0'), ('5799', '123.123.251.53', '', '', '1', '2008-09-05', '0'), ('5800', '119.122.214.76', '', '', '1', '2008-09-05', '0'), ('5801', '123.5.172.211', '', '', '2', '2008-09-05', '0'), ('5802', '59.32.106.194', '', '', '1', '2008-09-05', '0'), ('5803', '195.189.142.244', '', '', '2', '2008-09-05', '0'), ('5804', '211.137.62.252', '', '', '1', '2008-09-05', '0'), ('5805', '211.138.218.0', '', '', '1', '2008-09-05', '0'), ('5806', '124.88.155.196', '', '', '1', '2008-09-05', '0'), ('5807', '222.216.100.141', '', '', '15', '2008-09-05', '0'), ('5808', '59.54.20.108', '', '', '2', '2008-09-05', '0'), ('5809', '200.43.139.14', '', '', '2', '2008-09-05', '0'), ('5810', '116.22.209.116', '', '', '1', '2008-09-05', '0'), ('5811', '117.67.15.104', '', '', '1', '2008-09-05', '0'), ('5812', '219.136.219.208', '', '', '3', '2008-09-05', '0'), ('5813', '61.144.113.54', '', '', '9', '2008-09-05', '0'), ('5814', '121.41.90.118', '', '', '2', '2008-09-05', '0'), ('5815', '61.145.63.238', '', '', '1', '2008-09-05', '0'), ('5816', '60.1.49.139', '', '', '2', '2008-09-05', '0'), ('5817', '219.136.6.167', '', '', '1', '2008-09-05', '0'), ('5818', '125.91.202.12', '', '', '1', '2008-09-05', '0'), ('5819', '202.160.180.176', '', '', '2', '2008-09-05', '0'), ('5820', '119.126.16.159', '', '', '2', '2008-09-05', '0'), ('5821', '61.140.145.26', '', '', '1', '2008-09-05', '0'), ('5822', '218.16.111.94', '', '', '1', '2008-09-05', '0'), ('5823', '222.216.134.87', '', '', '695', '2008-09-05', '0'), ('5824', '220.206.235.87', '', '', '1', '2008-09-05', '0'), ('5825', '195.189.142.80', '', '', '1', '2008-09-05', '0'), ('5826', '218.205.252.182', '', '', '1', '2008-09-05', '0'), ('5827', '60.178.158.87', '', '', '2', '2008-09-05', '0'), ('5828', '121.12.1.192', '', '', '1', '2008-09-05', '0'), ('5829', '218.71.239.194', '', '', '1', '2008-09-05', '0'), ('5830', '202.160.178.123', '', '', '1', '2008-09-05', '0'), ('5831', '121.8.40.44', '', '', '1', '2008-09-05', '0'), ('5832', '117.40.124.58', '', '', '2', '2008-09-05', '0'), ('5833', '220.206.246.43', '', '', '4', '2008-09-05', '0'), ('5834', '202.160.178.29', '', '', '1', '2008-09-05', '0'), ('5835', '211.139.162.184', '', '', '13', '2008-09-05', '0'), ('5836', '218.93.17.226', '', '', '2', '2008-09-05', '0'), ('5837', '124.238.184.82', '', '', '2', '2008-09-05', '0'), ('5838', '60.9.241.195', '', '', '1', '2008-09-05', '0'), ('5839', '59.34.206.11', '', '', '2', '2008-09-05', '0'), ('5840', '211.139.162.186', '', '', '16', '2008-09-05', '0'), ('5841', '125.86.91.160', '', '', '3', '2008-09-05', '0'), ('5842', '211.139.162.163', '', '', '20', '2008-09-05', '0'), ('5843', '61.153.1.156', '', '', '1', '2008-09-05', '0'), ('5844', '124.226.45.6', '', '', '1', '2008-09-05', '0'), ('5845', '58.213.220.177', '', '', '1', '2008-09-05', '0'), ('5846', '221.14.145.176', '', '', '2', '2008-09-05', '0'), ('5847', '222.245.96.90', '', '', '1', '2008-09-05', '0'), ('5848', '220.206.240.36', '', '', '1', '2008-09-05', '0'), ('5849', '211.138.200.177', '', '', '5', '2008-09-05', '0'), ('5850', '116.16.153.62', '', '', '1', '2008-09-05', '0'), ('5851', '220.181.32.66', '', '', '10', '2008-09-05', '0'), ('5852', '60.3.145.175', '', '', '3', '2008-09-05', '0'), ('5853', '202.160.180.47', '', '', '1', '2008-09-05', '0'), ('5854', '116.16.199.12', '', '', '1', '2008-09-05', '0'), ('5855', '222.183.44.80', '', '', '3', '2008-09-05', '0'), ('5856', '61.131.120.50', '', '', '1', '2008-09-05', '0'), ('5857', '58.33.95.80', '', '', '1', '2008-09-05', '0'), ('5858', '116.197.217.128', '', '', '1', '2008-09-05', '0'), ('5859', '124.236.132.14', '', '', '1', '2008-09-05', '0'), ('5860', '221.15.74.136', '', '', '2', '2008-09-05', '0'), ('5861', '117.20.115.159', '', '', '2', '2008-09-05', '0'), ('5862', '121.32.21.15', '', '', '1', '2008-09-05', '0'), ('5863', '116.29.152.195', '', '', '1', '2008-09-05', '0'), ('5864', '59.108.78.35', '', '', '2', '2008-09-05', '0'), ('5865', '222.35.50.63', '', '', '1', '2008-09-05', '0'), ('5866', '211.136.158.238', '', '', '1', '2008-09-05', '0'), ('5867', '121.204.192.202', '', '', '2', '2008-09-05', '0'), ('5868', '58.253.19.196', '', '', '1', '2008-09-05', '0'), ('5869', '222.69.121.128', '', '', '1', '2008-09-05', '0'), ('5870', '221.237.164.26', '', '', '1', '2008-09-05', '0'), ('5871', '218.205.252.141', '', '', '2', '2008-09-05', '0'), ('5872', '202.108.7.208', '', '', '2', '2008-09-05', '0'), ('5873', '60.216.222.236', '', '', '1', '2008-09-05', '0'), ('5874', '218.75.123.171', '', '', '1', '2008-09-05', '0'), ('5875', '218.200.224.143', '', '', '2', '2008-09-05', '0'), ('5876', '117.68.54.254', '', '', '1', '2008-09-05', '0'), ('5877', '125.34.103.52', '', '', '1', '2008-09-05', '0'), ('5878', '222.66.78.10', '', '', '1', '2008-09-05', '0'), ('5879', '211.138.218.111', '', '', '1', '2008-09-05', '0'), ('5880', '91.121.139.153', '', '', '1', '2008-09-05', '0'), ('5881', '60.191.67.214', '', '', '2', '2008-09-05', '0'), ('5882', '59.51.46.253', '', '', '1', '2008-09-05', '0'), ('5883', '218.204.251.101', '', '', '1', '2008-09-05', '0'), ('5884', '222.76.205.181', '', '', '2', '2008-09-05', '0'), ('5885', '218.200.224.126', '', '', '1', '2008-09-05', '0'), ('5886', '211.136.158.135', '', '', '1', '2008-09-05', '0'), ('5887', '211.137.41.21', '', '', '4', '2008-09-05', '0'), ('5888', '219.143.150.235', '', '', '1', '2008-09-05', '0'), ('5889', '58.35.103.57', '', '', '1', '2008-09-05', '0'), ('5890', '59.35.94.115', '', '', '1', '2008-09-05', '0'), ('5891', '119.123.225.245', '', '', '1', '2008-09-05', '0'), ('5892', '41.208.48.193', '', '', '6', '2008-09-05', '0'), ('5893', '219.132.186.79', '', '', '1', '2008-09-05', '0'), ('5894', '219.136.173.47', '', '', '2', '2008-09-05', '0'), ('5895', '59.36.29.241', '', '', '1', '2008-09-05', '0'), ('5896', '61.168.213.205', '', '', '4', '2008-09-05', '0'), ('5897', '124.227.241.202', '', '', '9155', '2008-09-05', '0'), ('5898', '222.183.71.66', '', '', '1', '2008-09-05', '0'), ('5899', '119.141.24.189', '', '', '11', '2008-09-05', '0'), ('5900', '202.160.178.64', '', '', '1', '2008-09-05', '0'), ('5901', '119.120.9.104', '', '', '1', '2008-09-05', '0'), ('5902', '218.2.66.123', '', '', '1', '2008-09-05', '0'), ('5903', '222.77.31.84', '', '', '1', '2008-09-05', '0'), ('5904', '61.182.194.38', '', '', '1', '2008-09-05', '0'), ('5905', '220.200.58.157', '', '', '1', '2008-09-05', '0'), ('5906', '120.4.67.126', '', '', '7', '2008-09-05', '0'), ('5907', '61.135.168.23', '', '', '5', '2008-09-05', '0'), ('5908', '220.206.246.26', '', '', '2', '2008-09-05', '0'), ('5909', '121.63.33.131', '', '', '2', '2008-09-05', '0'), ('5910', '117.9.19.148', '', '', '1', '2008-09-05', '0'), ('5911', '120.14.14.214', '', '', '1', '2008-09-05', '0'), ('5912', '218.207.95.43', '', '', '1', '2008-09-05', '0'), ('5913', '58.71.239.67', '', '', '1', '2008-09-05', '0'), ('5914', '218.65.113.243', '', '', '1', '2008-09-05', '0'), ('5915', '123.15.47.218', '', '', '1', '2008-09-05', '0'), ('5916', '91.203.96.28', '', '', '2', '2008-09-05', '0'), ('5917', '58.221.241.224', '', '', '10', '2008-09-05', '0'), ('5918', '58.38.204.2', '', '', '1', '2008-09-05', '0'), ('5919', '59.42.59.87', '', '', '1', '2008-09-05', '0'), ('5920', '222.88.70.138', '', '', '1', '2008-09-05', '0'), ('5921', '203.145.92.94', '', '', '1', '2008-09-05', '0'), ('5922', '211.145.6.148', '', '', '1', '2008-09-05', '0'), ('5923', '220.187.70.243', '', '', '1', '2008-09-05', '0'), ('5924', '211.138.218.127', '', '', '1', '2008-09-05', '0'), ('5925', '121.235.190.122', '', '', '1', '2008-09-05', '0'), ('5926', '222.88.77.145', '', '', '1', '2008-09-05', '0'), ('5927', '116.22.189.27', '', '', '1', '2008-09-05', '0'), ('5928', '121.8.50.49', '', '', '2', '2008-09-05', '0'), ('5929', '221.239.20.132', '', '', '1', '2008-09-05', '0'), ('5930', '121.37.44.12', '', '', '2', '2008-09-05', '0'), ('5931', '218.16.112.165', '', '', '1', '2008-09-05', '0'), ('5932', '116.27.36.53', '', '', '2', '2008-09-05', '0'), ('5933', '202.160.180.7', '', '', '1', '2008-09-05', '0'), ('5934', '211.138.227.222', '', '', '1', '2008-09-05', '0'), ('5935', '220.199.241.118', '', '', '1', '2008-09-05', '0'), ('5936', '58.248.194.199', '', '', '1', '2008-09-05', '0'), ('5937', '58.41.61.233', '', '', '1', '2008-09-05', '0'), ('5938', '218.205.252.177', '', '', '1', '2008-09-05', '0'), ('5939', '202.160.182.11', '', '', '1', '2008-09-05', '0'), ('5940', '119.128.227.65', '', '', '1', '2008-09-05', '0'), ('5941', '219.132.114.38', '', '', '2', '2008-09-05', '0'), ('5942', '222.130.49.76', '', '', '4', '2008-09-05', '0'), ('5943', '222.42.101.44', '', '', '1', '2008-09-06', '0'), ('5944', '58.61.131.39', '', '', '2', '2008-09-06', '0'), ('5945', '60.182.160.31', '', '', '1', '2008-09-06', '0'), ('5946', '219.130.57.100', '', '', '1', '2008-09-06', '0'), ('5947', '211.138.227.111', '', '', '1', '2008-09-06', '0'), ('5948', '60.216.184.87', '', '', '3', '2008-09-06', '0'), ('5949', '121.9.114.215', '', '', '1', '2008-09-06', '0'), ('5950', '116.4.235.53', '', '', '2', '2008-09-06', '0'), ('5951', '195.189.142.42', '', '', '2', '2008-09-06', '0'), ('5952', '221.224.129.34', '', '', '2', '2008-09-06', '0'), ('5953', '123.4.113.152', '', '', '1', '2008-09-06', '0'), ('5954', '211.143.149.103', '', '', '1', '2008-09-06', '0'), ('5955', '195.189.142.134', '', '', '2', '2008-09-06', '0'), ('5956', '59.41.60.58', '', '', '1', '2008-09-06', '0'), ('5957', '202.160.178.190', '', '', '4', '2008-09-06', '0');
INSERT INTO `ig_gateway` VALUES ('5958', '59.40.221.25', '', '', '1', '2008-09-06', '0'), ('5959', '59.36.21.48', '', '', '1', '2008-09-06', '0'), ('5960', '219.136.2.145', '', '', '1', '2008-09-06', '0'), ('5961', '59.35.129.184', '', '', '1', '2008-09-06', '0'), ('5962', '211.136.75.254', '', '', '2', '2008-09-06', '0'), ('5963', '222.73.95.21', '', '', '4', '2008-09-06', '0'), ('5964', '202.160.180.61', '', '', '1', '2008-09-06', '0'), ('5965', '123.233.246.240', '', '', '1', '2008-09-06', '0'), ('5966', '58.39.118.226', '', '', '1', '2008-09-06', '0'), ('5967', '202.104.125.113', '', '', '1', '2008-09-06', '0'), ('5968', '124.66.65.186', '', '', '1', '2008-09-06', '0'), ('5970', '211.139.16.178', '', '', '7', '2008-09-06', '0'), ('5971', '196.207.35.245', '', '', '7', '2008-09-06', '0'), ('5972', '210.241.199.206', '', '', '5', '2008-09-06', '0'), ('5973', '59.33.254.147', '', '', '1', '2008-09-06', '0'), ('5974', '220.181.32.34', '', '', '1', '2008-09-06', '0'), ('5975', '219.154.22.244', '', '', '3', '2008-09-06', '0'), ('5976', '202.160.179.168', '', '', '1', '2008-09-06', '0'), ('5977', '120.87.205.8', '', '', '2', '2008-09-06', '0'), ('5978', '121.43.52.109', '', '', '2', '2008-09-06', '0'), ('5979', '202.160.180.154', '', '', '2', '2008-09-06', '0'), ('5980', '222.222.221.4', '', '', '1', '2008-09-06', '0'), ('5981', '211.136.75.130', '', '', '1', '2008-09-06', '0'), ('5982', '211.137.62.194', '', '', '1', '2008-09-06', '0'), ('5983', '60.223.176.149', '', '', '1', '2008-09-06', '0'), ('5984', '72.14.204.136', '', '', '5', '2008-09-06', '0'), ('5985', '202.160.178.243', '', '', '1', '2008-09-06', '0'), ('5986', '202.160.179.3', '', '', '1', '2008-09-06', '0'), ('5987', '222.168.65.121', '', '', '1', '2008-09-06', '0'), ('5988', '220.181.32.46', '', '', '1', '2008-09-06', '0'), ('5989', '202.160.179.58', '', '', '1', '2008-09-06', '0'), ('5990', '218.79.116.36', '', '', '1', '2008-09-06', '0'), ('5991', '202.160.179.64', '', '', '1', '2008-09-06', '0'), ('5992', '202.160.180.180', '', '', '2', '2008-09-06', '0'), ('5993', '222.132.227.21', '', '', '1', '2008-09-06', '0'), ('5994', '124.128.123.149', '', '', '2', '2008-09-06', '0'), ('5995', '218.60.94.166', '', '', '2', '2008-09-06', '0'), ('5996', '58.211.153.46', '', '', '2', '2008-09-06', '0'), ('5997', '222.216.135.177', '', '', '1617', '2008-09-06', '0'), ('5998', '116.17.92.80', '', '', '1', '2008-09-06', '0'), ('5999', '117.93.167.139', '', '', '2', '2008-09-06', '0'), ('6000', '118.119.81.79', '', '', '1', '2008-09-06', '0'), ('6001', '116.23.39.199', '', '', '1', '2008-09-06', '0'), ('6002', '203.142.123.81', '', '', '1', '2008-09-06', '0'), ('6003', '211.136.158.245', '', '', '1', '2008-09-06', '0'), ('6004', '219.146.215.158', '', '', '1', '2008-09-06', '0'), ('6005', '58.62.205.242', '', '', '1', '2008-09-06', '0'), ('6006', '219.135.130.226', '', '', '1', '2008-09-06', '0'), ('6007', '222.175.186.90', '', '', '2', '2008-09-06', '0'), ('6008', '202.160.178.121', '', '', '3', '2008-09-06', '0'), ('6009', '221.12.169.242', '', '', '1', '2008-09-06', '0'), ('6010', '61.168.213.251', '', '', '3', '2008-09-06', '0'), ('6011', '219.128.40.161', '', '', '1', '2008-09-06', '0'), ('6012', '220.178.150.44', '', '', '1', '2008-09-06', '0'), ('6013', '222.42.77.128', '', '', '1', '2008-09-06', '0'), ('6014', '220.181.32.25', '', '', '2', '2008-09-06', '0'), ('6015', '67.80.43.79', '', '', '3', '2008-09-06', '0'), ('6016', '222.132.24.10', '', '', '1', '2008-09-06', '0'), ('6017', '121.8.48.210', '', '', '4', '2008-09-06', '0'), ('6018', '222.173.50.2', '', '', '2', '2008-09-06', '0'), ('6019', '195.189.142.175', '', '', '1', '2008-09-06', '0'), ('6020', '211.145.120.15', '', '', '2', '2008-09-06', '0'), ('6021', '121.207.196.120', '', '', '2', '2008-09-06', '0'), ('6022', '222.241.179.32', '', '', '2', '2008-09-06', '0'), ('6023', '218.20.1.212', '', '', '2', '2008-09-06', '0'), ('6024', '116.28.15.144', '', '', '1', '2008-09-06', '0'), ('6025', '125.93.188.178', '', '', '1', '2008-09-06', '0'), ('6026', '211.137.41.17', '', '', '4', '2008-09-06', '0'), ('6027', '124.112.2.170', '', '', '3', '2008-09-06', '0'), ('6028', '125.92.32.116', '', '', '1', '2008-09-06', '0'), ('6029', '222.138.68.139', '', '', '4', '2008-09-06', '0'), ('6030', '114.95.48.103', '', '', '1', '2008-09-06', '0'), ('6031', '202.160.180.92', '', '', '1', '2008-09-06', '0'), ('6032', '202.160.178.244', '', '', '1', '2008-09-06', '0'), ('6033', '218.13.73.236', '', '', '1', '2008-09-06', '0'), ('6034', '125.92.86.48', '', '', '1', '2008-09-06', '0'), ('6035', '58.71.198.103', '', '', '1', '2008-09-06', '0'), ('6036', '58.63.136.2', '', '', '1', '2008-09-06', '0'), ('6037', '60.216.241.218', '', '', '1', '2008-09-06', '0'), ('6038', '202.160.180.173', '', '', '1', '2008-09-06', '0'), ('6039', '61.131.75.99', '', '', '2', '2008-09-06', '0'), ('6040', '124.134.26.10', '', '', '1', '2008-09-06', '0'), ('6041', '122.4.54.142', '', '', '1', '2008-09-06', '0'), ('6042', '211.136.75.146', '', '', '4', '2008-09-06', '0'), ('6043', '218.200.224.128', '', '', '1', '2008-09-06', '0'), ('6044', '202.160.180.108', '', '', '1', '2008-09-06', '0'), ('6045', '211.137.62.216', '', '', '14', '2008-09-06', '0'), ('6046', '218.205.249.99', '', '', '1', '2008-09-06', '0'), ('6047', '218.19.84.182', '', '', '5', '2008-09-06', '0'), ('6048', '123.175.187.100', '', '', '72', '2008-09-06', '0'), ('6049', '202.160.180.208', '', '', '1', '2008-09-06', '0'), ('6050', '222.216.134.179', '', '', '2220', '2008-09-06', '0'), ('6051', '221.224.48.210', '', '', '1', '2008-09-06', '0'), ('6052', '58.42.99.236', '', '', '2', '2008-09-06', '0'), ('6053', '222.211.155.40', '', '', '1', '2008-09-06', '0'), ('6054', '222.189.117.49', '', '', '2', '2008-09-06', '0'), ('6055', '125.95.255.145', '', '', '1', '2008-09-06', '0'), ('6056', '221.214.179.201', '', '', '2', '2008-09-06', '0'), ('6057', '211.143.149.227', '', '', '2', '2008-09-06', '0'), ('6058', '202.101.116.160', '', '', '1', '2008-09-06', '0'), ('6059', '123.117.142.192', '', '', '1', '2008-09-06', '0'), ('6060', '60.207.223.82', '', '', '1', '2008-09-06', '0'), ('6061', '125.77.180.6', '', '', '1', '2008-09-06', '0'), ('6062', '221.201.83.83', '', '', '4', '2008-09-06', '0'), ('6063', '125.66.67.29', '', '', '1', '2008-09-06', '0'), ('6064', '211.137.37.133', '', '', '2', '2008-09-06', '0'), ('6065', '222.218.74.14', '', '', '2', '2008-09-06', '0'), ('6066', '218.94.99.66', '', '', '1', '2008-09-06', '0'), ('6067', '121.12.14.59', '', '', '3', '2008-09-06', '0'), ('6068', '58.59.152.226', '', '', '1', '2008-09-06', '0'), ('6069', '61.145.152.28', '', '', '1', '2008-09-06', '0'), ('6070', '60.212.47.197', '', '', '1', '2008-09-06', '0'), ('6071', '119.32.37.140', '', '', '1', '2008-09-06', '0'), ('6072', '61.186.179.1', '', '', '1', '2008-09-06', '0'), ('6073', '202.160.178.115', '', '', '1', '2008-09-06', '0'), ('6074', '219.137.107.28', '', '', '1', '2008-09-06', '0'), ('6075', '119.128.77.60', '', '', '2', '2008-09-06', '0'), ('6076', '117.95.38.211', '', '', '1', '2008-09-06', '0'), ('6077', '202.160.180.78', '', '', '1', '2008-09-06', '0'), ('6078', '222.240.164.137', '', '', '1', '2008-09-06', '0'), ('6079', '211.136.158.216', '', '', '4', '2008-09-06', '0'), ('6080', '125.40.189.229', '', '', '8', '2008-09-06', '0'), ('6081', '203.145.92.95', '', '', '1', '2008-09-06', '0'), ('6082', '116.25.23.54', '', '', '1', '2008-09-06', '0'), ('6083', '202.160.178.71', '', '', '1', '2008-09-06', '0'), ('6084', '88.249.63.132', '', '', '1', '2008-09-06', '0'), ('6085', '60.190.247.18', '', '', '1', '2008-09-06', '0'), ('6086', '218.20.221.111', '', '', '1', '2008-09-06', '0'), ('6087', '119.124.209.147', '', '', '1', '2008-09-06', '0'), ('6088', '125.93.183.219', '', '', '3', '2008-09-06', '0'), ('6089', '58.59.223.85', '', '', '1204', '2008-09-06', '0'), ('6090', '218.16.190.144', '', '', '1', '2008-09-06', '0'), ('6091', '222.217.103.42', '', '', '2', '2008-09-06', '0'), ('6092', '202.160.179.150', '', '', '1', '2008-09-06', '0'), ('6093', '211.136.158.162', '', '', '3', '2008-09-06', '0'), ('6094', '124.236.164.101', '', '', '1', '2008-09-06', '0'), ('6095', '211.136.158.227', '', '', '1', '2008-09-06', '0'), ('6096', '211.145.3.46', '', '', '1', '2008-09-06', '0'), ('6097', '222.86.60.79', '', '', '1', '2008-09-06', '0'), ('6098', '124.197.111.118', '', '', '1', '2008-09-06', '0'), ('6099', '116.226.196.75', '', '', '3', '2008-09-06', '0'), ('6100', '60.20.54.196', '', '', '1', '2008-09-06', '0'), ('6101', '60.3.151.93', '', '', '1', '2008-09-06', '0'), ('6102', '220.206.245.2', '', '', '4', '2008-09-06', '0'), ('6103', '125.78.2.131', '', '', '1', '2008-09-06', '0'), ('6104', '116.17.91.129', '', '', '1', '2008-09-06', '0'), ('6105', '219.148.41.203', '', '', '3', '2008-09-06', '0'), ('6106', '58.61.231.202', '', '', '1', '2008-09-06', '0'), ('6107', '211.136.158.157', '', '', '4', '2008-09-06', '0'), ('6108', '124.131.220.120', '', '', '1', '2008-09-06', '0'), ('6109', '124.227.143.11', '', '', '4919', '2008-09-06', '0'), ('6110', '121.32.160.229', '', '', '1', '2008-09-06', '0'), ('6111', '211.136.75.120', '', '', '1', '2008-09-06', '0'), ('6112', '125.124.248.52', '', '', '1', '2008-09-06', '0'), ('6113', '219.132.115.173', '', '', '1', '2008-09-06', '0'), ('6114', '58.31.118.102', '', '', '2', '2008-09-06', '0'), ('6115', '222.130.40.143', '', '', '8', '2008-09-06', '0'), ('6116', '211.137.41.16', '', '', '9', '2008-09-06', '0'), ('6117', '202.160.180.178', '', '', '1', '2008-09-06', '0'), ('6118', '219.141.2.173', '', '', '2', '2008-09-06', '0'), ('6119', '220.206.255.3', '', '', '1', '2008-09-07', '0'), ('6120', '218.5.10.174', '', '', '8', '2008-09-07', '0'), ('6121', '125.89.16.34', '', '', '1', '2008-09-07', '0'), ('6122', '219.136.202.120', '', '', '1', '2008-09-07', '0'), ('6123', '118.20.83.212', '', '', '2', '2008-09-07', '0'), ('6124', '59.61.218.118', '', '', '15', '2008-09-07', '0'), ('6125', '60.185.94.243', '', '', '2', '2008-09-07', '0'), ('6126', '121.13.120.60', '', '', '3', '2008-09-07', '0'), ('6127', '218.205.249.186', '', '', '1', '2008-09-07', '0'), ('6128', '218.205.252.180', '', '', '1', '2008-09-07', '0'), ('6129', '211.137.63.77', '', '', '1', '2008-09-07', '0'), ('6130', '60.214.234.204', '', '', '2', '2008-09-07', '0'), ('6131', '60.168.56.210', '', '', '43', '2008-09-07', '0'), ('6132', '59.42.57.25', '', '', '1', '2008-09-07', '0'), ('6133', '203.145.92.84', '', '', '5', '2008-09-07', '0'), ('6134', '202.160.179.100', '', '', '1', '2008-09-07', '0'), ('6135', '221.205.215.182', '', '', '1', '2008-09-07', '0'), ('6136', '202.160.180.115', '', '', '1', '2008-09-07', '0'), ('6137', '220.199.246.66', '', '', '1', '2008-09-07', '0'), ('6138', '123.55.63.229', '', '', '1', '2008-09-07', '0'), ('6139', '195.47.255.3', '', '', '2', '2008-09-07', '0'), ('6140', '60.190.218.174', '', '', '2', '2008-09-07', '0'), ('6141', '59.42.194.138', '', '', '2', '2008-09-07', '0'), ('6142', '202.160.180.6', '', '', '1', '2008-09-07', '0'), ('6143', '61.135.168.20', '', '', '1', '2008-09-07', '0'), ('6144', '219.238.92.226', '', '', '1', '2008-09-07', '0'), ('6145', '60.212.138.224', '', '', '32', '2008-09-07', '0'), ('6146', '122.157.17.22', '', '', '2', '2008-09-07', '0'), ('6147', '211.138.227.172', '', '', '1', '2008-09-07', '0'), ('6148', '211.137.63.178', '', '', '2', '2008-09-07', '0'), ('6149', '203.142.123.110', '', '', '1', '2008-09-07', '0'), ('6150', '211.137.63.142', '', '', '17', '2008-09-07', '0'), ('6151', '210.72.78.7', '', '', '1', '2008-09-07', '0'), ('6152', '58.19.236.28', '', '', '4', '2008-09-07', '0'), ('6153', '221.201.52.116', '', '', '3', '2008-09-07', '0'), ('6154', '219.130.59.76', '', '', '1', '2008-09-07', '0'), ('6156', '116.198.134.18', '', '', '4', '2008-09-07', '0'), ('6157', '124.161.29.205', '', '', '1', '2008-09-07', '0'), ('6158', '218.205.238.102', '', '', '1', '2008-09-07', '0'), ('6159', '212.71.32.87', '', '', '1', '2008-09-07', '0'), ('6160', '61.145.9.137', '', '', '3', '2008-09-07', '0'), ('6161', '116.21.194.141', '', '', '1', '2008-09-07', '0'), ('6162', '61.142.246.150', '', '', '2', '2008-09-07', '0'), ('6163', '124.227.142.2', '', '', '1418', '2008-09-07', '0'), ('6164', '58.255.238.116', '', '', '1', '2008-09-07', '0'), ('6165', '221.232.76.174', '', '', '1', '2008-09-07', '0'), ('6166', '220.206.235.63', '', '', '1', '2008-09-07', '0'), ('6167', '123.123.215.138', '', '', '3', '2008-09-07', '0'), ('6168', '119.141.236.44', '', '', '1', '2008-09-07', '0'), ('6169', '121.12.248.224', '', '', '4', '2008-09-07', '0'), ('6170', '219.146.206.126', '', '', '14', '2008-09-07', '0'), ('6171', '218.19.54.28', '', '', '1', '2008-09-07', '0'), ('6172', '121.33.13.85', '', '', '9', '2008-09-07', '0'), ('6173', '116.29.106.223', '', '', '1', '2008-09-07', '0'), ('6174', '121.35.250.249', '', '', '1', '2008-09-07', '0'), ('6175', '119.141.60.154', '', '', '2', '2008-09-07', '0'), ('6176', '202.160.180.155', '', '', '1', '2008-09-07', '0'), ('6177', '58.54.125.30', '', '', '1', '2008-09-07', '0'), ('6178', '116.242.141.175', '', '', '3', '2008-09-07', '0'), ('6179', '218.19.22.177', '', '', '2', '2008-09-07', '0'), ('6180', '211.138.218.76', '', '', '1', '2008-09-07', '0'), ('6181', '222.217.18.52', '', '', '1', '2008-09-07', '0'), ('6182', '222.217.107.231', '', '', '1', '2008-09-07', '0'), ('6183', '222.180.159.5', '', '', '2', '2008-09-07', '0'), ('6184', '211.136.158.147', '', '', '2', '2008-09-07', '0'), ('6185', '60.3.133.13', '', '', '1', '2008-09-07', '0'), ('6186', '220.187.79.49', '', '', '1', '2008-09-07', '0'), ('6187', '222.208.224.101', '', '', '2', '2008-09-07', '0'), ('6188', '219.144.245.98', '', '', '5', '2008-09-07', '0'), ('6189', '61.183.32.149', '', '', '3', '2008-09-07', '0'), ('6190', '218.62.121.7', '', '', '1', '2008-09-07', '0'), ('6191', '123.118.127.247', '', '', '1', '2008-09-07', '0'), ('6192', '218.205.252.114', '', '', '1', '2008-09-07', '0'), ('6193', '222.213.121.199', '', '', '1', '2008-09-07', '0'), ('6194', '218.58.61.34', '', '', '1', '2008-09-07', '0'), ('6195', '211.136.75.233', '', '', '1', '2008-09-07', '0'), ('6196', '58.60.229.101', '', '', '1', '2008-09-07', '0'), ('6197', '121.27.14.7', '', '', '23', '2008-09-07', '0'), ('6198', '119.128.206.211', '', '', '1', '2008-09-07', '0'), ('6199', '61.135.220.64', '', '', '1', '2008-09-07', '0'), ('6200', '220.161.194.98', '', '', '4', '2008-09-07', '0'), ('6201', '116.21.171.12', '', '', '28', '2008-09-07', '0'), ('6202', '218.200.224.124', '', '', '1', '2008-09-07', '0'), ('6203', '219.134.160.133', '', '', '1', '2008-09-07', '0'), ('6204', '220.181.32.83', '', '', '1', '2008-09-07', '0'), ('6205', '211.138.227.2', '', '', '3', '2008-09-07', '0'), ('6206', '221.5.187.158', '', '', '2', '2008-09-07', '0'), ('6207', '58.83.127.202', '', '', '1', '2008-09-07', '0'), ('6208', '122.6.192.175', '', '', '2', '2008-09-07', '0'), ('6209', '74.6.18.218', '', '', '21', '2008-09-07', '0'), ('6210', '121.34.113.202', '', '', '2', '2008-09-07', '0'), ('6211', '202.160.179.46', '', '', '1', '2008-09-07', '0'), ('6212', '211.137.197.55', '', '', '6', '2008-09-07', '0'), ('6213', '222.42.68.51', '', '', '1', '2008-09-07', '0'), ('6214', '60.8.51.6', '', '', '2', '2008-09-07', '0'), ('6215', '117.42.131.200', '', '', '1', '2008-09-07', '0'), ('6216', '211.136.158.130', '', '', '3', '2008-09-07', '0'), ('6217', '122.4.138.145', '', '', '1', '2008-09-07', '0'), ('6218', '116.21.160.165', '', '', '1', '2008-09-07', '0'), ('6219', '123.113.141.64', '', '', '2', '2008-09-07', '0'), ('6220', '116.22.211.92', '', '', '2', '2008-09-07', '0'), ('6221', '211.137.63.115', '', '', '17', '2008-09-07', '0'), ('6222', '58.217.211.228', '', '', '2', '2008-09-07', '0'), ('6223', '58.59.245.93', '', '', '44', '2008-09-07', '0'), ('6224', '121.15.144.109', '', '', '1', '2008-09-07', '0'), ('6225', '219.129.205.169', '', '', '1', '2008-09-07', '0'), ('6226', '121.32.86.215', '', '', '2', '2008-09-07', '0'), ('6227', '220.255.7.201', '', '', '1', '2008-09-07', '0'), ('6228', '60.50.67.182', '', '', '1', '2008-09-07', '0'), ('6229', '125.110.201.180', '', '', '1', '2008-09-07', '0'), ('6230', '211.136.158.155', '', '', '21', '2008-09-07', '0'), ('6231', '221.14.151.77', '', '', '2', '2008-09-07', '0'), ('6232', '222.214.44.75', '', '', '5', '2008-09-07', '0'), ('6233', '124.227.143.45', '', '', '426', '2008-09-07', '0'), ('6234', '219.134.8.47', '', '', '4', '2008-09-07', '0'), ('6235', '124.227.226.29', '', '', '7', '2008-09-07', '0'), ('6236', '124.227.240.55', '', '', '349', '2008-09-07', '0'), ('6237', '116.27.22.5', '', '', '1', '2008-09-07', '0'), ('6238', '124.132.34.31', '', '', '1', '2008-09-07', '0'), ('6239', '121.228.162.106', '', '', '1', '2008-09-07', '0'), ('6240', '116.4.29.30', '', '', '4', '2008-09-07', '0'), ('6241', '202.160.179.31', '', '', '2', '2008-09-07', '0'), ('6242', '58.59.243.136', '', '', '637', '2008-09-07', '0'), ('6243', '202.160.178.33', '', '', '2', '2008-09-07', '0'), ('6244', '58.30.69.80', '', '', '1', '2008-09-07', '0'), ('6245', '117.82.18.67', '', '', '2', '2008-09-07', '0'), ('6246', '116.224.176.184', '', '', '1', '2008-09-07', '0'), ('6247', '116.17.25.183', '', '', '1', '2008-09-07', '0'), ('6248', '116.4.29.222', '', '', '1', '2008-09-07', '0'), ('6249', '125.113.176.56', '', '', '1', '2008-09-07', '0'), ('6250', '58.60.180.196', '', '', '2', '2008-09-07', '0'), ('6251', '121.70.229.222', '', '', '1', '2008-09-07', '0'), ('6252', '124.238.29.188', '', '', '1', '2008-09-07', '0'), ('6253', '124.92.134.24', '', '', '1', '2008-09-07', '0'), ('6254', '222.216.109.73', '', '', '2', '2008-09-07', '0'), ('6255', '219.131.49.16', '', '', '1', '2008-09-07', '0'), ('6256', '222.84.41.42', '', '', '1806', '2008-09-07', '0'), ('6257', '118.147.83.51', '', '', '1', '2008-09-07', '0'), ('6258', '218.79.74.202', '', '', '2', '2008-09-07', '0'), ('6259', '121.15.232.130', '', '', '6', '2008-09-07', '0'), ('6260', '211.138.227.234', '', '', '2', '2008-09-07', '0'), ('6261', '121.9.114.189', '', '', '3', '2008-09-07', '0'), ('6262', '59.41.190.82', '', '', '1', '2008-09-07', '0'), ('6263', '222.130.37.81', '', '', '2', '2008-09-07', '0'), ('6264', '218.21.37.162', '', '', '2', '2008-09-07', '0'), ('6265', '119.128.169.14', '', '', '1', '2008-09-07', '0'), ('6266', '59.34.233.75', '', '', '1', '2008-09-07', '0'), ('6267', '118.192.3.12', '', '', '2', '2008-09-07', '0'), ('6268', '125.107.154.158', '', '', '1', '2008-09-07', '0'), ('6269', '123.52.73.49', '', '', '2', '2008-09-07', '0'), ('6270', '58.59.244.84', '', '', '4182', '2008-09-07', '0'), ('6271', '218.13.97.74', '', '', '1', '2008-09-07', '0'), ('6272', '211.136.158.176', '', '', '10', '2008-09-07', '0'), ('6273', '222.77.112.208', '', '', '2', '2008-09-07', '0'), ('6274', '59.32.56.143', '', '', '1', '2008-09-07', '0'), ('6275', '121.229.169.59', '', '', '1', '2008-09-07', '0'), ('6276', '220.186.108.80', '', '', '1', '2008-09-07', '0'), ('6277', '211.145.114.145', '', '', '2', '2008-09-07', '0'), ('6278', '58.60.54.134', '', '', '4', '2008-09-08', '0'), ('6279', '219.135.8.22', '', '', '1', '2008-09-08', '0'), ('6280', '202.160.179.38', '', '', '1', '2008-09-08', '0'), ('6281', '201.195.82.148', '', '', '1', '2008-09-08', '0'), ('6282', '125.93.30.158', '', '', '1', '2008-09-08', '0'), ('6283', '195.189.143.58', '', '', '2', '2008-09-08', '0'), ('6284', '117.84.144.39', '', '', '4', '2008-09-08', '0'), ('6285', '58.62.192.238', '', '', '2', '2008-09-08', '0'), ('6286', '211.136.158.163', '', '', '3', '2008-09-08', '0'), ('6287', '60.168.47.45', '', '', '22', '2008-09-08', '0'), ('6288', '220.161.4.14', '', '', '1', '2008-09-08', '0'), ('6289', '60.2.249.154', '', '', '4', '2008-09-08', '0'), ('6290', '116.225.39.27', '', '', '2', '2008-09-08', '0'), ('6291', '202.160.178.242', '', '', '1', '2008-09-08', '0'), ('6292', '58.253.56.205', '', '', '1', '2008-09-08', '0'), ('6293', '58.59.243.223', '', '', '6863', '2008-09-08', '0'), ('6294', '211.138.63.66', '', '', '1', '2008-09-08', '0'), ('6295', '123.8.211.140', '', '', '2', '2008-09-08', '0'), ('6296', '211.137.62.200', '', '', '2', '2008-09-08', '0'), ('6297', '61.149.170.31', '', '', '1', '2008-09-08', '0'), ('6298', '211.136.75.93', '', '', '2', '2008-09-08', '0'), ('6299', '60.215.99.237', '', '', '1', '2008-09-08', '0'), ('6300', '202.160.179.62', '', '', '1', '2008-09-08', '0'), ('6301', '211.136.75.7', '', '', '2', '2008-09-08', '0'), ('6302', '80.250.148.225', '', '', '27', '2008-09-08', '0'), ('6303', '116.17.25.176', '', '', '8', '2008-09-08', '0'), ('6304', '211.138.218.104', '', '', '1', '2008-09-08', '0'), ('6305', '196.30.118.77', '', '', '1', '2008-09-08', '0'), ('6306', '211.137.63.138', '', '', '2', '2008-09-08', '0'), ('6307', '59.175.24.178', '', '', '1', '2008-09-08', '0'), ('6308', '121.35.33.88', '', '', '1', '2008-09-08', '0'), ('6309', '211.138.63.65', '', '', '1', '2008-09-08', '0'), ('6310', '59.36.144.204', '', '', '2', '2008-09-08', '0'), ('6311', '220.181.32.64', '', '', '1', '2008-09-08', '0'), ('6312', '61.242.254.168', '', '', '2', '2008-09-08', '0'), ('6313', '220.161.80.71', '', '', '1', '2008-09-08', '0'), ('6314', '218.19.65.210', '', '', '12', '2008-09-08', '0'), ('6315', '218.15.65.72', '', '', '1', '2008-09-08', '0'), ('6316', '124.193.203.254', '', '', '10', '2008-09-08', '0'), ('6317', '116.198.135.29', '', '', '2', '2008-09-08', '0'), ('6318', '58.59.240.49', '', '', '1492', '2008-09-08', '0'), ('6319', '211.138.227.100', '', '', '1', '2008-09-08', '0'), ('6320', '60.10.14.204', '', '', '2', '2008-09-08', '0'), ('6321', '124.227.142.108', '', '', '410', '2008-09-08', '0'), ('6322', '219.156.163.202', '', '', '1', '2008-09-08', '0'), ('6323', '59.47.243.38', '', '', '1', '2008-09-08', '0'), ('6324', '210.241.199.200', '', '', '9', '2008-09-08', '0'), ('6325', '58.60.193.54', '', '', '1', '2008-09-08', '0'), ('6326', '218.205.252.85', '', '', '1', '2008-09-08', '0'), ('6327', '121.20.90.97', '', '', '3', '2008-09-08', '0'), ('6328', '121.35.100.107', '', '', '10', '2008-09-08', '0'), ('6329', '222.218.148.133', '', '', '1', '2008-09-08', '0'), ('6330', '221.218.146.117', '', '', '1', '2008-09-08', '0'), ('6331', '219.134.85.189', '', '', '1', '2008-09-08', '0'), ('6332', '218.205.249.126', '', '', '2', '2008-09-08', '0'), ('6333', '211.137.197.59', '', '', '1', '2008-09-08', '0'), ('6334', '121.32.28.58', '', '', '1', '2008-09-08', '0'), ('6335', '210.72.236.69', '', '', '1', '2008-09-08', '0'), ('6336', '116.22.147.118', '', '', '4', '2008-09-08', '0'), ('6337', '211.143.101.60', '', '', '6', '2008-09-08', '0'), ('6338', '219.153.182.198', '', '', '1', '2008-09-08', '0'), ('6339', '211.138.218.27', '', '', '3', '2008-09-08', '0'), ('6340', '218.241.227.86', '', '', '1', '2008-09-08', '0'), ('6341', '222.213.216.26', '', '', '1', '2008-09-08', '0'), ('6342', '121.62.107.60', '', '', '8', '2008-09-08', '0'), ('6343', '124.226.3.250', '', '', '10', '2008-09-08', '0'), ('6344', '116.30.84.30', '', '', '3', '2008-09-08', '0'), ('6345', '59.32.106.105', '', '', '1', '2008-09-08', '0'), ('6346', '219.143.153.112', '', '', '2', '2008-09-08', '0'), ('6347', '220.206.245.4', '', '', '1', '2008-09-08', '0'), ('6348', '219.132.114.100', '', '', '1', '2008-09-08', '0'), ('6349', '116.21.59.123', '', '', '5', '2008-09-08', '0'), ('6350', '219.132.28.97', '', '', '1', '2008-09-08', '0'), ('6351', '116.25.125.202', '', '', '9', '2008-09-08', '0'), ('6352', '222.64.39.146', '', '', '1', '2008-09-08', '0'), ('6353', '211.139.192.54', '', '', '1', '2008-09-08', '0'), ('6354', '218.205.252.43', '', '', '1', '2008-09-08', '0'), ('6355', '116.18.117.67', '', '', '2', '2008-09-08', '0'), ('6356', '124.64.66.219', '', '', '1', '2008-09-08', '0'), ('6357', '58.252.226.200', '', '', '1', '2008-09-08', '0'), ('6358', '203.82.67.221', '', '', '17', '2008-09-08', '0'), ('6359', '219.136.182.6', '', '', '6', '2008-09-08', '0'), ('6360', '116.30.3.218', '', '', '1', '2008-09-08', '0'), ('6361', '116.17.166.22', '', '', '1', '2008-09-08', '0'), ('6362', '211.136.75.53', '', '', '1', '2008-09-08', '0'), ('6363', '211.136.73.106', '', '', '5', '2008-09-08', '0'), ('6364', '116.17.20.207', '', '', '3', '2008-09-08', '0'), ('6365', '123.54.9.119', '', '', '1', '2008-09-08', '0'), ('6366', '220.248.150.67', '', '', '1', '2008-09-08', '0'), ('6367', '125.92.104.162', '', '', '12', '2008-09-08', '0'), ('6368', '117.93.164.125', '', '', '1', '2008-09-08', '0'), ('6369', '220.207.233.56', '', '', '1', '2008-09-08', '0'), ('6370', '203.142.109.129', '', '', '1', '2008-09-08', '0'), ('6371', '211.137.63.154', '', '', '1', '2008-09-08', '0'), ('6372', '220.206.235.95', '', '', '1', '2008-09-08', '0'), ('6373', '222.217.107.190', '', '', '1', '2008-09-08', '0'), ('6374', '218.240.186.31', '', '', '1', '2008-09-08', '0'), ('6375', '211.136.75.246', '', '', '1', '2008-09-08', '0'), ('6376', '119.39.68.125', '', '', '1', '2008-09-08', '0'), ('6377', '125.95.254.208', '', '', '1', '2008-09-08', '0'), ('6378', '219.130.165.218', '', '', '1', '2008-09-08', '0'), ('6379', '119.163.114.18', '', '', '1', '2008-09-08', '0'), ('6380', '218.205.252.185', '', '', '1', '2008-09-08', '0'), ('6381', '211.136.158.225', '', '', '4', '2008-09-09', '0'), ('6382', '222.140.134.76', '', '', '1', '2008-09-09', '0'), ('6383', '125.120.100.76', '', '', '3', '2008-09-09', '0'), ('6384', '211.138.218.42', '', '', '1', '2008-09-09', '0'), ('6385', '218.16.106.105', '', '', '1', '2008-09-09', '0'), ('6386', '121.32.65.90', '', '', '2', '2008-09-09', '0'), ('6387', '41.208.50.160', '', '', '1', '2008-09-09', '0'), ('6388', '58.241.6.155', '', '', '1', '2008-09-09', '0'), ('6389', '218.13.22.22', '', '', '1', '2008-09-09', '0'), ('6390', '222.180.75.150', '', '', '7', '2008-09-09', '0'), ('6391', '218.213.241.136', '', '', '9', '2008-09-09', '0'), ('6392', '218.213.241.139', '', '', '4', '2008-09-09', '0'), ('6393', '218.213.241.138', '', '', '2', '2008-09-09', '0'), ('6394', '123.61.160.59', '', '', '2', '2008-09-09', '0'), ('6395', '72.14.199.38', '', '', '1', '2008-09-09', '0'), ('6396', '218.19.5.57', '', '', '7', '2008-09-09', '0'), ('6397', '218.205.249.97', '', '', '1', '2008-09-09', '0'), ('6398', '219.139.54.156', '', '', '1', '2008-09-09', '0'), ('6399', '195.189.142.179', '', '', '1', '2008-09-09', '0'), ('6400', '218.85.2.10', '', '', '1', '2008-09-09', '0'), ('6401', '125.78.207.214', '', '', '1', '2008-09-09', '0'), ('6402', '219.130.248.83', '', '', '1', '2008-09-09', '0'), ('6403', '211.136.75.217', '', '', '1', '2008-09-09', '0'), ('6404', '222.125.133.234', '', '', '1', '2008-09-09', '0'), ('6405', '208.68.138.5', '', '', '187', '2008-09-09', '0'), ('6406', '116.21.43.170', '', '', '1', '2008-09-09', '0'), ('6407', '219.136.172.56', '', '', '1', '2008-09-09', '0'), ('6408', '211.138.227.103', '', '', '1', '2008-09-09', '0'), ('6409', '116.29.153.153', '', '', '1', '2008-09-09', '0'), ('6410', '218.205.238.104', '', '', '8', '2008-09-09', '0'), ('6411', '221.222.137.13', '', '', '1', '2008-09-09', '0'), ('6412', '218.205.249.67', '', '', '1', '2008-09-09', '0'), ('6413', '85.26.178.202', '', '', '1', '2008-09-09', '0'), ('6414', '211.136.75.139', '', '', '4', '2008-09-09', '0'), ('6415', '116.26.241.33', '', '', '1', '2008-09-09', '0'), ('6416', '220.197.25.162', '', '', '2', '2008-09-09', '0'), ('6417', '218.0.126.233', '', '', '2', '2008-09-09', '0'), ('6418', '124.228.94.15', '', '', '1', '2008-09-09', '0'), ('6419', '221.206.55.250', '', '', '1', '2008-09-09', '0'), ('6420', '195.189.142.59', '', '', '1', '2008-09-09', '0'), ('6421', '123.116.210.34', '', '', '1', '2008-09-09', '0'), ('6422', '119.127.141.241', '', '', '1', '2008-09-09', '0'), ('6423', '122.7.29.234', '', '', '1', '2008-09-09', '0'), ('6424', '59.39.142.220', '', '', '2', '2008-09-09', '0'), ('6425', '202.93.153.84', '', '', '1', '2008-09-09', '0'), ('6426', '125.67.185.100', '', '', '1', '2008-09-09', '0'), ('6427', '211.143.149.237', '', '', '1', '2008-09-09', '0'), ('6428', '125.116.44.66', '', '', '1', '2008-09-09', '0'), ('6429', '220.186.110.169', '', '', '1', '2008-09-09', '0'), ('6430', '124.64.243.232', '', '', '2', '2008-09-09', '0'), ('6431', '211.94.82.109', '', '', '1', '2008-09-09', '0'), ('6432', '202.160.178.218', '', '', '1', '2008-09-09', '0'), ('6433', '121.32.147.248', '', '', '1', '2008-09-09', '0'), ('6434', '121.34.226.17', '', '', '1', '2008-09-09', '0'), ('6435', '222.67.146.217', '', '', '1', '2008-09-09', '0'), ('6436', '121.12.227.70', '', '', '1', '2008-09-10', '0'), ('6437', '125.91.201.1', '', '', '1', '2008-09-10', '0'), ('6438', '60.50.219.167', '', '', '1', '2008-09-10', '0'), ('6439', '220.162.31.45', '', '', '1', '2008-09-10', '0'), ('6440', '211.95.207.93', '', '', '22', '2008-09-10', '0'), ('6441', '123.136.5.5', '', '', '1', '2008-09-10', '0'), ('6442', '118.205.1.140', '', '', '1', '2008-09-10', '0'), ('6443', '220.206.235.43', '', '', '2', '2008-09-10', '0'), ('6445', '222.213.247.178', '', '', '1', '2008-09-10', '0'), ('6446', '123.103.43.234', '', '', '1', '2008-09-10', '0'), ('6447', '125.91.4.170', '', '移动', '0', '2008-10-15', '1'), ('6448', '211.136.158.246', '', '', '1', '2008-09-10', '0'), ('6449', '218.72.84.106', '', '', '1', '2008-09-10', '0'), ('6450', '121.13.134.99', '', '', '1', '2008-09-10', '0'), ('6451', '211.136.75.252', '', '', '2', '2008-09-10', '0'), ('6452', '211.138.152.122', '', '', '1', '2008-09-10', '0'), ('6453', '119.120.1.186', '', '', '1', '2008-09-10', '0'), ('6454', '125.65.14.240', '', '', '2', '2008-09-10', '0'), ('6455', '219.131.73.123', '', '', '1', '2008-09-10', '0'), ('6456', '61.143.183.67', '', '', '3', '2008-09-10', '0'), ('6457', '91.203.96.13', '', '', '2', '2008-09-10', '0'), ('6458', '211.138.227.3', '', '', '1', '2008-09-10', '0'), ('6459', '58.248.112.253', '', '', '1', '2008-09-10', '0'), ('6460', '211.137.197.50', '', '', '4', '2008-09-10', '0'), ('6461', '116.18.4.28', '', '', '1', '2008-09-10', '0'), ('6462', '119.123.151.227', '', '', '1', '2008-09-10', '0'), ('6463', '123.64.16.217', '', '', '1', '2008-09-10', '0'), ('6464', '202.105.79.126', '', '', '2', '2008-09-10', '0'), ('6465', '123.191.109.85', '', '', '3', '2008-09-10', '0'), ('6466', '125.92.204.254', '', '', '1', '2008-09-10', '0'), ('6467', '60.211.0.17', '', '', '1', '2008-09-10', '0'), ('6468', '219.129.250.246', '', '', '3', '2008-09-10', '0'), ('6469', '125.91.103.3', '', '', '1', '2008-09-10', '0'), ('6470', '121.33.81.108', '', '', '1', '2008-09-10', '0'), ('6471', '219.78.219.40', '', '', '1', '2008-09-10', '0'), ('6472', '60.52.45.117', '', '', '2', '2008-09-10', '0'), ('6473', '61.153.182.206', '', '', '1', '2008-09-10', '0'), ('6474', '61.141.137.151', '', '', '1', '2008-09-10', '0'), ('6475', '60.176.202.132', '', '', '1', '2008-09-10', '0'), ('6476', '213.98.206.209', '', '', '1', '2008-09-10', '0'), ('6477', '58.253.106.75', '', '', '1', '2008-09-10', '0'), ('6478', '123.147.1.209', '', '', '2', '2008-09-10', '0'), ('6479', '59.33.139.22', '', '', '1', '2008-09-10', '0'), ('6480', '58.60.228.34', '', '', '1', '2008-09-10', '0'), ('6481', '211.136.158.149', '', '', '5', '2008-09-10', '0'), ('6482', '220.243.109.44', '', '', '1', '2008-09-10', '0'), ('6483', '218.15.230.99', '', '', '1', '2008-09-10', '0'), ('6484', '59.38.105.227', '', '', '3', '2008-09-10', '0'), ('6485', '218.18.106.181', '', '', '1', '2008-09-10', '0'), ('6486', '221.130.191.160', '', '', '11', '2008-09-10', '0'), ('6487', '219.130.8.7', '', '', '1', '2008-09-10', '0'), ('6488', '211.138.227.206', '', '', '1', '2008-09-10', '0'), ('6489', '61.171.222.103', '', '', '1', '2008-09-10', '0'), ('6490', '116.128.30.76', '', '', '1', '2008-09-10', '0'), ('6491', '222.76.74.244', '', '', '1', '2008-09-10', '0'), ('6492', '211.138.152.121', '', '', '2', '2008-09-10', '0'), ('6493', '211.136.158.207', '', '', '3', '2008-09-10', '0'), ('6494', '121.32.158.37', '', '', '1', '2008-09-11', '0'), ('6495', '59.33.41.181', '', '', '1', '2008-09-11', '0'), ('6496', '221.206.46.60', '', '', '1', '2008-09-11', '0'), ('6497', '195.189.142.226', '', '', '1', '2008-09-11', '0'), ('6498', '114.138.235.43', '', '', '11', '2008-09-11', '0'), ('6499', '219.130.181.249', '', '', '27', '2008-09-11', '0'), ('6500', '195.189.142.138', '', '', '2', '2008-09-11', '0'), ('6501', '61.144.209.101', '', '', '2', '2008-09-11', '0'), ('6502', '203.177.91.133', '', '', '2', '2008-09-11', '0'), ('6503', '218.0.123.212', '', '', '2', '2008-09-11', '0'), ('6504', '218.200.224.25', '', '', '2', '2008-09-11', '0'), ('6505', '220.115.131.7', '', '', '2', '2008-09-11', '0'), ('6506', '219.136.174.35', '', '', '2', '2008-09-11', '0'), ('6507', '195.210.70.13', '', '', '1', '2008-09-11', '0'), ('6508', '118.231.136.222', '', '', '1', '2008-09-11', '0'), ('6509', '116.30.112.148', '', '', '1', '2008-09-11', '0'), ('6510', '121.8.142.9', '', '', '1', '2008-09-11', '0'), ('6511', '211.139.162.199', '', '', '11', '2008-09-11', '0'), ('6512', '59.40.182.189', '', '', '18', '2008-09-11', '0'), ('6513', '190.141.243.164', '', '', '1', '2008-09-11', '0'), ('6514', '61.145.179.14', '', '', '1', '2008-09-11', '0'), ('6515', '116.29.43.151', '', '', '1', '2008-09-11', '0'), ('6516', '218.66.82.69', '', '', '2', '2008-09-11', '0'), ('6517', '222.138.68.135', '', '', '1', '2008-09-11', '0'), ('6518', '124.112.0.99', '', '', '3', '2008-09-11', '0'), ('6519', '59.35.155.111', '', '', '1', '2008-09-11', '0'), ('6520', '219.135.12.3', '', '', '1', '2008-09-11', '0'), ('6521', '202.105.78.81', '', '', '3', '2008-09-11', '0'), ('6522', '59.32.7.245', '', '', '1', '2008-09-11', '0'), ('6523', '219.137.116.38', '', '', '1', '2008-09-11', '0'), ('6524', '121.9.124.78', '', '', '1', '2008-09-11', '0'), ('6525', '67.228.127.90', '', '', '1', '2008-09-11', '0'), ('6526', '125.112.72.88', '', '', '2', '2008-09-11', '0'), ('6527', '211.136.75.116', '', '', '1', '2008-09-11', '0'), ('6528', '219.137.137.72', '', '', '12', '2008-09-11', '0'), ('6529', '125.66.130.177', '', '', '1', '2008-09-11', '0'), ('6530', '116.17.167.120', '', '', '1', '2008-09-11', '0'), ('6531', '58.251.83.149', '', '', '2', '2008-09-11', '0'), ('6532', '211.137.41.8', '', '', '2', '2008-09-11', '0'), ('6533', '123.132.43.153', '', '', '1', '2008-09-11', '0'), ('6534', '123.175.189.141', '', '', '51', '2008-09-11', '0'), ('6535', '91.203.96.29', '', '', '2', '2008-09-11', '0'), ('6536', '221.0.54.202', '', '', '1', '2008-09-11', '0'), ('6537', '60.174.105.199', '', '', '1', '2008-09-11', '0'), ('6538', '116.18.21.158', '', '', '1', '2008-09-11', '0'), ('6539', '124.92.135.48', '', '', '6', '2008-09-11', '0'), ('6540', '59.36.114.119', '', '', '1', '2008-09-11', '0'), ('6541', '218.205.252.126', '', '', '2', '2008-09-11', '0'), ('6542', '59.57.169.254', '', '', '1', '2008-09-11', '0'), ('6543', '219.133.83.160', '', '', '1', '2008-09-11', '0'), ('6544', '210.72.234.35', '', '', '1', '2008-09-11', '0'), ('6545', '121.0.29.226', '', '', '1', '2008-09-11', '0'), ('6546', '125.91.4.158', '', '移动', '0', '2008-10-15', '1'), ('6547', '220.243.108.200', '', '', '1', '2008-09-11', '0'), ('6548', '211.137.62.215', '', '', '2', '2008-09-11', '0'), ('6549', '59.35.95.54', '', '', '1', '2008-09-11', '0'), ('6550', '116.21.182.143', '', '', '1', '2008-09-11', '0'), ('6551', '123.15.230.57', '', '', '1', '2008-09-11', '0'), ('6552', '125.93.76.146', '', '', '1', '2008-09-11', '0'), ('6553', '58.253.56.184', '', '', '5', '2008-09-11', '0'), ('6554', '222.175.106.178', '', '', '1', '2008-09-11', '0'), ('6555', '222.212.36.101', '', '', '1', '2008-09-11', '0'), ('6556', '218.19.95.132', '', '', '3', '2008-09-11', '0'), ('6557', '122.230.97.234', '', '', '1', '2008-09-11', '0'), ('6558', '218.58.179.36', '', '', '1', '2008-09-11', '0'), ('6559', '58.248.226.74', '', '', '1', '2008-09-11', '0'), ('6560', '58.47.44.175', '', '', '1', '2008-09-11', '0'), ('6561', '219.129.227.18', '', '', '2', '2008-09-11', '0'), ('6562', '125.93.74.26', '', '', '1', '2008-09-11', '0'), ('6563', '121.227.253.143', '', '', '1', '2008-09-11', '0'), ('6564', '220.166.159.72', '', '', '2', '2008-09-11', '0'), ('6565', '125.77.59.132', '', '', '1', '2008-09-11', '0'), ('6566', '121.33.109.136', '', '', '1', '2008-09-11', '0'), ('6567', '206.49.165.220', '', '', '5', '2008-09-11', '0'), ('6568', '221.131.60.192', '', '', '1', '2008-09-11', '0'), ('6569', '116.21.241.61', '', '', '2', '2008-09-11', '0'), ('6570', '124.112.2.104', '', '', '1', '2008-09-11', '0'), ('6571', '219.152.128.130', '', '', '1', '2008-09-11', '0'), ('6572', '125.33.61.15', '', '', '1', '2008-09-11', '0'), ('6573', '58.252.45.99', '', '', '1', '2008-09-11', '0'), ('6574', '220.206.246.55', '', '', '3', '2008-09-11', '0'), ('6575', '220.206.235.28', '', '', '1', '2008-09-12', '0'), ('6576', '211.136.75.102', '', '', '2', '2008-09-12', '0'), ('6577', '211.137.63.71', '', '', '1', '2008-09-12', '0'), ('6578', '211.136.158.210', '', '', '2', '2008-09-12', '0'), ('6579', '220.255.7.168', '', '', '1', '2008-09-12', '0'), ('6580', '195.189.142.57', '', '', '1', '2008-09-12', '0'), ('6581', '220.243.105.50', '', '', '6', '2008-09-12', '0'), ('6582', '219.128.67.42', '', '', '1', '2008-09-12', '0'), ('6583', '211.137.197.48', '', '', '3', '2008-09-12', '0'), ('6584', '211.138.152.124', '', '', '5', '2008-09-12', '0'), ('6585', '58.60.218.165', '', '', '1', '2008-09-12', '0'), ('6586', '59.33.203.55', '', '', '2', '2008-09-12', '0'), ('6587', '74.6.18.236', '', '', '1', '2008-09-12', '0'), ('6588', '220.206.246.53', '', '', '1', '2008-09-12', '0'), ('6589', '211.136.158.204', '', '', '1', '2008-09-12', '0'), ('6590', '125.93.150.169', '', '', '2', '2008-09-12', '0'), ('6591', '121.1.18.225', '', '', '1', '2008-09-12', '0'), ('6592', '59.34.64.250', '', '', '11', '2008-09-12', '0'), ('6593', '211.137.62.198', '', '', '2', '2008-09-12', '0'), ('6594', '118.192.3.50', '', '', '2', '2008-09-12', '0'), ('6595', '218.20.54.159', '', '', '1', '2008-09-12', '0'), ('6596', '219.129.49.8', '', '', '1', '2008-09-12', '0'), ('6597', '220.206.246.31', '', '', '2', '2008-09-12', '0'), ('6598', '220.206.246.36', '', '', '2', '2008-09-12', '0'), ('6599', '222.132.163.136', '', '', '1', '2008-09-12', '0'), ('6600', '116.27.29.250', '', '', '1', '2008-09-12', '0'), ('6601', '116.26.252.153', '', '', '1', '2008-09-12', '0'), ('6602', '60.166.213.86', '', '', '1', '2008-09-12', '0'), ('6603', '121.204.194.243', '', '', '1', '2008-09-12', '0'), ('6604', '202.149.25.235', '', '', '3', '2008-09-12', '0'), ('6605', '125.33.167.140', '', '', '1', '2008-09-12', '0'), ('6606', '60.205.119.28', '', '', '1', '2008-09-12', '0'), ('6607', '219.93.152.21', '', '', '2', '2008-09-12', '0'), ('6608', '211.137.37.137', '', '', '3', '2008-09-12', '0'), ('6609', '60.164.217.208', '', '', '1', '2008-09-12', '0'), ('6610', '58.71.207.96', '', '', '1', '2008-09-12', '0'), ('6611', '218.28.119.240', '', '', '12', '2008-09-12', '0'), ('6612', '116.25.121.58', '', '', '1', '2008-09-12', '0'), ('6613', '218.205.238.110', '', '', '1', '2008-09-12', '0'), ('6614', '61.161.108.137', '', '', '1', '2008-09-12', '0'), ('6615', '219.133.28.53', '', '', '1', '2008-09-12', '0'), ('6616', '116.21.48.214', '', '', '9', '2008-09-12', '0'), ('6617', '202.152.84.3', '', '', '5', '2008-09-12', '0'), ('6618', '118.192.9.121', '', '', '18', '2008-09-12', '0'), ('6619', '122.102.68.7', '', '', '1', '2008-09-12', '0'), ('6620', '123.4.46.251', '', '', '1', '2008-09-12', '0'), ('6621', '222.138.208.131', '', '', '1', '2008-09-12', '0'), ('6622', '124.93.243.152', '', '', '1', '2008-09-12', '0'), ('6623', '222.189.117.142', '', '', '1', '2008-09-12', '0'), ('6624', '202.105.18.66', '', '', '1', '2008-09-12', '0'), ('6625', '116.16.120.133', '', '', '23', '2008-09-12', '0'), ('6626', '119.141.138.38', '', '', '6', '2008-09-12', '0'), ('6627', '116.23.128.239', '', '', '1', '2008-09-12', '0'), ('6628', '220.206.246.30', '', '', '2', '2008-09-12', '0'), ('6629', '221.130.199.111', '', '', '1', '2008-09-12', '0'), ('6630', '118.192.37.250', '', '', '1', '2008-09-12', '0'), ('6631', '59.41.172.113', '', '', '1', '2008-09-12', '0'), ('6632', '121.13.89.147', '', '', '25', '2008-09-12', '0'), ('6633', '121.33.221.18', '', '', '2', '2008-09-12', '0'), ('6634', '211.139.16.179', '', '', '3', '2008-09-12', '0'), ('6635', '125.126.114.85', '', '', '1', '2008-09-12', '0'), ('6636', '125.66.183.40', '', '', '2', '2008-09-12', '0'), ('6637', '220.206.216.17', '', '', '12', '2008-09-12', '0'), ('6638', '123.115.246.89', '', '', '1', '2008-09-12', '0'), ('6639', '58.62.77.239', '', '', '1', '2008-09-12', '0'), ('6640', '124.244.200.247', '', '', '1', '2008-09-12', '0'), ('6641', '125.91.253.153', '', '移动', '0', '2008-10-15', '1'), ('6642', '119.124.54.195', '', '', '1', '2008-09-12', '0'), ('6643', '58.248.224.237', '', '', '4', '2008-09-12', '0'), ('6644', '116.4.29.117', '', '', '1', '2008-09-12', '0'), ('6645', '222.65.35.87', '', '', '1', '2008-09-12', '0'), ('6646', '116.27.10.145', '', '', '1', '2008-09-13', '0'), ('6647', '202.160.178.179', '', '', '1', '2008-09-13', '0'), ('6648', '218.13.168.59', '', '', '12', '2008-09-13', '0'), ('6649', '124.92.134.151', '', '', '2', '2008-09-13', '0'), ('6650', '121.37.44.11', '', '', '2', '2008-09-13', '0'), ('6651', '59.107.8.80', '', '', '2', '2008-09-13', '0'), ('6652', '116.10.162.62', '', '', '1', '2008-09-13', '0'), ('6653', '121.32.156.105', '', '', '1', '2008-09-13', '0'), ('6654', '121.20.233.216', '', '', '4', '2008-09-13', '0'), ('6655', '116.4.21.146', '', '', '1', '2008-09-13', '0'), ('6656', '222.72.61.62', '', '', '2', '2008-09-13', '0'), ('6657', '221.238.219.94', '', '', '3', '2008-09-13', '0'), ('6658', '213.137.132.134', '', '', '1', '2008-09-13', '0'), ('6659', '219.133.224.244', '', '', '1', '2008-09-13', '0'), ('6660', '125.127.121.245', '', '', '1', '2008-09-13', '0'), ('6661', '116.242.141.202', '', '', '1', '2008-09-13', '0'), ('6662', '72.28.255.138', '', '', '1', '2008-09-13', '0'), ('6663', '125.115.89.175', '', '', '1', '2008-09-13', '0'), ('6664', '121.33.189.51', '', '', '1', '2008-09-13', '0'), ('6665', '203.208.61.228', '', '', '1', '2008-09-13', '0'), ('6666', '58.221.241.219', '', '', '1', '2008-09-13', '0'), ('6667', '202.105.109.44', '', '', '2', '2008-09-13', '0'), ('6668', '118.231.4.25', '', '', '1', '2008-09-13', '0'), ('6669', '218.14.53.77', '', '', '1', '2008-09-13', '0'), ('6670', '116.17.94.104', '', '', '1', '2008-09-13', '0'), ('6671', '211.136.158.213', '', '', '1', '2008-09-13', '0'), ('6672', '125.116.45.54', '', '', '4', '2008-09-13', '0'), ('6673', '218.15.56.53', '', '', '1', '2008-09-13', '0'), ('6674', '125.127.118.173', '', '', '1', '2008-09-13', '0'), ('6675', '219.132.24.24', '', '', '6', '2008-09-13', '0'), ('6676', '58.63.102.33', '', '', '1', '2008-09-13', '0'), ('6677', '219.136.13.1', '', '', '1', '2008-09-13', '0'), ('6678', '222.213.122.72', '', '', '6', '2008-09-13', '0'), ('6679', '211.137.58.51', '', '', '8', '2008-09-13', '0'), ('6680', '121.68.0.246', '', '', '3', '2008-09-13', '0'), ('6681', '218.200.224.120', '', '', '1', '2008-09-13', '0'), ('6682', '116.22.214.189', '', '', '1', '2008-09-13', '0'), ('6683', '220.243.108.173', '', '', '1', '2008-09-13', '0'), ('6684', '221.222.163.149', '', '', '2', '2008-09-13', '0'), ('6685', '221.221.185.213', '', '', '1', '2008-09-13', '0'), ('6686', '125.91.209.42', '', '', '1', '2008-09-13', '0'), ('6687', '58.252.179.54', '', '', '2', '2008-09-13', '0'), ('6688', '61.185.26.131', '', '', '2', '2008-09-13', '0'), ('6689', '58.209.69.144', '', '', '4', '2008-09-13', '0'), ('6690', '58.60.64.124', '', '', '2', '2008-09-13', '0'), ('6691', '116.26.244.189', '', '', '2', '2008-09-13', '0'), ('6692', '219.238.200.34', '', '', '1', '2008-09-13', '0'), ('6693', '219.130.36.221', '', '', '1', '2008-09-13', '0'), ('6694', '222.77.54.4', '', '', '1', '2008-09-13', '0'), ('6695', '219.129.68.228', '', '', '8', '2008-09-13', '0'), ('6696', '202.101.131.157', '', '', '2', '2008-09-13', '0'), ('6697', '123.121.218.61', '', '', '1', '2008-09-13', '0'), ('6698', '116.31.143.31', '', '', '1', '2008-09-13', '0'), ('6699', '218.200.224.26', '', '', '1', '2008-09-13', '0'), ('6700', '59.36.21.123', '', '', '1', '2008-09-13', '0'), ('6701', '211.90.119.142', '', '', '137', '2008-09-13', '0'), ('6702', '211.138.218.3', '', '', '1', '2008-09-13', '0'), ('6703', '116.26.67.157', '', '', '1', '2008-09-13', '0'), ('6704', '218.91.151.46', '', '', '2', '2008-09-13', '0'), ('6705', '218.19.225.77', '', '', '1', '2008-09-13', '0'), ('6706', '61.144.147.93', '', '', '1', '2008-09-13', '0'), ('6707', '59.36.87.73', '', '', '1', '2008-09-13', '0'), ('6708', '124.226.251.128', '', '', '1', '2008-09-13', '0'), ('6709', '58.56.63.130', '', '', '1', '2008-09-13', '0'), ('6710', '120.87.99.125', '', '', '1', '2008-09-13', '0'), ('6711', '221.218.83.117', '', '', '4', '2008-09-13', '0'), ('6712', '58.39.176.225', '', '', '1', '2008-09-13', '0'), ('6713', '121.13.89.93', '', '', '1', '2008-09-13', '0'), ('6714', '116.22.176.190', '', '', '6', '2008-09-13', '0'), ('6715', '116.30.3.132', '', '', '7', '2008-09-13', '0'), ('6716', '118.192.2.56', '', '', '4', '2008-09-13', '0'), ('6717', '222.138.135.203', '', '', '7', '2008-09-13', '0'), ('6718', '123.116.138.27', '', '', '2', '2008-09-13', '0'), ('6719', '116.31.149.108', '', '', '1', '2008-09-13', '0'), ('6720', '211.136.75.211', '', '', '2', '2008-09-13', '0'), ('6721', '211.138.218.84', '', '', '1', '2008-09-13', '0'), ('6722', '61.175.247.50', '', '', '11', '2008-09-13', '0'), ('6723', '60.215.110.55', '', '', '1', '2008-09-13', '0'), ('6724', '119.128.167.76', '', '', '2', '2008-09-13', '0'), ('6725', '218.17.86.45', '', '', '1', '2008-09-13', '0'), ('6726', '125.33.58.24', '', '', '2', '2008-09-13', '0'), ('6727', '60.191.61.218', '', '', '1', '2008-09-13', '0'), ('6728', '116.5.110.49', '', '', '1', '2008-09-13', '0'), ('6729', '219.132.112.162', '', '', '1', '2008-09-14', '0'), ('6730', '211.140.186.150', '', '', '5', '2008-09-14', '0'), ('6731', '58.60.214.4', '', '', '1', '2008-09-14', '0'), ('6732', '211.137.63.164', '', '', '1', '2008-09-14', '0'), ('6733', '125.71.170.60', '', '', '1', '2008-09-14', '0'), ('6734', '125.93.145.245', '', '', '3', '2008-09-14', '0'), ('6735', '116.31.152.91', '', '', '1', '2008-09-14', '0'), ('6736', '222.94.63.21', '', '', '1', '2008-09-14', '0'), ('6737', '61.141.75.80', '', '', '1', '2008-09-14', '0'), ('6738', '116.26.222.31', '', '', '2', '2008-09-14', '0'), ('6739', '59.107.15.7', '', '', '1', '2008-09-14', '0'), ('6740', '116.18.210.228', '', '', '1', '2008-09-14', '0'), ('6741', '125.89.31.95', '', '', '6', '2008-09-14', '0'), ('6742', '59.42.157.35', '', '', '1', '2008-09-14', '0'), ('6743', '121.12.221.116', '', '', '4', '2008-09-14', '0'), ('6744', '61.166.132.45', '', '', '1', '2008-09-14', '0'), ('6745', '211.137.63.83', '', '', '1', '2008-09-14', '0'), ('6746', '116.25.200.141', '', '', '1', '2008-09-14', '0'), ('6747', '119.125.243.7', '', '', '1', '2008-09-14', '0'), ('6748', '61.146.251.192', '', '', '9', '2008-09-14', '0'), ('6749', '116.242.141.203', '', '', '3', '2008-09-14', '0'), ('6750', '61.144.223.150', '', '', '1', '2008-09-14', '0'), ('6751', '218.8.203.212', '', '', '1', '2008-09-14', '0'), ('6752', '211.137.62.192', '', '', '1', '2008-09-14', '0'), ('6753', '219.137.137.216', '', '', '2', '2008-09-14', '0'), ('6754', '41.220.75.3', '', '', '1', '2008-09-14', '0'), ('6755', '118.100.244.181', '', '', '1', '2008-09-14', '0'), ('6756', '116.4.73.171', '', '', '1', '2008-09-14', '0'), ('6757', '61.143.86.59', '', '', '1', '2008-09-14', '0'), ('6758', '211.136.158.134', '', '', '1', '2008-09-14', '0'), ('6759', '121.32.214.252', '', '', '1', '2008-09-14', '0'), ('6760', '117.15.61.105', '', '', '1', '2008-09-14', '0'), ('6761', '92.118.145.179', '', '', '1', '2008-09-14', '0'), ('6762', '60.171.94.85', '', '', '1', '2008-09-14', '0'), ('6763', '118.24.227.248', '', '', '1', '2008-09-14', '0'), ('6764', '219.153.6.189', '', '', '3', '2008-09-14', '0'), ('6765', '59.40.11.82', '', '', '1', '2008-09-14', '0'), ('6766', '58.71.235.248', '', '', '1', '2008-09-14', '0'), ('6767', '58.61.215.13', '', '', '2', '2008-09-14', '0'), ('6768', '220.188.82.193', '', '', '1', '2008-09-14', '0'), ('6769', '220.113.117.10', '', '', '1', '2008-09-14', '0'), ('6770', '218.90.157.98', '', '', '4', '2008-09-14', '0'), ('6771', '211.137.37.135', '', '', '3', '2008-09-14', '0'), ('6772', '121.235.70.62', '', '', '1', '2008-09-14', '0'), ('6773', '116.5.248.247', '', '', '1', '2008-09-14', '0'), ('6774', '118.229.161.96', '', '', '3', '2008-09-14', '0'), ('6775', '125.66.183.204', '', '', '3', '2008-09-14', '0'), ('6776', '59.38.182.133', '', '', '7', '2008-09-14', '0'), ('6777', '119.137.228.22', '', '', '1', '2008-09-14', '0'), ('6778', '123.114.210.254', '', '', '1', '2008-09-14', '0'), ('6779', '123.53.83.91', '', '', '1', '2008-09-14', '0'), ('6780', '218.213.241.137', '', '', '5', '2008-09-14', '0'), ('6781', '218.26.209.54', '', '', '1', '2008-09-14', '0'), ('6782', '211.94.255.51', '', '', '1', '2008-09-14', '0'), ('6783', '222.70.182.29', '', '', '1', '2008-09-14', '0'), ('6784', '59.42.1.182', '', '', '1', '2008-09-14', '0'), ('6785', '121.35.30.36', '', '', '1', '2008-09-14', '0'), ('6786', '220.243.109.27', '', '', '65', '2008-09-14', '0'), ('6787', '219.128.56.212', '', '', '20', '2008-09-14', '0'), ('6788', '125.91.23.151', '', '', '1', '2008-09-14', '0'), ('6789', '218.204.61.66', '', '', '1', '2008-09-14', '0'), ('6790', '218.19.50.128', '', '', '1', '2008-09-15', '0'), ('6791', '211.137.63.102', '', '', '1', '2008-09-15', '0'), ('6792', '116.19.162.218', '', '', '1', '2008-09-15', '0'), ('6793', '58.63.131.187', '', '', '1', '2008-09-15', '0'), ('6794', '61.191.55.64', '', '', '2', '2008-09-15', '0'), ('6795', '218.205.249.185', '', '', '2', '2008-09-15', '0'), ('6796', '222.88.50.222', '', '', '1', '2008-09-15', '0'), ('6797', '58.61.192.236', '', '', '1', '2008-09-15', '0'), ('6798', '211.136.158.150', '', '', '4', '2008-09-15', '0'), ('6799', '202.160.180.157', '', '', '1', '2008-09-15', '0'), ('6800', '116.18.89.249', '', '', '5', '2008-09-15', '0'), ('6801', '119.127.199.172', '', '', '2', '2008-09-15', '0'), ('6802', '222.70.6.236', '', '', '2', '2008-09-15', '0'), ('6803', '220.170.43.86', '', '', '6', '2008-09-15', '0'), ('6804', '202.120.38.182', '', '', '1', '2008-09-15', '0'), ('6805', '125.33.65.9', '', '', '5', '2008-09-15', '0'), ('6806', '59.32.28.162', '', '', '3', '2008-09-15', '0'), ('6807', '121.13.226.118', '', '', '1', '2008-09-15', '0'), ('6808', '61.144.54.46', '', '', '1', '2008-09-15', '0'), ('6809', '116.26.250.175', '', '', '1', '2008-09-15', '0'), ('6810', '222.132.185.196', '', '', '1', '2008-09-15', '0'), ('6811', '58.221.241.225', '', '', '1', '2008-09-15', '0'), ('6812', '220.206.235.116', '', '', '1', '2008-09-15', '0'), ('6813', '121.9.180.198', '', '', '1', '2008-09-15', '0'), ('6814', '222.79.136.240', '', '', '37', '2008-09-15', '0'), ('6815', '122.157.25.111', '', '', '1', '2008-09-15', '0'), ('6816', '59.39.90.62', '', '', '2', '2008-09-15', '0'), ('6817', '211.136.253.181', '', '', '1', '2008-09-15', '0'), ('6818', '218.28.52.54', '', '', '1', '2008-09-15', '0'), ('6819', '211.137.63.131', '', '', '5', '2008-09-15', '0'), ('6820', '218.89.81.214', '', '', '4', '2008-09-15', '0'), ('6821', '221.231.124.138', '', '', '1', '2008-09-15', '0'), ('6822', '121.13.183.161', '', '', '1', '2008-09-15', '0'), ('6823', '60.4.59.101', '', '', '1', '2008-09-15', '0'), ('6824', '222.242.216.99', '', '', '1', '2008-09-15', '0'), ('6825', '60.216.207.211', '', '', '1', '2008-09-15', '0'), ('6826', '220.167.52.132', '', '', '17', '2008-09-15', '0'), ('6827', '123.113.77.123', '', '', '1', '2008-09-15', '0'), ('6828', '222.245.203.112', '', '', '1', '2008-09-15', '0'), ('6829', '219.137.84.58', '', '', '1', '2008-09-15', '0'), ('6830', '222.185.234.18', '', '', '13', '2008-09-15', '0'), ('6831', '220.206.235.96', '', '', '4', '2008-09-15', '0'), ('6832', '220.166.37.63', '', '', '1', '2008-09-15', '0'), ('6833', '211.145.21.216', '', '', '3', '2008-09-15', '0'), ('6834', '119.123.128.115', '', '', '1', '2008-09-15', '0'), ('6835', '125.83.219.228', '', '', '4', '2008-09-15', '0'), ('6836', '60.166.206.255', '', '', '37', '2008-09-15', '0'), ('6837', '116.5.178.96', '', '', '1', '2008-09-15', '0'), ('6838', '221.0.53.42', '', '', '6', '2008-09-15', '0'), ('6839', '220.194.57.53', '', '', '6', '2008-09-15', '0'), ('6840', '125.91.42.26', '', '', '1', '2008-09-15', '0'), ('6841', '60.54.107.186', '', '', '1', '2008-09-15', '0'), ('6842', '121.35.165.5', '', '', '1', '2008-09-15', '0'), ('6843', '117.85.241.69', '', '', '1', '2008-09-15', '0'), ('6844', '119.130.214.111', '', '', '1', '2008-09-15', '0'), ('6845', '121.29.15.28', '', '', '4', '2008-09-15', '0'), ('6846', '196.3.94.228', '', '', '3', '2008-09-15', '0'), ('6847', '58.209.152.87', '', '', '1', '2008-09-15', '0'), ('6848', '211.138.227.151', '', '', '2', '2008-09-15', '0'), ('6849', '210.24.86.244', '', '', '1', '2008-09-15', '0'), ('6850', '220.194.137.5', '', '', '1', '2008-09-15', '0'), ('6851', '122.6.129.195', '', '', '1', '2008-09-15', '0'), ('6852', '211.136.75.4', '', '', '1', '2008-09-15', '0'), ('6853', '218.108.79.82', '', '', '1', '2008-09-15', '0'), ('6854', '121.32.220.213', '', '', '1', '2008-09-15', '0'), ('6855', '222.184.241.178', '', '', '11', '2008-09-15', '0'), ('6856', '116.21.185.185', '', '', '2', '2008-09-15', '0'), ('6857', '116.197.218.227', '', '', '1', '2008-09-15', '0'), ('6858', '61.132.133.38', '', '', '2', '2008-09-15', '0'), ('6859', '220.194.55.155', '', '', '3', '2008-09-15', '0'), ('6860', '60.166.205.120', '', '', '1', '2008-09-15', '0'), ('6861', '116.19.161.91', '', '', '1', '2008-09-15', '0'), ('6862', '123.188.116.123', '', '', '1', '2008-09-15', '0'), ('6863', '116.16.237.2', '', '', '4', '2008-09-15', '0'), ('6864', '211.145.100.60', '', '', '1', '2008-09-16', '0'), ('6865', '211.138.227.50', '', '', '1', '2008-09-16', '0'), ('6866', '211.137.63.104', '', '', '1', '2008-09-16', '0'), ('6867', '222.173.171.2', '', '', '2', '2008-09-16', '0'), ('6868', '220.205.141.158', '', '', '2', '2008-09-16', '0'), ('6869', '61.172.163.132', '', '', '1', '2008-09-16', '0'), ('6870', '125.77.31.248', '', '', '1', '2008-09-16', '0'), ('6871', '202.160.178.166', '', '', '1', '2008-09-16', '0'), ('6872', '59.35.182.231', '', '', '1', '2008-09-16', '0'), ('6873', '221.239.230.10', '', '', '1', '2008-09-16', '0'), ('6874', '121.201.245.24', '', '', '1', '2008-09-16', '0'), ('6875', '58.241.89.137', '', '', '1', '2008-09-16', '0'), ('6876', '203.142.104.36', '', '', '1', '2008-09-16', '0'), ('6877', '124.89.2.45', '', '', '1', '2008-09-16', '0'), ('6878', '219.128.55.181', '', '', '1', '2008-09-16', '0'), ('6879', '116.23.150.14', '', '', '1', '2008-09-16', '0'), ('6880', '222.64.100.74', '', '', '1', '2008-09-16', '0'), ('6881', '211.136.158.228', '', '', '1', '2008-09-16', '0'), ('6882', '114.138.238.250', '', '', '1', '2008-09-16', '0'), ('6883', '119.122.94.53', '', '', '1', '2008-09-16', '0'), ('6884', '211.90.161.242', '', '', '5', '2008-09-16', '0'), ('6885', '86.51.36.40', '', '', '1', '2008-09-16', '0'), ('6886', '218.23.175.196', '', '', '2', '2008-09-16', '0'), ('6887', '202.156.8.13', '', '', '1', '2008-09-16', '0'), ('6888', '125.78.123.207', '', '', '1', '2008-09-16', '0'), ('6889', '218.241.167.178', '', '', '1', '2008-09-16', '0'), ('6890', '118.147.95.200', '', '', '1', '2008-09-16', '0'), ('6891', '218.13.103.74', '', '', '1', '2008-09-16', '0'), ('6892', '218.19.0.143', '', '', '2', '2008-09-16', '0'), ('6893', '116.29.182.170', '', '', '1', '2008-09-16', '0'), ('6894', '211.136.158.211', '', '', '4', '2008-09-16', '0'), ('6895', '120.32.193.207', '', '', '1', '2008-09-16', '0'), ('6896', '218.202.67.67', '', '', '2', '2008-09-16', '0'), ('6897', '220.231.165.183', '', '', '2', '2008-09-16', '0'), ('6898', '60.189.17.219', '', '', '2', '2008-09-16', '0'), ('6899', '221.131.61.73', '', '', '3', '2008-09-16', '0'), ('6900', '58.60.190.219', '', '', '2', '2008-09-16', '0'), ('6901', '125.82.13.94', '', '', '1', '2008-09-16', '0'), ('6902', '61.188.122.42', '', '', '1', '2008-09-16', '0'), ('6903', '220.206.246.49', '', '', '1', '2008-09-16', '0'), ('6904', '118.192.9.193', '', '', '4', '2008-09-16', '0'), ('6905', '116.31.144.172', '', '', '2', '2008-09-16', '0'), ('6906', '222.76.166.90', '', '', '1', '2008-09-16', '0'), ('6907', '211.143.149.230', '', '', '1', '2008-09-16', '0'), ('6908', '60.191.233.130', '', '', '10', '2008-09-16', '0'), ('6909', '221.220.224.238', '', '', '28', '2008-09-16', '0'), ('6910', '218.75.94.206', '', '', '1', '2008-09-16', '0'), ('6911', '219.137.85.53', '', '', '1', '2008-09-16', '0'), ('6912', '201.224.33.227', '', '', '2', '2008-09-16', '0'), ('6913', '219.130.30.74', '', '', '2', '2008-09-16', '0'), ('6914', '218.18.51.49', '', '', '8', '2008-09-16', '0'), ('6915', '58.61.149.214', '', '', '26', '2008-09-16', '0'), ('6916', '59.37.236.84', '', '', '5', '2008-09-16', '0'), ('6917', '116.29.158.150', '', '', '1', '2008-09-16', '0'), ('6918', '119.128.227.190', '', '', '1', '2008-09-16', '0'), ('6919', '59.63.154.40', '', '', '1', '2008-09-16', '0'), ('6920', '219.129.52.190', '', '', '1', '2008-09-16', '0'), ('6921', '116.21.195.54', '', '', '1', '2008-09-16', '0'), ('6922', '121.9.189.50', '', '', '3', '2008-09-16', '0'), ('6923', '123.156.69.221', '', '', '2', '2008-09-16', '0'), ('6924', '58.61.23.9', '', '', '1', '2008-09-16', '0'), ('6925', '117.93.19.105', '', '', '1', '2008-09-16', '0'), ('6926', '60.188.192.239', '', '', '1', '2008-09-16', '0'), ('6927', '59.50.138.175', '', '', '2', '2008-09-16', '0'), ('6928', '220.196.37.66', '', '', '2', '2008-09-16', '0'), ('6929', '125.91.200.245', '', '', '1', '2008-09-16', '0'), ('6930', '58.63.126.208', '', '', '1', '2008-09-16', '0'), ('6931', '219.137.116.50', '', '', '2', '2008-09-16', '0'), ('6932', '125.93.189.106', '', '', '1', '2008-09-16', '0'), ('6933', '218.19.201.124', '', '', '1', '2008-09-16', '0'), ('6934', '116.30.113.108', '', '', '2', '2008-09-16', '0'), ('6935', '119.120.39.206', '', '', '1', '2008-09-16', '0'), ('6936', '218.75.20.230', '', '', '1', '2008-09-16', '0'), ('6937', '58.221.241.212', '', '', '1', '2008-09-16', '0'), ('6938', '119.137.231.22', '', '', '1', '2008-09-16', '0'), ('6939', '218.88.187.7', '', '', '1', '2008-09-16', '0'), ('6940', '125.33.58.169', '', '', '2', '2008-09-16', '0'), ('6941', '116.16.231.181', '', '', '1', '2008-09-16', '0'), ('6942', '119.124.51.108', '', '', '1', '2008-09-16', '0'), ('6943', '219.139.95.181', '', '', '2', '2008-09-16', '0'), ('6944', '211.137.37.136', '', '', '5', '2008-09-16', '0'), ('6945', '125.33.55.98', '', '', '1', '2008-09-16', '0'), ('6946', '125.93.188.252', '', '', '10', '2008-09-16', '0'), ('6947', '116.16.59.5', '', '', '1', '2008-09-16', '0'), ('6948', '218.200.224.90', '', '', '1', '2008-09-16', '0'), ('6949', '222.79.15.20', '', '', '1', '2008-09-16', '0'), ('6950', '218.73.228.221', '', '', '1', '2008-09-16', '0'), ('6951', '59.107.13.248', '', '', '1', '2008-09-16', '0'), ('6952', '221.10.91.215', '', '', '2', '2008-09-16', '0'), ('6953', '116.24.25.195', '', '', '1', '2008-09-16', '0'), ('6954', '124.225.29.219', '', '', '2', '2008-09-16', '0'), ('6955', '211.136.75.129', '', '', '1', '2008-09-16', '0'), ('6956', '60.215.119.164', '', '', '1', '2008-09-16', '0'), ('6957', '220.242.2.4', '', '', '2', '2008-09-16', '0'), ('6958', '58.60.232.65', '', '', '1', '2008-09-16', '0'), ('6959', '195.189.142.147', '', '', '1', '2008-09-16', '0'), ('6960', '220.194.137.11', '', '', '6', '2008-09-17', '0'), ('6961', '59.42.99.219', '', '', '1', '2008-09-17', '0'), ('6962', '121.20.233.17', '', '', '1', '2008-09-17', '0'), ('6963', '118.192.9.208', '', '', '4', '2008-09-17', '0'), ('6964', '58.252.118.76', '', '', '11', '2008-09-17', '0'), ('6965', '58.46.229.179', '', '', '1', '2008-09-17', '0'), ('6966', '60.172.225.116', '', '', '1', '2008-09-17', '0'), ('6967', '218.24.133.5', '', '', '2', '2008-09-17', '0'), ('6968', '221.1.44.107', '', '', '1', '2008-09-17', '0'), ('6969', '123.127.168.59', '', '', '1', '2008-09-17', '0'), ('6970', '58.71.206.227', '', '', '1', '2008-09-17', '0'), ('6971', '118.119.39.190', '', '', '1', '2008-09-17', '0'), ('6972', '218.14.180.66', '', '', '1', '2008-09-17', '0'), ('6973', '121.34.94.139', '', '', '1', '2008-09-17', '0'), ('6974', '218.16.94.76', '', '', '2', '2008-09-17', '0'), ('6975', '124.132.51.40', '', '', '1', '2008-09-17', '0'), ('6976', '123.112.76.179', '', '', '1', '2008-09-17', '0'), ('6977', '60.220.218.26', '', '', '2', '2008-09-17', '0'), ('6978', '222.83.168.209', '', '', '1', '2008-09-17', '0'), ('6979', '211.138.227.229', '', '', '1', '2008-09-17', '0'), ('6980', '59.40.186.101', '', '', '1', '2008-09-17', '0'), ('6981', '121.29.18.76', '', '', '1', '2008-09-17', '0'), ('6982', '218.19.53.73', '', '', '2', '2008-09-17', '0'), ('6983', '125.121.84.182', '', '', '2', '2008-09-17', '0'), ('6984', '219.236.120.223', '', '', '1', '2008-09-17', '0'), ('6985', '218.202.6.162', '', '', '5', '2008-09-17', '0'), ('6986', '220.160.201.137', '', '', '1', '2008-09-17', '0'), ('6987', '125.91.57.23', '', '', '1', '2008-09-17', '0'), ('6988', '60.168.92.199', '', '', '2', '2008-09-17', '0'), ('6989', '218.200.125.6', '', '', '5', '2008-09-17', '0'), ('6990', '218.16.245.26', '', '', '1', '2008-09-17', '0'), ('6991', '58.61.46.162', '', '', '1', '2008-09-17', '0'), ('6992', '116.5.251.231', '', '', '1', '2008-09-17', '0'), ('6993', '123.61.182.207', '', '', '2', '2008-09-17', '0'), ('6994', '220.187.145.156', '', '', '1', '2008-09-17', '0'), ('6995', '58.252.176.55', '', '', '2', '2008-09-17', '0'), ('6996', '121.34.58.31', '', '', '1', '2008-09-17', '0'), ('6997', '211.138.218.75', '', '', '1', '2008-09-17', '0'), ('6998', '117.95.193.69', '', '', '1', '2008-09-17', '0'), ('6999', '220.206.246.47', '', '', '1', '2008-09-17', '0'), ('7000', '220.243.104.166', '', '', '1', '2008-09-17', '0'), ('7001', '125.91.40.13', '', '', '1', '2008-09-17', '0'), ('7002', '58.221.241.182', '', '', '3', '2008-09-17', '0'), ('7003', '117.93.173.250', '', '', '2', '2008-09-17', '0'), ('7004', '217.113.76.242', '', '', '1', '2008-09-17', '0'), ('7005', '116.26.126.93', '', '', '1', '2008-09-17', '0'), ('7006', '123.11.27.254', '', '', '1', '2008-09-17', '0'), ('7007', '221.10.111.116', '', '', '1', '2008-09-17', '0'), ('7008', '70.48.112.45', '', '', '1', '2008-09-17', '0'), ('7009', '121.32.154.20', '', '', '1', '2008-09-17', '0'), ('7010', '116.63.222.179', '', '', '2', '2008-09-17', '0'), ('7011', '219.156.165.44', '', '', '1', '2008-09-17', '0'), ('7012', '211.138.227.62', '', '', '1', '2008-09-17', '0'), ('7013', '219.134.191.29', '', '', '1', '2008-09-17', '0'), ('7014', '219.137.116.18', '', '', '9', '2008-09-17', '0'), ('7015', '221.1.41.181', '', '', '1', '2008-09-17', '0'), ('7016', '58.61.224.90', '', '', '1', '2008-09-17', '0'), ('7017', '123.175.206.141', '', '', '23', '2008-09-17', '0'), ('7018', '211.136.75.234', '', '', '1', '2008-09-17', '0'), ('7019', '123.181.195.79', '', '', '1', '2008-09-17', '0'), ('7020', '219.136.15.61', '', '', '8', '2008-09-17', '0'), ('7021', '211.138.24.198', '', '', '1', '2008-09-17', '0'), ('7022', '116.4.235.42', '', '', '1', '2008-09-17', '0'), ('7023', '116.20.99.185', '', '', '5', '2008-09-17', '0'), ('7024', '122.230.13.29', '', '', '1', '2008-09-17', '0'), ('7025', '61.140.191.92', '', '', '3', '2008-09-17', '0'), ('7026', '125.36.194.35', '', '', '1', '2008-09-17', '0'), ('7027', '121.32.71.179', '', '', '2', '2008-09-17', '0'), ('7028', '220.206.235.23', '', '', '1', '2008-09-17', '0'), ('7029', '116.28.90.153', '', '', '1', '2008-09-17', '0'), ('7030', '116.26.144.235', '', '', '6', '2008-09-17', '0'), ('7031', '219.134.209.81', '', '', '1', '2008-09-17', '0'), ('7032', '125.91.200.226', '', '', '1', '2008-09-17', '0'), ('7033', '222.92.78.114', '', '', '3', '2008-09-17', '0'), ('7034', '118.120.249.152', '', '', '1', '2008-09-17', '0'), ('7035', '121.207.70.235', '', '', '1', '2008-09-17', '0'), ('7036', '119.84.153.147', '', '', '2', '2008-09-17', '0'), ('7037', '220.206.246.37', '', '', '2', '2008-09-17', '0'), ('7038', '116.30.162.216', '', '', '1', '2008-09-17', '0'), ('7039', '116.254.150.207', '', '', '1', '2008-09-17', '0'), ('7040', '41.223.73.75', '', '', '2', '2008-09-17', '0'), ('7041', '67.228.166.100', '', '移动', '0', '2008-10-15', '1'), ('7042', '58.33.46.66', '', '', '4', '2008-09-17', '0'), ('7043', '61.149.201.245', '', '', '1', '2008-09-17', '0'), ('7044', '219.152.41.204', '', '', '1', '2008-09-17', '0'), ('7045', '125.33.126.139', '', '', '1', '2008-09-17', '0'), ('7046', '218.75.95.46', '', '', '4', '2008-09-17', '0'), ('7047', '218.201.45.38', '', '', '2', '2008-09-17', '0'), ('7048', '211.138.218.126', '', '', '2', '2008-09-17', '0'), ('7049', '218.205.249.142', '', '', '1', '2008-09-17', '0'), ('7050', '121.229.189.80', '', '', '1', '2008-09-17', '0'), ('7051', '58.253.104.40', '', '', '1', '2008-09-18', '0'), ('7052', '220.206.235.77', '', '', '1', '2008-09-18', '0'), ('7053', '211.136.158.209', '', '', '2', '2008-09-18', '0'), ('7054', '125.93.23.208', '', '', '2', '2008-09-18', '0'), ('7055', '218.13.78.39', '', '', '2', '2008-09-18', '0'), ('7056', '119.141.138.218', '', '', '1', '2008-09-18', '0'), ('7057', '211.138.218.80', '', '', '1', '2008-09-18', '0'), ('7058', '118.192.0.187', '', '', '1', '2008-09-18', '0'), ('7059', '219.78.206.107', '', '', '3', '2008-09-18', '0'), ('7060', '218.202.227.146', '', '', '73', '2008-09-18', '0'), ('7061', '193.111.10.29', '', '', '1', '2008-09-18', '0');
INSERT INTO `ig_gateway` VALUES ('7062', '220.206.246.1', '', '', '3', '2008-09-18', '0'), ('7063', '211.136.75.138', '', '', '1', '2008-09-18', '0'), ('7064', '218.58.154.66', '', '', '3', '2008-09-18', '0'), ('7065', '116.26.230.118', '', '', '4', '2008-09-18', '0'), ('7066', '59.41.235.111', '', '', '1', '2008-09-18', '0'), ('7067', '117.85.241.133', '', '', '1', '2008-09-18', '0'), ('7068', '222.69.253.139', '', '', '1', '2008-09-18', '0'), ('7069', '124.197.114.23', '', '', '1', '2008-09-18', '0'), ('7070', '58.253.94.162', '', '', '8', '2008-09-18', '0'), ('7071', '219.93.152.23', '', '', '4', '2008-09-18', '0'), ('7072', '91.203.96.21', '', '', '2', '2008-09-18', '0'), ('7073', '116.4.139.65', '', '', '2', '2008-09-18', '0'), ('7074', '220.162.189.37', '', '', '6', '2008-09-18', '0'), ('7075', '116.233.140.35', '', '', '4', '2008-09-18', '0'), ('7076', '59.41.98.104', '', '', '1', '2008-09-18', '0'), ('7077', '219.137.116.20', '', '', '38', '2008-09-18', '0'), ('7078', '117.24.72.98', '', '', '2', '2008-09-18', '0'), ('7079', '116.4.78.187', '', '', '1', '2008-09-18', '0'), ('7080', '116.24.70.149', '', '', '2', '2008-09-18', '0'), ('7081', '61.164.129.178', '', '', '1', '2008-09-18', '0'), ('7082', '222.125.74.79', '', '', '1', '2008-09-18', '0'), ('7083', '58.62.162.62', '', '', '1', '2008-09-18', '0'), ('7084', '59.174.76.92', '', '', '2', '2008-09-18', '0'), ('7085', '218.200.224.240', '', '', '1', '2008-09-18', '0'), ('7086', '219.134.156.6', '', '', '2', '2008-09-18', '0'), ('7087', '59.33.248.146', '', '', '1', '2008-09-18', '0'), ('7088', '58.71.244.88', '', '', '1', '2008-09-18', '0'), ('7089', '221.222.165.219', '', '', '1', '2008-09-18', '0'), ('7090', '117.20.115.154', '', '', '2', '2008-09-18', '0'), ('7091', '220.231.138.107', '', '', '2', '2008-09-18', '0'), ('7092', '220.243.106.75', '', '', '7', '2008-09-18', '0'), ('7093', '221.221.16.222', '', '', '1', '2008-09-18', '0'), ('7094', '61.142.246.154', '', '', '12', '2008-09-18', '0'), ('7095', '58.59.134.211', '', '', '1', '2008-09-18', '0'), ('7096', '121.35.100.96', '', '', '1', '2008-09-18', '0'), ('7097', '116.19.20.31', '', '', '1', '2008-09-18', '0'), ('7098', '218.19.53.92', '', '', '1', '2008-09-18', '0'), ('7099', '218.92.20.106', '', '', '2', '2008-09-18', '0'), ('7100', '59.50.136.82', '', '', '1', '2008-09-18', '0'), ('7101', '220.248.97.122', '', '', '2', '2008-09-18', '0'), ('7102', '124.226.252.185', '', '', '12', '2008-09-18', '0'), ('7103', '125.74.4.200', '', '', '3', '2008-09-18', '0'), ('7104', '219.129.210.50', '', '', '1', '2008-09-18', '0'), ('7105', '211.137.63.114', '', '', '2', '2008-09-18', '0'), ('7106', '221.237.162.6', '', '', '3', '2008-09-18', '0'), ('7107', '213.26.205.144', '', '', '2', '2008-09-18', '0'), ('7108', '220.206.235.91', '', '', '3', '2008-09-18', '0'), ('7109', '220.200.177.195', '', '', '7', '2008-09-18', '0'), ('7110', '124.207.80.114', '', '', '1', '2008-09-18', '0'), ('7111', '122.224.187.45', '', '', '1', '2008-09-18', '0'), ('7112', '116.26.146.8', '', '', '1', '2008-09-18', '0'), ('7113', '211.137.236.67', '', '', '1', '2008-09-18', '0'), ('7114', '202.149.25.40', '', '', '13', '2008-09-18', '0'), ('7115', '219.135.232.66', '', '', '1', '2008-09-18', '0'), ('7116', '121.33.206.252', '', '', '1', '2008-09-18', '0'), ('7117', '125.91.146.51', '', '', '2', '2008-09-18', '0'), ('7118', '117.93.163.221', '', '', '2', '2008-09-18', '0'), ('7119', '125.91.193.47', '', '', '6', '2008-09-18', '0'), ('7120', '116.18.118.76', '', '', '5', '2008-09-18', '0'), ('7121', '58.62.37.39', '', '', '1', '2008-09-18', '0'), ('7122', '59.37.42.67', '', '', '1', '2008-09-18', '0'), ('7123', '58.216.213.166', '', '', '7', '2008-09-18', '0'), ('7124', '218.205.252.61', '', '', '1', '2008-09-18', '0'), ('7125', '221.1.88.113', '', '', '1', '2008-09-18', '0'), ('7126', '124.64.246.112', '', '', '1', '2008-09-18', '0'), ('7127', '218.15.233.70', '', '', '1', '2008-09-18', '0'), ('7128', '218.17.41.150', '', '', '1', '2008-09-18', '0'), ('7129', '123.117.162.139', '', '', '1', '2008-09-18', '0'), ('7130', '203.145.92.93', '', '', '1', '2008-09-18', '0'), ('7131', '116.23.210.251', '', '', '1', '2008-09-19', '0'), ('7132', '121.32.71.218', '', '', '2', '2008-09-19', '0'), ('7133', '123.14.28.154', '', '', '1', '2008-09-19', '0'), ('7134', '201.224.33.244', '', '', '3', '2008-09-19', '0'), ('7135', '222.70.11.93', '', '', '2', '2008-09-19', '0'), ('7136', '211.136.158.236', '', '', '1', '2008-09-19', '0'), ('7137', '125.77.151.157', '', '', '1', '2008-09-19', '0'), ('7138', '125.93.189.155', '', '', '1', '2008-09-19', '0'), ('7139', '121.201.245.2', '', '', '3', '2008-09-19', '0'), ('7140', '211.137.62.235', '', '', '2', '2008-09-19', '0'), ('7141', '59.60.57.252', '', '', '2', '2008-09-19', '0'), ('7142', '117.95.73.204', '', '', '1', '2008-09-19', '0'), ('7143', '116.24.244.114', '', '', '1', '2008-09-19', '0'), ('7144', '58.61.108.182', '', '', '1', '2008-09-19', '0'), ('7145', '211.136.75.215', '', '', '1', '2008-09-19', '0'), ('7146', '116.77.2.245', '', '', '1', '2008-09-19', '0'), ('7147', '121.33.34.49', '', '', '1', '2008-09-19', '0'), ('7148', '202.156.9.3', '', '', '3', '2008-09-19', '0'), ('7149', '211.136.158.234', '', '', '1', '2008-09-19', '0'), ('7150', '218.19.123.79', '', '', '14', '2008-09-19', '0'), ('7151', '220.206.246.61', '', '', '2', '2008-09-19', '0'), ('7152', '211.90.87.131', '', '', '6', '2008-09-19', '0'), ('7153', '219.137.59.189', '', '', '1', '2008-09-19', '0'), ('7154', '58.251.184.167', '', '', '3', '2008-09-19', '0'), ('7155', '125.95.165.18', '', '', '1', '2008-09-19', '0'), ('7156', '222.77.120.202', '', '', '1', '2008-09-19', '0'), ('7157', '219.136.217.70', '', '', '3', '2008-09-19', '0'), ('7158', '116.4.139.103', '', '', '1', '2008-09-19', '0'), ('7159', '58.242.206.224', '', '', '1', '2008-09-19', '0'), ('7160', '58.209.150.180', '', '', '1', '2008-09-19', '0'), ('7161', '219.133.170.70', '', '', '1', '2008-09-19', '0'), ('7162', '220.206.233.117', '', '', '1', '2008-09-19', '0'), ('7163', '125.124.77.145', '', '', '1', '2008-09-19', '0'), ('7164', '125.86.90.92', '', '', '1', '2008-09-19', '0'), ('7165', '211.147.253.213', '', '', '6', '2008-09-19', '0'), ('7166', '222.70.5.147', '', '', '1', '2008-09-19', '0'), ('7167', '222.208.239.214', '', '', '1', '2008-09-19', '0'), ('7168', '116.16.210.174', '', '', '4', '2008-09-19', '0'), ('7169', '121.32.147.169', '', '', '5', '2008-09-19', '0'), ('7170', '121.29.6.143', '', '', '2', '2008-09-19', '0'), ('7171', '219.132.122.123', '', '', '1', '2008-09-19', '0'), ('7172', '220.243.110.36', '', '', '2', '2008-09-19', '0'), ('7173', '124.197.120.50', '', '', '1', '2008-09-19', '0'), ('7174', '58.63.2.51', '', '', '1', '2008-09-19', '0'), ('7175', '219.134.136.240', '', '', '18', '2008-09-19', '0'), ('7176', '116.25.124.180', '', '', '7', '2008-09-19', '0'), ('7177', '117.68.52.13', '', '', '1', '2008-09-19', '0'), ('7178', '219.143.134.12', '', '', '1', '2008-09-19', '0'), ('7179', '218.205.249.246', '', '', '1', '2008-09-19', '0'), ('7180', '211.136.75.30', '', '', '2', '2008-09-19', '0'), ('7181', '121.32.32.205', '', '', '1', '2008-09-19', '0'), ('7182', '61.146.122.42', '', '', '2', '2008-09-19', '0'), ('7183', '116.232.190.68', '', '', '1', '2008-09-19', '0'), ('7184', '61.130.77.22', '', '', '3', '2008-09-19', '0'), ('7185', '58.242.220.140', '', '', '15', '2008-09-19', '0'), ('7186', '220.162.188.107', '', '', '1', '2008-09-19', '0'), ('7187', '116.21.203.46', '', '', '1', '2008-09-19', '0'), ('7188', '121.68.0.249', '', '', '3', '2008-09-19', '0'), ('7189', '117.93.169.128', '', '', '1', '2008-09-19', '0'), ('7190', '116.4.121.101', '', '', '1', '2008-09-19', '0'), ('7191', '202.93.37.94', '', '', '1', '2008-09-19', '0'), ('7192', '222.131.136.186', '', '', '1', '2008-09-19', '0'), ('7193', '116.7.56.92', '', '', '1', '2008-09-19', '0'), ('7194', '125.121.91.83', '', '', '1', '2008-09-19', '0'), ('7195', '58.60.212.203', '', '', '1', '2008-09-19', '0'), ('7196', '219.135.131.69', '', '', '1', '2008-09-19', '0'), ('7197', '123.103.46.247', '', '', '3', '2008-09-19', '0'), ('7198', '121.8.246.100', '', '', '4', '2008-09-19', '0'), ('7199', '222.182.162.214', '', '', '1', '2008-09-19', '0'), ('7200', '125.33.59.184', '', '', '6', '2008-09-19', '0'), ('7201', '117.97.196.161', '', '', '1', '2008-09-19', '0'), ('7202', '221.12.22.161', '', '', '1', '2008-09-19', '0'), ('7203', '219.128.60.81', '', '', '1', '2008-09-19', '0'), ('7204', '220.248.235.162', '', '', '1', '2008-09-19', '0'), ('7205', '218.72.87.77', '', '', '1', '2008-09-19', '0'), ('7206', '195.189.143.56', '', '', '3', '2008-09-19', '0'), ('7207', '118.192.1.30', '', '', '2', '2008-09-19', '0'), ('7208', '211.136.73.109', '', '', '12', '2008-09-19', '0'), ('7209', '114.138.246.32', '', '', '1', '2008-09-19', '0'), ('7210', '211.136.228.224', '', '', '1', '2008-09-19', '0'), ('7211', '220.178.74.118', '', '', '10', '2008-09-19', '0'), ('7212', '222.214.206.16', '', '', '3', '2008-09-20', '0'), ('7213', '58.212.64.234', '', '', '1', '2008-09-20', '0'), ('7214', '121.11.203.61', '', '', '3', '2008-09-20', '0'), ('7215', '118.227.1.187', '', '', '1', '2008-09-20', '0'), ('7216', '211.136.158.166', '', '', '1', '2008-09-20', '0'), ('7217', '125.95.41.128', '', '', '1', '2008-09-20', '0'), ('7218', '218.86.10.204', '', '', '8', '2008-09-20', '0'), ('7219', '119.234.0.25', '', '', '1', '2008-09-20', '0'), ('7220', '124.92.134.120', '', '', '1', '2008-09-20', '0'), ('7221', '211.136.158.201', '', '', '3', '2008-09-20', '0'), ('7222', '211.136.75.141', '', '', '1', '2008-09-20', '0'), ('7223', '59.40.164.205', '', '', '1', '2008-09-20', '0'), ('7224', '60.171.68.156', '', '', '1', '2008-09-20', '0'), ('7225', '218.205.249.12', '', '', '1', '2008-09-20', '0'), ('7227', '125.93.79.82', '', '', '5', '2008-09-20', '0'), ('7228', '116.26.150.73', '', '', '1', '2008-09-20', '0'), ('7229', '121.32.6.44', '', '', '3', '2008-09-20', '0'), ('7230', '125.113.57.28', '', '', '1', '2008-09-20', '0'), ('7231', '124.128.168.119', '', '', '1', '2008-09-20', '0'), ('7232', '222.84.43.56', '', '', '2', '2008-09-20', '0'), ('7233', '121.32.162.16', '', '', '3', '2008-09-20', '0'), ('7234', '66.249.72.161', '', '', '19', '2008-09-20', '0'), ('7235', '202.75.133.23', '', '', '3', '2008-09-20', '0'), ('7236', '60.29.19.153', '', '', '1', '2008-09-20', '0'), ('7237', '60.171.185.76', '', '', '1', '2008-09-20', '0'), ('7238', '61.191.170.70', '', '', '1', '2008-09-20', '0'), ('7239', '121.12.225.100', '', '', '13', '2008-09-20', '0'), ('7240', '121.32.65.105', '', '', '1', '2008-09-20', '0'), ('7241', '124.197.93.126', '', '', '1', '2008-09-20', '0'), ('7242', '116.25.218.32', '', '', '1', '2008-09-20', '0'), ('7243', '80.243.78.146', '', '', '1', '2008-09-20', '0'), ('7244', '211.136.75.239', '', '', '1', '2008-09-20', '0'), ('7245', '125.96.110.204', '', '', '1', '2008-09-20', '0'), ('7246', '116.31.151.221', '', '', '2', '2008-09-20', '0'), ('7247', '123.61.140.208', '', '', '1', '2008-09-20', '0'), ('7248', '125.64.120.124', '', '', '1', '2008-09-20', '0'), ('7249', '124.229.53.46', '', '', '23', '2008-09-20', '0'), ('7250', '218.20.241.107', '', '', '1', '2008-09-20', '0'), ('7251', '220.167.52.159', '', '', '1', '2008-09-20', '0'), ('7252', '59.36.87.191', '', '', '3', '2008-09-20', '0'), ('7253', '59.41.227.208', '', '', '1', '2008-09-20', '0'), ('7254', '222.213.123.184', '', '', '1', '2008-09-20', '0'), ('7255', '121.23.215.132', '', '', '1', '2008-09-20', '0'), ('7256', '59.151.17.132', '', '', '5', '2008-09-20', '0'), ('7257', '116.235.196.42', '', '', '1', '2008-09-20', '0'), ('7258', '125.33.50.93', '', '', '1', '2008-09-20', '0'), ('7259', '221.130.182.30', '', '', '3', '2008-09-20', '0'), ('7260', '211.137.63.119', '', '', '1', '2008-09-20', '0'), ('7261', '119.234.0.18', '', '', '1', '2008-09-20', '0'), ('7262', '61.184.3.5', '', '', '1', '2008-09-20', '0'), ('7263', '116.18.125.44', '', '', '2', '2008-09-20', '0'), ('7264', '116.4.243.61', '', '', '4', '2008-09-20', '0'), ('7265', '58.253.18.128', '', '', '5', '2008-09-20', '0'), ('7266', '203.113.138.118', '', '', '1', '2008-09-20', '0'), ('7267', '211.94.76.95', '', '', '2', '2008-09-20', '0'), ('7268', '119.128.227.203', '', '', '1', '2008-09-20', '0'), ('7269', '58.221.241.214', '', '', '1', '2008-09-20', '0'), ('7270', '218.200.224.8', '', '', '1', '2008-09-20', '0'), ('7271', '124.225.28.171', '', '', '1', '2008-09-20', '0'), ('7272', '211.136.75.143', '', '', '3', '2008-09-20', '0'), ('7273', '58.34.8.135', '', '', '1', '2008-09-20', '0'), ('7274', '123.136.6.23', '', '', '2', '2008-09-20', '0'), ('7275', '117.85.241.92', '', '', '1', '2008-09-20', '0'), ('7276', '220.201.81.204', '', '', '1', '2008-09-20', '0'), ('7277', '222.88.24.247', '', '', '1', '2008-09-20', '0'), ('7278', '220.187.68.235', '', '', '1', '2008-09-20', '0'), ('7279', '117.84.198.39', '', '', '1', '2008-09-20', '0'), ('7280', '121.32.112.152', '', '', '1', '2008-09-20', '0'), ('7281', '218.28.237.246', '', '', '14', '2008-09-20', '0'), ('7282', '59.59.6.126', '', '', '1', '2008-09-20', '0'), ('7283', '121.8.240.45', '', '', '1', '2008-09-20', '0'), ('7284', '116.16.242.93', '', '', '1', '2008-09-20', '0'), ('7285', '58.62.104.18', '', '', '1', '2008-09-20', '0'), ('7286', '218.85.123.60', '', '', '1', '2008-09-20', '0'), ('7287', '124.114.149.34', '', '', '3', '2008-09-20', '0'), ('7288', '125.116.57.184', '', '', '6', '2008-09-20', '0'), ('7289', '121.33.172.215', '', '', '3', '2008-09-20', '0'), ('7290', '116.4.15.60', '', '', '1', '2008-09-20', '0'), ('7291', '220.175.183.44', '', '', '1', '2008-09-20', '0'), ('7292', '116.23.203.98', '', '', '1', '2008-09-20', '0'), ('7293', '218.200.224.55', '', '', '1', '2008-09-20', '0'), ('7294', '60.190.69.131', '', '', '1', '2008-09-20', '0'), ('7295', '218.22.199.162', '', '', '2', '2008-09-20', '0'), ('7296', '220.255.7.156', '', '', '1', '2008-09-20', '0'), ('7297', '220.207.239.223', '', '', '1', '2008-09-20', '0'), ('7298', '58.59.215.254', '', '', '1', '2008-09-20', '0'), ('7299', '211.136.158.173', '', '', '1', '2008-09-20', '0'), ('7300', '122.48.238.162', '', '', '1', '2008-09-20', '0'), ('7301', '58.62.186.39', '', '', '1', '2008-09-21', '0'), ('7302', '117.95.193.20', '', '', '1', '2008-09-21', '0'), ('7303', '116.1.42.117', '', '', '1', '2008-09-21', '0'), ('7304', '221.219.63.144', '', '', '7', '2008-09-21', '0'), ('7305', '58.145.190.56', '', '', '4', '2008-09-21', '0'), ('7306', '125.77.146.160', '', '', '1', '2008-09-21', '0'), ('7307', '124.13.152.111', '', '', '1', '2008-09-21', '0'), ('7308', '211.136.158.190', '', '', '3', '2008-09-21', '0'), ('7309', '116.16.231.148', '', '', '2', '2008-09-21', '0'), ('7310', '210.21.125.182', '', '', '1', '2008-09-21', '0'), ('7311', '116.17.5.199', '', '', '1', '2008-09-21', '0'), ('7312', '202.75.133.24', '', '', '5', '2008-09-21', '0'), ('7313', '200.2.169.159', '', '', '1', '2008-09-21', '0'), ('7314', '202.75.133.29', '', '', '4', '2008-09-21', '0'), ('7315', '218.200.224.24', '', '', '1', '2008-09-21', '0'), ('7316', '202.75.133.27', '', '', '2', '2008-09-21', '0'), ('7317', '219.131.173.94', '', '', '23', '2008-09-21', '0'), ('7318', '202.75.133.21', '', '', '4', '2008-09-21', '0'), ('7319', '219.135.9.181', '', '', '1', '2008-09-21', '0'), ('7320', '59.35.153.167', '', '', '1', '2008-09-21', '0'), ('7321', '66.249.72.176', '', '', '13', '2008-09-21', '0'), ('7322', '219.130.49.111', '', '', '1', '2008-09-21', '0'), ('7323', '218.111.223.27', '', '', '1', '2008-09-21', '0'), ('7324', '124.229.41.45', '', '', '1', '2008-09-21', '0'), ('7325', '221.224.3.90', '', '', '1', '2008-09-21', '0'), ('7326', '219.136.219.162', '', '', '2', '2008-09-21', '0'), ('7327', '211.137.63.72', '', '', '2', '2008-09-21', '0'), ('7328', '125.71.40.237', '', '', '1', '2008-09-21', '0'), ('7329', '116.19.3.98', '', '', '1', '2008-09-21', '0'), ('7330', '121.8.83.98', '', '', '2', '2008-09-21', '0'), ('7331', '119.129.40.179', '', '', '1', '2008-09-21', '0'), ('7332', '218.2.112.186', '', '', '1', '2008-09-21', '0'), ('7333', '218.200.225.15', '', '', '4', '2008-09-21', '0'), ('7334', '194.145.200.46', '', '', '22', '2008-09-21', '0'), ('7335', '123.4.50.156', '', '', '3', '2008-09-21', '0'), ('7336', '116.28.18.161', '', '', '3', '2008-09-21', '0'), ('7337', '59.34.207.37', '', '', '1', '2008-09-21', '0'), ('7338', '58.63.134.115', '', '', '1', '2008-09-21', '0'), ('7339', '59.35.18.227', '', '', '1', '2008-09-21', '0'), ('7340', '202.75.133.39', '', '', '4', '2008-09-21', '0'), ('7341', '218.200.224.218', '', '', '1', '2008-09-21', '0'), ('7342', '59.35.84.106', '', '', '1', '2008-09-21', '0'), ('7343', '58.255.56.22', '', '', '3', '2008-09-21', '0'), ('7344', '219.137.87.184', '', '', '2', '2008-09-21', '0'), ('7345', '220.206.235.6', '', '', '1', '2008-09-21', '0'), ('7346', '221.204.113.241', '', '', '2', '2008-09-21', '0'), ('7347', '121.12.248.91', '', '', '1', '2008-09-21', '0'), ('7348', '219.134.43.139', '', '', '1', '2008-09-21', '0'), ('7349', '211.137.163.107', '', '', '4', '2008-09-21', '0'), ('7350', '202.104.35.166', '', '', '5', '2008-09-21', '0'), ('7351', '116.194.25.153', '', '', '2', '2008-09-21', '0'), ('7352', '116.16.91.157', '', '', '1', '2008-09-21', '0'), ('7353', '218.14.82.102', '', '', '1', '2008-09-21', '0'), ('7354', '119.123.20.245', '', '', '1', '2008-09-21', '0'), ('7355', '59.35.147.85', '', '', '1', '2008-09-21', '0'), ('7356', '121.35.240.156', '', '', '9', '2008-09-21', '0'), ('7357', '219.130.2.158', '', '', '1', '2008-09-21', '0'), ('7358', '125.84.222.5', '', '', '10', '2008-09-21', '0'), ('7359', '211.136.75.73', '', '', '2', '2008-09-21', '0'), ('7360', '59.174.122.51', '', '', '4', '2008-09-21', '0'), ('7361', '218.58.156.157', '', '', '1', '2008-09-21', '0'), ('7362', '120.32.197.131', '', '', '1', '2008-09-21', '0'), ('7363', '116.27.195.64', '', '', '1', '2008-09-21', '0'), ('7364', '116.21.80.53', '', '', '2', '2008-09-21', '0'), ('7365', '114.138.245.180', '', '', '1', '2008-09-21', '0'), ('7367', '117.85.209.95', '', '', '2', '2008-09-21', '0'), ('7368', '58.60.129.246', '', '', '4', '2008-09-21', '0'), ('7369', '58.63.121.2', '', '', '3', '2008-09-22', '0'), ('7370', '61.145.35.231', '', '', '1', '2008-09-22', '0'), ('7371', '220.206.246.2', '', '', '1', '2008-09-22', '0'), ('7372', '219.134.216.124', '', '', '1', '2008-09-22', '0'), ('7373', '220.206.255.6', '', '', '1', '2008-09-22', '0'), ('7374', '59.36.52.77', '', '', '2', '2008-09-22', '0'), ('7375', '220.243.111.208', '', '', '1', '2008-09-22', '0'), ('7376', '219.73.96.219', '', '', '2', '2008-09-22', '0'), ('7377', '58.71.200.39', '', '', '1', '2008-09-22', '0'), ('7378', '59.42.55.112', '', '', '1', '2008-09-22', '0'), ('7379', '218.13.73.161', '', '', '1', '2008-09-22', '0'), ('7380', '116.24.37.230', '', '', '2', '2008-09-22', '0'), ('7381', '125.91.141.98', '', '', '2', '2008-09-22', '0'), ('7382', '217.148.51.244', '', '', '1', '2008-09-22', '0'), ('7383', '211.136.158.160', '', '', '1', '2008-09-22', '0'), ('7384', '119.0.142.52', '', '', '2', '2008-09-22', '0'), ('7385', '220.206.246.14', '', '', '1', '2008-09-22', '0'), ('7386', '125.81.153.236', '', '', '2', '2008-09-22', '0'), ('7387', '202.91.19.194', '', '', '1', '2008-09-22', '0'), ('7388', '218.200.224.167', '', '', '2', '2008-09-22', '0'), ('7389', '218.56.40.166', '', '', '1', '2008-09-22', '0'), ('7390', '58.61.231.71', '', '', '1', '2008-09-22', '0'), ('7391', '61.136.175.37', '', '', '1', '2008-09-22', '0'), ('7392', '116.25.208.37', '', '', '1', '2008-09-22', '0'), ('7393', '195.189.142.213', '', '', '1', '2008-09-22', '0'), ('7394', '121.33.146.231', '', '', '2', '2008-09-22', '0'), ('7395', '61.178.152.169', '', '', '1', '2008-09-22', '0'), ('7396', '219.136.222.182', '', '', '1', '2008-09-22', '0'), ('7397', '61.157.133.78', '', '', '1', '2008-09-22', '0'), ('7398', '218.19.65.216', '', '', '2', '2008-09-22', '0'), ('7399', '218.16.94.88', '', '', '4', '2008-09-22', '0'), ('7400', '119.128.92.93', '', '', '1', '2008-09-22', '0'), ('7401', '123.155.34.113', '', '', '1', '2008-09-22', '0'), ('7402', '218.205.249.159', '', '', '1', '2008-09-22', '0'), ('7403', '219.143.155.85', '', '', '1', '2008-09-22', '0'), ('7404', '200.71.162.128', '', '', '1', '2008-09-22', '0'), ('7405', '117.24.168.177', '', '', '1', '2008-09-22', '0'), ('7406', '116.20.167.136', '', '', '1', '2008-09-22', '0'), ('7407', '59.40.121.219', '', '', '1', '2008-09-22', '0'), ('7408', '58.37.181.67', '', '', '1', '2008-09-22', '0'), ('7409', '221.218.145.183', '', '', '1', '2008-09-22', '0'), ('7410', '116.18.117.164', '', '', '4', '2008-09-22', '0'), ('7411', '125.93.46.22', '', '', '1', '2008-09-22', '0'), ('7412', '219.153.62.105', '', '', '1', '2008-09-22', '0'), ('7413', '117.85.241.225', '', '', '1', '2008-09-22', '0'), ('7414', '122.0.245.204', '', '', '1', '2008-09-22', '0'), ('7415', '222.132.208.231', '', '', '1', '2008-09-22', '0'), ('7416', '125.92.40.204', '', '', '5', '2008-09-22', '0'), ('7417', '220.243.110.220', '', '', '3', '2008-09-22', '0'), ('7418', '221.218.170.130', '', '', '1', '2008-09-22', '0'), ('7419', '122.4.173.191', '', '', '24', '2008-09-22', '0'), ('7420', '218.20.53.188', '', '', '3', '2008-09-22', '0'), ('7421', '217.168.3.241', '', '', '1', '2008-09-22', '0'), ('7422', '211.136.158.202', '', '', '2', '2008-09-22', '0'), ('7423', '211.139.162.167', '', '', '23', '2008-09-22', '0'), ('7424', '61.132.44.150', '', '', '1', '2008-09-22', '0'), ('7425', '211.136.75.149', '', '', '3', '2008-09-22', '0'), ('7426', '121.205.121.62', '', '', '1', '2008-09-22', '0'), ('7427', '119.128.227.42', '', '', '10', '2008-09-22', '0'), ('7428', '119.122.141.121', '', '', '1', '2008-09-22', '0'), ('7429', '123.136.1.115', '', '', '2', '2008-09-22', '0'), ('7430', '222.218.10.212', '', '', '1', '2008-09-22', '0'), ('7431', '59.35.130.235', '', '', '1', '2008-09-22', '0'), ('7432', '121.33.108.14', '', '', '1', '2008-09-22', '0'), ('7433', '211.136.75.218', '', '', '1', '2008-09-22', '0'), ('7434', '61.143.147.18', '', '', '2', '2008-09-22', '0'), ('7435', '123.53.81.183', '', '', '5', '2008-09-22', '0'), ('7436', '211.138.227.224', '', '', '2', '2008-09-22', '0'), ('7437', '222.217.195.2', '', '', '1', '2008-09-22', '0'), ('7438', '218.28.7.118', '', '', '1', '2008-09-22', '0'), ('7439', '221.1.80.44', '', '', '1', '2008-09-22', '0'), ('7440', '218.205.252.70', '', '', '1', '2008-09-22', '0'), ('7441', '219.128.254.138', '', '', '2', '2008-09-22', '0'), ('7442', '125.108.118.66', '', '', '2', '2008-09-22', '0'), ('7443', '202.105.66.51', '', '', '2', '2008-09-22', '0'), ('7444', '116.4.78.200', '', '', '1', '2008-09-22', '0'), ('7445', '123.9.225.123', '', '', '2', '2008-09-22', '0'), ('7446', '220.206.246.11', '', '', '1', '2008-09-22', '0'), ('7447', '124.65.141.170', '', '', '1', '2008-09-22', '0'), ('7448', '59.35.160.83', '', '', '1', '2008-09-22', '0'), ('7450', '116.21.248.211', '', '', '1', '2008-09-22', '0'), ('7451', '59.49.241.100', '', '', '6', '2008-09-22', '0'), ('7452', '211.137.62.207', '', '', '1', '2008-09-23', '0'), ('7453', '211.139.16.60', '', '', '1', '2008-09-23', '0'), ('7454', '211.95.168.250', '', '', '6', '2008-09-23', '0'), ('7455', '125.84.220.101', '', '', '3', '2008-09-23', '0'), ('7456', '222.212.107.28', '', '', '1', '2008-09-23', '0'), ('7457', '221.13.69.8', '', '', '1', '2008-09-23', '0'), ('7458', '121.205.46.71', '', '', '1', '2008-09-23', '0'), ('7459', '58.62.71.43', '', '', '1', '2008-09-23', '0'), ('7460', '58.60.139.84', '', '', '1', '2008-09-23', '0'), ('7461', '116.60.98.48', '', '', '2', '2008-09-23', '0'), ('7462', '211.138.227.107', '', '', '2', '2008-09-23', '0'), ('7463', '116.21.213.220', '', '', '1', '2008-09-23', '0'), ('7464', '58.63.163.74', '', '', '2', '2008-09-23', '0'), ('7465', '218.14.89.246', '', '', '1', '2008-09-23', '0'), ('7466', '119.138.239.6', '', '', '2', '2008-09-23', '0'), ('7467', '202.75.133.20', '', '', '3', '2008-09-23', '0'), ('7468', '202.75.133.28', '', '', '3', '2008-09-23', '0'), ('7469', '222.197.188.247', '', '', '1', '2008-09-23', '0'), ('7470', '202.75.133.26', '', '', '4', '2008-09-23', '0'), ('7471', '116.16.228.163', '', '', '1', '2008-09-23', '0'), ('7472', '122.194.157.40', '', '', '1', '2008-09-23', '0'), ('7473', '58.60.111.237', '', '', '1', '2008-09-23', '0'), ('7474', '58.208.203.79', '', '', '1', '2008-09-23', '0'), ('7475', '202.75.133.40', '', '', '2', '2008-09-23', '0'), ('7476', '122.154.101.4', '', '', '14', '2008-09-23', '0'), ('7477', '122.96.202.206', '', '', '1', '2008-09-23', '0'), ('7478', '125.92.6.188', '', '', '1', '2008-09-23', '0'), ('7479', '218.200.224.82', '', '', '1', '2008-09-23', '0'), ('7480', '122.157.21.156', '', '', '1', '2008-09-23', '0'), ('7481', '58.252.106.42', '', '', '1', '2008-09-23', '0'), ('7482', '211.136.158.224', '', '', '4', '2008-09-23', '0'), ('7483', '61.145.138.12', '', '', '1', '2008-09-23', '0'), ('7484', '59.41.191.2', '', '', '1', '2008-09-23', '0'), ('7485', '59.42.58.148', '', '', '1', '2008-09-23', '0'), ('7486', '61.143.85.128', '', '', '3', '2008-09-23', '0'), ('7487', '123.113.72.239', '', '', '2', '2008-09-23', '0'), ('7488', '59.41.224.115', '', '', '1', '2008-09-23', '0'), ('7489', '121.11.220.9', '', '', '6', '2008-09-23', '0'), ('7490', '211.145.100.93', '', '', '1', '2008-09-23', '0'), ('7491', '202.173.245.91', '', '', '1', '2008-09-23', '0'), ('7492', '220.181.24.100', '', '', '1', '2008-09-23', '0'), ('7493', '218.19.2.188', '', '', '2', '2008-09-23', '0'), ('7494', '58.61.21.31', '', '', '1', '2008-09-23', '0'), ('7495', '121.11.113.147', '', '', '2', '2008-09-23', '0'), ('7496', '119.123.153.64', '', '', '2', '2008-09-23', '0'), ('7497', '211.137.62.224', '', '', '2', '2008-09-23', '0'), ('7498', '58.213.213.132', '', '', '1', '2008-09-23', '0'), ('7499', '218.87.221.196', '', '', '1', '2008-09-23', '0'), ('7500', '59.33.27.89', '', '', '8', '2008-09-23', '0'), ('7501', '203.142.123.55', '', '', '1', '2008-09-23', '0'), ('7502', '125.127.67.143', '', '', '3', '2008-09-23', '0'), ('7503', '211.147.253.179', '', '', '2', '2008-09-23', '0'), ('7504', '218.85.24.231', '', '', '1', '2008-09-23', '0'), ('7505', '222.45.85.202', '', '', '1', '2008-09-23', '0'), ('7506', '124.207.112.118', '', '', '2', '2008-09-23', '0'), ('7507', '219.132.100.122', '', '', '2', '2008-09-23', '0'), ('7508', '125.84.179.29', '', '', '1', '2008-09-23', '0'), ('7509', '222.90.17.20', '', '', '2', '2008-09-23', '0'), ('7510', '219.136.40.246', '', '', '1', '2008-09-23', '0'), ('7511', '116.7.38.63', '', '', '1', '2008-09-23', '0'), ('7512', '123.175.121.33', '', '', '1', '2008-09-23', '0'), ('7513', '121.34.109.117', '', '', '1', '2008-09-23', '0'), ('7514', '218.20.243.35', '', '', '4', '2008-09-23', '0'), ('7515', '221.204.112.212', '', '', '1', '2008-09-23', '0'), ('7516', '116.199.93.87', '', '', '6', '2008-09-23', '0'), ('7517', '58.100.130.95', '', '', '2', '2008-09-23', '0'), ('7518', '119.123.19.38', '', '', '1', '2008-09-23', '0'), ('7519', '58.60.119.17', '', '', '1', '2008-09-23', '0'), ('7520', '116.30.32.131', '', '', '2', '2008-09-23', '0'), ('7521', '219.137.201.220', '', '', '2', '2008-09-23', '0'), ('7522', '116.30.0.83', '', '', '2', '2008-09-23', '0'), ('7523', '58.47.166.43', '', '', '1', '2008-09-23', '0'), ('7524', '117.87.165.182', '', '', '2', '2008-09-23', '0'), ('7525', '222.213.124.248', '', '', '1', '2008-09-23', '0'), ('7526', '219.143.153.247', '', '', '2', '2008-09-23', '0'), ('7527', '125.95.234.209', '', '', '1', '2008-09-23', '0'), ('7528', '222.70.235.168', '', '', '1', '2008-09-23', '0'), ('7529', '58.253.151.39', '', '', '1', '2008-09-23', '0'), ('7530', '121.15.94.229', '', '', '1', '2008-09-23', '0'), ('7531', '58.39.173.24', '', '', '1', '2008-09-23', '0'), ('7532', '219.133.17.205', '', '', '3', '2008-09-23', '0'), ('7533', '119.123.83.233', '', '', '1', '2008-09-23', '0'), ('7534', '211.145.70.232', '', '', '1', '2008-09-23', '0'), ('7535', '119.133.42.132', '', '', '27', '2008-09-23', '0'), ('7536', '220.205.19.25', '', '', '1', '2008-09-23', '0'), ('7537', '119.39.144.61', '', '', '1', '2008-09-23', '0'), ('7538', '116.16.169.132', '', '', '2', '2008-09-23', '0'), ('7539', '60.53.16.27', '', '', '1', '2008-09-23', '0'), ('7540', '117.28.24.63', '', '', '1', '2008-09-23', '0'), ('7541', '117.24.121.20', '', '', '1', '2008-09-23', '0'), ('7542', '122.255.101.24', '', '', '1', '2008-09-23', '0'), ('7543', '121.23.219.217', '', '', '1', '2008-09-23', '0'), ('7544', '116.21.191.184', '', '', '1', '2008-09-23', '0'), ('7545', '125.121.91.224', '', '', '1', '2008-09-23', '0'), ('7546', '60.4.225.215', '', '', '5', '2008-09-23', '0'), ('7547', '221.232.198.162', '', '', '2', '2008-09-23', '0'), ('7548', '203.113.138.122', '', '', '1', '2008-09-23', '0'), ('7549', '219.132.244.36', '', '', '1', '2008-09-23', '0'), ('7550', '121.13.221.226', '', '', '15', '2008-09-23', '0'), ('7551', '119.146.193.137', '', '', '1', '2008-09-23', '0'), ('7552', '211.136.75.71', '', '', '1', '2008-09-23', '0'), ('7553', '123.175.179.228', '', '', '2', '2008-09-23', '0'), ('7554', '123.53.76.110', '', '', '1', '2008-09-23', '0'), ('7555', '202.56.7.167', '', '', '2', '2008-09-23', '0'), ('7556', '220.173.193.233', '', '', '1', '2008-09-23', '0'), ('7557', '218.207.136.3', '', '', '1', '2008-09-23', '0'), ('7558', '124.92.133.126', '', '', '1', '2008-09-24', '0'), ('7559', '220.206.246.18', '', '', '1', '2008-09-24', '0'), ('7560', '58.59.255.115', '', '', '1', '2008-09-24', '0'), ('7561', '218.205.249.37', '', '', '1', '2008-09-24', '0'), ('7562', '211.137.63.124', '', '', '1', '2008-09-24', '0'), ('7563', '220.192.3.80', '', '', '2', '2008-09-24', '0'), ('7564', '222.84.149.37', '', '', '1', '2008-09-24', '0'), ('7565', '202.160.179.136', '', '', '1', '2008-09-24', '0'), ('7566', '219.152.241.227', '', '', '3', '2008-09-24', '0'), ('7567', '58.63.115.126', '', '', '1', '2008-09-24', '0'), ('7568', '124.6.202.206', '', '', '5', '2008-09-24', '0'), ('7569', '123.136.10.48', '', '', '1', '2008-09-24', '0'), ('7570', '218.17.241.157', '', '', '1', '2008-09-24', '0'), ('7571', '202.75.133.25', '', '', '2', '2008-09-24', '0'), ('7572', '118.231.145.44', '', '', '2', '2008-09-24', '0'), ('7573', '61.186.171.217', '', '', '1', '2008-09-24', '0'), ('7574', '60.4.88.209', '', '', '2', '2008-09-24', '0'), ('7575', '58.213.223.184', '', '', '5', '2008-09-24', '0'), ('7576', '116.227.72.218', '', '', '1', '2008-09-24', '0'), ('7577', '203.142.121.16', '', '', '1', '2008-09-24', '0'), ('7578', '123.175.201.115', '', '', '17', '2008-09-24', '0'), ('7579', '58.55.224.220', '', '', '1', '2008-09-24', '0'), ('7580', '218.207.136.5', '', '', '1', '2008-09-24', '0'), ('7581', '218.207.136.13', '', '', '2', '2008-09-24', '0'), ('7582', '123.121.193.88', '', '', '1', '2008-09-24', '0'), ('7583', '59.42.59.141', '', '', '2', '2008-09-24', '0'), ('7584', '119.123.105.144', '', '', '1', '2008-09-24', '0'), ('7585', '59.40.251.128', '', '', '1', '2008-09-24', '0'), ('7586', '218.94.124.41', '', '', '1', '2008-09-24', '0'), ('7587', '58.252.44.229', '', '', '24', '2008-09-24', '0'), ('7588', '121.41.191.190', '', '', '1', '2008-09-24', '0'), ('7589', '211.136.75.29', '', '', '2', '2008-09-24', '0'), ('7590', '222.84.43.197', '', '', '2', '2008-09-24', '0'), ('7591', '222.216.82.2', '', '', '1', '2008-09-24', '0'), ('7592', '60.215.113.88', '', '', '1', '2008-09-24', '0'), ('7593', '218.72.190.25', '', '', '1', '2008-09-24', '0'), ('7594', '211.137.37.139', '', '', '3', '2008-09-24', '0'), ('7595', '118.100.185.85', '', '', '1', '2008-09-24', '0'), ('7596', '222.241.216.52', '', '', '27', '2008-09-24', '0'), ('7597', '58.255.214.128', '', '', '1', '2008-09-24', '0'), ('7598', '218.205.249.19', '', '', '1', '2008-09-24', '0'), ('7599', '125.45.107.58', '', '', '3', '2008-09-24', '0'), ('7600', '59.37.136.208', '', '', '2', '2008-09-24', '0'), ('7601', '221.204.115.237', '', '', '2', '2008-09-24', '0'), ('7602', '221.216.1.69', '', '', '2', '2008-09-24', '0'), ('7603', '222.217.69.231', '', '', '1', '2008-09-24', '0'), ('7604', '211.137.62.193', '', '', '1', '2008-09-24', '0'), ('7605', '211.138.227.118', '', '', '2', '2008-09-24', '0'), ('7606', '211.136.158.252', '', '', '2', '2008-09-24', '0'), ('7607', '219.128.183.157', '', '', '1', '2008-09-24', '0'), ('7608', '61.136.144.103', '', '', '1', '2008-09-24', '0'), ('7609', '222.130.219.242', '', '', '1', '2008-09-24', '0'), ('7610', '60.209.15.23', '', '', '1', '2008-09-24', '0'), ('7611', '58.63.128.54', '', '', '1', '2008-09-24', '0'), ('7612', '116.233.211.225', '', '', '1', '2008-09-24', '0'), ('7613', '123.136.10.147', '', '', '1', '2008-09-24', '0'), ('7614', '218.16.251.102', '', '', '2', '2008-09-24', '0'), ('7615', '121.229.116.59', '', '', '11', '2008-09-24', '0'), ('7616', '59.39.177.34', '', '', '1', '2008-09-24', '0'), ('7617', '220.162.96.99', '', '', '1', '2008-09-24', '0'), ('7618', '124.79.179.15', '', '', '1', '2008-09-24', '0'), ('7619', '123.175.186.41', '', '', '2', '2008-09-24', '0'), ('7620', '58.255.133.80', '', '', '3', '2008-09-24', '0'), ('7621', '123.116.150.39', '', '', '1', '2008-09-24', '0'), ('7622', '119.128.164.138', '', '', '1', '2008-09-24', '0'), ('7623', '220.166.1.31', '', '', '2', '2008-09-24', '0'), ('7624', '60.205.109.240', '', '', '1', '2008-09-24', '0'), ('7625', '116.25.46.44', '', '', '1', '2008-09-24', '0'), ('7626', '218.85.231.245', '', '', '2', '2008-09-24', '0'), ('7627', '222.82.172.147', '', '', '1', '2008-09-24', '0'), ('7628', '218.13.173.20', '', '', '3', '2008-09-24', '0'), ('7629', '114.83.8.70', '', '', '3', '2008-09-24', '0'), ('7630', '117.36.11.111', '', '', '9', '2008-09-24', '0'), ('7631', '219.134.190.148', '', '', '23', '2008-09-24', '0'), ('7632', '59.56.235.184', '', '', '1', '2008-09-24', '0'), ('7633', '219.130.176.200', '', '', '1', '2008-09-24', '0'), ('7634', '125.90.101.57', '', '', '1', '2008-09-24', '0'), ('7635', '58.253.100.235', '', '', '1', '2008-09-24', '0'), ('7636', '125.120.138.184', '', '', '1', '2008-09-24', '0'), ('7637', '116.10.130.63', '', '', '1', '2008-09-24', '0'), ('7638', '222.88.24.251', '', '', '1', '2008-09-24', '0'), ('7639', '218.89.29.116', '', '', '1', '2008-09-24', '0'), ('7640', '117.65.35.38', '', '', '1', '2008-09-24', '0'), ('7641', '122.4.185.129', '', '', '20', '2008-09-24', '0'), ('7642', '218.94.136.179', '', '', '1', '2008-09-24', '0'), ('7643', '121.32.164.27', '', '', '3', '2008-09-24', '0'), ('7644', '116.24.37.249', '', '', '1', '2008-09-24', '0'), ('7645', '117.28.191.229', '', '', '1', '2008-09-24', '0'), ('7646', '211.136.75.105', '', '', '2', '2008-09-24', '0'), ('7647', '125.93.183.132', '', '', '2', '2008-09-24', '0'), ('7648', '123.117.86.159', '', '', '1', '2008-09-24', '0'), ('7649', '220.206.246.9', '', '', '3', '2008-09-24', '0'), ('7650', '119.129.211.169', '', '', '1', '2008-09-24', '0'), ('7651', '119.141.156.193', '', '', '2', '2008-09-24', '0'), ('7652', '116.76.41.213', '', '', '1', '2008-09-24', '0'), ('7653', '121.32.170.227', '', '', '1', '2008-09-24', '0'), ('7654', '117.27.105.236', '', '', '1', '2008-09-24', '0'), ('7655', '219.128.0.2', '', '', '1', '2008-09-24', '0'), ('7656', '121.13.83.130', '', '', '1', '2008-09-24', '0'), ('7657', '222.170.163.215', '', '', '1', '2008-09-24', '0'), ('7658', '221.137.33.12', '', '', '1', '2008-09-24', '0'), ('7659', '211.136.75.14', '', '', '3', '2008-09-24', '0'), ('7660', '119.128.224.235', '', '', '1', '2008-09-24', '0'), ('7661', '116.128.1.42', '', '', '1', '2008-09-24', '0'), ('7662', '121.15.43.227', '', '', '1', '2008-09-24', '0'), ('7663', '124.237.236.147', '', '', '1', '2008-09-24', '0'), ('7664', '124.92.133.214', '', '', '2', '2008-09-24', '0'), ('7665', '202.149.25.197', '', '', '2', '2008-09-24', '0'), ('7666', '211.138.227.237', '', '', '1', '2008-09-24', '0'), ('7667', '221.178.255.12', '', '', '1', '2008-09-24', '0'), ('7668', '123.61.166.202', '', '', '1', '2008-09-25', '0'), ('7669', '58.248.125.16', '', '', '1', '2008-09-25', '0'), ('7670', '116.26.166.243', '', '', '1', '2008-09-25', '0'), ('7671', '124.72.111.9', '', '', '1', '2008-09-25', '0'), ('7672', '61.144.83.198', '', '', '1', '2008-09-25', '0'), ('7673', '211.138.227.93', '', '', '1', '2008-09-25', '0'), ('7674', '59.35.82.83', '', '', '1', '2008-09-25', '0'), ('7675', '203.145.92.87', '', '', '1', '2008-09-25', '0'), ('7676', '116.4.29.23', '', '', '2', '2008-09-25', '0'), ('7677', '125.78.60.168', '', '', '1', '2008-09-25', '0'), ('7678', '211.138.227.57', '', '', '2', '2008-09-25', '0'), ('7679', '58.248.224.115', '', '', '2', '2008-09-25', '0'), ('7680', '219.137.176.38', '', '', '1', '2008-09-25', '0'), ('7681', '121.32.8.35', '', '', '1', '2008-09-25', '0'), ('7682', '220.206.246.8', '', '', '4', '2008-09-25', '0'), ('7683', '202.149.25.225', '', '', '2', '2008-09-25', '0'), ('7684', '116.16.217.60', '', '', '1', '2008-09-25', '0'), ('7685', '202.149.25.236', '', '', '1', '2008-09-25', '0'), ('7686', '60.183.55.17', '', '', '1', '2008-09-25', '0'), ('7687', '116.18.26.93', '', '', '1', '2008-09-25', '0'), ('7688', '202.160.178.221', '', '', '1', '2008-09-25', '0'), ('7689', '59.40.10.23', '', '', '2', '2008-09-25', '0'), ('7690', '220.206.246.48', '', '', '1', '2008-09-25', '0'), ('7691', '123.175.249.144', '', '', '17', '2008-09-25', '0'), ('7692', '119.146.192.30', '', '', '2', '2008-09-25', '0'), ('7693', '116.11.230.175', '', '', '1', '2008-09-25', '0'), ('7694', '61.144.20.42', '', '', '1', '2008-09-25', '0'), ('7695', '59.37.85.5', '', '', '1', '2008-09-25', '0'), ('7696', '220.178.24.138', '', '', '4', '2008-09-25', '0'), ('7697', '222.66.175.213', '', '', '1', '2008-09-25', '0'), ('7698', '125.84.222.85', '', '', '4', '2008-09-25', '0'), ('7699', '121.15.233.124', '', '', '1', '2008-09-25', '0'), ('7700', '119.122.118.228', '', '', '2', '2008-09-25', '0'), ('7701', '222.182.93.126', '', '', '1', '2008-09-25', '0'), ('7702', '219.137.136.135', '', '', '4', '2008-09-25', '0'), ('7703', '58.253.22.97', '', '', '1', '2008-09-25', '0'), ('7704', '211.138.227.44', '', '', '2', '2008-09-25', '0'), ('7705', '121.9.148.27', '', '', '2', '2008-09-25', '0'), ('7706', '123.180.10.192', '', '', '1', '2008-09-25', '0'), ('7707', '119.36.121.6', '', '', '1', '2008-09-25', '0'), ('7708', '60.166.170.194', '', '', '2', '2008-09-25', '0'), ('7709', '58.62.225.111', '', '', '1', '2008-09-25', '0'), ('7710', '116.19.65.160', '', '', '1', '2008-09-25', '0'), ('7711', '116.29.153.110', '', '', '1', '2008-09-25', '0'), ('7712', '211.136.75.127', '', '', '1', '2008-09-25', '0'), ('7713', '123.147.7.149', '', '', '2', '2008-09-25', '0'), ('7714', '220.206.246.22', '', '', '1', '2008-09-25', '0'), ('7715', '58.61.208.6', '', '', '1', '2008-09-25', '0'), ('7716', '58.61.233.35', '', '', '1', '2008-09-25', '0'), ('7717', '83.149.9.37', '', '', '1', '2008-09-25', '0'), ('7718', '219.131.121.22', '', '', '1', '2008-09-25', '0'), ('7719', '203.142.122.191', '', '', '2', '2008-09-25', '0'), ('7720', '219.93.152.31', '', '', '1', '2008-09-25', '0'), ('7721', '211.145.44.92', '', '', '3', '2008-09-25', '0'), ('7722', '121.206.28.45', '', '', '2', '2008-09-25', '0'), ('7723', '66.249.72.180', '', '', '39', '2008-09-25', '0'), ('7724', '119.141.189.186', '', '', '1', '2008-09-25', '0'), ('7725', '220.206.246.24', '', '', '2', '2008-09-25', '0'), ('7726', '121.8.10.248', '', '', '2', '2008-09-25', '0'), ('7727', '116.7.62.223', '', '', '1', '2008-09-25', '0'), ('7728', '219.135.184.43', '', '', '1', '2008-09-25', '0'), ('7729', '220.168.142.165', '', '', '15', '2008-09-25', '0'), ('7730', '218.20.31.98', '', '', '2', '2008-09-25', '0'), ('7731', '116.4.48.90', '', '', '1', '2008-09-25', '0'), ('7732', '222.213.124.131', '', '', '1', '2008-09-25', '0'), ('7733', '221.238.4.25', '', '', '1', '2008-09-25', '0'), ('7734', '195.74.84.165', '', '', '2', '2008-09-25', '0'), ('7735', '211.136.158.199', '', '', '1', '2008-09-25', '0'), ('7736', '221.213.184.161', '', '', '1', '2008-09-25', '0'), ('7737', '116.19.20.87', '', '', '1', '2008-09-25', '0'), ('7738', '218.1.85.26', '', '', '1', '2008-09-25', '0'), ('7739', '119.128.28.194', '', '', '1', '2008-09-25', '0'), ('7740', '221.227.105.100', '', '', '2', '2008-09-25', '0'), ('7741', '116.252.191.63', '', '', '1', '2008-09-25', '0'), ('7742', '123.119.38.59', '', '', '1', '2008-09-25', '0'), ('7743', '60.161.161.172', '', '', '1', '2008-09-25', '0'), ('7744', '219.153.181.129', '', '', '2', '2008-09-25', '0'), ('7745', '83.188.1.116', '', '', '2', '2008-09-25', '0'), ('7746', '211.137.62.232', '', '', '1', '2008-09-25', '0'), ('7747', '218.200.224.83', '', '', '3', '2008-09-25', '0'), ('7748', '125.93.29.67', '', '', '1', '2008-09-25', '0'), ('7749', '119.5.64.160', '', '', '1', '2008-09-25', '0'), ('7750', '125.91.123.115', '', '', '1', '2008-09-25', '0'), ('7751', '59.35.240.241', '', '', '1', '2008-09-25', '0'), ('7752', '117.85.10.194', '', '', '1', '2008-09-25', '0'), ('7753', '58.40.161.35', '', '', '1', '2008-09-25', '0'), ('7754', '116.11.143.81', '', '', '5', '2008-09-25', '0'), ('7755', '220.194.137.15', '', '', '3', '2008-09-25', '0'), ('7756', '219.130.14.155', '', '', '1', '2008-09-25', '0'), ('7757', '117.68.49.142', '', '', '1', '2008-09-25', '0'), ('7758', '220.206.239.1', '', '', '1', '2008-09-25', '0'), ('7759', '116.19.18.75', '', '', '1', '2008-09-25', '0'), ('7760', '220.206.235.42', '', '', '1', '2008-09-25', '0'), ('7761', '203.142.121.153', '', '', '1', '2008-09-25', '0'), ('7762', '218.200.224.202', '', '', '1', '2008-09-25', '0'), ('7763', '124.92.135.190', '', '', '1', '2008-09-25', '0'), ('7764', '121.77.197.73', '', '', '1', '2008-09-25', '0'), ('7765', '202.122.144.127', '', '', '1', '2008-09-25', '0'), ('7766', '121.63.28.85', '', '', '1', '2008-09-25', '0'), ('7767', '217.65.194.4', '', '', '4', '2008-09-25', '0'), ('7768', '58.60.89.126', '', '', '1', '2008-09-25', '0'), ('7769', '220.206.246.59', '', '', '1', '2008-09-26', '0'), ('7770', '119.129.160.102', '', '', '1', '2008-09-26', '0'), ('7771', '218.13.136.110', '', '', '2', '2008-09-26', '0'), ('7772', '221.10.45.250', '', '', '1', '2008-09-26', '0'), ('7773', '211.137.63.186', '', '', '3', '2008-09-26', '0'), ('7774', '211.136.158.217', '', '', '2', '2008-09-26', '0'), ('7775', '61.160.70.154', '', '', '2', '2008-09-26', '0'), ('7776', '222.213.126.68', '', '', '1', '2008-09-26', '0'), ('7777', '58.63.103.53', '', '', '1', '2008-09-26', '0'), ('7778', '203.208.60.134', '', '', '3525', '2008-09-26', '1'), ('7779', '59.44.117.194', '', '', '25', '2008-09-26', '0'), ('7780', '116.23.148.8', '', '', '1', '2008-09-26', '0'), ('7781', '218.205.249.224', '', '', '2', '2008-09-26', '0'), ('7782', '211.137.63.141', '', '', '1', '2008-09-26', '0'), ('7783', '116.25.39.197', '', '', '1', '2008-09-26', '0'), ('7784', '211.138.227.159', '', '', '1', '2008-09-26', '0'), ('7785', '211.138.227.129', '', '', '1', '2008-09-26', '0'), ('7786', '116.24.26.28', '', '', '1', '2008-09-26', '0'), ('7787', '61.142.114.189', '', '', '3', '2008-09-26', '0'), ('7788', '211.137.62.247', '', '', '2', '2008-09-26', '0'), ('7789', '124.161.17.176', '', '', '1', '2008-09-26', '0'), ('7790', '222.172.254.128', '', '', '1', '2008-09-26', '0'), ('7791', '209.183.32.17', '', '', '1', '2008-09-26', '0'), ('7792', '58.25.243.242', '', '', '1', '2008-09-26', '0'), ('7793', '211.136.75.111', '', '', '1', '2008-09-26', '0'), ('7794', '220.185.196.15', '', '', '1', '2008-09-26', '0'), ('7795', '219.131.123.202', '', '', '1', '2008-09-26', '0'), ('7796', '59.36.21.29', '', '', '1', '2008-09-26', '0'), ('7797', '211.137.251.132', '', '', '2', '2008-09-26', '0'), ('7798', '58.60.232.49', '', '', '1', '2008-09-26', '0'), ('7799', '121.13.242.162', '', '', '2', '2008-09-26', '0'), ('7800', '211.138.227.23', '', '', '1', '2008-09-26', '0'), ('7801', '59.39.191.50', '', '', '1', '2008-09-26', '0'), ('7802', '60.4.241.37', '', '', '1', '2008-09-26', '0'), ('7803', '116.4.20.154', '', '', '1', '2008-09-26', '0'), ('7804', '202.103.141.116', '', '', '17', '2008-09-26', '0'), ('7805', '218.19.198.110', '', '', '1', '2008-09-26', '0'), ('7806', '125.86.93.147', '', '', '1', '2008-09-26', '0'), ('7807', '218.19.67.224', '', '', '1', '2008-09-26', '0'), ('7808', '59.33.202.95', '', '', '2', '2008-09-26', '0'), ('7809', '116.31.13.87', '', '', '1', '2008-09-26', '0'), ('7810', '61.140.30.87', '', '', '1', '2008-09-26', '0'), ('7811', '220.206.246.3', '', '', '1', '2008-09-26', '0'), ('7812', '64.203.192.105', '', '', '1', '2008-09-26', '0'), ('7813', '116.25.227.108', '', '', '5', '2008-09-26', '0'), ('7814', '218.6.67.118', '', '', '1', '2008-09-26', '0'), ('7815', '118.113.18.162', '', '', '1', '2008-09-26', '0'), ('7816', '195.189.143.53', '', '', '1', '2008-09-26', '0'), ('7817', '124.88.155.135', '', '', '1', '2008-09-26', '0'), ('7818', '61.157.235.119', '', '', '3', '2008-09-26', '0'), ('7819', '122.70.53.155', '', '', '1', '2008-09-26', '0'), ('7820', '59.34.64.41', '', '', '1', '2008-09-26', '0'), ('7821', '58.253.49.218', '', '', '1', '2008-09-26', '0'), ('7822', '116.18.158.209', '', '', '1', '2008-09-26', '0'), ('7823', '222.129.88.34', '', '', '7', '2008-09-26', '0'), ('7824', '125.107.76.240', '', '', '1', '2008-09-26', '0'), ('7825', '218.207.136.2', '', '', '1', '2008-09-26', '0'), ('7826', '125.92.133.143', '', '', '1', '2008-09-26', '0'), ('7827', '61.140.250.144', '', '', '1', '2008-09-26', '0'), ('7828', '218.6.225.130', '', '', '1', '2008-09-26', '0'), ('7829', '220.206.246.42', '', '', '2', '2008-09-26', '0'), ('7830', '211.137.63.73', '', '', '2', '2008-09-26', '0'), ('7831', '208.131.186.19', '', '', '2', '2008-09-26', '0'), ('7832', '122.53.95.125', '', '', '1', '2008-09-26', '0'), ('7833', '116.21.4.96', '', '', '1', '2008-09-26', '0'), ('7834', '219.129.213.129', '', '', '2', '2008-09-26', '0'), ('7835', '116.4.139.203', '', '', '1', '2008-09-26', '0'), ('7836', '123.136.5.80', '', '', '1', '2008-09-26', '0'), ('7837', '218.18.196.44', '', '', '1', '2008-09-26', '0'), ('7838', '203.208.60.102', '', '', '3', '2008-09-26', '0'), ('7839', '203.208.60.109', '', '', '3', '2008-09-26', '0'), ('7840', '203.208.60.20', '', '', '2', '2008-09-26', '0'), ('7841', '203.208.60.17', '', '', '2', '2008-09-26', '0'), ('7842', '203.208.60.143', '', '', '5', '2008-09-26', '0'), ('7843', '203.208.60.41', '', '', '3', '2008-09-26', '0'), ('7844', '203.208.60.111', '', '', '5', '2008-09-26', '0'), ('7845', '203.208.60.141', '', '', '3', '2008-09-26', '0'), ('7846', '203.208.60.105', '', '', '2', '2008-09-26', '0'), ('7847', '203.208.60.116', '', '', '3', '2008-09-26', '0'), ('7848', '203.208.60.118', '', '', '1', '2008-09-26', '0'), ('7849', '203.208.60.19', '', '', '4', '2008-09-26', '0'), ('7850', '203.208.60.43', '', '', '6', '2008-09-26', '0'), ('7851', '203.208.60.49', '', '', '3', '2008-09-26', '0'), ('7852', '203.208.60.113', '', '', '2', '2008-09-26', '0'), ('7853', '203.208.60.106', '', '', '2', '2008-09-26', '0'), ('7854', '203.208.60.130', '', '', '2', '2008-09-26', '0'), ('7855', '203.208.60.103', '', '', '2', '2008-09-26', '0'), ('7856', '203.208.60.147', '', '', '1', '2008-09-26', '0'), ('7857', '203.208.60.51', '', '', '2', '2008-09-26', '0'), ('7858', '220.189.35.187', '', '', '3', '2008-09-26', '0'), ('7859', '203.208.60.133', '', '', '1', '2008-09-26', '0'), ('7860', '203.208.60.101', '', '', '2', '2008-09-26', '0'), ('7861', '203.208.60.3', '', '', '3', '2008-09-26', '0'), ('7862', '203.208.60.98', '', '', '1', '2008-09-26', '0'), ('7863', '203.208.60.33', '', '', '1', '2008-09-26', '0'), ('7864', '203.208.60.15', '', '', '2', '2008-09-26', '0'), ('7865', '203.208.60.132', '', '', '3', '2008-09-26', '0'), ('7866', '203.208.60.46', '', '', '3', '2008-09-26', '0'), ('7867', '203.208.60.104', '', '', '2', '2008-09-26', '0'), ('7868', '203.208.60.11', '', '', '2', '2008-09-26', '0'), ('7869', '203.208.60.136', '', '', '1', '2008-09-26', '0'), ('7870', '203.208.60.131', '', '', '1', '2008-09-26', '0'), ('7871', '203.208.60.120', '', '', '1', '2008-09-26', '0'), ('7872', '203.208.60.108', '', '', '1', '2008-09-26', '0'), ('7873', '203.208.60.145', '', '', '2', '2008-09-26', '0'), ('7874', '203.208.60.16', '', '', '1', '2008-09-26', '0'), ('7875', '203.208.60.135', '', '', '1', '2008-09-26', '0'), ('7876', '222.211.129.122', '', '', '1', '2008-09-26', '0'), ('7877', '203.208.60.122', '', '', '3', '2008-09-26', '0'), ('7878', '203.208.60.42', '', '', '3', '2008-09-26', '0'), ('7879', '203.208.60.144', '', '', '3', '2008-09-26', '0'), ('7880', '203.208.60.107', '', '', '1', '2008-09-26', '0'), ('7881', '203.208.60.44', '', '', '1', '2008-09-26', '0'), ('7882', '125.95.154.173', '', '', '1', '2008-09-26', '0'), ('7883', '116.28.18.54', '', '', '1', '2008-09-26', '0'), ('7884', '211.138.31.7', '', '', '3', '2008-09-26', '0'), ('7885', '219.143.128.78', '', '', '1', '2008-09-26', '0'), ('7886', '219.234.252.188', '', '', '1', '2008-09-26', '0'), ('7887', '61.172.166.48', '', '', '1', '2008-09-26', '0'), ('7888', '124.166.241.150', '', '', '1', '2008-09-26', '0'), ('7889', '121.228.143.180', '', '', '2', '2008-09-26', '0'), ('7890', '58.221.227.22', '', '', '1', '2008-09-26', '0'), ('7891', '125.95.5.173', '', '', '1', '2008-09-26', '0'), ('7892', '58.51.89.193', '', '', '1', '2008-09-26', '0'), ('7893', '218.90.163.234', '', '', '3', '2008-09-26', '0'), ('7894', '211.139.16.62', '', '', '2', '2008-09-26', '0'), ('7895', '220.206.246.40', '', '', '1', '2008-09-26', '0'), ('7896', '220.206.235.71', '', '', '2', '2008-09-26', '0'), ('7897', '222.69.229.224', '', '', '1', '2008-09-26', '0'), ('7898', '59.60.111.121', '', '', '2', '2008-09-26', '0'), ('7899', '220.206.246.13', '', '', '3', '2008-09-26', '0'), ('7900', '211.138.227.133', '', '', '1', '2008-09-26', '0'), ('7901', '59.39.148.183', '', '', '1', '2008-09-26', '0'), ('7902', '116.24.211.96', '', '', '2', '2008-09-26', '0'), ('7903', '61.185.219.83', '', '', '13', '2008-09-26', '0'), ('7904', '123.53.33.145', '', '', '1', '2008-09-26', '0'), ('7905', '121.35.29.99', '', '', '1', '2008-09-26', '0'), ('7906', '119.163.114.27', '', '', '1', '2008-09-26', '0'), ('7907', '211.138.218.60', '', '', '2', '2008-09-26', '0'), ('7908', '123.132.10.87', '', '', '3', '2008-09-26', '0'), ('7909', '121.234.239.162', '', '', '1', '2008-09-26', '0'), ('7910', '60.30.66.130', '', '', '7', '2008-09-26', '0'), ('7911', '211.139.145.213', '', '', '2', '2008-09-26', '0'), ('7912', '121.227.0.30', '', '', '1', '2008-09-26', '0'), ('7913', '119.255.28.98', '', '', '2', '2008-09-26', '0'), ('7914', '125.78.133.184', '', '', '1', '2008-09-26', '0'), ('7915', '118.147.58.116', '', '', '1', '2008-09-26', '0'), ('7916', '122.5.215.140', '', '', '1', '2008-09-26', '0'), ('7917', '119.146.193.20', '', '', '1', '2008-09-26', '0'), ('7918', '221.216.179.156', '', '', '1', '2008-09-26', '0'), ('7919', '218.82.197.207', '', '', '1', '2008-09-26', '0'), ('7920', '222.79.131.174', '', '', '1', '2008-09-26', '0'), ('7921', '211.136.75.126', '', '', '1', '2008-09-26', '0'), ('7922', '125.91.138.38', '', '', '1', '2008-09-26', '0'), ('7923', '116.204.242.57', '', '', '3', '2008-09-26', '0'), ('7924', '211.137.62.243', '', '', '2', '2008-09-26', '0'), ('7925', '222.130.236.193', '', '', '1', '2008-09-26', '0'), ('7926', '222.131.1.238', '', '', '1', '2008-09-26', '0'), ('7927', '211.138.227.16', '', '', '2', '2008-09-26', '0'), ('7928', '221.0.113.189', '', '', '6', '2008-09-26', '0'), ('7929', '218.13.226.174', '', '', '1', '2008-09-26', '0'), ('7930', '58.62.39.38', '', '', '1', '2008-09-26', '0'), ('7931', '123.159.30.80', '', '', '1', '2008-09-26', '0'), ('7932', '195.189.142.212', '', '', '1', '2008-09-26', '0'), ('7933', '121.11.12.245', '', '', '2', '2008-09-26', '0'), ('7934', '218.200.224.1', '', '', '1', '2008-09-26', '0'), ('7935', '125.68.19.76', '', '', '1', '2008-09-26', '0'), ('7936', '124.200.187.202', '', '', '1', '2008-09-26', '0'), ('7937', '218.63.70.18', '', '', '2', '2008-09-26', '0'), ('7938', '211.136.75.247', '', '', '1', '2008-09-26', '0'), ('7939', '121.235.21.164', '', '', '1', '2008-09-26', '0'), ('7940', '121.204.102.72', '', '', '2', '2008-09-26', '0'), ('7941', '116.227.3.162', '', '', '1', '2008-09-26', '0'), ('7942', '121.33.117.79', '', '', '1', '2008-09-26', '0'), ('7943', '220.194.137.7', '', '', '1', '2008-09-26', '0'), ('7944', '219.136.255.147', '', '', '2', '2008-09-26', '0'), ('7945', '218.200.224.215', '', '', '1', '2008-09-26', '0'), ('7946', '59.56.168.72', '', '', '3', '2008-09-27', '0'), ('7947', '220.206.235.57', '', '', '1', '2008-09-27', '0'), ('7948', '59.57.71.19', '', '', '11', '2008-09-27', '0'), ('7949', '117.28.188.12', '', '', '1', '2008-09-27', '0'), ('7950', '218.58.176.220', '', '', '1', '2008-09-27', '0'), ('7951', '221.239.130.125', '', '', '1', '2008-09-27', '0'), ('7952', '125.93.74.122', '', '', '2', '2008-09-27', '0'), ('7953', '219.134.87.180', '', '', '1', '2008-09-27', '0'), ('7954', '220.207.162.203', '', '', '1', '2008-09-27', '0'), ('7955', '219.130.84.114', '', '', '1', '2008-09-27', '0'), ('7956', '122.224.195.160', '', '', '1', '2008-09-27', '0'), ('7957', '206.53.144.73', '', '', '2', '2008-09-27', '0'), ('7958', '58.61.116.42', '', '', '1', '2008-09-27', '0'), ('7959', '116.21.147.208', '', '', '1', '2008-09-27', '0'), ('7960', '218.205.252.91', '', '', '2', '2008-09-27', '0'), ('7961', '116.9.232.239', '', '', '3', '2008-09-27', '0'), ('7962', '219.128.101.71', '', '', '2', '2008-09-27', '0'), ('7963', '211.136.158.168', '', '', '3', '2008-09-27', '0'), ('7964', '125.71.216.10', '', '', '3', '2008-09-27', '0'), ('7965', '116.53.233.85', '', '', '1', '2008-09-27', '0'), ('7966', '218.200.224.155', '', '', '1', '2008-09-27', '0'), ('7967', '121.32.160.161', '', '', '2', '2008-09-27', '0'), ('7968', '218.79.155.217', '', '', '2', '2008-09-27', '0'), ('7969', '60.211.129.193', '', '', '7', '2008-09-27', '0'), ('7970', '61.149.188.66', '', '', '1', '2008-09-27', '0'), ('7971', '219.136.83.96', '', '', '1', '2008-09-27', '0'), ('7972', '220.169.80.222', '', '', '1', '2008-09-27', '0'), ('7973', '123.67.89.9', '', '', '1', '2008-09-27', '0'), ('7974', '121.31.150.8', '', '', '1', '2008-09-27', '0'), ('7975', '124.203.240.107', '', '', '1', '2008-09-27', '0'), ('7976', '218.18.20.46', '', '', '2', '2008-09-27', '0'), ('7977', '219.93.152.32', '', '', '2', '2008-09-27', '0'), ('7978', '219.137.136.74', '', '', '3', '2008-09-27', '0'), ('7979', '122.66.10.54', '', '', '2', '2008-09-27', '0'), ('7980', '59.42.190.14', '', '', '1', '2008-09-27', '0'), ('7981', '203.125.84.190', '', '', '1', '2008-09-27', '0'), ('7982', '219.137.177.93', '', '', '2', '2008-09-27', '0'), ('7983', '124.197.116.4', '', '', '1', '2008-09-27', '0'), ('7984', '121.8.43.254', '', '', '1', '2008-09-27', '0'), ('7985', '58.44.18.151', '', '', '3', '2008-09-27', '0'), ('7986', '59.60.49.37', '', '', '2', '2008-09-27', '0'), ('7987', '211.137.62.196', '', '', '2', '2008-09-27', '0'), ('7988', '195.189.142.182', '', '', '1', '2008-09-27', '0'), ('7989', '121.207.85.130', '', '', '2', '2008-09-27', '0'), ('7990', '59.55.16.249', '', '', '5', '2008-09-27', '0'), ('7991', '41.220.207.11', '', '', '1', '2008-09-27', '0'), ('7992', '211.136.113.214', '', '', '2', '2008-09-27', '0'), ('7993', '58.62.229.180', '', '', '2', '2008-09-27', '0'), ('7994', '218.17.253.168', '', '', '1', '2008-09-27', '0'), ('7995', '116.26.228.7', '', '', '1', '2008-09-27', '0'), ('7996', '59.56.111.231', '', '', '2', '2008-09-27', '0'), ('7997', '61.132.138.216', '', '', '2', '2008-09-27', '0'), ('7998', '41.223.57.77', '', '', '1', '2008-09-27', '0'), ('7999', '121.227.111.92', '', '', '1', '2008-09-27', '0'), ('8000', '117.95.1.194', '', '', '1', '2008-09-27', '0'), ('8001', '221.237.26.63', '', '', '2', '2008-09-27', '0'), ('8002', '60.217.68.133', '', '', '2', '2008-09-27', '0'), ('8003', '211.136.75.92', '', '', '1', '2008-09-27', '0'), ('8004', '125.69.65.32', '', '', '1', '2008-09-27', '0'), ('8005', '196.30.118.86', '', '', '1', '2008-09-27', '0'), ('8006', '121.8.243.118', '', '', '1', '2008-09-27', '0'), ('8007', '61.146.119.98', '', '', '1', '2008-09-27', '0'), ('8008', '60.21.119.174', '', '', '2', '2008-09-27', '0'), ('8009', '220.185.196.200', '', '', '1', '2008-09-27', '0'), ('8010', '119.255.2.193', '', '', '1', '2008-09-27', '0'), ('8011', '59.42.57.208', '', '', '1', '2008-09-27', '0'), ('8012', '219.132.227.229', '', '', '1', '2008-09-27', '0'), ('8013', '125.106.7.38', '', '', '1', '2008-09-27', '0'), ('8014', '124.132.165.107', '', '', '1', '2008-09-27', '0'), ('8015', '211.137.41.9', '', '', '1', '2008-09-27', '0'), ('8016', '218.7.43.194', '', '', '1', '2008-09-27', '0'), ('8017', '125.83.28.227', '', '', '1', '2008-09-27', '0'), ('8018', '116.17.163.238', '', '', '2', '2008-09-27', '0'), ('8019', '60.48.182.232', '', '', '1', '2008-09-27', '0'), ('8020', '219.137.29.111', '', '', '1', '2008-09-27', '0'), ('8021', '121.10.168.29', '', '', '1', '2008-09-27', '0'), ('8022', '59.37.160.30', '', '', '1', '2008-09-27', '0'), ('8023', '124.135.175.41', '', '', '1', '2008-09-27', '0'), ('8024', '121.63.57.167', '', '', '1', '2008-09-27', '0'), ('8025', '219.137.173.48', '', '', '1', '2008-09-27', '0'), ('8026', '219.152.240.2', '', '', '1', '2008-09-27', '0'), ('8027', '211.138.218.101', '', '', '1', '2008-09-27', '0'), ('8028', '211.136.75.228', '', '', '3', '2008-09-27', '0'), ('8029', '219.131.174.22', '', '', '1', '2008-09-27', '0'), ('8030', '218.17.209.157', '', '', '1', '2008-09-27', '0'), ('8031', '58.61.122.59', '', '', '1', '2008-09-27', '0'), ('8032', '119.183.72.67', '', '', '2', '2008-09-27', '0'), ('8033', '220.192.112.141', '', '', '1', '2008-09-27', '0'), ('8034', '218.75.114.222', '', '', '1', '2008-09-27', '0'), ('8035', '211.136.75.226', '', '', '1', '2008-09-27', '0'), ('8036', '125.107.72.180', '', '', '2', '2008-09-27', '0'), ('8037', '123.165.107.117', '', '', '1', '2008-09-27', '0'), ('8038', '218.204.251.68', '', '', '7', '2008-09-27', '0'), ('8039', '125.121.189.45', '', '', '1', '2008-09-27', '0'), ('8040', '121.227.28.91', '', '', '1', '2008-09-27', '0'), ('8041', '220.206.246.6', '', '', '2', '2008-09-27', '0'), ('8042', '116.4.29.202', '', '', '1', '2008-09-27', '0'), ('8043', '218.202.6.161', '', '', '7', '2008-09-27', '0'), ('8044', '121.235.181.128', '', '', '1', '2008-09-27', '0'), ('8045', '118.192.8.248', '', '', '3', '2008-09-27', '0'), ('8046', '119.123.121.149', '', '', '1', '2008-09-27', '0'), ('8047', '123.136.8.12', '', '', '1', '2008-09-27', '0'), ('8048', '218.25.164.145', '', '', '2', '2008-09-27', '0'), ('8049', '211.137.63.174', '', '', '2', '2008-09-27', '0'), ('8050', '218.14.150.151', '', '', '2', '2008-09-27', '0'), ('8051', '118.112.250.132', '', '', '1', '2008-09-28', '0'), ('8052', '220.206.246.56', '', '', '1', '2008-09-28', '0'), ('8053', '116.20.167.185', '', '', '1', '2008-09-28', '0'), ('8054', '119.120.133.121', '', '', '2', '2008-09-28', '0'), ('8055', '211.138.227.36', '', '', '1', '2008-09-28', '0'), ('8056', '219.153.180.248', '', '', '1', '2008-09-28', '0'), ('8057', '222.211.114.107', '', '', '1', '2008-09-28', '0'), ('8058', '119.128.125.33', '', '', '14', '2008-09-28', '0'), ('8059', '220.170.43.49', '', '', '1', '2008-09-28', '0'), ('8060', '124.130.13.227', '', '', '1', '2008-09-28', '0'), ('8061', '195.229.237.37', '', '', '2', '2008-09-28', '0'), ('8062', '59.36.8.181', '', '', '2', '2008-09-28', '0'), ('8063', '61.145.246.156', '', '', '3', '2008-09-28', '0'), ('8064', '58.61.132.189', '', '', '1', '2008-09-28', '0'), ('8065', '195.189.142.45', '', '', '1', '2008-09-28', '0'), ('8066', '41.220.207.13', '', '', '2', '2008-09-28', '0'), ('8067', '41.220.207.12', '', '', '2', '2008-09-28', '0'), ('8068', '221.221.18.63', '', '', '1', '2008-09-28', '0'), ('8069', '58.60.232.25', '', '', '1', '2008-09-28', '0'), ('8070', '125.18.235.215', '', '', '3', '2008-09-28', '0'), ('8071', '211.138.218.8', '', '', '1', '2008-09-28', '0'), ('8072', '220.206.196.10', '', '', '3', '2008-09-28', '0'), ('8073', '121.17.129.14', '', '', '1', '2008-09-28', '0'), ('8074', '220.193.99.32', '', '', '1', '2008-09-28', '0'), ('8075', '221.2.207.130', '', '', '2', '2008-09-28', '0'), ('8076', '219.128.35.146', '', '', '1', '2008-09-28', '0'), ('8077', '210.83.70.70', '', '', '1', '2008-09-28', '0'), ('8078', '59.58.56.184', '', '', '1', '2008-09-28', '0'), ('8079', '61.130.77.166', '', '', '2', '2008-09-28', '0'), ('8080', '58.49.139.255', '', '', '2', '2008-09-28', '0'), ('8081', '211.136.75.199', '', '', '4', '2008-09-28', '0'), ('8082', '116.20.202.253', '', '', '2', '2008-09-28', '0'), ('8083', '221.130.56.27', '', '', '1', '2008-09-28', '0'), ('8084', '59.41.66.90', '', '', '1', '2008-09-28', '0'), ('8085', '222.212.99.136', '', '', '3', '2008-09-28', '0'), ('8086', '125.126.126.44', '', '', '2', '2008-09-28', '0'), ('8087', '60.208.25.3', '', '', '1', '2008-09-28', '0'), ('8088', '211.137.63.172', '', '', '1', '2008-09-28', '0'), ('8089', '220.206.246.52', '', '', '1', '2008-09-28', '0'), ('8090', '124.226.249.181', '', '', '1', '2008-09-28', '0'), ('8091', '220.255.7.158', '', '', '1', '2008-09-28', '0'), ('8092', '219.152.242.180', '', '', '1', '2008-09-28', '0'), ('8093', '59.40.141.100', '', '', '1', '2008-09-28', '0'), ('8094', '59.41.189.236', '', '', '1', '2008-09-28', '0'), ('8095', '211.136.75.16', '', '', '1', '2008-09-28', '0'), ('8096', '211.136.75.17', '', '', '1', '2008-09-28', '0'), ('8097', '222.184.77.168', '', '', '1', '2008-09-28', '0'), ('8098', '60.21.120.69', '', '', '3', '2008-09-28', '0'), ('8099', '218.20.134.59', '', '', '1', '2008-09-28', '0'), ('8100', '74.6.22.155', '', '', '1', '2008-09-28', '0'), ('8101', '116.4.91.34', '', '', '3', '2008-09-28', '0'), ('8102', '116.233.240.142', '', '', '1', '2008-09-28', '0'), ('8103', '121.33.250.194', '', '', '1', '2008-09-28', '0'), ('8104', '222.130.224.134', '', '', '1', '2008-09-28', '0'), ('8105', '123.175.183.153', '', '', '2', '2008-09-28', '0'), ('8106', '121.20.33.140', '', '', '1', '2008-09-28', '0'), ('8107', '220.206.235.62', '', '', '1', '2008-09-28', '0'), ('8108', '121.35.175.132', '', '', '1', '2008-09-28', '0'), ('8109', '203.142.123.83', '', '', '1', '2008-09-28', '0'), ('8110', '59.108.78.81', '', '', '2', '2008-09-28', '0'), ('8111', '121.29.182.3', '', '', '1', '2008-09-28', '0'), ('8112', '219.130.75.180', '', '', '2', '2008-09-28', '0'), ('8113', '61.157.245.29', '', '', '1', '2008-09-28', '0'), ('8114', '123.64.23.211', '', '', '1', '2008-09-28', '0'), ('8115', '59.35.139.17', '', '', '37', '2008-09-28', '0'), ('8116', '123.132.83.225', '', '', '1', '2008-09-28', '0'), ('8117', '123.175.195.198', '', '', '2', '2008-09-28', '0'), ('8118', '221.221.158.158', '', '', '1', '2008-09-28', '0'), ('8119', '59.55.227.91', '', '', '6', '2008-09-28', '0'), ('8120', '219.153.183.154', '', '', '1', '2008-09-28', '0'), ('8121', '125.69.69.19', '', '', '2', '2008-09-28', '0'), ('8122', '58.65.203.52', '', '', '1', '2008-09-28', '0'), ('8123', '125.91.59.61', '', '', '1', '2008-09-28', '0'), ('8124', '220.206.246.12', '', '', '2', '2008-09-28', '0'), ('8125', '218.205.238.101', '', '', '1', '2008-09-28', '0'), ('8126', '58.241.16.106', '', '', '1', '2008-09-28', '0'), ('8127', '211.136.113.244', '', '', '2', '2008-09-28', '0'), ('8128', '58.54.184.93', '', '', '2', '2008-09-28', '0'), ('8129', '121.8.245.117', '', '', '16', '2008-09-28', '0'), ('8130', '60.180.157.20', '', '', '1', '2008-09-28', '0'), ('8131', '220.205.143.153', '', '', '2', '2008-09-28', '0'), ('8132', '116.225.148.185', '', '', '1', '2008-09-28', '0'), ('8133', '222.217.107.87', '', '', '1', '2008-09-28', '0'), ('8134', '121.33.220.138', '', '', '1', '2008-09-28', '0'), ('8135', '221.5.4.194', '', '', '1', '2008-09-28', '0'), ('8136', '218.205.249.1', '', '', '1', '2008-09-28', '0'), ('8137', '58.61.57.98', '', '', '5', '2008-09-28', '0'), ('8138', '117.24.144.64', '', '', '1', '2008-09-28', '0'), ('8139', '123.114.168.248', '', '', '1', '2008-09-28', '0'), ('8140', '211.136.75.119', '', '', '1', '2008-09-28', '0'), ('8141', '121.33.221.20', '', '', '2', '2008-09-28', '0'), ('8142', '58.62.225.236', '', '', '4', '2008-09-28', '0'), ('8143', '121.8.37.158', '', '', '3', '2008-09-28', '0'), ('8144', '118.192.107.94', '', '', '10', '2008-09-28', '0'), ('8145', '119.122.41.19', '', '', '1', '2008-09-28', '0'), ('8146', '219.130.238.121', '', '', '2', '2008-09-28', '0'), ('8147', '121.234.226.132', '', '', '2', '2008-09-28', '0'), ('8148', '219.145.103.190', '', '', '1', '2008-09-28', '0'), ('8149', '219.132.119.189', '', '', '1', '2008-09-28', '0'), ('8150', '219.146.253.156', '', '', '3', '2008-09-28', '0'), ('8151', '203.145.92.65', '', '', '1', '2008-09-28', '0'), ('8152', '121.37.7.212', '', '', '2', '2008-09-28', '0'), ('8153', '211.138.227.92', '', '', '1', '2008-09-29', '0'), ('8154', '221.226.203.43', '', '', '1', '2008-09-29', '0'), ('8155', '119.141.246.203', '', '', '1', '2008-09-29', '0'), ('8156', '60.168.82.205', '', '', '1', '2008-09-29', '0'), ('8157', '125.90.72.121', '', '', '3', '2008-09-29', '0'), ('8158', '222.216.78.137', '', '', '1', '2008-09-29', '0'), ('8159', '119.125.14.176', '', '', '9', '2008-09-29', '0'), ('8160', '202.86.188.170', '', '', '1', '2008-09-29', '0'), ('8161', '117.85.241.10', '', '', '2', '2008-09-29', '0'), ('8162', '58.44.138.112', '', '', '1', '2008-09-29', '0'), ('8163', '211.94.252.177', '', '', '1', '2008-09-29', '0'), ('8164', '196.30.118.87', '', '', '1', '2008-09-29', '0'), ('8165', '58.62.33.44', '', '', '15', '2008-09-29', '0'), ('8166', '203.113.138.124', '', '', '2', '2008-09-29', '0'), ('8167', '222.186.239.238', '', '', '1', '2008-09-29', '0');
INSERT INTO `ig_gateway` VALUES ('8168', '218.202.227.120', '', '', '6', '2008-09-29', '0'), ('8169', '222.133.27.154', '', '', '1', '2008-09-29', '0'), ('8170', '218.16.113.48', '', '', '2', '2008-09-29', '0'), ('8171', '211.137.62.191', '', '', '20', '2008-09-29', '0'), ('8172', '58.60.80.159', '', '', '1', '2008-09-29', '0'), ('8173', '221.2.118.53', '', '', '1', '2008-09-29', '0'), ('8174', '59.35.243.68', '', '', '1', '2008-09-29', '0'), ('8175', '59.41.254.190', '', '', '2', '2008-09-29', '0'), ('8176', '60.179.12.128', '', '', '1', '2008-09-29', '0'), ('8177', '58.252.241.248', '', '', '1', '2008-09-29', '0'), ('8178', '121.29.8.29', '', '', '2', '2008-09-29', '0'), ('8179', '220.243.107.227', '', '', '9', '2008-09-29', '0'), ('8180', '124.161.170.227', '', '', '24', '2008-09-29', '0'), ('8181', '218.205.252.34', '', '', '1', '2008-09-29', '0'), ('8182', '116.16.208.69', '', '', '1', '2008-09-29', '0'), ('8183', '58.49.31.216', '', '', '24', '2008-09-29', '0'), ('8184', '211.138.218.65', '', '', '1', '2008-09-29', '0'), ('8185', '117.97.207.157', '', '', '2', '2008-09-29', '0'), ('8186', '211.138.218.55', '', '', '3', '2008-09-29', '0'), ('8187', '58.253.149.134', '', '', '1', '2008-09-29', '0'), ('8188', '60.23.3.75', '', '', '1', '2008-09-29', '0'), ('8189', '219.133.93.127', '', '', '2', '2008-09-29', '0'), ('8190', '220.206.235.24', '', '', '1', '2008-09-29', '0'), ('8191', '116.254.150.89', '', '', '1', '2008-09-29', '0'), ('8192', '211.24.226.8', '', '', '1', '2008-09-29', '0'), ('8193', '222.134.154.99', '', '', '1', '2008-09-29', '0'), ('8194', '123.128.38.116', '', '', '15', '2008-09-29', '0'), ('8195', '116.21.1.188', '', '', '1', '2008-09-29', '0'), ('8196', '60.31.2.84', '', '', '1', '2008-09-29', '0'), ('8197', '58.57.0.12', '', '', '1', '2008-09-29', '0'), ('8198', '91.203.96.16', '', '', '2', '2008-09-29', '0'), ('8199', '60.168.95.114', '', '', '1', '2008-09-29', '0'), ('8200', '58.62.230.187', '', '', '4', '2008-09-29', '0'), ('8201', '121.15.142.189', '', '', '1', '2008-09-29', '0'), ('8202', '119.128.13.124', '', '', '1', '2008-09-29', '0'), ('8203', '59.35.168.185', '', '', '1', '2008-09-29', '0'), ('8204', '59.35.170.157', '', '', '13', '2008-09-29', '0'), ('8205', '123.112.82.105', '', '', '1', '2008-09-29', '0'), ('8206', '222.209.254.173', '', '', '1', '2008-09-29', '0'), ('8207', '116.18.215.3', '', '', '1', '2008-09-29', '0'), ('8208', '116.24.234.80', '', '', '1', '2008-09-29', '0'), ('8209', '219.133.14.114', '', '', '3', '2008-09-29', '0'), ('8210', '218.205.249.119', '', '', '1', '2008-09-29', '0'), ('8211', '116.24.101.195', '', '', '1', '2008-09-29', '0'), ('8212', '60.180.148.222', '', '', '1', '2008-09-29', '0'), ('8213', '122.4.172.50', '', '', '35', '2008-09-29', '0'), ('8214', '219.130.33.200', '', '', '1', '2008-09-29', '0'), ('8215', '120.87.102.140', '', '', '1', '2008-09-29', '0'), ('8216', '220.250.10.93', '', '', '1', '2008-09-29', '0'), ('8217', '121.13.254.210', '', '', '1', '2008-09-29', '0'), ('8218', '219.134.117.44', '', '', '3', '2008-09-29', '0'), ('8219', '116.25.1.8', '', '', '3', '2008-09-29', '0'), ('8220', '218.82.193.212', '', '', '1', '2008-09-29', '0'), ('8221', '219.134.252.109', '', '', '1', '2008-09-29', '0'), ('8222', '117.24.229.28', '', '', '12', '2008-09-29', '0'), ('8223', '114.138.233.91', '', '', '10', '2008-09-29', '0'), ('8224', '58.37.177.139', '', '', '1', '2008-09-29', '0'), ('8225', '123.61.167.183', '', '', '6', '2008-09-29', '0'), ('8226', '58.252.87.141', '', '', '2', '2008-09-29', '0'), ('8227', '221.218.34.156', '', '', '1', '2008-09-29', '0'), ('8228', '119.122.27.83', '', '', '1', '2008-09-29', '0'), ('8229', '220.231.221.50', '', '', '1', '2008-09-30', '0'), ('8230', '219.152.241.168', '', '', '5', '2008-09-30', '0'), ('8231', '202.75.133.37', '', '', '2', '2008-09-30', '0'), ('8232', '211.138.227.132', '', '', '1', '2008-09-30', '0'), ('8233', '211.138.152.118', '', '', '3', '2008-09-30', '0'), ('8234', '211.137.63.126', '', '', '3', '2008-09-30', '0'), ('8235', '121.207.15.1', '', '', '1', '2008-09-30', '0'), ('8236', '211.137.63.133', '', '', '2', '2008-09-30', '0'), ('8237', '58.62.13.131', '', '', '1', '2008-09-30', '0'), ('8238', '58.63.219.211', '', '', '1', '2008-09-30', '0'), ('8239', '116.21.35.20', '', '', '1', '2008-09-30', '0'), ('8240', '219.134.120.63', '', '', '1', '2008-09-30', '0'), ('8241', '119.163.113.31', '', '', '1', '2008-09-30', '0'), ('8242', '61.141.156.100', '', '', '1', '2008-09-30', '0'), ('8243', '220.255.7.141', '', '', '1', '2008-09-30', '0'), ('8244', '221.131.97.48', '', '', '1', '2008-09-30', '0'), ('8245', '218.80.225.34', '', '', '9', '2008-09-30', '0'), ('8246', '220.206.216.2', '', '', '2', '2008-09-30', '0'), ('8247', '116.224.179.168', '', '', '2', '2008-09-30', '0'), ('8248', '116.26.226.151', '', '', '3', '2008-09-30', '0'), ('8249', '114.240.175.194', '', '', '1', '2008-09-30', '0'), ('8250', '211.137.63.149', '', '', '1', '2008-09-30', '0'), ('8251', '119.128.13.221', '', '', '1', '2008-09-30', '0'), ('8252', '220.206.246.39', '', '', '1', '2008-09-30', '0'), ('8253', '117.19.22.145', '', '', '1', '2008-09-30', '0'), ('8254', '218.207.138.74', '', '', '10', '2008-09-30', '0'), ('8255', '116.21.126.86', '', '', '1', '2008-09-30', '0'), ('8256', '218.16.242.90', '', '', '9', '2008-09-30', '0'), ('8257', '125.73.179.231', '', '', '1', '2008-09-30', '0'), ('8258', '116.5.124.223', '', '', '1', '2008-09-30', '0'), ('8259', '59.40.223.99', '', '', '1', '2008-09-30', '0'), ('8260', '59.40.155.142', '', '', '1', '2008-09-30', '0'), ('8261', '211.137.63.145', '', '', '1', '2008-09-30', '0'), ('8262', '211.137.63.185', '', '', '3', '2008-09-30', '0'), ('8263', '211.137.63.129', '', '', '2', '2008-09-30', '0'), ('8264', '121.15.146.1', '', '', '1', '2008-09-30', '0'), ('8265', '124.161.170.230', '', '', '2', '2008-09-30', '0'), ('8266', '122.157.25.66', '', '', '1', '2008-09-30', '0'), ('8267', '220.166.116.205', '', '', '2', '2008-09-30', '0'), ('8268', '61.142.74.151', '', '', '4', '2008-09-30', '0'), ('8269', '222.171.71.220', '', '', '1', '2008-09-30', '0'), ('8270', '58.61.225.56', '', '', '1', '2008-09-30', '0'), ('8271', '220.197.7.72', '', '', '2', '2008-09-30', '0'), ('8272', '218.200.224.30', '', '', '1', '2008-09-30', '0'), ('8273', '203.142.115.17', '', '', '1', '2008-09-30', '0'), ('8274', '218.75.53.139', '', '', '1', '2008-09-30', '0'), ('8275', '211.138.218.48', '', '', '2', '2008-09-30', '0'), ('8276', '59.33.245.162', '', '', '3', '2008-09-30', '0'), ('8277', '60.20.195.62', '', '', '1', '2008-09-30', '0'), ('8278', '124.89.2.8', '', '', '1', '2008-09-30', '0'), ('8279', '59.38.165.210', '', '', '1', '2008-09-30', '0'), ('8280', '219.131.117.173', '', '', '1', '2008-09-30', '0'), ('8281', '122.236.213.10', '', '', '1', '2008-09-30', '0'), ('8282', '203.145.92.90', '', '', '2', '2008-09-30', '0'), ('8283', '218.15.164.93', '', '', '1', '2008-09-30', '0'), ('8284', '211.138.152.120', '', '', '2', '2008-09-30', '0'), ('8285', '222.217.152.185', '', '', '1', '2008-09-30', '0'), ('8286', '93.172.67.216', '', '', '1', '2008-09-30', '0'), ('8287', '220.191.110.72', '', '', '1', '2008-09-30', '0'), ('8288', '222.216.136.110', '', '', '1', '2008-09-30', '0'), ('8289', '125.91.165.13', '', '', '2', '2008-09-30', '0'), ('8290', '60.176.253.126', '', '', '2', '2008-09-30', '0'), ('8291', '116.254.151.194', '', '', '2', '2008-09-30', '0'), ('8292', '59.37.135.234', '', '', '1', '2008-09-30', '0'), ('8293', '218.16.253.249', '', '', '2', '2008-09-30', '0'), ('8294', '58.48.59.207', '', '', '2', '2008-09-30', '0'), ('8295', '116.16.216.140', '', '', '1', '2008-09-30', '0'), ('8296', '116.204.34.210', '', '', '1', '2008-09-30', '0'), ('8297', '116.16.196.190', '', '', '1', '2008-09-30', '0'), ('8298', '125.36.195.71', '', '', '2', '2008-09-30', '0'), ('8299', '219.125.148.5', '', '', '1', '2008-09-30', '0'), ('8300', '116.26.168.181', '', '', '1', '2008-09-30', '0'), ('8301', '121.46.45.172', '', '', '1', '2008-09-30', '0'), ('8302', '117.85.241.64', '', '', '3', '2008-09-30', '0'), ('8303', '122.4.188.102', '', '', '24', '2008-09-30', '0'), ('8304', '59.57.35.27', '', '', '1', '2008-09-30', '0'), ('8305', '116.19.18.130', '', '', '1', '2008-09-30', '0'), ('8306', '116.5.57.80', '', '', '1', '2008-09-30', '0'), ('8307', '116.26.120.3', '', '', '1', '2008-09-30', '0'), ('8308', '119.182.24.186', '', '', '3', '2008-09-30', '0'), ('8309', '60.0.75.198', '', '', '2', '2008-09-30', '0'), ('8310', '59.40.40.252', '', '', '1', '2008-09-30', '0'), ('8311', '59.59.164.136', '', '', '1', '2008-09-30', '0'), ('8312', '211.136.113.200', '', '', '2', '2008-09-30', '0'), ('8313', '117.68.10.63', '', '', '1', '2008-09-30', '0'), ('8314', '220.201.232.35', '', '', '2', '2008-09-30', '0'), ('8315', '59.56.201.13', '', '', '4', '2008-09-30', '0'), ('8316', '222.67.35.80', '', '', '1', '2008-09-30', '0'), ('8317', '211.137.63.159', '', '', '1', '2008-09-30', '0'), ('8319', '211.137.63.136', '', '', '1', '2008-09-30', '0'), ('8320', '211.137.63.173', '', '', '1', '2008-09-30', '0'), ('8321', '60.5.167.144', '', '', '8', '2008-09-30', '0'), ('8322', '195.189.142.251', '', '', '1', '2008-09-30', '0'), ('8323', '119.122.93.199', '', '', '1', '2008-09-30', '0'), ('8324', '220.160.9.41', '', '', '11', '2008-09-30', '0'), ('8325', '58.145.148.3', '', '', '2', '2008-09-30', '0'), ('8326', '219.128.51.1', '', '', '1', '2008-09-30', '0'), ('8327', '116.4.243.91', '', '', '1', '2008-09-30', '0'), ('8328', '211.137.63.157', '', '', '1', '2008-09-30', '0'), ('8329', '202.101.131.174', '', '', '1', '2008-09-30', '0'), ('8330', '117.85.241.159', '', '', '1', '2008-09-30', '0'), ('8331', '218.200.224.181', '', '', '2', '2008-09-30', '0'), ('8332', '59.57.91.121', '', '', '1', '2008-09-30', '0'), ('8333', '119.32.68.15', '', '', '1', '2008-09-30', '0'), ('8334', '211.137.63.188', '', '', '1', '2008-09-30', '0'), ('8335', '211.137.63.184', '', '', '1', '2008-09-30', '0'), ('8336', '125.93.73.58', '', '', '1', '2008-09-30', '0'), ('8337', '124.238.143.164', '', '', '1', '2008-09-30', '0'), ('8338', '218.83.240.146', '', '', '1', '2008-09-30', '0'), ('8339', '60.188.99.218', '', '', '1', '2008-09-30', '0'), ('8340', '211.137.63.187', '', '', '1', '2008-09-30', '0'), ('8341', '116.18.228.62', '', '', '1', '2008-09-30', '0'), ('8342', '211.137.63.148', '', '', '1', '2008-09-30', '0'), ('8343', '125.43.237.220', '', '', '1', '2008-09-30', '0'), ('8344', '118.192.1.187', '', '', '1', '2008-09-30', '0'), ('8345', '61.178.192.55', '', '', '2', '2008-09-30', '0'), ('8346', '121.8.237.187', '', '', '3', '2008-09-30', '0'), ('8347', '211.138.227.181', '', '', '1', '2008-09-30', '0'), ('8348', '219.134.230.235', '', '', '1', '2008-09-30', '0'), ('8349', '58.248.236.35', '', '', '2', '2008-09-30', '0'), ('8350', '59.37.147.76', '', '', '2', '2008-10-01', '0'), ('8351', '123.136.0.155', '', '', '1', '2008-10-01', '0'), ('8352', '222.212.101.90', '', '', '5', '2008-10-01', '0'), ('8353', '121.123.96.254', '', '', '2', '2008-10-01', '0'), ('8354', '123.175.179.75', '', '', '3', '2008-10-01', '0'), ('8355', '219.136.158.20', '', '', '3', '2008-10-01', '0'), ('8356', '61.145.101.53', '', '', '1', '2008-10-01', '0'), ('8357', '66.94.9.52', '', '', '2', '2008-10-01', '0'), ('8358', '125.90.13.206', '', '', '1', '2008-10-01', '0'), ('8359', '125.127.177.56', '', '', '1', '2008-10-01', '0'), ('8360', '220.206.235.84', '', '', '1', '2008-10-01', '0'), ('8361', '60.53.31.164', '', '', '2', '2008-10-01', '0'), ('8362', '222.89.160.41', '', '', '2', '2008-10-01', '0'), ('8363', '59.37.208.235', '', '', '1', '2008-10-01', '0'), ('8364', '120.0.84.76', '', '', '7', '2008-10-01', '0'), ('8365', '59.35.162.42', '', '', '1', '2008-10-01', '0'), ('8366', '203.142.109.90', '', '', '1', '2008-10-01', '0'), ('8367', '218.15.153.26', '', '', '3', '2008-10-01', '0'), ('8368', '124.227.12.156', '', '', '7', '2008-10-01', '0'), ('8369', '58.61.23.207', '', '', '4', '2008-10-01', '0'), ('8370', '212.35.66.175', '', '', '1', '2008-10-01', '0'), ('8371', '211.136.75.19', '', '', '1', '2008-10-01', '0'), ('8372', '203.208.60.97', '', '', '1', '2008-10-01', '0'), ('8373', '123.114.252.210', '', '', '1', '2008-10-01', '0'), ('8374', '125.83.218.215', '', '', '5', '2008-10-01', '0'), ('8375', '211.136.158.222', '', '', '1', '2008-10-01', '0'), ('8376', '125.81.154.97', '', '', '1', '2008-10-01', '0'), ('8377', '116.24.115.101', '', '', '1', '2008-10-01', '0'), ('8378', '219.132.27.98', '', '', '1', '2008-10-01', '0'), ('8379', '121.13.66.40', '', '', '2', '2008-10-01', '0'), ('8380', '121.10.152.123', '', '', '1', '2008-10-01', '0'), ('8381', '119.121.8.33', '', '', '1', '2008-10-01', '0'), ('8382', '121.8.242.91', '', '', '1', '2008-10-01', '0'), ('8383', '211.138.218.78', '', '', '1', '2008-10-01', '0'), ('8384', '59.38.35.18', '', '', '3', '2008-10-01', '0'), ('8385', '116.28.205.184', '', '', '1', '2008-10-01', '0'), ('8386', '218.15.164.92', '', '', '2', '2008-10-01', '0'), ('8387', '121.13.223.114', '', '', '1', '2008-10-01', '0'), ('8388', '117.93.163.213', '', '', '1', '2008-10-01', '0'), ('8389', '116.19.19.104', '', '', '1', '2008-10-01', '0'), ('8390', '59.33.121.25', '', '', '2', '2008-10-01', '0'), ('8391', '195.46.107.97', '', '', '4', '2008-10-01', '0'), ('8392', '60.186.156.102', '', '', '1', '2008-10-01', '0'), ('8393', '124.112.2.48', '', '', '1', '2008-10-01', '0'), ('8394', '220.206.235.18', '', '', '1', '2008-10-01', '0'), ('8395', '211.136.75.99', '', '', '1', '2008-10-01', '0'), ('8396', '219.135.134.239', '', '', '1', '2008-10-01', '0'), ('8397', '125.91.208.206', '', '', '1', '2008-10-01', '0'), ('8398', '125.64.78.19', '', '', '4', '2008-10-01', '0'), ('8399', '211.136.113.197', '', '', '3', '2008-10-01', '0'), ('8400', '116.16.198.72', '', '', '1', '2008-10-01', '0'), ('8401', '123.175.205.104', '', '', '3', '2008-10-01', '0'), ('8402', '91.203.96.26', '', '', '4', '2008-10-01', '0'), ('8403', '218.205.238.119', '', '', '1', '2008-10-01', '0'), ('8404', '125.254.151.87', '', '', '1', '2008-10-01', '0'), ('8405', '116.16.165.159', '', '', '1', '2008-10-01', '0'), ('8406', '121.68.64.119', '', '', '1', '2008-10-01', '0'), ('8407', '119.125.213.229', '', '', '1', '2008-10-01', '0'), ('8408', '211.136.75.58', '', '', '2', '2008-10-01', '0'), ('8409', '116.27.157.55', '', '', '9', '2008-10-01', '0'), ('8410', '116.17.92.164', '', '', '1', '2008-10-01', '0'), ('8411', '219.152.40.216', '', '', '1', '2008-10-01', '0'), ('8412', '130.244.196.90', '', '', '1', '2008-10-01', '0'), ('8413', '60.166.168.52', '', '', '1', '2008-10-01', '0'), ('8414', '125.33.61.120', '', '', '2', '2008-10-01', '0'), ('8415', '120.0.217.251', '', '', '5', '2008-10-01', '0'), ('8416', '211.136.75.25', '', '', '2', '2008-10-01', '0'), ('8417', '221.218.83.81', '', '', '1', '2008-10-01', '0'), ('8418', '124.77.119.168', '', '', '1', '2008-10-01', '0'), ('8419', '123.53.58.82', '', '', '1', '2008-10-01', '0'), ('8420', '116.4.50.235', '', '', '6', '2008-10-01', '0'), ('8421', '211.137.41.6', '', '', '1', '2008-10-01', '0'), ('8422', '222.138.50.151', '', '', '4', '2008-10-01', '0'), ('8423', '195.189.143.62', '', '', '1', '2008-10-02', '0'), ('8424', '125.84.222.31', '', '', '1', '2008-10-02', '0'), ('8425', '219.134.191.225', '', '', '1', '2008-10-02', '0'), ('8426', '121.77.135.177', '', '', '1', '2008-10-02', '0'), ('8427', '122.52.71.221', '', '', '1', '2008-10-02', '0'), ('8428', '124.89.2.2', '', '', '2', '2008-10-02', '0'), ('8429', '195.189.143.50', '', '', '2', '2008-10-02', '0'), ('8430', '59.42.63.200', '', '', '2', '2008-10-02', '0'), ('8431', '58.220.233.14', '', '', '8', '2008-10-02', '0'), ('8432', '61.146.211.46', '', '', '1', '2008-10-02', '0'), ('8433', '125.90.91.137', '', '', '1', '2008-10-02', '0'), ('8434', '219.150.131.80', '', '', '1', '2008-10-02', '0'), ('8435', '220.169.11.3', '', '', '2', '2008-10-02', '0'), ('8436', '211.136.158.200', '', '', '2', '2008-10-02', '0'), ('8437', '203.142.116.147', '', '', '1', '2008-10-02', '0'), ('8438', '59.37.234.14', '', '', '2', '2008-10-02', '0'), ('8439', '117.36.7.185', '', '', '5', '2008-10-02', '0'), ('8440', '125.108.35.86', '', '', '1', '2008-10-02', '0'), ('8441', '211.136.75.85', '', '', '1', '2008-10-02', '0'), ('8442', '211.138.227.13', '', '', '1', '2008-10-02', '0'), ('8443', '58.60.159.202', '', '', '5', '2008-10-02', '0'), ('8444', '58.60.164.19', '', '', '1', '2008-10-02', '0'), ('8445', '119.127.141.8', '', '', '1', '2008-10-02', '0'), ('8446', '116.112.129.78', '', '', '2', '2008-10-02', '0'), ('8447', '219.129.215.3', '', '', '3', '2008-10-02', '0'), ('8448', '124.82.104.178', '', '', '1', '2008-10-02', '0'), ('8449', '119.96.19.10', '', '', '1', '2008-10-02', '0'), ('8450', '60.1.248.140', '', '', '2', '2008-10-02', '0'), ('8451', '219.148.28.230', '', '', '1', '2008-10-02', '0'), ('8452', '219.128.170.92', '', '', '7', '2008-10-02', '0'), ('8453', '125.93.77.147', '', '', '3', '2008-10-02', '0'), ('8454', '125.119.34.3', '', '', '1', '2008-10-02', '0'), ('8455', '222.248.65.195', '', '', '1', '2008-10-02', '0'), ('8456', '211.136.113.253', '', '', '1', '2008-10-02', '0'), ('8457', '211.140.143.55', '', '', '1', '2008-10-02', '0'), ('8458', '122.53.20.78', '', '', '1', '2008-10-02', '0'), ('8459', '116.30.204.200', '', '', '1', '2008-10-02', '0'), ('8460', '125.77.219.75', '', '', '2', '2008-10-02', '0'), ('8461', '121.33.220.98', '', '', '1', '2008-10-02', '0'), ('8462', '121.13.217.26', '', '', '1', '2008-10-02', '0'), ('8463', '218.16.112.117', '', '', '1', '2008-10-02', '0'), ('8464', '119.125.215.171', '', '', '1', '2008-10-02', '0'), ('8465', '58.240.255.9', '', '', '1', '2008-10-02', '0'), ('8466', '59.36.145.73', '', '', '1', '2008-10-02', '0'), ('8467', '59.32.95.87', '', '', '1', '2008-10-02', '0'), ('8468', '123.123.215.133', '', '', '1', '2008-10-02', '0'), ('8469', '211.136.75.223', '', '', '1', '2008-10-02', '0'), ('8470', '218.17.7.11', '', '', '1', '2008-10-02', '0'), ('8471', '125.93.78.59', '', '', '1', '2008-10-02', '0'), ('8472', '60.166.137.81', '', '', '9', '2008-10-02', '0'), ('8473', '60.4.228.201', '', '', '1', '2008-10-02', '0'), ('8474', '219.128.249.186', '', '', '1', '2008-10-02', '0'), ('8475', '220.206.235.25', '', '', '1', '2008-10-02', '0'), ('8476', '221.237.165.67', '', '', '1', '2008-10-02', '0'), ('8477', '211.137.197.57', '', '', '2', '2008-10-02', '0'), ('8478', '125.93.76.99', '', '', '1', '2008-10-02', '0'), ('8479', '202.152.243.101', '', '', '1', '2008-10-02', '0'), ('8480', '59.33.17.83', '', '', '1', '2008-10-02', '0'), ('8481', '121.13.93.241', '', '', '1', '2008-10-02', '0'), ('8482', '58.23.112.84', '', '', '1', '2008-10-02', '0'), ('8483', '221.6.85.26', '', '', '2', '2008-10-02', '0'), ('8484', '211.152.8.143', '', '联通', '1', '2008-10-02', '0'), ('8485', '124.92.135.29', '', '', '1', '2008-10-02', '0'), ('8486', '59.42.216.41', '', '', '1', '2008-10-03', '0'), ('8487', '125.88.207.23', '', '', '1', '2008-10-03', '0'), ('8488', '195.189.142.180', '', '', '1', '2008-10-03', '0'), ('8489', '59.57.94.172', '', '', '1', '2008-10-03', '0'), ('8490', '219.135.204.62', '', '', '1', '2008-10-03', '0'), ('8491', '116.18.27.221', '', '', '1', '2008-10-03', '0'), ('8492', '202.75.133.22', '', '', '2', '2008-10-03', '0'), ('8493', '220.192.145.218', '', '', '1', '2008-10-03', '0'), ('8494', '125.78.148.10', '', '', '1', '2008-10-03', '0'), ('8495', '121.9.85.136', '', '', '3', '2008-10-03', '0'), ('8496', '119.120.134.78', '', '', '1', '2008-10-03', '0'), ('8497', '116.25.121.245', '', '', '1', '2008-10-03', '0'), ('8498', '123.175.203.102', '', '', '32', '2008-10-03', '0'), ('8499', '61.160.66.29', '', '', '1', '2008-10-03', '0'), ('8500', '203.142.108.147', '', '', '1', '2008-10-03', '0'), ('8501', '60.178.171.221', '', '', '1', '2008-10-03', '0'), ('8502', '116.232.176.213', '', '', '1', '2008-10-03', '0'), ('8503', '219.129.139.202', '', '', '1', '2008-10-03', '0'), ('8504', '117.86.50.87', '', '', '1', '2008-10-03', '0'), ('8505', '220.161.95.186', '', '', '2', '2008-10-03', '0'), ('8506', '211.136.113.227', '', '', '1', '2008-10-03', '0'), ('8507', '116.16.228.191', '', '', '1', '2008-10-03', '0'), ('8508', '218.20.243.143', '', '', '2', '2008-10-03', '0'), ('8509', '220.192.203.209', '', '', '1', '2008-10-03', '0'), ('8510', '211.136.158.180', '', '', '2', '2008-10-03', '0'), ('8511', '121.32.185.89', '', '', '1', '2008-10-03', '0'), ('8512', '121.32.90.177', '', '', '1', '2008-10-03', '0'), ('8513', '116.21.104.187', '', '', '1', '2008-10-03', '0'), ('8514', '194.176.111.10', '', '', '1', '2008-10-03', '0'), ('8515', '195.189.142.214', '', '', '1', '2008-10-03', '0'), ('8516', '219.132.115.114', '', '', '1', '2008-10-03', '0'), ('8517', '219.130.146.51', '', '', '1', '2008-10-03', '0'), ('8518', '210.13.124.162', '', '', '23', '2008-10-03', '0'), ('8519', '58.62.40.231', '', '', '3', '2008-10-03', '0'), ('8520', '211.136.113.248', '', '', '1', '2008-10-03', '0'), ('8521', '116.28.48.31', '', '', '1', '2008-10-03', '0'), ('8522', '121.32.125.204', '', '', '1', '2008-10-03', '0'), ('8523', '114.93.193.84', '', '', '1', '2008-10-03', '0'), ('8524', '220.207.210.233', '', '', '1', '2008-10-03', '0'), ('8525', '59.172.167.227', '', '', '1', '2008-10-03', '0'), ('8526', '121.9.75.7', '', '', '1', '2008-10-03', '0'), ('8527', '151.80.64.3', '', '', '1', '2008-10-03', '0'), ('8528', '221.239.237.123', '', '', '1', '2008-10-03', '0'), ('8529', '219.129.165.242', '', '', '1', '2008-10-03', '0'), ('8530', '211.136.75.154', '', '', '1', '2008-10-03', '0'), ('8531', '195.189.142.43', '', '', '1', '2008-10-03', '0'), ('8532', '59.42.231.124', '', '', '1', '2008-10-03', '0'), ('8533', '116.29.45.235', '', '', '1', '2008-10-03', '0'), ('8534', '123.136.9.48', '', '', '1', '2008-10-03', '0'), ('8535', '123.136.8.110', '', '', '1', '2008-10-03', '0'), ('8536', '58.209.187.175', '', '', '2', '2008-10-03', '0'), ('8537', '211.137.63.125', '', '', '1', '2008-10-03', '0'), ('8538', '59.56.209.79', '', '', '3', '2008-10-03', '0'), ('8539', '219.137.144.66', '', '', '1', '2008-10-03', '0'), ('8540', '123.120.6.78', '', '', '1', '2008-10-03', '0'), ('8541', '58.248.154.53', '', '', '1', '2008-10-03', '0'), ('8542', '125.91.95.2', '', '', '1', '2008-10-03', '0'), ('8543', '125.84.223.91', '', '', '3', '2008-10-03', '0'), ('8544', '122.4.186.154', '', '', '1', '2008-10-03', '0'), ('8545', '59.41.148.206', '', '', '4', '2008-10-03', '0'), ('8546', '220.206.235.81', '', '', '1', '2008-10-03', '0'), ('8547', '221.223.86.30', '', '', '1', '2008-10-03', '0'), ('8548', '220.206.235.1', '', '', '1', '2008-10-03', '0'), ('8549', '117.85.241.220', '', '', '4', '2008-10-04', '0'), ('8550', '211.143.149.109', '', '', '1', '2008-10-04', '0'), ('8551', '61.141.20.146', '', '', '1', '2008-10-04', '0'), ('8552', '114.137.180.42', '', '', '1', '2008-10-04', '0'), ('8553', '122.156.234.33', '', '', '1', '2008-10-04', '0'), ('8554', '119.128.105.203', '', '', '2', '2008-10-04', '0'), ('8555', '221.213.128.66', '', '', '1', '2008-10-04', '0'), ('8556', '195.189.143.55', '', '', '1', '2008-10-04', '0'), ('8557', '119.120.80.68', '', '', '2', '2008-10-04', '0'), ('8558', '218.16.75.96', '', '', '1', '2008-10-04', '0'), ('8559', '59.40.111.60', '', '', '1', '2008-10-04', '0'), ('8560', '218.66.44.244', '', '', '1', '2008-10-04', '0'), ('8561', '219.130.138.126', '', '', '5', '2008-10-04', '0'), ('8562', '117.44.21.123', '', '', '1', '2008-10-04', '0'), ('8563', '222.213.121.49', '', '', '2', '2008-10-04', '0'), ('8564', '116.227.164.202', '', '', '1', '2008-10-04', '0'), ('8565', '59.35.95.212', '', '', '1', '2008-10-04', '0'), ('8566', '219.128.126.225', '', '', '2', '2008-10-04', '0'), ('8567', '58.31.33.43', '', '', '1', '2008-10-04', '0'), ('8568', '222.79.207.185', '', '', '5', '2008-10-04', '0'), ('8569', '125.116.52.228', '', '', '1', '2008-10-04', '0'), ('8570', '211.136.113.215', '', '', '1', '2008-10-04', '0'), ('8571', '211.139.16.59', '', '', '3', '2008-10-04', '0'), ('8572', '196.207.32.37', '', '', '4', '2008-10-04', '0'), ('8573', '66.249.71.167', '', '', '11', '2008-10-04', '0'), ('8574', '119.128.166.108', '', '', '1', '2008-10-04', '0'), ('8575', '211.139.145.149', '', '', '1', '2008-10-04', '0'), ('8576', '58.63.24.17', '', '', '2', '2008-10-04', '0'), ('8577', '218.58.178.238', '', '', '1', '2008-10-04', '0'), ('8578', '194.176.111.227', '', '', '1', '2008-10-04', '0'), ('8579', '117.22.14.176', '', '', '1', '2008-10-04', '0'), ('8580', '219.136.203.95', '', '', '1', '2008-10-04', '0'), ('8582', '116.25.215.137', '', '', '2', '2008-10-04', '0'), ('8583', '219.129.165.243', '', '', '2', '2008-10-04', '0'), ('8584', '121.9.56.50', '', '', '7', '2008-10-04', '0'), ('8585', '58.252.76.243', '', '', '2', '2008-10-04', '0'), ('8586', '217.118.82.20', '', '', '1', '2008-10-04', '0'), ('8587', '66.249.71.168', '', '', '15', '2008-10-04', '0'), ('8588', '60.222.201.125', '', '', '1', '2008-10-04', '0'), ('8589', '124.64.62.154', '', '', '1', '2008-10-04', '0'), ('8590', '218.79.202.57', '', '', '1', '2008-10-04', '0'), ('8591', '122.100.201.181', '', '', '1', '2008-10-04', '0'), ('8592', '211.137.62.220', '', '', '1', '2008-10-04', '0'), ('8593', '121.33.161.5', '', '', '2', '2008-10-04', '0'), ('8594', '211.137.41.22', '', '', '4', '2008-10-04', '0'), ('8595', '119.128.145.18', '', '', '1', '2008-10-04', '0'), ('8596', '60.210.7.98', '', '', '9', '2008-10-04', '0'), ('8597', '211.136.113.222', '', '', '1', '2008-10-05', '0'), ('8598', '61.160.70.98', '', '', '5', '2008-10-05', '0'), ('8599', '114.138.220.213', '', '', '1', '2008-10-05', '0'), ('8600', '219.128.224.35', '', '', '4', '2008-10-05', '0'), ('8601', '220.205.63.232', '', '', '2', '2008-10-05', '0'), ('8602', '83.149.9.172', '', '', '1', '2008-10-05', '0'), ('8603', '219.144.200.2', '', '', '6', '2008-10-05', '0'), ('8604', '218.66.43.12', '', '', '1', '2008-10-05', '0'), ('8605', '121.32.126.155', '', '', '1', '2008-10-05', '0'), ('8606', '119.128.32.119', '', '', '1', '2008-10-05', '0'), ('8607', '125.20.13.85', '', '', '1', '2008-10-05', '0'), ('8608', '58.253.107.107', '', '', '1', '2008-10-05', '0'), ('8609', '220.246.161.244', '', '', '2', '2008-10-05', '0'), ('8610', '125.112.193.182', '', '', '1', '2008-10-05', '0'), ('8611', '120.31.228.101', '', '', '1', '2008-10-05', '0'), ('8612', '66.249.71.169', '', '', '10', '2008-10-05', '0'), ('8613', '202.56.4.106', '', '', '3', '2008-10-05', '0'), ('8614', '91.203.96.19', '', '', '1', '2008-10-05', '0'), ('8615', '211.136.158.131', '', '', '1', '2008-10-05', '0'), ('8616', '211.136.75.5', '', '', '1', '2008-10-05', '0'), ('8617', '119.128.77.78', '', '', '6', '2008-10-05', '0'), ('8618', '211.136.75.20', '', '', '1', '2008-10-05', '0'), ('8619', '58.39.147.75', '', '', '1', '2008-10-05', '0'), ('8620', '210.192.98.210', '', '', '1', '2008-10-05', '0'), ('8621', '116.31.166.104', '', '', '8', '2008-10-05', '0'), ('8622', '203.142.104.224', '', '', '2', '2008-10-05', '0'), ('8623', '125.116.47.201', '', '', '3', '2008-10-05', '0'), ('8624', '202.105.69.144', '', '', '1', '2008-10-05', '0'), ('8625', '58.33.38.126', '', '', '3', '2008-10-05', '0'), ('8626', '61.50.145.67', '', '', '1', '2008-10-05', '0'), ('8627', '66.212.163.168', '', '', '1', '2008-10-05', '0'), ('8628', '60.1.254.191', '', '', '6', '2008-10-05', '0'), ('8629', '116.21.84.223', '', '', '3', '2008-10-05', '0'), ('8630', '221.209.77.180', '', '', '2', '2008-10-05', '0'), ('8631', '211.138.227.160', '', '', '2', '2008-10-05', '0'), ('8632', '118.120.249.214', '', '', '1', '2008-10-05', '0'), ('8633', '221.192.112.229', '', '', '1', '2008-10-05', '0'), ('8634', '59.35.18.158', '', '', '1', '2008-10-05', '0'), ('8635', '59.35.0.242', '', '', '1', '2008-10-05', '0'), ('8636', '58.34.105.99', '', '', '1', '2008-10-05', '0'), ('8637', '119.141.172.135', '', '', '1', '2008-10-05', '0'), ('8638', '116.226.134.2', '', '', '4', '2008-10-05', '0'), ('8639', '211.136.75.61', '', '', '1', '2008-10-05', '0'), ('8640', '220.207.230.71', '', '', '1', '2008-10-05', '0'), ('8641', '202.160.178.61', '', '', '1', '2008-10-05', '0'), ('8642', '61.187.201.11', '', '', '2', '2008-10-05', '0'), ('8643', '118.245.200.7', '', '', '1', '2008-10-05', '0'), ('8644', '124.42.119.197', '', '', '1', '2008-10-05', '0'), ('8645', '121.34.128.107', '', '', '1', '2008-10-05', '0'), ('8646', '59.41.149.151', '', '', '1', '2008-10-05', '0'), ('8647', '218.85.40.101', '', '', '1', '2008-10-05', '0'), ('8648', '124.205.2.203', '', '', '1', '2008-10-05', '0'), ('8649', '59.35.88.62', '', '', '1', '2008-10-05', '0'), ('8650', '59.173.220.42', '', '', '1', '2008-10-05', '0'), ('8651', '119.141.156.212', '', '', '6', '2008-10-05', '0'), ('8652', '58.47.61.182', '', '', '1', '2008-10-05', '0'), ('8653', '220.162.115.34', '', '', '1', '2008-10-06', '0'), ('8654', '116.29.246.195', '', '', '1', '2008-10-06', '0'), ('8655', '221.221.27.171', '', '', '1', '2008-10-06', '0'), ('8656', '221.0.142.224', '', '', '1', '2008-10-06', '0'), ('8657', '124.92.132.195', '', '', '1', '2008-10-06', '0'), ('8658', '116.25.121.179', '', '', '1', '2008-10-06', '0'), ('8659', '222.212.110.69', '', '', '8', '2008-10-06', '0'), ('8660', '59.35.138.33', '', '', '1', '2008-10-06', '0'), ('8661', '116.16.233.196', '', '', '1', '2008-10-06', '0'), ('8662', '220.128.48.238', '', '', '1', '2008-10-06', '0'), ('8663', '121.15.244.10', '', '', '1', '2008-10-06', '0'), ('8664', '211.138.227.187', '', '', '1', '2008-10-06', '0'), ('8665', '119.128.125.62', '', '', '1', '2008-10-06', '0'), ('8666', '120.87.246.139', '', '', '1', '2008-10-06', '0'), ('8667', '122.157.22.177', '', '', '1', '2008-10-06', '0'), ('8668', '211.136.113.212', '', '', '1', '2008-10-06', '0'), ('8669', '61.140.191.81', '', '', '9', '2008-10-06', '0'), ('8670', '218.71.73.106', '', '', '1', '2008-10-06', '0'), ('8671', '61.49.112.163', '', '', '3', '2008-10-06', '0'), ('8672', '121.33.136.208', '', '', '2', '2008-10-06', '0'), ('8673', '219.143.45.170', '', '', '2', '2008-10-06', '0'), ('8674', '220.192.71.111', '', '', '1', '2008-10-06', '0'), ('8675', '125.34.69.116', '', '', '9', '2008-10-06', '0'), ('8676', '61.140.191.215', '', '', '1', '2008-10-06', '0'), ('8677', '60.168.81.34', '', '', '3', '2008-10-06', '0'), ('8678', '58.63.43.16', '', '', '1', '2008-10-06', '0'), ('8679', '125.78.188.186', '', '', '1', '2008-10-06', '0'), ('8680', '222.197.188.244', '', '', '1', '2008-10-06', '0'), ('8681', '119.128.146.28', '', '', '1', '2008-10-06', '0'), ('8682', '211.137.63.95', '', '', '1', '2008-10-06', '0'), ('8683', '116.23.253.111', '', '', '1', '2008-10-06', '0'), ('8684', '119.128.141.133', '', '', '2', '2008-10-06', '0'), ('8685', '222.64.130.38', '', '', '1', '2008-10-06', '0'), ('8686', '211.142.187.206', '', '', '1', '2008-10-06', '0'), ('8687', '219.143.140.185', '', '', '1', '2008-10-06', '0'), ('8688', '219.136.176.168', '', '', '2', '2008-10-06', '0'), ('8689', '222.173.45.59', '', '', '1', '2008-10-06', '0'), ('8690', '116.25.12.253', '', '', '1', '2008-10-06', '0'), ('8691', '120.10.8.109', '', '', '2', '2008-10-06', '0'), ('8692', '222.187.249.16', '', '', '4', '2008-10-06', '0'), ('8693', '219.157.69.194', '', '', '1', '2008-10-06', '0'), ('8694', '211.136.75.57', '', '', '1', '2008-10-06', '0'), ('8695', '60.52.140.26', '', '', '1', '2008-10-06', '0'), ('8696', '59.107.0.240', '', '', '1', '2008-10-06', '0'), ('8697', '121.10.71.102', '', '', '1', '2008-10-06', '0'), ('8698', '116.29.155.62', '', '', '1', '2008-10-06', '0'), ('8699', '118.125.2.40', '', '', '1', '2008-10-06', '0'), ('8700', '59.33.40.201', '', '', '1', '2008-10-06', '0'), ('8701', '119.128.11.34', '', '', '1', '2008-10-06', '0'), ('8702', '219.132.117.203', '', '', '1', '2008-10-06', '0'), ('8703', '116.18.173.178', '', '', '1', '2008-10-06', '0'), ('8704', '121.32.217.190', '', '', '1', '2008-10-06', '0'), ('8705', '124.227.192.220', '', '', '1', '2008-10-06', '0'), ('8706', '59.32.82.124', '', '', '1', '2008-10-06', '0'), ('8707', '211.137.63.106', '', '', '1', '2008-10-06', '0'), ('8708', '217.118.82.43', '', '', '1', '2008-10-06', '0'), ('8709', '58.44.25.52', '', '', '2', '2008-10-06', '0'), ('8710', '116.23.113.77', '', '', '2', '2008-10-06', '0'), ('8711', '202.105.68.128', '', '', '1', '2008-10-06', '0'), ('8712', '58.39.139.104', '', '', '2', '2008-10-06', '0'), ('8713', '59.41.122.234', '', '', '1', '2008-10-06', '0'), ('8714', '116.23.4.203', '', '', '1', '2008-10-06', '0'), ('8715', '60.211.199.196', '', '', '5', '2008-10-06', '0'), ('8716', '116.23.229.185', '', '', '1', '2008-10-06', '0'), ('8717', '116.235.208.90', '', '', '1', '2008-10-06', '0'), ('8718', '58.242.201.42', '', '', '1', '2008-10-07', '0'), ('8719', '125.114.101.125', '', '', '13', '2008-10-07', '0'), ('8720', '116.27.33.237', '', '', '1', '2008-10-07', '0'), ('8721', '58.65.203.48', '', '', '2', '2008-10-07', '0'), ('8722', '211.136.73.69', '', '', '2', '2008-10-07', '0'), ('8723', '59.41.163.236', '', '', '1', '2008-10-07', '0'), ('8724', '116.24.14.96', '', '', '2', '2008-10-07', '0'), ('8725', '218.13.146.187', '', '', '1', '2008-10-07', '0'), ('8726', '121.13.223.131', '', '', '1', '2008-10-07', '0'), ('8727', '211.136.158.233', '', '', '1', '2008-10-07', '0'), ('8728', '222.69.5.211', '', '', '2', '2008-10-07', '0'), ('8729', '119.123.149.196', '', '', '1', '2008-10-07', '0'), ('8730', '222.213.94.164', '', '', '3', '2008-10-07', '0'), ('8731', '203.145.92.79', '', '', '1', '2008-10-07', '0'), ('8732', '222.72.78.177', '', '', '1', '2008-10-07', '0'), ('8733', '202.119.140.41', '', '', '1', '2008-10-07', '0'), ('8734', '192.168.1.213', '', '', '20', '2008-10-07', '0'), ('8735', '218.19.52.149', '', '', '1', '2008-10-07', '0'), ('8736', '211.138.218.12', '', '', '1', '2008-10-07', '0'), ('8737', '116.25.228.144', '', '', '6', '2008-10-07', '0'), ('8738', '60.166.208.167', '', '', '1', '2008-10-07', '0'), ('8739', '58.62.63.110', '', '', '1', '2008-10-07', '0'), ('8740', '59.58.169.106', '', '', '1', '2008-10-07', '0'), ('8741', '120.87.209.186', '', '', '2', '2008-10-07', '0'), ('8742', '221.122.70.18', '', '', '1', '2008-10-07', '0'), ('8743', '121.41.233.86', '', '', '3', '2008-10-07', '0'), ('8744', '121.33.33.233', '', '', '1', '2008-10-07', '0'), ('8745', '202.106.74.158', '', '', '1', '2008-10-07', '0'), ('8746', '121.33.154.158', '', '', '1', '2008-10-07', '0'), ('8747', '60.167.47.93', '', '', '5', '2008-10-07', '0'), ('8748', '58.248.107.71', '', '', '1', '2008-10-07', '0'), ('8749', '58.82.176.170', '', '', '4', '2008-10-07', '0'), ('8750', '117.93.161.254', '', '', '2', '2008-10-07', '0'), ('8751', '58.248.131.62', '', '', '1', '2008-10-07', '0'), ('8752', '211.137.63.180', '', '', '3', '2008-10-07', '0'), ('8753', '116.18.72.63', '', '', '1', '2008-10-07', '0'), ('8754', '59.33.253.142', '', '', '1', '2008-10-07', '0'), ('8755', '219.137.140.112', '', '', '3', '2008-10-07', '0'), ('8756', '220.206.235.102', '', '', '1', '2008-10-07', '0'), ('8757', '219.142.232.74', '', '', '1', '2008-10-07', '0'), ('8758', '219.142.254.52', '', '', '1', '2008-10-07', '0'), ('8759', '58.221.241.206', '', '', '1', '2008-10-07', '0'), ('8760', '58.253.151.165', '', '', '3', '2008-10-07', '0'), ('8761', '121.234.202.99', '', '', '1', '2008-10-07', '0'), ('8762', '116.21.0.225', '', '', '1', '2008-10-07', '0'), ('8763', '221.192.237.174', '', '', '1', '2008-10-07', '0'), ('8764', '203.145.131.148', '', '', '2', '2008-10-07', '0'), ('8765', '118.147.3.183', '', '', '4', '2008-10-07', '0'), ('8766', '118.78.194.167', '', '', '1', '2008-10-07', '0'), ('8767', '211.138.227.4', '', '', '2', '2008-10-07', '0'), ('8768', '41.7.212.156', '', '', '1', '2008-10-07', '0'), ('8769', '125.91.238.3', '', '移动', '0', '2008-10-15', '1'), ('8770', '221.130.200.26', '', '', '2', '2008-10-07', '0'), ('8771', '219.134.218.172', '', '', '2', '2008-10-07', '0'), ('8772', '59.42.93.119', '', '', '1', '2008-10-07', '0'), ('8773', '116.4.178.48', '', '', '1', '2008-10-07', '0'), ('8774', '121.35.122.177', '', '', '1', '2008-10-07', '0'), ('8775', '222.92.114.92', '', '', '1', '2008-10-07', '0'), ('8776', '123.189.56.157', '', '', '1', '2008-10-07', '0'), ('8777', '125.91.238.5', '', '移动', '0', '2008-10-15', '1'), ('8778', '121.10.147.239', '', '', '5', '2008-10-07', '0'), ('8779', '190.88.31.202', '', '', '1', '2008-10-07', '0'), ('8780', '218.78.200.225', '', '', '5', '2008-10-07', '0'), ('8781', '124.225.29.94', '', '', '8', '2008-10-07', '0'), ('8782', '58.37.210.242', '', '', '2', '2008-10-07', '0'), ('8783', '220.170.45.8', '', '', '1', '2008-10-07', '0'), ('8784', '61.232.53.240', '', '', '1', '2008-10-07', '0'), ('8785', '219.129.225.68', '', '', '1', '2008-10-07', '0'), ('8786', '58.255.165.20', '', '', '12', '2008-10-08', '0'), ('8787', '58.19.128.1', '', '', '1', '2008-10-08', '0'), ('8788', '218.202.227.127', '', '', '6', '2008-10-08', '0'), ('8789', '58.252.119.97', '', '', '4', '2008-10-08', '0'), ('8790', '117.7.185.91', '', '', '1', '2008-10-08', '0'), ('8791', '218.15.149.16', '', '', '1', '2008-10-08', '0'), ('8792', '219.135.3.125', '', '', '7', '2008-10-08', '0'), ('8793', '125.114.57.250', '', '', '1', '2008-10-08', '0'), ('8794', '121.12.211.201', '', '', '1', '2008-10-08', '0'), ('8795', '221.11.178.13', '', '', '2', '2008-10-08', '0'), ('8796', '211.137.63.105', '', '', '1', '2008-10-08', '0'), ('8797', '123.120.96.184', '', '', '10', '2008-10-08', '0'), ('8798', '221.234.142.4', '', '', '1', '2008-10-08', '0'), ('8799', '119.163.114.110', '', '', '2', '2008-10-08', '0'), ('8800', '220.205.207.192', '', '', '1', '2008-10-08', '0'), ('8801', '219.133.168.1', '', '', '2', '2008-10-08', '0'), ('8802', '211.136.75.152', '', '', '1', '2008-10-08', '0'), ('8803', '121.12.11.173', '', '', '1', '2008-10-08', '0'), ('8804', '218.71.79.37', '', '', '1', '2008-10-08', '0'), ('8805', '59.38.98.250', '', '', '3', '2008-10-08', '0'), ('8806', '124.92.133.246', '', '', '3', '2008-10-08', '0'), ('8807', '219.136.15.111', '', '', '1', '2008-10-08', '0'), ('8808', '61.141.253.127', '', '', '3', '2008-10-08', '0'), ('8809', '125.91.238.8', '', '移动', '0', '2008-10-15', '1'), ('8810', '219.133.122.211', '', '', '1', '2008-10-08', '0'), ('8811', '125.91.238.13', '', '移动', '0', '2008-10-15', '1'), ('8812', '125.91.238.10', '', '移动', '0', '2008-10-15', '1'), ('8813', '219.134.129.170', '', '', '1', '2008-10-08', '0'), ('8814', '60.182.154.243', '', '', '29', '2008-10-08', '0'), ('8815', '121.10.155.217', '', '', '3', '2008-10-08', '0'), ('8816', '124.64.153.165', '', '', '3', '2008-10-08', '0'), ('8817', '118.144.128.7', '', '', '1', '2008-10-08', '0'), ('8818', '218.111.174.172', '', '', '1', '2008-10-08', '0'), ('8819', '58.44.16.20', '', '', '1', '2008-10-08', '0'), ('8820', '125.91.238.16', '', '移动', '0', '2008-10-15', '1'), ('8821', '117.93.166.74', '', '', '5', '2008-10-08', '0'), ('8822', '125.91.238.7', '', '移动', '0', '2008-10-15', '1'), ('8823', '116.197.233.113', '', '', '1', '2008-10-08', '0'), ('8824', '219.136.218.90', '', '', '3', '2008-10-08', '0'), ('8825', '125.93.184.170', '', '', '2', '2008-10-08', '0'), ('8826', '219.137.30.239', '', '', '6', '2008-10-08', '0'), ('8827', '218.19.68.250', '', '', '8', '2008-10-08', '0'), ('8828', '123.116.156.71', '', '', '1', '2008-10-08', '0'), ('8829', '125.91.238.25', '', '移动', '0', '2008-10-15', '1'), ('8830', '125.109.105.116', '', '', '2', '2008-10-08', '0'), ('8831', '125.91.238.20', '', '移动', '0', '2008-10-15', '1'), ('8832', '125.90.101.163', '', '', '1', '2008-10-08', '0'), ('8833', '61.236.105.117', '', '', '1', '2008-10-08', '0'), ('8834', '222.191.242.253', '', '', '17', '2008-10-08', '0'), ('8835', '60.215.98.146', '', '', '1', '2008-10-08', '0'), ('8836', '119.128.92.229', '', '', '1', '2008-10-08', '0'), ('8837', '202.103.141.141', '', '', '1', '2008-10-08', '0'), ('8838', '220.206.235.72', '', '', '1', '2008-10-08', '0'), ('8839', '221.233.24.48', '', '', '1', '2008-10-08', '0'), ('8840', '211.92.29.202', '', '', '1', '2008-10-08', '0'), ('8841', '124.165.154.10', '', '', '1', '2008-10-08', '0'), ('8842', '60.186.122.98', '', '', '1', '2008-10-08', '0'), ('8843', '125.91.238.26', '', '移动', '0', '2008-10-15', '1'), ('8844', '222.129.109.97', '', '', '1', '2008-10-08', '0'), ('8845', '121.15.18.103', '', '', '11', '2008-10-08', '0'), ('8846', '218.11.22.124', '', '', '1', '2008-10-08', '0'), ('8847', '123.6.185.81', '', '', '1', '2008-10-08', '0'), ('8848', '116.30.96.140', '', '', '1', '2008-10-08', '0'), ('8849', '220.197.164.106', '', '', '1', '2008-10-08', '0'), ('8850', '211.136.158.171', '', '', '1', '2008-10-08', '0'), ('8851', '125.91.238.14', '', '移动', '0', '2008-10-15', '1'), ('8852', '118.245.196.237', '', '', '1', '2008-10-08', '0'), ('8853', '116.26.154.185', '', '', '1', '2008-10-08', '0'), ('8854', '59.35.150.133', '', '', '1', '2008-10-08', '0'), ('8855', '211.136.75.82', '', '', '1', '2008-10-08', '0'), ('8856', '59.58.36.7', '', '', '1', '2008-10-08', '0'), ('8857', '125.91.151.82', '', '', '1', '2008-10-08', '0'), ('8858', '124.131.248.124', '', '', '2', '2008-10-08', '0'), ('8859', '222.79.5.166', '', '', '1', '2008-10-08', '0'), ('8860', '58.45.78.129', '', '', '1', '2008-10-08', '0'), ('8861', '123.15.59.49', '', '', '1', '2008-10-08', '0'), ('8862', '121.13.125.66', '', '', '1', '2008-10-08', '0'), ('8863', '119.130.45.78', '', '', '2', '2008-10-08', '0'), ('8864', '61.140.37.32', '', '', '1', '2008-10-08', '0'), ('8865', '125.91.238.18', '', '移动', '0', '2008-10-15', '1'), ('8866', '118.112.255.210', '', '', '2', '2008-10-08', '0'), ('8867', '125.93.75.250', '', '', '1', '2008-10-08', '0'), ('8868', '219.132.174.179', '', '', '1', '2008-10-08', '0'), ('8869', '213.26.205.138', '', '', '2', '2008-10-08', '0'), ('8870', '218.76.141.30', '', '', '2', '2008-10-08', '0'), ('8871', '211.136.158.203', '', '', '1', '2008-10-08', '0'), ('8872', '124.227.148.183', '', '', '1', '2008-10-08', '0'), ('8873', '125.91.238.27', '', '移动', '0', '2008-10-15', '1'), ('8874', '125.91.238.15', '', '移动', '0', '2008-10-15', '1'), ('8875', '123.112.204.202', '', '', '1', '2008-10-08', '0'), ('8876', '125.91.238.22', '', '移动', '0', '2008-10-15', '1'), ('8877', '211.136.75.244', '', '', '1', '2008-10-09', '0'), ('8878', '125.91.238.12', '', '移动', '0', '2008-10-15', '1'), ('8879', '58.62.169.253', '', '', '3', '2008-10-09', '0'), ('8880', '218.15.9.233', '', '', '1', '2008-10-09', '0'), ('8881', '218.78.201.76', '', '', '2', '2008-10-09', '0'), ('8882', '116.25.120.51', '', '', '1', '2008-10-09', '0'), ('8883', '124.66.107.225', '', '', '1', '2008-10-09', '0'), ('8884', '116.28.6.139', '', '', '2', '2008-10-09', '0'), ('8885', '125.91.238.23', '', '移动', '0', '2008-10-15', '1'), ('8886', '125.91.238.11', '', '移动', '0', '2008-10-15', '1'), ('8887', '121.8.44.155', '', '', '1', '2008-10-09', '0'), ('8888', '221.0.108.34', '', '', '3', '2008-10-09', '0'), ('8889', '58.253.169.60', '', '', '1', '2008-10-09', '0'), ('8890', '121.10.165.0', '', '', '2', '2008-10-09', '0'), ('8891', '125.113.110.158', '', '', '1', '2008-10-09', '0'), ('8892', '219.137.207.243', '', '', '2', '2008-10-09', '0'), ('8893', '222.86.68.237', '', '', '1', '2008-10-09', '0'), ('8894', '221.221.147.13', '', '', '1', '2008-10-09', '0'), ('8895', '119.123.16.190', '', '', '2', '2008-10-09', '0'), ('8896', '124.79.4.39', '', '', '2', '2008-10-09', '0'), ('8897', '117.93.161.20', '', '', '1', '2008-10-09', '0'), ('8898', '202.101.73.200', '', '', '3', '2008-10-09', '0'), ('8899', '59.35.110.46', '', '', '1', '2008-10-09', '0'), ('8900', '222.215.15.168', '', '', '2', '2008-10-09', '0'), ('8901', '119.234.0.14', '', '', '1', '2008-10-09', '0'), ('8902', '60.190.30.26', '', '', '1', '2008-10-09', '0'), ('8903', '58.55.16.111', '', '', '1', '2008-10-09', '0'), ('8904', '222.197.188.252', '', '', '1', '2008-10-09', '0'), ('8905', '61.48.69.193', '', '', '1', '2008-10-09', '0'), ('8906', '58.214.238.138', '', '', '1', '2008-10-09', '0'), ('8907', '61.172.241.98', '', '', '1', '2008-10-09', '0'), ('8908', '211.96.15.24', '', '', '1', '2008-10-09', '0'), ('8909', '118.192.1.6', '', '', '1', '2008-10-09', '0'), ('8910', '118.81.209.50', '', '', '2', '2008-10-09', '0'), ('8911', '60.211.110.64', '', '', '1', '2008-10-09', '0'), ('8912', '60.191.3.117', '', '', '2', '2008-10-09', '0'), ('8913', '210.77.146.233', '', '', '11', '2008-10-09', '0'), ('8914', '125.91.238.6', '', '移动', '0', '2008-10-15', '1'), ('8915', '41.6.3.89', '', '', '1', '2008-10-09', '0'), ('8916', '125.33.57.211', '', '', '1', '2008-10-09', '0'), ('8917', '218.19.129.250', '', '', '1', '2008-10-09', '0'), ('8918', '121.232.103.76', '', '', '3', '2008-10-09', '0'), ('8919', '58.63.13.34', '', '', '2', '2008-10-09', '0'), ('8920', '211.136.113.233', '', '', '2', '2008-10-09', '0'), ('8921', '211.136.113.196', '', '', '1', '2008-10-09', '0'), ('8922', '61.170.205.166', '', '', '1', '2008-10-09', '0'), ('8923', '119.129.197.10', '', '', '1', '2008-10-09', '0'), ('8924', '58.253.95.157', '', '', '1', '2008-10-09', '0'), ('8925', '218.15.208.151', '', '', '1', '2008-10-09', '0'), ('8926', '61.141.122.151', '', '', '3', '2008-10-09', '0'), ('8927', '83.149.9.135', '', '', '1', '2008-10-09', '0'), ('8928', '125.91.238.2', '', '移动', '0', '2008-10-15', '1'), ('8929', '218.11.22.115', '', '', '10', '2008-10-09', '0'), ('8930', '117.22.79.184', '', '', '1', '2008-10-09', '0'), ('8931', '58.62.224.253', '', '', '1', '2008-10-09', '0'), ('8932', '124.226.160.216', '', '', '2', '2008-10-09', '0'), ('8933', '125.91.238.9', '', '移动', '0', '2008-10-15', '1'), ('8934', '58.44.20.49', '', '', '1', '2008-10-09', '0'), ('8935', '121.13.187.58', '', '', '1', '2008-10-09', '0'), ('8936', '58.61.67.192', '', '', '1', '2008-10-10', '0'), ('8937', '58.214.132.245', '', '', '3', '2008-10-10', '0'), ('8938', '203.145.92.88', '', '', '2', '2008-10-10', '0'), ('8939', '222.212.108.60', '', '', '12', '2008-10-10', '0'), ('8940', '117.28.75.148', '', '', '1', '2008-10-10', '0'), ('8941', '125.113.42.76', '', '', '1', '2008-10-10', '0'), ('8942', '218.20.157.161', '', '', '2', '2008-10-10', '0'), ('8943', '122.102.68.8', '', '', '12', '2008-10-10', '0'), ('8944', '222.172.252.69', '', '', '2', '2008-10-10', '0'), ('8945', '79.124.203.145', '', '', '1', '2008-10-10', '0'), ('8946', '203.145.92.78', '', '', '2', '2008-10-10', '0'), ('8947', '118.24.193.208', '', '', '1', '2008-10-10', '0'), ('8948', '116.53.213.143', '', '', '1', '2008-10-10', '0'), ('8949', '125.91.238.28', '', '移动', '0', '2008-10-15', '1'), ('8950', '58.253.57.60', '', '', '1', '2008-10-10', '0'), ('8951', '114.137.57.179', '', '', '1', '2008-10-10', '0'), ('8952', '74.6.17.158', '', '', '1', '2008-10-10', '0'), ('8953', '59.42.42.253', '', '', '11', '2008-10-10', '0'), ('8954', '125.91.238.4', '', '移动', '0', '2008-10-15', '1'), ('8955', '125.91.238.19', '', '移动', '0', '2008-10-15', '1'), ('8956', '59.32.101.204', '', '', '1', '2008-10-10', '0'), ('8957', '121.29.22.13', '', '', '1', '2008-10-10', '0'), ('8958', '119.141.138.39', '', '', '1', '2008-10-10', '0'), ('8959', '60.168.90.78', '', '', '1', '2008-10-10', '0'), ('8960', '222.182.171.136', '', '', '1', '2008-10-10', '0'), ('8961', '116.21.118.182', '', '', '1', '2008-10-10', '0'), ('8962', '125.92.4.26', '', '', '1', '2008-10-10', '0'), ('8963', '58.61.230.163', '', '', '1', '2008-10-10', '0'), ('8964', '123.114.39.194', '', '', '1', '2008-10-10', '0'), ('8965', '211.136.182.86', '', '', '1', '2008-10-10', '0'), ('8966', '222.213.124.168', '', '', '1', '2008-10-10', '0'), ('8967', '58.253.146.193', '', '', '1', '2008-10-10', '0'), ('8968', '58.221.241.222', '', '', '3', '2008-10-10', '0'), ('8969', '125.91.238.17', '', '移动', '0', '2008-10-15', '1'), ('8970', '218.66.36.33', '', '', '1', '2008-10-10', '0'), ('8971', '125.91.120.114', '', '', '8', '2008-10-10', '0'), ('8972', '222.212.36.25', '', '', '1', '2008-10-10', '0'), ('8973', '125.78.76.129', '', '', '22', '2008-10-10', '0'), ('8974', '211.137.62.214', '', '', '1', '2008-10-10', '0'), ('8975', '125.68.134.244', '', '', '2', '2008-10-10', '0'), ('8976', '121.18.106.70', '', '', '2', '2008-10-10', '0'), ('8977', '117.26.148.123', '', '', '1', '2008-10-10', '0'), ('8978', '195.189.143.61', '', '', '2', '2008-10-10', '0'), ('8979', '116.24.112.254', '', '', '7', '2008-10-10', '0'), ('8980', '219.76.195.101', '', '', '1', '2008-10-10', '0'), ('8981', '60.184.234.198', '', '', '1', '2008-10-10', '0'), ('8982', '218.19.0.72', '', '', '4', '2008-10-10', '0'), ('8983', '61.154.207.203', '', '', '1', '2008-10-10', '0'), ('8984', '220.206.239.86', '', '', '1', '2008-10-10', '0'), ('8985', '218.19.53.126', '', '', '2', '2008-10-10', '0'), ('8986', '121.123.116.74', '', '', '1', '2008-10-10', '0'), ('8987', '222.216.141.192', '', '', '19', '2008-10-10', '0'), ('8988', '222.191.242.69', '', '', '1', '2008-10-10', '0'), ('8989', '58.248.101.51', '', '', '1', '2008-10-10', '0'), ('8990', '203.208.60.142', '', '', '1', '2008-10-10', '0'), ('8991', '203.208.60.47', '', '', '1', '2008-10-10', '0'), ('8992', '121.201.179.178', '', '', '1', '2008-10-10', '0'), ('8993', '222.173.45.53', '', '', '8', '2008-10-10', '0'), ('8994', '210.72.78.5', '', '', '1', '2008-10-10', '0'), ('8995', '125.115.199.46', '', '', '3', '2008-10-10', '0'), ('8996', '58.221.241.223', '', '', '2', '2008-10-10', '0'), ('8997', '202.138.126.240', '', '', '1', '2008-10-10', '0'), ('8998', '124.76.79.213', '', '', '1', '2008-10-10', '0'), ('8999', '116.48.19.68', '', '', '2', '2008-10-10', '0'), ('9000', '119.130.186.5', '', '', '1', '2008-10-10', '0'), ('9001', '121.34.220.32', '', '', '1', '2008-10-10', '0'), ('9002', '202.175.20.87', '', '', '1', '2008-10-10', '0'), ('9003', '219.133.159.36', '', '', '1', '2008-10-10', '0'), ('9004', '59.41.139.13', '', '', '1', '2008-10-10', '0'), ('9005', '219.130.32.79', '', '', '1', '2008-10-10', '0'), ('9006', '120.0.217.186', '', '', '1', '2008-10-10', '0'), ('9007', '116.30.107.36', '', '', '1', '2008-10-10', '0'), ('9008', '121.234.236.4', '', '', '1', '2008-10-10', '0'), ('9009', '121.15.90.206', '', '', '1', '2008-10-10', '0'), ('9010', '218.15.126.114', '', '', '1', '2008-10-10', '0'), ('9011', '59.56.214.124', '', '', '1', '2008-10-10', '0'), ('9012', '58.60.162.148', '', '', '6', '2008-10-10', '0'), ('9013', '213.226.144.158', '', '', '1', '2008-10-10', '0'), ('9014', '222.212.107.69', '', '', '1', '2008-10-10', '0'), ('9015', '62.240.62.168', '', '', '2', '2008-10-10', '0'), ('9016', '116.23.22.35', '', '', '1', '2008-10-10', '0'), ('9017', '218.205.249.174', '', '', '1', '2008-10-10', '0'), ('9018', '219.153.181.44', '', '', '2', '2008-10-10', '0'), ('9019', '119.126.90.122', '', '', '4', '2008-10-11', '0'), ('9020', '221.222.224.185', '', '', '1', '2008-10-11', '0'), ('9021', '211.136.113.242', '', '', '1', '2008-10-11', '0'), ('9022', '211.136.113.216', '', '', '1', '2008-10-11', '0'), ('9023', '116.20.233.135', '', '', '1', '2008-10-11', '0'), ('9024', '222.76.70.154', '', '', '1', '2008-10-11', '0'), ('9025', '116.29.71.189', '', '', '1', '2008-10-11', '0'), ('9026', '59.107.10.233', '', '', '1', '2008-10-11', '0'), ('9027', '59.36.196.85', '', '', '1', '2008-10-11', '0'), ('9028', '121.32.214.194', '', '', '4', '2008-10-11', '0'), ('9029', '219.78.194.30', '', '', '1', '2008-10-11', '0'), ('9030', '221.221.106.30', '', '', '1', '2008-10-11', '0'), ('9031', '220.249.207.8', '', '', '1', '2008-10-11', '0'), ('9032', '116.27.40.87', '', '', '1', '2008-10-11', '0'), ('9033', '211.136.158.237', '', '', '1', '2008-10-11', '0'), ('9034', '220.205.12.129', '', '', '1', '2008-10-11', '0'), ('9035', '212.58.185.27', '', '', '1', '2008-10-11', '0'), ('9036', '125.122.49.103', '', '', '2', '2008-10-11', '0'), ('9037', '58.216.228.90', '', '', '4', '2008-10-11', '0'), ('9038', '123.175.173.132', '', '', '10', '2008-10-11', '0'), ('9039', '59.34.240.109', '', '', '1', '2008-10-11', '0'), ('9040', '218.107.36.254', '', '', '4', '2008-10-11', '0'), ('9041', '218.15.90.146', '', '', '1', '2008-10-11', '0'), ('9042', '60.181.21.117', '', '', '1', '2008-10-11', '0'), ('9043', '116.19.39.51', '', '', '1', '2008-10-11', '0'), ('9044', '211.137.63.97', '', '', '1', '2008-10-11', '0'), ('9045', '117.93.169.20', '', '', '7', '2008-10-11', '0'), ('9046', '218.205.249.145', '', '', '1', '2008-10-11', '0'), ('9047', '211.136.113.224', '', '', '1', '2008-10-11', '0'), ('9048', '222.208.6.102', '', '', '13', '2008-10-11', '0'), ('9049', '219.136.177.176', '', '', '1', '2008-10-11', '0'), ('9050', '218.18.212.120', '', '', '1', '2008-10-11', '0'), ('9051', '61.149.134.149', '', '', '1', '2008-10-11', '0'), ('9052', '59.41.120.220', '', '', '1', '2008-10-11', '0'), ('9053', '125.92.214.193', '', '', '1', '2008-10-11', '0'), ('9054', '119.124.97.228', '', '', '1', '2008-10-11', '0'), ('9055', '58.208.103.115', '', '', '1', '2008-10-11', '0'), ('9056', '218.58.59.73', '', '', '1', '2008-10-11', '0'), ('9057', '195.189.142.247', '', '', '1', '2008-10-11', '0'), ('9058', '121.228.151.244', '', '', '1', '2008-10-11', '0'), ('9059', '218.13.9.206', '', '', '1', '2008-10-11', '0'), ('9060', '125.46.76.18', '', '', '1', '2008-10-11', '0'), ('9061', '59.32.224.237', '', '', '1', '2008-10-11', '0'), ('9062', '117.24.230.238', '', '', '6', '2008-10-11', '0'), ('9063', '220.205.145.126', '', '', '2', '2008-10-11', '0'), ('9064', '125.91.116.255', '', '', '1', '2008-10-11', '0'), ('9065', '219.134.78.85', '', '', '1', '2008-10-11', '0'), ('9066', '222.73.98.141', '', '', '1', '2008-10-11', '0'), ('9067', '218.15.233.186', '', '', '1', '2008-10-11', '0'), ('9068', '125.91.165.66', '', '', '1', '2008-10-11', '0'), ('9069', '58.60.35.166', '', '', '1', '2008-10-11', '0'), ('9070', '61.144.147.16', '', '', '1', '2008-10-11', '0'), ('9071', '222.209.98.21', '', '', '2', '2008-10-11', '0'), ('9072', '211.136.75.241', '', '', '1', '2008-10-11', '0'), ('9073', '120.6.16.254', '', '', '1', '2008-10-11', '0'), ('9074', '124.206.96.217', '', '', '1', '2008-10-11', '0'), ('9075', '62.217.247.249', '', '', '1', '2008-10-11', '0'), ('9076', '62.217.247.238', '', '', '1', '2008-10-11', '0'), ('9077', '211.136.158.231', '', '', '1', '2008-10-11', '0'), ('9078', '125.91.95.119', '', '', '3', '2008-10-11', '0'), ('9079', '124.132.48.111', '', '', '12', '2008-10-11', '0'), ('9080', '219.148.29.117', '', '', '1', '2008-10-11', '0'), ('9081', '61.172.162.65', '', '', '1', '2008-10-11', '0'), ('9082', '58.61.142.195', '', '', '1', '2008-10-11', '0'), ('9083', '125.91.253.226', '', '移动', '0', '2008-10-15', '1'), ('9084', '60.174.252.203', '', '', '1', '2008-10-11', '0'), ('9085', '59.42.40.220', '', '', '1', '2008-10-11', '0'), ('9086', '219.150.120.163', '', '', '4', '2008-10-11', '0'), ('9087', '123.6.218.25', '', '', '1', '2008-10-11', '0'), ('9088', '118.227.0.145', '', '', '1', '2008-10-11', '0'), ('9089', '219.135.193.135', '', '', '1', '2008-10-11', '0'), ('9090', '221.222.231.222', '', '', '1', '2008-10-11', '0'), ('9091', '220.206.246.46', '', '', '1', '2008-10-11', '0'), ('9092', '121.13.67.42', '', '', '1', '2008-10-12', '0'), ('9093', '116.30.218.43', '', '', '1', '2008-10-12', '0'), ('9094', '59.58.98.91', '', '', '2', '2008-10-12', '0'), ('9095', '121.20.225.155', '', '', '1', '2008-10-12', '0'), ('9096', '116.31.167.107', '', '', '1', '2008-10-12', '0'), ('9097', '77.119.132.38', '', '', '1', '2008-10-12', '0'), ('9098', '116.16.217.148', '', '', '2', '2008-10-12', '0'), ('9099', '124.225.153.7', '', '', '1', '2008-10-12', '0'), ('9100', '124.78.197.248', '', '', '1', '2008-10-12', '0'), ('9101', '66.175.109.145', '', '', '1', '2008-10-12', '0'), ('9102', '61.146.122.166', '', '', '1', '2008-10-12', '0'), ('9103', '220.206.235.30', '', '', '1', '2008-10-12', '0'), ('9104', '122.231.96.198', '', '', '1', '2008-10-12', '0'), ('9105', '91.145.224.36', '', '', '2', '2008-10-12', '0'), ('9106', '59.35.148.24', '', '', '2', '2008-10-12', '0'), ('9107', '211.137.41.11', '', '', '1', '2008-10-12', '0'), ('9108', '211.138.227.41', '', '', '1', '2008-10-12', '0'), ('9109', '125.116.202.41', '', '', '2', '2008-10-12', '0'), ('9110', '220.206.235.53', '', '', '1', '2008-10-12', '0'), ('9111', '218.18.61.16', '', '', '4', '2008-10-12', '0'), ('9112', '211.136.75.207', '', '', '1', '2008-10-12', '0'), ('9113', '221.222.226.252', '', '', '4', '2008-10-12', '0'), ('9114', '120.67.206.165', '', '', '1', '2008-10-12', '0'), ('9115', '219.132.140.58', '', '', '4', '2008-10-12', '0'), ('9116', '116.26.251.111', '', '', '1', '2008-10-12', '0'), ('9117', '119.130.188.249', '', '', '4', '2008-10-12', '0'), ('9118', '119.128.82.231', '', '', '2', '2008-10-12', '0'), ('9119', '124.226.192.197', '', '', '1', '2008-10-12', '0'), ('9120', '121.8.239.149', '', '', '3', '2008-10-12', '0'), ('9121', '125.34.98.10', '', '', '1', '2008-10-12', '0'), ('9122', '58.53.104.105', '', '', '1', '2008-10-12', '0'), ('9123', '59.35.150.224', '', '', '1', '2008-10-12', '0'), ('9124', '125.91.238.21', '', '移动', '0', '2008-10-15', '1'), ('9125', '220.249.88.225', '', '', '1', '2008-10-12', '0'), ('9126', '120.87.214.71', '', '', '1', '2008-10-12', '0'), ('9127', '116.128.9.56', '', '', '1', '2008-10-12', '0'), ('9128', '222.91.78.80', '', '', '1', '2008-10-12', '0'), ('9129', '121.15.94.106', '', '', '9', '2008-10-12', '0'), ('9130', '221.194.18.244', '', '', '3', '2008-10-12', '0'), ('9131', '119.127.140.77', '', '', '1', '2008-10-12', '0'), ('9132', '211.138.227.123', '', '', '1', '2008-10-12', '0'), ('9133', '124.226.252.198', '', '', '2', '2008-10-12', '0'), ('9134', '119.130.119.111', '', '', '1', '2008-10-12', '0'), ('9135', '220.249.178.55', '', '', '1', '2008-10-12', '0'), ('9136', '218.13.162.14', '', '', '1', '2008-10-12', '0'), ('9137', '125.113.121.168', '', '', '3', '2008-10-12', '0'), ('9138', '218.19.11.136', '', '', '1', '2008-10-12', '0'), ('9139', '219.238.200.38', '', '', '1', '2008-10-12', '0'), ('9140', '116.25.26.232', '', '', '1', '2008-10-12', '0'), ('9141', '222.88.123.100', '', '', '1', '2008-10-12', '0'), ('9142', '218.19.32.150', '', '', '1', '2008-10-12', '0'), ('9143', '61.146.227.45', '', '', '5', '2008-10-12', '0'), ('9144', '121.10.157.185', '', '', '1', '2008-10-12', '0'), ('9145', '59.41.207.105', '', '', '2', '2008-10-12', '0'), ('9146', '116.16.113.19', '', '', '1', '2008-10-12', '0'), ('9147', '218.107.37.128', '', '', '1', '2008-10-12', '0'), ('9148', '125.127.155.168', '', '', '1', '2008-10-13', '0'), ('9149', '117.80.66.224', '', '', '1', '2008-10-13', '0'), ('9150', '116.21.193.60', '', '', '1', '2008-10-13', '0'), ('9151', '222.72.76.147', '', '', '2', '2008-10-13', '0'), ('9152', '60.182.156.160', '', '', '1', '2008-10-13', '0'), ('9153', '119.122.56.91', '', '', '2', '2008-10-13', '0'), ('9154', '118.192.2.198', '', '', '1', '2008-10-13', '0'), ('9155', '221.225.209.242', '', '', '1', '2008-10-13', '0'), ('9156', '221.221.166.21', '', '', '1', '2008-10-13', '0'), ('9157', '116.25.5.119', '', '', '1', '2008-10-13', '0'), ('9158', '211.147.254.233', '', '', '1', '2008-10-13', '0'), ('9159', '59.39.67.170', '', '', '1', '2008-10-13', '0'), ('9160', '212.96.26.180', '', '', '1', '2008-10-13', '0'), ('9161', '59.34.164.140', '', '', '4', '2008-10-13', '0'), ('9162', '125.93.74.84', '', '', '1', '2008-10-13', '0'), ('9163', '211.138.227.102', '', '', '1', '2008-10-13', '0'), ('9164', '125.91.238.24', '', '移动', '0', '2008-10-15', '1'), ('9165', '116.16.168.206', '', '', '1', '2008-10-13', '0'), ('9166', '124.126.81.24', '', '', '1', '2008-10-13', '0'), ('9167', '61.140.190.170', '', '', '5', '2008-10-13', '0'), ('9168', '60.219.163.181', '', '', '1', '2008-10-13', '0'), ('9169', '60.161.111.226', '', '', '1', '2008-10-13', '0'), ('9170', '58.60.33.23', '', '', '4', '2008-10-13', '0'), ('9171', '59.57.30.40', '', '', '1', '2008-10-13', '0'), ('9172', '117.28.190.97', '', '', '1', '2008-10-13', '0'), ('9173', '119.141.98.69', '', '', '2', '2008-10-13', '0'), ('9174', '123.118.118.174', '', '', '1', '2008-10-13', '0'), ('9175', '58.59.184.110', '', '', '1', '2008-10-13', '0'), ('9176', '123.117.170.2', '', '', '1', '2008-10-13', '0'), ('9177', '58.61.149.209', '', '', '1', '2008-10-13', '0'), ('9178', '61.138.254.44', '', '', '1', '2008-10-13', '0'), ('9179', '58.44.145.165', '', '', '1', '2008-10-13', '0'), ('9180', '218.72.74.137', '', '', '1', '2008-10-13', '0'), ('9181', '116.25.169.85', '', '', '1', '2008-10-13', '0'), ('9182', '59.40.121.153', '', '', '1', '2008-10-13', '0'), ('9183', '116.20.44.92', '', '', '1', '2008-10-13', '0'), ('9184', '119.127.225.115', '', '', '16', '2008-10-13', '0'), ('9185', '124.112.22.237', '', '', '2', '2008-10-13', '0'), ('9186', '117.24.129.230', '', '', '3', '2008-10-13', '0'), ('9187', '205.142.19.166', '', '', '1', '2008-10-13', '0'), ('9188', '219.136.13.192', '', '', '1', '2008-10-13', '0'), ('9189', '210.51.244.182', '', '', '1', '2008-10-13', '0'), ('9190', '59.107.9.187', '', '', '1', '2008-10-13', '0'), ('9191', '218.19.2.160', '', '', '1', '2008-10-13', '0'), ('9192', '59.42.32.233', '', '', '2', '2008-10-13', '0'), ('9193', '116.26.155.69', '', '', '1', '2008-10-13', '0'), ('9194', '124.163.176.2', '', '', '1', '2008-10-13', '0'), ('9195', '121.12.203.185', '', '', '1', '2008-10-13', '0'), ('9196', '220.181.66.231', '', '', '1', '2008-10-13', '0'), ('9197', '219.157.173.198', '', '', '2', '2008-10-13', '0'), ('9198', '219.136.97.179', '', '', '1', '2008-10-13', '0'), ('9199', '219.133.251.213', '', '', '1', '2008-10-13', '0'), ('9200', '58.248.226.136', '', '', '1', '2008-10-13', '0'), ('9201', '58.213.252.72', '', '', '1', '2008-10-13', '0'), ('9202', '222.172.250.99', '', '', '1', '2008-10-13', '0'), ('9203', '117.28.6.70', '', '', '1', '2008-10-13', '0'), ('9204', '60.178.209.102', '', '', '1', '2008-10-13', '0'), ('9205', '121.8.239.35', '', '', '1', '2008-10-13', '0'), ('9206', '120.0.219.151', '', '', '4', '2008-10-13', '0'), ('9207', '220.206.235.82', '', '', '2', '2008-10-13', '0'), ('9208', '220.192.161.142', '', '', '1', '2008-10-13', '0'), ('9209', '211.138.218.86', '', '', '1', '2008-10-13', '0'), ('9210', '122.4.5.222', '', '', '1', '2008-10-13', '0'), ('9211', '221.221.23.49', '', '', '1', '2008-10-13', '0'), ('9212', '211.94.125.226', '', '', '2', '2008-10-13', '0'), ('9213', '218.204.254.117', '', '', '2', '2008-10-13', '0'), ('9214', '58.50.20.138', '', '', '19', '2008-10-14', '0'), ('9215', '119.125.3.31', '', '', '4', '2008-10-14', '0'), ('9216', '116.23.109.208', '', '', '1', '2008-10-14', '0'), ('9217', '211.143.30.75', '', '', '1', '2008-10-14', '0'), ('9218', '116.21.58.194', '', '', '2', '2008-10-14', '0'), ('9219', '121.15.37.79', '', '', '1', '2008-10-14', '0'), ('9220', '119.123.85.178', '', '', '2', '2008-10-14', '0'), ('9221', '60.166.228.232', '', '', '1', '2008-10-14', '0'), ('9222', '124.226.252.241', '', '', '3', '2008-10-14', '0'), ('9223', '220.181.66.255', '', '', '1', '2008-10-14', '0'), ('9224', '202.144.216.120', '', '', '1', '2008-10-14', '0'), ('9225', '41.223.4.35', '', '', '1', '2008-10-14', '0'), ('9226', '218.205.249.137', '', '', '1', '2008-10-14', '0'), ('9227', '125.78.193.197', '', '', '1', '2008-10-14', '0'), ('9228', '211.136.75.90', '', '', '1', '2008-10-14', '0'), ('9229', '211.138.218.90', '', '', '1', '2008-10-14', '0'), ('9230', '211.136.113.238', '', '', '1', '2008-10-14', '0'), ('9231', '220.206.245.3', '', '', '1', '2008-10-14', '0'), ('9232', '125.116.44.221', '', '', '1', '2008-10-14', '0'), ('9233', '220.206.245.6', '', '', '1', '2008-10-14', '0'), ('9234', '195.189.143.49', '', '', '2', '2008-10-14', '0'), ('9235', '116.128.17.98', '', '', '1', '2008-10-14', '0'), ('9236', '219.137.38.37', '', '', '5', '2008-10-14', '0'), ('9237', '61.140.135.20', '', '', '1', '2008-10-14', '0'), ('9238', '218.19.90.212', '', '', '2', '2008-10-14', '0'), ('9239', '211.138.227.73', '', '', '2', '2008-10-14', '0'), ('9240', '195.189.142.88', '', '', '2', '2008-10-14', '0'), ('9241', '211.136.113.207', '', '', '1', '2008-10-14', '0'), ('9242', '119.124.1.69', '', '', '1', '2008-10-14', '0'), ('9243', '222.184.199.214', '', '', '2', '2008-10-14', '0'), ('9244', '220.206.235.73', '', '', '1', '2008-10-14', '0'), ('9245', '116.21.118.45', '', '', '2', '2008-10-14', '0'), ('9246', '203.142.126.51', '', '', '1', '2008-10-14', '0'), ('9247', '219.93.152.34', '', '', '1', '2008-10-14', '0'), ('9248', '124.236.159.115', '', '', '1', '2008-10-14', '0'), ('9249', '211.136.158.169', '', '', '2', '2008-10-14', '0'), ('9250', '116.16.229.186', '', '', '1', '2008-10-14', '0'), ('9251', '217.201.6.172', '', '', '2', '2008-10-14', '0'), ('9252', '116.4.138.97', '', '', '1', '2008-10-14', '0'), ('9253', '217.202.105.94', '', '', '1', '2008-10-14', '0'), ('9254', '220.164.2.9', '', '', '2', '2008-10-14', '0'), ('9255', '119.131.135.185', '', '', '1', '2008-10-14', '0'), ('9256', '218.204.253.124', '', '', '2', '2008-10-14', '0'), ('9257', '211.138.218.96', '', '', '1', '2008-10-14', '0'), ('9258', '123.113.34.246', '', '', '1', '2008-10-14', '0'), ('9259', '222.83.151.35', '', '', '1', '2008-10-14', '0'), ('9260', '61.142.114.74', '', '', '4', '2008-10-14', '0'), ('9261', '60.166.213.35', '', '', '1', '2008-10-14', '0'), ('9262', '119.122.72.165', '', '', '1', '2008-10-14', '0'), ('9263', '222.240.212.186', '', '', '1', '2008-10-14', '0'), ('9264', '124.236.204.42', '', '', '1', '2008-10-14', '0'), ('9265', '125.36.194.97', '', '', '3', '2008-10-14', '0'), ('9266', '119.122.184.4', '', '', '1', '2008-10-14', '0'), ('9267', '218.78.225.114', '', '', '1', '2008-10-14', '0'), ('9268', '116.30.207.141', '', '', '1', '2008-10-14', '0'), ('9269', '59.41.121.123', '', '', '1', '2008-10-14', '0'), ('9270', '74.6.22.185', '', '', '1', '2008-10-14', '0'), ('9271', '58.214.11.138', '', '', '2', '2008-10-14', '0'), ('9272', '121.13.114.83', '', '', '2', '2008-10-14', '0');
INSERT INTO `ig_gateway` VALUES ('9273', '121.33.118.147', '', '', '1', '2008-10-14', '0'), ('9274', '121.11.139.221', '', '', '1', '2008-10-14', '0'), ('9275', '58.253.22.243', '', '', '1', '2008-10-14', '0'), ('9276', '220.161.198.6', '', '', '1', '2008-10-14', '0'), ('9277', '121.8.243.50', '', '', '2', '2008-10-14', '0'), ('9278', '119.120.78.183', '', '', '1', '2008-10-14', '0'), ('9279', '125.90.12.29', '', '', '2', '2008-10-14', '0'), ('9280', '60.175.193.93', '', '', '1', '2008-10-14', '0'), ('9281', '219.133.65.22', '', '', '3', '2008-10-14', '0'), ('9282', '218.107.1.98', '', '', '1', '2008-10-14', '0'), ('9283', '211.138.227.80', '', '', '1', '2008-10-14', '0'), ('9284', '116.199.65.93', '', '', '50', '2008-10-14', '0'), ('9285', '211.136.75.95', '', '', '1', '2008-10-14', '0'), ('9286', '61.140.133.194', '', '', '1', '2008-10-15', '0'), ('9287', '218.13.29.235', '', '', '1', '2008-10-15', '0'), ('9288', '116.18.30.193', '', '', '2', '2008-10-15', '0'), ('9289', '125.90.72.120', '', '', '1', '2008-10-15', '0'), ('9290', '59.56.216.200', '', '', '1', '2008-10-15', '0'), ('9291', '114.138.226.72', '', '', '1', '2008-10-15', '0'), ('9292', '61.143.239.138', '', '', '3', '2008-10-15', '0'), ('9293', '59.172.137.227', '', '', '1', '2008-10-15', '0'), ('9294', '221.206.184.145', '', '', '1', '2008-10-15', '0'), ('9295', '58.210.116.121', '', '', '2', '2008-10-15', '0'), ('9296', '116.24.12.85', '', '', '2', '2008-10-15', '0'), ('9297', '123.4.247.104', '', '', '1', '2008-10-15', '0'), ('9298', '116.19.21.172', '', '', '1', '2008-10-15', '0'), ('9299', '60.168.82.87', '', '', '2', '2008-10-15', '0'), ('9300', '220.174.250.26', '', '', '1', '2008-10-15', '0'), ('9301', '218.19.68.113', '', '', '1', '2008-10-15', '0'), ('9302', '58.241.178.182', '', '', '1', '2008-10-15', '0'), ('9303', '222.222.138.16', '', '', '1', '2008-10-15', '0'), ('9304', '117.95.51.244', '', '', '1', '2008-10-15', '0'), ('9305', '211.138.218.112', '', '', '1', '2008-10-15', '0'), ('9306', '116.4.138.214', '', '', '1', '2008-10-15', '0'), ('9307', '222.141.14.29', '', '', '1', '2008-10-15', '0'), ('9308', '58.49.210.175', '', '', '2', '2008-10-15', '0'), ('9309', '219.148.140.70', '', '', '1', '2008-10-15', '0'), ('9310', '125.91.156.98', '', '', '1', '2008-10-15', '0'), ('9311', '61.142.212.162', '', '', '1', '2008-10-15', '0'), ('9312', '58.252.160.167', '', '', '1', '2008-10-15', '0'), ('9313', '219.128.134.127', '', '', '2', '2008-10-15', '0'), ('9314', '58.253.144.132', '', '', '1', '2008-10-15', '0'), ('9315', '121.62.153.105', '', '', '1', '2008-10-15', '0'), ('9316', '60.186.12.48', '', '', '1', '2008-10-15', '0'), ('9317', '121.8.83.211', '', '', '1', '2008-10-15', '0'), ('9318', '123.64.18.230', '', '', '1', '2008-10-15', '0'), ('9319', '58.211.21.66', '', '移动', '0', '2008-10-15', '1'), ('9320', '58.211.21.67', '', '移动', '0', '2008-10-15', '1'), ('9321', '58.211.21.75', '', '移动', '0', '2008-10-15', '1'), ('9322', '58.211.21.105', '', '移动', '0', '2008-10-15', '1'), ('9323', '58.211.21.106', '', '移动', '0', '2008-10-15', '1'), ('9324', '58.211.21.107', '', '移动', '0', '2008-10-15', '1'), ('9325', '58.211.21.108', '', '移动', '0', '2008-10-15', '1'), ('9326', '58.211.21.109', '', '移动', '0', '2008-10-15', '1'), ('9327', '58.211.21.110', '', '移动', '0', '2008-10-15', '1'), ('9328', '61.141.5.40', '', '移动', '0', '2008-10-15', '1'), ('9329', '61.141.5.41', '', '移动', '0', '2008-10-15', '1'), ('9331', '67.228.166.101', '', '移动', '0', '2008-10-15', '1'), ('9332', '67.228.166.102', '', '移动', '0', '2008-10-15', '1'), ('9333', '67.228.174.48', '', '移动', '0', '2008-10-15', '1'), ('9334', '67.228.174.49', '', '移动', '0', '2008-10-15', '1'), ('9335', '67.228.174.50', '', '移动', '0', '2008-10-15', '1'), ('9336', '67.228.174.51', '', '移动', '0', '2008-10-15', '1'), ('9337', '67.228.174.52', '', '移动', '0', '2008-10-15', '1'), ('9338', '67.228.174.53', '', '移动', '0', '2008-10-15', '1'), ('9339', '67.228.174.54', '', '移动', '0', '2008-10-15', '1'), ('9340', '67.228.174.55', '', '移动', '0', '2008-10-15', '1'), ('9341', '67.228.174.64', '', '移动', '0', '2008-10-15', '1'), ('9342', '67.228.174.65', '', '移动', '0', '2008-10-15', '1'), ('9343', '67.228.174.66', '', '移动', '0', '2008-10-15', '1'), ('9344', '67.228.174.67', '', '移动', '0', '2008-10-15', '1'), ('9345', '67.228.174.68', '', '移动', '0', '2008-10-15', '1'), ('9346', '67.228.174.69', '', '移动', '0', '2008-10-15', '1'), ('9347', '67.228.174.70', '', '移动', '0', '2008-10-15', '1'), ('9348', '67.228.174.71', '', '移动', '0', '2008-10-15', '1'), ('9349', '67.228.174.72', '', '移动', '0', '2008-10-15', '1'), ('9350', '67.228.174.73', '', '移动', '0', '2008-10-15', '1'), ('9351', '67.228.174.74', '', '移动', '0', '2008-10-15', '1'), ('9352', '67.228.174.75', '', '移动', '0', '2008-10-15', '1'), ('9353', '67.228.174.76', '', '移动', '0', '2008-10-15', '1'), ('9354', '67.228.174.77', '', '移动', '0', '2008-10-15', '1'), ('9355', '67.228.174.78', '', '移动', '0', '2008-10-15', '1'), ('9356', '67.228.174.79', '', '移动', '0', '2008-10-15', '1'), ('9357', '67.228.174.56', '', '移动', '0', '2008-10-15', '1'), ('9358', '67.228.174.57', '', '移动', '0', '2008-10-15', '1'), ('9359', '67.228.174.58', '', '移动', '0', '2008-10-15', '1'), ('9360', '67.228.174.59', '', '移动', '0', '2008-10-15', '1'), ('9361', '67.228.174.60', '', '移动', '0', '2008-10-15', '1'), ('9362', '67.228.174.61', '', '移动', '0', '2008-10-15', '1'), ('9363', '67.228.174.62', '', '移动', '0', '2008-10-15', '1'), ('9364', '67.228.174.63', '', '移动', '0', '2008-10-15', '1'), ('9365', '125.91.4.140', '', '移动', '0', '2008-10-15', '1'), ('9366', '125.91.4.141', '', '移动', '0', '2008-10-15', '1'), ('9367', '125.91.4.142', '', '移动', '0', '2008-10-15', '1'), ('9368', '125.91.4.143', '', '移动', '0', '2008-10-15', '1'), ('9369', '125.91.4.144', '', '移动', '0', '2008-10-15', '1'), ('9370', '125.91.4.145', '', '移动', '0', '2008-10-15', '1'), ('9371', '125.91.4.146', '', '移动', '0', '2008-10-15', '1'), ('9372', '125.91.4.149', '', '移动', '0', '2008-10-15', '1'), ('9374', '125.91.4.161', '', '移动', '0', '2008-10-15', '1'), ('9376', '125.91.4.163', '', '移动', '0', '2008-10-15', '1'), ('9379', '125.91.4.166', '', '移动', '0', '2008-10-15', '1'), ('9380', '125.91.4.167', '', '移动', '0', '2008-10-15', '1'), ('9381', '125.91.4.168', '', '移动', '0', '2008-10-15', '1'), ('9383', '125.91.4.173', '', '移动', '0', '2008-10-15', '1'), ('9384', '125.91.4.175', '', '移动', '0', '2008-10-15', '1'), ('9385', '125.91.4.180', '', '移动', '0', '2008-10-15', '1'), ('9386', '125.91.4.181', '', '移动', '0', '2008-10-15', '1'), ('9387', '125.91.4.182', '', '移动', '0', '2008-10-15', '1'), ('9388', '125.91.4.184', '', '移动', '0', '2008-10-15', '1'), ('9389', '125.91.5.43', '', '移动', '0', '2008-10-15', '1'), ('9390', '125.91.5.44', '', '移动', '0', '2008-10-15', '1'), ('9391', '125.91.5.45', '', '移动', '0', '2008-10-15', '1'), ('9392', '125.91.5.46', '', '移动', '0', '2008-10-15', '1'), ('9393', '125.91.5.47', '', '移动', '0', '2008-10-15', '1'), ('9394', '125.91.5.48', '', '移动', '0', '2008-10-15', '1'), ('9395', '125.91.5.49', '', '移动', '0', '2008-10-15', '1'), ('9396', '125.91.5.50', '', '移动', '0', '2008-10-15', '1'), ('9397', '125.91.5.52', '', '移动', '0', '2008-10-15', '1'), ('9398', '125.91.5.53', '', '移动', '0', '2008-10-15', '1'), ('9399', '125.91.5.55', '', '移动', '0', '2008-10-15', '1'), ('9400', '125.91.5.56', '', '移动', '0', '2008-10-15', '1'), ('9401', '125.91.5.57', '', '移动', '0', '2008-10-15', '1'), ('9402', '125.91.229.34', '', '移动', '0', '2008-10-15', '1'), ('9403', '125.91.229.35', '', '移动', '0', '2008-10-15', '1'), ('9404', '125.91.229.36', '', '移动', '0', '2008-10-15', '1'), ('9405', '125.91.229.37', '', '移动', '0', '2008-10-15', '1'), ('9406', '125.91.229.38', '', '移动', '0', '2008-10-15', '1'), ('9407', '125.91.229.39', '', '移动', '0', '2008-10-15', '1'), ('9408', '125.91.229.45', '', '移动', '0', '2008-10-15', '1'), ('9409', '125.91.229.46', '', '移动', '0', '2008-10-15', '1'), ('9410', '125.91.229.47', '', '移动', '0', '2008-10-15', '1'), ('9411', '125.91.229.48', '', '移动', '0', '2008-10-15', '1'), ('9412', '125.91.253.46', '', '移动', '0', '2008-10-15', '1'), ('9413', '125.91.253.47', '', '移动', '0', '2008-10-15', '1'), ('9414', '125.91.253.82', '', '移动', '0', '2008-10-15', '1'), ('9415', '125.91.253.83', '', '移动', '0', '2008-10-15', '1'), ('9416', '125.91.253.84', '', '移动', '0', '2008-10-15', '1'), ('9417', '125.91.253.85', '', '移动', '0', '2008-10-15', '1'), ('9418', '125.91.253.86', '', '移动', '0', '2008-10-15', '1'), ('9419', '125.91.253.87', '', '移动', '0', '2008-10-15', '1'), ('9420', '125.91.253.88', '', '移动', '0', '2008-10-15', '1'), ('9421', '125.91.253.89', '', '移动', '0', '2008-10-15', '1'), ('9422', '125.91.253.90', '', '移动', '0', '2008-10-15', '1'), ('9423', '125.91.253.91', '', '移动', '0', '2008-10-15', '1'), ('9424', '125.91.253.92', '', '移动', '0', '2008-10-15', '1'), ('9425', '125.91.253.93', '', '移动', '0', '2008-10-15', '1'), ('9426', '125.91.253.94', '', '移动', '0', '2008-10-15', '1'), ('9427', '125.91.253.130', '', '移动', '0', '2008-10-15', '1'), ('9428', '125.91.253.131', '', '移动', '0', '2008-10-15', '1'), ('9429', '125.91.253.132', '', '移动', '0', '2008-10-15', '1'), ('9430', '125.91.253.133', '', '移动', '0', '2008-10-15', '1'), ('9431', '125.91.253.154', '', '移动', '0', '2008-10-15', '1'), ('9432', '125.91.253.155', '', '移动', '0', '2008-10-15', '1'), ('9433', '125.91.253.156', '', '移动', '0', '2008-10-15', '1'), ('9434', '125.91.253.157', '', '移动', '0', '2008-10-15', '1'), ('9435', '125.91.253.158', '', '移动', '0', '2008-10-15', '1'), ('9436', '125.91.253.159', '', '移动', '0', '2008-10-15', '1'), ('9437', '125.91.253.171', '', '移动', '0', '2008-10-15', '1'), ('9438', '125.91.253.172', '', '移动', '0', '2008-10-15', '1'), ('9439', '125.91.253.173', '', '移动', '0', '2008-10-15', '1'), ('9440', '125.91.253.174', '', '移动', '0', '2008-10-15', '1'), ('9441', '125.91.253.175', '', '移动', '0', '2008-10-15', '1'), ('9442', '125.91.253.176', '', '移动', '0', '2008-10-15', '1'), ('9443', '218.30.107.226', '', '移动', '0', '2008-10-15', '1'), ('9444', '218.30.107.227', '', '移动', '0', '2008-10-15', '1'), ('9445', '218.30.107.228', '', '移动', '0', '2008-10-15', '1'), ('9446', '218.30.107.245', '', '移动', '0', '2008-10-15', '1'), ('9447', '218.30.107.246', '', '移动', '0', '2008-10-15', '1'), ('9448', '218.30.107.247', '', '移动', '0', '2008-10-15', '1'), ('9449', '218.30.107.248', '', '移动', '0', '2008-10-15', '1'), ('9450', '218.30.107.249', '', '移动', '0', '2008-10-15', '1'), ('9451', '218.30.110.168', '', '移动', '0', '2008-10-15', '1'), ('9452', '218.204.252.117', '', '移动', '0', '2008-10-15', '1'), ('9453', '218.204.252.119', '', '移动', '0', '2008-10-15', '1'), ('9454', '218.30.117.5', '', '移动', '0', '2008-10-15', '1'), ('9455', '218.30.117.6', '', '移动', '0', '2008-10-15', '1'), ('9456', '116.29.152.222', '', '', '1', '2008-10-15', '0'), ('9457', '125.89.24.39', '', '', '1', '2008-10-16', '0'), ('9458', '221.130.33.30', '北京', '移动', '0', '2008-10-16', '1'), ('9459', '221.130.33.31', '北京', '移动', '0', '2008-10-16', '1'), ('9460', '221.130.33.40', '北京', '移动', '0', '2008-10-16', '1'), ('9461', '221.130.33.41', '北京', '移动', '0', '2008-10-16', '1'), ('9462', '221.130.33.42', '北京', '移动', '0', '2008-10-16', '1'), ('9463', '221.130.33.43', '北京', '移动', '0', '2008-10-16', '1'), ('9464', '221.130.33.44', '北京', '移动', '0', '2008-10-16', '1'), ('9465', '221.130.33.45', '北京', '移动', '0', '2008-10-16', '1'), ('9466', '221.130.33.46', '北京', '移动', '0', '2008-10-16', '1'), ('9467', '221.130.33.47', '北京', '移动', '0', '2008-10-16', '1'), ('9468', '221.130.33.48', '北京', '移动', '0', '2008-10-16', '1'), ('9469', '221.130.33.28', '北京', '移动', '0', '2008-10-16', '1'), ('9470', '218.249.251.194', '北京', '移动', '0', '2008-10-16', '1'), ('9471', '211.136.83.84', '北京', '移动', '0', '2008-10-16', '1'), ('9472', '60.195.251.33', '北京', '移动', '0', '2008-10-16', '1'), ('9473', '211.136.83.81', '北京', '移动', '0', '2008-10-16', '1'), ('9474', '221.221.238.113', '北京', '移动', '0', '2008-10-16', '1'), ('9475', '221.221.241.78', '北京', '移动', '0', '2008-10-16', '1'), ('9476', '221.221.241.232', '北京', '移动', '0', '2008-10-16', '1'), ('9477', '60.195.251.29', '北京', '移动', '0', '2008-10-16', '1'), ('9478', '218.249.120.174', '北京', '移动', '0', '2008-10-16', '1'), ('9479', '211.94.138.55', '北京', '移动', '0', '2008-10-16', '1'), ('9480', '218.240.131.222', '北京', '移动', '0', '2008-10-16', '1'), ('9481', '60.195.251.31', '北京', '移动', '0', '2008-10-16', '1'), ('9482', '218.240.131.218', '北京', '移动', '0', '2008-10-16', '1'), ('9483', '220.181.31.170', '北京', '移动', '0', '2008-10-16', '1'), ('9484', '202.106.180.62', '北京', '移动', '0', '2008-10-16', '1'), ('9485', '211.94.164.221', '北京', '移动', '0', '2008-10-16', '1'), ('9486', '202.106.184.178', '北京', '移动', '0', '2008-10-16', '1'), ('9487', '202.91.186.130', '北京', '移动', '0', '2008-10-16', '1'), ('9488', '60.195.251.49', '北京', '移动', '0', '2008-10-16', '1'), ('9489', '211.136.74.82', '北京', '移动', '0', '2008-10-16', '1'), ('9490', '61.135.170.29', '北京', '移动', '0', '2008-10-16', '1'), ('9491', '218.240.131.220', '北京', '移动', '0', '2008-10-16', '1'), ('9492', '221.223.227.247', '北京', '移动', '0', '2008-10-16', '1'), ('9493', '203.86.78.130', '北京', '移动', '0', '2008-10-16', '1'), ('9494', '61.148.45.110', '北京', '移动', '0', '2008-10-16', '1'), ('9495', '61.49.114.95', '北京', '移动', '0', '2008-10-16', '1'), ('9496', '210.82.61.150', '北京', '移动', '0', '2008-10-16', '1'), ('9497', '218.249.105.83', '北京', '移动', '0', '2008-10-16', '1'), ('9498', '202.106.184.193', '北京', '移动', '0', '2008-10-16', '1'), ('9499', '61.149.83.62', '北京', '移动', '0', '2008-10-16', '1'), ('9500', '218.247.140.213', '北京', '移动', '0', '2008-10-16', '1'), ('9501', '221.220.113.52', '北京', '移动', '0', '2008-10-16', '1'), ('9502', '221.216.140.182', '北京', '移动', '0', '2008-10-16', '1'), ('9503', '221.216.77.87', '北京', '移动', '0', '2008-10-16', '1'), ('9504', '218.249.112.2', '北京', '移动', '0', '2008-10-16', '1'), ('9505', '61.135.154.20', '北京', '移动', '0', '2008-10-16', '1'), ('9506', '202.106.184.194', '北京', '移动', '0', '2008-10-16', '1'), ('9507', '222.128.33.228', '北京', '移动', '0', '2008-10-16', '1'), ('9508', '211.94.67.216', '北京', '移动', '0', '2008-10-16', '1'), ('9509', '218.97.253.211', '北京', '移动', '0', '2008-10-16', '1'), ('9510', '220.181.24.107', '北京', '移动', '0', '2008-10-16', '1'), ('9511', '218.247.140.214', '北京', '移动', '0', '2008-10-16', '1'), ('9512', '61.49.9.140', '北京', '移动', '0', '2008-10-16', '1'), ('9513', '61.48.138.3', '北京', '移动', '0', '2008-10-16', '1'), ('9514', '211.99.10.2', '北京', '移动', '0', '2008-10-16', '1'), ('9515', '211.94.69.240', '北京', '移动', '0', '2008-10-16', '1'), ('9516', '218.247.140.199', '北京', '移动', '0', '2008-10-16', '1'), ('9517', '219.142.172.32', '北京', '移动', '0', '2008-10-16', '1'), ('9518', '218.247.14.130', '北京', '移动', '0', '2008-10-16', '1'), ('9519', '61.135.152.194', '北京', '移动', '0', '2008-10-16', '1'), ('9520', '218.249.90.115', '北京', '移动', '0', '2008-10-16', '1'), ('9521', '219.239.109.235', '北京', '移动', '0', '2008-10-16', '1'), ('9522', '211.155.166.1', '北京', '移动', '0', '2008-10-16', '1'), ('9523', '221.221.237.38', '北京', '移动', '0', '2008-10-16', '1'), ('9524', '221.220.114.38', '北京', '移动', '0', '2008-10-16', '1'), ('9526', '219.142.177.97', '北京', '移动', '0', '2008-10-16', '1'), ('9527', '218.247.201.75', '北京', '移动', '0', '2008-10-16', '1'), ('9528', '202.108.1.3', '北京', '移动', '0', '2008-10-16', '1'), ('9529', '221.216.77.148', '北京', '移动', '0', '2008-10-16', '1'), ('9530', '219.142.249.146', '北京', '移动', '0', '2008-10-16', '1'), ('9531', '61.49.114.63', '北京', '移动', '0', '2008-10-16', '1'), ('9532', '220.181.24.170', '北京', '移动', '0', '2008-10-16', '1'), ('9533', '219.238.157.60', '北京', '移动', '0', '2008-10-16', '1'), ('9534', '202.108.4.123', '北京', '移动', '0', '2008-10-16', '1'), ('9535', '203.212.6.139', '北京', '移动', '0', '2008-10-16', '1'), ('9536', '218.247.140.198', '北京', '移动', '0', '2008-10-16', '1'), ('9537', '221.222.23.150', '北京', '移动', '0', '2008-10-16', '1'), ('9538', '60.195.251.85', '北京', '移动', '0', '2008-10-16', '1'), ('9539', '202.108.4.125', '北京', '移动', '0', '2008-10-16', '1'), ('9540', '202.108.4.122', '北京', '移动', '0', '2008-10-16', '1'), ('9541', '219.142.191.122', '北京', '移动', '0', '2008-10-16', '1'), ('9542', '219.239.217.8', '北京', '移动', '0', '2008-10-16', '1'), ('9543', '203.86.78.131', '北京', '移动', '0', '2008-10-16', '1'), ('9544', '61.149.83.134', '北京', '移动', '0', '2008-10-16', '1'), ('9545', '219.142.237.56', '北京', '移动', '0', '2008-10-16', '1'), ('9546', '211.167.225.41', '北京', '移动', '0', '2008-10-16', '1'), ('9547', '221.221.172.130', '北京', '移动', '0', '2008-10-16', '1'), ('9548', '202.108.1.15', '北京', '移动', '0', '2008-10-16', '1'), ('9549', '202.108.1.13', '北京', '移动', '0', '2008-10-16', '1'), ('9550', '222.130.201.144', '北京', '移动', '0', '2008-10-16', '1'), ('9551', '203.187.187.150', '北京', '移动', '0', '2008-10-16', '1'), ('9552', '202.108.1.4', '北京', '移动', '0', '2008-10-16', '1'), ('9553', '202.108.1.9', '北京', '移动', '0', '2008-10-16', '1'), ('9554', '124.42.31.101', '北京', '移动', '0', '2008-10-16', '1'), ('9555', '219.142.248.27', '北京', '移动', '0', '2008-10-16', '1'), ('9556', '202.108.1.10', '北京', '移动', '0', '2008-10-16', '1'), ('9557', '221.220.26.236', '北京', '移动', '0', '2008-10-16', '1'), ('9558', '219.239.109.226', '北京', '移动', '0', '2008-10-16', '1'), ('9559', '211.136.73.8', '北京', '移动', '0', '2008-10-16', '1'), ('9560', '211.136.74.115', '北京', '移动', '0', '2008-10-16', '1'), ('9561', '218.97.243.172', '北京', '移动', '0', '2008-10-16', '1'), ('9562', '202.108.1.6', '北京', '移动', '0', '2008-10-16', '1'), ('9563', '219.142.192.187', '北京', '移动', '0', '2008-10-16', '1'), ('9564', '221.216.76.36', '北京', '移动', '0', '2008-10-16', '1'), ('9565', '193.113.200.172', '北京', '移动', '0', '2008-10-16', '1'), ('9566', '211.136.74.85', '北京', '移动', '0', '2008-10-16', '1'), ('9567', '202.108.207.35', '北京', '移动', '0', '2008-10-16', '1'), ('9568', '211.100.252.243', '北京', '移动', '0', '2008-10-16', '1'), ('9569', '211.136.74.23', '北京', '移动', '0', '2008-10-16', '1'), ('9570', '218.249.47.66', '北京', '移动', '0', '2008-10-16', '1'), ('9571', '210.82.111.241', '北京', '移动', '0', '2008-10-16', '1'), ('9572', '211.136.73.32', '北京', '移动', '0', '2008-10-16', '1'), ('9573', '203.86.78.39', '北京', '移动', '0', '2008-10-16', '1'), ('9574', '203.81.27.1', '北京', '移动', '0', '2008-10-16', '1'), ('9575', '219.142.251.172', '北京', '移动', '0', '2008-10-16', '1'), ('9576', '124.42.104.6', '北京', '移动', '0', '2008-10-16', '1'), ('9577', '211.136.74.5', '北京', '移动', '0', '2008-10-16', '1'), ('9578', '202.108.1.12', '北京', '移动', '0', '2008-10-16', '1'), ('9579', '202.108.1.2', '北京', '移动', '0', '2008-10-16', '1'), ('9580', '211.136.73.2', '北京', '移动', '0', '2008-10-16', '1'), ('9581', '221.220.122.118', '北京', '移动', '0', '2008-10-16', '1'), ('9582', '211.136.73.26', '北京', '移动', '0', '2008-10-16', '1'), ('9583', '219.142.122.14', '北京', '移动', '0', '2008-10-16', '1'), ('9584', '210.72.234.87', '北京', '移动', '0', '2008-10-16', '1'), ('9585', '221.221.10.42', '北京', '移动', '0', '2008-10-16', '1'), ('9586', '211.136.74.26', '北京', '移动', '0', '2008-10-16', '1'), ('9587', '202.108.91.190', '北京', '移动', '0', '2008-10-16', '1'), ('9588', '61.149.215.29', '北京', '移动', '0', '2008-10-16', '1'), ('9589', '211.136.74.105', '北京', '移动', '0', '2008-10-16', '1'), ('9590', '221.219.196.222', '北京', '移动', '0', '2008-10-16', '1'), ('9591', '211.136.74.61', '北京', '移动', '0', '2008-10-16', '1'), ('9592', '219.239.238.252', '北京', '移动', '0', '2008-10-16', '1'), ('9593', '220.205.138.187', '北京', '移动', '0', '2008-10-16', '1'), ('9594', '211.136.74.9', '北京', '移动', '0', '2008-10-16', '1'), ('9595', '211.136.74.75', '北京', '移动', '0', '2008-10-16', '1'), ('9596', '220.181.19.96', '北京', '移动', '0', '2008-10-16', '1'), ('9597', '202.91.186.139', '北京', '移动', '0', '2008-10-16', '1'), ('9598', '221.217.230.144', '北京', '移动', '0', '2008-10-16', '1'), ('9599', '211.136.73.31', '北京', '移动', '0', '2008-10-16', '1'), ('9600', '221.216.4.111', '北京', '移动', '0', '2008-10-16', '1'), ('9601', '211.136.74.90', '北京', '移动', '0', '2008-10-16', '1'), ('9602', '221.221.175.232', '北京', '移动', '0', '2008-10-16', '1'), ('9603', '203.86.94.109', '北京', '移动', '0', '2008-10-16', '1'), ('9604', '220.205.155.32', '北京', '移动', '0', '2008-10-16', '1'), ('9605', '219.142.193.198', '北京', '移动', '0', '2008-10-16', '1'), ('9606', '61.49.114.112', '北京', '移动', '0', '2008-10-16', '1'), ('9607', '211.136.74.81', '北京', '移动', '0', '2008-10-16', '1'), ('9608', '211.136.74.39', '北京', '移动', '0', '2008-10-16', '1'), ('9609', '202.108.4.126', '北京', '移动', '0', '2008-10-16', '1'), ('9610', '211.136.74.11', '北京', '移动', '0', '2008-10-16', '1'), ('9611', '222.130.205.22', '北京', '移动', '0', '2008-10-16', '1'), ('9612', '211.136.73.7', '北京', '移动', '0', '2008-10-16', '1'), ('9613', '61.49.221.216', '北京', '移动', '0', '2008-10-16', '1'), ('9614', '221.216.101.167', '北京', '移动', '0', '2008-10-16', '1'), ('9615', '218.249.109.98', '北京', '移动', '0', '2008-10-16', '1'), ('9616', '218.247.181.199', '北京', '移动', '0', '2008-10-16', '1'), ('9617', '219.142.239.226', '北京', '移动', '0', '2008-10-16', '1'), ('9618', '211.136.74.45', '北京', '移动', '0', '2008-10-16', '1'), ('9619', '219.237.176.148', '北京', '移动', '0', '2008-10-16', '1'), ('9620', '219.142.128.136', '北京', '移动', '0', '2008-10-16', '1'), ('9621', '219.142.237.213', '北京', '移动', '0', '2008-10-16', '1'), ('9622', '219.238.242.246', '北京', '移动', '0', '2008-10-16', '1'), ('9623', '220.205.57.55', '北京', '移动', '0', '2008-10-16', '1'), ('9624', '220.192.3.214', '北京', '移动', '0', '2008-10-16', '1'), ('9625', '219.142.226.188', '北京', '移动', '0', '2008-10-16', '1'), ('9626', '221.216.157.147', '北京', '移动', '0', '2008-10-16', '1'), ('9627', '221.122.54.66', '北京', '移动', '0', '2008-10-16', '1'), ('9628', '220.207.72.171', '北京', '移动', '0', '2008-10-16', '1'), ('9629', '221.222.188.29', '北京', '移动', '0', '2008-10-16', '1'), ('9630', '61.149.187.56', '北京', '移动', '0', '2008-10-16', '1'), ('9631', '221.219.195.149', '北京', '移动', '0', '2008-10-16', '1'), ('9632', '222.128.34.45', '北京', '移动', '0', '2008-10-16', '1'), ('9633', '61.51.241.223', '北京', '移动', '0', '2008-10-16', '1'), ('9634', '222.130.25.197', '北京', '移动', '0', '2008-10-16', '1'), ('9635', '203.86.94.99', '北京', '移动', '0', '2008-10-16', '1'), ('9636', '219.239.52.34', '北京', '移动', '0', '2008-10-16', '1'), ('9637', '219.142.177.96', '北京', '移动', '0', '2008-10-16', '1'), ('9638', '219.238.124.80', '北京', '移动', '0', '2008-10-16', '1'), ('9639', '61.51.195.6', '北京', '移动', '0', '2008-10-16', '1'), ('9640', '218.206.71.60', '北京', '移动', '0', '2008-10-16', '1'), ('9641', '211.136.74.114', '北京', '移动', '0', '2008-10-16', '1'), ('9642', '211.136.73.20', '北京', '移动', '0', '2008-10-16', '1'), ('9643', '211.136.74.124', '北京', '移动', '0', '2008-10-16', '1'), ('9644', '211.136.74.72', '北京', '移动', '0', '2008-10-16', '1'), ('9645', '211.136.73.1', '北京', '移动', '0', '2008-10-16', '1'), ('9646', '61.50.161.101', '北京', '移动', '0', '2008-10-16', '1'), ('9647', '220.207.73.251', '北京', '移动', '0', '2008-10-16', '1'), ('9648', '124.254.20.67', '北京', '移动', '0', '2008-10-16', '1'), ('9649', '221.218.199.41', '北京', '移动', '0', '2008-10-16', '1'), ('9650', '211.136.74.44', '北京', '移动', '0', '2008-10-16', '1'), ('9651', '219.142.253.127', '北京', '移动', '0', '2008-10-16', '1'), ('9652', '202.99.23.184', '北京', '移动', '0', '2008-10-16', '1'), ('9653', '221.222.191.252', '北京', '移动', '0', '2008-10-16', '1'), ('9654', '219.142.250.94', '北京', '移动', '0', '2008-10-16', '1'), ('9655', '221.219.169.60', '北京', '移动', '0', '2008-10-16', '1'), ('9656', '222.129.225.242', '北京', '移动', '0', '2008-10-16', '1'), ('9657', '202.99.16.85', '北京', '移动', '0', '2008-10-16', '1'), ('9658', '61.148.100.42', '北京', '移动', '0', '2008-10-16', '1'), ('9659', '220.205.45.126', '北京', '移动', '0', '2008-10-16', '1'), ('9660', '221.221.147.0', '北京', '移动', '0', '2008-10-16', '1'), ('9661', '211.136.74.99', '北京', '移动', '0', '2008-10-16', '1'), ('9662', '211.136.74.92', '北京', '移动', '0', '2008-10-16', '1'), ('9663', '221.221.154.225', '北京', '移动', '0', '2008-10-16', '1'), ('9664', '61.50.161.100', '北京', '移动', '0', '2008-10-16', '1'), ('9665', '211.136.16.37', '北京', '移动', '0', '2008-10-16', '1'), ('9666', '218.206.69.113', '北京', '移动', '0', '2008-10-16', '1'), ('9667', '221.130.33.32', '北京', '移动', '0', '2008-10-16', '1'), ('9668', '211.140.12.200', '北京', '移动', '0', '2008-10-16', '1'), ('9669', '221.130.33.33', '北京', '移动', '0', '2008-10-16', '1'), ('9670', '221.130.33.34', '北京', '移动', '0', '2008-10-16', '1'), ('9671', '221.130.33.35', '北京', '移动', '0', '2008-10-16', '1'), ('9672', '221.130.33.36', '北京', '移动', '0', '2008-10-16', '1'), ('9673', '221.130.33.37', '北京', '移动', '0', '2008-10-16', '1'), ('9674', '221.130.33.38', '北京', '移动', '0', '2008-10-16', '1'), ('9675', '202.96.60.53', '北京', '移动', '0', '2008-10-16', '1'), ('9676', '202.96.60.54', '北京', '移动', '0', '2008-10-16', '1'), ('9677', '218.106.172.241', '北京', '移动', '0', '2008-10-16', '1'), ('9678', '218.106.172.242', '北京', '移动', '0', '2008-10-16', '1'), ('9679', '218.106.172.243', '北京', '移动', '0', '2008-10-16', '1'), ('9680', '218.106.172.244', '北京', '移动', '0', '2008-10-16', '1'), ('9681', '218.106.172.245', '北京', '移动', '0', '2008-10-16', '1'), ('9682', '219.142.180.240', '北京', '移动', '0', '2008-10-16', '1'), ('9683', '219.238.9.194', '北京', '移动', '0', '2008-10-16', '1'), ('9684', '218.206.86.26', '北京', '移动', '0', '2008-10-16', '1'), ('9686', '61.50.161.105', '北京', '移动', '0', '2008-10-16', '1'), ('9687', '218.206.86.27', '北京', '移动', '0', '2008-10-16', '1'), ('9688', '218.206.86.143', '北京', '移动', '0', '2008-10-16', '1'), ('9689', '211.136.74.43', '北京', '移动', '0', '2008-10-16', '1'), ('9690', '211.94.164.201', '北京', '移动', '0', '2008-10-16', '1'), ('9691', '218.75.44.245', '浙江', '移动', '0', '2008-10-16', '1'), ('9692', '219.82.22.208', '浙江', '移动', '0', '2008-10-16', '1'), ('9693', '211.138.118.18', '浙江', '移动', '0', '2008-10-16', '1'), ('9694', '211.138.118.126', '浙江', '移动', '0', '2008-10-16', '1'), ('9695', '211.138.118.5', '浙江', '移动', '0', '2008-10-16', '1'), ('9696', '220.191.64.177', '浙江', '移动', '0', '2008-10-16', '1'), ('9697', '60.176.100.135', '浙江', '移动', '0', '2008-10-16', '1'), ('9698', '211.138.118.156', '浙江', '移动', '0', '2008-10-16', '1'), ('9699', '211.138.116.169', '浙江', '移动', '0', '2008-10-16', '1'), ('9700', '220.191.1.131', '浙江', '移动', '0', '2008-10-16', '1'), ('9701', '211.138.113.205', '浙江', '移动', '0', '2008-10-16', '1'), ('9702', '211.90.241.180', '浙江', '移动', '0', '2008-10-16', '1'), ('9703', '211.139.151.7', '广东', '移动', '0', '2008-10-16', '1'), ('9704', '211.139.145.19', '广东', '移动', '0', '2008-10-16', '1'), ('9705', '211.139.145.212', '广东', '移动', '0', '2008-10-16', '1'), ('9706', '211.139.145.21', '广东', '移动', '0', '2008-10-16', '1'), ('9707', '211.139.189.179', '广东', '移动', '0', '2008-10-16', '1'), ('9708', '211.139.189.38', '广东', '移动', '0', '2008-10-16', '1'), ('9709', '211.139.145.211', '广东', '移动', '0', '2008-10-16', '1'), ('9710', '211.139.189.35', '广东', '移动', '0', '2008-10-16', '1'), ('9711', '211.136.200.189', '广东', '移动', '0', '2008-10-16', '1'), ('9712', '211.136.200.131', '广东', '移动', '0', '2008-10-16', '1'), ('9713', '211.139.163.13', '广东', '移动', '0', '2008-10-16', '1'), ('9714', '211.139.190.121', '广东', '移动', '0', '2008-10-16', '1'), ('9715', '211.136.228.65', '广东', '移动', '0', '2008-10-16', '1'), ('9716', '211.139.190.130', '广东', '移动', '0', '2008-10-16', '1'), ('9717', '211.139.190.132', '广东', '移动', '0', '2008-10-16', '1'), ('9718', '211.139.190.23', '广东', '移动', '0', '2008-10-16', '1'), ('9719', '218.204.243.2', '广东', '移动', '0', '2008-10-16', '1'), ('9720', '211.139.190.2', '广东', '移动', '0', '2008-10-16', '1'), ('9721', '211.139.190.20', '广东', '移动', '0', '2008-10-16', '1'), ('9722', '211.136.228.74', '广东', '移动', '0', '2008-10-16', '1'), ('9723', '211.139.190.131', '广东', '移动', '0', '2008-10-16', '1'), ('9724', '218.204.243.4', '广东', '移动', '0', '2008-10-16', '1'), ('9725', '211.139.190.124', '广东', '移动', '0', '2008-10-16', '1'), ('9726', '211.136.228.66', '广东', '移动', '0', '2008-10-16', '1'), ('9727', '125.91.4.164', '广东', '移动', '0', '2008-10-16', '1'), ('9728', '125.91.4.147', '广东', '移动', '0', '2008-10-16', '1'), ('9729', '125.91.4.162', '广东', '移动', '0', '2008-10-16', '1'), ('9730', '125.91.4.165', '广东', '移动', '0', '2008-10-16', '1'), ('9731', '125.91.4.154', '广东', '移动', '0', '2008-10-16', '1'), ('9732', '125.91.4.151', '广东', '移动', '0', '2008-10-16', '1'), ('9733', '125.91.4.169', '广东', '移动', '0', '2008-10-16', '1'), ('9734', '203.86.5.167', '广东', '移动', '0', '2008-10-16', '1'), ('9735', '203.86.5.173', '广东', '移动', '0', '2008-10-16', '1'), ('9736', '61.144.182.182', '广东', '移动', '0', '2008-10-16', '1'), ('9737', '220.231.152.165', '广东', '移动', '0', '2008-10-16', '1'), ('9738', '218.200.247.111', '广东', '移动', '0', '2008-10-16', '1'), ('9739', '218.200.244.6', '广东', '移动', '0', '2008-10-16', '1'), ('9740', '218.200.247.10', '广东', '移动', '0', '2008-10-16', '1'), ('9741', '218.200.247.1', '广东', '移动', '0', '2008-10-16', '1'), ('9742', '211.136.16.41', '广东', '移动', '0', '2008-10-16', '1'), ('9743', '218.200.247.13', '广东', '移动', '0', '2008-10-16', '1'), ('9744', '211.136.15.9', '广东', '移动', '0', '2008-10-16', '1'), ('9745', '211.136.18.69', '广东', '移动', '0', '2008-10-16', '1'), ('9746', '61.50.161.104', '福建', '移动', '0', '2008-10-16', '1'), ('9747', '211.138.17.33', '福建', '移动', '0', '2008-10-16', '1'), ('9748', '220.181.31.169', '福建', '移动', '0', '2008-10-16', '1'), ('9749', '218.16.120.100', '广东', '移动', '0', '2008-10-16', '1'), ('9750', '59.37.203.176', '广东', '移动', '0', '2008-10-16', '1'), ('9751', '59.37.218.93', '广东', '移动', '0', '2008-10-16', '1'), ('9752', '59.39.181.222', '广东', '移动', '0', '2008-10-16', '1'), ('9753', '211.138.152.119', '福建', '移动', '0', '2008-10-16', '1'), ('9754', '211.138.152.105', '福建', '移动', '0', '2008-10-16', '1'), ('9755', '211.138.152.104', '福建', '移动', '0', '2008-10-16', '1'), ('9756', '211.138.152.111', '福建', '移动', '0', '2008-10-16', '1'), ('9757', '211.143.149.98', '福建', '移动', '0', '2008-10-16', '1'), ('9758', '211.138.11.87', '河北', '移动', '0', '2008-10-16', '1'), ('9759', '211.138.6.182', '河北', '移动', '0', '2008-10-16', '1'), ('9760', '211.138.167.243', '海南', '移动', '0', '2008-10-16', '1'), ('9761', '211.138.167.244', '海南', '移动', '0', '2008-10-16', '1'), ('9762', '211.137.63.117', '湖北', '移动', '0', '2008-10-16', '1'), ('9763', '211.137.79.70', '湖北', '移动', '0', '2008-10-16', '1'), ('9764', '211.137.59.2', '湖北', '移动', '0', '2008-10-16', '1'), ('9765', '211.138.226.143', '湖南', '移动', '0', '2008-10-16', '1'), ('9766', '211.138.237.17', '湖南', '移动', '0', '2008-10-16', '1'), ('9767', '211.138.226.186', '湖南', '移动', '0', '2008-10-16', '1'), ('9768', '211.138.226.146', '湖南', '移动', '0', '2008-10-16', '1'), ('9769', '211.138.226.135', '湖南', '移动', '0', '2008-10-16', '1'), ('9770', '211.142.189.74', '河南', '移动', '0', '2008-10-16', '1'), ('9771', '211.142.189.75', '河南', '移动', '0', '2008-10-16', '1'), ('9772', '211.142.189.76', '河南', '移动', '0', '2008-10-16', '1'), ('9773', '211.142.189.77', '河南', '移动', '0', '2008-10-16', '1'), ('9774', '211.137.211.139', '吉林', '移动', '0', '2008-10-16', '1'), ('9775', '211.141.68.65', '吉林', '移动', '0', '2008-10-16', '1'), ('9776', '211.141.68.75', '吉林', '移动', '0', '2008-10-16', '1'), ('9777', '211.141.68.74', '吉林', '移动', '0', '2008-10-16', '1'), ('9778', '218.200.247.11', '江苏', '移动', '0', '2008-10-16', '1'), ('9779', '218.200.247.12', '江苏', '移动', '0', '2008-10-16', '1'), ('9781', '218.200.247.14', '江苏', '移动', '0', '2008-10-16', '1'), ('9782', '211.136.20.37', '广东', '移动', '0', '2008-10-16', '1'), ('9783', '211.136.20.38', '广东', '移动', '0', '2008-10-16', '1'), ('9784', '211.136.20.39', '广东', '移动', '0', '2008-10-16', '1'), ('9785', '211.136.20.40', '广东', '移动', '0', '2008-10-16', '1'), ('9786', '211.136.20.41', '广东', '移动', '0', '2008-10-16', '1'), ('9787', '211.136.20.42', '广东', '移动', '0', '2008-10-16', '1'), ('9788', '211.136.20.43', '广东', '移动', '0', '2008-10-16', '1'), ('9789', '211.136.20.45', '广东', '移动', '0', '2008-10-16', '1'), ('9790', '211.136.23.7', '辽宁', '移动', '0', '2008-10-16', '1'), ('9791', '211.137.37.141', '辽宁', '移动', '0', '2008-10-16', '1'), ('9792', '211.136.158.215', '上海', '移动', '0', '2008-10-16', '1'), ('9793', '221.130.176.132', '上海', '移动', '0', '2008-10-16', '1'), ('9794', '211.136.158.244', '上海', '移动', '0', '2008-10-16', '1'), ('9795', '211.136.158.151', '上海', '移动', '0', '2008-10-16', '1'), ('9796', '218.200.224.245', '四川', '移动', '0', '2008-10-16', '1'), ('9797', '218.200.224.112', '四川', '移动', '0', '2008-10-16', '1'), ('9798', '218.200.225.11', '四川', '移动', '0', '2008-10-16', '1'), ('9799', '218.200.224.247', '四川', '移动', '0', '2008-10-16', '1'), ('9800', '211.140.18.1', '浙江', '移动', '0', '2008-10-16', '1'), ('9801', '211.140.16.233', '浙江', '移动', '0', '2008-10-16', '1'), ('9802', '211.137.167.133', '天津', '移动', '0', '2008-10-16', '1'), ('9803', '218.201.8.130', '重庆', '移动', '0', '2008-10-16', '1'), ('9804', '218.201.8.132', '重庆', '移动', '0', '2008-10-16', '1'), ('9805', '218.201.8.131', '重庆', '移动', '0', '2008-10-16', '1'), ('9806', '218.201.23.4', '重庆', '移动', '0', '2008-10-16', '1'), ('9807', '211.139.90.249', '甘肃', '移动', '0', '2008-10-16', '1'), ('9808', '116.29.181.58', '', '', '1', '2008-10-16', '0'), ('9809', '212.71.32.95', '', '', '1', '2008-10-18', '0'), ('9810', '59.37.185.30', '', '', '1', '2008-10-18', '0'), ('9811', '200.35.64.106', '', '', '1', '2008-10-19', '0'), ('9812', '211.90.87.216', '', '联通', '22', '2008-10-20', '1'), ('9813', '125.91.171.179', '', '', '12', '2008-10-22', '0'), ('9814', '222.222.184.232', '', '', '2', '2008-10-22', '0'), ('9815', '41.204.128.126', '', '', '3', '2008-10-24', '0'), ('9816', '119.122.94.139', '', '', '2', '2008-10-26', '0'), ('9817', '221.130.197.32', '', '', '1', '2008-10-27', '0'), ('9818', '202.160.180.204', '', '', '1', '2008-10-28', '0'), ('9819', '125.89.210.25', '', '', '1', '2008-10-28', '0'), ('9820', '211.138.237.200', '', '移动', '1', '2009-07-29', '1'), ('9822', '221.179.21.19', '', '移动', '0', '2009-12-06', '1'), ('9823', '211.137.119.247', '陕西省西安市', '移动', '0', '2009-12-07', '1'), ('9824', '117.136.19.208', '中国', '移动', '0', '2009-12-07', '1'), ('9825', '218.207.91.131', '中国', '移动', '0', '2009-12-07', '1'), ('9826', '211.140.18.145', '浙江省杭州市', '移动', '0', '2009-12-07', '1'), ('9827', '211.142.189.235', '河南省', '移动', '0', '2009-12-07', '1'), ('9828', '211.142.189.206', '河南省', '移动', '0', '2009-12-07', '1'), ('9829', '218.206.252.66', '河南省', '移动', '0', '2009-12-07', '1'), ('9830', '211.136.115.24', '上海市', '移动', '0', '2009-12-07', '1'), ('9831', '211.143.145.209', '福建省福州市', '移动', '0', '2009-12-07', '1'), ('9832', '221.179.8.84', '重庆市', '移动', '0', '2009-12-07', '1'), ('9833', '117.136.10.153', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9834', '117.136.8.153', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9835', '211.143.145.241', '福建省福州市', '移动', '0', '2009-12-07', '1'), ('9836', '211.138.199.172', '江苏省', '移动', '0', '2009-12-07', '1'), ('9837', '211.137.33.177', '辽宁省沈阳市', '移动', '0', '2009-12-07', '1'), ('9838', '117.136.10.35', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9839', '211.140.16.14', '浙江省杭州市', '移动', '0', '2009-12-07', '1'), ('9840', '211.138.69.11', '青海省西宁市', '移动', '0', '2009-12-07', '1'), ('9841', '117.136.16.136', '中国', '移动', '0', '2009-12-07', '1'), ('9842', '221.179.21.20', '重庆市', '移动', '0', '2009-12-07', '1'), ('9843', '117.136.14.36', '中国', '移动', '0', '2009-12-07', '1'), ('9844', '117.136.31.42', '中国', '移动', '0', '2009-12-07', '1'), ('9845', '117.136.11.129', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9846', '211.141.86.24', '江西省南昌市', '移动', '0', '2009-12-07', '1'), ('9847', '117.136.15.35', '中国', '移动', '0', '2009-12-07', '1'), ('9848', '211.136.115.45', '上海市', '移动', '0', '2009-12-07', '1'), ('9849', '117.136.0.146', '中国', '移动', '0', '2009-12-07', '1'), ('9850', '211.138.199.170', '江苏省', '移动', '0', '2009-12-07', '1'), ('9851', '211.138.199.173', '江苏省', '移动', '0', '2009-12-07', '1'), ('9852', '117.136.10.14', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9853', '211.138.243.111', '广西自治区南宁市', '移动', '0', '2009-12-07', '1'), ('9854', '117.136.12.33', '中国', '移动', '0', '2009-12-07', '1'), ('9855', '117.136.13.10', '中国', '移动', '0', '2009-12-07', '1'), ('9856', '117.136.15.150', '中国', '移动', '0', '2009-12-07', '1'), ('9857', '117.136.10.146', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9858', '117.136.8.4', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9859', '117.136.19.206', '中国', '移动', '0', '2009-12-07', '1'), ('9860', '117.136.16.135', '中国', '移动', '0', '2009-12-07', '1'), ('9861', '211.137.180.242', '山东省', '移动', '0', '2009-12-07', '1'), ('9862', '117.136.19.5', '中国', '移动', '0', '2009-12-07', '1'), ('9863', '117.136.15.34', '中国', '移动', '0', '2009-12-07', '1'), ('9864', '211.138.199.171', '江苏省', '移动', '0', '2009-12-07', '1'), ('9865', '117.136.3.2', '中国', '移动', '0', '2009-12-07', '1'), ('9866', '117.136.19.165', '中国', '移动', '0', '2009-12-07', '1'), ('9867', '117.136.19.207', '中国', '移动', '0', '2009-12-07', '1'), ('9868', '117.136.15.137', '中国', '移动', '0', '2009-12-07', '1'), ('9869', '117.136.20.1', '中国', '移动', '0', '2009-12-07', '1'), ('9870', '117.136.10.42', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9871', '117.136.13.1', '中国', '移动', '0', '2009-12-07', '1'), ('9872', '117.136.12.25', '中国', '移动', '0', '2009-12-07', '1'), ('9873', '117.136.15.68', '中国', '移动', '0', '2009-12-07', '1'), ('9874', '117.136.12.2', '中国', '移动', '0', '2009-12-07', '1'), ('9875', '117.136.13.4', '中国', '移动', '0', '2009-12-07', '1'), ('9876', '117.136.12.123', '中国', '移动', '0', '2009-12-07', '1'), ('9877', '117.136.11.173', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9878', '117.136.17.13', '中国', '移动', '0', '2009-12-07', '1'), ('9879', '117.136.6.10', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9880', '117.136.23.253', '中国', '移动', '0', '2009-12-07', '1'), ('9881', '117.136.2.2', '中国', '移动', '0', '2009-12-07', '1'), ('9882', '117.136.10.179', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9883', '117.136.10.136', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9884', '117.136.8.197', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9885', '117.136.4.243', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9886', '117.136.2.4', '中国', '移动', '0', '2009-12-07', '1'), ('9887', '117.136.8.163', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9888', '117.136.10.183', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9889', '117.136.6.2', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9890', '117.136.19.169', '中国', '移动', '0', '2009-12-07', '1'), ('9891', '117.136.19.35', '中国', '移动', '0', '2009-12-07', '1'), ('9892', '117.136.22.141', '中国', '移动', '0', '2009-12-07', '1'), ('9893', '117.136.16.129', '中国', '移动', '0', '2009-12-07', '1'), ('9894', '117.136.19.136', '中国', '移动', '0', '2009-12-07', '1'), ('9895', '117.136.4.5', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9896', '117.136.31.45', '中国', '移动', '0', '2009-12-07', '1'), ('9897', '117.136.12.49', '中国', '移动', '0', '2009-12-07', '1'), ('9898', '117.136.5.83', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9899', '117.136.10.158', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9900', '117.136.4.8', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9901', '117.136.11.152', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9902', '117.136.5.68', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9903', '117.136.8.3', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9904', '117.136.10.40', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9905', '117.136.20.19', '中国', '移动', '0', '2009-12-07', '1'), ('9906', '117.136.0.144', '中国', '移动', '0', '2009-12-07', '1'), ('9907', '117.136.10.38', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9908', '117.136.10.44', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9909', '117.136.14.14', '中国', '移动', '0', '2009-12-07', '1'), ('9910', '117.136.16.131', '中国', '移动', '0', '2009-12-07', '1'), ('9911', '117.136.10.36', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9912', '117.136.5.204', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9913', '117.136.8.7', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9914', '117.136.10.132', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9915', '117.136.12.242', '中国', '移动', '0', '2009-12-07', '1'), ('9916', '117.136.8.145', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9917', '117.136.2.45', '中国', '移动', '0', '2009-12-07', '1'), ('9918', '117.136.2.28', '中国', '移动', '0', '2009-12-07', '1'), ('9919', '117.136.12.138', '中国', '移动', '0', '2009-12-07', '1'), ('9920', '117.136.10.148', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9921', '117.136.15.251', '中国', '移动', '0', '2009-12-07', '1'), ('9922', '117.136.8.169', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9923', '117.136.5.167', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9924', '117.136.2.29', '中国', '移动', '0', '2009-12-07', '1'), ('9925', '117.136.8.152', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9926', '117.136.2.19', '中国', '移动', '0', '2009-12-07', '1'), ('9927', '117.136.12.209', '中国', '移动', '0', '2009-12-07', '1'), ('9928', '117.136.10.164', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9929', '117.136.12.35', '中国', '移动', '0', '2009-12-07', '1'), ('9930', '117.136.31.43', '中国', '移动', '0', '2009-12-07', '1'), ('9931', '117.136.25.53', '中国', '移动', '0', '2009-12-07', '1'), ('9932', '117.136.12.193', '中国', '移动', '0', '2009-12-07', '1'), ('9933', '117.136.12.54', '中国', '移动', '0', '2009-12-07', '1'), ('9934', '117.136.8.195', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9935', '117.136.11.148', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9936', '117.136.10.163', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9937', '117.136.9.68', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9938', '117.136.10.171', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9939', '117.136.16.133', '中国', '移动', '0', '2009-12-07', '1'), ('9940', '117.136.16.78', '中国', '移动', '0', '2009-12-07', '1'), ('9941', '117.136.8.30', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9942', '117.136.5.86', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9943', '117.136.22.138', '中国', '移动', '0', '2009-12-07', '1'), ('9944', '117.136.29.55', '中国', '移动', '0', '2009-12-07', '1'), ('9945', '117.136.4.3', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9946', '117.136.10.162', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9947', '117.136.10.43', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9948', '117.136.19.197', '中国', '移动', '0', '2009-12-07', '1'), ('9949', '117.136.3.4', '中国', '移动', '0', '2009-12-07', '1'), ('9950', '117.136.27.254', '中国', '移动', '0', '2009-12-07', '1'), ('9951', '117.136.10.168', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9952', '117.136.15.160', '中国', '移动', '0', '2009-12-07', '1'), ('9953', '117.136.12.18', '中国', '移动', '0', '2009-12-07', '1'), ('9954', '211.137.63.146', '湖北省十堰市', '移动', '0', '2009-12-07', '1'), ('9955', '117.136.8.137', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9956', '117.136.22.137', '中国', '移动', '0', '2009-12-07', '1'), ('9957', '117.136.2.30', '中国', '移动', '0', '2009-12-07', '1'), ('9958', '117.136.19.193', '中国', '移动', '0', '2009-12-07', '1'), ('9959', '117.136.8.157', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9960', '117.136.0.157', '中国', '移动', '0', '2009-12-07', '1'), ('9961', '117.136.10.57', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9962', '117.136.12.180', '中国', '移动', '0', '2009-12-07', '1'), ('9963', '117.136.8.168', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9964', '117.136.8.149', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9965', '117.136.12.52', '中国', '移动', '0', '2009-12-07', '1'), ('9966', '117.136.10.39', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9967', '117.136.10.10', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9968', '117.136.12.139', '中国', '移动', '0', '2009-12-07', '1'), ('9969', '117.136.20.22', '中国', '移动', '0', '2009-12-07', '1'), ('9970', '117.136.31.17', '中国', '移动', '0', '2009-12-07', '1'), ('9971', '117.136.11.130', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9972', '117.136.6.25', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9973', '117.136.19.170', '中国', '移动', '0', '2009-12-07', '1'), ('9974', '221.131.128.233', '江苏省南京市', '移动', '0', '2009-12-07', '1'), ('9975', '117.136.2.46', '中国', '移动', '0', '2009-12-07', '1'), ('9976', '117.136.8.16', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9977', '117.136.12.150', '中国', '移动', '0', '2009-12-07', '1'), ('9978', '117.136.12.140', '中国', '移动', '0', '2009-12-07', '1'), ('9979', '117.136.19.138', '中国', '移动', '0', '2009-12-07', '1'), ('9980', '117.136.5.80', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9981', '117.136.10.185', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9982', '117.136.4.14', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9983', '117.136.6.130', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9984', '117.136.8.29', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9985', '117.136.20.4', '中国', '移动', '0', '2009-12-07', '1'), ('9986', '117.136.19.199', '中国', '移动', '0', '2009-12-07', '1'), ('9987', '117.136.23.145', '中国', '移动', '0', '2009-12-07', '1'), ('9988', '117.136.5.67', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('9989', '117.136.17.5', '中国', '移动', '0', '2009-12-07', '1'), ('9990', '117.136.13.5', '中国', '移动', '0', '2009-12-07', '1'), ('9991', '117.136.22.139', '中国', '移动', '0', '2009-12-07', '1'), ('9992', '117.136.27.250', '中国', '移动', '0', '2009-12-07', '1'), ('9993', '117.136.12.1', '中国', '移动', '0', '2009-12-07', '1'), ('9994', '117.136.25.51', '中国', '移动', '0', '2009-12-07', '1'), ('9995', '117.136.13.9', '中国', '移动', '0', '2009-12-07', '1'), ('9996', '117.136.12.36', '中国', '移动', '0', '2009-12-07', '1'), ('9997', '117.136.10.12', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('9998', '211.137.63.140', '湖北省十堰市', '移动', '0', '2009-12-07', '1'), ('9999', '117.136.10.55', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10000', '117.136.12.85', '中国', '移动', '0', '2009-12-07', '1'), ('10001', '117.136.16.130', '中国', '移动', '0', '2009-12-07', '1'), ('10002', '117.136.8.164', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10003', '117.136.22.142', '中国', '移动', '0', '2009-12-07', '1'), ('10004', '117.136.10.154', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10005', '117.136.12.50', '中国', '移动', '0', '2009-12-07', '1'), ('10006', '117.136.12.220', '中国', '移动', '0', '2009-12-07', '1'), ('10007', '117.136.14.2', '中国', '移动', '0', '2009-12-07', '1'), ('10008', '117.136.19.36', '中国', '移动', '0', '2009-12-07', '1'), ('10009', '117.136.15.149', '中国', '移动', '0', '2009-12-07', '1'), ('10010', '117.136.10.150', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10011', '117.136.8.196', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10012', '117.136.24.25', '中国', '移动', '0', '2009-12-07', '1'), ('10013', '117.136.11.77', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10014', '117.136.11.17', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10015', '117.136.12.81', '中国', '移动', '0', '2009-12-07', '1'), ('10016', '117.136.11.162', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10017', '211.137.63.147', '湖北省十堰市', '移动', '0', '2009-12-07', '1'), ('10018', '117.136.1.25', '中国', '移动', '0', '2009-12-07', '1'), ('10019', '211.137.63.92', '湖北省十堰市', '移动', '0', '2009-12-07', '1'), ('10020', '117.136.10.149', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10021', '117.136.8.22', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10022', '117.136.10.46', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10023', '211.137.63.107', '湖北省十堰市', '移动', '0', '2009-12-07', '1'), ('10024', '117.136.1.30', '中国', '移动', '0', '2009-12-07', '1'), ('10025', '117.136.25.43', '中国', '移动', '0', '2009-12-07', '1'), ('10026', '117.136.12.142', '中国', '移动', '0', '2009-12-07', '1'), ('10027', '117.136.0.34', '中国', '移动', '0', '2009-12-07', '1'), ('10028', '117.136.2.1', '中国', '移动', '0', '2009-12-07', '1'), ('10029', '117.136.4.255', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('10030', '117.136.8.200', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10031', '117.136.19.203', '中国', '移动', '0', '2009-12-07', '1'), ('10032', '117.136.12.74', '中国', '移动', '0', '2009-12-07', '1'), ('10033', '117.136.23.199', '中国', '移动', '0', '2009-12-07', '1'), ('10034', '117.136.19.204', '中国', '移动', '0', '2009-12-07', '1'), ('10035', '117.136.4.6', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('10036', '117.136.10.33', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10037', '117.136.19.134', '中国', '移动', '0', '2009-12-07', '1'), ('10038', '117.136.8.10', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10039', '117.136.12.22', '中国', '移动', '0', '2009-12-07', '1'), ('10040', '117.136.10.141', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10041', '117.136.15.62', '中国', '移动', '0', '2009-12-07', '1'), ('10042', '117.136.27.253', '中国', '移动', '0', '2009-12-07', '1'), ('10043', '211.137.63.65', '湖北省十堰市', '移动', '0', '2009-12-07', '1'), ('10044', '117.136.12.121', '中国', '移动', '0', '2009-12-07', '1'), ('10045', '117.136.8.21', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10046', '117.136.12.98', '中国', '移动', '0', '2009-12-07', '1'), ('10047', '117.136.19.135', '中国', '移动', '0', '2009-12-07', '1'), ('10048', '117.136.12.197', '中国', '移动', '0', '2009-12-07', '1'), ('10049', '117.136.8.2', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10050', '117.136.31.44', '中国', '移动', '0', '2009-12-07', '1'), ('10051', '117.136.10.4', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10052', '117.136.2.17', '中国', '移动', '0', '2009-12-07', '1'), ('10053', '117.136.19.3', '中国', '移动', '0', '2009-12-07', '1'), ('10054', '117.136.12.37', '中国', '移动', '0', '2009-12-07', '1'), ('10055', '117.136.12.73', '中国', '移动', '0', '2009-12-07', '1'), ('10056', '117.136.2.5', '中国', '移动', '0', '2009-12-07', '1'), ('10057', '117.136.31.20', '中国', '移动', '0', '2009-12-07', '1'), ('10058', '211.137.63.91', '湖北省十堰市', '移动', '0', '2009-12-07', '1'), ('10059', '117.136.8.165', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10060', '117.136.5.214', '辽宁省本溪市', '移动', '0', '2009-12-07', '1'), ('10061', '117.136.27.252', '中国', '移动', '0', '2009-12-07', '1'), ('10062', '117.136.10.142', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10063', '117.136.12.207', '中国', '移动', '0', '2009-12-07', '1'), ('10064', '117.136.8.148', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10065', '117.136.8.28', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10066', '117.136.12.224', '中国', '移动', '0', '2009-12-07', '1'), ('10067', '117.136.16.134', '中国', '移动', '0', '2009-12-07', '1'), ('10068', '117.136.2.3', '中国', '移动', '0', '2009-12-07', '1'), ('10069', '117.136.12.196', '中国', '移动', '0', '2009-12-07', '1'), ('10070', '117.136.8.25', '山东省潍坊市', '移动', '0', '2009-12-07', '1'), ('10071', '117.136.8.19', '', '移动', '0', '2009-12-07', '1'), ('10072', '221.179.8.83', '', '移动', '0', '2009-12-07', '1'), ('10073', '117.136.10.147', '', '移动', '0', '2009-12-07', '1'), ('10074', '117.136.2.9', '', '移动', '0', '2009-12-07', '1'), ('10075', '117.136.11.75', '山东省潍坊市', '移动', '0', '2009-12-08', '1'), ('10076', '117.136.0.156', '中国', '移动', '0', '2009-12-08', '1'), ('10077', '117.136.18.21', '中国', '移动', '0', '2009-12-08', '1'), ('10078', '117.136.20.17', '中国', '移动', '0', '2009-12-08', '1'), ('10079', '117.136.20.5', '中国', '移动', '0', '2009-12-08', '1'), ('10080', '117.136.12.34', '中国', '移动', '0', '2009-12-08', '1'), ('10081', '117.136.1.27', '中国', '移动', '0', '2009-12-08', '1'), ('10082', '117.136.12.168', '中国', '移动', '0', '2009-12-08', '1'), ('10083', '117.136.11.164', '山东省潍坊市', '移动', '0', '2009-12-08', '1'), ('10084', '117.136.19.194', '中国', '移动', '0', '2009-12-08', '1'), ('10085', '117.136.21.172', '中国', '移动', '0', '2009-12-08', '1'), ('10086', '117.136.10.63', '', '移动', '0', '2009-12-08', '1'), ('10087', '117.136.11.65', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10088', '117.136.11.136', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10089', '117.136.7.7', '辽宁省本溪市', '移动', '0', '2009-12-09', '1'), ('10090', '117.136.19.37', '中国', '移动', '0', '2009-12-09', '1'), ('10091', '117.136.20.12', '中国', '移动', '0', '2009-12-09', '1'), ('10092', '117.136.21.198', '中国', '移动', '0', '2009-12-09', '1'), ('10093', '117.136.5.211', '辽宁省本溪市', '移动', '0', '2009-12-09', '1'), ('10094', '117.136.8.17', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10095', '117.136.21.174', '中国', '移动', '0', '2009-12-09', '1'), ('10096', '117.136.12.78', '中国', '移动', '0', '2009-12-09', '1'), ('10097', '117.136.10.45', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10098', '117.136.12.122', '中国', '移动', '0', '2009-12-09', '1'), ('10099', '117.136.19.140', '中国', '移动', '0', '2009-12-09', '1'), ('10100', '117.136.21.232', '中国', '移动', '0', '2009-12-09', '1'), ('10101', '117.136.10.23', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10102', '117.136.10.41', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10103', '117.136.13.6', '中国', '移动', '0', '2009-12-09', '1'), ('10104', '117.136.11.67', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10105', '117.136.19.167', '中国', '移动', '0', '2009-12-09', '1'), ('10106', '117.136.8.24', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10107', '117.136.11.138', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10108', '117.136.12.192', '中国', '移动', '0', '2009-12-09', '1'), ('10109', '117.136.15.164', '中国', '移动', '0', '2009-12-09', '1'), ('10110', '117.136.10.151', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10111', '117.136.19.205', '中国', '移动', '0', '2009-12-09', '1'), ('10112', '117.136.4.4', '辽宁省本溪市', '移动', '0', '2009-12-09', '1'), ('10113', '117.136.27.249', '中国', '移动', '0', '2009-12-09', '1'), ('10114', '117.136.12.200', '中国', '移动', '0', '2009-12-09', '1'), ('10115', '117.136.30.72', '中国', '移动', '0', '2009-12-09', '1'), ('10116', '117.136.12.70', '中国', '移动', '0', '2009-12-09', '1'), ('10117', '117.136.12.238', '中国', '移动', '0', '2009-12-09', '1'), ('10118', '117.136.5.195', '辽宁省本溪市', '移动', '0', '2009-12-09', '1'), ('10119', '117.136.0.35', '中国', '移动', '0', '2009-12-09', '1'), ('10120', '117.136.10.167', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10121', '117.136.19.196', '中国', '移动', '0', '2009-12-09', '1'), ('10122', '117.136.12.51', '中国', '移动', '0', '2009-12-09', '1'), ('10123', '117.136.8.161', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10124', '117.136.8.8', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10125', '117.136.18.26', '中国', '移动', '0', '2009-12-09', '1'), ('10126', '117.136.16.132', '中国', '移动', '0', '2009-12-09', '1'), ('10127', '117.136.10.170', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10128', '117.136.12.38', '中国', '移动', '0', '2009-12-09', '1'), ('10129', '117.136.15.73', '中国', '移动', '0', '2009-12-09', '1'), ('10130', '117.136.10.140', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10131', '117.136.10.178', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10132', '117.136.5.217', '辽宁省本溪市', '移动', '0', '2009-12-09', '1'), ('10133', '117.136.15.57', '中国', '移动', '0', '2009-12-09', '1'), ('10134', '117.136.23.243', '中国', '移动', '0', '2009-12-09', '1'), ('10135', '117.136.8.26', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10136', '117.136.12.67', '中国', '移动', '0', '2009-12-09', '1'), ('10137', '117.136.20.3', '中国', '移动', '0', '2009-12-09', '1'), ('10138', '117.136.23.179', '中国', '移动', '0', '2009-12-09', '1'), ('10139', '117.136.15.69', '中国', '移动', '0', '2009-12-09', '1'), ('10140', '117.136.8.194', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10141', '117.136.25.45', '中国', '移动', '0', '2009-12-09', '1'), ('10142', '117.136.11.26', '山东省潍坊市', '移动', '0', '2009-12-09', '1'), ('10143', '117.136.31.18', '中国', '移动', '0', '2009-12-09', '1'), ('10144', '117.136.21.179', '中国', '移动', '0', '2009-12-09', '1'), ('10145', '117.136.19.166', '中国', '移动', '0', '2009-12-09', '1'), ('10146', '117.136.19.168', '中国', '移动', '0', '2009-12-09', '1'), ('10147', '117.136.0.154', '中国', '移动', '0', '2009-12-09', '1'), ('10148', '117.136.12.59', '中国', '移动', '0', '2009-12-09', '1'), ('10149', '117.136.20.13', '中国', '移动', '0', '2009-12-10', '1'), ('10150', '117.136.7.163', '辽宁省本溪市', '移动', '0', '2009-12-10', '1'), ('10151', '117.136.5.75', '辽宁省本溪市', '移动', '0', '2009-12-10', '1'), ('10152', '117.136.4.1', '辽宁省本溪市', '移动', '0', '2009-12-10', '1'), ('10153', '117.136.31.21', '中国', '移动', '0', '2009-12-10', '1'), ('10154', '117.136.15.72', '中国', '移动', '0', '2009-12-10', '1'), ('10155', '117.136.19.201', '中国', '移动', '0', '2009-12-10', '1'), ('10156', '117.136.11.137', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10157', '117.136.12.205', '中国', '移动', '0', '2009-12-10', '1'), ('10158', '211.137.63.94', '湖北省十堰市', '移动', '0', '2009-12-10', '1'), ('10159', '117.136.10.139', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10160', '117.136.25.52', '中国', '移动', '0', '2009-12-10', '1'), ('10161', '117.136.15.205', '中国', '移动', '0', '2009-12-10', '1'), ('10162', '117.136.12.75', '中国', '移动', '0', '2009-12-10', '1'), ('10163', '117.136.8.170', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10164', '117.136.22.143', '中国', '移动', '0', '2009-12-10', '1'), ('10165', '117.136.9.73', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10166', '117.136.23.190', '中国', '移动', '0', '2009-12-10', '1'), ('10167', '117.136.8.5', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10168', '117.136.10.24', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10169', '117.136.10.13', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10170', '117.136.19.133', '中国', '移动', '0', '2009-12-10', '1'), ('10171', '117.136.12.194', '中国', '移动', '0', '2009-12-10', '1'), ('10172', '117.136.25.14', '中国', '移动', '0', '2009-12-10', '1'), ('10173', '117.136.10.30', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10174', '117.136.10.49', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10175', '117.136.3.5', '中国', '移动', '0', '2009-12-10', '1'), ('10176', '117.136.12.84', '中国', '移动', '0', '2009-12-10', '1'), ('10177', '117.136.12.30', '中国', '移动', '0', '2009-12-10', '1'), ('10178', '117.136.10.135', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10179', '117.136.12.26', '中国', '移动', '0', '2009-12-10', '1'), ('10180', '117.136.10.130', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10181', '117.136.4.2', '辽宁省本溪市', '移动', '0', '2009-12-10', '1'), ('10182', '117.136.2.14', '中国', '移动', '0', '2009-12-10', '1'), ('10183', '117.136.29.53', '中国', '移动', '0', '2009-12-10', '1'), ('10184', '117.136.10.188', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10185', '117.136.8.167', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10186', '117.136.10.152', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10187', '117.136.8.201', '山东省潍坊市', '移动', '0', '2009-12-10', '1'), ('10188', '117.136.11.161', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10189', '117.136.10.11', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10190', '117.136.19.137', '中国', '移动', '0', '2009-12-11', '1'), ('10191', '117.136.24.61', '中国', '移动', '0', '2009-12-11', '1'), ('10192', '117.136.3.37', '中国', '移动', '0', '2009-12-11', '1'), ('10193', '117.136.15.71', '中国', '移动', '0', '2009-12-11', '1'), ('10194', '117.136.14.10', '中国', '移动', '0', '2009-12-11', '1'), ('10195', '117.136.10.166', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10196', '117.136.8.18', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10197', '218.202.227.151', '上海市', '移动', '0', '2009-12-11', '1'), ('10198', '117.136.12.126', '中国', '移动', '0', '2009-12-11', '1'), ('10199', '117.136.20.24', '中国', '移动', '0', '2009-12-11', '1'), ('10200', '117.136.10.131', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10201', '117.136.23.239', '中国', '移动', '0', '2009-12-11', '1'), ('10202', '117.136.12.76', '中国', '移动', '0', '2009-12-11', '1'), ('10203', '117.136.10.28', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10204', '117.136.10.190', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10205', '117.136.1.250', '中国', '移动', '0', '2009-12-11', '1'), ('10206', '117.136.0.150', '中国', '移动', '0', '2009-12-11', '1'), ('10207', '117.136.12.136', '中国', '移动', '0', '2009-12-11', '1'), ('10208', '117.136.4.253', '辽宁省本溪市', '移动', '0', '2009-12-11', '1'), ('10209', '117.136.10.7', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10210', '117.136.27.251', '中国', '移动', '0', '2009-12-11', '1'), ('10211', '117.136.13.3', '中国', '移动', '0', '2009-12-11', '1'), ('10212', '117.136.31.41', '中国', '移动', '0', '2009-12-11', '1'), ('10213', '117.136.8.6', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10214', '117.136.10.133', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10215', '117.136.19.171', '中国', '移动', '0', '2009-12-11', '1'), ('10216', '117.136.12.179', '中国', '移动', '0', '2009-12-11', '1'), ('10217', '117.136.10.157', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10218', '117.136.12.232', '中国', '移动', '0', '2009-12-11', '1'), ('10219', '117.136.10.54', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10220', '117.136.15.61', '中国', '移动', '0', '2009-12-11', '1'), ('10221', '117.136.12.43', '中国', '移动', '0', '2009-12-11', '1'), ('10222', '117.136.11.166', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10223', '117.136.2.11', '中国', '移动', '0', '2009-12-11', '1'), ('10224', '117.136.5.87', '辽宁省本溪市', '移动', '0', '2009-12-11', '1'), ('10225', '117.136.25.15', '中国', '移动', '0', '2009-12-11', '1'), ('10226', '117.136.15.70', '中国', '移动', '0', '2009-12-11', '1'), ('10227', '117.136.18.28', '中国', '移动', '0', '2009-12-11', '1'), ('10228', '117.136.11.69', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10229', '117.136.12.90', '中国', '移动', '0', '2009-12-11', '1'), ('10230', '117.136.2.20', '中国', '移动', '0', '2009-12-11', '1'), ('10231', '117.136.12.216', '中国', '移动', '0', '2009-12-11', '1'), ('10232', '117.136.19.161', '中国', '移动', '0', '2009-12-11', '1'), ('10233', '117.136.10.34', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10234', '117.136.15.210', '中国', '移动', '0', '2009-12-11', '1'), ('10235', '117.136.19.195', '中国', '移动', '0', '2009-12-11', '1'), ('10236', '211.137.63.113', '湖北省十堰市', '移动', '0', '2009-12-11', '1'), ('10237', '117.136.15.154', '中国', '移动', '0', '2009-12-11', '1'), ('10238', '117.136.12.241', '中国', '移动', '0', '2009-12-11', '1'), ('10239', '211.137.63.183', '湖北省十堰市', '移动', '0', '2009-12-11', '1'), ('10240', '117.136.12.42', '中国', '移动', '0', '2009-12-11', '1'), ('10241', '117.136.1.156', '中国', '移动', '0', '2009-12-11', '1'), ('10242', '117.136.15.49', '中国', '移动', '0', '2009-12-11', '1'), ('10243', '117.136.10.21', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10244', '117.136.0.39', '中国', '移动', '0', '2009-12-11', '1'), ('10245', '117.136.8.193', '山东省潍坊市', '移动', '0', '2009-12-11', '1'), ('10246', '218.202.227.156', '上海市', '移动', '0', '2009-12-12', '1'), ('10247', '117.136.10.5', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10248', '117.136.8.20', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10249', '117.136.9.2', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10250', '117.136.0.134', '中国', '移动', '0', '2009-12-12', '1'), ('10251', '117.136.11.74', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10252', '117.136.20.10', '中国', '移动', '0', '2009-12-12', '1'), ('10253', '117.136.12.83', '中国', '移动', '0', '2009-12-12', '1'), ('10254', '117.136.12.28', '中国', '移动', '0', '2009-12-12', '1'), ('10255', '117.136.19.200', '中国', '移动', '0', '2009-12-12', '1'), ('10256', '117.136.8.12', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10257', '117.136.8.11', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10258', '117.136.10.37', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10259', '117.136.12.53', '中国', '移动', '0', '2009-12-12', '1'), ('10260', '117.136.10.145', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10261', '117.136.14.35', '中国', '移动', '0', '2009-12-12', '1'), ('10262', '117.136.12.17', '中国', '移动', '0', '2009-12-12', '1'), ('10263', '117.136.8.162', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10264', '117.136.10.9', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10265', '117.136.4.254', '辽宁省本溪市', '移动', '0', '2009-12-12', '1'), ('10266', '117.136.12.46', '中国', '移动', '0', '2009-12-12', '1'), ('10267', '117.136.25.54', '中国', '移动', '0', '2009-12-12', '1'), ('10268', '117.136.31.19', '中国', '移动', '0', '2009-12-12', '1'), ('10269', '117.136.10.51', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10270', '117.136.19.198', '中国', '移动', '0', '2009-12-12', '1'), ('10271', '117.136.12.222', '中国', '移动', '0', '2009-12-12', '1'), ('10272', '117.136.15.56', '中国', '移动', '0', '2009-12-12', '1'), ('10273', '117.136.21.164', '中国', '移动', '0', '2009-12-12', '1'), ('10274', '117.136.10.155', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10275', '117.136.0.21', '中国', '移动', '0', '2009-12-12', '1'), ('10276', '117.136.11.142', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10277', '117.136.10.134', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10278', '117.136.10.61', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10279', '117.136.8.198', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10280', '117.136.11.64', '山东省潍坊市', '移动', '0', '2009-12-12', '1'), ('10281', '117.136.1.136', '中国', '移动', '0', '2009-12-12', '1'), ('10282', '117.136.3.6', '中国', '移动', '0', '2009-12-12', '1'), ('10283', '117.136.12.6', '中国', '移动', '0', '2009-12-12', '1'), ('10284', '117.136.4.244', '辽宁省本溪市', '移动', '0', '2009-12-12', '1'), ('10285', '117.136.10.1', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10286', '117.136.6.129', '辽宁省本溪市', '移动', '0', '2009-12-13', '1'), ('10287', '117.136.5.203', '辽宁省本溪市', '移动', '0', '2009-12-13', '1'), ('10288', '117.136.10.189', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10289', '117.136.27.3', '中国', '移动', '0', '2009-12-13', '1'), ('10290', '117.136.10.50', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10291', '117.136.15.60', '中国', '移动', '0', '2009-12-13', '1'), ('10292', '117.136.12.77', '中国', '移动', '0', '2009-12-13', '1'), ('10293', '117.136.15.106', '中国', '移动', '0', '2009-12-13', '1'), ('10294', '117.136.5.196', '辽宁省本溪市', '移动', '0', '2009-12-13', '1'), ('10295', '117.136.8.202', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10296', '117.136.5.209', '辽宁省本溪市', '移动', '0', '2009-12-13', '1'), ('10297', '117.136.10.60', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10298', '117.136.8.155', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10299', '117.136.23.158', '中国', '移动', '0', '2009-12-13', '1'), ('10300', '117.136.10.2', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10301', '117.136.15.51', '中国', '移动', '0', '2009-12-13', '1'), ('10302', '117.136.10.137', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10303', '117.136.10.138', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10304', '211.137.63.82', '湖北省十堰市', '移动', '0', '2009-12-13', '1'), ('10305', '117.136.10.169', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10306', '117.136.8.133', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10307', '117.136.20.6', '中国', '移动', '0', '2009-12-13', '1'), ('10308', '117.136.12.178', '中国', '移动', '0', '2009-12-13', '1');
INSERT INTO `ig_gateway` VALUES ('10309', '117.136.12.3', '中国', '移动', '0', '2009-12-13', '1'), ('10310', '117.136.10.56', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10311', '117.136.12.247', '中国', '移动', '0', '2009-12-13', '1'), ('10312', '117.136.21.0', '中国', '移动', '0', '2009-12-13', '1'), ('10313', '117.136.20.18', '中国', '移动', '0', '2009-12-13', '1'), ('10314', '117.136.2.42', '中国', '移动', '0', '2009-12-13', '1'), ('10315', '117.136.2.44', '中国', '移动', '0', '2009-12-13', '1'), ('10316', '117.136.2.43', '中国', '移动', '0', '2009-12-13', '1'), ('10317', '117.136.15.52', '中国', '移动', '0', '2009-12-13', '1'), ('10318', '211.137.63.64', '湖北省十堰市', '移动', '0', '2009-12-13', '1'), ('10319', '117.136.1.133', '中国', '移动', '0', '2009-12-13', '1'), ('10320', '117.136.0.30', '中国', '移动', '0', '2009-12-13', '1'), ('10321', '117.136.10.174', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10322', '117.136.22.161', '中国', '移动', '0', '2009-12-13', '1'), ('10323', '117.136.12.124', '中国', '移动', '0', '2009-12-13', '1'), ('10324', '117.136.8.166', '山东省潍坊市', '移动', '0', '2009-12-13', '1'), ('10325', '117.136.12.181', '中国', '移动', '0', '2009-12-14', '1'), ('10326', '117.136.4.247', '辽宁省本溪市', '移动', '0', '2009-12-14', '1'), ('10327', '211.137.63.132', '湖北省十堰市', '移动', '0', '2009-12-14', '1'), ('10328', '117.136.11.131', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10329', '117.136.9.58', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10330', '117.136.10.17', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10331', '117.136.3.3', '中国', '移动', '0', '2009-12-14', '1'), ('10332', '117.136.6.140', '辽宁省本溪市', '移动', '0', '2009-12-14', '1'), ('10333', '117.136.22.162', '中国', '移动', '0', '2009-12-14', '1'), ('10334', '117.136.10.29', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10335', '117.136.11.134', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10336', '117.136.0.1', '中国', '移动', '0', '2009-12-14', '1'), ('10337', '117.136.12.251', '中国', '移动', '0', '2009-12-14', '1'), ('10338', '117.136.12.252', '中国', '移动', '0', '2009-12-14', '1'), ('10339', '117.136.12.182', '中国', '移动', '0', '2009-12-14', '1'), ('10340', '117.136.19.139', '中国', '移动', '0', '2009-12-14', '1'), ('10341', '117.136.30.77', '中国', '移动', '0', '2009-12-14', '1'), ('10342', '117.136.10.165', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10343', '117.136.11.150', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10344', '117.136.12.144', '中国', '移动', '0', '2009-12-14', '1'), ('10345', '117.136.10.53', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10346', '117.136.10.8', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10347', '117.136.12.4', '中国', '移动', '0', '2009-12-14', '1'), ('10348', '117.136.0.18', '中国', '移动', '0', '2009-12-14', '1'), ('10349', '117.136.4.240', '辽宁省本溪市', '移动', '0', '2009-12-14', '1'), ('10350', '117.136.23.172', '中国', '移动', '0', '2009-12-14', '1'), ('10351', '117.136.11.141', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10352', '117.136.12.171', '中国', '移动', '0', '2009-12-14', '1'), ('10353', '117.136.12.125', '中国', '移动', '0', '2009-12-14', '1'), ('10354', '117.136.28.241', '中国', '移动', '0', '2009-12-14', '1'), ('10355', '117.136.4.12', '辽宁省本溪市', '移动', '0', '2009-12-14', '1'), ('10356', '117.136.9.1', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10357', '117.136.8.134', '山东省潍坊市', '移动', '0', '2009-12-14', '1'), ('10358', '117.136.31.30', '中国', '移动', '0', '2009-12-14', '1'), ('10359', '117.136.0.59', '中国', '移动', '0', '2009-12-14', '1'), ('10360', '117.136.10.3', '山东省潍坊市', '移动', '0', '2009-12-15', '1'), ('10361', '117.136.15.109', '中国', '移动', '0', '2009-12-15', '1'), ('10362', '117.136.24.49', '中国', '移动', '0', '2009-12-15', '1'), ('10363', '117.136.8.23', '山东省潍坊市', '移动', '0', '2009-12-15', '1'), ('10364', '117.136.11.70', '山东省潍坊市', '移动', '0', '2009-12-15', '1'), ('10365', '211.137.63.177', '湖北省十堰市', '移动', '0', '2009-12-15', '1'), ('10366', '117.136.16.71', '中国', '移动', '0', '2009-12-15', '1'), ('10367', '117.136.10.161', '山东省潍坊市', '移动', '0', '2009-12-15', '1'), ('10368', '218.202.227.155', '上海市', '移动', '0', '2009-12-15', '1'), ('10369', '117.136.12.86', '中国', '移动', '0', '2009-12-15', '1'), ('10370', '117.136.15.40', '中国', '移动', '0', '2009-12-15', '1'), ('10371', '117.136.5.90', '辽宁省本溪市', '移动', '0', '2009-12-15', '1'), ('10372', '117.136.9.78', '山东省潍坊市', '移动', '0', '2009-12-15', '1'), ('10373', '117.136.12.253', '中国', '移动', '0', '2009-12-15', '1'), ('10374', '117.136.9.60', '山东省潍坊市', '移动', '0', '2009-12-15', '1'), ('10375', '117.136.11.78', '山东省潍坊市', '移动', '0', '2009-12-15', '1'), ('10376', '117.136.4.245', '辽宁省本溪市', '移动', '0', '2009-12-15', '1'), ('10377', '117.136.12.21', '中国', '移动', '0', '2009-12-15', '1'), ('10378', '117.136.0.50', '中国', '移动', '0', '2009-12-15', '1'), ('10379', '117.136.12.5', '中国', '移动', '0', '2009-12-15', '1'), ('10380', '117.136.10.19', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10381', '117.136.5.201', '辽宁省本溪市', '移动', '0', '2009-12-16', '1'), ('10382', '117.136.5.85', '辽宁省本溪市', '移动', '0', '2009-12-16', '1'), ('10383', '211.143.169.222', '福建省', '移动', '0', '2009-12-16', '1'), ('10384', '117.136.15.25', '中国', '移动', '0', '2009-12-16', '1'), ('10385', '218.202.227.153', '上海市', '移动', '0', '2009-12-16', '1'), ('10386', '117.136.8.136', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10387', '117.136.9.33', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10388', '211.137.63.96', '湖北省十堰市', '移动', '0', '2009-12-16', '1'), ('10389', '117.136.12.58', '中国', '移动', '0', '2009-12-16', '1'), ('10390', '117.136.12.69', '中国', '移动', '0', '2009-12-16', '1'), ('10391', '117.136.8.9', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10392', '117.136.19.175', '中国', '移动', '0', '2009-12-16', '1'), ('10393', '117.136.30.70', '中国', '移动', '0', '2009-12-16', '1'), ('10394', '117.136.9.77', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10395', '117.136.12.60', '中国', '移动', '0', '2009-12-16', '1'), ('10396', '218.201.21.179', '重庆市', '移动', '0', '2009-12-16', '1'), ('10397', '117.136.5.73', '辽宁省本溪市', '移动', '0', '2009-12-16', '1'), ('10398', '117.136.12.89', '中国', '移动', '0', '2009-12-16', '1'), ('10399', '117.136.15.195', '中国', '移动', '0', '2009-12-16', '1'), ('10400', '117.136.17.22', '中国', '移动', '0', '2009-12-16', '1'), ('10401', '117.136.12.248', '中国', '移动', '0', '2009-12-16', '1'), ('10402', '117.136.12.240', '中国', '移动', '0', '2009-12-16', '1'), ('10403', '117.136.9.168', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10404', '117.136.12.44', '中国', '移动', '0', '2009-12-16', '1'), ('10405', '117.136.11.165', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10406', '117.136.12.91', '中国', '移动', '0', '2009-12-16', '1'), ('10407', '117.136.24.24', '中国', '移动', '0', '2009-12-16', '1'), ('10408', '117.136.24.108', '中国', '移动', '0', '2009-12-16', '1'), ('10409', '117.136.0.27', '中国', '移动', '0', '2009-12-16', '1'), ('10410', '117.136.19.162', '中国', '移动', '0', '2009-12-16', '1'), ('10411', '117.136.12.93', '中国', '移动', '0', '2009-12-16', '1'), ('10412', '117.136.12.233', '中国', '移动', '0', '2009-12-16', '1'), ('10413', '117.136.1.252', '中国', '移动', '0', '2009-12-16', '1'), ('10414', '117.136.10.129', '山东省潍坊市', '移动', '0', '2009-12-16', '1'), ('10415', '117.136.12.244', '中国', '移动', '0', '2009-12-16', '1'), ('10416', '117.136.6.27', '辽宁省本溪市', '移动', '0', '2009-12-16', '1'), ('10417', '117.136.0.15', '中国', '移动', '0', '2009-12-16', '1'), ('10418', '117.136.2.54', '中国', '移动', '0', '2009-12-16', '1'), ('10419', '211.137.63.84', '湖北省十堰市', '移动', '0', '2009-12-16', '1'), ('10420', '117.136.20.2', '中国', '移动', '0', '2009-12-16', '1'), ('10421', '117.136.21.243', '中国', '移动', '0', '2009-12-16', '1'), ('10422', '117.136.12.68', '中国', '移动', '0', '2009-12-17', '1'), ('10423', '117.136.4.9', '辽宁省本溪市', '移动', '0', '2009-12-17', '1'), ('10424', '117.136.23.170', '中国', '移动', '0', '2009-12-17', '1'), ('10425', '117.136.6.26', '辽宁省本溪市', '移动', '0', '2009-12-17', '1'), ('10426', '117.136.0.60', '中国', '移动', '0', '2009-12-17', '1'), ('10427', '211.137.63.130', '湖北省十堰市', '移动', '0', '2009-12-17', '1'), ('10428', '117.136.15.58', '中国', '移动', '0', '2009-12-17', '1'), ('10429', '117.136.31.163', '中国', '移动', '0', '2009-12-17', '1'), ('10430', '117.136.17.12', '中国', '移动', '0', '2009-12-17', '1'), ('10431', '117.136.25.44', '中国', '移动', '0', '2009-12-17', '1'), ('10432', '117.136.1.149', '中国', '移动', '0', '2009-12-17', '1'), ('10433', '117.136.15.213', '中国', '移动', '0', '2009-12-17', '1'), ('10434', '117.136.0.11', '中国', '移动', '0', '2009-12-17', '1'), ('10435', '117.136.8.199', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10436', '117.136.12.19', '中国', '移动', '0', '2009-12-17', '1'), ('10437', '117.136.8.130', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10438', '117.136.5.2', '辽宁省本溪市', '移动', '0', '2009-12-17', '1'), ('10439', '117.136.15.174', '中国', '移动', '0', '2009-12-17', '1'), ('10440', '117.136.31.171', '中国', '移动', '0', '2009-12-17', '1'), ('10441', '117.136.14.4', '中国', '移动', '0', '2009-12-17', '1'), ('10442', '117.136.21.241', '中国', '移动', '0', '2009-12-17', '1'), ('10443', '117.136.5.8', '辽宁省本溪市', '移动', '0', '2009-12-17', '1'), ('10444', '117.136.21.144', '中国', '移动', '0', '2009-12-17', '1'), ('10445', '117.136.11.63', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10446', '117.136.21.207', '中国', '移动', '0', '2009-12-17', '1'), ('10447', '117.136.12.113', '中国', '移动', '0', '2009-12-17', '1'), ('10448', '117.136.11.133', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10449', '117.136.15.232', '中国', '移动', '0', '2009-12-17', '1'), ('10450', '117.136.8.140', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10451', '117.136.12.172', '中国', '移动', '0', '2009-12-17', '1'), ('10452', '221.182.46.157', '中国', '移动', '0', '2009-12-17', '1'), ('10453', '117.136.11.158', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10454', '117.136.2.50', '中国', '移动', '0', '2009-12-17', '1'), ('10455', '117.136.8.15', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10456', '117.136.0.47', '中国', '移动', '0', '2009-12-17', '1'), ('10457', '117.136.2.27', '中国', '移动', '0', '2009-12-17', '1'), ('10458', '117.136.12.62', '中国', '移动', '0', '2009-12-17', '1'), ('10459', '117.136.3.1', '中国', '移动', '0', '2009-12-17', '1'), ('10460', '117.136.25.46', '中国', '移动', '0', '2009-12-17', '1'), ('10461', '117.136.8.14', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10462', '117.136.21.162', '中国', '移动', '0', '2009-12-17', '1'), ('10463', '117.136.1.230', '中国', '移动', '0', '2009-12-17', '1'), ('10464', '117.136.12.107', '中国', '移动', '0', '2009-12-17', '1'), ('10465', '117.136.31.162', '中国', '移动', '0', '2009-12-17', '1'), ('10466', '117.136.11.56', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10467', '117.136.12.61', '中国', '移动', '0', '2009-12-17', '1'), ('10468', '117.136.0.31', '中国', '移动', '0', '2009-12-17', '1'), ('10469', '117.136.8.27', '山东省潍坊市', '移动', '0', '2009-12-17', '1'), ('10470', '117.136.12.100', '中国', '移动', '0', '2009-12-17', '1'), ('10471', '117.136.17.26', '中国', '移动', '0', '2009-12-17', '1'), ('10472', '117.136.12.116', '中国', '移动', '0', '2009-12-18', '1'), ('10473', '117.136.22.172', '中国', '移动', '0', '2009-12-18', '1'), ('10474', '117.136.1.232', '中国', '移动', '0', '2009-12-18', '1'), ('10475', '117.136.21.166', '中国', '移动', '0', '2009-12-18', '1'), ('10476', '117.136.5.70', '辽宁省本溪市', '移动', '0', '2009-12-18', '1'), ('10477', '117.136.8.147', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10478', '117.136.30.75', '中国', '移动', '0', '2009-12-18', '1'), ('10479', '117.136.9.25', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10480', '117.136.10.52', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10481', '117.136.19.2', '中国', '移动', '0', '2009-12-18', '1'), ('10482', '117.136.9.65', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10483', '117.136.30.83', '中国', '移动', '0', '2009-12-18', '1'), ('10484', '117.136.30.81', '中国', '移动', '0', '2009-12-18', '1'), ('10485', '117.136.0.48', '中国', '移动', '0', '2009-12-18', '1'), ('10486', '117.136.6.28', '辽宁省本溪市', '移动', '0', '2009-12-18', '1'), ('10487', '117.136.12.255', '中国', '移动', '0', '2009-12-18', '1'), ('10488', '117.136.11.147', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10489', '117.136.31.22', '中国', '移动', '0', '2009-12-18', '1'), ('10490', '117.136.20.20', '中国', '移动', '0', '2009-12-18', '1'), ('10491', '221.182.46.148', '中国', '移动', '0', '2009-12-18', '1'), ('10492', '117.136.12.169', '中国', '移动', '0', '2009-12-18', '1'), ('10493', '117.136.20.23', '中国', '移动', '0', '2009-12-18', '1'), ('10494', '117.136.1.142', '中国', '移动', '0', '2009-12-18', '1'), ('10495', '218.202.227.152', '上海市', '移动', '0', '2009-12-18', '1'), ('10496', '117.136.0.19', '中国', '移动', '0', '2009-12-18', '1'), ('10497', '117.136.21.181', '中国', '移动', '0', '2009-12-18', '1'), ('10498', '117.136.15.250', '中国', '移动', '0', '2009-12-18', '1'), ('10499', '117.136.11.72', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10500', '117.136.15.12', '中国', '移动', '0', '2009-12-18', '1'), ('10501', '117.136.21.154', '中国', '移动', '0', '2009-12-18', '1'), ('10502', '117.136.21.136', '中国', '移动', '0', '2009-12-18', '1'), ('10503', '117.136.21.151', '中国', '移动', '0', '2009-12-18', '1'), ('10504', '117.136.11.145', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10505', '117.136.9.26', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10506', '117.136.22.170', '中国', '移动', '0', '2009-12-18', '1'), ('10507', '211.137.63.156', '湖北省十堰市', '移动', '0', '2009-12-18', '1'), ('10508', '117.136.10.59', '山东省潍坊市', '移动', '0', '2009-12-18', '1'), ('10509', '117.136.5.84', '辽宁省本溪市', '移动', '0', '2009-12-18', '1'), ('10510', '117.136.0.16', '中国', '移动', '0', '2009-12-18', '1'), ('10511', '117.136.12.104', '中国', '移动', '0', '2009-12-18', '1'), ('10512', '211.137.63.90', '湖北省十堰市', '移动', '0', '2009-12-18', '1'), ('10513', '117.136.3.33', '中国', '移动', '0', '2009-12-18', '1'), ('10514', '117.136.12.149', '中国', '移动', '0', '2009-12-18', '1'), ('10515', '117.136.0.8', '中国', '移动', '0', '2009-12-18', '1'), ('10516', '117.136.24.116', '中国', '移动', '0', '2009-12-19', '1'), ('10517', '117.136.4.251', '辽宁省本溪市', '移动', '0', '2009-12-19', '1'), ('10518', '117.136.2.26', '中国', '移动', '0', '2009-12-19', '1'), ('10519', '117.136.8.143', '山东省潍坊市', '移动', '0', '2009-12-19', '1'), ('10520', '117.136.15.55', '中国', '移动', '0', '2009-12-19', '1'), ('10521', '117.136.11.135', '山东省潍坊市', '移动', '0', '2009-12-19', '1'), ('10522', '117.136.12.101', '中国', '移动', '0', '2009-12-19', '1'), ('10523', '117.136.10.6', '山东省潍坊市', '移动', '0', '2009-12-19', '1'), ('10524', '117.136.12.170', '中国', '移动', '0', '2009-12-19', '1'), ('10525', '117.136.15.207', '中国', '移动', '0', '2009-12-19', '1'), ('10526', '117.136.17.21', '中国', '移动', '0', '2009-12-19', '1'), ('10527', '117.136.15.54', '中国', '移动', '0', '2009-12-19', '1'), ('10528', '117.136.20.21', '中国', '移动', '0', '2009-12-19', '1'), ('10529', '117.136.5.71', '辽宁省本溪市', '移动', '0', '2009-12-19', '1'), ('10530', '117.136.11.157', '山东省潍坊市', '移动', '0', '2009-12-19', '1'), ('10531', '117.136.19.4', '中国', '移动', '0', '2009-12-19', '1'), ('10532', '117.136.15.23', '中国', '移动', '0', '2009-12-19', '1'), ('10533', '117.136.2.13', '中国', '移动', '0', '2009-12-19', '1'), ('10534', '117.136.12.249', '中国', '移动', '0', '2009-12-19', '1'), ('10535', '117.136.8.154', '山东省潍坊市', '移动', '0', '2009-12-19', '1'), ('10536', '117.136.8.132', '山东省潍坊市', '移动', '0', '2009-12-19', '1'), ('10537', '117.136.10.20', '山东省潍坊市', '移动', '0', '2009-12-19', '1'), ('10538', '117.136.12.254', '中国', '移动', '0', '2009-12-19', '1'), ('10539', '117.136.0.155', '中国', '移动', '0', '2009-12-19', '1'), ('10540', '117.136.24.85', '中国', '移动', '0', '2009-12-19', '1'), ('10541', '117.136.4.252', '辽宁省本溪市', '移动', '0', '2009-12-20', '1'), ('10542', '117.136.3.34', '中国', '移动', '0', '2009-12-20', '1'), ('10543', '117.136.10.173', '山东省潍坊市', '移动', '0', '2009-12-20', '1'), ('10544', '117.136.12.92', '中国', '移动', '0', '2009-12-20', '1'), ('10545', '117.136.12.45', '中国', '移动', '0', '2009-12-20', '1'), ('10546', '117.136.12.148', '中国', '移动', '0', '2009-12-20', '1'), ('10547', '117.136.11.68', '山东省潍坊市', '移动', '0', '2009-12-20', '1'), ('10548', '117.136.5.79', '辽宁省本溪市', '移动', '0', '2009-12-20', '1'), ('10549', '117.136.2.49', '中国', '移动', '0', '2009-12-20', '1'), ('10550', '117.136.5.221', '辽宁省本溪市', '移动', '0', '2009-12-20', '1'), ('10551', '117.136.31.160', '中国', '移动', '0', '2009-12-20', '1'), ('10552', '117.136.31.170', '中国', '移动', '0', '2009-12-20', '1'), ('10553', '117.136.1.129', '中国', '移动', '0', '2009-12-20', '1'), ('10554', '117.136.11.30', '山东省潍坊市', '移动', '0', '2009-12-20', '1'), ('10555', '117.136.21.137', '中国', '移动', '0', '2009-12-20', '1'), ('10556', '117.136.15.196', '中国', '移动', '0', '2009-12-20', '1'), ('10557', '117.136.8.139', '山东省潍坊市', '移动', '0', '2009-12-21', '1'), ('10558', '117.136.8.141', '山东省潍坊市', '移动', '0', '2009-12-21', '1'), ('10559', '117.136.12.94', '中国', '移动', '0', '2009-12-21', '1'), ('10560', '117.136.4.246', '辽宁省本溪市', '移动', '0', '2009-12-21', '1'), ('10561', '117.136.10.172', '山东省潍坊市', '移动', '0', '2009-12-21', '1'), ('10562', '117.136.2.10', '中国', '移动', '0', '2009-12-21', '1'), ('10563', '117.136.17.29', '中国', '移动', '0', '2009-12-21', '1'), ('10564', '117.136.18.20', '中国', '移动', '0', '2009-12-21', '1'), ('10565', '117.136.5.4', '辽宁省本溪市', '移动', '0', '2009-12-21', '1'), ('10566', '117.136.12.183', '中国', '移动', '0', '2009-12-21', '1'), ('10567', '117.136.0.152', '中国', '移动', '0', '2009-12-21', '1'), ('10568', '117.136.15.22', '中国', '移动', '0', '2009-12-21', '1'), ('10569', '117.136.18.19', '中国', '移动', '0', '2009-12-21', '1'), ('10570', '117.136.22.171', '中国', '移动', '0', '2009-12-21', '1'), ('10571', '117.136.21.177', '中国', '移动', '0', '2009-12-21', '1'), ('10572', '117.136.11.139', '山东省潍坊市', '移动', '0', '2009-12-21', '1'), ('10573', '117.136.1.150', '中国', '移动', '0', '2009-12-21', '1'), ('10574', '117.136.11.73', '山东省潍坊市', '移动', '0', '2009-12-21', '1'), ('10575', '117.136.0.142', '中国', '移动', '0', '2009-12-21', '1'), ('10576', '117.136.5.197', '辽宁省本溪市', '移动', '0', '2009-12-21', '1'), ('10577', '117.136.15.253', '中国', '移动', '0', '2009-12-21', '1'), ('10578', '117.136.2.12', '中国', '移动', '0', '2009-12-21', '1'), ('10579', '117.136.30.20', '中国', '移动', '0', '2009-12-22', '1'), ('10580', '117.136.30.29', '中国', '移动', '0', '2009-12-22', '1'), ('10581', '117.136.21.247', '中国', '移动', '0', '2009-12-22', '1'), ('10582', '117.136.0.158', '中国', '移动', '0', '2009-12-22', '1'), ('10583', '117.136.18.27', '中国', '移动', '0', '2009-12-22', '1'), ('10584', '117.136.12.214', '中国', '移动', '0', '2009-12-22', '1'), ('10585', '117.136.23.191', '中国', '移动', '0', '2009-12-22', '1'), ('10586', '117.136.5.11', '辽宁省本溪市', '移动', '0', '2009-12-22', '1'), ('10587', '117.136.17.7', '中国', '移动', '0', '2009-12-22', '1'), ('10588', '117.136.5.9', '辽宁省本溪市', '移动', '0', '2009-12-22', '1'), ('10589', '117.136.12.66', '中国', '移动', '0', '2009-12-22', '1'), ('10590', '117.136.1.151', '中国', '移动', '0', '2009-12-22', '1'), ('10591', '117.136.15.235', '中国', '移动', '0', '2009-12-22', '1'), ('10592', '117.136.12.147', '中国', '移动', '0', '2009-12-22', '1'), ('10593', '117.136.17.10', '中国', '移动', '0', '2009-12-22', '1'), ('10594', '117.136.3.36', '中国', '移动', '0', '2009-12-22', '1'), ('10595', '117.136.10.180', '山东省潍坊市', '移动', '0', '2009-12-22', '1'), ('10596', '117.136.0.132', '中国', '移动', '0', '2009-12-22', '1'), ('10597', '117.136.15.237', '中国', '移动', '0', '2009-12-22', '1'), ('10598', '117.136.30.5', '中国', '移动', '0', '2009-12-23', '1'), ('10599', '117.136.1.140', '中国', '移动', '0', '2009-12-23', '1'), ('10600', '117.136.15.175', '中国', '移动', '0', '2009-12-23', '1'), ('10601', '117.136.17.23', '中国', '移动', '0', '2009-12-23', '1'), ('10602', '117.136.30.84', '中国', '移动', '0', '2009-12-23', '1'), ('10603', '117.136.18.29', '中国', '移动', '0', '2009-12-23', '1'), ('10604', '117.136.10.18', '山东省潍坊市', '移动', '0', '2009-12-23', '1'), ('10605', '117.136.12.175', '中国', '移动', '0', '2009-12-23', '1'), ('10606', '117.136.9.12', '山东省潍坊市', '移动', '0', '2009-12-23', '1'), ('10607', '117.136.11.27', '山东省潍坊市', '移动', '0', '2009-12-23', '1'), ('10608', '117.136.10.26', '山东省潍坊市', '移动', '0', '2009-12-23', '1'), ('10609', '117.136.31.178', '中国', '移动', '0', '2009-12-23', '1'), ('10610', '117.136.10.184', '山东省潍坊市', '移动', '0', '2009-12-23', '1'), ('10611', '211.137.63.128', '湖北省十堰市', '移动', '0', '2009-12-23', '1'), ('10612', '117.136.12.173', '中国', '移动', '0', '2009-12-23', '1'), ('10613', '117.136.4.10', '辽宁省本溪市', '移动', '0', '2009-12-23', '1'), ('10614', '211.139.92.231', '甘肃省兰州市', '移动', '0', '2009-12-23', '1'), ('10615', '218.201.21.180', '重庆市', '移动', '0', '2009-12-23', '1'), ('10616', '117.136.12.145', '中国', '移动', '0', '2009-12-23', '1'), ('10617', '117.136.5.82', '辽宁省本溪市', '移动', '0', '2009-12-23', '1'), ('10618', '117.136.12.174', '中国', '移动', '0', '2009-12-23', '1'), ('10619', '117.136.0.128', '中国', '移动', '0', '2009-12-23', '1'), ('10620', '211.137.63.158', '湖北省十堰市', '移动', '0', '2009-12-23', '1'), ('10621', '117.136.17.24', '中国', '移动', '0', '2009-12-23', '1'), ('10622', '211.137.63.111', '湖北省十堰市', '移动', '0', '2009-12-23', '1'), ('10623', '117.136.6.24', '辽宁省本溪市', '移动', '0', '2009-12-24', '1'), ('10624', '117.136.15.184', '中国', '移动', '0', '2009-12-24', '1'), ('10625', '117.136.15.198', '中国', '移动', '0', '2009-12-24', '1'), ('10626', '117.136.11.154', '山东省潍坊市', '移动', '0', '2009-12-24', '1'), ('10627', '117.136.11.140', '山东省潍坊市', '移动', '0', '2009-12-24', '1'), ('10628', '117.136.1.26', '中国', '移动', '0', '2009-12-24', '1'), ('10629', '117.136.10.156', '山东省潍坊市', '移动', '0', '2009-12-24', '1'), ('10630', '117.136.12.213', '中国', '移动', '0', '2009-12-24', '1'), ('10631', '117.136.21.180', '中国', '移动', '0', '2009-12-24', '1'), ('10632', '117.136.21.194', '中国', '移动', '0', '2009-12-24', '1'), ('10633', '117.136.5.222', '辽宁省本溪市', '移动', '0', '2009-12-24', '1'), ('10634', '117.136.12.102', '中国', '移动', '0', '2009-12-24', '1'), ('10635', '117.136.12.177', '中国', '移动', '0', '2009-12-24', '1'), ('10636', '117.136.12.146', '中国', '移动', '0', '2009-12-24', '1'), ('10637', '117.136.12.212', '中国', '移动', '0', '2009-12-24', '1'), ('10638', '117.136.11.20', '山东省潍坊市', '移动', '0', '2009-12-24', '1'), ('10639', '211.137.63.176', '湖北省十堰市', '移动', '0', '2009-12-24', '1'), ('10640', '117.136.6.7', '辽宁省本溪市', '移动', '0', '2009-12-25', '1'), ('10641', '117.136.11.76', '山东省潍坊市', '移动', '0', '2009-12-25', '1'), ('10642', '117.136.0.38', '中国', '移动', '0', '2009-12-25', '1'), ('10643', '117.136.24.65', '中国', '移动', '0', '2009-12-25', '1'), ('10644', '117.136.9.11', '山东省潍坊市', '移动', '0', '2009-12-25', '1'), ('10645', '117.136.11.169', '山东省潍坊市', '移动', '0', '2009-12-25', '1'), ('10646', '117.136.12.218', '中国', '移动', '0', '2009-12-25', '1'), ('10647', '117.136.17.14', '中国', '移动', '0', '2009-12-25', '1'), ('10648', '117.136.1.146', '中国', '移动', '0', '2009-12-25', '1'), ('10649', '117.136.12.176', '中国', '移动', '0', '2009-12-25', '1'), ('10650', '117.136.12.41', '中国', '移动', '0', '2009-12-25', '1'), ('10651', '117.136.4.249', '辽宁省本溪市', '移动', '0', '2009-12-25', '1'), ('10652', '117.136.12.210', '中国', '移动', '0', '2009-12-25', '1'), ('10653', '117.136.12.208', '中国', '移动', '0', '2009-12-25', '1'), ('10654', '117.136.21.5', '中国', '移动', '0', '2009-12-26', '1'), ('10655', '117.136.12.151', '中国', '移动', '0', '2009-12-26', '1'), ('10656', '117.136.17.8', '中国', '移动', '0', '2009-12-26', '1'), ('10657', '117.136.1.159', '中国', '移动', '0', '2009-12-26', '1'), ('10658', '117.136.21.161', '中国', '移动', '0', '2009-12-26', '1'), ('10659', '117.136.31.29', '中国', '移动', '0', '2009-12-26', '1'), ('10660', '117.136.12.215', '中国', '移动', '0', '2009-12-26', '1'), ('10661', '117.136.12.106', '中国', '移动', '0', '2009-12-26', '1'), ('10662', '117.136.15.163', '中国', '移动', '0', '2009-12-26', '1'), ('10663', '117.136.12.137', '中国', '移动', '0', '2009-12-26', '1'), ('10664', '117.136.31.25', '中国', '移动', '0', '2009-12-26', '1'), ('10665', '117.136.19.163', '中国', '移动', '0', '2009-12-26', '1'), ('10666', '117.136.18.24', '中国', '移动', '0', '2009-12-26', '1'), ('10667', '211.137.63.81', '湖北省十堰市', '移动', '0', '2009-12-26', '1'), ('10668', '117.136.11.170', '山东省潍坊市', '移动', '0', '2009-12-27', '1'), ('10669', '117.136.2.52', '中国', '移动', '0', '2009-12-27', '1'), ('10670', '211.137.63.160', '湖北省十堰市', '移动', '0', '2009-12-27', '1'), ('10671', '117.136.0.145', '中国', '移动', '0', '2009-12-27', '1'), ('10672', '211.139.164.204', '广东省', '移动', '0', '2009-12-27', '1'), ('10673', '117.136.0.153', '中国', '移动', '0', '2009-12-27', '1'), ('10674', '117.136.31.175', '中国', '移动', '0', '2009-12-27', '1'), ('10675', '117.136.19.172', '中国', '移动', '0', '2009-12-27', '1'), ('10676', '117.136.12.29', '中国', '移动', '0', '2009-12-27', '1'), ('10677', '117.136.12.141', '中国', '移动', '0', '2009-12-27', '1'), ('10678', '117.136.5.65', '辽宁省本溪市', '移动', '0', '2009-12-27', '1'), ('10679', '117.136.17.11', '中国', '移动', '0', '2009-12-27', '1'), ('10680', '117.136.0.26', '中国', '移动', '0', '2009-12-27', '1'), ('10681', '117.136.5.210', '辽宁省本溪市', '移动', '0', '2009-12-27', '1'), ('10682', '117.136.15.103', '中国', '移动', '0', '2009-12-27', '1'), ('10683', '117.136.4.248', '辽宁省本溪市', '移动', '0', '2009-12-27', '1'), ('10684', '117.136.11.171', '山东省潍坊市', '移动', '0', '2009-12-27', '1'), ('10685', '117.136.0.23', '中国', '移动', '0', '2009-12-27', '1'), ('10686', '117.136.12.27', '中国', '移动', '0', '2009-12-27', '1'), ('10687', '117.136.24.74', '中国', '移动', '0', '2009-12-27', '1'), ('10688', '117.136.12.250', '中国', '移动', '0', '2009-12-27', '1'), ('10689', '117.136.0.49', '中国', '移动', '0', '2009-12-27', '1'), ('10690', '117.136.1.144', '中国', '移动', '0', '2009-12-27', '1'), ('10691', '117.136.21.238', '中国', '移动', '0', '2009-12-27', '1'), ('10692', '117.136.15.47', '中国', '移动', '0', '2009-12-27', '1'), ('10693', '117.136.19.202', '中国', '移动', '0', '2009-12-27', '1'), ('10694', '117.136.11.172', '山东省潍坊市', '移动', '0', '2009-12-27', '1'), ('10695', '117.136.0.61', '中国', '移动', '0', '2009-12-27', '1'), ('10696', '117.136.5.89', '辽宁省本溪市', '移动', '0', '2009-12-27', '1'), ('10697', '117.136.11.132', '山东省潍坊市', '移动', '0', '2009-12-27', '1'), ('10698', '117.136.21.168', '中国', '移动', '0', '2009-12-28', '1'), ('10699', '117.136.21.205', '中国', '移动', '0', '2009-12-28', '1'), ('10700', '117.136.9.177', '山东省潍坊市', '移动', '0', '2009-12-28', '1'), ('10701', '117.136.31.169', '中国', '移动', '0', '2009-12-28', '1'), ('10702', '117.136.0.151', '中国', '移动', '0', '2009-12-28', '1'), ('10703', '117.136.0.12', '中国', '移动', '0', '2009-12-28', '1'), ('10704', '117.136.15.171', '中国', '移动', '0', '2009-12-28', '1'), ('10705', '117.136.9.59', '山东省潍坊市', '移动', '0', '2009-12-28', '1'), ('10706', '117.136.15.96', '中国', '移动', '0', '2009-12-28', '1'), ('10707', '117.136.15.181', '中国', '移动', '0', '2009-12-28', '1'), ('10708', '117.136.11.155', '山东省潍坊市', '移动', '0', '2009-12-28', '1'), ('10709', '117.136.15.59', '中国', '移动', '0', '2009-12-28', '1'), ('10710', '117.136.11.28', '山东省潍坊市', '移动', '0', '2009-12-28', '1'), ('10711', '117.136.31.165', '中国', '移动', '0', '2009-12-28', '1'), ('10712', '117.136.0.56', '中国', '移动', '0', '2009-12-28', '1'), ('10713', '211.137.63.170', '湖北省十堰市', '移动', '0', '2009-12-28', '1'), ('10714', '117.136.8.150', '山东省潍坊市', '移动', '0', '2009-12-28', '1'), ('10715', '211.137.63.80', '湖北省十堰市', '移动', '0', '2009-12-29', '1'), ('10716', '117.136.24.18', '中国', '移动', '0', '2009-12-29', '1'), ('10717', '117.136.20.69', '中国', '移动', '0', '2009-12-29', '1'), ('10718', '117.136.22.169', '中国', '移动', '0', '2009-12-29', '1'), ('10719', '117.136.11.163', '山东省潍坊市', '移动', '0', '2009-12-29', '1'), ('10720', '117.136.31.168', '中国', '移动', '0', '2009-12-29', '1'), ('10721', '117.136.12.82', '中国', '移动', '0', '2009-12-29', '1'), ('10722', '117.136.21.2', '中国', '移动', '0', '2009-12-30', '1'), ('10723', '117.136.20.66', '中国', '移动', '0', '2009-12-30', '1'), ('10724', '117.136.21.1', '中国', '移动', '0', '2009-12-30', '1'), ('10725', '117.136.12.20', '中国', '移动', '0', '2009-12-30', '1'), ('10726', '117.136.12.105', '中国', '移动', '0', '2009-12-30', '1'), ('10727', '117.136.12.203', '中国', '移动', '0', '2009-12-30', '1'), ('10728', '117.136.18.22', '中国', '移动', '0', '2009-12-30', '1'), ('10729', '117.136.31.172', '中国', '移动', '0', '2009-12-30', '1'), ('10730', '117.136.12.246', '中国', '移动', '0', '2009-12-30', '1'), ('10731', '117.136.10.25', '山东省潍坊市', '移动', '0', '2009-12-30', '1'), ('10732', '117.136.0.147', '中国', '移动', '0', '2009-12-30', '1'), ('10733', '117.136.5.77', '辽宁省本溪市', '移动', '0', '2009-12-30', '1'), ('10734', '117.136.24.93', '中国', '移动', '0', '2009-12-31', '1'), ('10735', '117.136.8.13', '山东省潍坊市', '移动', '0', '2009-12-31', '1'), ('10736', '117.136.21.7', '中国', '移动', '0', '2009-12-31', '1'), ('10737', '117.136.1.28', '中国', '移动', '0', '2009-12-31', '1'), ('10738', '117.136.8.131', '山东省潍坊市', '移动', '0', '2009-12-31', '1'), ('10739', '117.136.30.82', '中国', '移动', '0', '2009-12-31', '1'), ('10740', '117.136.17.6', '中国', '移动', '0', '2009-12-31', '1'), ('10741', '117.136.15.27', '中国', '移动', '0', '2009-12-31', '1'), ('10742', '117.136.31.173', '中国', '移动', '0', '2009-12-31', '1'), ('10743', '117.136.12.97', '中国', '移动', '0', '2009-12-31', '1'), ('10744', '117.136.9.3', '山东省潍坊市', '移动', '0', '2009-12-31', '1'), ('10745', '117.136.12.219', '中国', '移动', '0', '2009-12-31', '1'), ('10746', '117.136.30.71', '中国', '移动', '0', '2009-12-31', '1'), ('10747', '117.136.19.174', '中国', '移动', '0', '2009-12-31', '1'), ('10748', '117.136.0.6', '中国', '移动', '0', '2009-12-31', '1'), ('10749', '117.136.2.25', '中国', '移动', '0', '2010-01-01', '1'), ('10750', '117.136.10.181', '山东省潍坊市', '移动', '0', '2010-01-01', '1'), ('10751', '221.182.2.163', '四川省成都市', '移动', '0', '2010-01-01', '1'), ('10752', '221.130.13.94', '江苏省南京市', '移动', '0', '2010-01-01', '1'), ('10753', '117.136.31.161', '中国', '移动', '0', '2010-01-01', '1'), ('10754', '117.136.31.179', '中国', '移动', '0', '2010-01-01', '1'), ('10755', '211.139.253.26', '广东省广州市', '移动', '0', '2010-01-01', '1'), ('10756', '117.136.5.69', '辽宁省本溪市', '移动', '0', '2010-01-01', '1'), ('10757', '117.136.30.54', '中国', '移动', '0', '2010-01-01', '1'), ('10758', '117.136.1.29', '中国', '移动', '0', '2010-01-01', '1'), ('10759', '117.136.11.71', '山东省潍坊市', '移动', '0', '2010-01-01', '1'), ('10760', '117.136.30.69', '中国', '移动', '0', '2010-01-01', '1'), ('10761', '117.136.9.74', '山东省潍坊市', '移动', '0', '2010-01-01', '1'), ('10762', '117.136.30.85', '中国', '移动', '0', '2010-01-02', '1'), ('10763', '117.136.12.202', '中国', '移动', '0', '2010-01-02', '1'), ('10764', '117.136.15.42', '中国', '移动', '0', '2010-01-02', '1'), ('10765', '117.136.11.79', '山东省潍坊市', '移动', '0', '2010-01-02', '1'), ('10766', '117.136.21.3', '中国', '移动', '0', '2010-01-02', '1'), ('10767', '117.136.20.11', '中国', '移动', '0', '2010-01-02', '1'), ('10768', '117.136.0.141', '中国', '移动', '0', '2010-01-02', '1'), ('10769', '117.136.5.72', '辽宁省本溪市', '移动', '0', '2010-01-02', '1'), ('10770', '117.136.1.253', '中国', '移动', '0', '2010-01-02', '1'), ('10771', '117.136.30.80', '中国', '移动', '0', '2010-01-02', '1'), ('10772', '117.136.21.215', '中国', '移动', '0', '2010-01-02', '1'), ('10773', '117.136.9.51', '山东省潍坊市', '移动', '0', '2010-01-02', '1'), ('10774', '117.136.9.50', '山东省潍坊市', '移动', '0', '2010-01-02', '1'), ('10775', '117.136.24.51', '中国', '移动', '0', '2010-01-02', '1'), ('10776', '117.136.9.44', '山东省潍坊市', '移动', '0', '2010-01-02', '1'), ('10777', '117.136.0.17', '中国', '移动', '0', '2010-01-02', '1'), ('10778', '117.136.0.139', '中国', '移动', '0', '2010-01-02', '1'), ('10779', '117.136.16.80', '中国', '移动', '0', '2010-01-02', '1'), ('10780', '117.136.11.22', '山东省潍坊市', '移动', '0', '2010-01-02', '1'), ('10781', '117.136.10.58', '山东省潍坊市', '移动', '0', '2010-01-02', '1'), ('10782', '117.136.5.208', '辽宁省本溪市', '移动', '0', '2010-01-03', '1'), ('10783', '117.136.4.242', '辽宁省本溪市', '移动', '0', '2010-01-03', '1'), ('10784', '117.136.18.23', '中国', '移动', '0', '2010-01-03', '1'), ('10785', '117.136.18.17', '中国', '移动', '0', '2010-01-03', '1'), ('10786', '117.136.11.167', '山东省潍坊市', '移动', '0', '2010-01-03', '1'), ('10787', '117.136.1.153', '中国', '移动', '0', '2010-01-03', '1'), ('10788', '117.136.24.31', '中国', '移动', '0', '2010-01-03', '1'), ('10789', '117.136.10.182', '山东省潍坊市', '移动', '0', '2010-01-03', '1'), ('10790', '211.137.63.86', '湖北省十堰市', '移动', '0', '2010-01-03', '1'), ('10791', '117.136.15.233', '中国', '移动', '0', '2010-01-03', '1'), ('10792', '117.136.21.158', '中国', '移动', '0', '2010-01-03', '1'), ('10793', '117.136.0.58', '中国', '移动', '0', '2010-01-03', '1'), ('10794', '117.136.30.19', '中国', '移动', '0', '2010-01-03', '1'), ('10795', '117.136.30.53', '中国', '移动', '0', '2010-01-03', '1'), ('10796', '117.136.12.204', '中国', '移动', '0', '2010-01-03', '1'), ('10797', '117.136.15.99', '中国', '移动', '0', '2010-01-03', '1'), ('10798', '117.136.15.48', '中国', '移动', '0', '2010-01-03', '1'), ('10799', '211.137.63.161', '湖北省十堰市', '移动', '0', '2010-01-04', '1'), ('10800', '117.136.10.186', '山东省潍坊市', '移动', '0', '2010-01-04', '1'), ('10801', '117.136.9.57', '山东省潍坊市', '移动', '0', '2010-01-04', '1'), ('10802', '117.136.30.42', '中国', '移动', '0', '2010-01-04', '1'), ('10803', '117.136.30.41', '中国', '移动', '0', '2010-01-04', '1'), ('10804', '117.136.30.47', '中国', '移动', '0', '2010-01-04', '1'), ('10805', '117.136.23.207', '中国', '移动', '0', '2010-01-04', '1'), ('10806', '117.136.30.68', '中国', '移动', '0', '2010-01-04', '1'), ('10807', '117.136.8.158', '山东省潍坊市', '移动', '0', '2010-01-04', '1'), ('10808', '117.136.1.249', '中国', '移动', '0', '2010-01-04', '1'), ('10809', '117.136.24.139', '中国', '移动', '0', '2010-01-04', '1'), ('10810', '117.136.15.102', '中国', '移动', '0', '2010-01-04', '1'), ('10811', '117.136.10.62', '山东省潍坊市', '移动', '0', '2010-01-04', '1'), ('10812', '117.136.2.41', '中国', '移动', '0', '2010-01-04', '1'), ('10813', '117.136.11.83', '山东省潍坊市', '移动', '0', '2010-01-04', '1'), ('10814', '221.182.2.164', '四川省成都市', '移动', '0', '2010-01-04', '1'), ('10815', '117.136.0.33', '中国', '移动', '0', '2010-01-04', '1'), ('10816', '117.136.31.26', '中国', '移动', '0', '2010-01-04', '1'), ('10817', '117.136.0.40', '中国', '移动', '0', '2010-01-04', '1'), ('10818', '117.136.24.69', '中国', '移动', '0', '2010-01-05', '1'), ('10819', '117.136.12.243', '中国', '移动', '0', '2010-01-05', '1'), ('10820', '117.136.10.22', '山东省潍坊市', '移动', '0', '2010-01-05', '1'), ('10821', '117.136.11.86', '山东省潍坊市', '移动', '0', '2010-01-05', '1'), ('10822', '117.136.1.143', '中国', '移动', '0', '2010-01-05', '1'), ('10823', '117.136.4.11', '辽宁省本溪市', '移动', '0', '2010-01-05', '1'), ('10824', '117.136.0.3', '中国', '移动', '0', '2010-01-05', '1'), ('10825', '117.136.5.3', '辽宁省本溪市', '移动', '0', '2010-01-05', '1'), ('10826', '117.136.11.85', '山东省潍坊市', '移动', '0', '2010-01-05', '1'), ('10827', '117.136.15.53', '中国', '移动', '0', '2010-01-05', '1'), ('10828', '117.136.21.211', '中国', '移动', '0', '2010-01-05', '1'), ('10829', '117.136.30.33', '中国', '移动', '0', '2010-01-05', '1'), ('10830', '117.136.23.163', '中国', '移动', '0', '2010-01-05', '1'), ('10831', '117.136.11.94', '山东省潍坊市', '移动', '0', '2010-01-05', '1'), ('10832', '117.136.4.13', '辽宁省本溪市', '移动', '0', '2010-01-05', '1'), ('10833', '117.136.16.67', '中国', '移动', '0', '2010-01-05', '1'), ('10834', '117.136.12.206', '中国', '移动', '0', '2010-01-05', '1'), ('10835', '117.136.10.187', '山东省潍坊市', '移动', '0', '2010-01-05', '1'), ('10836', '117.136.9.52', '山东省潍坊市', '移动', '0', '2010-01-05', '1'), ('10837', '117.136.11.87', '山东省潍坊市', '移动', '0', '2010-01-06', '1'), ('10838', '117.136.18.25', '中国', '移动', '0', '2010-01-06', '1'), ('10839', '117.136.11.80', '山东省潍坊市', '移动', '0', '2010-01-06', '1'), ('10840', '221.179.8.18', '重庆市', '移动', '0', '2010-01-06', '1'), ('10841', '117.136.12.65', '中国', '移动', '0', '2010-01-06', '1'), ('10842', '117.136.24.6', '中国', '移动', '0', '2010-01-06', '1'), ('10843', '117.136.10.27', '山东省潍坊市', '移动', '0', '2010-01-06', '1'), ('10844', '117.136.11.81', '山东省潍坊市', '移动', '0', '2010-01-06', '1'), ('10845', '117.136.30.67', '中国', '移动', '0', '2010-01-06', '1'), ('10846', '211.137.63.169', '湖北省十堰市', '移动', '0', '2010-01-06', '1'), ('10847', '117.136.30.49', '中国', '移动', '0', '2010-01-06', '1'), ('10848', '117.136.11.93', '山东省潍坊市', '移动', '0', '2010-01-06', '1'), ('10849', '117.136.23.230', '中国', '移动', '0', '2010-01-06', '1'), ('10850', '211.137.63.78', '湖北省十堰市', '移动', '0', '2010-01-06', '1'), ('10851', '117.136.15.39', '中国', '移动', '0', '2010-01-06', '1'), ('10852', '117.136.23.166', '中国', '移动', '0', '2010-01-06', '1'), ('10853', '117.136.12.118', '中国', '移动', '0', '2010-01-06', '1'), ('10854', '117.136.9.4', '山东省潍坊市', '移动', '0', '2010-01-06', '1'), ('10855', '117.136.12.117', '中国', '移动', '0', '2010-01-06', '1'), ('10856', '117.136.16.66', '中国', '移动', '0', '2010-01-06', '1'), ('10857', '211.137.63.121', '湖北省十堰市', '移动', '0', '2010-01-06', '1'), ('10858', '117.136.15.50', '中国', '移动', '0', '2010-01-06', '1'), ('10859', '117.136.15.224', '中国', '移动', '0', '2010-01-07', '1'), ('10860', '117.136.30.63', '中国', '移动', '0', '2010-01-07', '1'), ('10861', '117.136.11.84', '山东省潍坊市', '移动', '0', '2010-01-07', '1'), ('10862', '117.136.30.76', '中国', '移动', '0', '2010-01-07', '1'), ('10863', '117.136.11.95', '山东省潍坊市', '移动', '0', '2010-01-07', '1'), ('10864', '221.182.2.161', '四川省成都市', '移动', '0', '2010-01-07', '1'), ('10865', '117.136.17.9', '中国', '移动', '0', '2010-01-07', '1'), ('10866', '117.136.15.67', '中国', '移动', '0', '2010-01-07', '1'), ('10867', '117.136.5.198', '辽宁省本溪市', '移动', '0', '2010-01-07', '1'), ('10868', '117.136.0.149', '中国', '移动', '0', '2010-01-07', '1'), ('10869', '211.137.63.108', '湖北省十堰市', '移动', '0', '2010-01-07', '1'), ('10870', '117.136.31.46', '中国', '移动', '0', '2010-01-07', '1'), ('10871', '117.136.19.164', '中国', '移动', '0', '2010-01-07', '1'), ('10872', '117.136.15.65', '中国', '移动', '0', '2010-01-07', '1'), ('10873', '117.136.24.131', '中国', '移动', '0', '2010-01-07', '1'), ('10874', '117.136.22.140', '中国', '移动', '0', '2010-01-07', '1'), ('10875', '117.136.24.130', '中国', '移动', '0', '2010-01-07', '1'), ('10876', '117.136.0.129', '中国', '移动', '0', '2010-01-07', '1'), ('10877', '211.137.63.100', '湖北省十堰市', '移动', '0', '2010-01-08', '1'), ('10878', '117.136.30.11', '中国', '移动', '0', '2010-01-08', '1'), ('10879', '117.136.15.179', '中国', '移动', '0', '2010-01-08', '1'), ('10880', '117.136.5.78', '辽宁省本溪市', '移动', '0', '2010-01-08', '1'), ('10881', '117.136.15.36', '中国', '移动', '0', '2010-01-08', '1'), ('10882', '211.137.63.79', '湖北省十堰市', '移动', '0', '2010-01-08', '1'), ('10883', '117.136.5.81', '辽宁省本溪市', '移动', '0', '2010-01-08', '1'), ('10884', '117.136.5.66', '辽宁省本溪市', '移动', '0', '2010-01-08', '1'), ('10885', '221.179.8.50', '重庆市', '移动', '0', '2010-01-08', '1'), ('10886', '117.136.21.250', '中国', '移动', '0', '2010-01-08', '1'), ('10887', '211.137.63.69', '湖北省十堰市', '移动', '0', '2010-01-08', '1'), ('10888', '117.136.22.144', '中国', '移动', '0', '2010-01-08', '1'), ('10889', '117.136.11.24', '山东省潍坊市', '移动', '0', '2010-01-08', '1'), ('10890', '117.136.23.241', '中国', '移动', '0', '2010-01-08', '1'), ('10891', '117.136.15.66', '中国', '移动', '0', '2010-01-08', '1'), ('10892', '117.136.11.89', '山东省潍坊市', '移动', '0', '2010-01-08', '1'), ('10893', '117.136.15.31', '中国', '移动', '0', '2010-01-08', '1'), ('10894', '117.136.4.250', '辽宁省本溪市', '移动', '0', '2010-01-08', '1'), ('10895', '117.136.11.91', '山东省潍坊市', '移动', '0', '2010-01-08', '1'), ('10896', '117.136.31.174', '中国', '移动', '0', '2010-01-08', '1'), ('10897', '117.136.30.74', '中国', '移动', '0', '2010-01-09', '1'), ('10898', '117.136.11.92', '山东省潍坊市', '移动', '0', '2010-01-09', '1'), ('10899', '117.136.30.51', '中国', '移动', '0', '2010-01-09', '1'), ('10900', '117.136.16.3', '中国', '移动', '0', '2010-01-09', '1'), ('10901', '117.136.12.225', '中国', '移动', '0', '2010-01-09', '1'), ('10902', '117.136.30.4', '中国', '移动', '0', '2010-01-09', '1'), ('10903', '117.136.30.18', '中国', '移动', '0', '2010-01-09', '1'), ('10904', '117.136.23.141', '中国', '移动', '0', '2010-01-09', '1'), ('10905', '117.136.20.9', '中国', '移动', '0', '2010-01-09', '1'), ('10906', '117.136.21.6', '中国', '移动', '0', '2010-01-09', '1'), ('10907', '117.136.21.153', '中国', '移动', '0', '2010-01-09', '1'), ('10908', '117.136.5.88', '辽宁省本溪市', '移动', '0', '2010-01-10', '1'), ('10909', '117.136.18.18', '中国', '移动', '0', '2010-01-10', '1'), ('10910', '117.136.21.184', '中国', '移动', '0', '2010-01-10', '1'), ('10911', '117.136.6.17', '辽宁省本溪市', '移动', '0', '2010-01-10', '1'), ('10912', '117.136.31.176', '中国', '移动', '0', '2010-01-10', '1'), ('10913', '117.136.30.40', '中国', '移动', '0', '2010-01-10', '1'), ('10914', '117.136.31.27', '中国', '移动', '0', '2010-01-10', '1'), ('10915', '117.136.20.73', '中国', '移动', '0', '2010-01-10', '1'), ('10916', '117.136.17.28', '中国', '移动', '0', '2010-01-10', '1'), ('10917', '117.136.0.24', '中国', '移动', '0', '2010-01-10', '1'), ('10918', '117.136.8.135', '山东省潍坊市', '移动', '0', '2010-01-10', '1'), ('10919', '117.136.11.82', '山东省潍坊市', '移动', '0', '2010-01-10', '1'), ('10920', '117.136.23.142', '中国', '移动', '0', '2010-01-10', '1'), ('10921', '117.136.15.98', '中国', '移动', '0', '2010-01-10', '1'), ('10922', '117.136.0.9', '中国', '移动', '0', '2010-01-10', '1'), ('10923', '117.136.8.151', '山东省潍坊市', '移动', '0', '2010-01-10', '1'), ('10924', '117.136.24.3', '中国', '移动', '0', '2010-01-10', '1'), ('10925', '117.136.14.18', '中国', '移动', '0', '2010-01-10', '1'), ('10926', '117.136.12.114', '中国', '移动', '0', '2010-01-10', '1'), ('10927', '117.136.11.21', '山东省潍坊市', '移动', '0', '2010-01-10', '1'), ('10928', '117.136.21.147', '中国', '移动', '0', '2010-01-10', '1'), ('10929', '117.136.8.156', '山东省潍坊市', '移动', '0', '2010-01-11', '1'), ('10930', '117.136.21.160', '中国', '移动', '0', '2010-01-11', '1'), ('10931', '117.136.20.89', '中国', '移动', '0', '2010-01-11', '1'), ('10932', '117.136.5.74', '辽宁省本溪市', '移动', '0', '2010-01-11', '1'), ('10933', '117.136.1.225', '中国', '移动', '0', '2010-01-11', '1'), ('10934', '117.136.23.144', '中国', '移动', '0', '2010-01-11', '1'), ('10935', '117.136.15.153', '中国', '移动', '0', '2010-01-11', '1'), ('10936', '117.136.4.15', '辽宁省本溪市', '移动', '0', '2010-01-11', '1'), ('10937', '117.136.21.197', '中国', '移动', '0', '2010-01-11', '1'), ('10938', '117.136.4.241', '辽宁省本溪市', '移动', '0', '2010-01-11', '1'), ('10939', '117.136.20.71', '中国', '移动', '0', '2010-01-12', '1'), ('10940', '117.136.24.77', '中国', '移动', '0', '2010-01-12', '1'), ('10941', '117.136.30.44', '中国', '移动', '0', '2010-01-12', '1'), ('10942', '117.136.21.178', '中国', '移动', '0', '2010-01-12', '1'), ('10943', '117.136.27.9', '中国', '移动', '0', '2010-01-12', '1'), ('10944', '117.136.15.107', '中国', '移动', '0', '2010-01-12', '1'), ('10945', '117.136.0.148', '中国', '移动', '0', '2010-01-12', '1'), ('10946', '211.137.63.99', '湖北省十堰市', '移动', '0', '2010-01-12', '1'), ('10947', '117.136.20.94', '中国', '移动', '0', '2010-01-12', '1'), ('10948', '211.137.63.143', '湖北省十堰市', '移动', '0', '2010-01-12', '1'), ('10949', '117.136.5.76', '辽宁省本溪市', '移动', '0', '2010-01-12', '1'), ('10950', '117.136.23.140', '中国', '移动', '0', '2010-01-12', '1'), ('10951', '117.136.9.187', '山东省潍坊市', '移动', '0', '2010-01-12', '1'), ('10952', '117.136.24.42', '中国', '移动', '0', '2010-01-12', '1'), ('10953', '211.137.63.74', '湖北省十堰市', '移动', '0', '2010-01-12', '1'), ('10954', '117.136.8.146', '山东省潍坊市', '移动', '0', '2010-01-13', '1'), ('10955', '117.136.15.101', '中国', '移动', '0', '2010-01-13', '1'), ('10956', '117.136.15.108', '中国', '移动', '0', '2010-01-13', '1'), ('10957', '117.136.24.110', '中国', '移动', '0', '2010-01-13', '1'), ('10958', '117.136.21.129', '中国', '移动', '0', '2010-01-13', '1'), ('10959', '117.136.6.4', '辽宁省本溪市', '移动', '0', '2010-01-13', '1'), ('10960', '117.136.30.78', '中国', '移动', '0', '2010-01-13', '1'), ('10961', '117.136.19.176', '中国', '移动', '0', '2010-01-13', '1'), ('10962', '117.136.30.23', '中国', '移动', '0', '2010-01-13', '1'), ('10963', '117.136.21.244', '中国', '移动', '0', '2010-01-13', '1'), ('10964', '211.137.63.98', '湖北省十堰市', '移动', '0', '2010-01-13', '1'), ('10965', '117.136.2.51', '中国', '移动', '0', '2010-01-14', '1'), ('10966', '117.136.15.244', '中国', '移动', '0', '2010-01-14', '1'), ('10967', '117.136.5.206', '辽宁省本溪市', '移动', '0', '2010-01-14', '1'), ('10968', '117.136.1.135', '中国', '移动', '0', '2010-01-15', '1'), ('10969', '117.136.19.34', '中国', '移动', '0', '2010-01-15', '1'), ('10970', '117.136.12.115', '中国', '移动', '0', '2010-01-15', '1'), ('10971', '211.137.63.70', '湖北省十堰市', '移动', '0', '2010-01-15', '1'), ('10972', '117.136.28.246', '中国', '移动', '0', '2010-01-15', '1'), ('10973', '117.136.21.139', '中国', '移动', '0', '2010-01-15', '1'), ('10974', '117.136.0.143', '中国', '移动', '0', '2010-01-15', '1'), ('10975', '117.136.31.164', '中国', '移动', '0', '2010-01-16', '1'), ('10976', '117.136.23.66', '中国', '移动', '0', '2010-01-16', '1'), ('10977', '117.136.23.72', '中国', '移动', '0', '2010-01-16', '1'), ('10978', '117.136.6.32', '辽宁省本溪市', '移动', '0', '2010-01-16', '1'), ('10979', '117.136.23.78', '中国', '移动', '0', '2010-01-16', '1'), ('10980', '117.136.0.137', '中国', '移动', '0', '2010-01-17', '1'), ('10981', '117.136.23.121', '中国', '移动', '0', '2010-01-17', '1'), ('10982', '117.136.23.234', '中国', '移动', '0', '2010-01-17', '1'), ('10983', '117.136.15.21', '中国', '移动', '0', '2010-01-17', '1'), ('10984', '117.136.2.53', '中国', '移动', '0', '2010-01-17', '1'), ('10985', '117.136.20.74', '中国', '移动', '0', '2010-01-18', '1'), ('10986', '117.136.20.85', '中国', '移动', '0', '2010-01-18', '1'), ('10987', '117.136.20.67', '中国', '移动', '0', '2010-01-18', '1'), ('10988', '117.136.17.27', '中国', '移动', '0', '2010-01-18', '1'), ('10989', '117.136.23.97', '中国', '移动', '0', '2010-01-18', '1'), ('10990', '117.136.6.33', '辽宁省本溪市', '移动', '0', '2010-01-18', '1'), ('10991', '117.136.23.51', '中国', '移动', '0', '2010-01-18', '1'), ('10992', '117.136.23.227', '中国', '移动', '0', '2010-01-18', '1'), ('10993', '117.136.20.93', '中国', '移动', '0', '2010-01-19', '1'), ('10994', '117.136.23.70', '中国', '移动', '0', '2010-01-19', '1'), ('10995', '117.136.21.199', '中国', '移动', '0', '2010-01-19', '1'), ('10996', '117.136.23.86', '中国', '移动', '0', '2010-01-19', '1'), ('10997', '117.136.21.145', '中国', '移动', '0', '2010-01-19', '1'), ('10998', '117.136.23.123', '中国', '移动', '0', '2010-01-19', '1'), ('10999', '117.136.23.99', '中国', '移动', '0', '2010-01-19', '1'), ('11000', '117.136.31.177', '中国', '移动', '0', '2010-01-19', '1'), ('11001', '117.136.23.19', '中国', '移动', '0', '2010-01-19', '1'), ('11002', '117.136.23.31', '中国', '移动', '0', '2010-01-20', '1'), ('11003', '117.136.23.131', '中国', '移动', '0', '2010-01-20', '1'), ('11004', '117.136.21.229', '中国', '移动', '0', '2010-01-20', '1'), ('11005', '117.136.21.201', '中国', '移动', '0', '2010-01-20', '1'), ('11006', '117.136.21.210', '中国', '移动', '0', '2010-01-20', '1'), ('11007', '117.136.23.62', '中国', '移动', '0', '2010-01-21', '1'), ('11008', '117.136.28.245', '中国', '移动', '0', '2010-01-21', '1'), ('11009', '117.136.23.91', '中国', '移动', '0', '2010-01-21', '1'), ('11010', '117.136.16.69', '中国', '移动', '0', '2010-01-21', '1'), ('11011', '117.136.12.245', '中国', '移动', '0', '2010-01-21', '1'), ('11012', '117.136.23.83', '中国', '移动', '0', '2010-01-21', '1'), ('11013', '117.136.21.214', '中国', '移动', '0', '2010-01-21', '1'), ('11014', '117.136.23.101', '中国', '移动', '0', '2010-01-22', '1'), ('11015', '117.136.30.38', '中国', '移动', '0', '2010-01-22', '1'), ('11016', '117.136.23.92', '中国', '移动', '0', '2010-01-22', '1'), ('11017', '117.136.27.5', '中国', '移动', '0', '2010-01-22', '1'), ('11018', '117.136.23.85', '中国', '移动', '0', '2010-01-22', '1'), ('11019', '117.136.21.38', '中国', '移动', '0', '2010-01-22', '1'), ('11020', '117.136.23.71', '中国', '移动', '0', '2010-01-22', '1'), ('11021', '117.136.0.2', '中国', '移动', '0', '2010-01-22', '1'), ('11022', '117.136.0.41', '中国', '移动', '0', '2010-01-22', '1'), ('11023', '117.136.23.46', '中国', '移动', '0', '2010-01-22', '1'), ('11024', '117.136.7.69', '辽宁省本溪市', '移动', '0', '2010-01-23', '1'), ('11025', '117.136.23.77', '中国', '移动', '0', '2010-01-23', '1'), ('11026', '117.136.11.168', '山东省潍坊市', '移动', '0', '2010-01-23', '1'), ('11027', '117.136.23.28', '中国', '移动', '0', '2010-01-23', '1'), ('11028', '117.136.23.81', '中国', '移动', '0', '2010-01-23', '1'), ('11029', '117.136.6.139', '辽宁省本溪市', '移动', '0', '2010-01-23', '1'), ('11030', '117.136.15.208', '中国', '移动', '0', '2010-01-23', '1'), ('11031', '117.136.30.10', '中国', '移动', '0', '2010-01-23', '1'), ('11032', '117.136.23.120', '中国', '移动', '0', '2010-01-23', '1'), ('11033', '117.136.30.26', '中国', '移动', '0', '2010-01-23', '1'), ('11034', '117.136.23.26', '中国', '移动', '0', '2010-01-24', '1'), ('11035', '117.136.21.37', '中国', '移动', '0', '2010-01-24', '1'), ('11036', '117.136.21.149', '中国', '移动', '0', '2010-01-24', '1'), ('11037', '117.136.23.73', '中国', '移动', '0', '2010-01-24', '1'), ('11038', '117.136.23.112', '中国', '移动', '0', '2010-01-24', '1'), ('11039', '117.136.23.82', '中国', '移动', '0', '2010-01-24', '1'), ('11040', '117.136.21.185', '中国', '移动', '0', '2010-01-24', '1'), ('11041', '117.136.21.212', '中国', '移动', '0', '2010-01-24', '1'), ('11042', '117.136.23.10', '中国', '移动', '0', '2010-01-24', '1'), ('11043', '117.136.21.190', '中国', '移动', '0', '2010-01-24', '1'), ('11044', '117.136.23.76', '中国', '移动', '0', '2010-01-25', '1'), ('11045', '117.136.20.77', '中国', '移动', '0', '2010-01-25', '1'), ('11046', '211.139.92.225', '甘肃省兰州市', '移动', '0', '2010-01-25', '1'), ('11047', '117.136.21.237', '中国', '移动', '0', '2010-01-25', '1'), ('11048', '117.136.21.44', '中国', '移动', '0', '2010-01-25', '1'), ('11049', '117.136.30.34', '中国', '移动', '0', '2010-01-25', '1'), ('11050', '221.181.2.188', '江苏省南京市', '移动', '0', '2010-01-25', '1'), ('11051', '117.136.23.22', '中国', '移动', '0', '2010-01-25', '1'), ('11052', '117.136.21.235', '中国', '移动', '0', '2010-01-25', '1'), ('11053', '117.136.11.48', '山东省潍坊市', '移动', '0', '2010-01-25', '1'), ('11054', '117.136.11.49', '山东省潍坊市', '移动', '0', '2010-01-25', '1'), ('11055', '117.136.21.59', '中国', '移动', '0', '2010-01-25', '1'), ('11056', '117.136.23.57', '中国', '移动', '0', '2010-01-26', '1'), ('11057', '211.139.92.239', '甘肃省兰州市', '移动', '0', '2010-01-26', '1'), ('11058', '117.136.23.114', '中国', '移动', '0', '2010-01-26', '1'), ('11059', '117.136.23.98', '中国', '移动', '0', '2010-01-26', '1'), ('11060', '117.136.23.1', '中国', '移动', '0', '2010-01-26', '1'), ('11061', '117.136.30.48', '中国', '移动', '0', '2010-01-27', '1'), ('11062', '117.136.23.117', '中国', '移动', '0', '2010-01-27', '1'), ('11063', '117.136.15.194', '中国', '移动', '0', '2010-01-27', '1'), ('11064', '117.136.15.239', '中国', '移动', '0', '2010-01-27', '1'), ('11065', '117.136.23.108', '中国', '移动', '0', '2010-01-27', '1'), ('11066', '117.136.23.5', '中国', '移动', '0', '2010-01-27', '1'), ('11067', '117.136.11.53', '山东省潍坊市', '移动', '0', '2010-01-27', '1'), ('11068', '117.136.27.13', '中国', '移动', '0', '2010-01-28', '1'), ('11069', '117.136.23.2', '中国', '移动', '0', '2010-01-28', '1'), ('11070', '117.136.27.11', '中国', '移动', '0', '2010-01-28', '1'), ('11071', '117.136.0.7', '中国', '移动', '0', '2010-01-28', '1'), ('11072', '117.136.15.63', '中国', '移动', '0', '2010-01-28', '1'), ('11073', '117.136.12.143', '中国', '移动', '0', '2010-01-28', '1'), ('11074', '117.136.21.186', '中国', '移动', '0', '2010-01-28', '1'), ('11075', '117.136.24.103', '中国', '移动', '0', '2010-01-28', '1'), ('11076', '117.136.23.17', '中国', '移动', '0', '2010-01-29', '1'), ('11077', '117.136.21.191', '中国', '移动', '0', '2010-01-29', '1'), ('11078', '117.136.23.245', '中国', '移动', '0', '2010-01-29', '1'), ('11079', '117.136.23.59', '中国', '移动', '0', '2010-01-29', '1'), ('11080', '117.136.0.13', '中国', '移动', '0', '2010-01-29', '1'), ('11081', '117.136.16.70', '中国', '移动', '0', '2010-01-29', '1'), ('11082', '117.136.23.74', '中国', '移动', '0', '2010-01-29', '1'), ('11083', '117.136.21.187', '中国', '移动', '0', '2010-01-30', '1'), ('11084', '117.136.31.166', '中国', '移动', '0', '2010-01-30', '1'), ('11085', '117.136.23.110', '中国', '移动', '0', '2010-01-30', '1'), ('11086', '117.136.30.56', '中国', '移动', '0', '2010-01-30', '1'), ('11087', '117.136.23.94', '中国', '移动', '0', '2010-01-30', '1'), ('11088', '117.136.21.219', '中国', '移动', '0', '2010-01-31', '1'), ('11089', '117.136.11.50', '山东省潍坊市', '移动', '0', '2010-01-31', '1'), ('11090', '117.136.23.55', '中国', '移动', '0', '2010-01-31', '1'), ('11091', '117.136.20.72', '中国', '移动', '0', '2010-01-31', '1'), ('11092', '117.136.20.81', '中国', '移动', '0', '2010-01-31', '1'), ('11093', '117.136.21.218', '中国', '移动', '0', '2010-02-01', '1'), ('11094', '117.136.20.82', '中国', '移动', '0', '2010-02-01', '1'), ('11095', '117.136.1.155', '中国', '移动', '0', '2010-02-01', '1'), ('11096', '117.136.23.88', '中国', '移动', '0', '2010-02-01', '1'), ('11097', '117.136.27.7', '中国', '移动', '0', '2010-02-01', '1'), ('11098', '117.136.15.84', '中国', '移动', '0', '2010-02-01', '1'), ('11099', '117.136.31.181', '中国', '移动', '0', '2010-02-01', '1'), ('11100', '117.136.23.111', '中国', '移动', '0', '2010-02-02', '1'), ('11101', '117.136.30.7', '中国', '移动', '0', '2010-02-02', '1'), ('11102', '117.136.23.237', '中国', '移动', '0', '2010-02-03', '1'), ('11103', '117.136.21.231', '中国', '移动', '0', '2010-02-03', '1'), ('11104', '117.136.21.206', '中国', '移动', '0', '2010-02-03', '1'), ('11105', '117.136.31.28', '中国', '移动', '0', '2010-02-03', '1'), ('11106', '117.136.0.131', '中国', '移动', '0', '2010-02-03', '1'), ('11107', '117.136.0.22', '中国', '移动', '0', '2010-02-03', '1'), ('11108', '117.136.21.41', '中国', '移动', '0', '2010-02-03', '1'), ('11109', '117.136.5.193', '辽宁省本溪市', '移动', '0', '2010-02-04', '1'), ('11110', '117.136.23.188', '中国', '移动', '0', '2010-02-04', '1'), ('11111', '117.136.30.31', '中国', '移动', '0', '2010-02-04', '1'), ('11112', '117.136.0.10', '中国', '移动', '0', '2010-02-04', '1'), ('11113', '117.136.11.31', '山东省潍坊市', '移动', '0', '2010-02-04', '1'), ('11114', '117.136.11.55', '山东省潍坊市', '移动', '0', '2010-02-04', '1'), ('11115', '117.136.21.75', '中国', '移动', '0', '2010-02-04', '1'), ('11116', '117.136.0.53', '中国', '移动', '0', '2010-02-05', '1'), ('11117', '117.136.19.173', '中国', '移动', '0', '2010-02-05', '1'), ('11118', '117.136.31.183', '中国', '移动', '0', '2010-02-05', '1'), ('11119', '117.136.7.68', '辽宁省本溪市', '移动', '0', '2010-02-06', '1'), ('11120', '117.136.21.220', '中国', '移动', '0', '2010-02-06', '1'), ('11121', '221.182.2.166', '四川省成都市', '移动', '0', '2010-02-06', '1'), ('11122', '117.136.21.169', '中国', '移动', '0', '2010-02-06', '1'), ('11123', '117.136.21.222', '中国', '移动', '0', '2010-02-06', '1'), ('11124', '117.136.21.189', '中国', '移动', '0', '2010-02-06', '1'), ('11125', '117.136.21.176', '中国', '移动', '0', '2010-02-06', '1'), ('11126', '117.136.23.25', '中国', '移动', '0', '2010-02-06', '1'), ('11127', '117.136.21.133', '中国', '移动', '0', '2010-02-06', '1'), ('11128', '117.136.23.93', '中国', '移动', '0', '2010-02-06', '1'), ('11129', '117.136.23.119', '中国', '移动', '0', '2010-02-07', '1'), ('11130', '117.136.20.90', '中国', '移动', '0', '2010-02-07', '1'), ('11131', '117.136.27.1', '中国', '移动', '0', '2010-02-07', '1'), ('11132', '117.136.21.143', '中国', '移动', '0', '2010-02-07', '1'), ('11133', '117.136.17.30', '中国', '移动', '0', '2010-02-07', '1'), ('11134', '117.136.21.78', '中国', '移动', '0', '2010-02-07', '1'), ('11135', '117.136.0.5', '中国', '移动', '0', '2010-02-07', '1'), ('11136', '117.136.11.174', '山东省潍坊市', '移动', '0', '2010-02-07', '1'), ('11137', '117.136.20.70', '中国', '移动', '0', '2010-02-07', '1'), ('11138', '117.136.12.130', '中国', '移动', '0', '2010-02-08', '1'), ('11139', '117.136.11.54', '山东省潍坊市', '移动', '0', '2010-02-08', '1'), ('11140', '117.136.21.79', '中国', '移动', '0', '2010-02-08', '1'), ('11141', '117.136.21.183', '中国', '移动', '0', '2010-02-08', '1'), ('11142', '117.136.15.81', '中国', '移动', '0', '2010-02-08', '1'), ('11143', '117.136.27.6', '中国', '移动', '0', '2010-02-08', '1'), ('11144', '117.136.12.129', '中国', '移动', '0', '2010-02-08', '1'), ('11145', '117.136.11.25', '山东省潍坊市', '移动', '0', '2010-02-08', '1'), ('11146', '117.136.20.76', '中国', '移动', '0', '2010-02-08', '1'), ('11147', '117.136.20.14', '中国', '移动', '0', '2010-02-09', '1'), ('11148', '117.136.11.62', '山东省潍坊市', '移动', '0', '2010-02-09', '1'), ('11149', '117.136.23.250', '中国', '移动', '0', '2010-02-09', '1'), ('11150', '117.136.20.75', '中国', '移动', '0', '2010-02-09', '1'), ('11151', '117.136.20.68', '中国', '移动', '0', '2010-02-09', '1'), ('11152', '117.136.24.48', '中国', '移动', '0', '2010-02-09', '1'), ('11153', '117.136.23.41', '中国', '移动', '0', '2010-02-09', '1'), ('11154', '117.136.21.132', '中国', '移动', '0', '2010-02-09', '1'), ('11155', '117.136.30.22', '中国', '移动', '0', '2010-02-09', '1'), ('11156', '117.136.30.3', '中国', '移动', '0', '2010-02-09', '1'), ('11157', '117.136.12.211', '中国', '移动', '0', '2010-02-09', '1'), ('11158', '117.136.23.33', '中国', '移动', '0', '2010-02-09', '1'), ('11159', '117.136.16.77', '中国', '移动', '0', '2010-02-09', '1'), ('11160', '117.136.5.10', '辽宁省本溪市', '移动', '0', '2010-02-09', '1'), ('11161', '117.136.23.226', '中国', '移动', '0', '2010-02-09', '1'), ('11162', '117.136.30.86', '中国', '移动', '0', '2010-02-09', '1'), ('11163', '117.136.11.29', '山东省潍坊市', '移动', '0', '2010-02-09', '1'), ('11164', '117.136.30.36', '中国', '移动', '0', '2010-02-09', '1'), ('11165', '117.136.23.134', '中国', '移动', '0', '2010-02-09', '1'), ('11166', '117.136.23.151', '中国', '移动', '0', '2010-02-10', '1'), ('11167', '117.136.11.51', '山东省潍坊市', '移动', '0', '2010-02-10', '1'), ('11168', '117.136.23.209', '中国', '移动', '0', '2010-02-10', '1'), ('11169', '117.136.31.180', '中国', '移动', '0', '2010-02-10', '1'), ('11170', '117.136.14.37', '中国', '移动', '0', '2010-02-10', '1'), ('11171', '117.136.15.188', '中国', '移动', '0', '2010-02-10', '1'), ('11172', '117.136.24.99', '中国', '移动', '0', '2010-02-10', '1'), ('11173', '117.136.9.66', '山东省潍坊市', '移动', '0', '2010-02-10', '1'), ('11174', '117.136.11.61', '山东省潍坊市', '移动', '0', '2010-02-11', '1'), ('11175', '221.182.2.165', '四川省成都市', '移动', '0', '2010-02-11', '1'), ('11176', '117.136.0.133', '中国', '移动', '0', '2010-02-11', '1'), ('11177', '117.136.23.18', '中国', '移动', '0', '2010-02-11', '1'), ('11178', '117.136.27.2', '中国', '移动', '0', '2010-02-11', '1'), ('11179', '117.136.27.14', '中国', '移动', '0', '2010-02-12', '1'), ('11180', '117.136.30.90', '中国', '移动', '0', '2010-02-12', '1'), ('11181', '117.136.11.16', '山东省潍坊市', '移动', '0', '2010-02-12', '1'), ('11182', '117.136.24.1', '中国', '移动', '0', '2010-02-12', '1'), ('11183', '117.136.15.128', '中国', '移动', '0', '2010-02-12', '1'), ('11184', '117.136.27.10', '中国', '移动', '0', '2010-02-12', '1'), ('11185', '117.136.27.4', '中国', '移动', '0', '2010-02-13', '1'), ('11186', '211.139.92.237', '甘肃省兰州市', '移动', '0', '2010-02-13', '1'), ('11187', '211.139.92.233', '甘肃省兰州市', '移动', '0', '2010-02-13', '1'), ('11188', '211.139.92.238', '甘肃省兰州市', '移动', '0', '2010-02-13', '1'), ('11189', '117.136.27.12', '中国', '移动', '0', '2010-02-13', '1'), ('11190', '117.136.24.106', '中国', '移动', '0', '2010-02-13', '1'), ('11191', '117.136.5.1', '辽宁省本溪市', '移动', '0', '2010-02-13', '1'), ('11192', '117.136.9.49', '山东省潍坊市', '移动', '0', '2010-02-13', '1'), ('11193', '117.136.23.122', '中国', '移动', '0', '2010-02-13', '1'), ('11194', '117.136.5.131', '辽宁省本溪市', '移动', '0', '2010-02-13', '1'), ('11195', '117.136.20.84', '中国', '移动', '0', '2010-02-13', '1'), ('11196', '117.136.12.231', '中国', '移动', '0', '2010-02-14', '1'), ('11197', '117.136.23.215', '中国', '移动', '0', '2010-02-14', '1'), ('11198', '117.136.20.91', '中国', '移动', '0', '2010-02-14', '1'), ('11199', '117.136.11.52', '山东省潍坊市', '移动', '0', '2010-02-14', '1'), ('11200', '117.136.20.83', '中国', '移动', '0', '2010-02-14', '1'), ('11201', '117.136.23.115', '中国', '移动', '0', '2010-02-15', '1'), ('11202', '117.136.16.68', '中国', '移动', '0', '2010-02-15', '1'), ('11203', '117.136.31.167', '中国', '移动', '0', '2010-02-16', '1'), ('11204', '117.136.24.22', '中国', '移动', '0', '2010-02-16', '1'), ('11205', '117.136.24.45', '中国', '移动', '0', '2010-02-16', '1'), ('11206', '117.136.23.27', '中国', '移动', '0', '2010-02-16', '1'), ('11207', '117.136.23.34', '中国', '移动', '0', '2010-02-16', '1'), ('11208', '117.136.23.124', '中国', '移动', '0', '2010-02-17', '1'), ('11209', '117.136.24.141', '中国', '移动', '0', '2010-02-17', '1'), ('11210', '117.136.5.136', '辽宁省本溪市', '移动', '0', '2010-02-17', '1'), ('11211', '117.136.31.182', '中国', '移动', '0', '2010-02-17', '1'), ('11212', '117.136.24.7', '中国', '移动', '0', '2010-02-18', '1'), ('11213', '117.136.5.164', '辽宁省本溪市', '移动', '0', '2010-02-18', '1'), ('11214', '117.136.21.155', '中国', '移动', '0', '2010-02-19', '1'), ('11215', '117.136.8.144', '山东省潍坊市', '移动', '0', '2010-02-19', '1'), ('11216', '117.136.20.92', '中国', '移动', '0', '2010-02-19', '1'), ('11217', '117.136.8.142', '山东省潍坊市', '移动', '0', '2010-02-20', '1'), ('11218', '117.136.23.96', '中国', '移动', '0', '2010-02-20', '1'), ('11219', '117.136.5.165', '辽宁省本溪市', '移动', '0', '2010-02-20', '1'), ('11220', '117.136.23.193', '中国', '移动', '0', '2010-02-21', '1'), ('11221', '117.136.28.243', '中国', '移动', '0', '2010-02-21', '1'), ('11222', '117.136.6.1', '辽宁省本溪市', '移动', '0', '2010-02-21', '1'), ('11223', '117.136.23.157', '中国', '移动', '0', '2010-02-21', '1'), ('11224', '117.136.20.87', '中国', '移动', '0', '2010-02-21', '1'), ('11225', '117.136.24.62', '中国', '移动', '0', '2010-02-21', '1'), ('11226', '117.136.20.88', '中国', '移动', '0', '2010-02-21', '1'), ('11227', '117.136.28.242', '中国', '移动', '0', '2010-02-21', '1'), ('11228', '117.136.23.87', '中国', '移动', '0', '2010-02-21', '1'), ('11229', '117.136.12.99', '中国', '移动', '0', '2010-02-21', '1'), ('11230', '117.136.5.212', '辽宁省本溪市', '移动', '0', '2010-02-21', '1'), ('11231', '117.136.30.16', '中国', '移动', '0', '2010-02-22', '1'), ('11232', '117.136.1.237', '中国', '移动', '0', '2010-02-22', '1'), ('11233', '117.136.23.220', '中国', '移动', '0', '2010-02-22', '1'), ('11234', '117.136.20.86', '中国', '移动', '0', '2010-02-23', '1'), ('11235', '117.136.23.173', '中国', '移动', '0', '2010-02-24', '1'), ('11236', '117.136.1.137', '中国', '移动', '0', '2010-02-24', '1'), ('11237', '117.136.17.25', '中国', '移动', '0', '2010-02-24', '1'), ('11238', '117.136.7.65', '辽宁省本溪市', '移动', '0', '2010-02-24', '1'), ('11239', '117.136.24.19', '中国', '移动', '0', '2010-02-24', '1'), ('11240', '117.136.23.221', '中国', '移动', '0', '2010-02-24', '1'), ('11241', '117.136.15.242', '中国', '移动', '0', '2010-02-24', '1'), ('11242', '117.136.20.65', '中国', '移动', '0', '2010-02-25', '1'), ('11243', '117.136.23.147', '中国', '移动', '0', '2010-02-25', '1'), ('11244', '117.136.12.236', '中国', '移动', '0', '2010-02-25', '1'), ('11245', '117.136.21.131', '中国', '移动', '0', '2010-02-25', '1'), ('11246', '117.136.5.205', '辽宁省本溪市', '移动', '0', '2010-02-25', '1'), ('11247', '117.136.0.135', '中国', '移动', '0', '2010-02-25', '1'), ('11248', '117.136.23.194', '中国', '移动', '0', '2010-02-25', '1'), ('11249', '117.136.30.2', '中国', '移动', '0', '2010-02-25', '1'), ('11250', '117.136.5.162', '辽宁省本溪市', '移动', '0', '2010-02-26', '1'), ('11251', '117.136.23.21', '中国', '移动', '0', '2010-02-26', '1'), ('11252', '211.139.92.232', '甘肃省兰州市', '移动', '0', '2010-02-26', '1'), ('11253', '211.139.92.226', '甘肃省兰州市', '移动', '0', '2010-02-27', '1'), ('11254', '211.139.92.230', '甘肃省兰州市', '移动', '0', '2010-02-27', '1'), ('11255', '211.139.92.228', '甘肃省兰州市', '移动', '0', '2010-02-27', '1'), ('11256', '211.139.92.229', '甘肃省兰州市', '移动', '0', '2010-02-27', '1'), ('11257', '117.136.23.183', '中国', '移动', '0', '2010-02-27', '1'), ('11258', '117.136.5.129', '辽宁省本溪市', '移动', '0', '2010-02-27', '1'), ('11259', '117.136.23.116', '中国', '移动', '0', '2010-02-27', '1'), ('11260', '117.136.23.160', '中国', '移动', '0', '2010-02-27', '1'), ('11261', '117.136.1.235', '中国', '移动', '0', '2010-02-28', '1'), ('11262', '117.136.1.231', '中国', '移动', '0', '2010-02-28', '1'), ('11263', '117.136.23.30', '中国', '移动', '0', '2010-02-28', '1'), ('11264', '221.130.13.89', '江苏省南京市', '移动', '0', '2010-03-01', '1'), ('11265', '117.136.21.195', '中国', '移动', '0', '2010-03-01', '1'), ('11266', '117.136.23.9', '中国', '移动', '0', '2010-03-02', '1'), ('11267', '117.136.16.76', '中国', '移动', '0', '2010-03-02', '1'), ('11268', '117.136.23.217', '中国', '移动', '0', '2010-03-02', '1'), ('11269', '211.139.92.224', '甘肃省兰州市', '移动', '0', '2010-03-02', '1'), ('11270', '117.136.5.140', '辽宁省本溪市', '移动', '0', '2010-03-02', '1'), ('11271', '117.136.23.100', '中国', '移动', '0', '2010-03-02', '1'), ('11272', '117.136.23.23', '中国', '移动', '0', '2010-03-03', '1'), ('11273', '117.136.16.72', '中国', '移动', '0', '2010-03-03', '1'), ('11274', '117.136.5.139', '辽宁省本溪市', '移动', '0', '2010-03-03', '1'), ('11275', '117.136.23.222', '中国', '移动', '0', '2010-03-03', '1'), ('11276', '117.136.11.59', '山东省潍坊市', '移动', '0', '2010-03-03', '1'), ('11277', '117.136.0.46', '中国', '移动', '0', '2010-03-03', '1'), ('11278', '117.136.24.102', '中国', '移动', '0', '2010-03-03', '1'), ('11279', '117.136.23.118', '中国', '移动', '0', '2010-03-03', '1'), ('11280', '117.136.23.6', '中国', '移动', '0', '2010-03-03', '1'), ('11281', '117.136.21.240', '中国', '移动', '0', '2010-03-03', '1'), ('11282', '117.136.23.12', '中国', '移动', '0', '2010-03-03', '1'), ('11283', '117.136.0.45', '中国', '移动', '0', '2010-03-03', '1'), ('11284', '117.136.21.182', '中国', '移动', '0', '2010-03-03', '1'), ('11285', '117.136.11.58', '山东省潍坊市', '移动', '0', '2010-03-03', '1'), ('11286', '117.136.21.53', '中国', '移动', '0', '2010-03-03', '1'), ('11287', '117.136.0.55', '中国', '移动', '0', '2010-03-03', '1'), ('11288', '117.136.12.221', '中国', '移动', '0', '2010-03-03', '1'), ('11289', '117.136.24.83', '中国', '移动', '0', '2010-03-03', '1'), ('11290', '117.136.24.9', '中国', '移动', '0', '2010-03-03', '1'), ('11291', '117.136.12.226', '中国', '移动', '0', '2010-03-03', '1'), ('11292', '117.136.0.25', '中国', '移动', '0', '2010-03-03', '1'), ('11293', '117.136.21.4', '中国', '移动', '0', '2010-03-03', '1'), ('11294', '117.136.23.45', '中国', '移动', '0', '2010-03-03', '1'), ('11295', '117.136.16.74', '中国', '移动', '0', '2010-03-03', '1'), ('11296', '117.136.27.8', '中国', '移动', '0', '2010-03-03', '1'), ('11297', '221.182.2.170', '四川省成都市', '移动', '0', '2010-03-03', '1'), ('11298', '117.136.23.95', '中国', '移动', '0', '2010-03-03', '1'), ('11299', '117.136.5.132', '辽宁省本溪市', '移动', '0', '2010-03-03', '1'), ('11300', '117.136.21.248', '中国', '移动', '0', '2010-03-03', '1'), ('11301', '117.136.15.82', '中国', '移动', '0', '2010-03-03', '1'), ('11302', '117.136.21.193', '中国', '移动', '0', '2010-03-03', '1'), ('11303', '117.136.3.35', '中国', '移动', '0', '2010-03-03', '1'), ('11304', '117.136.3.38', '中国', '移动', '0', '2010-03-03', '1'), ('11305', '117.136.11.60', '山东省潍坊市', '移动', '0', '2010-03-03', '1'), ('11306', '117.136.6.11', '辽宁省本溪市', '移动', '0', '2010-03-03', '1'), ('11307', '117.136.23.68', '中国', '移动', '0', '2010-03-03', '1'), ('11308', '117.136.23.67', '中国', '移动', '0', '2010-03-03', '1'), ('11309', '117.136.15.83', '中国', '移动', '0', '2010-03-03', '1'), ('11310', '117.136.15.192', '中国', '移动', '0', '2010-03-03', '1'), ('11311', '117.136.24.86', '中国', '移动', '0', '2010-03-03', '1'), ('11312', '117.136.21.163', '中国', '移动', '0', '2010-03-03', '1');
INSERT INTO `ig_gateway` VALUES ('11313', '221.182.2.169', '四川省成都市', '移动', '0', '2010-03-03', '1'), ('11314', '117.136.5.134', '辽宁省本溪市', '移动', '0', '2010-03-03', '1'), ('11315', '117.136.0.37', '中国', '移动', '0', '2010-03-03', '1'), ('11316', '117.136.24.120', '中国', '移动', '0', '2010-03-03', '1'), ('11317', '117.136.5.173', '辽宁省本溪市', '移动', '0', '2010-03-03', '1'), ('11318', '117.136.24.39', '中国', '移动', '0', '2010-03-03', '1'), ('11319', '117.136.5.171', '辽宁省本溪市', '移动', '0', '2010-03-04', '1'), ('11320', '117.136.24.113', '中国', '移动', '0', '2010-03-04', '1'), ('11321', '117.136.23.39', '中国', '移动', '0', '2010-03-04', '1'), ('11322', '117.136.23.251', '中国', '移动', '0', '2010-03-04', '1'), ('11323', '117.136.30.73', '中国', '移动', '0', '2010-03-04', '1'), ('11324', '117.136.23.189', '中国', '移动', '0', '2010-03-04', '1'), ('11325', '117.136.11.66', '山东省潍坊市', '移动', '0', '2010-03-04', '1'), ('11326', '117.136.9.67', '山东省潍坊市', '移动', '0', '2010-03-04', '1'), ('11327', '117.136.9.42', '山东省潍坊市', '移动', '0', '2010-03-04', '1'), ('11328', '117.136.0.20', '中国', '移动', '0', '2010-03-04', '1'), ('11329', '117.136.15.168', '中国', '移动', '0', '2010-03-04', '1'), ('11330', '117.136.7.67', '辽宁省本溪市', '移动', '0', '2010-03-04', '1'), ('11331', '117.136.23.109', '中国', '移动', '0', '2010-03-04', '1'), ('11332', '117.136.21.130', '中国', '移动', '0', '2010-03-04', '1'), ('11333', '117.136.30.55', '中国', '移动', '0', '2010-03-04', '1'), ('11334', '117.136.23.168', '中国', '移动', '0', '2010-03-04', '1'), ('11335', '117.136.23.104', '中国', '移动', '0', '2010-03-04', '1'), ('11336', '221.130.13.34', '江苏省南京市', '移动', '0', '2010-03-04', '1'), ('11337', '117.136.24.10', '中国', '移动', '0', '2010-03-04', '1'), ('11338', '117.136.5.213', '辽宁省本溪市', '移动', '0', '2010-03-04', '1'), ('11339', '117.136.7.66', '辽宁省本溪市', '移动', '0', '2010-03-04', '1'), ('11340', '117.136.1.139', '中国', '移动', '0', '2010-03-04', '1'), ('11341', '117.136.30.66', '中国', '移动', '0', '2010-03-04', '1'), ('11342', '117.136.5.174', '辽宁省本溪市', '移动', '0', '2010-03-04', '1'), ('11343', '117.136.16.75', '中国', '移动', '0', '2010-03-04', '1'), ('11344', '117.136.23.14', '中国', '移动', '0', '2010-03-04', '1'), ('11345', '117.136.21.251', '中国', '移动', '0', '2010-03-07', '1'), ('11346', '117.136.23.75', '中国', '移动', '0', '2010-03-07', '1'), ('11347', '117.136.23.152', '中国', '移动', '0', '2010-03-07', '1'), ('11348', '117.136.23.63', '中国', '移动', '0', '2010-03-07', '1'), ('11349', '117.136.21.58', '中国', '移动', '0', '2010-03-07', '1'), ('11350', '117.136.23.232', '中国', '移动', '0', '2010-03-07', '1'), ('11351', '117.136.23.84', '中国', '移动', '0', '2010-03-07', '1'), ('11352', '117.136.23.223', '中国', '移动', '0', '2010-03-07', '1'), ('11353', '117.136.23.252', '中国', '移动', '0', '2010-03-07', '1'), ('11354', '117.136.21.150', '中国', '移动', '0', '2010-03-07', '1'), ('11355', '117.136.23.80', '中国', '移动', '0', '2010-03-07', '1'), ('11356', '117.136.0.36', '中国', '移动', '0', '2010-03-07', '1'), ('11357', '117.136.30.79', '中国', '移动', '0', '2010-03-07', '1'), ('11358', '117.136.1.234', '中国', '移动', '0', '2010-03-07', '1'), ('11359', '117.136.24.60', '中国', '移动', '0', '2010-03-07', '1'), ('11360', '117.136.30.89', '中国', '移动', '0', '2010-03-07', '1'), ('11361', '117.136.1.238', '中国', '移动', '0', '2010-03-07', '1'), ('11362', '117.136.23.148', '中国', '移动', '0', '2010-03-07', '1'), ('11363', '117.136.0.130', '中国', '移动', '0', '2010-03-07', '1'), ('11364', '117.136.23.50', '中国', '移动', '0', '2010-03-07', '1'), ('11365', '117.136.12.239', '中国', '移动', '0', '2010-03-07', '1'), ('11366', '117.136.23.32', '中国', '移动', '0', '2010-03-07', '1'), ('11367', '117.136.24.5', '中国', '移动', '0', '2010-03-07', '1'), ('11368', '117.136.31.185', '中国', '移动', '0', '2010-03-07', '1'), ('11369', '117.136.5.133', '辽宁省本溪市', '移动', '0', '2010-03-07', '1'), ('11370', '117.136.23.197', '中国', '移动', '0', '2010-03-07', '1'), ('11371', '117.136.1.236', '中国', '移动', '0', '2010-03-07', '1'), ('11372', '117.136.23.150', '中国', '移动', '0', '2010-03-07', '1'), ('11373', '117.136.1.229', '中国', '移动', '0', '2010-03-07', '1'), ('11374', '117.136.24.91', '中国', '移动', '0', '2010-03-07', '1'), ('11375', '117.136.0.54', '中国', '移动', '0', '2010-03-07', '1'), ('11376', '117.136.8.138', '山东省潍坊市', '移动', '0', '2010-03-07', '1'), ('11377', '117.136.23.202', '中国', '移动', '0', '2010-03-07', '1'), ('11378', '117.136.5.216', '辽宁省本溪市', '移动', '0', '2010-03-07', '1'), ('11379', '117.136.21.228', '中国', '移动', '0', '2010-03-07', '1'), ('11380', '117.136.7.70', '辽宁省本溪市', '移动', '0', '2010-03-07', '1'), ('11381', '117.136.24.125', '中国', '移动', '0', '2010-03-07', '1'), ('11382', '117.136.15.248', '中国', '移动', '0', '2010-03-07', '1'), ('11383', '117.136.23.105', '中国', '移动', '0', '2010-03-07', '1'), ('11384', '117.136.23.125', '中国', '移动', '0', '2010-03-07', '1'), ('11385', '117.136.24.8', '中国', '移动', '0', '2010-03-07', '1'), ('11386', '117.136.23.90', '中国', '移动', '0', '2010-03-07', '1'), ('11387', '117.136.20.78', '中国', '移动', '0', '2010-03-07', '1'), ('11388', '117.136.5.169', '辽宁省本溪市', '移动', '0', '2010-03-07', '1'), ('11389', '117.136.23.181', '中国', '移动', '0', '2010-03-07', '1'), ('11390', '117.136.0.140', '中国', '移动', '0', '2010-03-07', '1'), ('11391', '117.136.30.61', '中国', '移动', '0', '2010-03-07', '1'), ('11392', '117.136.24.54', '中国', '移动', '0', '2010-03-07', '1'), ('11393', '117.136.12.223', '中国', '移动', '0', '2010-03-07', '1'), ('11394', '117.136.5.5', '辽宁省本溪市', '移动', '0', '2010-03-07', '1'), ('11395', '117.136.24.72', '中国', '移动', '0', '2010-03-07', '1'), ('11396', '117.136.15.41', '中国', '移动', '0', '2010-03-07', '1'), ('11397', '117.136.1.131', '中国', '移动', '0', '2010-03-07', '1'), ('11398', '117.136.2.18', '中国', '移动', '0', '2010-03-07', '1'), ('11399', '117.136.23.43', '中国', '移动', '0', '2010-03-07', '1'), ('11400', '117.136.0.136', '中国', '移动', '0', '2010-03-07', '1'), ('11401', '117.136.12.230', '中国', '移动', '0', '2010-03-07', '1'), ('11402', '117.136.23.61', '中国', '移动', '0', '2010-03-07', '1'), ('11403', '117.136.23.233', '中国', '移动', '0', '2010-03-07', '1'), ('11404', '117.136.23.15', '中国', '移动', '0', '2010-03-07', '1'), ('11405', '117.136.24.2', '中国', '移动', '0', '2010-03-07', '1'), ('11406', '117.136.23.38', '中国', '移动', '0', '2010-03-07', '1'), ('11407', '117.136.21.170', '中国', '移动', '0', '2010-03-07', '1'), ('11408', '117.136.24.16', '中国', '移动', '0', '2010-03-07', '1'), ('11409', '117.136.21.19', '中国', '移动', '0', '2010-03-07', '1'), ('11410', '211.139.92.227', '甘肃省兰州市', '移动', '0', '2010-03-07', '1'), ('11411', '117.136.5.168', '辽宁省本溪市', '移动', '0', '2010-03-08', '1'), ('11412', '117.136.24.92', '中国', '移动', '0', '2010-03-08', '1'), ('11413', '117.136.23.102', '中国', '移动', '0', '2010-03-08', '1'), ('11414', '117.136.23.53', '中国', '移动', '0', '2010-03-08', '1'), ('11415', '117.136.23.137', '中国', '移动', '0', '2010-03-08', '1'), ('11416', '117.136.1.152', '中国', '移动', '0', '2010-03-08', '1'), ('11417', '117.136.23.236', '中国', '移动', '0', '2010-03-08', '1'), ('11418', '117.136.1.241', '中国', '移动', '0', '2010-03-08', '1'), ('11419', '117.136.21.171', '中国', '移动', '0', '2010-03-08', '1'), ('11420', '117.136.21.234', '中国', '移动', '0', '2010-03-08', '1'), ('11421', '117.136.24.81', '中国', '移动', '0', '2010-03-08', '1'), ('11422', '117.136.12.229', '中国', '移动', '0', '2010-03-08', '1'), ('11423', '117.136.23.20', '中国', '移动', '0', '2010-03-08', '1'), ('11424', '117.136.5.6', '辽宁省本溪市', '移动', '0', '2010-03-08', '1'), ('11425', '117.136.21.226', '中国', '移动', '0', '2010-03-08', '1'), ('11426', '117.136.21.249', '中国', '移动', '0', '2010-03-08', '1'), ('11427', '117.136.15.104', '中国', '移动', '0', '2010-03-09', '1'), ('11428', '117.136.21.213', '中国', '移动', '0', '2010-03-09', '1'), ('11429', '117.136.24.134', '中国', '移动', '0', '2010-03-09', '1'), ('11430', '117.136.15.246', '中国', '移动', '0', '2010-03-09', '1'), ('11431', '117.136.24.4', '中国', '移动', '0', '2010-03-09', '1'), ('11432', '117.136.12.57', '中国', '移动', '0', '2010-03-09', '1'), ('11433', '117.136.23.113', '中国', '移动', '0', '2010-03-09', '1'), ('11434', '117.136.24.57', '中国', '移动', '0', '2010-03-10', '1'), ('11435', '117.136.21.28', '中国', '移动', '0', '2010-03-10', '1'), ('11436', '117.136.24.111', '中国', '移动', '0', '2010-03-10', '1'), ('11437', '117.136.24.138', '中国', '移动', '0', '2010-03-10', '1'), ('11438', '117.136.0.52', '中国', '移动', '0', '2010-03-10', '1'), ('11439', '117.136.24.23', '中国', '移动', '0', '2010-03-10', '1'), ('11440', '117.136.30.62', '中国', '移动', '0', '2010-03-10', '1'), ('11441', '117.136.21.239', '中国', '移动', '0', '2010-03-10', '1'), ('11442', '117.136.23.7', '中国', '移动', '0', '2010-03-10', '1'), ('11443', '117.136.0.28', '中国', '移动', '0', '2010-03-10', '1'), ('11444', '117.136.10.177', '山东省潍坊市', '移动', '0', '2010-03-10', '1'), ('11445', '117.136.23.42', '中国', '移动', '0', '2010-03-10', '1'), ('11446', '117.136.0.43', '中国', '移动', '0', '2010-03-11', '1'), ('11447', '117.136.24.88', '中国', '移动', '0', '2010-03-11', '1'), ('11448', '117.136.15.18', '中国', '移动', '0', '2010-03-11', '1'), ('11449', '117.136.21.32', '中国', '移动', '0', '2010-03-11', '1'), ('11450', '117.136.9.43', '山东省潍坊市', '移动', '0', '2010-03-11', '1'), ('11451', '117.136.15.215', '中国', '移动', '0', '2010-03-11', '1'), ('11452', '117.136.15.222', '中国', '移动', '0', '2010-03-11', '1'), ('11453', '117.136.23.37', '中国', '移动', '0', '2010-03-11', '1'), ('11454', '117.136.1.243', '中国', '移动', '0', '2010-03-11', '1'), ('11455', '117.136.7.71', '辽宁省本溪市', '移动', '0', '2010-03-11', '1'), ('11456', '117.136.23.225', '中国', '移动', '0', '2010-03-11', '1'), ('11457', '117.136.30.52', '中国', '移动', '0', '2010-03-11', '1'), ('11458', '221.130.13.43', '江苏省南京市', '移动', '0', '2010-03-11', '1'), ('11459', '117.136.23.224', '中国', '移动', '0', '2010-03-11', '1'), ('11460', '117.136.21.142', '中国', '移动', '0', '2010-03-11', '1'), ('11461', '117.136.7.72', '辽宁省本溪市', '移动', '0', '2010-03-11', '1'), ('11462', '117.136.23.161', '中国', '移动', '0', '2010-03-11', '1'), ('11463', '117.136.21.233', '中国', '移动', '0', '2010-03-11', '1'), ('11464', '117.136.24.46', '中国', '移动', '0', '2010-03-12', '1'), ('11465', '117.136.31.186', '中国', '移动', '0', '2010-03-12', '1'), ('11466', '117.136.5.163', '辽宁省本溪市', '移动', '0', '2010-03-12', '1'), ('11467', '117.136.0.32', '中国', '移动', '0', '2010-03-12', '1'), ('11468', '117.136.23.54', '中国', '移动', '0', '2010-03-12', '1'), ('11469', '117.136.30.87', '中国', '移动', '0', '2010-03-12', '1'), ('11470', '117.136.24.96', '中国', '移动', '0', '2010-03-12', '1'), ('11471', '111.0.232.21', '中国', '移动', '0', '2010-03-12', '1'), ('11472', '117.136.23.40', '中国', '移动', '0', '2010-03-12', '1'), ('11473', '117.136.23.49', '中国', '移动', '0', '2010-03-13', '1'), ('11474', '211.139.92.234', '甘肃省兰州市', '移动', '0', '2010-03-13', '1'), ('11475', '117.136.21.12', '中国', '移动', '0', '2010-03-13', '1'), ('11476', '117.136.14.20', '中国', '移动', '0', '2010-03-13', '1'), ('11477', '117.136.21.140', '中国', '移动', '0', '2010-03-13', '1'), ('11478', '117.136.0.138', '中国', '移动', '0', '2010-03-13', '1'), ('11479', '117.136.5.161', '辽宁省本溪市', '移动', '0', '2010-03-14', '1'), ('11480', '117.136.24.36', '中国', '移动', '0', '2010-03-14', '1'), ('11481', '117.136.21.245', '中国', '移动', '0', '2010-03-14', '1'), ('11482', '117.136.23.89', '中国', '移动', '0', '2010-03-14', '1'), ('11483', '117.136.21.85', '中国', '移动', '0', '2010-03-14', '1'), ('11484', '117.136.23.11', '中国', '移动', '0', '2010-03-14', '1'), ('11485', '117.136.23.218', '中国', '移动', '0', '2010-03-14', '1'), ('11486', '117.136.5.207', '辽宁省本溪市', '移动', '0', '2010-03-14', '1'), ('11487', '117.136.30.37', '中国', '移动', '0', '2010-03-14', '1'), ('11488', '117.136.21.221', '中国', '移动', '0', '2010-03-14', '1'), ('11489', '117.136.24.82', '中国', '移动', '0', '2010-03-15', '1'), ('11490', '117.136.31.187', '中国', '移动', '0', '2010-03-15', '1'), ('11491', '117.136.23.58', '中国', '移动', '0', '2010-03-15', '1'), ('11492', '117.136.1.251', '中国', '移动', '0', '2010-03-15', '1'), ('11493', '117.136.15.97', '中国', '移动', '0', '2010-03-15', '1'), ('11494', '117.136.15.132', '中国', '移动', '0', '2010-03-15', '1'), ('11495', '117.136.30.43', '中国', '移动', '0', '2010-03-15', '1'), ('11496', '117.136.30.50', '中国', '移动', '0', '2010-03-15', '1'), ('11497', '117.136.1.128', '中国', '移动', '0', '2010-03-15', '1'), ('11498', '117.136.23.29', '中国', '移动', '0', '2010-03-15', '1'), ('11499', '117.136.21.141', '中国', '移动', '0', '2010-03-15', '1'), ('11500', '117.136.24.114', '中国', '移动', '0', '2010-03-15', '1'), ('11501', '117.136.15.249', '中国', '移动', '0', '2010-03-15', '1'), ('11502', '117.136.1.240', '中国', '移动', '0', '2010-03-16', '1'), ('11503', '117.136.15.223', '中国', '移动', '0', '2010-03-16', '1'), ('11504', '117.136.30.57', '中国', '移动', '0', '2010-03-16', '1'), ('11505', '117.136.23.139', '中国', '移动', '0', '2010-03-16', '1'), ('11506', '117.136.31.184', '中国', '移动', '0', '2010-03-16', '1'), ('11507', '117.136.23.169', '中国', '移动', '0', '2010-03-16', '1'), ('11508', '117.136.0.42', '中国', '移动', '0', '2010-03-16', '1'), ('11509', '117.136.15.105', '中国', '移动', '0', '2010-03-17', '1'), ('11510', '117.136.23.106', '中国', '移动', '0', '2010-03-17', '1'), ('11511', '120.196.193.14', '中国', '移动', '0', '2010-03-17', '1'), ('11512', '117.136.12.234', '中国', '移动', '0', '2010-03-17', '1'), ('11513', '117.136.28.244', '中国', '移动', '0', '2010-03-17', '1'), ('11514', '117.136.23.47', '中国', '移动', '0', '2010-03-17', '1'), ('11515', '117.136.23.103', '中国', '移动', '0', '2010-03-17', '1'), ('11516', '117.136.24.44', '中国', '移动', '0', '2010-03-18', '1'), ('11517', '117.136.30.12', '中国', '移动', '0', '2010-03-18', '1'), ('11518', '117.136.12.235', '中国', '移动', '0', '2010-03-18', '1'), ('11519', '117.136.15.229', '中国', '移动', '0', '2010-03-18', '1'), ('11520', '117.136.5.172', '辽宁省本溪市', '移动', '0', '2010-03-19', '1'), ('11521', '117.136.23.184', '中国', '移动', '0', '2010-03-19', '1'), ('11522', '117.136.24.105', '中国', '移动', '0', '2010-03-19', '1'), ('11523', '117.136.23.195', '中国', '移动', '0', '2010-03-19', '1'), ('11524', '117.136.0.57', '中国', '移动', '0', '2010-03-19', '1'), ('11525', '117.136.24.126', '中国', '移动', '0', '2010-03-19', '1'), ('11526', '117.136.30.59', '中国', '移动', '0', '2010-03-20', '1'), ('11527', '117.136.15.33', '中国', '移动', '0', '2010-03-20', '1'), ('11528', '117.136.9.34', '山东省潍坊市', '移动', '0', '2010-03-20', '1'), ('11529', '117.136.23.127', '中国', '移动', '0', '2010-03-20', '1'), ('11530', '117.136.23.136', '中国', '移动', '0', '2010-03-20', '1'), ('11531', '117.136.15.254', '中国', '移动', '0', '2010-03-20', '1'), ('11532', '117.136.15.203', '中国', '移动', '0', '2010-03-20', '1'), ('11533', '117.136.0.62', '中国', '移动', '0', '2010-03-21', '1'), ('11534', '117.136.23.4', '中国', '移动', '0', '2010-03-21', '1'), ('11535', '117.136.9.176', '山东省潍坊市', '移动', '0', '2010-03-21', '1'), ('11536', '117.136.7.161', '辽宁省本溪市', '移动', '0', '2010-03-21', '1'), ('11537', '117.136.15.219', '中国', '移动', '0', '2010-03-21', '1'), ('11538', '117.136.15.228', '中国', '移动', '0', '2010-03-21', '1'), ('11539', '117.136.23.171', '中国', '移动', '0', '2010-03-22', '1'), ('11540', '117.136.12.237', '中国', '移动', '0', '2010-03-22', '1'), ('11541', '117.136.5.7', '辽宁省本溪市', '移动', '0', '2010-03-22', '1'), ('11542', '117.136.15.214', '中国', '移动', '0', '2010-03-22', '1'), ('11543', '117.136.5.166', '辽宁省本溪市', '移动', '0', '2010-03-23', '1'), ('11544', '117.136.24.26', '中国', '移动', '0', '2010-03-23', '1'), ('11545', '117.136.21.209', '中国', '移动', '0', '2010-03-23', '1'), ('11546', '117.136.23.235', '中国', '移动', '0', '2010-03-23', '1'), ('11547', '117.136.24.70', '中国', '移动', '0', '2010-03-23', '1'), ('11548', '117.136.23.186', '中国', '移动', '0', '2010-03-23', '1'), ('11549', '117.136.12.227', '中国', '移动', '0', '2010-03-23', '1'), ('11550', '117.136.24.43', '中国', '移动', '0', '2010-03-23', '1'), ('11551', '117.136.23.244', '中国', '移动', '0', '2010-03-23', '1'), ('11552', '117.136.21.204', '中国', '移动', '0', '2010-03-23', '1'), ('11553', '117.136.23.204', '中国', '移动', '0', '2010-03-24', '1'), ('11554', '117.136.21.196', '中国', '移动', '0', '2010-03-24', '1'), ('11555', '117.136.24.38', '中国', '移动', '0', '2010-03-24', '1'), ('11556', '117.136.5.202', '辽宁省本溪市', '移动', '0', '2010-03-24', '1'), ('11557', '117.136.21.253', '中国', '移动', '0', '2010-03-24', '1'), ('11558', '117.136.9.175', '山东省潍坊市', '移动', '0', '2010-03-24', '1'), ('11559', '117.136.15.220', '中国', '移动', '0', '2010-03-24', '1'), ('11560', '117.136.5.137', '辽宁省本溪市', '移动', '0', '2010-03-24', '1'), ('11561', '117.136.24.66', '中国', '移动', '0', '2010-03-24', '1'), ('11562', '117.136.24.107', '中国', '移动', '0', '2010-03-24', '1'), ('11563', '117.136.15.212', '中国', '移动', '0', '2010-03-24', '1'), ('11564', '117.136.11.18', '山东省潍坊市', '移动', '0', '2010-03-25', '1'), ('11565', '117.136.11.19', '山东省潍坊市', '移动', '0', '2010-03-25', '1'), ('11566', '117.136.21.157', '中国', '移动', '0', '2010-03-25', '1'), ('11567', '117.136.21.225', '中国', '移动', '0', '2010-03-25', '1'), ('11568', '211.139.92.9', '甘肃省兰州市', '移动', '0', '2010-03-25', '1'), ('11569', '211.139.92.8', '甘肃省兰州市', '移动', '0', '2010-03-25', '1'), ('11570', '117.136.23.36', '中国', '移动', '0', '2010-03-25', '1'), ('11571', '117.136.24.68', '中国', '移动', '0', '2010-03-26', '1'), ('11572', '117.136.5.199', '辽宁省本溪市', '移动', '0', '2010-03-26', '1'), ('11573', '117.136.24.58', '中国', '移动', '0', '2010-03-26', '1'), ('11574', '117.136.21.254', '中国', '移动', '0', '2010-03-27', '1'), ('11575', '117.136.0.79', '中国', '移动', '0', '2010-03-27', '1'), ('11576', '117.136.23.228', '中国', '移动', '0', '2010-03-27', '1'), ('11577', '117.136.11.23', '山东省潍坊市', '移动', '0', '2010-03-27', '1'), ('11578', '117.136.23.159', '中国', '移动', '0', '2010-03-27', '1'), ('11579', '117.136.15.197', '中国', '移动', '0', '2010-03-27', '1'), ('11580', '211.139.92.235', '甘肃省兰州市', '移动', '0', '2010-03-27', '1'), ('11581', '117.136.16.73', '中国', '移动', '0', '2010-03-27', '1'), ('11582', '117.136.23.206', '中国', '移动', '0', '2010-03-28', '1'), ('11583', '117.136.15.211', '中国', '移动', '0', '2010-03-28', '1'), ('11584', '117.136.24.67', '中国', '移动', '0', '2010-03-28', '1'), ('11585', '117.136.21.47', '中国', '移动', '0', '2010-03-28', '1'), ('11586', '117.136.8.203', '山东省潍坊市', '移动', '0', '2010-03-28', '1'), ('11587', '117.136.21.203', '中国', '移动', '0', '2010-03-28', '1'), ('11588', '117.136.8.205', '山东省潍坊市', '移动', '0', '2010-03-28', '1'), ('11589', '117.136.5.220', '辽宁省本溪市', '移动', '0', '2010-03-28', '1'), ('11590', '117.136.15.111', '中国', '移动', '0', '2010-03-28', '1'), ('11591', '117.136.24.71', '中国', '移动', '0', '2010-03-28', '1'), ('11592', '117.136.24.21', '中国', '移动', '0', '2010-03-28', '1'), ('11593', '117.136.21.224', '中国', '移动', '0', '2010-03-28', '1'), ('11594', '117.136.24.52', '中国', '移动', '0', '2010-03-29', '1'), ('11595', '211.139.92.236', '甘肃省兰州市', '移动', '0', '2010-03-29', '1'), ('11596', '117.136.15.193', '中国', '移动', '0', '2010-03-29', '1'), ('11597', '117.136.23.214', '中国', '移动', '0', '2010-03-29', '1'), ('11598', '117.136.21.77', '中国', '移动', '0', '2010-03-29', '1'), ('11599', '117.136.5.218', '辽宁省本溪市', '移动', '0', '2010-03-30', '1'), ('11600', '117.136.9.27', '山东省潍坊市', '移动', '0', '2010-03-30', '1'), ('11601', '117.136.0.84', '中国', '移动', '0', '2010-03-30', '1'), ('11602', '117.136.1.132', '中国', '移动', '0', '2010-03-30', '1'), ('11603', '117.136.8.212', '山东省潍坊市', '移动', '0', '2010-03-31', '1'), ('11604', '117.136.8.176', '山东省潍坊市', '移动', '0', '2010-03-31', '1'), ('11605', '117.136.15.204', '中国', '移动', '0', '2010-03-31', '1'), ('11606', '117.136.0.29', '中国', '移动', '0', '2010-04-01', '1'), ('11607', '117.136.8.171', '山东省潍坊市', '移动', '0', '2010-04-01', '1'), ('11608', '117.136.21.138', '中国', '移动', '0', '2010-04-01', '1'), ('11609', '117.136.9.28', '山东省潍坊市', '移动', '0', '2010-04-01', '1'), ('11610', '117.136.30.35', '中国', '移动', '0', '2010-04-01', '1'), ('11611', '117.136.15.29', '中国', '移动', '0', '2010-04-01', '1'), ('11612', '117.136.23.247', '中国', '移动', '0', '2010-04-02', '1'), ('11613', '117.136.16.65', '中国', '移动', '0', '2010-04-02', '1'), ('11614', '117.136.16.79', '中国', '移动', '0', '2010-04-02', '1'), ('11615', '117.136.23.44', '中国', '移动', '0', '2010-04-02', '1'), ('11616', '117.136.9.166', '山东省潍坊市', '移动', '0', '2010-04-02', '1'), ('11617', '117.136.0.51', '中国', '移动', '0', '2010-04-02', '1'), ('11618', '117.136.21.217', '中国', '移动', '0', '2010-04-02', '1'), ('11619', '117.136.21.252', '中国', '移动', '0', '2010-04-02', '1'), ('11620', '221.182.2.162', '四川省成都市', '移动', '0', '2010-04-02', '1'), ('11621', '117.136.8.204', '山东省潍坊市', '移动', '0', '2010-04-02', '1'), ('11622', '117.136.8.211', '山东省潍坊市', '移动', '0', '2010-04-02', '1'), ('11623', '117.136.21.167', '中国', '移动', '0', '2010-04-02', '1'), ('11624', '117.136.15.238', '中国', '移动', '0', '2010-04-03', '1'), ('11625', '117.136.21.236', '中国', '移动', '0', '2010-04-03', '1'), ('11626', '117.136.23.13', '中国', '移动', '0', '2010-04-03', '1'), ('11627', '117.136.9.41', '山东省潍坊市', '移动', '0', '2010-04-03', '1'), ('11628', '117.136.23.64', '中国', '移动', '0', '2010-04-03', '1'), ('11629', '117.136.24.133', '中国', '移动', '0', '2010-04-03', '1'), ('11630', '117.136.23.254', '中国', '移动', '0', '2010-04-03', '1'), ('11631', '117.136.24.100', '中国', '移动', '0', '2010-04-03', '1'), ('11632', '117.136.24.50', '中国', '移动', '0', '2010-04-03', '1'), ('11633', '117.136.15.157', '中国', '移动', '0', '2010-04-03', '1'), ('11634', '117.136.5.170', '辽宁省本溪市', '移动', '0', '2010-04-03', '1'), ('11635', '117.136.8.175', '山东省潍坊市', '移动', '0', '2010-04-03', '1'), ('11636', '117.136.5.12', '辽宁省本溪市', '移动', '0', '2010-04-03', '1'), ('11637', '117.136.1.228', '中国', '移动', '0', '2010-04-04', '1'), ('11638', '117.136.15.247', '中国', '移动', '0', '2010-04-04', '1'), ('11639', '117.136.23.48', '中国', '移动', '0', '2010-04-04', '1'), ('11640', '117.136.21.202', '中国', '移动', '0', '2010-04-04', '1'), ('11641', '117.136.24.55', '中国', '移动', '0', '2010-04-04', '1'), ('11642', '117.136.23.35', '中国', '移动', '0', '2010-04-05', '1'), ('11643', '117.136.24.122', '中国', '移动', '0', '2010-04-05', '1'), ('11644', '117.136.21.192', '中国', '移动', '0', '2010-04-05', '1'), ('11645', '117.136.23.164', '中国', '移动', '0', '2010-04-05', '1'), ('11646', '117.136.29.56', '中国', '移动', '0', '2010-04-05', '1'), ('11647', '117.136.29.52', '中国', '移动', '0', '2010-04-05', '1'), ('11648', '221.182.46.71', '四川省成都市', '移动', '0', '2010-04-05', '1'), ('11649', '117.136.8.206', '山东省潍坊市', '移动', '0', '2010-04-05', '1'), ('11650', '117.136.8.180', '山东省潍坊市', '移动', '0', '2010-04-05', '1'), ('11651', '117.136.15.110', '中国', '移动', '0', '2010-04-05', '1'), ('11652', '117.136.12.228', '中国', '移动', '0', '2010-04-05', '1'), ('11653', '117.136.0.44', '中国', '移动', '0', '2010-04-06', '1'), ('11654', '117.136.24.104', '中国', '移动', '0', '2010-04-06', '1'), ('11655', '117.136.23.60', '中国', '移动', '0', '2010-04-06', '1'), ('11656', '117.136.23.146', '中国', '移动', '0', '2010-04-06', '1'), ('11657', '117.136.23.143', '中国', '移动', '0', '2010-04-06', '1'), ('11658', '117.136.24.29', '中国', '移动', '0', '2010-04-06', '1'), ('11659', '117.136.24.129', '中国', '移动', '0', '2010-04-06', '1'), ('11660', '117.136.6.16', '辽宁省本溪市', '移动', '0', '2010-04-06', '1'), ('11661', '117.136.8.209', '山东省潍坊市', '移动', '0', '2010-04-07', '1'), ('11662', '117.136.24.32', '中国', '移动', '0', '2010-04-07', '1'), ('11663', '117.136.11.57', '山东省潍坊市', '移动', '0', '2010-04-07', '1'), ('11664', '117.136.0.78', '中国', '移动', '0', '2010-04-07', '1'), ('11665', '117.136.21.188', '中国', '移动', '0', '2010-04-07', '1'), ('11666', '117.136.1.134', '中国', '移动', '0', '2010-04-07', '1'), ('11667', '117.136.5.219', '辽宁省本溪市', '移动', '0', '2010-04-07', '1'), ('11668', '117.136.15.143', '中国', '移动', '0', '2010-04-07', '1'), ('11669', '117.136.0.65', '中国', '移动', '0', '2010-04-07', '1'), ('11670', '221.178.9.180', '重庆市', '移动', '0', '2010-04-07', '1'), ('11671', '117.136.15.136', '中国', '移动', '0', '2010-04-07', '1'), ('11672', '117.136.6.12', '辽宁省本溪市', '移动', '0', '2010-04-07', '1'), ('11673', '117.136.24.59', '中国', '移动', '0', '2010-04-08', '1'), ('11674', '117.136.5.43', '辽宁省本溪市', '移动', '0', '2010-04-08', '1'), ('11675', '117.136.5.37', '辽宁省本溪市', '移动', '0', '2010-04-08', '1'), ('11676', '117.136.31.38', '中国', '移动', '0', '2010-04-08', '1'), ('11677', '117.136.21.146', '中国', '移动', '0', '2010-04-08', '1'), ('11678', '117.136.23.219', '中国', '移动', '0', '2010-04-08', '1'), ('11679', '117.136.1.244', '中国', '移动', '0', '2010-04-08', '1'), ('11680', '211.143.83.46', '河北省', '移动', '0', '2010-04-08', '1'), ('11681', '117.136.31.61', '中国', '移动', '0', '2010-04-08', '1'), ('11682', '117.136.8.210', '山东省潍坊市', '移动', '0', '2010-04-08', '1'), ('11683', '117.136.31.58', '中国', '移动', '0', '2010-04-08', '1'), ('11684', '117.136.0.73', '中国', '移动', '0', '2010-04-09', '1'), ('11685', '117.136.24.137', '中国', '移动', '0', '2010-04-09', '1'), ('11686', '117.136.15.240', '中国', '移动', '0', '2010-04-09', '1'), ('11687', '117.136.31.59', '中国', '移动', '0', '2010-04-09', '1'), ('11688', '117.136.21.135', '中国', '移动', '0', '2010-04-09', '1'), ('11689', '117.136.5.40', '辽宁省本溪市', '移动', '0', '2010-04-09', '1'), ('11690', '117.136.30.46', '中国', '移动', '0', '2010-04-09', '1'), ('11691', '117.136.21.227', '中国', '移动', '0', '2010-04-09', '1'), ('11692', '117.136.30.28', '中国', '移动', '0', '2010-04-09', '1'), ('11693', '117.136.9.180', '山东省潍坊市', '移动', '0', '2010-04-10', '1'), ('11694', '117.136.8.173', '山东省潍坊市', '移动', '0', '2010-04-10', '1'), ('11695', '117.136.31.60', '中国', '移动', '0', '2010-04-10', '1'), ('11696', '117.136.23.3', '中国', '移动', '0', '2010-04-10', '1'), ('11697', '117.136.1.226', '中国', '移动', '0', '2010-04-10', '1'), ('11698', '117.136.1.248', '中国', '移动', '0', '2010-04-10', '1'), ('11699', '117.136.11.181', '山东省潍坊市', '移动', '0', '2010-04-10', '1'), ('11700', '117.136.21.200', '中国', '移动', '0', '2010-04-11', '1'), ('11701', '117.136.23.52', '中国', '移动', '0', '2010-04-11', '1'), ('11702', '117.136.31.34', '中国', '移动', '0', '2010-04-11', '1'), ('11703', '117.136.24.35', '中国', '移动', '0', '2010-04-11', '1'), ('11704', '117.136.23.211', '中国', '移动', '0', '2010-04-11', '1'), ('11705', '117.136.15.209', '中国', '移动', '0', '2010-04-11', '1'), ('11706', '117.136.5.36', '辽宁省本溪市', '移动', '0', '2010-04-11', '1'), ('11707', '211.140.19.6', '浙江省杭州市', '移动', '0', '2010-04-11', '1'), ('11708', '117.136.8.208', '山东省潍坊市', '移动', '0', '2010-04-11', '1'), ('11709', '117.136.21.230', '中国', '移动', '0', '2010-04-12', '1'), ('11710', '117.136.15.221', '中国', '移动', '0', '2010-04-12', '1'), ('11711', '117.136.23.200', '中国', '移动', '0', '2010-04-12', '1'), ('11712', '117.136.8.178', '山东省潍坊市', '移动', '0', '2010-04-12', '1'), ('11713', '117.136.1.233', '中国', '移动', '0', '2010-04-12', '1'), ('11714', '117.136.0.93', '中国', '移动', '0', '2010-04-12', '1'), ('11715', '117.136.8.174', '山东省潍坊市', '移动', '0', '2010-04-12', '1'), ('11716', '117.136.0.14', '中国', '移动', '0', '2010-04-12', '1'), ('11717', '117.136.30.94', '中国', '移动', '0', '2010-04-12', '1'), ('11718', '117.136.31.50', '中国', '移动', '0', '2010-04-12', '1'), ('11719', '117.136.21.246', '中国', '移动', '0', '2010-04-13', '1'), ('11720', '117.136.31.57', '中国', '移动', '0', '2010-04-13', '1'), ('11721', '117.136.30.39', '中国', '移动', '0', '2010-04-13', '1'), ('11722', '117.136.8.172', '山东省潍坊市', '移动', '0', '2010-04-13', '1'), ('11723', '117.136.23.79', '中国', '移动', '0', '2010-04-13', '1'), ('11724', '117.136.5.33', '辽宁省本溪市', '移动', '0', '2010-04-13', '1'), ('11725', '117.136.21.29', '中国', '移动', '0', '2010-04-13', '1'), ('11726', '117.136.5.42', '辽宁省本溪市', '移动', '0', '2010-04-13', '1'), ('11727', '117.136.31.35', '中国', '移动', '0', '2010-04-13', '1'), ('11728', '117.136.11.183', '山东省潍坊市', '移动', '0', '2010-04-14', '1'), ('11729', '117.136.11.179', '山东省潍坊市', '移动', '0', '2010-04-14', '1'), ('11730', '221.182.2.167', '四川省成都市', '移动', '0', '2010-04-14', '1'), ('11731', '117.136.0.4', '中国', '移动', '0', '2010-04-15', '1'), ('11732', '117.136.12.217', '中国', '移动', '0', '2010-04-15', '1'), ('11733', '117.136.31.62', '中国', '移动', '0', '2010-04-15', '1'), ('11734', '117.136.9.179', '山东省潍坊市', '移动', '0', '2010-04-15', '1'), ('11735', '117.136.5.38', '辽宁省本溪市', '移动', '0', '2010-04-15', '1'), ('11736', '117.136.31.33', '中国', '移动', '0', '2010-04-16', '1'), ('11737', '117.136.30.60', '中国', '移动', '0', '2010-04-16', '1'), ('11738', '117.136.5.41', '辽宁省本溪市', '移动', '0', '2010-04-16', '1'), ('11739', '117.136.1.130', '中国', '移动', '0', '2010-04-16', '1'), ('11740', '117.136.24.37', '中国', '移动', '0', '2010-04-16', '1'), ('11741', '117.136.5.34', '辽宁省本溪市', '移动', '0', '2010-04-17', '1'), ('11742', '117.136.31.37', '中国', '移动', '0', '2010-04-17', '1'), ('11743', '117.136.15.206', '中国', '移动', '0', '2010-04-17', '1'), ('11744', '117.136.5.35', '辽宁省本溪市', '移动', '0', '2010-04-18', '1'), ('11745', '117.136.8.207', '山东省潍坊市', '移动', '0', '2010-04-18', '1'), ('11746', '117.136.23.69', '中国', '移动', '0', '2010-04-18', '1'), ('11747', '117.136.1.157', '中国', '移动', '0', '2010-04-18', '1'), ('11748', '117.136.24.132', '中国', '移动', '0', '2010-04-18', '1'), ('11749', '117.136.23.175', '中国', '移动', '0', '2010-04-18', '1'), ('11750', '117.136.13.2', '中国', '移动', '0', '2010-04-18', '1'), ('11751', '117.136.5.215', '辽宁省本溪市', '移动', '0', '2010-04-19', '1'), ('11752', '117.136.6.23', '辽宁省本溪市', '移动', '0', '2010-04-19', '1'), ('11753', '117.136.17.133', '中国', '移动', '0', '2010-04-19', '1'), ('11754', '117.136.31.36', '中国', '移动', '0', '2010-04-19', '1'), ('11755', '117.136.30.17', '中国', '移动', '0', '2010-04-19', '1'), ('11756', '117.136.6.15', '辽宁省本溪市', '移动', '0', '2010-04-19', '1'), ('11757', '117.136.5.194', '辽宁省本溪市', '移动', '0', '2010-04-20', '1'), ('11758', '117.136.15.100', '中国', '移动', '0', '2010-04-20', '1'), ('11759', '117.136.23.56', '中国', '移动', '0', '2010-04-20', '1'), ('11760', '221.182.46.89', '四川省成都市', '移动', '0', '2010-04-20', '1'), ('11761', '117.136.17.134', '中国', '移动', '0', '2010-04-20', '1'), ('11762', '117.136.24.98', '中国', '移动', '0', '2010-04-21', '1'), ('11763', '117.136.21.152', '中国', '移动', '0', '2010-04-21', '1'), ('11764', '117.136.15.202', '中国', '移动', '0', '2010-04-21', '1'), ('11765', '117.136.24.143', '中国', '移动', '0', '2010-04-21', '1'), ('11766', '117.136.1.239', '中国', '移动', '0', '2010-04-21', '1'), ('11767', '117.136.8.179', '山东省潍坊市', '移动', '0', '2010-04-21', '1'), ('11768', '117.136.17.140', '中国', '移动', '0', '2010-04-21', '1'), ('11769', '117.136.6.5', '辽宁省本溪市', '移动', '0', '2010-04-22', '1'), ('11770', '117.136.15.241', '中国', '移动', '0', '2010-04-22', '1'), ('11771', '117.136.15.144', '中国', '移动', '0', '2010-04-22', '1'), ('11772', '117.136.23.16', '中国', '移动', '0', '2010-04-22', '1'), ('11773', '117.136.21.175', '中国', '移动', '0', '2010-04-22', '1'), ('11774', '117.136.30.13', '中国', '移动', '0', '2010-04-23', '1'), ('11775', '117.136.31.49', '中国', '移动', '0', '2010-04-23', '1'), ('11776', '117.136.21.208', '中国', '移动', '0', '2010-04-24', '1'), ('11777', '117.136.6.3', '辽宁省本溪市', '移动', '0', '2010-04-24', '1'), ('11778', '117.136.11.178', '山东省潍坊市', '移动', '0', '2010-04-24', '1'), ('11779', '117.136.24.142', '中国', '移动', '0', '2010-04-24', '1'), ('11780', '117.136.22.187', '中国', '移动', '0', '2010-04-25', '1'), ('11781', '117.136.22.185', '中国', '移动', '0', '2010-04-25', '1'), ('11782', '117.136.23.162', '中国', '移动', '0', '2010-04-25', '1'), ('11783', '117.136.22.178', '中国', '移动', '0', '2010-04-25', '1'), ('11784', '117.136.21.242', '中国', '移动', '0', '2010-04-25', '1'), ('11785', '117.136.22.184', '中国', '移动', '0', '2010-04-25', '1'), ('11786', '117.136.22.186', '中国', '移动', '0', '2010-04-25', '1'), ('11787', '117.136.6.143', '辽宁省本溪市', '移动', '0', '2010-04-25', '1'), ('11788', '117.136.22.180', '中国', '移动', '0', '2010-04-25', '1'), ('11789', '117.136.22.177', '中国', '移动', '0', '2010-04-25', '1'), ('11790', '117.136.15.26', '中国', '移动', '0', '2010-04-25', '1'), ('11791', '117.136.22.182', '中国', '移动', '0', '2010-04-25', '1'), ('11792', '117.136.0.71', '中国', '移动', '0', '2010-04-25', '1'), ('11793', '117.136.22.179', '中国', '移动', '0', '2010-04-25', '1'), ('11794', '117.136.22.181', '中国', '移动', '0', '2010-04-25', '1'), ('11795', '221.130.162.231', '中国', '移动', '0', '2010-04-25', '1'), ('11796', '117.136.22.183', '中国', '移动', '0', '2010-04-25', '1'), ('11797', '117.136.22.99', '中国', '移动', '0', '2010-04-25', '1'), ('11798', '117.136.22.100', '中国', '移动', '0', '2010-04-25', '1'), ('11799', '117.136.22.97', '中国', '移动', '0', '2010-04-26', '1'), ('11800', '117.136.23.205', '中国', '移动', '0', '2010-04-26', '1'), ('11801', '117.136.17.56', '中国', '移动', '0', '2010-04-26', '1'), ('11802', '117.136.15.37', '中国', '移动', '0', '2010-04-26', '1'), ('11803', '117.136.22.188', '中国', '移动', '0', '2010-04-27', '1'), ('11804', '117.136.22.98', '中国', '移动', '0', '2010-04-27', '1'), ('11805', '117.136.23.238', '中国', '移动', '0', '2010-04-27', '1'), ('11806', '117.136.17.55', '中国', '移动', '0', '2010-04-27', '1'), ('11807', '117.136.30.6', '中国', '移动', '0', '2010-04-27', '1'), ('11808', '117.136.21.173', '中国', '移动', '0', '2010-04-28', '1'), ('11809', '117.136.5.200', '辽宁省本溪市', '移动', '0', '2010-04-28', '1'), ('11810', '117.136.23.182', '中国', '移动', '0', '2010-04-28', '1'), ('11811', '117.136.24.30', '中国', '移动', '0', '2010-04-28', '1'), ('11812', '117.136.24.121', '中国', '移动', '0', '2010-04-28', '1'), ('11813', '117.136.15.16', '中国', '移动', '0', '2010-04-28', '1'), ('11814', '117.136.6.30', '辽宁省本溪市', '移动', '0', '2010-04-28', '1'), ('11815', '117.136.30.88', '中国', '移动', '0', '2010-04-28', '1'), ('11816', '117.136.11.182', '山东省潍坊市', '移动', '0', '2010-04-28', '1'), ('11817', '117.136.31.51', '中国', '移动', '0', '2010-04-28', '1'), ('11818', '117.136.31.53', '中国', '移动', '0', '2010-04-28', '1'), ('11819', '117.136.24.127', '中国', '移动', '0', '2010-04-28', '1'), ('11820', '117.136.21.54', '中国', '移动', '0', '2010-04-29', '1'), ('11821', '117.136.24.117', '中国', '移动', '0', '2010-04-29', '1'), ('11822', '117.136.11.32', '山东省潍坊市', '移动', '0', '2010-04-29', '1'), ('11823', '117.136.15.38', '中国', '移动', '0', '2010-04-29', '1'), ('11824', '117.136.11.189', '山东省潍坊市', '移动', '0', '2010-04-29', '1'), ('11825', '117.136.23.65', '中国', '移动', '0', '2010-04-30', '1'), ('11826', '117.136.22.237', '中国', '移动', '0', '2010-04-30', '1'), ('11827', '117.136.6.144', '辽宁省本溪市', '移动', '0', '2010-04-30', '1'), ('11828', '117.136.30.21', '中国', '移动', '0', '2010-04-30', '1'), ('11829', '117.136.11.180', '山东省潍坊市', '移动', '0', '2010-04-30', '1'), ('11830', '117.136.24.118', '中国', '移动', '0', '2010-04-30', '1'), ('11831', '117.136.14.59', '中国', '移动', '0', '2010-04-30', '1'), ('11832', '117.136.11.39', '山东省潍坊市', '移动', '0', '2010-04-30', '1'), ('11833', '117.136.11.36', '山东省潍坊市', '移动', '0', '2010-05-01', '1'), ('11834', '117.136.14.49', '中国', '移动', '0', '2010-05-01', '1'), ('11835', '117.136.9.98', '山东省潍坊市', '移动', '0', '2010-05-01', '1'), ('11836', '117.136.11.185', '山东省潍坊市', '移动', '0', '2010-05-01', '1'), ('11837', '117.136.11.42', '山东省潍坊市', '移动', '0', '2010-05-01', '1'), ('11838', '117.136.11.35', '山东省潍坊市', '移动', '0', '2010-05-01', '1'), ('11839', '117.136.21.148', '中国', '移动', '0', '2010-05-02', '1'), ('11840', '117.136.6.142', '辽宁省本溪市', '移动', '0', '2010-05-02', '1'), ('11841', '117.136.14.42', '中国', '移动', '0', '2010-05-02', '1'), ('11842', '117.136.23.240', '中国', '移动', '0', '2010-05-02', '1'), ('11843', '117.136.9.35', '山东省潍坊市', '移动', '0', '2010-05-02', '1'), ('11844', '117.136.14.44', '中国', '移动', '0', '2010-05-02', '1'), ('11845', '117.136.0.82', '中国', '移动', '0', '2010-05-02', '1'), ('11846', '117.136.11.46', '山东省潍坊市', '移动', '0', '2010-05-02', '1'), ('11847', '117.136.14.61', '中国', '移动', '0', '2010-05-02', '1'), ('11848', '117.136.14.52', '中国', '移动', '0', '2010-05-03', '1'), ('11849', '117.136.9.165', '山东省潍坊市', '移动', '0', '2010-05-03', '1'), ('11850', '117.136.24.47', '中国', '移动', '0', '2010-05-03', '1'), ('11851', '117.136.1.141', '中国', '移动', '0', '2010-05-03', '1'), ('11852', '117.136.14.41', '中国', '移动', '0', '2010-05-03', '1'), ('11853', '117.136.5.141', '辽宁省本溪市', '移动', '0', '2010-05-03', '1'), ('11854', '117.136.14.46', '中国', '移动', '0', '2010-05-03', '1'), ('11855', '117.136.5.39', '辽宁省本溪市', '移动', '0', '2010-05-03', '1'), ('11856', '117.136.9.183', '山东省潍坊市', '移动', '0', '2010-05-04', '1'), ('11857', '117.136.15.44', '中国', '移动', '0', '2010-05-04', '1'), ('11858', '117.136.30.25', '中国', '移动', '0', '2010-05-04', '1'), ('11859', '117.136.8.177', '山东省潍坊市', '移动', '0', '2010-05-04', '1'), ('11860', '117.136.14.45', '中国', '移动', '0', '2010-05-04', '1'), ('11861', '117.136.14.53', '中国', '移动', '0', '2010-05-04', '1'), ('11862', '117.136.11.47', '山东省潍坊市', '移动', '0', '2010-05-04', '1'), ('11863', '117.136.11.33', '山东省潍坊市', '移动', '0', '2010-05-04', '1'), ('11864', '117.136.14.51', '中国', '移动', '0', '2010-05-04', '1'), ('11865', '117.136.22.236', '中国', '移动', '0', '2010-05-04', '1'), ('11866', '117.136.21.88', '中国', '移动', '0', '2010-05-05', '1'), ('11867', '117.136.23.187', '中国', '移动', '0', '2010-05-05', '1'), ('11868', '117.136.11.43', '山东省潍坊市', '移动', '0', '2010-05-05', '1'), ('11869', '117.136.11.41', '山东省潍坊市', '移动', '0', '2010-05-05', '1'), ('11870', '117.136.11.44', '山东省潍坊市', '移动', '0', '2010-05-05', '1'), ('11871', '117.136.11.190', '山东省潍坊市', '移动', '0', '2010-05-05', '1'), ('11872', '117.136.5.130', '辽宁省本溪市', '移动', '0', '2010-05-05', '1'), ('11873', '117.136.21.156', '中国', '移动', '0', '2010-05-06', '1'), ('11874', '117.136.9.185', '山东省潍坊市', '移动', '0', '2010-05-06', '1'), ('11875', '117.136.9.97', '山东省潍坊市', '移动', '0', '2010-05-06', '1'), ('11876', '117.136.14.54', '中国', '移动', '0', '2010-05-06', '1'), ('11877', '117.136.22.240', '中国', '移动', '0', '2010-05-06', '1'), ('11878', '117.136.22.239', '中国', '移动', '0', '2010-05-06', '1'), ('11879', '117.136.0.77', '中国', '移动', '0', '2010-05-07', '1'), ('11880', '117.136.14.50', '中国', '移动', '0', '2010-05-07', '1'), ('11881', '221.182.2.168', '四川省成都市', '移动', '0', '2010-05-07', '1'), ('11882', '117.136.23.178', '中国', '移动', '0', '2010-05-08', '1'), ('11883', '117.136.12.201', '中国', '移动', '0', '2010-05-08', '1'), ('11884', '117.136.30.58', '中国', '移动', '0', '2010-05-08', '1'), ('11885', '218.206.252.65', '河南省', '移动', '0', '2010-05-08', '1'), ('11886', '117.136.21.216', '中国', '移动', '0', '2010-05-08', '1'), ('11887', '117.136.1.254', '中国', '移动', '0', '2010-05-09', '1'), ('11888', '117.136.21.159', '中国', '移动', '0', '2010-05-09', '1'), ('11889', '117.136.6.20', '辽宁省本溪市', '移动', '0', '2010-05-09', '1'), ('11890', '117.136.23.216', '中国', '移动', '0', '2010-05-09', '1'), ('11891', '117.136.22.233', '中国', '移动', '0', '2010-05-10', '1'), ('11892', '117.136.14.43', '中国', '移动', '0', '2010-05-10', '1'), ('11893', '117.136.11.13', '山东省潍坊市', '移动', '0', '2010-05-11', '1'), ('11894', '117.136.15.30', '中国', '移动', '0', '2010-05-11', '1'), ('11895', '117.136.15.46', '中国', '移动', '0', '2010-05-11', '1'), ('11896', '117.136.21.134', '中国', '移动', '0', '2010-05-11', '1'), ('11897', '117.136.14.60', '中国', '移动', '0', '2010-05-11', '1'), ('11898', '117.136.14.57', '中国', '移动', '0', '2010-05-11', '1'), ('11899', '117.136.23.208', '中国', '移动', '0', '2010-05-12', '1'), ('11900', '117.136.24.95', '中国', '移动', '0', '2010-05-12', '1'), ('11901', '117.136.30.45', '中国', '移动', '0', '2010-05-12', '1'), ('11902', '117.136.31.54', '中国', '移动', '0', '2010-05-12', '1'), ('11903', '117.136.23.248', '中国', '移动', '0', '2010-05-12', '1'), ('11904', '117.136.23.213', '中国', '移动', '0', '2010-05-13', '1'), ('11905', '117.136.23.8', '中国', '移动', '0', '2010-05-13', '1'), ('11906', '117.136.5.44', '辽宁省本溪市', '移动', '0', '2010-05-13', '1'), ('11907', '117.136.14.58', '中国', '移动', '0', '2010-05-13', '1'), ('11908', '117.136.24.15', '中国', '移动', '0', '2010-05-13', '1'), ('11909', '117.136.6.8', '辽宁省本溪市', '移动', '0', '2010-05-13', '1'), ('11910', '117.136.0.91', '中国', '移动', '0', '2010-05-14', '1'), ('11911', '117.136.0.70', '中国', '移动', '0', '2010-05-14', '1'), ('11912', '117.136.14.62', '中国', '移动', '0', '2010-05-14', '1'), ('11913', '117.136.1.169', '中国', '移动', '0', '2010-05-14', '1'), ('11914', '117.136.1.189', '中国', '移动', '0', '2010-05-15', '1'), ('11915', '117.136.11.4', '山东省潍坊市', '移动', '0', '2010-05-15', '1'), ('11916', '117.136.0.69', '中国', '移动', '0', '2010-05-15', '1'), ('11917', '117.136.26.1', '中国', '移动', '0', '2010-05-15', '1'), ('11918', '117.136.11.38', '山东省潍坊市', '移动', '0', '2010-05-15', '1'), ('11919', '117.136.1.208', '中国', '移动', '0', '2010-05-15', '1'), ('11920', '117.136.11.0', '山东省潍坊市', '移动', '0', '2010-05-15', '1'), ('11921', '117.136.1.180', '中国', '移动', '0', '2010-05-15', '1'), ('11922', '117.136.2.22', '中国', '移动', '0', '2010-05-15', '1'), ('11923', '117.136.1.56', '中国', '移动', '0', '2010-05-15', '1'), ('11924', '117.136.1.168', '中国', '移动', '0', '2010-05-15', '1'), ('11925', '117.136.1.170', '中国', '移动', '0', '2010-05-16', '1'), ('11926', '117.136.5.135', '辽宁省本溪市', '移动', '0', '2010-05-16', '1'), ('11927', '117.136.26.137', '中国', '移动', '0', '2010-05-16', '1'), ('11928', '117.136.26.136', '中国', '移动', '0', '2010-05-16', '1'), ('11929', '117.136.0.85', '中国', '移动', '0', '2010-05-16', '1'), ('11930', '117.136.31.52', '中国', '移动', '0', '2010-05-16', '1'), ('11931', '117.136.1.219', '中国', '移动', '0', '2010-05-17', '1'), ('11932', '117.136.26.138', '中国', '移动', '0', '2010-05-17', '1'), ('11933', '117.136.1.211', '中国', '移动', '0', '2010-05-18', '1'), ('11934', '117.136.1.66', '中国', '移动', '0', '2010-05-18', '1'), ('11935', '117.136.9.167', '山东省潍坊市', '移动', '0', '2010-05-19', '1'), ('11936', '117.136.26.2', '中国', '移动', '0', '2010-05-19', '1'), ('11937', '117.136.1.100', '中国', '移动', '0', '2010-05-19', '1'), ('11938', '117.136.23.130', '中国', '移动', '0', '2010-05-20', '1'), ('11939', '117.136.22.235', '中国', '移动', '0', '2010-05-20', '1'), ('11940', '117.136.15.32', '中国', '移动', '0', '2010-05-20', '1'), ('11941', '117.136.22.234', '中国', '移动', '0', '2010-05-20', '1'), ('11942', '117.136.15.20', '中国', '移动', '0', '2010-05-20', '1'), ('11943', '117.136.6.13', '辽宁省本溪市', '移动', '0', '2010-05-20', '1'), ('11944', '117.136.1.46', '中国', '移动', '0', '2010-05-21', '1'), ('11945', '117.136.9.174', '山东省潍坊市', '移动', '0', '2010-05-21', '1'), ('11946', '117.136.1.162', '中国', '移动', '0', '2010-05-21', '1'), ('11947', '113.18.96.26', '福建省', '移动', '0', '2010-05-21', '1'), ('11948', '117.136.1.177', '中国', '移动', '0', '2010-05-21', '1'), ('11949', '117.136.1.215', '中国', '移动', '0', '2010-05-22', '1'), ('11950', '117.136.11.34', '山东省潍坊市', '移动', '0', '2010-05-22', '1'), ('11951', '117.136.1.190', '中国', '移动', '0', '2010-05-22', '1'), ('11952', '117.136.23.185', '中国', '移动', '0', '2010-05-23', '1'), ('11953', '117.136.0.92', '中国', '移动', '0', '2010-05-23', '1'), ('11954', '117.136.0.75', '中国', '移动', '0', '2010-05-23', '1'), ('11955', '117.136.11.11', '山东省潍坊市', '移动', '0', '2010-05-23', '1'), ('11956', '117.136.24.11', '中国', '移动', '0', '2010-05-23', '1'), ('11957', '117.136.11.10', '山东省潍坊市', '移动', '0', '2010-05-23', '1'), ('11958', '117.136.23.126', '中国', '移动', '0', '2010-05-23', '1'), ('11959', '117.136.15.45', '中国', '移动', '0', '2010-05-23', '1'), ('11960', '117.136.11.1', '山东省潍坊市', '移动', '0', '2010-05-23', '1'), ('11961', '117.136.11.40', '山东省潍坊市', '移动', '0', '2010-05-24', '1'), ('11962', '117.136.9.186', '山东省潍坊市', '移动', '0', '2010-05-24', '1'), ('11963', '117.136.6.9', '辽宁省本溪市', '移动', '0', '2010-05-25', '1'), ('11964', '117.136.23.107', '中国', '移动', '0', '2010-05-25', '1'), ('11965', '117.136.6.18', '辽宁省本溪市', '移动', '0', '2010-05-25', '1'), ('11966', '117.136.1.47', '中国', '移动', '0', '2010-05-25', '1'), ('11967', '117.136.1.74', '中国', '移动', '0', '2010-05-26', '1'), ('11968', '117.136.0.64', '中国', '移动', '0', '2010-05-26', '1'), ('11969', '117.136.15.43', '中国', '移动', '0', '2010-05-26', '1'), ('11970', '117.136.0.80', '中国', '移动', '0', '2010-05-26', '1'), ('11971', '117.136.17.139', '中国', '移动', '0', '2010-05-27', '1'), ('11972', '117.136.1.91', '中国', '移动', '0', '2010-05-27', '1'), ('11973', '117.136.6.21', '辽宁省本溪市', '移动', '0', '2010-05-28', '1'), ('11974', '117.136.11.6', '山东省潍坊市', '移动', '0', '2010-05-29', '1'), ('11975', '117.136.15.17', '中国', '移动', '0', '2010-05-29', '1'), ('11976', '117.136.6.14', '辽宁省本溪市', '移动', '0', '2010-05-29', '1'), ('11977', '117.136.23.198', '中国', '移动', '0', '2010-05-29', '1'), ('11978', '117.136.21.165', '中国', '移动', '0', '2010-05-29', '1'), ('11979', '117.136.1.181', '中国', '移动', '0', '2010-05-30', '1'), ('11980', '117.136.15.19', '中国', '移动', '0', '2010-05-30', '1'), ('11981', '117.136.1.59', '中国', '移动', '0', '2010-05-30', '1'), ('11982', '221.179.185.209', '重庆市', '移动', '0', '2010-05-30', '1'), ('11983', '117.136.22.238', '中国', '移动', '0', '2010-05-30', '1'), ('11984', '117.136.11.45', '山东省潍坊市', '移动', '0', '2010-05-31', '1'), ('11985', '117.136.1.206', '中国', '移动', '0', '2010-05-31', '1'), ('11986', '117.136.23.249', '中国', '移动', '0', '2010-05-31', '1'), ('11987', '117.136.23.246', '中国', '移动', '0', '2010-05-31', '1'), ('11988', '117.136.11.8', '山东省潍坊市', '移动', '0', '2010-05-31', '1'), ('11989', '117.136.23.135', '中国', '移动', '0', '2010-06-01', '1'), ('11990', '117.136.11.2', '山东省潍坊市', '移动', '0', '2010-06-01', '1'), ('11991', '117.136.1.95', '中国', '移动', '0', '2010-06-01', '1'), ('11992', '117.136.23.24', '中国', '移动', '0', '2010-06-01', '1'), ('11993', '117.136.1.81', '中国', '移动', '0', '2010-06-02', '1'), ('11994', '117.136.30.14', '中国', '移动', '0', '2010-06-02', '1'), ('11995', '117.136.23.132', '中国', '移动', '0', '2010-06-02', '1'), ('11996', '117.136.1.194', '中国', '移动', '0', '2010-06-02', '1'), ('11997', '117.136.11.37', '山东省潍坊市', '移动', '0', '2010-06-03', '1'), ('11998', '117.136.11.3', '山东省潍坊市', '移动', '0', '2010-06-03', '1'), ('11999', '117.136.1.122', '中国', '移动', '0', '2010-06-03', '1'), ('12000', '117.136.1.97', '中国', '移动', '0', '2010-06-04', '1'), ('12001', '117.136.21.73', '中国', '移动', '0', '2010-06-04', '1'), ('12002', '117.136.1.83', '中国', '移动', '0', '2010-06-04', '1'), ('12003', '117.136.1.166', '中国', '移动', '0', '2010-06-04', '1'), ('12004', '117.136.6.6', '辽宁省本溪市', '移动', '0', '2010-06-05', '1'), ('12005', '117.136.1.80', '中国', '移动', '0', '2010-06-05', '1'), ('12006', '117.136.1.176', '中国', '移动', '0', '2010-06-05', '1'), ('12007', '117.136.1.213', '中国', '移动', '0', '2010-06-05', '1'), ('12008', '117.136.22.134', '中国', '移动', '0', '2010-06-05', '1'), ('12009', '117.136.1.204', '中国', '移动', '0', '2010-06-05', '1'), ('12010', '117.136.22.135', '中国', '移动', '0', '2010-06-05', '1'), ('12011', '117.136.23.156', '中国', '移动', '0', '2010-06-06', '1'), ('12012', '117.136.0.218', '中国', '移动', '0', '2010-06-06', '1'), ('12013', '117.136.1.98', '中国', '移动', '0', '2010-06-06', '1'), ('12014', '117.136.6.141', '辽宁省本溪市', '移动', '0', '2010-06-07', '1'), ('12015', '117.136.1.148', '中国', '移动', '0', '2010-06-07', '1'), ('12016', '117.136.1.154', '中国', '移动', '0', '2010-06-07', '1'), ('12017', '117.136.0.200', '中国', '移动', '0', '2010-06-08', '1'), ('12018', '117.136.1.195', '中国', '移动', '0', '2010-06-08', '1'), ('12019', '117.136.1.212', '中国', '移动', '0', '2010-06-08', '1'), ('12020', '117.136.1.202', '中国', '移动', '0', '2010-06-08', '1'), ('12021', '221.176.88.9', '江西省', '移动', '0', '2010-06-08', '1'), ('12022', '117.136.1.182', '中国', '移动', '0', '2010-06-09', '1'), ('12023', '117.136.1.90', '中国', '移动', '0', '2010-06-09', '1'), ('12024', '117.136.1.192', '中国', '移动', '0', '2010-06-09', '1'), ('12025', '120.199.47.228', '浙江省', '移动', '0', '2010-06-09', '1'), ('12026', '117.136.1.173', '中国', '移动', '0', '2010-06-09', '1'), ('12027', '117.136.1.138', '中国', '移动', '0', '2010-06-09', '1'), ('12028', '117.136.21.223', '中国', '移动', '0', '2010-06-09', '1'), ('12029', '117.136.11.12', '山东省潍坊市', '移动', '0', '2010-06-10', '1'), ('12030', '117.136.1.62', '中国', '移动', '0', '2010-06-10', '1'), ('12031', '117.136.1.196', '中国', '移动', '0', '2010-06-10', '1'), ('12032', '117.136.1.174', '中国', '移动', '0', '2010-06-10', '1'), ('12033', '117.136.1.158', '中国', '移动', '0', '2010-06-11', '1'), ('12034', '117.136.1.214', '中国', '移动', '0', '2010-06-11', '1'), ('12035', '117.136.1.217', '中国', '移动', '0', '2010-06-12', '1'), ('12036', '117.136.22.133', '中国', '移动', '0', '2010-06-12', '1'), ('12037', '117.136.1.165', '中国', '移动', '0', '2010-06-13', '1'), ('12038', '218.202.114.221', '内蒙古', '移动', '0', '2010-06-13', '1'), ('12039', '117.136.23.192', '中国', '移动', '0', '2010-06-13', '1'), ('12040', '117.136.1.167', '中国', '移动', '0', '2010-06-13', '1'), ('12041', '117.136.24.123', '中国', '移动', '0', '2010-06-14', '1'), ('12042', '117.136.1.218', '中国', '移动', '0', '2010-06-14', '1'), ('12043', '117.136.30.24', '中国', '移动', '0', '2010-06-14', '1'), ('12044', '117.136.30.15', '中国', '移动', '0', '2010-06-14', '1'), ('12045', '117.136.1.79', '中国', '移动', '0', '2010-06-14', '1'), ('12046', '117.136.24.112', '中国', '移动', '0', '2010-06-15', '1'), ('12047', '117.136.11.184', '山东省潍坊市', '移动', '0', '2010-06-15', '1'), ('12048', '117.136.1.43', '中国', '移动', '0', '2010-06-15', '1'), ('12049', '117.136.1.108', '中国', '移动', '0', '2010-06-15', '1'), ('12050', '117.136.1.198', '中国', '移动', '0', '2010-06-15', '1'), ('12051', '117.136.1.201', '中国', '移动', '0', '2010-06-16', '1'), ('12052', '117.136.1.37', '中国', '移动', '0', '2010-06-16', '1'), ('12053', '117.136.1.203', '中国', '移动', '0', '2010-06-17', '1'), ('12054', '117.136.24.89', '中国', '移动', '0', '2010-06-17', '1'), ('12055', '117.136.1.48', '中国', '移动', '0', '2010-06-17', '1'), ('12056', '117.136.1.164', '中国', '移动', '0', '2010-06-18', '1'), ('12057', '117.136.1.96', '中国', '移动', '0', '2010-06-18', '1'), ('12058', '117.136.1.147', '中国', '移动', '0', '2010-06-19', '1'), ('12059', '117.136.11.5', '山东省潍坊市', '移动', '0', '2010-06-19', '1'), ('12060', '117.136.1.187', '中国', '移动', '0', '2010-06-19', '1'), ('12061', '117.136.1.61', '中国', '移动', '0', '2010-06-19', '1'), ('12062', '117.136.1.93', '中国', '移动', '0', '2010-06-20', '1'), ('12063', '117.136.1.104', '中国', '移动', '0', '2010-06-21', '1'), ('12064', '117.136.21.42', '中国', '移动', '0', '2010-06-21', '1'), ('12065', '117.136.1.39', '中国', '移动', '0', '2010-06-21', '1'), ('12066', '211.142.239.77', '湖南省株洲市', '移动', '0', '2010-06-22', '1'), ('12067', '117.136.21.45', '中国', '移动', '0', '2010-06-22', '1'), ('12068', '117.136.15.24', '中国', '移动', '0', '2010-06-22', '1'), ('12069', '117.136.9.6', '山东省潍坊市', '移动', '0', '2010-06-24', '1'), ('12070', '117.136.1.171', '中国', '移动', '0', '2010-06-24', '1'), ('12071', '211.139.16.201', '云南省昆明市', '移动', '0', '2010-06-25', '1'), ('12072', '117.136.21.66', '中国', '移动', '0', '2010-06-25', '1'), ('12073', '117.136.1.163', '中国', '移动', '0', '2010-06-25', '1'), ('12074', '117.136.24.140', '中国', '移动', '0', '2010-06-26', '1'), ('12075', '117.136.29.58', '中国', '移动', '0', '2010-06-26', '1'), ('12076', '117.136.23.201', '中国', '移动', '0', '2010-06-27', '1'), ('12077', '117.136.23.138', '中国', '移动', '0', '2010-06-28', '1'), ('12078', '117.136.23.167', '中国', '移动', '0', '2010-06-28', '1'), ('12079', '117.136.0.235', '中国', '移动', '0', '2010-07-01', '1'), ('12080', '117.136.23.212', '中国', '移动', '0', '2010-07-02', '1'), ('12081', '211.139.16.197', '云南省昆明市', '移动', '0', '2010-07-02', '1'), ('12082', '117.136.24.145', '中国', '移动', '0', '2010-07-02', '1'), ('12083', '117.136.1.119', '中国', '移动', '0', '2010-07-02', '1'), ('12084', '117.136.1.207', '中国', '移动', '0', '2010-07-03', '1'), ('12085', '117.136.1.224', '中国', '移动', '0', '2010-07-03', '1'), ('12086', '117.136.1.35', '中国', '移动', '0', '2010-07-03', '1'), ('12087', '117.136.1.216', '中国', '移动', '0', '2010-07-04', '1'), ('12088', '117.136.0.89', '中国', '移动', '0', '2010-07-04', '1'), ('12089', '117.136.24.135', '中国', '移动', '0', '2010-07-04', '1'), ('12090', '117.136.11.186', '山东省潍坊市', '移动', '0', '2010-07-05', '1'), ('12091', '117.136.0.66', '中国', '移动', '0', '2010-07-05', '1'), ('12092', '117.136.1.42', '中国', '移动', '0', '2010-07-05', '1'), ('12093', '117.136.0.211', '中国', '移动', '0', '2010-07-06', '1'), ('12094', '117.136.1.105', '中国', '移动', '0', '2010-07-06', '1'), ('12095', '117.136.24.13', '中国', '移动', '0', '2010-07-07', '1'), ('12096', '117.136.1.200', '中国', '移动', '0', '2010-07-07', '1'), ('12097', '117.136.24.97', '中国', '移动', '0', '2010-07-07', '1'), ('12098', '117.136.1.175', '中国', '移动', '0', '2010-07-08', '1'), ('12099', '117.136.1.210', '中国', '移动', '0', '2010-07-08', '1'), ('12100', '117.136.1.193', '中国', '移动', '0', '2010-07-08', '1'), ('12101', '221.131.128.202', '江苏省南京市', '移动', '0', '2010-07-08', '1'), ('12102', '221.131.128.200', '江苏省南京市', '移动', '0', '2010-07-08', '1'), ('12103', '117.136.1.88', '中国', '移动', '0', '2010-07-09', '1'), ('12104', '221.131.128.201', '江苏省南京市', '移动', '0', '2010-07-09', '1'), ('12105', '117.136.1.86', '中国', '移动', '0', '2010-07-10', '1'), ('12106', '117.136.1.77', '中国', '移动', '0', '2010-07-10', '1'), ('12107', '117.136.1.70', '中国', '移动', '0', '2010-07-11', '1'), ('12108', '117.136.1.33', '中国', '移动', '0', '2010-07-11', '1'), ('12109', '117.136.0.67', '中国', '移动', '0', '2010-07-12', '1'), ('12110', '117.136.0.95', '中国', '移动', '0', '2010-07-12', '1'), ('12111', '117.136.1.82', '中国', '移动', '0', '2010-07-12', '1'), ('12112', '117.136.1.53', '中国', '移动', '0', '2010-07-13', '1'), ('12113', '117.136.11.7', '山东省潍坊市', '移动', '0', '2010-07-13', '1'), ('12114', '117.136.0.251', '中国', '移动', '0', '2010-07-13', '1'), ('12115', '117.136.1.99', '中国', '移动', '0', '2010-07-13', '1'), ('12116', '117.136.2.21', '中国', '移动', '0', '2010-07-13', '1'), ('12117', '117.136.24.124', '中国', '移动', '0', '2010-07-14', '1'), ('12118', '117.136.1.188', '中国', '移动', '0', '2010-07-15', '1'), ('12119', '117.136.1.183', '中国', '移动', '0', '2010-07-15', '1'), ('12120', '117.136.16.95', '中国', '移动', '0', '2010-07-15', '1'), ('12121', '117.136.1.113', '中国', '移动', '0', '2010-07-15', '1'), ('12122', '117.136.0.87', '中国', '移动', '0', '2010-07-15', '1'), ('12123', '117.136.0.90', '中国', '移动', '0', '2010-07-15', '1'), ('12124', '117.136.1.94', '中国', '移动', '0', '2010-07-15', '1'), ('12125', '117.136.0.195', '中国', '移动', '0', '2010-07-16', '1'), ('12126', '117.136.16.92', '中国', '移动', '0', '2010-07-16', '1'), ('12127', '117.136.24.84', '中国', '移动', '0', '2010-07-16', '1'), ('12128', '117.136.1.107', '中国', '移动', '0', '2010-07-16', '1'), ('12129', '117.136.1.101', '中国', '移动', '0', '2010-07-17', '1'), ('12130', '117.136.1.60', '中国', '移动', '0', '2010-07-17', '1'), ('12131', '117.136.24.94', '中国', '移动', '0', '2010-07-18', '1'), ('12132', '117.136.0.244', '中国', '移动', '0', '2010-07-18', '1'), ('12133', '117.136.1.51', '中国', '移动', '0', '2010-07-18', '1'), ('12134', '117.136.11.146', '山东省潍坊市', '移动', '0', '2010-07-18', '1'), ('12135', '117.136.16.98', '中国', '移动', '0', '2010-07-19', '1'), ('12136', '117.136.11.153', '山东省潍坊市', '移动', '0', '2010-07-20', '1'), ('12137', '117.136.0.229', '中国', '移动', '0', '2010-07-20', '1'), ('12138', '117.136.0.248', '中国', '移动', '0', '2010-07-20', '1'), ('12139', '117.136.6.22', '辽宁省本溪市', '移动', '0', '2010-07-21', '1'), ('12140', '117.136.16.94', '中国', '移动', '0', '2010-07-21', '1'), ('12141', '117.136.16.87', '中国', '移动', '0', '2010-07-23', '1'), ('12142', '117.136.1.76', '中国', '移动', '0', '2010-07-23', '1'), ('12143', '117.136.0.249', '中国', '移动', '0', '2010-07-23', '1'), ('12144', '117.136.1.87', '中国', '移动', '0', '2010-07-24', '1'), ('12145', '117.136.1.78', '中国', '移动', '0', '2010-07-24', '1'), ('12146', '117.136.16.93', '中国', '移动', '0', '2010-07-24', '1'), ('12147', '117.136.26.9', '中国', '移动', '0', '2010-07-24', '1'), ('12148', '117.136.24.40', '中国', '移动', '0', '2010-07-24', '1'), ('12149', '117.136.1.123', '中国', '移动', '0', '2010-07-24', '1'), ('12150', '117.136.1.52', '中国', '移动', '0', '2010-07-25', '1'), ('12151', '117.136.23.165', '中国', '移动', '0', '2010-07-25', '1'), ('12152', '117.136.0.74', '中国', '移动', '0', '2010-07-25', '1'), ('12153', '117.136.1.49', '中国', '移动', '0', '2010-07-26', '1'), ('12154', '117.136.1.64', '中国', '移动', '0', '2010-07-26', '1'), ('12155', '117.136.1.110', '中国', '移动', '0', '2010-07-27', '1'), ('12156', '117.136.1.50', '中国', '移动', '0', '2010-07-27', '1'), ('12157', '117.136.4.237', '辽宁省本溪市', '移动', '0', '2010-07-27', '1'), ('12158', '120.196.208.73', '中国', '移动', '0', '2010-07-27', '1'), ('12159', '120.196.208.79', '中国', '移动', '0', '2010-07-28', '1'), ('12160', '117.136.6.31', '辽宁省本溪市', '移动', '0', '2010-07-28', '1'), ('12161', '120.196.208.76', '中国', '移动', '0', '2010-07-28', '1'), ('12162', '117.136.16.81', '中国', '移动', '0', '2010-07-28', '1'), ('12163', '117.136.4.236', '辽宁省本溪市', '移动', '0', '2010-07-28', '1'), ('12164', '117.136.9.162', '山东省潍坊市', '移动', '0', '2010-07-29', '1'), ('12165', '117.136.1.223', '中国', '移动', '0', '2010-07-29', '1'), ('12166', '117.136.16.86', '中国', '移动', '0', '2010-07-29', '1'), ('12167', '117.136.0.209', '中国', '移动', '0', '2010-07-29', '1'), ('12168', '218.206.244.46', '河南省郑州市', '移动', '0', '2010-07-29', '1'), ('12169', '117.136.0.232', '中国', '移动', '0', '2010-07-29', '1'), ('12170', '117.136.4.235', '辽宁省本溪市', '移动', '0', '2010-07-30', '1'), ('12171', '211.138.129.190', '浙江省', '移动', '0', '2010-07-30', '1'), ('12172', '211.138.129.201', '浙江省', '移动', '0', '2010-07-30', '1'), ('12173', '117.136.0.205', '中国', '移动', '0', '2010-07-30', '1'), ('12174', '211.138.129.196', '浙江省', '移动', '0', '2010-07-30', '1'), ('12175', '117.136.1.209', '中国', '移动', '0', '2010-07-30', '1'), ('12176', '117.136.11.149', '山东省潍坊市', '移动', '0', '2010-07-31', '1'), ('12177', '117.136.29.51', '中国', '移动', '0', '2010-07-31', '1'), ('12178', '117.136.0.207', '中国', '移动', '0', '2010-07-31', '1'), ('12179', '117.136.16.91', '中国', '移动', '0', '2010-07-31', '1'), ('12180', '117.136.23.174', '中国', '移动', '0', '2010-07-31', '1'), ('12181', '117.136.0.227', '中国', '移动', '0', '2010-08-01', '1'), ('12182', '117.136.11.15', '山东省潍坊市', '移动', '0', '2010-08-01', '1'), ('12183', '117.136.0.254', '中国', '移动', '0', '2010-08-02', '1'), ('12184', '117.136.0.88', '中国', '移动', '0', '2010-08-02', '1'), ('12185', '117.136.23.231', '中国', '移动', '0', '2010-08-02', '1'), ('12186', '117.136.0.217', '中国', '移动', '0', '2010-08-03', '1'), ('12187', '117.136.1.186', '中国', '移动', '0', '2010-08-04', '1'), ('12188', '117.136.16.84', '中国', '移动', '0', '2010-08-04', '1'), ('12189', '117.136.0.94', '中国', '移动', '0', '2010-08-04', '1'), ('12190', '117.136.1.36', '中国', '移动', '0', '2010-08-05', '1'), ('12191', '117.136.1.41', '中国', '移动', '0', '2010-08-05', '1'), ('12192', '117.136.16.85', '中国', '移动', '0', '2010-08-05', '1'), ('12193', '117.136.1.172', '中国', '移动', '0', '2010-08-05', '1'), ('12194', '117.136.1.69', '中国', '移动', '0', '2010-08-05', '1'), ('12195', '117.136.1.117', '中国', '移动', '0', '2010-08-06', '1'), ('12196', '117.136.23.129', '中国', '移动', '0', '2010-08-06', '1'), ('12197', '117.136.16.203', '中国', '移动', '0', '2010-08-07', '1'), ('12198', '117.136.11.156', '山东省潍坊市', '移动', '0', '2010-08-08', '1'), ('12199', '117.136.11.151', '山东省潍坊市', '移动', '0', '2010-08-08', '1'), ('12200', '211.143.54.67', '河北省', '移动', '0', '2010-08-09', '1'), ('12201', '117.136.0.243', '中国', '移动', '0', '2010-08-09', '1'), ('12202', '117.136.1.114', '中国', '移动', '0', '2010-08-09', '1'), ('12203', '117.136.0.197', '中国', '移动', '0', '2010-08-09', '1'), ('12204', '117.136.0.76', '中国', '移动', '0', '2010-08-10', '1'), ('12205', '117.136.16.96', '中国', '移动', '0', '2010-08-10', '1'), ('12206', '221.130.131.245', '中国', '移动', '0', '2010-08-10', '1'), ('12207', '221.130.131.242', '中国', '移动', '0', '2010-08-10', '1'), ('12208', '221.130.131.244', '中国', '移动', '0', '2010-08-10', '1'), ('12209', '221.130.131.241', '中国', '移动', '0', '2010-08-11', '1'), ('12210', '221.130.131.243', '中国', '移动', '0', '2010-08-11', '1'), ('12211', '117.136.24.20', '中国', '移动', '0', '2010-08-13', '1'), ('12212', '117.136.23.153', '中国', '移动', '0', '2010-08-15', '1'), ('12213', '117.136.24.28', '中国', '移动', '0', '2010-08-15', '1'), ('12214', '117.136.4.224', '辽宁省本溪市', '移动', '0', '2010-08-15', '1'), ('12215', '117.136.4.228', '辽宁省本溪市', '移动', '0', '2010-08-15', '1'), ('12216', '117.136.1.65', '中国', '移动', '0', '2010-08-15', '1'), ('12217', '117.136.1.103', '中国', '移动', '0', '2010-08-15', '1'), ('12218', '117.136.4.233', '辽宁省本溪市', '移动', '0', '2010-08-16', '1'), ('12219', '117.136.1.44', '中国', '移动', '0', '2010-08-16', '1'), ('12220', '117.136.9.36', '山东省潍坊市', '移动', '0', '2010-08-16', '1'), ('12221', '117.136.11.14', '山东省潍坊市', '移动', '0', '2010-08-17', '1'), ('12222', '117.136.4.238', '辽宁省本溪市', '移动', '0', '2010-08-18', '1'), ('12223', '117.136.4.232', '辽宁省本溪市', '移动', '0', '2010-08-19', '1'), ('12224', '117.136.4.234', '辽宁省本溪市', '移动', '0', '2010-08-20', '1'), ('12225', '218.205.245.8', '四川省', '移动', '0', '2010-08-20', '1'), ('12226', '218.205.245.10', '四川省', '移动', '0', '2010-08-21', '1'), ('12227', '218.205.245.7', '四川省', '移动', '0', '2010-08-21', '1'), ('12228', '218.205.245.9', '四川省', '移动', '0', '2010-08-21', '1'), ('12229', '117.136.1.54', '中国', '移动', '0', '2010-08-21', '1'), ('12230', '117.136.12.133', '中国', '移动', '0', '2010-08-22', '1'), ('12231', '117.136.11.177', '山东省潍坊市', '移动', '0', '2010-08-22', '1'), ('12232', '117.136.0.83', '中国', '移动', '0', '2010-08-22', '1'), ('12233', '117.136.1.121', '中国', '移动', '0', '2010-08-22', '1'), ('12234', '117.136.30.91', '中国', '移动', '0', '2010-08-23', '1'), ('12235', '117.136.30.9', '中国', '移动', '0', '2010-08-23', '1'), ('12236', '117.136.12.134', '中国', '移动', '0', '2010-08-24', '1'), ('12237', '117.136.16.97', '中国', '移动', '0', '2010-08-24', '1'), ('12238', '117.136.1.58', '中国', '移动', '0', '2010-08-24', '1'), ('12239', '117.136.1.55', '中国', '移动', '0', '2010-08-24', '1'), ('12240', '117.136.1.38', '中国', '移动', '0', '2010-08-25', '1'), ('12241', '117.136.23.203', '中国', '移动', '0', '2010-08-25', '1'), ('12242', '117.136.1.161', '中国', '移动', '0', '2010-08-25', '1'), ('12243', '211.143.168.252', '福建省', '移动', '0', '2010-08-26', '1'), ('12244', '117.136.16.200', '中国', '移动', '0', '2010-08-27', '1'), ('12245', '211.138.129.131', '浙江省', '移动', '0', '2010-08-27', '1'), ('12246', '211.138.129.132', '浙江省', '移动', '0', '2010-08-27', '1'), ('12247', '117.136.1.34', '中国', '移动', '0', '2010-08-27', '1'), ('12248', '117.136.16.205', '中国', '移动', '0', '2010-08-28', '1'), ('12249', '117.136.0.240', '中国', '移动', '0', '2010-08-28', '1'), ('12250', '117.136.9.230', '山东省潍坊市', '移动', '0', '2010-08-28', '1'), ('12251', '117.136.23.149', '中国', '移动', '0', '2010-08-29', '1'), ('12252', '117.136.1.184', '中国', '移动', '0', '2010-08-29', '1'), ('12253', '117.136.1.109', '中国', '移动', '0', '2010-08-29', '1'), ('12254', '117.136.0.81', '中国', '移动', '0', '2010-08-30', '1'), ('12255', '117.136.21.55', '中国', '移动', '0', '2010-08-30', '1'), ('12256', '117.136.1.197', '中国', '移动', '0', '2010-08-30', '1'), ('12257', '117.136.21.39', '中国', '移动', '0', '2010-09-01', '1'), ('12258', '117.136.1.106', '中国', '移动', '0', '2010-09-01', '1'), ('12259', '117.136.4.229', '辽宁省本溪市', '移动', '0', '2010-09-02', '1'), ('12260', '117.136.1.178', '中国', '移动', '0', '2010-09-02', '1'), ('12261', '117.136.16.194', '中国', '移动', '0', '2010-09-02', '1'), ('12262', '117.136.16.199', '中国', '移动', '0', '2010-09-03', '1'), ('12263', '117.136.0.231', '中国', '移动', '0', '2010-09-03', '1'), ('12264', '117.136.24.17', '中国', '移动', '0', '2010-09-03', '1'), ('12265', '117.136.0.206', '中国', '移动', '0', '2010-09-04', '1'), ('12266', '117.136.0.194', '中国', '移动', '0', '2010-09-04', '1'), ('12267', '117.136.0.236', '中国', '移动', '0', '2010-09-06', '1'), ('12268', '117.136.1.89', '中国', '移动', '0', '2010-09-06', '1'), ('12269', '117.136.0.198', '中国', '移动', '0', '2010-09-06', '1'), ('12270', '117.136.0.202', '中国', '移动', '0', '2010-09-07', '1'), ('12271', '117.136.23.242', '中国', '移动', '0', '2010-09-07', '1'), ('12272', '117.136.16.202', '中国', '移动', '0', '2010-09-08', '1'), ('12273', '117.136.11.9', '山东省潍坊市', '移动', '0', '2010-09-08', '1'), ('12274', '117.136.0.224', '中国', '移动', '0', '2010-09-08', '1'), ('12275', '117.136.0.196', '中国', '移动', '0', '2010-09-09', '1'), ('12276', '117.136.1.111', '中国', '移动', '0', '2010-09-09', '1'), ('12277', '117.136.1.84', '中国', '移动', '0', '2010-09-09', '1'), ('12278', '117.136.0.241', '中国', '移动', '0', '2010-09-09', '1'), ('12279', '117.136.0.219', '中国', '移动', '0', '2010-09-09', '1'), ('12280', '117.136.0.242', '中国', '移动', '0', '2010-09-09', '1'), ('12281', '117.136.0.201', '中国', '移动', '0', '2010-09-10', '1'), ('12282', '117.136.9.163', '山东省潍坊市', '移动', '0', '2010-09-10', '1'), ('12283', '117.136.16.201', '中国', '移动', '0', '2010-09-11', '1'), ('12284', '117.136.1.92', '中国', '移动', '0', '2010-09-11', '1'), ('12285', '117.136.0.237', '中国', '移动', '0', '2010-09-11', '1'), ('12286', '117.136.9.189', '山东省潍坊市', '移动', '0', '2010-09-11', '1'), ('12287', '211.138.124.202', '浙江省', '移动', '0', '2010-09-11', '1'), ('12288', '221.130.162.232', '中国', '移动', '0', '2010-09-11', '1'), ('12289', '117.136.0.72', '中国', '移动', '0', '2010-09-11', '1'), ('12290', '117.136.16.196', '中国', '移动', '0', '2010-09-12', '1'), ('12291', '117.136.21.40', '中国', '移动', '0', '2010-09-12', '1'), ('12292', '117.136.0.228', '中国', '移动', '0', '2010-09-12', '1'), ('12293', '117.136.6.19', '辽宁省本溪市', '移动', '0', '2010-09-12', '1'), ('12294', '117.136.16.198', '中国', '移动', '0', '2010-09-13', '1'), ('12295', '117.136.26.141', '中国', '移动', '0', '2010-09-13', '1'), ('12296', '117.136.4.230', '辽宁省本溪市', '移动', '0', '2010-09-13', '1'), ('12297', '117.136.28.5', '中国', '移动', '0', '2010-09-13', '1'), ('12298', '117.136.26.140', '中国', '移动', '0', '2010-09-14', '1'), ('12299', '117.136.4.225', '辽宁省本溪市', '移动', '0', '2010-09-15', '1'), ('12300', '117.136.0.220', '中国', '移动', '0', '2010-09-15', '1'), ('12301', '117.136.9.235', '山东省潍坊市', '移动', '0', '2010-09-15', '1'), ('12302', '117.136.16.195', '中国', '移动', '0', '2010-09-15', '1'), ('12303', '117.136.28.15', '中国', '移动', '0', '2010-09-15', '1'), ('12304', '117.136.30.1', '中国', '移动', '0', '2010-09-16', '1'), ('12305', '117.136.29.57', '中国', '移动', '0', '2010-09-16', '1'), ('12306', '117.136.0.246', '中国', '移动', '0', '2010-09-16', '1'), ('12307', '117.136.30.93', '中国', '移动', '0', '2010-09-16', '1'), ('12308', '117.136.16.206', '中国', '移动', '0', '2010-09-17', '1'), ('12309', '117.136.0.225', '中国', '移动', '0', '2010-09-18', '1'), ('12310', '117.136.1.75', '中国', '移动', '0', '2010-09-18', '1'), ('12311', '112.4.2.43', '江苏省', '移动', '0', '2010-09-18', '1'), ('12312', '112.4.2.42', '江苏省', '移动', '0', '2010-09-18', '1'), ('12313', '117.136.16.204', '中国', '移动', '0', '2010-09-18', '1'), ('12314', '112.4.2.44', '江苏省', '移动', '0', '2010-09-18', '1'), ('12315', '117.135.129.28', '中国', '移动', '0', '2010-09-18', '1'), ('12316', '112.4.2.45', '江苏省', '移动', '0', '2010-09-19', '1'), ('12317', '117.136.0.253', '中国', '移动', '0', '2010-09-19', '1'), ('12318', '117.136.1.63', '中国', '移动', '0', '2010-09-19', '1'), ('12319', '111.2.93.250', '中国', '移动', '0', '2010-09-19', '1'), ('12320', '211.138.129.208', '浙江省', '移动', '0', '2010-09-21', '1'), ('12321', '117.136.1.73', '中国', '移动', '0', '2010-09-22', '1');
INSERT INTO `ig_gateway` VALUES ('12322', '117.136.11.188', '山东省潍坊市', '移动', '0', '2010-09-23', '1'), ('12323', '117.136.9.5', '山东省潍坊市', '移动', '0', '2010-09-23', '1'), ('12324', '117.136.19.148', '中国', '移动', '0', '2010-09-26', '1'), ('12325', '117.136.28.11', '中国', '移动', '0', '2010-09-26', '1'), ('12326', '117.135.128.246', '中国', '移动', '0', '2010-09-26', '1'), ('12327', '117.136.16.83', '中国', '移动', '0', '2010-09-26', '1'), ('12328', '221.178.39.9', '重庆市', '移动', '0', '2010-09-27', '1'), ('12329', '117.136.0.233', '中国', '移动', '0', '2010-09-28', '1'), ('12330', '117.136.4.239', '辽宁省本溪市', '移动', '0', '2010-09-28', '1'), ('12331', '117.136.21.49', '中国', '移动', '0', '2010-09-28', '1'), ('12332', '211.137.41.204', '辽宁省', '移动', '0', '2010-09-29', '1'), ('12333', '117.136.19.143', '中国', '移动', '0', '2010-09-29', '1'), ('12334', '117.136.30.8', '中国', '移动', '0', '2010-09-29', '1'), ('12335', '117.136.19.142', '中国', '移动', '0', '2010-09-29', '1'), ('12336', '117.136.19.146', '中国', '移动', '0', '2010-09-29', '1'), ('12337', '120.196.220.21', '中国', '移动', '0', '2010-09-29', '1'), ('12338', '211.137.41.202', '辽宁省', '移动', '0', '2010-09-30', '1'), ('12339', '117.136.0.208', '中国', '移动', '0', '2010-09-30', '1'), ('12340', '211.137.41.205', '辽宁省', '移动', '0', '2010-09-30', '1'), ('12341', '211.137.41.203', '辽宁省', '移动', '0', '2010-09-30', '1'), ('12342', '117.136.28.3', '中国', '移动', '0', '2010-09-30', '1'), ('12343', '117.136.0.247', '中国', '移动', '0', '2010-10-01', '1'), ('12344', '117.136.26.8', '中国', '移动', '0', '2010-10-01', '1'), ('12345', '117.136.19.144', '中国', '移动', '0', '2010-10-01', '1'), ('12346', '117.136.0.239', '中国', '移动', '0', '2010-10-01', '1'), ('12347', '117.136.0.210', '中国', '移动', '0', '2010-10-02', '1'), ('12348', '117.136.16.193', '中国', '移动', '0', '2010-10-02', '1'), ('12349', '117.136.1.72', '中国', '移动', '0', '2010-10-03', '1'), ('12350', '117.136.19.147', '中国', '移动', '0', '2010-10-03', '1'), ('12351', '117.136.9.225', '山东省潍坊市', '移动', '0', '2010-10-04', '1'), ('12352', '117.136.19.150', '中国', '移动', '0', '2010-10-05', '1'), ('12353', '117.136.19.145', '中国', '移动', '0', '2010-10-07', '1'), ('12354', '117.136.24.27', '中国', '移动', '0', '2010-10-07', '1'), ('12355', '117.136.1.116', '中国', '移动', '0', '2010-10-11', '1'), ('12356', '117.136.31.99', '中国', '移动', '0', '2010-10-11', '1'), ('12357', '117.136.26.143', '中国', '移动', '0', '2010-10-12', '1'), ('12358', '211.138.184.196', '安徽省', '移动', '0', '2010-10-12', '1'), ('12359', '117.136.0.212', '中国', '移动', '0', '2010-10-13', '1'), ('12360', '117.136.0.245', '中国', '移动', '0', '2010-10-13', '1'), ('12361', '117.136.30.27', '中国', '移动', '0', '2010-10-13', '1'), ('12362', '117.136.0.215', '中国', '移动', '0', '2010-10-13', '1'), ('12363', '117.136.19.149', '中国', '移动', '0', '2010-10-13', '1'), ('12364', '117.136.26.139', '中国', '移动', '0', '2010-10-14', '1'), ('12365', '117.136.9.224', '山东省潍坊市', '移动', '0', '2010-10-15', '1'), ('12366', '117.136.26.142', '中国', '移动', '0', '2010-10-15', '1'), ('12367', '117.136.9.184', '山东省潍坊市', '移动', '0', '2010-10-15', '1'), ('12368', '117.136.5.138', '辽宁省本溪市', '移动', '0', '2010-10-16', '1'), ('12369', '117.136.31.91', '中国', '移动', '0', '2010-10-16', '1'), ('12370', '117.136.9.227', '山东省潍坊市', '移动', '0', '2010-10-17', '1'), ('12371', '117.136.13.242', '中国', '移动', '0', '2010-10-18', '1'), ('12372', '117.136.1.102', '中国', '移动', '0', '2010-10-19', '1'), ('12373', '211.143.50.6', '河北省', '移动', '0', '2010-10-20', '1'), ('12374', '211.143.50.4', '河北省', '移动', '0', '2010-10-20', '1'), ('12375', '117.136.13.241', '中国', '移动', '0', '2010-10-20', '1'), ('12376', '211.143.50.3', '河北省', '移动', '0', '2010-10-20', '1'), ('12377', '117.136.31.153', '中国', '移动', '0', '2010-10-20', '1'), ('12378', '117.136.31.154', '中国', '移动', '0', '2010-10-20', '1'), ('12379', '211.137.220.152', '吉林省', '移动', '0', '2010-10-21', '1'), ('12380', '211.137.220.151', '吉林省', '移动', '0', '2010-10-21', '1'), ('12381', '211.143.50.5', '河北省', '移动', '0', '2010-10-22', '1'), ('12382', '117.136.1.185', '中国', '移动', '0', '2010-10-22', '1'), ('12383', '117.136.1.222', '中国', '移动', '0', '2010-10-23', '1'), ('12384', '117.136.19.180', '中国', '移动', '0', '2010-10-23', '1'), ('12385', '117.136.1.40', '中国', '移动', '0', '2010-10-23', '1'), ('12386', '117.136.31.146', '中国', '移动', '0', '2010-10-24', '1'), ('12387', '117.136.31.145', '中国', '移动', '0', '2010-10-24', '1'), ('12388', '117.136.19.181', '中国', '移动', '0', '2010-10-25', '1'), ('12389', '218.202.227.162', '上海市', '移动', '0', '2010-10-25', '1'), ('12390', '117.136.23.155', '中国', '移动', '0', '2010-10-26', '1'), ('12391', '117.136.28.16', '中国', '移动', '0', '2010-10-26', '1'), ('12392', '211.143.50.68', '河北省', '移动', '0', '2010-10-26', '1'), ('12393', '211.138.129.205', '浙江省', '移动', '0', '2010-10-26', '1'), ('12394', '117.136.1.12', '中国', '移动', '0', '2010-10-27', '1'), ('12395', '211.143.50.69', '河北省', '移动', '0', '2010-10-28', '1'), ('12396', '211.143.50.67', '河北省', '移动', '0', '2010-10-28', '1'), ('12397', '117.136.24.152', '中国', '移动', '0', '2010-10-29', '1'), ('12398', '211.137.119.24', '陕西省西安市', '移动', '0', '2010-10-29', '1'), ('12399', '211.143.50.70', '河北省', '移动', '0', '2010-10-29', '1'), ('12400', '211.137.119.22', '陕西省西安市', '移动', '0', '2010-10-29', '1'), ('12401', '211.137.119.21', '陕西省西安市', '移动', '0', '2010-10-29', '1'), ('12402', '117.136.19.182', '中国', '移动', '0', '2010-10-29', '1'), ('12403', '117.136.28.12', '中国', '移动', '0', '2010-10-29', '1'), ('12404', '211.137.119.25', '陕西省西安市', '移动', '0', '2010-10-29', '1'), ('12405', '211.138.129.207', '浙江省', '移动', '0', '2010-10-30', '1'), ('12406', '211.138.129.203', '浙江省', '移动', '0', '2010-10-30', '1'), ('12407', '211.138.129.204', '浙江省', '移动', '0', '2010-10-30', '1'), ('12408', '211.138.129.209', '浙江省', '移动', '0', '2010-10-30', '1'), ('12409', '211.138.129.206', '浙江省', '移动', '0', '2010-10-30', '1'), ('12410', '211.138.129.202', '浙江省', '移动', '0', '2010-10-30', '1'), ('12411', '117.136.28.2', '中国', '移动', '0', '2010-10-30', '1'), ('12412', '117.136.1.67', '中国', '移动', '0', '2010-10-30', '1'), ('12413', '117.136.31.96', '中国', '移动', '0', '2010-10-30', '1'), ('12414', '218.205.220.100', '北京市', '移动', '0', '2010-10-30', '1'), ('12415', '117.136.28.7', '中国', '移动', '0', '2010-10-31', '1'), ('12416', '117.136.28.10', '中国', '移动', '0', '2010-10-31', '1'), ('12417', '211.137.119.23', '陕西省西安市', '移动', '0', '2010-10-31', '1'), ('12418', '117.136.28.6', '中国', '移动', '0', '2010-10-31', '1'), ('12419', '117.136.1.179', '中国', '移动', '0', '2010-11-01', '1'), ('12420', '117.136.28.13', '中国', '移动', '0', '2010-11-01', '1'), ('12421', '117.136.1.45', '中国', '移动', '0', '2010-11-01', '1'), ('12422', '117.136.12.195', '中国', '移动', '0', '2010-11-01', '1'), ('12423', '117.136.24.144', '中国', '移动', '0', '2010-11-02', '1'), ('12424', '117.136.23.210', '中国', '移动', '0', '2010-11-02', '1'), ('12425', '117.136.31.150', '中国', '移动', '0', '2010-11-02', '1'), ('12426', '117.136.31.94', '中国', '移动', '0', '2010-11-02', '1'), ('12427', '117.136.31.158', '中国', '移动', '0', '2010-11-03', '1'), ('12428', '221.176.5.153', '江西省', '移动', '0', '2010-11-03', '1'), ('12429', '117.136.30.65', '中国', '移动', '0', '2010-11-03', '1'), ('12430', '117.136.31.101', '中国', '移动', '0', '2010-11-03', '1'), ('12431', '117.136.1.9', '中国', '移动', '0', '2010-11-03', '1'), ('12432', '117.136.31.157', '中国', '移动', '0', '2010-11-03', '1'), ('12433', '117.136.1.112', '中国', '移动', '0', '2010-11-03', '1'), ('12434', '117.136.31.149', '中国', '移动', '0', '2010-11-03', '1'), ('12435', '117.136.9.188', '山东省潍坊市', '移动', '0', '2010-11-03', '1'), ('12436', '117.136.31.103', '中国', '移动', '0', '2010-11-04', '1'), ('12437', '111.1.17.254', '中国', '移动', '0', '2010-11-04', '1'), ('12438', '117.136.9.246', '山东省潍坊市', '移动', '0', '2010-11-04', '1'), ('12439', '211.141.185.131', '安徽省宿州市', '移动', '0', '2010-11-04', '1'), ('12440', '117.136.1.32', '中国', '移动', '0', '2010-11-04', '1'), ('12441', '117.136.1.2', '中国', '移动', '0', '2010-11-04', '1'), ('12442', '117.136.19.184', '中国', '移动', '0', '2010-11-05', '1'), ('12443', '117.136.19.183', '中国', '移动', '0', '2010-11-05', '1'), ('12444', '117.136.19.179', '中国', '移动', '0', '2010-11-05', '1'), ('12445', '117.136.19.177', '中国', '移动', '0', '2010-11-05', '1'), ('12446', '117.136.9.245', '山东省潍坊市', '移动', '0', '2010-11-05', '1'), ('12447', '117.136.9.247', '山东省潍坊市', '移动', '0', '2010-11-05', '1'), ('12448', '117.136.9.242', '山东省潍坊市', '移动', '0', '2010-11-05', '1'), ('12449', '117.136.1.0', '中国', '移动', '0', '2010-11-05', '1'), ('12450', '211.137.185.10', '山东省', '移动', '0', '2010-11-06', '1'), ('12451', '117.136.9.240', '山东省潍坊市', '移动', '0', '2010-11-06', '1'), ('12452', '211.137.185.7', '山东省', '移动', '0', '2010-11-06', '1'), ('12453', '111.2.87.80', '中国', '移动', '0', '2010-11-06', '1'), ('12454', '211.137.185.8', '山东省', '移动', '0', '2010-11-06', '1'), ('12455', '211.137.185.9', '山东省', '移动', '0', '2010-11-06', '1'), ('12456', '117.136.30.92', '中国', '移动', '0', '2010-11-06', '1'), ('12457', '117.136.1.4', '中国', '移动', '0', '2010-11-07', '1'), ('12458', '117.136.31.88', '中国', '移动', '0', '2010-11-07', '1'), ('12459', '117.136.1.115', '中国', '移动', '0', '2010-11-07', '1'), ('12460', '117.136.1.6', '中国', '移动', '0', '2010-11-07', '1'), ('12461', '117.136.0.216', '中国', '移动', '0', '2010-11-08', '1'), ('12462', '117.136.1.205', '中国', '移动', '0', '2010-11-08', '1'), ('12463', '221.176.5.156', '江西省', '移动', '0', '2010-11-08', '1'), ('12464', '117.136.1.8', '中国', '移动', '0', '2010-11-09', '1'), ('12465', '117.136.24.156', '中国', '移动', '0', '2010-11-09', '1'), ('12466', '117.136.24.158', '中国', '移动', '0', '2010-11-09', '1'), ('12467', '117.136.16.88', '中国', '移动', '0', '2010-11-09', '1'), ('12468', '117.136.28.14', '中国', '移动', '0', '2010-11-09', '1'), ('12469', '117.136.31.89', '中国', '移动', '0', '2010-11-09', '1'), ('12470', '117.136.31.100', '中国', '移动', '0', '2010-11-10', '1'), ('12471', '117.136.1.1', '中国', '移动', '0', '2010-11-10', '1'), ('12472', '211.141.216.146', '安徽省马鞍山市', '移动', '0', '2010-11-10', '1'), ('12473', '211.141.216.152', '安徽省马鞍山市', '移动', '0', '2010-11-10', '1'), ('12474', '211.136.115.81', '上海市', '移动', '0', '2010-11-10', '1'), ('12475', '117.136.16.197', '中国', '移动', '0', '2010-11-10', '1'), ('12476', '117.136.9.190', '山东省潍坊市', '移动', '0', '2010-11-10', '1'), ('12477', '211.136.115.83', '上海市', '移动', '0', '2010-11-11', '1'), ('12478', '221.176.5.154', '江西省', '移动', '0', '2010-11-11', '1'), ('12479', '117.136.1.120', '中国', '移动', '0', '2010-11-11', '1'), ('12480', '211.136.115.82', '上海市', '移动', '0', '2010-11-11', '1'), ('12481', '117.136.1.11', '中国', '移动', '0', '2010-11-11', '1'), ('12482', '117.136.19.178', '中国', '移动', '0', '2010-11-11', '1'), ('12483', '117.136.1.10', '中国', '移动', '0', '2010-11-11', '1'), ('12484', '117.136.23.154', '中国', '移动', '0', '2010-11-11', '1'), ('12485', '117.136.1.127', '中国', '移动', '0', '2010-11-11', '1'), ('12486', '117.136.9.248', '山东省潍坊市', '移动', '0', '2010-11-11', '1'), ('12487', '117.136.9.250', '山东省潍坊市', '移动', '0', '2010-11-12', '1'), ('12488', '117.135.129.154', '中国', '移动', '0', '2010-11-12', '1'), ('12489', '117.135.129.155', '中国', '移动', '0', '2010-11-12', '1'), ('12490', '117.135.124.170', '中国', '移动', '0', '2010-11-12', '1'), ('12491', '117.136.24.155', '中国', '移动', '0', '2010-11-13', '1'), ('12492', '117.136.31.90', '中国', '移动', '0', '2010-11-13', '1'), ('12493', '117.139.100.243', '中国', '移动', '0', '2010-11-15', '1'), ('12494', '117.136.24.12', '中国', '移动', '0', '2010-11-15', '1'), ('12495', '117.136.31.95', '中国', '移动', '0', '2010-11-16', '1'), ('12496', '117.136.11.187', '山东省潍坊市', '移动', '0', '2010-11-16', '1'), ('12497', '117.136.9.243', '山东省潍坊市', '移动', '0', '2010-11-16', '1'), ('12498', '218.205.220.93', '北京市', '移动', '0', '2010-11-16', '1'), ('12499', '117.136.1.160', '中国', '移动', '0', '2010-11-17', '1'), ('12500', '218.205.245.74', '四川省', '移动', '0', '2010-11-17', '1'), ('12501', '218.205.245.71', '四川省', '移动', '0', '2010-11-18', '1'), ('12502', '117.136.31.93', '中国', '移动', '0', '2010-11-18', '1'), ('12503', '117.136.21.57', '中国', '移动', '0', '2010-11-19', '1'), ('12504', '117.136.9.253', '山东省潍坊市', '移动', '0', '2010-11-20', '1'), ('12505', '117.136.21.64', '中国', '移动', '0', '2010-11-20', '1'), ('12506', '117.136.9.234', '山东省潍坊市', '移动', '0', '2010-11-20', '1'), ('12507', '211.138.16.227', '河南省郑州市', '移动', '0', '2010-11-21', '1'), ('12508', '117.136.1.85', '中国', '移动', '0', '2010-11-21', '1'), ('12509', '211.138.16.225', '河南省郑州市', '移动', '0', '2010-11-22', '1'), ('12510', '211.138.16.228', '河南省郑州市', '移动', '0', '2010-11-22', '1'), ('12511', '111.1.17.145', '中国', '移动', '0', '2010-11-23', '1'), ('12512', '117.136.1.125', '中国', '移动', '0', '2010-11-23', '1'), ('12513', '211.138.16.226', '河南省郑州市', '移动', '0', '2010-11-23', '1'), ('12514', '117.136.21.67', '中国', '移动', '0', '2010-11-24', '1'), ('12515', '117.136.21.72', '中国', '移动', '0', '2010-11-24', '1'), ('12516', '117.136.21.69', '中国', '移动', '0', '2010-11-24', '1'), ('12517', '117.136.21.65', '中国', '移动', '0', '2010-11-24', '1'), ('12518', '117.136.21.68', '中国', '移动', '0', '2010-11-24', '1'), ('12519', '117.136.9.249', '山东省潍坊市', '移动', '0', '2010-11-25', '1'), ('12520', '117.136.21.90', '中国', '移动', '0', '2010-11-26', '1'), ('12521', '117.136.21.93', '中国', '移动', '0', '2010-11-26', '1'), ('12522', '117.136.21.71', '中国', '移动', '0', '2010-11-26', '1'), ('12523', '218.205.245.72', '四川省', '移动', '0', '2010-11-26', '1'), ('12524', '117.136.21.94', '中国', '移动', '0', '2010-11-26', '1'), ('12525', '117.136.21.89', '中国', '移动', '0', '2010-11-26', '1'), ('12526', '117.136.21.95', '中国', '移动', '0', '2010-11-26', '1'), ('12527', '117.136.9.170', '山东省潍坊市', '移动', '0', '2010-11-26', '1'), ('12528', '117.136.0.204', '中国', '移动', '0', '2010-11-27', '1'), ('12529', '117.136.9.252', '山东省潍坊市', '移动', '0', '2010-11-27', '1'), ('12530', '117.136.0.192', '中国', '移动', '0', '2010-11-27', '1'), ('12531', '117.136.28.9', '中国', '移动', '0', '2010-11-28', '1'), ('12532', '117.136.28.4', '中国', '移动', '0', '2010-11-29', '1'), ('12533', '117.136.23.133', '中国', '移动', '0', '2010-11-29', '1'), ('12534', '117.136.2.59', '中国', '移动', '0', '2010-11-30', '1'), ('12535', '117.136.21.52', '中国', '移动', '0', '2010-11-30', '1'), ('12536', '117.136.1.126', '中国', '移动', '0', '2010-12-01', '1'), ('12537', '117.136.28.1', '中国', '移动', '0', '2010-12-01', '1'), ('12538', '117.136.24.151', '中国', '移动', '0', '2010-12-02', '1'), ('12539', '117.136.9.171', '山东省潍坊市', '移动', '0', '2010-12-02', '1'), ('12540', '117.136.24.115', '中国', '移动', '0', '2010-12-02', '1'), ('12541', '117.136.9.172', '山东省潍坊市', '移动', '0', '2010-12-02', '1'), ('12542', '117.136.9.239', '山东省潍坊市', '移动', '0', '2010-12-03', '1'), ('12543', '117.136.30.30', '中国', '移动', '0', '2010-12-04', '1'), ('12544', '117.136.2.56', '中国', '移动', '0', '2010-12-05', '1'), ('12545', '117.136.9.178', '山东省潍坊市', '移动', '0', '2010-12-05', '1'), ('12546', '117.136.2.57', '中国', '移动', '0', '2010-12-05', '1'), ('12547', '117.136.1.3', '中国', '移动', '0', '2010-12-06', '1'), ('12548', '211.142.223.68', '湖南省长沙市', '移动', '0', '2010-12-06', '1'), ('12549', '117.136.2.60', '中国', '移动', '0', '2010-12-06', '1'), ('12550', '117.136.9.236', '山东省潍坊市', '移动', '0', '2010-12-07', '1'), ('12551', '218.201.148.58', '山东省东营市', '移动', '0', '2010-12-07', '1'), ('12552', '117.136.0.214', '中国', '移动', '0', '2010-12-07', '1'), ('12553', '117.136.23.180', '中国', '移动', '0', '2010-12-08', '1'), ('12554', '117.136.2.61', '中国', '移动', '0', '2010-12-09', '1'), ('12555', '117.136.21.31', '中国', '移动', '0', '2010-12-09', '1'), ('12556', '221.176.4.134', '江西省', '移动', '0', '2010-12-09', '1'), ('12557', '117.136.0.213', '中国', '移动', '0', '2010-12-09', '1'), ('12558', '117.136.21.74', '中国', '移动', '0', '2010-12-10', '1'), ('12559', '218.202.106.216', '内蒙古呼和浩特市', '移动', '0', '2010-12-10', '1'), ('12560', '117.136.9.226', '山东省潍坊市', '移动', '0', '2010-12-11', '1'), ('12561', '117.136.2.62', '中国', '移动', '0', '2010-12-11', '1'), ('12562', '117.136.24.79', '中国', '移动', '0', '2010-12-12', '1'), ('12563', '117.136.21.83', '中国', '移动', '0', '2010-12-12', '1'), ('12564', '117.136.0.193', '中国', '移动', '0', '2010-12-12', '1'), ('12565', '117.136.9.228', '山东省潍坊市', '移动', '0', '2010-12-13', '1'), ('12566', '117.136.0.223', '中国', '移动', '0', '2010-12-13', '1'), ('12567', '218.207.218.132', '中国', '移动', '0', '2010-12-14', '1'), ('12568', '117.136.21.92', '中国', '移动', '0', '2010-12-15', '1'), ('12569', '117.136.21.81', '中国', '移动', '0', '2010-12-15', '1'), ('12570', '117.136.9.238', '山东省潍坊市', '移动', '0', '2010-12-15', '1'), ('12571', '211.142.189.67', '河南省', '移动', '0', '2010-12-16', '1'), ('12572', '211.142.189.68', '河南省', '移动', '0', '2010-12-16', '1'), ('12573', '211.142.189.66', '河南省', '移动', '0', '2010-12-16', '1'), ('12574', '211.142.189.65', '河南省', '移动', '0', '2010-12-16', '1'), ('12575', '117.136.31.102', '中国', '移动', '0', '2010-12-17', '1'), ('12576', '117.136.9.99', '山东省潍坊市', '移动', '0', '2010-12-17', '1'), ('12577', '117.136.9.231', '山东省潍坊市', '移动', '0', '2010-12-17', '1'), ('12578', '218.205.245.73', '四川省', '移动', '0', '2010-12-17', '1'), ('12579', '117.136.9.182', '山东省潍坊市', '移动', '0', '2010-12-17', '1'), ('12580', '211.137.220.133', '吉林省', '移动', '0', '2010-12-18', '1'), ('12581', '117.136.9.150', '山东省潍坊市', '移动', '0', '2010-12-18', '1'), ('12582', '117.136.2.58', '中国', '移动', '0', '2010-12-18', '1'), ('12583', '112.3.254.50', '中国', '移动', '0', '2010-12-19', '1'), ('12584', '117.136.23.229', '中国', '移动', '0', '2010-12-19', '1'), ('12585', '117.136.9.232', '山东省潍坊市', '移动', '0', '2010-12-19', '1'), ('12586', '117.136.9.155', '山东省潍坊市', '移动', '0', '2010-12-19', '1'), ('12587', '117.136.1.118', '中国', '移动', '0', '2010-12-19', '1'), ('12588', '117.136.9.153', '山东省潍坊市', '移动', '0', '2010-12-21', '1'), ('12589', '211.143.50.15', '河北省', '移动', '0', '2010-12-21', '1'), ('12590', '117.136.1.5', '中国', '移动', '0', '2010-12-21', '1'), ('12591', '117.136.21.76', '中国', '移动', '0', '2010-12-22', '1'), ('12592', '117.136.21.70', '中国', '移动', '0', '2010-12-22', '1'), ('12593', '117.136.21.82', '中国', '移动', '0', '2010-12-22', '1'), ('12594', '218.201.74.102', '重庆市', '移动', '0', '2010-12-22', '1'), ('12595', '117.136.9.254', '山东省潍坊市', '移动', '0', '2010-12-22', '1'), ('12596', '117.136.21.84', '中国', '移动', '0', '2010-12-23', '1'), ('12597', '117.136.9.164', '山东省潍坊市', '移动', '0', '2010-12-23', '1'), ('12598', '117.136.21.86', '中国', '移动', '0', '2010-12-23', '1'), ('12599', '221.179.9.69', '重庆市', '移动', '0', '2010-12-24', '1'), ('12600', '120.196.211.105', '中国', '移动', '0', '2010-12-24', '1'), ('12601', '117.136.28.8', '中国', '移动', '0', '2010-12-24', '1'), ('12602', '117.136.26.166', '中国', '移动', '0', '2010-12-25', '1'), ('12603', '117.136.26.160', '中国', '移动', '0', '2010-12-25', '1'), ('12604', '211.137.133.252', '陕西省西安市', '移动', '0', '2010-12-25', '1'), ('12605', '120.192.205.52', '中国', '移动', '0', '2010-12-25', '1'), ('12606', '112.3.254.40', '中国', '移动', '0', '2010-12-25', '1'), ('12607', '111.10.95.32', '中国', '移动', '0', '2010-12-26', '1'), ('12608', '117.136.21.91', '中国', '移动', '0', '2010-12-26', '1'), ('12609', '117.136.21.56', '中国', '移动', '0', '2010-12-27', '1'), ('12610', '117.136.1.7', '中国', '移动', '0', '2010-12-27', '1'), ('12611', '117.136.15.145', '中国', '移动', '0', '2010-12-28', '1'), ('12612', '117.136.9.181', '山东省潍坊市', '移动', '0', '2010-12-29', '1'), ('12613', '117.136.26.163', '中国', '移动', '0', '2010-12-29', '1'), ('12614', '117.136.15.152', '中国', '移动', '0', '2010-12-29', '1'), ('12615', '117.136.13.244', '中国', '移动', '0', '2010-12-29', '1'), ('12616', '117.136.15.142', '中国', '移动', '0', '2010-12-31', '1'), ('12617', '117.136.19.75', '中国', '移动', '0', '2010-12-31', '1'), ('12618', '117.136.19.68', '中国', '移动', '0', '2011-01-01', '1'), ('12619', '117.136.13.243', '中国', '移动', '0', '2011-01-01', '1'), ('12620', '117.136.9.136', '山东省潍坊市', '移动', '0', '2011-01-01', '1'), ('12621', '117.136.9.138', '山东省潍坊市', '移动', '0', '2011-01-02', '1'), ('12622', '211.137.73.116', '湖北省武汉市', '移动', '0', '2011-01-02', '1'), ('12623', '117.136.26.165', '中国', '移动', '0', '2011-01-02', '1'), ('12624', '117.136.9.158', '山东省潍坊市', '移动', '0', '2011-01-03', '1'), ('12625', '117.136.26.161', '中国', '移动', '0', '2011-01-03', '1'), ('12626', '117.136.9.255', '山东省潍坊市', '移动', '0', '2011-01-04', '1'), ('12627', '117.136.26.167', '中国', '移动', '0', '2011-01-05', '1'), ('12628', '117.136.9.157', '山东省潍坊市', '移动', '0', '2011-01-07', '1'), ('12629', '117.136.21.80', '中国', '移动', '0', '2011-01-07', '1'), ('12630', '117.136.9.151', '山东省潍坊市', '移动', '0', '2011-01-07', '1'), ('12631', '117.136.21.87', '中国', '移动', '0', '2011-01-07', '1'), ('12632', '117.136.9.100', '山东省潍坊市', '移动', '0', '2011-01-08', '1'), ('12633', '117.136.19.73', '中国', '移动', '0', '2011-01-08', '1'), ('12634', '117.136.26.164', '中国', '移动', '0', '2011-01-09', '1'), ('12635', '117.136.15.135', '中国', '移动', '0', '2011-01-09', '1'), ('12636', '117.136.30.142', '中国', '移动', '0', '2011-01-09', '1'), ('12637', '117.136.30.154', '中国', '移动', '0', '2011-01-09', '1'), ('12638', '117.136.30.149', '中国', '移动', '0', '2011-01-09', '1'), ('12639', '117.136.30.128', '中国', '移动', '0', '2011-01-09', '1'), ('12640', '117.136.26.162', '中国', '移动', '0', '2011-01-09', '1'), ('12641', '117.136.19.72', '中国', '移动', '0', '2011-01-10', '1'), ('12642', '117.136.15.141', '中国', '移动', '0', '2011-01-10', '1'), ('12643', '117.136.15.156', '中国', '移动', '0', '2011-01-10', '1'), ('12644', '117.136.19.76', '中国', '移动', '0', '2011-01-10', '1'), ('12645', '117.136.21.126', '中国', '移动', '0', '2011-01-10', '1'), ('12646', '117.136.21.114', '中国', '移动', '0', '2011-01-10', '1'), ('12647', '117.136.21.127', '中国', '移动', '0', '2011-01-10', '1'), ('12648', '117.136.24.109', '中国', '移动', '0', '2011-01-10', '1'), ('12649', '117.136.21.122', '中国', '移动', '0', '2011-01-11', '1'), ('12650', '117.136.30.152', '中国', '移动', '0', '2011-01-11', '1'), ('12651', '117.136.19.77', '中国', '移动', '0', '2011-01-11', '1'), ('12652', '117.136.30.151', '中国', '移动', '0', '2011-01-11', '1'), ('12653', '117.136.24.73', '中国', '移动', '0', '2011-01-11', '1'), ('12654', '117.136.31.92', '中国', '移动', '0', '2011-01-11', '1'), ('12655', '117.136.19.66', '中国', '移动', '0', '2011-01-11', '1'), ('12656', '117.136.21.119', '中国', '移动', '0', '2011-01-11', '1'), ('12657', '211.137.185.73', '山东省', '移动', '0', '2011-01-11', '1'), ('12658', '211.137.185.72', '山东省', '移动', '0', '2011-01-11', '1'), ('12659', '211.137.185.71', '山东省', '移动', '0', '2011-01-12', '1'), ('12660', '211.137.185.74', '山东省', '移动', '0', '2011-01-12', '1'), ('12661', '117.136.30.130', '中国', '移动', '0', '2011-01-12', '1'), ('12662', '117.136.30.132', '中国', '移动', '0', '2011-01-12', '1'), ('12663', '117.136.30.153', '中国', '移动', '0', '2011-01-12', '1'), ('12664', '117.136.0.203', '中国', '移动', '0', '2011-01-12', '1'), ('12665', '117.136.21.125', '中国', '移动', '0', '2011-01-12', '1'), ('12666', '117.136.30.136', '中国', '移动', '0', '2011-01-12', '1'), ('12667', '117.136.21.124', '中国', '移动', '0', '2011-01-13', '1'), ('12668', '117.136.21.117', '中国', '移动', '0', '2011-01-13', '1'), ('12669', '117.136.30.146', '中国', '移动', '0', '2011-01-14', '1'), ('12670', '117.136.30.144', '中国', '移动', '0', '2011-01-14', '1'), ('12671', '117.136.30.155', '中国', '移动', '0', '2011-01-14', '1'), ('12672', '117.136.15.134', '中国', '移动', '0', '2011-01-14', '1'), ('12673', '117.136.21.120', '中国', '移动', '0', '2011-01-14', '1'), ('12674', '117.136.21.116', '中国', '移动', '0', '2011-01-14', '1'), ('12675', '117.136.9.144', '山东省潍坊市', '移动', '0', '2011-01-14', '1'), ('12676', '117.136.21.113', '中国', '移动', '0', '2011-01-14', '1'), ('12677', '117.136.21.123', '中国', '移动', '0', '2011-01-14', '1'), ('12678', '117.136.30.145', '中国', '移动', '0', '2011-01-15', '1'), ('12679', '117.136.30.137', '中国', '移动', '0', '2011-01-15', '1'), ('12680', '117.136.21.121', '中国', '移动', '0', '2011-01-15', '1'), ('12681', '211.140.7.194', '浙江省杭州市', '移动', '0', '2011-01-15', '1'), ('12682', '211.140.7.193', '浙江省杭州市', '移动', '0', '2011-01-15', '1'), ('12683', '117.136.9.131', '山东省潍坊市', '移动', '0', '2011-01-15', '1'), ('12684', '117.136.9.244', '山东省潍坊市', '移动', '0', '2011-01-15', '1'), ('12685', '117.136.21.112', '中国', '移动', '0', '2011-01-16', '1'), ('12686', '211.140.7.195', '浙江省杭州市', '移动', '0', '2011-01-16', '1'), ('12687', '117.136.30.141', '中国', '移动', '0', '2011-01-16', '1'), ('12688', '117.136.15.155', '中国', '移动', '0', '2011-01-16', '1'), ('12689', '117.136.30.134', '中国', '移动', '0', '2011-01-17', '1'), ('12690', '117.136.30.156', '中国', '移动', '0', '2011-01-17', '1'), ('12691', '117.136.30.135', '中国', '移动', '0', '2011-01-17', '1'), ('12692', '117.136.30.147', '中国', '移动', '0', '2011-01-17', '1'), ('12693', '117.136.30.138', '中国', '移动', '0', '2011-01-17', '1'), ('12694', '117.136.30.131', '中国', '移动', '0', '2011-01-18', '1'), ('12695', '117.136.30.133', '中国', '移动', '0', '2011-01-18', '1'), ('12696', '211.140.7.196', '浙江省杭州市', '移动', '0', '2011-01-18', '1'), ('12697', '117.136.9.147', '山东省潍坊市', '移动', '0', '2011-01-18', '1'), ('12698', '117.136.30.157', '中国', '移动', '0', '2011-01-19', '1'), ('12699', '117.136.21.118', '中国', '移动', '0', '2011-01-19', '1'), ('12700', '211.138.157.1', '福建省泉州市', '移动', '0', '2011-01-19', '1'), ('12701', '117.136.19.69', '中国', '移动', '0', '2011-01-20', '1'), ('12702', '218.206.254.135', '河南省', '移动', '0', '2011-01-20', '1'), ('12703', '117.136.19.70', '中国', '移动', '0', '2011-01-20', '1'), ('12704', '117.136.14.72', '中国', '移动', '0', '2011-01-22', '1'), ('12705', '112.4.2.13', '江苏省', '移动', '0', '2011-01-22', '1'), ('12706', '112.4.2.12', '江苏省', '移动', '0', '2011-01-22', '1'), ('12707', '117.136.0.250', '中国', '移动', '0', '2011-01-22', '1'), ('12708', '112.4.2.10', '江苏省', '移动', '0', '2011-01-22', '1'), ('12709', '117.136.22.6', '中国', '移动', '0', '2011-01-23', '1'), ('12710', '117.136.1.68', '中国', '移动', '0', '2011-01-23', '1'), ('12711', '117.136.19.74', '中国', '移动', '0', '2011-01-23', '1'), ('12712', '117.136.14.78', '中国', '移动', '0', '2011-01-23', '1'), ('12713', '117.136.16.82', '中国', '移动', '0', '2011-01-23', '1'), ('12714', '112.4.2.11', '江苏省', '移动', '0', '2011-01-24', '1'), ('12715', '117.136.1.15', '中国', '移动', '0', '2011-01-24', '1'), ('12716', '117.136.19.65', '中国', '移动', '0', '2011-01-24', '1'), ('12717', '117.136.14.76', '中国', '移动', '0', '2011-01-24', '1'), ('12718', '117.136.14.75', '中国', '移动', '0', '2011-01-25', '1'), ('12719', '117.136.22.4', '中国', '移动', '0', '2011-01-25', '1'), ('12720', '218.206.254.132', '河南省', '移动', '0', '2011-01-25', '1'), ('12721', '117.136.22.5', '中国', '移动', '0', '2011-01-25', '1'), ('12722', '218.206.254.158', '河南省', '移动', '0', '2011-01-26', '1'), ('12723', '117.136.14.77', '中国', '移动', '0', '2011-01-26', '1'), ('12724', '117.136.9.148', '山东省潍坊市', '移动', '0', '2011-01-26', '1'), ('12725', '218.206.254.153', '河南省', '移动', '0', '2011-01-26', '1'), ('12726', '117.136.9.191', '山东省潍坊市', '移动', '0', '2011-01-27', '1'), ('12727', '218.206.254.154', '河南省', '移动', '0', '2011-01-27', '1'), ('12728', '218.206.254.157', '河南省', '移动', '0', '2011-01-27', '1'), ('12729', '117.136.22.164', '中国', '移动', '0', '2011-01-27', '1'), ('12730', '218.206.254.137', '河南省', '移动', '0', '2011-01-27', '1'), ('12731', '117.136.19.71', '中国', '移动', '0', '2011-01-28', '1'), ('12732', '117.136.14.73', '中国', '移动', '0', '2011-01-28', '1'), ('12733', '117.136.15.131', '中国', '移动', '0', '2011-01-28', '1'), ('12734', '117.136.22.3', '中国', '移动', '0', '2011-01-28', '1'), ('12735', '218.206.254.139', '河南省', '移动', '0', '2011-01-28', '1'), ('12736', '218.206.254.128', '河南省', '移动', '0', '2011-01-28', '1'), ('12737', '117.136.24.193', '中国', '移动', '0', '2011-01-29', '1'), ('12738', '221.182.2.179', '四川省成都市', '移动', '0', '2011-01-29', '1'), ('12739', '218.205.245.97', '四川省', '移动', '0', '2011-01-29', '1'), ('12740', '117.136.6.66', '辽宁省本溪市', '移动', '0', '2011-01-30', '1'), ('12741', '218.206.254.136', '河南省', '移动', '0', '2011-01-30', '1'), ('12742', '211.137.86.4', '四川省成都市', '移动', '0', '2011-01-30', '1'), ('12743', '218.206.254.130', '河南省', '移动', '0', '2011-01-31', '1'), ('12744', '117.136.22.149', '中国', '移动', '0', '2011-01-31', '1'), ('12745', '117.136.24.194', '中国', '移动', '0', '2011-01-31', '1'), ('12746', '117.136.22.49', '中国', '移动', '0', '2011-01-31', '1'), ('12747', '117.136.22.66', '中国', '移动', '0', '2011-01-31', '1'), ('12748', '117.136.19.78', '中国', '移动', '0', '2011-02-01', '1'), ('12749', '117.136.24.204', '中国', '移动', '0', '2011-02-01', '1'), ('12750', '221.182.2.180', '四川省成都市', '移动', '0', '2011-02-01', '1'), ('12751', '117.136.22.130', '中国', '移动', '0', '2011-02-01', '1'), ('12752', '117.136.14.79', '中国', '移动', '0', '2011-02-01', '1'), ('12753', '117.136.9.8', '山东省潍坊市', '移动', '0', '2011-02-01', '1'), ('12754', '117.136.22.150', '中国', '移动', '0', '2011-02-01', '1'), ('12755', '117.136.22.53', '中国', '移动', '0', '2011-02-01', '1'), ('12756', '117.136.31.97', '中国', '移动', '0', '2011-02-02', '1'), ('12757', '117.136.22.59', '中国', '移动', '0', '2011-02-02', '1'), ('12758', '117.136.24.76', '中国', '移动', '0', '2011-02-02', '1'), ('12759', '117.136.15.138', '中国', '移动', '0', '2011-02-02', '1'), ('12760', '117.136.9.16', '山东省潍坊市', '移动', '0', '2011-02-02', '1'), ('12761', '117.136.15.133', '中国', '移动', '0', '2011-02-02', '1'), ('12762', '117.136.15.151', '中国', '移动', '0', '2011-02-02', '1'), ('12763', '117.136.14.74', '中国', '移动', '0', '2011-02-03', '1'), ('12764', '117.136.22.151', '中国', '移动', '0', '2011-02-03', '1'), ('12765', '117.136.24.203', '中国', '移动', '0', '2011-02-03', '1'), ('12766', '218.206.255.129', '河南省', '移动', '0', '2011-02-03', '1'), ('12767', '117.136.15.85', '中国', '移动', '0', '2011-02-03', '1'), ('12768', '117.136.15.86', '中国', '移动', '0', '2011-02-03', '1'), ('12769', '117.136.24.195', '中国', '移动', '0', '2011-02-03', '1'), ('12770', '117.136.15.129', '中国', '移动', '0', '2011-02-03', '1'), ('12771', '218.206.254.151', '河南省', '移动', '0', '2011-02-03', '1'), ('12772', '117.136.22.56', '中国', '移动', '0', '2011-02-03', '1'), ('12773', '117.136.22.129', '中国', '移动', '0', '2011-02-04', '1'), ('12774', '117.136.9.10', '山东省潍坊市', '移动', '0', '2011-02-05', '1'), ('12775', '218.206.254.159', '河南省', '移动', '0', '2011-02-05', '1'), ('12776', '218.206.254.147', '河南省', '移动', '0', '2011-02-05', '1'), ('12777', '218.206.254.152', '河南省', '移动', '0', '2011-02-05', '1'), ('12778', '117.136.22.131', '中国', '移动', '0', '2011-02-05', '1'), ('12779', '218.206.254.144', '河南省', '移动', '0', '2011-02-05', '1'), ('12780', '218.206.254.150', '河南省', '移动', '0', '2011-02-06', '1'), ('12781', '117.136.24.206', '中国', '移动', '0', '2011-02-06', '1'), ('12782', '117.136.24.101', '中国', '移动', '0', '2011-02-06', '1'), ('12783', '117.136.23.176', '中国', '移动', '0', '2011-02-07', '1'), ('12784', '117.136.23.177', '中国', '移动', '0', '2011-02-07', '1'), ('12785', '117.136.9.9', '山东省潍坊市', '移动', '0', '2011-02-07', '1'), ('12786', '218.206.254.134', '河南省', '移动', '0', '2011-02-08', '1'), ('12787', '117.136.15.130', '中国', '移动', '0', '2011-02-09', '1'), ('12788', '218.206.254.138', '河南省', '移动', '0', '2011-02-09', '1'), ('12789', '218.206.254.155', '河南省', '移动', '0', '2011-02-10', '1'), ('12790', '218.206.254.148', '河南省', '移动', '0', '2011-02-11', '1'), ('12791', '117.136.22.152', '中国', '移动', '0', '2011-02-11', '1'), ('12792', '117.136.6.69', '辽宁省本溪市', '移动', '0', '2011-02-11', '1'), ('12793', '221.182.106.35', '中国', '移动', '0', '2011-02-12', '1'), ('12794', '117.136.30.158', '中国', '移动', '0', '2011-02-13', '1'), ('12795', '120.196.125.13', '中国', '移动', '0', '2011-02-14', '1'), ('12796', '117.136.30.129', '中国', '移动', '0', '2011-02-14', '1'), ('12797', '117.136.30.140', '中国', '移动', '0', '2011-02-14', '1'), ('12798', '117.136.30.148', '中国', '移动', '0', '2011-02-14', '1'), ('12799', '117.136.31.98', '中国', '移动', '0', '2011-02-14', '1'), ('12800', '117.136.15.140', '中国', '移动', '0', '2011-02-15', '1'), ('12801', '117.136.24.90', '中国', '移动', '0', '2011-02-15', '1'), ('12802', '218.206.254.145', '河南省', '移动', '0', '2011-02-16', '1'), ('12803', '117.136.9.14', '山东省潍坊市', '移动', '0', '2011-02-17', '1'), ('12804', '117.136.9.13', '山东省潍坊市', '移动', '0', '2011-02-17', '1'), ('12805', '218.206.254.146', '河南省', '移动', '0', '2011-02-17', '1'), ('12806', '117.136.30.159', '中国', '移动', '0', '2011-02-19', '1'), ('12807', '117.136.15.148', '中国', '移动', '0', '2011-02-21', '1'), ('12808', '117.136.19.67', '中国', '移动', '0', '2011-02-21', '1'), ('12809', '117.136.24.14', '中国', '移动', '0', '2011-02-21', '1'), ('12810', '117.136.9.142', '山东省潍坊市', '移动', '0', '2011-02-22', '1'), ('12811', '111.9.16.188', '中国', '移动', '0', '2011-02-22', '1'), ('12812', '117.136.24.196', '中国', '移动', '0', '2011-02-22', '1'), ('12813', '112.4.236.24', '江苏省', '移动', '0', '2011-02-22', '1'), ('12814', '111.9.16.56', '中国', '移动', '0', '2011-02-22', '1'), ('12815', '117.136.9.135', '山东省潍坊市', '移动', '0', '2011-02-23', '1'), ('12816', '111.9.18.13', '中国', '移动', '0', '2011-02-23', '1'), ('12817', '117.136.9.139', '山东省潍坊市', '移动', '0', '2011-02-24', '1'), ('12818', '111.9.16.27', '中国', '移动', '0', '2011-02-25', '1'), ('12819', '117.135.129.59', '中国', '移动', '0', '2011-02-26', '1'), ('12820', '117.135.129.58', '中国', '移动', '0', '2011-02-26', '1'), ('12821', '218.201.200.121', '贵州省', '移动', '0', '2011-02-27', '1'), ('12822', '218.201.200.122', '贵州省', '移动', '0', '2011-02-27', '1'), ('12823', '218.201.200.123', '贵州省', '移动', '0', '2011-02-27', '1'), ('12824', '218.206.254.133', '河南省', '移动', '0', '2011-02-28', '1'), ('12825', '218.201.103.156', '山东省青岛市', '移动', '0', '2011-02-28', '1'), ('12826', '218.205.220.74', '北京市', '移动', '0', '2011-02-28', '1'), ('12827', '221.182.2.181', '四川省成都市', '移动', '0', '2011-02-28', '1'), ('12828', '117.136.21.51', '中国', '移动', '0', '2011-02-28', '1'), ('12829', '117.136.24.201', '中国', '移动', '0', '2011-03-01', '1'), ('12830', '117.136.9.22', '山东省潍坊市', '移动', '0', '2011-03-01', '1'), ('12831', '117.136.21.43', '中国', '移动', '0', '2011-03-01', '1'), ('12832', '117.136.24.197', '中国', '移动', '0', '2011-03-02', '1'), ('12833', '117.136.9.23', '山东省潍坊市', '移动', '0', '2011-03-02', '1'), ('12834', '111.4.143.228', '中国', '移动', '0', '2011-03-03', '1'), ('12835', '117.136.9.121', '山东省潍坊市', '移动', '0', '2011-03-03', '1'), ('12836', '117.136.9.241', '山东省潍坊市', '移动', '0', '2011-03-03', '1'), ('12837', '117.136.15.158', '中国', '移动', '0', '2011-03-03', '1'), ('12838', '117.136.1.71', '中国', '移动', '0', '2011-03-04', '1'), ('12839', '117.136.22.55', '中国', '移动', '0', '2011-03-04', '1'), ('12840', '218.206.254.129', '河南省', '移动', '0', '2011-03-04', '1'), ('12841', '117.136.9.19', '山东省潍坊市', '移动', '0', '2011-03-05', '1'), ('12842', '117.136.24.159', '中国', '移动', '0', '2011-03-06', '1'), ('12843', '117.136.15.146', '中国', '移动', '0', '2011-03-06', '1'), ('12844', '117.136.24.205', '中国', '移动', '0', '2011-03-07', '1'), ('12845', '117.136.22.163', '中国', '移动', '0', '2011-03-08', '1'), ('12846', '117.136.22.58', '中国', '移动', '0', '2011-03-09', '1'), ('12847', '117.136.22.51', '中国', '移动', '0', '2011-03-10', '1'), ('12848', '117.136.15.147', '中国', '移动', '0', '2011-03-10', '1'), ('12849', '117.136.24.199', '中国', '移动', '0', '2011-03-10', '1'), ('12850', '117.136.21.33', '中国', '移动', '0', '2011-03-10', '1'), ('12851', '117.136.9.15', '山东省潍坊市', '移动', '0', '2011-03-11', '1'), ('12852', '117.136.1.14', '中国', '移动', '0', '2011-03-11', '1'), ('12853', '117.136.22.52', '中国', '移动', '0', '2011-03-11', '1'), ('12854', '117.136.6.64', '辽宁省本溪市', '移动', '0', '2011-03-11', '1'), ('12855', '117.136.24.87', '中国', '移动', '0', '2011-03-12', '1'), ('12856', '117.136.9.154', '山东省潍坊市', '移动', '0', '2011-03-13', '1'), ('12857', '117.136.24.207', '中国', '移动', '0', '2011-03-13', '1'), ('12858', '117.136.21.9', '中国', '移动', '0', '2011-03-14', '1'), ('12859', '221.182.2.182', '四川省成都市', '移动', '0', '2011-03-14', '1'), ('12860', '117.136.6.71', '辽宁省本溪市', '移动', '0', '2011-03-14', '1'), ('12861', '117.136.21.34', '中国', '移动', '0', '2011-03-14', '1'), ('12862', '218.206.254.131', '河南省', '移动', '0', '2011-03-15', '1'), ('12863', '221.178.179.130', '江苏省镇江市', '移动', '0', '2011-03-15', '1'), ('12864', '117.136.9.145', '山东省潍坊市', '移动', '0', '2011-03-17', '1'), ('12865', '117.136.22.60', '中国', '移动', '0', '2011-03-17', '1'), ('12866', '117.136.9.140', '山东省潍坊市', '移动', '0', '2011-03-18', '1'), ('12867', '117.136.6.70', '辽宁省本溪市', '移动', '0', '2011-03-18', '1'), ('12868', '117.136.30.143', '中国', '移动', '0', '2011-03-18', '1'), ('12869', '117.136.0.230', '中国', '移动', '0', '2011-03-18', '1'), ('12870', '117.136.22.54', '中国', '移动', '0', '2011-03-20', '1'), ('12871', '117.136.22.57', '中国', '移动', '0', '2011-03-20', '1'), ('12872', '117.136.26.10', '中国', '移动', '0', '2011-03-20', '1'), ('12873', '117.136.0.234', '中国', '移动', '0', '2011-03-20', '1'), ('12874', '117.136.9.7', '山东省潍坊市', '移动', '0', '2011-03-20', '1'), ('12875', '117.136.31.129', '中国', '移动', '0', '2011-03-20', '1'), ('12876', '117.136.21.13', '中国', '移动', '0', '2011-03-21', '1'), ('12877', '117.136.31.130', '中国', '移动', '0', '2011-03-21', '1'), ('12878', '117.136.9.133', '山东省潍坊市', '移动', '0', '2011-03-22', '1'), ('12879', '117.136.9.130', '山东省潍坊市', '移动', '0', '2011-03-22', '1'), ('12880', '117.136.30.139', '中国', '移动', '0', '2011-03-22', '1'), ('12881', '117.136.9.237', '山东省潍坊市', '移动', '0', '2011-03-22', '1'), ('12882', '117.136.26.14', '中国', '移动', '0', '2011-03-22', '1'), ('12883', '211.138.129.225', '浙江省', '移动', '0', '2011-03-22', '1'), ('12884', '211.138.129.226', '浙江省', '移动', '0', '2011-03-22', '1'), ('12885', '218.206.255.130', '河南省', '移动', '0', '2011-03-23', '1'), ('12886', '211.138.5.43', '河北省石家庄市', '移动', '0', '2011-03-23', '1'), ('12887', '211.138.5.42', '河北省石家庄市', '移动', '0', '2011-03-23', '1'), ('12888', '211.138.5.40', '河北省石家庄市', '移动', '0', '2011-03-23', '1'), ('12889', '211.138.5.41', '河北省石家庄市', '移动', '0', '2011-03-24', '1'), ('12890', '117.136.9.134', '山东省潍坊市', '移动', '0', '2011-03-24', '1'), ('12891', '117.136.9.129', '山东省潍坊市', '移动', '0', '2011-03-24', '1'), ('12892', '221.179.8.158', '重庆市', '移动', '0', '2011-03-24', '1'), ('12893', '117.136.19.119', '中国', '移动', '0', '2011-03-25', '1'), ('12894', '120.207.194.155', '中国', '移动', '0', '2011-03-25', '1'), ('12895', '117.136.9.141', '山东省潍坊市', '移动', '0', '2011-03-25', '1'), ('12896', '221.179.8.157', '重庆市', '移动', '0', '2011-03-25', '1'), ('12897', '117.136.21.22', '中国', '移动', '0', '2011-03-26', '1'), ('12898', '117.136.19.117', '中国', '移动', '0', '2011-03-26', '1'), ('12899', '117.136.21.20', '中国', '移动', '0', '2011-03-27', '1'), ('12900', '117.136.19.115', '中国', '移动', '0', '2011-03-27', '1'), ('12901', '117.136.1.242', '中国', '移动', '0', '2011-03-27', '1'), ('12902', '117.136.21.50', '中国', '移动', '0', '2011-03-29', '1'), ('12903', '117.136.22.50', '中国', '移动', '0', '2011-03-29', '1'), ('12904', '117.136.19.123', '中国', '移动', '0', '2011-03-30', '1'), ('12905', '117.136.1.245', '中国', '移动', '0', '2011-04-01', '1'), ('12906', '117.136.19.113', '中国', '移动', '0', '2011-04-01', '1'), ('12907', '211.138.157.17', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12908', '211.138.157.22', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12909', '211.138.157.18', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12910', '211.138.157.19', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12911', '211.138.157.20', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12912', '211.138.157.21', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12913', '211.138.157.23', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12914', '117.136.19.87', '中国', '移动', '0', '2011-04-01', '1'), ('12915', '117.136.19.127', '中国', '移动', '0', '2011-04-01', '1'), ('12916', '211.138.157.24', '福建省泉州市', '移动', '0', '2011-04-01', '1'), ('12917', '211.136.7.242', '北京市', '移动', '0', '2011-04-01', '1'), ('12918', '111.4.143.8', '中国', '移动', '0', '2011-04-01', '1'), ('12919', '117.136.19.82', '中国', '移动', '0', '2011-04-01', '1'), ('12920', '211.143.58.42', '河北省承德市', '移动', '0', '2011-04-01', '1'), ('12921', '211.143.58.41', '河北省承德市', '移动', '0', '2011-04-01', '1'), ('12922', '117.136.21.15', '中国', '移动', '0', '2011-04-02', '1'), ('12923', '211.143.58.43', '河北省承德市', '移动', '0', '2011-04-02', '1'), ('12924', '117.136.19.114', '中国', '移动', '0', '2011-04-02', '1'), ('12925', '211.143.58.40', '河北省承德市', '移动', '0', '2011-04-02', '1'), ('12926', '117.136.0.221', '中国', '移动', '0', '2011-04-02', '1'), ('12927', '211.143.58.52', '河北省承德市', '移动', '0', '2011-04-02', '1'), ('12928', '117.136.9.137', '山东省潍坊市', '移动', '0', '2011-04-02', '1'), ('12929', '117.136.23.196', '中国', '移动', '0', '2011-04-02', '1'), ('12930', '117.136.16.111', '中国', '移动', '0', '2011-04-02', '1'), ('12931', '117.136.26.11', '中国', '移动', '0', '2011-04-03', '1'), ('12932', '117.136.15.139', '中国', '移动', '0', '2011-04-03', '1'), ('12933', '117.136.19.118', '中国', '移动', '0', '2011-04-03', '1'), ('12934', '117.136.16.112', '中国', '移动', '0', '2011-04-04', '1'), ('12935', '218.206.254.149', '河南省', '移动', '0', '2011-04-04', '1'), ('12936', '117.136.16.110', '中国', '移动', '0', '2011-04-04', '1'), ('12937', '117.136.19.121', '中国', '移动', '0', '2011-04-05', '1'), ('12938', '117.136.16.108', '中国', '移动', '0', '2011-04-05', '1'), ('12939', '117.136.4.17', '辽宁省本溪市', '移动', '0', '2011-04-06', '1'), ('12940', '117.136.24.202', '中国', '移动', '0', '2011-04-06', '1'), ('12941', '112.20.72.81', '中国', '移动', '0', '2011-04-06', '1'), ('12942', '117.136.19.125', '中国', '移动', '0', '2011-04-07', '1'), ('12943', '117.136.16.113', '中国', '移动', '0', '2011-04-07', '1'), ('12944', '117.136.16.116', '中国', '移动', '0', '2011-04-07', '1'), ('12945', '117.136.6.65', '辽宁省本溪市', '移动', '0', '2011-04-08', '1'), ('12946', '117.136.14.85', '中国', '移动', '0', '2011-04-09', '1'), ('12947', '117.136.14.90', '中国', '移动', '0', '2011-04-09', '1'), ('12948', '117.136.0.222', '中国', '移动', '0', '2011-04-09', '1'), ('12949', '117.136.16.105', '中国', '移动', '0', '2011-04-09', '1'), ('12950', '117.136.24.119', '中国', '移动', '0', '2011-04-09', '1'), ('12951', '117.139.103.157', '中国', '移动', '0', '2011-04-09', '1'), ('12952', '117.136.24.75', '中国', '移动', '0', '2011-04-10', '1'), ('12953', '117.136.14.87', '中国', '移动', '0', '2011-04-10', '1'), ('12954', '117.136.16.117', '中国', '移动', '0', '2011-04-10', '1'), ('12955', '117.136.4.19', '辽宁省本溪市', '移动', '0', '2011-04-11', '1'), ('12956', '117.136.30.150', '中国', '移动', '0', '2011-04-11', '1'), ('12957', '117.136.14.88', '中国', '移动', '0', '2011-04-11', '1'), ('12958', '117.136.9.149', '山东省潍坊市', '移动', '0', '2011-04-12', '1'), ('12959', '117.136.26.12', '中国', '移动', '0', '2011-04-12', '1'), ('12960', '117.136.6.68', '辽宁省本溪市', '移动', '0', '2011-04-12', '1'), ('12961', '117.136.16.119', '中国', '移动', '0', '2011-04-12', '1'), ('12962', '117.136.14.91', '中国', '移动', '0', '2011-04-12', '1'), ('12963', '58.248.126.181', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('12964', '119.163.122.65', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('12965', '61.242.223.2', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('12966', '58.22.116.254', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('12967', '58.16.246.202', '贵州省', '联通', '0', '2011-04-12', '1'), ('12968', '61.242.168.117', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('12969', '58.243.250.101', '安徽省', '联通', '0', '2011-04-12', '1'), ('12970', '122.194.0.164', '江苏省', '联通', '0', '2011-04-12', '1'), ('12971', '113.58.8.149', '海南省', '联通', '0', '2011-04-12', '1'), ('12972', '118.212.186.58', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('12973', '60.13.124.79', '海南省', '联通', '0', '2011-04-12', '1'), ('12974', '113.58.13.154', '海南省', '联通', '0', '2011-04-12', '1'), ('12975', '113.57.244.30', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('12976', '116.114.83.108', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('12977', '119.6.251.253', '四川省绵阳市', '联通', '0', '2011-04-12', '1'), ('12978', '119.163.122.196', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('12979', '113.58.8.88', '海南省', '联通', '0', '2011-04-12', '1'), ('12980', '58.243.254.46', '安徽省', '联通', '0', '2011-04-12', '1'), ('12981', '220.196.53.10', '上海市', '联通', '0', '2011-04-12', '1'), ('12982', '58.243.254.49', '安徽省', '联通', '0', '2011-04-12', '1'), ('12983', '58.22.117.244', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('12984', '121.31.250.14', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('12985', '121.31.250.6', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('12986', '58.243.250.91', '安徽省', '联通', '0', '2011-04-12', '1'), ('12987', '211.92.245.195', '云南省昆明市', '联通', '0', '2011-04-12', '1'), ('12988', '112.97.168.230', '广东省', '联通', '0', '2011-04-12', '1'), ('12989', '119.163.122.221', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('12990', '119.163.122.166', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('12991', '122.194.2.96', '江苏省', '联通', '0', '2011-04-12', '1'), ('12992', '113.58.2.233', '海南省', '联通', '0', '2011-04-12', '1'), ('12993', '123.129.218.177', '山东省', '联通', '0', '2011-04-12', '1'), ('12994', '119.6.251.54', '四川省绵阳市', '联通', '0', '2011-04-12', '1'), ('12995', '58.243.254.62', '安徽省', '联通', '0', '2011-04-12', '1'), ('12996', '124.160.209.232', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('12997', '58.22.114.69', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('12998', '58.243.250.92', '安徽省', '联通', '0', '2011-04-12', '1'), ('12999', '58.243.254.48', '安徽省', '联通', '0', '2011-04-12', '1'), ('13000', '124.160.192.25', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13001', '124.160.192.24', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13002', '119.163.122.249', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13003', '58.248.124.184', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13004', '58.248.124.213', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13005', '61.156.45.24', '山东省济宁市', '联通', '0', '2011-04-12', '1'), ('13006', '124.160.209.128', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13007', '221.11.61.252', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13008', '61.240.7.40', '天津市', '联通', '0', '2011-04-12', '1'), ('13009', '58.243.250.90', '安徽省', '联通', '0', '2011-04-12', '1'), ('13010', '113.58.0.239', '海南省', '联通', '0', '2011-04-12', '1'), ('13011', '124.160.208.78', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13012', '61.158.152.115', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13013', '121.31.250.30', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13014', '121.31.250.15', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13015', '122.194.0.194', '江苏省', '联通', '0', '2011-04-12', '1'), ('13016', '119.163.122.161', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13017', '119.163.122.167', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13018', '124.160.208.70', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13019', '58.22.114.21', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13020', '124.160.208.193', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13021', '124.160.208.100', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13022', '119.163.122.162', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13023', '119.163.122.163', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13024', '122.194.0.172', '江苏省', '联通', '0', '2011-04-12', '1'), ('13025', '218.60.141.233', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('13026', '58.22.113.37', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13027', '58.243.250.120', '安徽省', '联通', '0', '2011-04-12', '1'), ('13028', '123.129.218.184', '山东省', '联通', '0', '2011-04-12', '1'), ('13029', '113.58.23.38', '海南省', '联通', '0', '2011-04-12', '1'), ('13030', '221.1.215.138', '山东省菏泽市', '联通', '0', '2011-04-12', '1'), ('13031', '58.243.250.82', '安徽省', '联通', '0', '2011-04-12', '1'), ('13032', '119.163.122.219', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13033', '124.160.208.199', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13034', '124.160.208.185', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13035', '218.25.249.84', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13036', '61.158.152.40', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13037', '123.127.159.244', '北京市', '联通', '0', '2011-04-12', '1'), ('13038', '123.14.204.161', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('13039', '122.194.2.2', '江苏省', '联通', '0', '2011-04-12', '1'), ('13040', '115.85.238.118', '甘肃省', '联通', '0', '2011-04-12', '1'), ('13041', '119.163.122.212', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13042', '124.160.208.4', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13043', '121.31.250.23', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13044', '58.243.250.94', '安徽省', '联通', '0', '2011-04-12', '1'), ('13045', '61.158.152.109', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13046', '122.194.2.115', '江苏省', '联通', '0', '2011-04-12', '1'), ('13047', '113.58.1.178', '海南省', '联通', '0', '2011-04-12', '1'), ('13048', '119.163.122.218', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13049', '113.58.2.137', '海南省', '联通', '0', '2011-04-12', '1'), ('13050', '58.243.250.112', '安徽省', '联通', '0', '2011-04-12', '1'), ('13051', '124.160.209.214', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13052', '113.58.16.199', '海南省', '联通', '0', '2011-04-12', '1'), ('13053', '218.57.45.107', '山东省菏泽市', '联通', '0', '2011-04-12', '1'), ('13054', '119.163.122.209', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13055', '123.147.244.7', '重庆市', '联通', '0', '2011-04-12', '1'), ('13056', '124.160.209.18', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13057', '124.160.208.33', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13058', '113.58.8.192', '海南省', '联通', '0', '2011-04-12', '1'), ('13059', '113.58.11.143', '海南省', '联通', '0', '2011-04-12', '1'), ('13060', '121.31.250.8', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13061', '112.97.171.44', '广东省', '联通', '0', '2011-04-12', '1'), ('13062', '124.160.208.179', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13063', '113.58.0.195', '海南省', '联通', '0', '2011-04-12', '1'), ('13064', '119.163.122.210', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13065', '123.125.66.110', '北京市', '联通', '0', '2011-04-12', '1'), ('13066', '124.160.209.213', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13067', '120.86.101.91', '广东省', '联通', '0', '2011-04-12', '1'), ('13068', '122.194.2.173', '江苏省', '联通', '0', '2011-04-12', '1'), ('13069', '124.160.208.229', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13070', '58.243.254.14', '安徽省', '联通', '0', '2011-04-12', '1'), ('13071', '113.58.16.14', '海南省', '联通', '0', '2011-04-12', '1'), ('13072', '124.160.208.1', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13073', '121.31.254.59', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13074', '124.160.209.161', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13075', '119.39.249.3', '湖南省', '联通', '0', '2011-04-12', '1'), ('13076', '121.31.250.51', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13077', '112.64.190.36', '上海市', '联通', '0', '2011-04-12', '1'), ('13078', '113.5.0.125', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('13079', '124.160.208.254', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13080', '122.194.2.250', '江苏省', '联通', '0', '2011-04-12', '1'), ('13081', '122.194.0.49', '江苏省', '联通', '0', '2011-04-12', '1'), ('13082', '61.158.152.22', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13083', '221.207.27.230', '青海省西宁市', '联通', '0', '2011-04-12', '1'), ('13084', '58.243.254.36', '安徽省', '联通', '0', '2011-04-12', '1'), ('13085', '123.127.159.240', '北京市', '联通', '0', '2011-04-12', '1'), ('13086', '121.31.250.29', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13087', '119.48.176.122', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13088', '121.31.250.19', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13089', '123.147.244.1', '重庆市', '联通', '0', '2011-04-12', '1'), ('13090', '121.31.250.16', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13091', '112.64.188.44', '上海市', '联通', '0', '2011-04-12', '1'), ('13092', '61.158.152.41', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13093', '121.31.250.46', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13094', '122.194.2.34', '江苏省', '联通', '0', '2011-04-12', '1'), ('13095', '113.58.18.68', '海南省', '联通', '0', '2011-04-12', '1'), ('13096', '112.96.90.198', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13097', '124.160.208.225', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13098', '124.160.208.28', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13099', '61.158.152.187', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13100', '122.194.2.91', '江苏省', '联通', '0', '2011-04-12', '1'), ('13101', '124.165.228.2', '山西省吕梁市', '联通', '0', '2011-04-12', '1'), ('13102', '124.160.209.160', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13103', '112.96.104.223', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13104', '122.194.2.84', '江苏省', '联通', '0', '2011-04-12', '1'), ('13105', '218.107.6.177', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13106', '121.31.250.24', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13107', '122.194.2.208', '江苏省', '联通', '0', '2011-04-12', '1'), ('13108', '221.194.30.182', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13109', '122.194.0.215', '江苏省', '联通', '0', '2011-04-12', '1'), ('13110', '61.158.152.46', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13111', '221.194.30.162', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13112', '221.194.30.105', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13113', '221.194.30.71', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13114', '222.128.24.67', '北京市', '联通', '0', '2011-04-12', '1'), ('13115', '61.158.140.149', '河南省开封市', '联通', '0', '2011-04-12', '1'), ('13116', '114.247.10.77', '北京市', '联通', '0', '2011-04-12', '1'), ('13117', '221.194.30.189', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13118', '218.60.138.213', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13119', '58.22.113.5', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13120', '218.60.141.122', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('13121', '61.158.152.233', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13122', '218.60.141.198', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('13123', '122.159.252.135', '黑龙江省哈尔滨市', '联通', '0', '2011-04-12', '1'), ('13124', '61.158.152.60', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13125', '112.64.190.34', '上海市', '联通', '0', '2011-04-12', '1'), ('13126', '124.160.208.95', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13127', '122.194.0.232', '江苏省', '联通', '0', '2011-04-12', '1'), ('13128', '220.249.138.116', '福建省宁德市', '联通', '0', '2011-04-12', '1'), ('13129', '124.160.209.216', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13130', '221.205.226.77', '山西省临汾市', '联通', '0', '2011-04-12', '1'), ('13131', '119.163.122.229', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13132', '119.163.122.164', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13133', '124.160.209.238', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13134', '122.194.2.104', '江苏省', '联通', '0', '2011-04-12', '1'), ('13135', '221.199.10.226', '宁夏自治区银川市', '联通', '0', '2011-04-12', '1'), ('13136', '58.22.166.166', '福建省宁德市', '联通', '0', '2011-04-12', '1'), ('13137', '58.243.254.2', '安徽省', '联通', '0', '2011-04-12', '1'), ('13138', '58.246.76.76', '上海市', '联通', '0', '2011-04-12', '1'), ('13139', '114.247.10.76', '北京市', '联通', '0', '2011-04-12', '1'), ('13140', '112.64.190.35', '上海市', '联通', '0', '2011-04-12', '1'), ('13141', '124.160.208.173', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13142', '112.97.228.46', '广东省', '联通', '0', '2011-04-12', '1'), ('13143', '124.160.209.95', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13144', '218.60.141.48', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('13145', '218.7.208.244', '黑龙江省鹤岗市', '联通', '0', '2011-04-12', '1'), ('13146', '220.206.218.2', '中国', '联通', '0', '2011-04-12', '1'), ('13147', '124.160.208.81', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13148', '61.139.151.138', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13149', '61.158.152.56', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13150', '112.65.244.80', '上海市', '联通', '0', '2011-04-12', '1'), ('13151', '124.160.209.61', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13152', '113.57.246.235', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13153', '121.25.81.27', '河北省张家口市', '联通', '0', '2011-04-12', '1'), ('13154', '123.152.199.163', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('13155', '61.158.152.169', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13156', '123.152.202.53', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('13157', '115.56.101.237', '河南省', '联通', '0', '2011-04-12', '1'), ('13158', '121.31.250.61', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13159', '61.55.156.20', '河北省邯郸市', '联通', '0', '2011-04-12', '1'), ('13160', '122.194.3.110', '江苏省', '联通', '0', '2011-04-12', '1'), ('13161', '221.11.44.43', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13162', '116.114.82.64', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('13163', '58.22.114.81', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13164', '61.158.152.68', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13165', '119.62.128.115', '云南省', '联通', '0', '2011-04-12', '1'), ('13166', '118.212.190.59', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('13167', '218.26.158.28', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('13168', '218.26.158.4', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('13169', '112.97.38.9', '广东省', '联通', '0', '2011-04-12', '1'), ('13170', '114.247.10.74', '北京市', '联通', '0', '2011-04-12', '1'), ('13171', '115.56.102.9', '河南省', '联通', '0', '2011-04-12', '1'), ('13172', '61.158.152.229', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13173', '61.158.152.199', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13174', '61.139.151.146', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13175', '61.158.152.138', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13176', '112.97.220.99', '广东省', '联通', '0', '2011-04-12', '1'), ('13177', '112.97.236.204', '广东省', '联通', '0', '2011-04-12', '1'), ('13178', '124.160.209.133', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13179', '114.247.10.84', '北京市', '联通', '0', '2011-04-12', '1'), ('13180', '114.247.10.80', '北京市', '联通', '0', '2011-04-12', '1'), ('13181', '124.160.208.53', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13182', '124.160.208.148', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13183', '202.99.125.114', '天津市', '联通', '0', '2011-04-12', '1'), ('13184', '112.97.51.163', '广东省', '联通', '0', '2011-04-12', '1'), ('13185', '61.158.152.33', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13186', '124.160.209.195', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13187', '218.7.208.240', '黑龙江省鹤岗市', '联通', '0', '2011-04-12', '1'), ('13188', '124.160.209.245', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13189', '123.113.119.42', '北京市', '联通', '0', '2011-04-12', '1'), ('13190', '61.158.152.206', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13191', '221.194.31.187', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13192', '122.194.2.42', '江苏省', '联通', '0', '2011-04-12', '1'), ('13193', '115.56.100.144', '河南省', '联通', '0', '2011-04-12', '1'), ('13194', '119.39.248.1', '湖南省', '联通', '0', '2011-04-12', '1'), ('13195', '119.4.252.112', '四川省', '联通', '0', '2011-04-12', '1'), ('13196', '61.158.152.232', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13197', '119.4.249.53', '四川省', '联通', '0', '2011-04-12', '1'), ('13198', '58.243.254.10', '安徽省', '联通', '0', '2011-04-12', '1'), ('13199', '123.152.167.208', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('13200', '113.58.16.87', '海南省', '联通', '0', '2011-04-12', '1'), ('13201', '58.248.120.47', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13202', '124.160.209.174', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13203', '61.158.152.1', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13204', '124.160.208.61', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13205', '58.243.250.109', '安徽省', '联通', '0', '2011-04-12', '1'), ('13206', '121.31.254.44', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13207', '121.31.250.32', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13208', '61.158.152.28', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13209', '61.158.152.88', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13210', '112.64.188.45', '上海市', '联通', '0', '2011-04-12', '1'), ('13211', '124.160.209.181', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13212', '124.160.209.90', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13213', '221.9.247.11', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13214', '122.194.0.115', '江苏省', '联通', '0', '2011-04-12', '1'), ('13215', '123.120.209.16', '北京市', '联通', '0', '2011-04-12', '1'), ('13216', '124.160.209.136', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13217', '124.160.208.219', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13218', '221.194.30.183', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13219', '121.31.250.12', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13220', '124.128.255.131', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13221', '58.22.114.45', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13222', '218.107.6.173', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13223', '114.247.10.75', '北京市', '联通', '0', '2011-04-12', '1'), ('13224', '124.160.208.91', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13225', '124.160.209.210', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13226', '124.160.208.112', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13227', '61.158.152.110', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13228', '58.22.113.73', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13229', '122.194.2.29', '江苏省', '联通', '0', '2011-04-12', '1'), ('13230', '124.160.209.240', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13231', '118.212.190.83', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('13232', '61.158.152.239', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13233', '124.160.208.158', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13234', '118.212.190.145', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('13235', '124.160.209.176', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13236', '61.158.152.50', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13237', '124.160.208.247', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13238', '61.158.152.143', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13239', '124.160.208.242', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13240', '61.158.152.198', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13241', '61.158.152.149', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13242', '124.160.208.220', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13243', '218.61.135.58', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('13244', '61.158.152.197', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13245', '112.224.3.93', '山东省', '联通', '0', '2011-04-12', '1'), ('13246', '61.158.152.218', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13247', '122.194.2.56', '江苏省', '联通', '0', '2011-04-12', '1'), ('13248', '124.160.208.32', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13249', '122.194.0.99', '江苏省', '联通', '0', '2011-04-12', '1'), ('13250', '122.194.1.162', '江苏省', '联通', '0', '2011-04-12', '1'), ('13251', '60.11.205.34', '黑龙江省鹤岗市', '联通', '0', '2011-04-12', '1'), ('13252', '122.194.0.16', '江苏省', '联通', '0', '2011-04-12', '1'), ('13253', '124.160.208.108', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13254', '124.160.209.132', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13255', '112.64.188.46', '上海市', '联通', '0', '2011-04-12', '1'), ('13256', '61.158.152.70', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13257', '112.224.2.64', '山东省', '联通', '0', '2011-04-12', '1'), ('13258', '58.243.250.67', '安徽省', '联通', '0', '2011-04-12', '1'), ('13259', '116.117.40.236', '内蒙古兴安盟', '联通', '0', '2011-04-12', '1'), ('13260', '121.31.250.34', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13261', '123.147.244.10', '重庆市', '联通', '0', '2011-04-12', '1'), ('13262', '124.160.209.85', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13263', '123.147.244.2', '重庆市', '联通', '0', '2011-04-12', '1'), ('13264', '118.212.190.131', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('13265', '122.194.0.217', '江苏省', '联通', '0', '2011-04-12', '1'), ('13266', '61.158.152.73', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13267', '119.163.122.165', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13268', '221.199.9.9', '宁夏自治区银川市', '联通', '0', '2011-04-12', '1'), ('13269', '124.160.209.74', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13270', '122.194.3.194', '江苏省', '联通', '0', '2011-04-12', '1'), ('13271', '110.52.11.37', '湖南省常德市', '联通', '0', '2011-04-12', '1'), ('13272', '113.58.16.209', '海南省', '联通', '0', '2011-04-12', '1'), ('13273', '113.58.12.25', '海南省', '联通', '0', '2011-04-12', '1'), ('13274', '124.160.208.167', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13275', '61.158.152.55', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13276', '124.160.209.150', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13277', '61.158.152.247', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13278', '61.135.249.155', '北京市', '联通', '0', '2011-04-12', '1'), ('13279', '61.135.249.157', '北京市', '联通', '0', '2011-04-12', '1'), ('13280', '61.135.249.57', '北京市', '联通', '0', '2011-04-12', '1'), ('13281', '218.60.138.23', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13282', '61.135.249.252', '北京市', '联通', '0', '2011-04-12', '1'), ('13283', '61.135.249.133', '北京市', '联通', '0', '2011-04-12', '1'), ('13284', '61.135.249.184', '北京市', '联通', '0', '2011-04-12', '1'), ('13285', '61.135.249.121', '北京市', '联通', '0', '2011-04-12', '1'), ('13286', '61.135.249.14', '北京市', '联通', '0', '2011-04-12', '1'), ('13287', '61.135.249.15', '北京市', '联通', '0', '2011-04-12', '1'), ('13288', '61.135.249.190', '北京市', '联通', '0', '2011-04-12', '1'), ('13289', '61.135.249.27', '北京市', '联通', '0', '2011-04-12', '1'), ('13290', '61.135.249.145', '北京市', '联通', '0', '2011-04-12', '1'), ('13291', '61.135.249.169', '北京市', '联通', '0', '2011-04-12', '1'), ('13292', '61.135.248.220', '北京市', '联通', '0', '2011-04-12', '1'), ('13293', '61.135.249.105', '北京市', '联通', '0', '2011-04-12', '1'), ('13294', '61.135.249.120', '北京市', '联通', '0', '2011-04-12', '1'), ('13295', '61.135.248.198', '北京市', '联通', '0', '2011-04-12', '1'), ('13296', '61.135.249.34', '北京市', '联通', '0', '2011-04-12', '1'), ('13297', '61.135.249.107', '北京市', '联通', '0', '2011-04-12', '1'), ('13298', '114.247.10.65', '北京市', '联通', '0', '2011-04-12', '1'), ('13299', '61.135.249.59', '北京市', '联通', '0', '2011-04-12', '1'), ('13300', '61.135.249.164', '北京市', '联通', '0', '2011-04-12', '1'), ('13301', '61.135.249.29', '北京市', '联通', '0', '2011-04-12', '1'), ('13302', '61.135.249.93', '北京市', '联通', '0', '2011-04-12', '1'), ('13303', '61.135.248.197', '北京市', '联通', '0', '2011-04-12', '1'), ('13304', '61.135.249.98', '北京市', '联通', '0', '2011-04-12', '1'), ('13305', '61.158.152.20', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13306', '124.160.208.177', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13307', '61.135.249.75', '北京市', '联通', '0', '2011-04-12', '1'), ('13308', '61.135.248.233', '北京市', '联通', '0', '2011-04-12', '1'), ('13309', '61.135.249.226', '北京市', '联通', '0', '2011-04-12', '1'), ('13310', '61.135.249.5', '北京市', '联通', '0', '2011-04-12', '1'), ('13311', '61.135.249.43', '北京市', '联通', '0', '2011-04-12', '1'), ('13312', '61.135.249.17', '北京市', '联通', '0', '2011-04-12', '1'), ('13313', '61.135.249.73', '北京市', '联通', '0', '2011-04-12', '1');
INSERT INTO `ig_gateway` VALUES ('13314', '61.135.249.234', '北京市', '联通', '0', '2011-04-12', '1'), ('13315', '125.32.81.28', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13316', '61.135.249.44', '北京市', '联通', '0', '2011-04-12', '1'), ('13317', '61.135.248.219', '北京市', '联通', '0', '2011-04-12', '1'), ('13318', '124.160.209.54', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13319', '61.135.249.83', '北京市', '联通', '0', '2011-04-12', '1'), ('13320', '119.4.249.150', '四川省', '联通', '0', '2011-04-12', '1'), ('13321', '61.135.248.227', '北京市', '联通', '0', '2011-04-12', '1'), ('13322', '61.135.249.102', '北京市', '联通', '0', '2011-04-12', '1'), ('13323', '61.135.249.240', '北京市', '联通', '0', '2011-04-12', '1'), ('13324', '61.135.249.85', '北京市', '联通', '0', '2011-04-12', '1'), ('13325', '61.135.249.113', '北京市', '联通', '0', '2011-04-12', '1'), ('13326', '61.135.249.96', '北京市', '联通', '0', '2011-04-12', '1'), ('13327', '61.135.249.162', '北京市', '联通', '0', '2011-04-12', '1'), ('13328', '61.135.249.31', '北京市', '联通', '0', '2011-04-12', '1'), ('13329', '61.135.249.40', '北京市', '联通', '0', '2011-04-12', '1'), ('13330', '61.135.249.76', '北京市', '联通', '0', '2011-04-12', '1'), ('13331', '61.135.249.65', '北京市', '联通', '0', '2011-04-12', '1'), ('13332', '61.135.249.126', '北京市', '联通', '0', '2011-04-12', '1'), ('13333', '61.135.249.71', '北京市', '联通', '0', '2011-04-12', '1'), ('13334', '61.135.249.181', '北京市', '联通', '0', '2011-04-12', '1'), ('13335', '61.135.249.52', '北京市', '联通', '0', '2011-04-12', '1'), ('13336', '61.135.249.20', '北京市', '联通', '0', '2011-04-12', '1'), ('13337', '61.135.249.243', '北京市', '联通', '0', '2011-04-12', '1'), ('13338', '61.135.249.68', '北京市', '联通', '0', '2011-04-12', '1'), ('13339', '61.158.152.16', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13340', '61.135.249.158', '北京市', '联通', '0', '2011-04-12', '1'), ('13341', '61.135.248.192', '北京市', '联通', '0', '2011-04-12', '1'), ('13342', '61.135.249.241', '北京市', '联通', '0', '2011-04-12', '1'), ('13343', '61.135.248.194', '北京市', '联通', '0', '2011-04-12', '1'), ('13344', '61.135.248.195', '北京市', '联通', '0', '2011-04-12', '1'), ('13345', '61.135.249.236', '北京市', '联通', '0', '2011-04-12', '1'), ('13346', '61.135.249.242', '北京市', '联通', '0', '2011-04-12', '1'), ('13347', '61.135.248.182', '北京市', '联通', '0', '2011-04-12', '1'), ('13348', '61.135.249.254', '北京市', '联通', '0', '2011-04-12', '1'), ('13349', '61.135.248.202', '北京市', '联通', '0', '2011-04-12', '1'), ('13350', '61.135.249.196', '北京市', '联通', '0', '2011-04-12', '1'), ('13351', '61.135.249.26', '北京市', '联通', '0', '2011-04-12', '1'), ('13352', '61.135.249.79', '北京市', '联通', '0', '2011-04-12', '1'), ('13353', '61.135.249.19', '北京市', '联通', '0', '2011-04-12', '1'), ('13354', '112.96.169.182', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13355', '119.4.252.185', '四川省', '联通', '0', '2011-04-12', '1'), ('13356', '118.212.187.226', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('13357', '221.13.117.18', '重庆市', '联通', '0', '2011-04-12', '1'), ('13358', '122.194.2.83', '江苏省', '联通', '0', '2011-04-12', '1'), ('13359', '61.135.248.185', '北京市', '联通', '0', '2011-04-12', '1'), ('13360', '61.135.249.36', '北京市', '联通', '0', '2011-04-12', '1'), ('13361', '61.135.249.132', '北京市', '联通', '0', '2011-04-12', '1'), ('13362', '61.135.248.177', '北京市', '联通', '0', '2011-04-12', '1'), ('13363', '61.135.249.185', '北京市', '联通', '0', '2011-04-12', '1'), ('13364', '61.135.249.182', '北京市', '联通', '0', '2011-04-12', '1'), ('13365', '61.135.249.13', '北京市', '联通', '0', '2011-04-12', '1'), ('13366', '61.135.249.251', '北京市', '联通', '0', '2011-04-12', '1'), ('13367', '61.135.249.152', '北京市', '联通', '0', '2011-04-12', '1'), ('13368', '61.135.248.234', '北京市', '联通', '0', '2011-04-12', '1'), ('13369', '61.135.248.217', '北京市', '联通', '0', '2011-04-12', '1'), ('13370', '61.135.248.204', '北京市', '联通', '0', '2011-04-12', '1'), ('13371', '61.135.249.239', '北京市', '联通', '0', '2011-04-12', '1'), ('13372', '61.135.249.238', '北京市', '联通', '0', '2011-04-12', '1'), ('13373', '61.135.249.81', '北京市', '联通', '0', '2011-04-12', '1'), ('13374', '61.135.249.176', '北京市', '联通', '0', '2011-04-12', '1'), ('13375', '61.135.248.236', '北京市', '联通', '0', '2011-04-12', '1'), ('13376', '61.135.249.151', '北京市', '联通', '0', '2011-04-12', '1'), ('13377', '61.135.249.250', '北京市', '联通', '0', '2011-04-12', '1'), ('13378', '61.135.248.193', '北京市', '联通', '0', '2011-04-12', '1'), ('13379', '61.158.152.150', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13380', '114.247.10.72', '北京市', '联通', '0', '2011-04-12', '1'), ('13381', '58.243.254.13', '安徽省', '联通', '0', '2011-04-12', '1'), ('13382', '113.58.30.112', '海南省', '联通', '0', '2011-04-12', '1'), ('13383', '218.28.246.118', '河南省驻马店市', '联通', '0', '2011-04-12', '1'), ('13384', '61.158.152.159', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13385', '124.160.208.222', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13386', '124.160.209.169', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13387', '113.58.10.21', '海南省', '联通', '0', '2011-04-12', '1'), ('13388', '61.158.152.127', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13389', '218.60.141.2', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('13390', '124.160.209.117', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13391', '124.160.209.217', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13392', '61.158.152.192', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13393', '118.212.172.36', '江西省', '联通', '0', '2011-04-12', '1'), ('13394', '61.158.152.48', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13395', '123.147.244.31', '重庆市', '联通', '0', '2011-04-12', '1'), ('13396', '124.160.208.89', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13397', '61.158.152.160', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13398', '124.160.209.68', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13399', '61.158.152.47', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13400', '112.96.48.243', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13401', '112.96.125.67', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13402', '61.158.152.117', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13403', '118.212.172.116', '江西省', '联通', '0', '2011-04-12', '1'), ('13404', '221.194.31.81', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13405', '221.194.30.102', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13406', '221.194.30.201', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13407', '120.84.59.37', '广东省', '联通', '0', '2011-04-12', '1'), ('13408', '61.158.152.122', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13409', '221.13.78.11', '西藏拉萨市', '联通', '0', '2011-04-12', '1'), ('13410', '122.158.240.221', '黑龙江省双鸭山市', '联通', '0', '2011-04-12', '1'), ('13411', '112.64.190.37', '上海市', '联通', '0', '2011-04-12', '1'), ('13412', '124.160.209.156', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13413', '124.160.208.154', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13414', '58.243.254.38', '安徽省', '联通', '0', '2011-04-12', '1'), ('13415', '124.160.208.223', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13416', '58.243.254.29', '安徽省', '联通', '0', '2011-04-12', '1'), ('13417', '58.243.254.39', '安徽省', '联通', '0', '2011-04-12', '1'), ('13418', '221.207.37.22', '青海省西宁市', '联通', '0', '2011-04-12', '1'), ('13419', '61.135.249.142', '北京市', '联通', '0', '2011-04-12', '1'), ('13420', '61.135.249.139', '北京市', '联通', '0', '2011-04-12', '1'), ('13421', '61.135.248.172', '北京市', '联通', '0', '2011-04-12', '1'), ('13422', '61.135.249.118', '北京市', '联通', '0', '2011-04-12', '1'), ('13423', '221.1.118.118', '山东省潍坊市', '联通', '0', '2011-04-12', '1'), ('13424', '61.135.249.246', '北京市', '联通', '0', '2011-04-12', '1'), ('13425', '61.135.249.154', '北京市', '联通', '0', '2011-04-12', '1'), ('13426', '124.160.208.92', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13427', '61.135.249.248', '北京市', '联通', '0', '2011-04-12', '1'), ('13428', '61.135.249.50', '北京市', '联通', '0', '2011-04-12', '1'), ('13429', '218.107.5.222', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13430', '61.135.249.106', '北京市', '联通', '0', '2011-04-12', '1'), ('13431', '124.160.208.143', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13432', '61.135.249.56', '北京市', '联通', '0', '2011-04-12', '1'), ('13433', '61.135.249.144', '北京市', '联通', '0', '2011-04-12', '1'), ('13434', '123.147.244.27', '重庆市', '联通', '0', '2011-04-12', '1'), ('13435', '124.160.208.209', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13436', '124.160.208.43', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13437', '61.135.249.235', '北京市', '联通', '0', '2011-04-12', '1'), ('13438', '121.31.250.43', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13439', '61.135.248.231', '北京市', '联通', '0', '2011-04-12', '1'), ('13440', '61.135.249.171', '北京市', '联通', '0', '2011-04-12', '1'), ('13441', '61.135.249.3', '北京市', '联通', '0', '2011-04-12', '1'), ('13442', '61.135.248.218', '北京市', '联通', '0', '2011-04-12', '1'), ('13443', '61.135.249.119', '北京市', '联通', '0', '2011-04-12', '1'), ('13444', '61.135.249.149', '北京市', '联通', '0', '2011-04-12', '1'), ('13445', '61.135.249.165', '北京市', '联通', '0', '2011-04-12', '1'), ('13446', '61.158.152.156', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13447', '218.60.138.42', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13448', '124.160.92.170', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('13449', '61.158.152.17', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13450', '61.135.248.207', '北京市', '联通', '0', '2011-04-12', '1'), ('13451', '61.158.152.154', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13452', '122.194.2.70', '江苏省', '联通', '0', '2011-04-12', '1'), ('13453', '61.135.249.227', '北京市', '联通', '0', '2011-04-12', '1'), ('13454', '123.147.244.13', '重庆市', '联通', '0', '2011-04-12', '1'), ('13455', '61.135.249.245', '北京市', '联通', '0', '2011-04-12', '1'), ('13456', '61.135.248.200', '北京市', '联通', '0', '2011-04-12', '1'), ('13457', '122.194.2.187', '江苏省', '联通', '0', '2011-04-12', '1'), ('13458', '122.194.2.33', '江苏省', '联通', '0', '2011-04-12', '1'), ('13459', '124.160.209.41', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13460', '124.160.208.197', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13461', '113.58.26.177', '海南省', '联通', '0', '2011-04-12', '1'), ('13462', '58.248.120.152', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13463', '119.62.127.120', '云南省', '联通', '0', '2011-04-12', '1'), ('13464', '123.147.244.46', '重庆市', '联通', '0', '2011-04-12', '1'), ('13465', '221.9.247.8', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13466', '61.158.152.10', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13467', '61.158.152.8', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13468', '124.160.208.147', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13469', '58.243.254.22', '安徽省', '联通', '0', '2011-04-12', '1'), ('13470', '58.16.226.125', '贵州省', '联通', '0', '2011-04-12', '1'), ('13471', '58.243.250.88', '安徽省', '联通', '0', '2011-04-12', '1'), ('13472', '124.160.209.211', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13473', '218.60.140.68', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13474', '123.147.244.23', '重庆市', '联通', '0', '2011-04-12', '1'), ('13475', '61.158.152.144', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13476', '112.224.3.41', '山东省', '联通', '0', '2011-04-12', '1'), ('13477', '113.58.14.206', '海南省', '联通', '0', '2011-04-12', '1'), ('13478', '124.160.208.244', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13479', '125.32.82.31', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13480', '121.31.250.18', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13481', '124.160.208.29', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13482', '112.224.2.91', '山东省', '联通', '0', '2011-04-12', '1'), ('13483', '124.160.208.205', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13484', '122.194.2.8', '江苏省', '联通', '0', '2011-04-12', '1'), ('13485', '218.26.158.36', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('13486', '218.60.138.111', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13487', '122.194.2.156', '江苏省', '联通', '0', '2011-04-12', '1'), ('13488', '124.160.209.180', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13489', '121.31.250.39', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13490', '58.16.249.44', '贵州省', '联通', '0', '2011-04-12', '1'), ('13491', '113.58.18.254', '海南省', '联通', '0', '2011-04-12', '1'), ('13492', '61.135.248.209', '北京市', '联通', '0', '2011-04-12', '1'), ('13493', '119.4.252.58', '四川省', '联通', '0', '2011-04-12', '1'), ('13494', '221.199.9.13', '宁夏自治区银川市', '联通', '0', '2011-04-12', '1'), ('13495', '113.58.7.244', '海南省', '联通', '0', '2011-04-12', '1'), ('13496', '113.58.4.204', '海南省', '联通', '0', '2011-04-12', '1'), ('13497', '58.243.250.118', '安徽省', '联通', '0', '2011-04-12', '1'), ('13498', '123.120.202.249', '北京市', '联通', '0', '2011-04-12', '1'), ('13499', '119.4.172.187', '四川省', '联通', '0', '2011-04-12', '1'), ('13500', '124.128.255.133', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13501', '122.136.234.181', '吉林省', '联通', '0', '2011-04-12', '1'), ('13502', '124.160.209.31', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13503', '221.194.31.176', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13504', '124.160.208.232', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13505', '61.158.152.188', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13506', '124.160.208.90', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13507', '122.194.0.39', '江苏省', '联通', '0', '2011-04-12', '1'), ('13508', '61.158.152.89', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13509', '124.160.208.142', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13510', '124.160.209.55', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13511', '113.57.244.190', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13512', '122.194.2.85', '江苏省', '联通', '0', '2011-04-12', '1'), ('13513', '61.158.152.194', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13514', '123.152.202.118', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('13515', '61.139.151.18', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13516', '61.135.249.247', '北京市', '联通', '0', '2011-04-12', '1'), ('13517', '122.194.2.160', '江苏省', '联通', '0', '2011-04-12', '1'), ('13518', '61.135.248.205', '北京市', '联通', '0', '2011-04-12', '1'), ('13519', '58.243.254.32', '安徽省', '联通', '0', '2011-04-12', '1'), ('13520', '112.224.3.114', '山东省', '联通', '0', '2011-04-12', '1'), ('13521', '221.194.31.173', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13522', '123.147.244.39', '重庆市', '联通', '0', '2011-04-12', '1'), ('13523', '58.16.226.145', '贵州省', '联通', '0', '2011-04-12', '1'), ('13524', '119.112.106.175', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13525', '58.243.254.52', '安徽省', '联通', '0', '2011-04-12', '1'), ('13526', '202.99.125.238', '天津市', '联通', '0', '2011-04-12', '1'), ('13527', '122.194.2.32', '江苏省', '联通', '0', '2011-04-12', '1'), ('13528', '122.194.2.87', '江苏省', '联通', '0', '2011-04-12', '1'), ('13529', '123.120.201.254', '北京市', '联通', '0', '2011-04-12', '1'), ('13530', '119.62.128.112', '云南省', '联通', '0', '2011-04-12', '1'), ('13531', '124.160.209.26', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13532', '112.64.190.139', '上海市', '联通', '0', '2011-04-12', '1'), ('13533', '218.26.158.22', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('13534', '61.135.249.94', '北京市', '联通', '0', '2011-04-12', '1'), ('13535', '221.194.31.211', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13536', '124.160.209.28', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13537', '119.112.104.128', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13538', '113.57.244.69', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13539', '122.194.2.77', '江苏省', '联通', '0', '2011-04-12', '1'), ('13540', '124.160.208.88', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13541', '112.64.190.119', '上海市', '联通', '0', '2011-04-12', '1'), ('13542', '61.158.152.153', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13543', '115.46.178.29', '广西自治区', '联通', '0', '2011-04-12', '1'), ('13544', '61.135.249.89', '北京市', '联通', '0', '2011-04-12', '1'), ('13545', '221.1.59.188', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('13546', '113.58.20.103', '海南省', '联通', '0', '2011-04-12', '1'), ('13547', '123.120.210.24', '北京市', '联通', '0', '2011-04-12', '1'), ('13548', '124.160.208.150', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13549', '112.64.190.127', '上海市', '联通', '0', '2011-04-12', '1'), ('13550', '122.194.2.155', '江苏省', '联通', '0', '2011-04-12', '1'), ('13551', '113.58.4.152', '海南省', '联通', '0', '2011-04-12', '1'), ('13552', '58.247.162.231', '上海市', '联通', '0', '2011-04-12', '1'), ('13553', '118.81.21.104', '山西省太原市', '联通', '0', '2011-04-12', '1'), ('13554', '123.120.200.11', '北京市', '联通', '0', '2011-04-12', '1'), ('13555', '123.147.144.125', '重庆市', '联通', '0', '2011-04-12', '1'), ('13556', '124.160.208.44', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13557', '112.224.3.7', '山东省', '联通', '0', '2011-04-12', '1'), ('13558', '123.120.205.93', '北京市', '联通', '0', '2011-04-12', '1'), ('13559', '113.58.27.164', '海南省', '联通', '0', '2011-04-12', '1'), ('13560', '122.194.2.103', '江苏省', '联通', '0', '2011-04-12', '1'), ('13561', '124.160.208.231', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13562', '61.135.248.184', '北京市', '联通', '0', '2011-04-12', '1'), ('13563', '115.46.176.249', '广西自治区', '联通', '0', '2011-04-12', '1'), ('13564', '221.207.14.153', '青海省西宁市', '联通', '0', '2011-04-12', '1'), ('13565', '61.135.248.206', '北京市', '联通', '0', '2011-04-12', '1'), ('13566', '112.224.3.60', '山东省', '联通', '0', '2011-04-12', '1'), ('13567', '124.160.209.57', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13568', '113.58.7.196', '海南省', '联通', '0', '2011-04-12', '1'), ('13569', '112.224.2.19', '山东省', '联通', '0', '2011-04-12', '1'), ('13570', '61.158.152.136', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13571', '61.135.249.233', '北京市', '联通', '0', '2011-04-12', '1'), ('13572', '112.97.43.148', '广东省', '联通', '0', '2011-04-12', '1'), ('13573', '110.17.170.80', '内蒙古', '联通', '0', '2011-04-12', '1'), ('13574', '61.135.248.228', '北京市', '联通', '0', '2011-04-12', '1'), ('13575', '61.135.248.173', '北京市', '联通', '0', '2011-04-12', '1'), ('13576', '58.243.250.115', '安徽省', '联通', '0', '2011-04-12', '1'), ('13577', '124.160.208.37', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13578', '121.31.250.41', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13579', '112.64.190.135', '上海市', '联通', '0', '2011-04-12', '1'), ('13580', '61.158.152.185', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13581', '123.147.244.19', '重庆市', '联通', '0', '2011-04-12', '1'), ('13582', '61.158.152.226', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13583', '221.199.9.11', '宁夏自治区银川市', '联通', '0', '2011-04-12', '1'), ('13584', '58.22.113.38', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13585', '124.160.209.230', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13586', '123.147.244.57', '重庆市', '联通', '0', '2011-04-12', '1'), ('13587', '58.16.226.167', '贵州省', '联通', '0', '2011-04-12', '1'), ('13588', '122.194.2.6', '江苏省', '联通', '0', '2011-04-12', '1'), ('13589', '221.194.31.138', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13590', '124.128.255.151', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13591', '112.64.46.80', '上海市', '联通', '0', '2011-04-12', '1'), ('13592', '124.160.209.119', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13593', '61.135.248.201', '北京市', '联通', '0', '2011-04-12', '1'), ('13594', '122.194.2.182', '江苏省', '联通', '0', '2011-04-12', '1'), ('13595', '61.158.152.235', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13596', '122.194.3.23', '江苏省', '联通', '0', '2011-04-12', '1'), ('13597', '115.85.238.33', '甘肃省', '联通', '0', '2011-04-12', '1'), ('13598', '112.64.188.39', '上海市', '联通', '0', '2011-04-12', '1'), ('13599', '112.94.72.90', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13600', '61.135.248.212', '北京市', '联通', '0', '2011-04-12', '1'), ('13601', '122.194.0.226', '江苏省', '联通', '0', '2011-04-12', '1'), ('13602', '122.194.2.94', '江苏省', '联通', '0', '2011-04-12', '1'), ('13603', '124.160.208.72', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13604', '119.62.128.38', '云南省', '联通', '0', '2011-04-12', '1'), ('13605', '221.194.31.141', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13606', '61.158.152.105', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13607', '112.64.190.138', '上海市', '联通', '0', '2011-04-12', '1'), ('13608', '124.160.208.160', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13609', '116.114.82.68', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('13610', '124.128.255.153', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13611', '61.135.249.2', '北京市', '联通', '0', '2011-04-12', '1'), ('13612', '112.64.188.30', '上海市', '联通', '0', '2011-04-12', '1'), ('13613', '221.194.30.186', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13614', '218.28.87.14', '河南省南阳市', '联通', '0', '2011-04-12', '1'), ('13615', '61.135.248.226', '北京市', '联通', '0', '2011-04-12', '1'), ('13616', '122.136.228.151', '吉林省', '联通', '0', '2011-04-12', '1'), ('13617', '222.134.158.32', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('13618', '58.243.250.124', '安徽省', '联通', '0', '2011-04-12', '1'), ('13619', '61.158.152.246', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13620', '119.4.252.66', '四川省', '联通', '0', '2011-04-12', '1'), ('13621', '61.135.249.88', '北京市', '联通', '0', '2011-04-12', '1'), ('13622', '112.96.170.251', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13623', '61.135.249.7', '北京市', '联通', '0', '2011-04-12', '1'), ('13624', '124.160.208.233', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13625', '58.22.114.70', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13626', '123.147.244.24', '重庆市', '联通', '0', '2011-04-12', '1'), ('13627', '124.160.208.178', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13628', '61.135.248.190', '北京市', '联通', '0', '2011-04-12', '1'), ('13629', '61.158.152.222', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13630', '124.160.209.111', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13631', '121.31.250.38', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13632', '112.96.140.194', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13633', '110.16.224.16', '内蒙古鄂尔多斯市', '联通', '0', '2011-04-12', '1'), ('13634', '116.114.82.65', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('13635', '124.160.208.164', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13636', '112.97.67.72', '广东省', '联通', '0', '2011-04-12', '1'), ('13637', '58.243.254.60', '安徽省', '联通', '0', '2011-04-12', '1'), ('13638', '124.160.208.54', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13639', '124.160.209.93', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13640', '113.58.8.215', '海南省', '联通', '0', '2011-04-12', '1'), ('13641', '113.58.26.230', '海南省', '联通', '0', '2011-04-12', '1'), ('13642', '61.158.152.155', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13643', '123.147.244.42', '重庆市', '联通', '0', '2011-04-12', '1'), ('13644', '221.9.247.10', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13645', '118.212.172.253', '江西省', '联通', '0', '2011-04-12', '1'), ('13646', '221.194.31.100', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13647', '61.135.249.237', '北京市', '联通', '0', '2011-04-12', '1'), ('13648', '122.194.2.211', '江苏省', '联通', '0', '2011-04-12', '1'), ('13649', '120.87.16.50', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('13650', '119.248.9.34', '河北省石家庄市', '联通', '0', '2011-04-12', '1'), ('13651', '202.99.84.55', '天津市', '联通', '0', '2011-04-12', '1'), ('13652', '124.160.208.97', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13653', '61.158.152.142', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13654', '221.194.30.108', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13655', '202.99.125.204', '天津市', '联通', '0', '2011-04-12', '1'), ('13656', '124.160.209.207', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13657', '112.96.173.91', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13658', '112.224.2.70', '山东省', '联通', '0', '2011-04-12', '1'), ('13659', '58.248.125.251', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13660', '221.194.31.110', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13661', '123.147.244.45', '重庆市', '联通', '0', '2011-04-12', '1'), ('13662', '112.64.188.37', '上海市', '联通', '0', '2011-04-12', '1'), ('13663', '124.160.208.251', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13664', '61.135.249.114', '北京市', '联通', '0', '2011-04-12', '1'), ('13665', '218.60.139.48', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13666', '220.199.227.97', '广东省', '联通', '0', '2011-04-12', '1'), ('13667', '124.128.255.155', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13668', '123.147.244.58', '重庆市', '联通', '0', '2011-04-12', '1'), ('13669', '122.194.1.218', '江苏省', '联通', '0', '2011-04-12', '1'), ('13670', '124.160.209.43', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13671', '122.136.238.31', '吉林省', '联通', '0', '2011-04-12', '1'), ('13672', '222.132.155.62', '山东省泰安市', '联通', '0', '2011-04-12', '1'), ('13673', '221.194.30.153', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13674', '124.160.208.140', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13675', '61.135.248.174', '北京市', '联通', '0', '2011-04-12', '1'), ('13676', '61.135.248.223', '北京市', '联通', '0', '2011-04-12', '1'), ('13677', '61.135.249.63', '北京市', '联通', '0', '2011-04-12', '1'), ('13678', '61.135.249.108', '北京市', '联通', '0', '2011-04-12', '1'), ('13679', '124.128.255.138', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13680', '61.135.249.99', '北京市', '联通', '0', '2011-04-12', '1'), ('13681', '61.135.249.123', '北京市', '联通', '0', '2011-04-12', '1'), ('13682', '61.135.249.87', '北京市', '联通', '0', '2011-04-12', '1'), ('13683', '61.135.249.135', '北京市', '联通', '0', '2011-04-12', '1'), ('13684', '61.135.249.12', '北京市', '联通', '0', '2011-04-12', '1'), ('13685', '61.135.249.125', '北京市', '联通', '0', '2011-04-12', '1'), ('13686', '112.97.250.198', '广东省', '联通', '0', '2011-04-12', '1'), ('13687', '61.135.249.84', '北京市', '联通', '0', '2011-04-12', '1'), ('13688', '61.135.249.199', '北京市', '联通', '0', '2011-04-12', '1'), ('13689', '124.160.208.183', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13690', '61.158.152.39', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13691', '122.194.1.190', '江苏省', '联通', '0', '2011-04-12', '1'), ('13692', '61.135.249.122', '北京市', '联通', '0', '2011-04-12', '1'), ('13693', '112.64.190.137', '上海市', '联通', '0', '2011-04-12', '1'), ('13694', '61.135.249.70', '北京市', '联通', '0', '2011-04-12', '1'), ('13695', '123.147.144.150', '重庆市', '联通', '0', '2011-04-12', '1'), ('13696', '61.135.249.78', '北京市', '联通', '0', '2011-04-12', '1'), ('13697', '61.135.249.24', '北京市', '联通', '0', '2011-04-12', '1'), ('13698', '61.135.248.199', '北京市', '联通', '0', '2011-04-12', '1'), ('13699', '61.135.249.18', '北京市', '联通', '0', '2011-04-12', '1'), ('13700', '61.135.249.42', '北京市', '联通', '0', '2011-04-12', '1'), ('13701', '60.4.158.112', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('13702', '61.135.249.104', '北京市', '联通', '0', '2011-04-12', '1'), ('13703', '112.64.188.40', '上海市', '联通', '0', '2011-04-12', '1'), ('13704', '120.82.109.126', '广东省', '联通', '0', '2011-04-12', '1'), ('13705', '61.135.249.115', '北京市', '联通', '0', '2011-04-12', '1'), ('13706', '61.135.249.194', '北京市', '联通', '0', '2011-04-12', '1'), ('13707', '61.158.152.26', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13708', '61.135.249.72', '北京市', '联通', '0', '2011-04-12', '1'), ('13709', '61.135.249.67', '北京市', '联通', '0', '2011-04-12', '1'), ('13710', '61.135.249.37', '北京市', '联通', '0', '2011-04-12', '1'), ('13711', '61.135.249.30', '北京市', '联通', '0', '2011-04-12', '1'), ('13712', '124.160.209.36', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13713', '61.135.249.86', '北京市', '联通', '0', '2011-04-12', '1'), ('13714', '112.65.11.168', '上海市', '联通', '0', '2011-04-12', '1'), ('13715', '122.194.2.179', '江苏省', '联通', '0', '2011-04-12', '1'), ('13716', '61.135.248.191', '北京市', '联通', '0', '2011-04-12', '1'), ('13717', '61.135.249.54', '北京市', '联通', '0', '2011-04-12', '1'), ('13718', '112.96.161.146', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13719', '61.135.249.39', '北京市', '联通', '0', '2011-04-12', '1'), ('13720', '60.4.145.23', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('13721', '61.135.249.111', '北京市', '联通', '0', '2011-04-12', '1'), ('13722', '116.113.84.195', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('13723', '118.212.191.28', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('13724', '61.135.249.41', '北京市', '联通', '0', '2011-04-12', '1'), ('13725', '202.99.125.118', '天津市', '联通', '0', '2011-04-12', '1'), ('13726', '61.135.249.49', '北京市', '联通', '0', '2011-04-12', '1'), ('13727', '61.135.249.173', '北京市', '联通', '0', '2011-04-12', '1'), ('13728', '61.135.249.167', '北京市', '联通', '0', '2011-04-12', '1'), ('13729', '123.10.43.120', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('13730', '61.135.249.177', '北京市', '联通', '0', '2011-04-12', '1'), ('13731', '61.135.249.172', '北京市', '联通', '0', '2011-04-12', '1'), ('13732', '119.180.176.19', '山东省', '联通', '0', '2011-04-12', '1'), ('13733', '113.58.22.133', '海南省', '联通', '0', '2011-04-12', '1'), ('13734', '113.58.8.145', '海南省', '联通', '0', '2011-04-12', '1'), ('13735', '113.5.0.61', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('13736', '113.58.0.106', '海南省', '联通', '0', '2011-04-12', '1'), ('13737', '58.243.254.16', '安徽省', '联通', '0', '2011-04-12', '1'), ('13738', '61.158.152.219', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13739', '61.135.248.176', '北京市', '联通', '0', '2011-04-12', '1'), ('13740', '122.194.2.237', '江苏省', '联通', '0', '2011-04-12', '1'), ('13741', '61.135.249.253', '北京市', '联通', '0', '2011-04-12', '1'), ('13742', '122.194.0.35', '江苏省', '联通', '0', '2011-04-12', '1'), ('13743', '61.158.152.151', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13744', '123.147.244.17', '重庆市', '联通', '0', '2011-04-12', '1'), ('13745', '61.135.249.141', '北京市', '联通', '0', '2011-04-12', '1'), ('13746', '60.210.150.242', '山东省潍坊市', '联通', '0', '2011-04-12', '1'), ('13747', '61.135.249.103', '北京市', '联通', '0', '2011-04-12', '1'), ('13748', '61.135.248.235', '北京市', '联通', '0', '2011-04-12', '1'), ('13749', '61.135.248.187', '北京市', '联通', '0', '2011-04-12', '1'), ('13750', '124.128.255.130', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13751', '61.135.248.181', '北京市', '联通', '0', '2011-04-12', '1'), ('13752', '61.135.248.179', '北京市', '联通', '0', '2011-04-12', '1'), ('13753', '122.194.3.142', '江苏省', '联通', '0', '2011-04-12', '1'), ('13754', '61.135.249.33', '北京市', '联通', '0', '2011-04-12', '1'), ('13755', '61.135.249.127', '北京市', '联通', '0', '2011-04-12', '1'), ('13756', '124.160.208.168', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13757', '61.135.249.90', '北京市', '联通', '0', '2011-04-12', '1'), ('13758', '123.128.232.121', '山东省威海市', '联通', '0', '2011-04-12', '1'), ('13759', '61.135.249.8', '北京市', '联通', '0', '2011-04-12', '1'), ('13760', '220.199.129.101', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13761', '61.135.248.213', '北京市', '联通', '0', '2011-04-12', '1'), ('13762', '114.247.10.71', '北京市', '联通', '0', '2011-04-12', '1'), ('13763', '61.135.249.58', '北京市', '联通', '0', '2011-04-12', '1'), ('13764', '61.135.249.28', '北京市', '联通', '0', '2011-04-12', '1'), ('13765', '112.96.237.93', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13766', '124.160.209.187', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13767', '61.135.249.95', '北京市', '联通', '0', '2011-04-12', '1'), ('13768', '119.4.252.29', '四川省', '联通', '0', '2011-04-12', '1'), ('13769', '61.135.249.168', '北京市', '联通', '0', '2011-04-12', '1'), ('13770', '113.58.17.162', '海南省', '联通', '0', '2011-04-12', '1'), ('13771', '122.194.2.50', '江苏省', '联通', '0', '2011-04-12', '1'), ('13772', '123.128.157.167', '山东省威海市', '联通', '0', '2011-04-12', '1'), ('13773', '113.58.19.240', '海南省', '联通', '0', '2011-04-12', '1'), ('13774', '61.135.248.216', '北京市', '联通', '0', '2011-04-12', '1'), ('13775', '61.135.249.80', '北京市', '联通', '0', '2011-04-12', '1'), ('13776', '118.212.171.39', '江西省', '联通', '0', '2011-04-12', '1'), ('13777', '123.130.198.108', '山东省菏泽市', '联通', '0', '2011-04-12', '1'), ('13778', '60.20.114.131', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13779', '61.135.249.47', '北京市', '联通', '0', '2011-04-12', '1'), ('13780', '61.135.249.25', '北京市', '联通', '0', '2011-04-12', '1'), ('13781', '123.147.244.18', '重庆市', '联通', '0', '2011-04-12', '1'), ('13782', '123.147.244.41', '重庆市', '联通', '0', '2011-04-12', '1'), ('13783', '61.135.248.215', '北京市', '联通', '0', '2011-04-12', '1'), ('13784', '112.109.197.199', '福建省', '联通', '0', '2011-04-12', '1'), ('13785', '112.224.2.47', '山东省', '联通', '0', '2011-04-12', '1'), ('13786', '124.90.137.178', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('13787', '61.135.249.130', '北京市', '联通', '0', '2011-04-12', '1'), ('13788', '221.204.67.164', '山西省太原市', '联通', '0', '2011-04-12', '1'), ('13789', '58.243.254.58', '安徽省', '联通', '0', '2011-04-12', '1'), ('13790', '218.60.139.254', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13791', '61.135.249.143', '北京市', '联通', '0', '2011-04-12', '1'), ('13792', '119.4.252.152', '四川省', '联通', '0', '2011-04-12', '1'), ('13793', '61.135.248.210', '北京市', '联通', '0', '2011-04-12', '1'), ('13794', '61.135.249.140', '北京市', '联通', '0', '2011-04-12', '1'), ('13795', '61.135.249.156', '北京市', '联通', '0', '2011-04-12', '1'), ('13796', '61.135.248.186', '北京市', '联通', '0', '2011-04-12', '1'), ('13797', '61.135.249.66', '北京市', '联通', '0', '2011-04-12', '1'), ('13798', '61.135.249.92', '北京市', '联通', '0', '2011-04-12', '1'), ('13799', '61.163.108.6', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13800', '61.135.248.183', '北京市', '联通', '0', '2011-04-12', '1'), ('13801', '61.135.249.231', '北京市', '联通', '0', '2011-04-12', '1'), ('13802', '112.94.71.61', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13803', '113.58.19.18', '海南省', '联通', '0', '2011-04-12', '1'), ('13804', '61.135.249.200', '北京市', '联通', '0', '2011-04-12', '1'), ('13805', '202.108.50.71', '北京市', '联通', '0', '2011-04-12', '1'), ('13806', '221.11.61.101', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13807', '61.135.249.10', '北京市', '联通', '0', '2011-04-12', '1'), ('13808', '113.57.244.174', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13809', '112.224.3.57', '山东省', '联通', '0', '2011-04-12', '1'), ('13810', '61.135.249.60', '北京市', '联通', '0', '2011-04-12', '1'), ('13811', '202.108.50.74', '北京市', '联通', '0', '2011-04-12', '1'), ('13812', '58.253.30.245', '广东省汕头市', '联通', '0', '2011-04-12', '1'), ('13813', '113.58.30.46', '海南省', '联通', '0', '2011-04-12', '1'), ('13814', '221.11.61.221', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13815', '221.11.61.28', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13816', '61.158.152.19', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13817', '61.135.249.32', '北京市', '联通', '0', '2011-04-12', '1'), ('13818', '221.11.61.70', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13819', '221.9.247.22', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13820', '61.135.249.55', '北京市', '联通', '0', '2011-04-12', '1'), ('13821', '221.11.61.23', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13822', '119.163.122.253', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13823', '221.11.61.25', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13824', '124.160.208.75', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13825', '112.97.218.229', '广东省', '联通', '0', '2011-04-12', '1'), ('13826', '61.135.249.198', '北京市', '联通', '0', '2011-04-12', '1'), ('13827', '221.11.61.181', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13828', '221.11.61.159', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13829', '61.135.248.211', '北京市', '联通', '0', '2011-04-12', '1'), ('13830', '221.11.61.93', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13831', '124.160.208.71', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13832', '221.194.31.230', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13833', '120.87.9.243', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('13834', '58.243.254.4', '安徽省', '联通', '0', '2011-04-12', '1'), ('13835', '220.199.212.56', '广东省', '联通', '0', '2011-04-12', '1'), ('13836', '119.62.127.250', '云南省', '联通', '0', '2011-04-12', '1'), ('13837', '221.194.30.140', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13838', '123.122.114.130', '北京市', '联通', '0', '2011-04-12', '1'), ('13839', '221.11.61.12', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13840', '61.135.249.229', '北京市', '联通', '0', '2011-04-12', '1'), ('13841', '221.11.61.13', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13842', '124.160.209.165', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13843', '119.39.249.39', '湖南省', '联通', '0', '2011-04-12', '1'), ('13844', '220.249.166.58', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13845', '122.136.147.35', '吉林省延边州', '联通', '0', '2011-04-12', '1'), ('13846', '122.194.2.44', '江苏省', '联通', '0', '2011-04-12', '1'), ('13847', '61.158.152.167', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13848', '221.194.30.180', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13849', '220.199.162.187', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13850', '221.194.30.65', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13851', '124.160.208.155', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13852', '218.26.158.14', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('13853', '124.160.209.226', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13854', '119.4.252.97', '四川省', '联通', '0', '2011-04-12', '1'), ('13855', '221.11.61.242', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13856', '61.158.152.224', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13857', '221.209.93.227', '黑龙江省齐齐哈尔市', '联通', '0', '2011-04-12', '1'), ('13858', '112.96.222.104', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13859', '221.194.30.187', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13860', '58.243.250.107', '安徽省', '联通', '0', '2011-04-12', '1'), ('13861', '123.118.210.3', '北京市', '联通', '0', '2011-04-12', '1'), ('13862', '220.199.242.43', '广东省', '联通', '0', '2011-04-12', '1'), ('13863', '221.194.31.204', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13864', '119.178.137.50', '山东省荷泽市', '联通', '0', '2011-04-12', '1'), ('13865', '61.158.152.43', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13866', '119.62.127.175', '云南省', '联通', '0', '2011-04-12', '1'), ('13867', '112.96.208.224', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13868', '61.135.248.196', '北京市', '联通', '0', '2011-04-12', '1'), ('13869', '221.11.61.36', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13870', '221.11.61.164', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13871', '124.160.209.56', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13872', '114.243.224.36', '北京市', '联通', '0', '2011-04-12', '1'), ('13873', '58.244.58.233', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13874', '121.31.250.37', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13875', '121.31.250.10', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13876', '121.31.250.45', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13877', '123.132.67.117', '山东省济宁市', '联通', '0', '2011-04-12', '1'), ('13878', '61.158.152.210', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13879', '61.135.249.101', '北京市', '联通', '0', '2011-04-12', '1'), ('13880', '119.62.127.168', '云南省', '联通', '0', '2011-04-12', '1'), ('13881', '61.135.249.180', '北京市', '联通', '0', '2011-04-12', '1'), ('13882', '60.216.120.118', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13883', '221.11.61.214', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13884', '119.62.127.242', '云南省', '联通', '0', '2011-04-12', '1'), ('13885', '61.135.249.174', '北京市', '联通', '0', '2011-04-12', '1'), ('13886', '112.97.118.106', '广东省', '联通', '0', '2011-04-12', '1'), ('13887', '61.135.249.82', '北京市', '联通', '0', '2011-04-12', '1'), ('13888', '220.199.252.219', '广东省', '联通', '0', '2011-04-12', '1'), ('13889', '221.194.31.147', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13890', '220.199.222.101', '广东省', '联通', '0', '2011-04-12', '1'), ('13891', '119.4.252.170', '四川省', '联通', '0', '2011-04-12', '1'), ('13892', '120.84.44.31', '广东省', '联通', '0', '2011-04-12', '1'), ('13893', '221.194.30.60', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13894', '124.160.208.135', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13895', '61.135.249.159', '北京市', '联通', '0', '2011-04-12', '1'), ('13896', '112.64.190.141', '上海市', '联通', '0', '2011-04-12', '1'), ('13897', '61.135.248.203', '北京市', '联通', '0', '2011-04-12', '1'), ('13898', '222.130.132.145', '北京市', '联通', '0', '2011-04-12', '1'), ('13899', '112.224.3.120', '山东省', '联通', '0', '2011-04-12', '1'), ('13900', '123.122.127.158', '北京市', '联通', '0', '2011-04-12', '1'), ('13901', '220.199.243.147', '广东省', '联通', '0', '2011-04-12', '1'), ('13902', '122.194.2.177', '江苏省', '联通', '0', '2011-04-12', '1'), ('13903', '115.85.238.129', '甘肃省', '联通', '0', '2011-04-12', '1'), ('13904', '221.9.247.16', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('13905', '119.62.127.23', '云南省', '联通', '0', '2011-04-12', '1'), ('13906', '221.11.61.131', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13907', '123.116.200.116', '北京市', '联通', '0', '2011-04-12', '1'), ('13908', '125.34.149.76', '北京市', '联通', '0', '2011-04-12', '1'), ('13909', '220.199.188.133', '广东省', '联通', '0', '2011-04-12', '1'), ('13910', '221.11.61.136', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13911', '119.62.127.85', '云南省', '联通', '0', '2011-04-12', '1'), ('13912', '61.135.249.223', '北京市', '联通', '0', '2011-04-12', '1'), ('13913', '61.158.152.96', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13914', '58.22.113.26', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('13915', '123.119.238.44', '北京市', '联通', '0', '2011-04-12', '1'), ('13916', '119.39.249.98', '湖南省', '联通', '0', '2011-04-12', '1'), ('13917', '221.194.31.104', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13918', '58.243.250.113', '安徽省', '联通', '0', '2011-04-12', '1'), ('13919', '112.96.217.133', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13920', '61.135.249.232', '北京市', '联通', '0', '2011-04-12', '1'), ('13921', '61.158.152.166', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13922', '124.160.209.1', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13923', '61.135.249.195', '北京市', '联通', '0', '2011-04-12', '1'), ('13924', '124.160.209.59', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13925', '120.84.95.111', '广东省', '联通', '0', '2011-04-12', '1'), ('13926', '61.135.248.229', '北京市', '联通', '0', '2011-04-12', '1'), ('13927', '123.119.239.73', '北京市', '联通', '0', '2011-04-12', '1'), ('13928', '61.135.249.109', '北京市', '联通', '0', '2011-04-12', '1'), ('13929', '221.11.61.241', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13930', '123.122.123.126', '北京市', '联通', '0', '2011-04-12', '1'), ('13931', '61.135.249.224', '北京市', '联通', '0', '2011-04-12', '1'), ('13932', '112.96.121.229', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13933', '61.135.249.116', '北京市', '联通', '0', '2011-04-12', '1'), ('13934', '113.58.36.65', '海南省', '联通', '0', '2011-04-12', '1'), ('13935', '115.54.75.126', '河南省', '联通', '0', '2011-04-12', '1'), ('13936', '61.135.249.35', '北京市', '联通', '0', '2011-04-12', '1'), ('13937', '61.135.249.230', '北京市', '联通', '0', '2011-04-12', '1'), ('13938', '110.7.212.114', '内蒙古', '联通', '0', '2011-04-12', '1'), ('13939', '58.250.167.51', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('13940', '221.4.182.60', '广东省江门市', '联通', '0', '2011-04-12', '1'), ('13941', '122.194.3.211', '江苏省', '联通', '0', '2011-04-12', '1'), ('13942', '124.160.208.159', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13943', '221.194.30.207', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13944', '119.4.252.158', '四川省', '联通', '0', '2011-04-12', '1'), ('13945', '61.135.249.249', '北京市', '联通', '0', '2011-04-12', '1'), ('13946', '220.199.170.172', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13947', '61.135.249.69', '北京市', '联通', '0', '2011-04-12', '1'), ('13948', '112.96.162.155', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13949', '61.158.152.200', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('13950', '119.163.122.242', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('13951', '58.247.42.50', '上海市', '联通', '0', '2011-04-12', '1'), ('13952', '115.46.180.104', '广西自治区', '联通', '0', '2011-04-12', '1'), ('13953', '220.199.75.172', '广东省', '联通', '0', '2011-04-12', '1'), ('13954', '113.57.244.111', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13955', '61.135.249.110', '北京市', '联通', '0', '2011-04-12', '1'), ('13956', '110.7.215.47', '内蒙古', '联通', '0', '2011-04-12', '1'), ('13957', '61.135.249.244', '北京市', '联通', '0', '2011-04-12', '1'), ('13958', '122.194.3.203', '江苏省', '联通', '0', '2011-04-12', '1'), ('13959', '221.194.31.196', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('13960', '61.135.249.112', '北京市', '联通', '0', '2011-04-12', '1'), ('13961', '122.194.2.101', '江苏省', '联通', '0', '2011-04-12', '1'), ('13962', '124.160.209.141', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13963', '112.94.87.83', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13964', '119.248.114.211', '河北省', '联通', '0', '2011-04-12', '1'), ('13965', '61.135.249.64', '北京市', '联通', '0', '2011-04-12', '1'), ('13966', '110.7.66.88', '内蒙古', '联通', '0', '2011-04-12', '1'), ('13967', '122.136.238.218', '吉林省', '联通', '0', '2011-04-12', '1'), ('13968', '113.57.246.71', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13969', '112.97.129.71', '广东省', '联通', '0', '2011-04-12', '1'), ('13970', '113.57.244.231', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13971', '61.135.248.180', '北京市', '联通', '0', '2011-04-12', '1'), ('13972', '120.84.86.123', '广东省', '联通', '0', '2011-04-12', '1'), ('13973', '61.180.129.157', '黑龙江省海伦市', '联通', '0', '2011-04-12', '1'), ('13974', '112.97.173.172', '广东省', '联通', '0', '2011-04-12', '1'), ('13975', '218.60.139.68', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13976', '114.250.34.178', '北京市', '联通', '0', '2011-04-12', '1'), ('13977', '113.57.246.75', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('13978', '210.22.8.226', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('13979', '122.194.2.61', '江苏省', '联通', '0', '2011-04-12', '1'), ('13980', '110.7.69.223', '内蒙古', '联通', '0', '2011-04-12', '1'), ('13981', '112.96.91.76', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('13982', '220.199.208.172', '广东省', '联通', '0', '2011-04-12', '1'), ('13983', '122.194.1.180', '江苏省', '联通', '0', '2011-04-12', '1'), ('13984', '121.31.250.2', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('13985', '112.96.239.195', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('13986', '122.194.2.1', '江苏省', '联通', '0', '2011-04-12', '1'), ('13987', '222.130.134.82', '北京市', '联通', '0', '2011-04-12', '1'), ('13988', '112.224.3.63', '山东省', '联通', '0', '2011-04-12', '1'), ('13989', '124.160.209.14', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13990', '124.90.140.218', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('13991', '221.11.61.185', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('13992', '124.160.208.156', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13993', '218.60.138.248', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('13994', '220.199.224.212', '广东省', '联通', '0', '2011-04-12', '1'), ('13995', '61.135.249.150', '北京市', '联通', '0', '2011-04-12', '1'), ('13996', '61.135.249.179', '北京市', '联通', '0', '2011-04-12', '1'), ('13997', '124.160.209.67', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('13998', '61.135.249.22', '北京市', '联通', '0', '2011-04-12', '1'), ('13999', '61.158.152.125', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14000', '61.158.152.209', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14001', '61.135.249.161', '北京市', '联通', '0', '2011-04-12', '1'), ('14002', '112.96.135.103', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14003', '61.135.249.61', '北京市', '联通', '0', '2011-04-12', '1'), ('14004', '61.158.152.83', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14005', '119.4.252.39', '四川省', '联通', '0', '2011-04-12', '1'), ('14006', '61.135.249.45', '北京市', '联通', '0', '2011-04-12', '1'), ('14007', '61.135.249.175', '北京市', '联通', '0', '2011-04-12', '1'), ('14008', '113.58.19.19', '海南省', '联通', '0', '2011-04-12', '1'), ('14009', '118.212.172.221', '江西省', '联通', '0', '2011-04-12', '1'), ('14010', '115.56.116.49', '河南省', '联通', '0', '2011-04-12', '1'), ('14011', '124.160.209.63', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14012', '61.135.249.4', '北京市', '联通', '0', '2011-04-12', '1'), ('14013', '123.147.244.12', '重庆市', '联通', '0', '2011-04-12', '1'), ('14014', '58.243.254.27', '安徽省', '联通', '0', '2011-04-12', '1'), ('14015', '114.241.163.132', '北京市', '联通', '0', '2011-04-12', '1'), ('14016', '61.158.152.103', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14017', '61.135.249.147', '北京市', '联通', '0', '2011-04-12', '1'), ('14018', '221.194.44.14', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('14019', '58.243.254.59', '安徽省', '联通', '0', '2011-04-12', '1'), ('14020', '61.135.249.138', '北京市', '联通', '0', '2011-04-12', '1'), ('14021', '218.26.158.27', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14022', '61.135.248.232', '北京市', '联通', '0', '2011-04-12', '1'), ('14023', '124.160.208.182', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14024', '124.160.208.211', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14025', '122.194.2.31', '江苏省', '联通', '0', '2011-04-12', '1'), ('14026', '61.135.249.74', '北京市', '联通', '0', '2011-04-12', '1'), ('14027', '221.194.30.81', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14028', '61.158.152.6', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14029', '218.60.139.137', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14030', '61.158.152.77', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14031', '61.158.152.251', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14032', '218.29.38.21', '河南省南阳市', '联通', '0', '2011-04-12', '1'), ('14033', '119.116.193.52', '辽宁省', '联通', '0', '2011-04-12', '1'), ('14034', '122.194.2.230', '江苏省', '联通', '0', '2011-04-12', '1'), ('14035', '124.160.208.252', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14036', '61.135.249.53', '北京市', '联通', '0', '2011-04-12', '1'), ('14037', '125.34.106.180', '北京市', '联通', '0', '2011-04-12', '1'), ('14038', '110.7.215.212', '内蒙古', '联通', '0', '2011-04-12', '1'), ('14039', '220.196.52.183', '上海市', '联通', '0', '2011-04-12', '1'), ('14040', '61.158.152.82', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14041', '124.160.208.196', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14042', '218.26.158.10', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14043', '110.247.185.181', '河北省衡水市', '联通', '0', '2011-04-12', '1'), ('14044', '58.247.36.35', '上海市', '联通', '0', '2011-04-12', '1'), ('14045', '118.212.171.213', '江西省', '联通', '0', '2011-04-12', '1'), ('14046', '61.158.152.18', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14047', '61.135.249.11', '北京市', '联通', '0', '2011-04-12', '1'), ('14048', '124.160.208.77', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14049', '119.39.248.41', '湖南省', '联通', '0', '2011-04-12', '1'), ('14050', '114.243.232.89', '北京市', '联通', '0', '2011-04-12', '1'), ('14051', '112.97.143.14', '广东省', '联通', '0', '2011-04-12', '1'), ('14052', '124.128.255.141', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14053', '124.160.209.224', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14054', '61.158.152.184', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14055', '61.135.249.46', '北京市', '联通', '0', '2011-04-12', '1'), ('14056', '113.226.21.238', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14057', '124.160.208.161', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14058', '124.128.255.139', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14059', '61.158.152.145', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14060', '220.199.201.234', '广东省', '联通', '0', '2011-04-12', '1'), ('14061', '112.96.153.26', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14062', '115.48.136.197', '河南省', '联通', '0', '2011-04-12', '1'), ('14063', '112.97.51.84', '广东省', '联通', '0', '2011-04-12', '1'), ('14064', '116.112.70.92', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('14065', '124.160.209.140', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14066', '124.160.209.9', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14067', '220.199.178.250', '广东省', '联通', '0', '2011-04-12', '1'), ('14068', '124.160.209.149', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14069', '112.224.3.55', '山东省', '联通', '0', '2011-04-12', '1'), ('14070', '221.9.247.19', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('14071', '123.122.118.5', '北京市', '联通', '0', '2011-04-12', '1'), ('14072', '112.97.47.100', '广东省', '联通', '0', '2011-04-12', '1'), ('14073', '112.96.201.102', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14074', '61.135.249.62', '北京市', '联通', '0', '2011-04-12', '1'), ('14075', '61.158.152.220', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14076', '119.39.249.85', '湖南省', '联通', '0', '2011-04-12', '1'), ('14077', '58.243.250.72', '安徽省', '联通', '0', '2011-04-12', '1'), ('14078', '119.4.252.57', '四川省', '联通', '0', '2011-04-12', '1'), ('14079', '112.96.82.106', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14080', '58.22.113.15', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14081', '221.9.247.21', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('14082', '221.194.30.49', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14083', '112.97.85.240', '广东省', '联通', '0', '2011-04-12', '1'), ('14084', '122.194.3.155', '江苏省', '联通', '0', '2011-04-12', '1'), ('14085', '124.160.208.221', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14086', '60.214.229.79', '山东省东营市', '联通', '0', '2011-04-12', '1'), ('14087', '124.160.208.50', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14088', '114.247.10.126', '北京市', '联通', '0', '2011-04-12', '1'), ('14089', '111.163.1.113', '天津市', '联通', '0', '2011-04-12', '1'), ('14090', '61.158.152.241', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14091', '61.158.152.171', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14092', '112.94.81.125', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14093', '119.39.248.6', '湖南省', '联通', '0', '2011-04-12', '1'), ('14094', '220.250.41.41', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14095', '124.160.208.40', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14096', '112.224.2.15', '山东省', '联通', '0', '2011-04-12', '1'), ('14097', '220.198.132.11', '广东省', '联通', '0', '2011-04-12', '1'), ('14098', '121.31.250.4', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('14099', '122.194.1.212', '江苏省', '联通', '0', '2011-04-12', '1'), ('14100', '123.118.91.243', '北京市', '联通', '0', '2011-04-12', '1'), ('14101', '61.158.152.129', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14102', '122.194.3.74', '江苏省', '联通', '0', '2011-04-12', '1'), ('14103', '112.224.3.62', '山东省', '联通', '0', '2011-04-12', '1'), ('14104', '113.58.4.25', '海南省', '联通', '0', '2011-04-12', '1'), ('14105', '124.160.208.115', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14106', '218.26.158.1', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14107', '123.156.39.27', '浙江省金华市', '联通', '0', '2011-04-12', '1'), ('14108', '112.224.3.47', '山东省', '联通', '0', '2011-04-12', '1'), ('14109', '112.224.2.2', '山东省', '联通', '0', '2011-04-12', '1'), ('14110', '124.128.255.129', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14111', '124.160.208.39', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14112', '61.158.152.87', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14113', '61.158.152.240', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14114', '112.96.150.30', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14115', '119.39.249.68', '湖南省', '联通', '0', '2011-04-12', '1'), ('14116', '61.158.152.100', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14117', '112.64.190.33', '上海市', '联通', '0', '2011-04-12', '1'), ('14118', '122.194.3.19', '江苏省', '联通', '0', '2011-04-12', '1'), ('14119', '220.199.231.98', '广东省', '联通', '0', '2011-04-12', '1'), ('14120', '119.62.127.57', '云南省', '联通', '0', '2011-04-12', '1'), ('14121', '123.159.32.149', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14122', '61.158.152.236', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14123', '112.224.2.63', '山东省', '联通', '0', '2011-04-12', '1'), ('14124', '115.56.116.77', '河南省', '联通', '0', '2011-04-12', '1'), ('14125', '221.11.61.150', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14126', '218.60.140.213', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14127', '112.96.160.125', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14128', '119.4.252.24', '四川省', '联通', '0', '2011-04-12', '1'), ('14129', '116.3.194.172', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14130', '112.96.139.181', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14131', '120.84.93.99', '广东省', '联通', '0', '2011-04-12', '1'), ('14132', '220.198.141.40', '广东省', '联通', '0', '2011-04-12', '1'), ('14133', '120.84.67.200', '广东省', '联通', '0', '2011-04-12', '1'), ('14134', '220.198.151.64', '广东省清远市', '联通', '0', '2011-04-12', '1'), ('14135', '112.94.182.110', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14136', '113.57.244.182', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14137', '124.128.255.137', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14138', '119.163.122.248', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14139', '115.55.97.1', '河南省', '联通', '0', '2011-04-12', '1'), ('14140', '119.4.252.111', '四川省', '联通', '0', '2011-04-12', '1'), ('14141', '112.94.240.41', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14142', '58.22.114.102', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14143', '119.4.217.215', '四川省', '联通', '0', '2011-04-12', '1'), ('14144', '112.64.188.36', '上海市', '联通', '0', '2011-04-12', '1'), ('14145', '113.57.244.121', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14146', '113.5.0.62', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('14147', '113.58.31.130', '海南省', '联通', '0', '2011-04-12', '1'), ('14148', '112.96.97.154', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14149', '112.64.190.125', '上海市', '联通', '0', '2011-04-12', '1'), ('14150', '123.138.242.55', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14151', '221.13.78.2', '西藏拉萨市', '联通', '0', '2011-04-12', '1'), ('14152', '220.199.241.122', '广东省', '联通', '0', '2011-04-12', '1'), ('14153', '119.4.252.228', '四川省', '联通', '0', '2011-04-12', '1'), ('14154', '61.158.152.104', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14155', '221.11.61.233', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14156', '112.97.80.54', '广东省', '联通', '0', '2011-04-12', '1'), ('14157', '110.246.64.212', '河北省邢台市', '联通', '0', '2011-04-12', '1'), ('14158', '123.138.242.153', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14159', '112.64.190.32', '上海市', '联通', '0', '2011-04-12', '1'), ('14160', '122.194.2.243', '江苏省', '联通', '0', '2011-04-12', '1'), ('14161', '124.160.209.127', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14162', '124.160.209.7', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14163', '113.57.244.133', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14164', '218.26.158.21', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14165', '121.31.250.7', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('14166', '112.97.59.9', '广东省', '联通', '0', '2011-04-12', '1'), ('14167', '124.160.209.228', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14168', '123.138.242.171', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14169', '120.87.24.41', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('14170', '119.4.252.125', '四川省', '联通', '0', '2011-04-12', '1'), ('14171', '221.194.31.174', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14172', '116.113.84.193', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('14173', '58.22.77.252', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14174', '220.199.185.90', '广东省', '联通', '0', '2011-04-12', '1'), ('14175', '124.160.209.21', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14176', '218.60.141.9', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('14177', '61.158.152.214', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14178', '119.179.51.32', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14179', '123.138.242.161', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14180', '124.128.255.132', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14181', '218.26.158.6', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14182', '115.56.103.34', '河南省', '联通', '0', '2011-04-12', '1'), ('14183', '122.194.2.90', '江苏省', '联通', '0', '2011-04-12', '1'), ('14184', '124.160.209.2', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14185', '122.194.0.66', '江苏省', '联通', '0', '2011-04-12', '1'), ('14186', '58.243.254.11', '安徽省', '联通', '0', '2011-04-12', '1'), ('14187', '119.4.249.166', '四川省', '联通', '0', '2011-04-12', '1'), ('14188', '124.160.208.118', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14189', '220.199.211.42', '广东省', '联通', '0', '2011-04-12', '1'), ('14190', '113.58.12.68', '海南省', '联通', '0', '2011-04-12', '1'), ('14191', '221.194.30.88', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14192', '124.160.209.34', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14193', '58.243.250.122', '安徽省', '联通', '0', '2011-04-12', '1'), ('14194', '124.160.208.236', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14195', '123.138.242.187', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14196', '123.138.242.110', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14197', '58.22.114.33', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14198', '112.224.2.88', '山东省', '联通', '0', '2011-04-12', '1'), ('14199', '119.4.252.236', '四川省', '联通', '0', '2011-04-12', '1'), ('14200', '120.8.17.52', '河北省邯郸市', '联通', '0', '2011-04-12', '1'), ('14201', '221.11.61.90', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14202', '118.212.172.33', '江西省', '联通', '0', '2011-04-12', '1'), ('14203', '218.60.139.237', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14204', '112.224.3.15', '山东省', '联通', '0', '2011-04-12', '1'), ('14205', '123.138.242.175', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14206', '221.194.30.199', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14207', '221.11.61.196', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14208', '220.199.134.186', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14209', '113.57.244.218', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14210', '113.57.244.201', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14211', '122.194.2.214', '江苏省', '联通', '0', '2011-04-12', '1'), ('14212', '61.158.152.25', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14213', '124.160.208.117', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14214', '123.138.242.208', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14215', '123.138.242.125', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14216', '58.16.226.236', '贵州省', '联通', '0', '2011-04-12', '1'), ('14217', '218.60.140.172', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14218', '115.56.100.241', '河南省', '联通', '0', '2011-04-12', '1'), ('14219', '112.97.134.96', '广东省', '联通', '0', '2011-04-12', '1'), ('14220', '113.57.244.128', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14221', '112.64.188.28', '上海市', '联通', '0', '2011-04-12', '1'), ('14222', '112.224.3.1', '山东省', '联通', '0', '2011-04-12', '1'), ('14223', '61.158.152.93', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14224', '113.57.244.4', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14225', '220.198.110.250', '广东省湛江市', '联通', '0', '2011-04-12', '1'), ('14226', '221.11.61.243', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14227', '218.60.140.31', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14228', '221.194.31.188', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14229', '122.194.0.19', '江苏省', '联通', '0', '2011-04-12', '1'), ('14230', '114.247.10.68', '北京市', '联通', '0', '2011-04-12', '1'), ('14231', '112.96.103.234', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14232', '123.138.242.154', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14233', '58.243.250.83', '安徽省', '联通', '0', '2011-04-12', '1'), ('14234', '221.11.61.2', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14235', '221.194.31.144', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14236', '221.11.61.45', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14237', '218.28.46.141', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('14238', '61.158.152.191', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14239', '113.57.244.80', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14240', '61.158.152.14', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14241', '112.224.3.94', '山东省', '联通', '0', '2011-04-12', '1'), ('14242', '220.199.227.10', '广东省', '联通', '0', '2011-04-12', '1'), ('14243', '113.57.244.51', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14244', '115.56.102.254', '河南省', '联通', '0', '2011-04-12', '1'), ('14245', '221.194.30.63', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14246', '60.13.166.240', '新疆石河子市', '联通', '0', '2011-04-12', '1'), ('14247', '123.138.242.109', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14248', '114.247.10.73', '北京市', '联通', '0', '2011-04-12', '1'), ('14249', '124.160.208.213', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14250', '60.28.164.103', '天津市', '联通', '0', '2011-04-12', '1'), ('14251', '220.198.145.166', '广东省清远市', '联通', '0', '2011-04-12', '1'), ('14252', '124.160.208.129', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14253', '122.194.3.106', '江苏省', '联通', '0', '2011-04-12', '1'), ('14254', '123.138.242.181', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14255', '220.199.254.154', '广东省', '联通', '0', '2011-04-12', '1'), ('14256', '118.212.172.165', '江西省', '联通', '0', '2011-04-12', '1'), ('14257', '61.158.152.69', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14258', '61.158.152.250', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14259', '221.7.5.50', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('14260', '58.243.254.21', '安徽省', '联通', '0', '2011-04-12', '1'), ('14261', '221.11.61.57', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14262', '112.97.98.71', '广东省', '联通', '0', '2011-04-12', '1'), ('14263', '119.4.252.139', '四川省', '联通', '0', '2011-04-12', '1'), ('14264', '119.4.252.74', '四川省', '联通', '0', '2011-04-12', '1'), ('14265', '220.198.71.42', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14266', '221.194.31.127', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14267', '221.194.31.227', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14268', '112.97.240.48', '广东省', '联通', '0', '2011-04-12', '1'), ('14269', '112.224.2.114', '山东省', '联通', '0', '2011-04-12', '1'), ('14270', '61.158.152.212', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14271', '113.57.244.200', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14272', '58.243.254.7', '安徽省', '联通', '0', '2011-04-12', '1'), ('14273', '115.48.138.69', '河南省', '联通', '0', '2011-04-12', '1'), ('14274', '115.56.116.26', '河南省', '联通', '0', '2011-04-12', '1'), ('14275', '112.97.186.240', '广东省', '联通', '0', '2011-04-12', '1'), ('14276', '218.60.139.203', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14277', '61.135.249.91', '北京市', '联通', '0', '2011-04-12', '1'), ('14278', '58.243.254.1', '安徽省', '联通', '0', '2011-04-12', '1'), ('14279', '119.4.252.172', '四川省', '联通', '0', '2011-04-12', '1'), ('14280', '218.60.139.7', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14281', '113.57.244.45', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14282', '112.224.3.86', '山东省', '联通', '0', '2011-04-12', '1'), ('14283', '60.4.71.228', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('14284', '112.224.3.35', '山东省', '联通', '0', '2011-04-12', '1'), ('14285', '119.39.248.65', '湖南省', '联通', '0', '2011-04-12', '1'), ('14286', '202.99.82.23', '天津市', '联通', '0', '2011-04-12', '1'), ('14287', '124.160.208.65', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14288', '112.224.3.19', '山东省', '联通', '0', '2011-04-12', '1'), ('14289', '113.5.32.128', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('14290', '112.224.3.40', '山东省', '联通', '0', '2011-04-12', '1'), ('14291', '114.247.10.70', '北京市', '联通', '0', '2011-04-12', '1'), ('14292', '113.58.31.150', '海南省', '联通', '0', '2011-04-12', '1'), ('14293', '61.158.152.95', '河南省濮阳市', '联通', '0', '2011-04-12', '1');
INSERT INTO `ig_gateway` VALUES ('14294', '218.60.141.222', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('14295', '61.135.249.148', '北京市', '联通', '0', '2011-04-12', '1'), ('14296', '61.158.152.67', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14297', '112.224.3.89', '山东省', '联通', '0', '2011-04-12', '1'), ('14298', '58.22.113.195', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14299', '58.248.192.91', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14300', '218.26.158.56', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14301', '122.194.1.201', '江苏省', '联通', '0', '2011-04-12', '1'), ('14302', '124.160.208.3', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14303', '120.80.49.100', '广东省', '联通', '0', '2011-04-12', '1'), ('14304', '61.135.248.230', '北京市', '联通', '0', '2011-04-12', '1'), ('14305', '61.158.152.94', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14306', '115.50.71.132', '河南省', '联通', '0', '2011-04-12', '1'), ('14307', '220.199.202.206', '广东省', '联通', '0', '2011-04-12', '1'), ('14308', '58.22.114.191', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14309', '221.194.31.148', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14310', '58.243.250.111', '安徽省', '联通', '0', '2011-04-12', '1'), ('14311', '61.135.249.100', '北京市', '联通', '0', '2011-04-12', '1'), ('14312', '61.135.249.124', '北京市', '联通', '0', '2011-04-12', '1'), ('14313', '61.135.249.23', '北京市', '联通', '0', '2011-04-12', '1'), ('14314', '61.135.249.228', '北京市', '联通', '0', '2011-04-12', '1'), ('14315', '218.58.132.116', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('14316', '58.22.113.111', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14317', '112.96.189.85', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14318', '58.243.250.84', '安徽省', '联通', '0', '2011-04-12', '1'), ('14319', '58.22.113.13', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14320', '218.60.140.4', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14321', '124.160.209.200', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14322', '218.60.139.34', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14323', '220.198.130.208', '广东省', '联通', '0', '2011-04-12', '1'), ('14324', '112.96.107.109', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14325', '58.243.250.69', '安徽省', '联通', '0', '2011-04-12', '1'), ('14326', '221.203.79.36', '辽宁省抚顺市', '联通', '0', '2011-04-12', '1'), ('14327', '114.247.10.79', '北京市', '联通', '0', '2011-04-12', '1'), ('14328', '122.194.3.123', '江苏省', '联通', '0', '2011-04-12', '1'), ('14329', '221.194.30.144', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14330', '117.8.182.199', '天津市', '联通', '0', '2011-04-12', '1'), ('14331', '124.160.208.87', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14332', '112.224.3.45', '山东省', '联通', '0', '2011-04-12', '1'), ('14333', '218.60.138.108', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14334', '113.57.244.171', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14335', '119.39.248.21', '湖南省', '联通', '0', '2011-04-12', '1'), ('14336', '220.199.181.2', '广东省', '联通', '0', '2011-04-12', '1'), ('14337', '221.11.61.77', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14338', '121.31.250.3', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('14339', '124.160.208.203', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14340', '113.58.1.153', '海南省', '联通', '0', '2011-04-12', '1'), ('14341', '61.158.152.243', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14342', '122.194.1.69', '江苏省', '联通', '0', '2011-04-12', '1'), ('14343', '124.160.209.198', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14344', '218.109.112.70', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('14345', '58.243.250.105', '安徽省', '联通', '0', '2011-04-12', '1'), ('14346', '124.160.209.206', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14347', '113.58.20.213', '海南省', '联通', '0', '2011-04-12', '1'), ('14348', '118.212.190.100', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('14349', '113.5.0.120', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('14350', '113.5.0.56', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('14351', '124.160.209.11', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14352', '124.160.209.254', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14353', '112.96.108.14', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14354', '111.165.141.228', '天津市', '联通', '0', '2011-04-12', '1'), ('14355', '113.57.244.236', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14356', '124.160.209.237', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14357', '112.96.76.141', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14358', '112.97.228.37', '广东省', '联通', '0', '2011-04-12', '1'), ('14359', '118.212.171.230', '江西省', '联通', '0', '2011-04-12', '1'), ('14360', '58.243.250.121', '安徽省', '联通', '0', '2011-04-12', '1'), ('14361', '124.160.209.96', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14362', '123.127.159.229', '北京市', '联通', '0', '2011-04-12', '1'), ('14363', '58.247.155.207', '上海市', '联通', '0', '2011-04-12', '1'), ('14364', '61.158.152.119', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14365', '221.194.31.162', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14366', '118.212.171.38', '江西省', '联通', '0', '2011-04-12', '1'), ('14367', '122.194.2.147', '江苏省', '联通', '0', '2011-04-12', '1'), ('14368', '119.36.38.12', '湖北省', '联通', '0', '2011-04-12', '1'), ('14369', '118.212.171.106', '江西省', '联通', '0', '2011-04-12', '1'), ('14370', '124.160.208.82', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14371', '58.243.254.41', '安徽省', '联通', '0', '2011-04-12', '1'), ('14372', '112.97.178.242', '广东省', '联通', '0', '2011-04-12', '1'), ('14373', '218.60.140.90', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14374', '218.59.107.178', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14375', '58.248.169.180', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14376', '60.217.248.150', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14377', '116.113.84.192', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('14378', '58.249.33.20', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14379', '220.199.198.254', '广东省', '联通', '0', '2011-04-12', '1'), ('14380', '122.194.0.25', '江苏省', '联通', '0', '2011-04-12', '1'), ('14381', '124.160.209.248', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14382', '113.5.0.63', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('14383', '221.11.61.152', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14384', '220.198.112.154', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('14385', '58.248.162.96', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14386', '112.224.3.42', '山东省', '联通', '0', '2011-04-12', '1'), ('14387', '119.167.30.213', '山东省青岛市', '联通', '0', '2011-04-12', '1'), ('14388', '112.97.47.142', '广东省', '联通', '0', '2011-04-12', '1'), ('14389', '58.249.96.236', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14390', '58.243.250.97', '安徽省', '联通', '0', '2011-04-12', '1'), ('14391', '61.158.152.123', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14392', '113.57.244.100', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14393', '124.160.209.170', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14394', '58.241.3.22', '江苏省无锡市', '联通', '0', '2011-04-12', '1'), ('14395', '222.140.115.249', '河南省济源市', '联通', '0', '2011-04-12', '1'), ('14396', '118.212.171.205', '江西省', '联通', '0', '2011-04-12', '1'), ('14397', '118.212.171.203', '江西省', '联通', '0', '2011-04-12', '1'), ('14398', '60.4.83.151', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('14399', '112.97.155.239', '广东省', '联通', '0', '2011-04-12', '1'), ('14400', '221.9.247.13', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('14401', '112.97.123.198', '广东省', '联通', '0', '2011-04-12', '1'), ('14402', '58.22.114.193', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14403', '124.160.208.192', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14404', '112.97.216.41', '广东省', '联通', '0', '2011-04-12', '1'), ('14405', '221.11.61.109', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14406', '112.97.54.7', '广东省', '联通', '0', '2011-04-12', '1'), ('14407', '58.243.254.25', '安徽省', '联通', '0', '2011-04-12', '1'), ('14408', '112.224.3.31', '山东省', '联通', '0', '2011-04-12', '1'), ('14409', '58.249.32.254', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14410', '58.247.38.18', '上海市', '联通', '0', '2011-04-12', '1'), ('14411', '61.158.152.72', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14412', '110.7.68.54', '内蒙古', '联通', '0', '2011-04-12', '1'), ('14413', '61.158.152.203', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14414', '124.160.208.55', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14415', '124.160.209.97', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14416', '114.247.10.69', '北京市', '联通', '0', '2011-04-12', '1'), ('14417', '58.248.174.210', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14418', '123.127.159.243', '北京市', '联通', '0', '2011-04-12', '1'), ('14419', '220.199.176.226', '广东省', '联通', '0', '2011-04-12', '1'), ('14420', '58.243.250.93', '安徽省', '联通', '0', '2011-04-12', '1'), ('14421', '124.160.208.131', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14422', '58.22.113.18', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14423', '58.248.165.128', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14424', '221.0.119.241', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14425', '124.160.209.234', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14426', '58.247.24.84', '上海市', '联通', '0', '2011-04-12', '1'), ('14427', '58.243.250.75', '安徽省', '联通', '0', '2011-04-12', '1'), ('14428', '218.60.138.104', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14429', '58.243.254.57', '安徽省', '联通', '0', '2011-04-12', '1'), ('14430', '218.60.141.174', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('14431', '124.160.209.173', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14432', '58.249.36.8', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14433', '58.243.254.47', '安徽省', '联通', '0', '2011-04-12', '1'), ('14434', '221.0.127.168', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14435', '124.160.208.30', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14436', '58.22.114.16', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14437', '202.99.125.59', '天津市', '联通', '0', '2011-04-12', '1'), ('14438', '61.158.152.3', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14439', '112.97.219.167', '广东省', '联通', '0', '2011-04-12', '1'), ('14440', '113.57.244.3', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14441', '112.64.190.134', '上海市', '联通', '0', '2011-04-12', '1'), ('14442', '218.60.138.155', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14443', '116.114.83.66', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('14444', '60.212.71.136', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14445', '218.26.158.2', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14446', '58.243.254.15', '安徽省', '联通', '0', '2011-04-12', '1'), ('14447', '113.58.26.33', '海南省', '联通', '0', '2011-04-12', '1'), ('14448', '124.160.209.241', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14449', '124.160.209.84', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14450', '113.58.20.98', '海南省', '联通', '0', '2011-04-12', '1'), ('14451', '124.160.209.30', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14452', '112.97.32.144', '广东省', '联通', '0', '2011-04-12', '1'), ('14453', '113.57.244.12', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14454', '124.160.209.183', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14455', '58.248.166.201', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14456', '202.99.125.7', '天津市', '联通', '0', '2011-04-12', '1'), ('14457', '123.125.66.40', '北京市', '联通', '0', '2011-04-12', '1'), ('14458', '220.199.190.73', '广东省', '联通', '0', '2011-04-12', '1'), ('14459', '124.160.208.93', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14460', '221.194.30.68', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14461', '124.160.209.172', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14462', '58.248.168.47', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14463', '124.160.209.99', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14464', '221.194.30.192', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14465', '113.58.18.28', '海南省', '联通', '0', '2011-04-12', '1'), ('14466', '218.107.25.211', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14467', '220.199.131.226', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14468', '58.22.113.74', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14469', '221.194.30.205', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14470', '60.212.64.79', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14471', '58.22.114.143', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14472', '124.160.209.69', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14473', '61.158.152.45', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14474', '113.58.32.255', '海南省', '联通', '0', '2011-04-12', '1'), ('14475', '112.224.2.44', '山东省', '联通', '0', '2011-04-12', '1'), ('14476', '124.160.209.138', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14477', '112.65.8.85', '上海市', '联通', '0', '2011-04-12', '1'), ('14478', '58.22.114.15', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14479', '218.8.78.58', '黑龙江省哈尔滨市', '联通', '0', '2011-04-12', '1'), ('14480', '112.64.190.128', '上海市', '联通', '0', '2011-04-12', '1'), ('14481', '124.160.208.128', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14482', '58.22.113.127', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14483', '114.244.124.128', '北京市', '联通', '0', '2011-04-12', '1'), ('14484', '61.158.152.7', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14485', '124.160.209.27', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14486', '124.160.209.10', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14487', '220.199.225.162', '广东省', '联通', '0', '2011-04-12', '1'), ('14488', '58.22.114.83', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14489', '112.96.50.33', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14490', '220.199.157.10', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14491', '58.22.113.155', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14492', '118.212.172.198', '江西省', '联通', '0', '2011-04-12', '1'), ('14493', '58.248.127.143', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14494', '58.243.250.66', '安徽省', '联通', '0', '2011-04-12', '1'), ('14495', '58.243.250.96', '安徽省', '联通', '0', '2011-04-12', '1'), ('14496', '124.160.208.127', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14497', '119.39.248.46', '湖南省', '联通', '0', '2011-04-12', '1'), ('14498', '119.39.248.43', '湖南省', '联通', '0', '2011-04-12', '1'), ('14499', '58.248.160.234', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14500', '61.158.152.231', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14501', '116.113.84.224', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('14502', '58.243.254.33', '安徽省', '联通', '0', '2011-04-12', '1'), ('14503', '119.39.249.70', '湖南省', '联通', '0', '2011-04-12', '1'), ('14504', '124.160.209.110', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14505', '124.160.208.7', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14506', '124.160.209.188', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14507', '60.221.161.71', '山西省吕梁地区', '联通', '0', '2011-04-12', '1'), ('14508', '112.96.112.237', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14509', '58.243.254.24', '安徽省', '联通', '0', '2011-04-12', '1'), ('14510', '113.57.244.244', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14511', '123.125.66.55', '北京市', '联通', '0', '2011-04-12', '1'), ('14512', '124.160.209.24', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14513', '124.128.255.149', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14514', '61.179.163.223', '山东省安丘市', '联通', '0', '2011-04-12', '1'), ('14515', '58.243.254.37', '安徽省', '联通', '0', '2011-04-12', '1'), ('14516', '221.194.31.210', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14517', '112.97.84.140', '广东省', '联通', '0', '2011-04-12', '1'), ('14518', '119.4.252.93', '四川省', '联通', '0', '2011-04-12', '1'), ('14519', '118.212.172.229', '江西省', '联通', '0', '2011-04-12', '1'), ('14520', '124.160.208.240', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14521', '124.160.209.81', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14522', '124.160.209.44', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14523', '124.160.208.125', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14524', '123.128.155.86', '山东省威海市', '联通', '0', '2011-04-12', '1'), ('14525', '124.160.209.159', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14526', '113.57.244.163', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14527', '124.160.208.208', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14528', '118.212.171.233', '江西省', '联通', '0', '2011-04-12', '1'), ('14529', '124.160.208.113', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14530', '220.198.86.188', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14531', '60.221.160.46', '山西省吕梁地区', '联通', '0', '2011-04-12', '1'), ('14532', '124.160.209.76', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14533', '58.22.114.139', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14534', '113.57.244.55', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14535', '124.160.209.135', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14536', '119.39.248.47', '湖南省', '联通', '0', '2011-04-12', '1'), ('14537', '117.11.233.51', '天津市', '联通', '0', '2011-04-12', '1'), ('14538', '124.160.209.4', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14539', '124.160.208.195', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14540', '221.194.31.83', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14541', '112.224.2.40', '山东省', '联通', '0', '2011-04-12', '1'), ('14542', '221.7.242.48', '广西自治区贺州市', '联通', '0', '2011-04-12', '1'), ('14543', '58.243.254.5', '安徽省', '联通', '0', '2011-04-12', '1'), ('14544', '123.127.159.224', '北京市', '联通', '0', '2011-04-12', '1'), ('14545', '61.158.152.131', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14546', '221.194.31.158', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14547', '119.4.252.197', '四川省', '联通', '0', '2011-04-12', '1'), ('14548', '120.84.32.46', '广东省', '联通', '0', '2011-04-12', '1'), ('14549', '123.127.159.234', '北京市', '联通', '0', '2011-04-12', '1'), ('14550', '124.160.209.212', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14551', '118.212.171.133', '江西省', '联通', '0', '2011-04-12', '1'), ('14552', '221.215.243.66', '山东省青岛市', '联通', '0', '2011-04-12', '1'), ('14553', '119.39.248.23', '湖南省', '联通', '0', '2011-04-12', '1'), ('14554', '211.95.241.208', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14555', '122.194.0.233', '江苏省', '联通', '0', '2011-04-12', '1'), ('14556', '112.96.233.142', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14557', '58.22.113.9', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14558', '58.243.250.79', '安徽省', '联通', '0', '2011-04-12', '1'), ('14559', '113.57.244.215', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14560', '61.139.148.10', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('14561', '123.127.159.227', '北京市', '联通', '0', '2011-04-12', '1'), ('14562', '112.93.34.87', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('14563', '123.125.66.21', '北京市', '联通', '0', '2011-04-12', '1'), ('14564', '220.198.118.106', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('14565', '124.160.208.16', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14566', '119.39.248.64', '湖南省', '联通', '0', '2011-04-12', '1'), ('14567', '112.64.190.121', '上海市', '联通', '0', '2011-04-12', '1'), ('14568', '113.236.141.120', '辽宁省抚顺市', '联通', '0', '2011-04-12', '1'), ('14569', '119.163.122.204', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14570', '61.158.152.161', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14571', '112.64.190.140', '上海市', '联通', '0', '2011-04-12', '1'), ('14572', '220.199.237.90', '广东省', '联通', '0', '2011-04-12', '1'), ('14573', '112.64.190.123', '上海市', '联通', '0', '2011-04-12', '1'), ('14574', '124.160.209.137', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14575', '112.224.3.9', '山东省', '联通', '0', '2011-04-12', '1'), ('14576', '122.194.3.162', '江苏省', '联通', '0', '2011-04-12', '1'), ('14577', '124.160.208.102', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14578', '119.163.122.193', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14579', '124.134.49.192', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('14580', '58.243.250.68', '安徽省', '联通', '0', '2011-04-12', '1'), ('14581', '124.160.208.227', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14582', '124.160.208.171', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14583', '124.160.208.130', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14584', '112.97.193.71', '广东省', '联通', '0', '2011-04-12', '1'), ('14585', '112.224.2.56', '山东省', '联通', '0', '2011-04-12', '1'), ('14586', '60.221.163.147', '山西省吕梁地区', '联通', '0', '2011-04-12', '1'), ('14587', '58.22.114.137', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14588', '58.243.254.18', '安徽省', '联通', '0', '2011-04-12', '1'), ('14589', '58.243.250.99', '安徽省', '联通', '0', '2011-04-12', '1'), ('14590', '124.160.208.2', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14591', '220.198.99.116', '广东省湛江市', '联通', '0', '2011-04-12', '1'), ('14592', '221.7.7.63', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('14593', '61.158.152.54', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14594', '218.59.113.158', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14595', '112.224.3.25', '山东省', '联通', '0', '2011-04-12', '1'), ('14596', '60.4.85.27', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('14597', '112.64.190.120', '上海市', '联通', '0', '2011-04-12', '1'), ('14598', '125.33.20.196', '北京市', '联通', '0', '2011-04-12', '1'), ('14599', '119.118.230.87', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14600', '61.158.152.248', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14601', '118.212.171.12', '江西省', '联通', '0', '2011-04-12', '1'), ('14602', '122.194.2.196', '江苏省', '联通', '0', '2011-04-12', '1'), ('14603', '112.97.184.214', '广东省', '联通', '0', '2011-04-12', '1'), ('14604', '119.118.233.88', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14605', '58.243.254.8', '安徽省', '联通', '0', '2011-04-12', '1'), ('14606', '124.160.209.236', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14607', '124.160.209.179', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14608', '124.160.209.47', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14609', '58.243.250.70', '安徽省', '联通', '0', '2011-04-12', '1'), ('14610', '124.160.208.157', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14611', '124.160.100.19', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14612', '119.118.236.220', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14613', '58.100.240.101', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('14614', '124.160.209.65', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14615', '113.57.244.254', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14616', '113.57.244.6', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14617', '221.9.247.9', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('14618', '113.58.47.223', '海南省', '联通', '0', '2011-04-12', '1'), ('14619', '119.118.226.179', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14620', '124.160.208.104', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14621', '119.39.248.25', '湖南省', '联通', '0', '2011-04-12', '1'), ('14622', '124.90.129.129', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('14623', '124.160.208.19', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14624', '221.11.61.254', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14625', '119.163.122.231', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14626', '122.194.1.232', '江苏省', '联通', '0', '2011-04-12', '1'), ('14627', '119.118.227.165', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14628', '220.199.180.102', '广东省', '联通', '0', '2011-04-12', '1'), ('14629', '112.237.12.182', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14630', '124.160.209.104', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14631', '221.11.61.192', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14632', '124.160.209.118', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14633', '58.243.254.17', '安徽省', '联通', '0', '2011-04-12', '1'), ('14634', '110.17.170.65', '内蒙古', '联通', '0', '2011-04-12', '1'), ('14635', '119.118.230.60', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14636', '120.84.42.117', '广东省', '联通', '0', '2011-04-12', '1'), ('14637', '124.160.208.57', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14638', '112.64.190.38', '上海市', '联通', '0', '2011-04-12', '1'), ('14639', '116.113.84.225', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('14640', '124.160.209.231', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14641', '112.224.3.109', '山东省', '联通', '0', '2011-04-12', '1'), ('14642', '119.118.238.3', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14643', '58.243.254.56', '安徽省', '联通', '0', '2011-04-12', '1'), ('14644', '123.127.159.228', '北京市', '联通', '0', '2011-04-12', '1'), ('14645', '113.224.145.221', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14646', '220.199.84.232', '广东省', '联通', '0', '2011-04-12', '1'), ('14647', '58.248.193.109', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14648', '221.9.247.14', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('14649', '61.158.152.157', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14650', '119.39.248.68', '湖南省', '联通', '0', '2011-04-12', '1'), ('14651', '119.163.122.214', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14652', '58.243.254.35', '安徽省', '联通', '0', '2011-04-12', '1'), ('14653', '221.194.31.87', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14654', '218.60.139.197', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14655', '124.160.209.131', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14656', '112.97.166.1', '广东省', '联通', '0', '2011-04-12', '1'), ('14657', '119.39.248.61', '湖南省', '联通', '0', '2011-04-12', '1'), ('14658', '122.194.1.76', '江苏省', '联通', '0', '2011-04-12', '1'), ('14659', '122.194.3.184', '江苏省', '联通', '0', '2011-04-12', '1'), ('14660', '61.158.152.132', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14661', '222.134.133.66', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('14662', '122.194.3.186', '江苏省', '联通', '0', '2011-04-12', '1'), ('14663', '58.22.113.139', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14664', '124.160.208.52', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14665', '123.127.159.232', '北京市', '联通', '0', '2011-04-12', '1'), ('14666', '119.108.182.225', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14667', '218.60.141.187', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('14668', '58.243.250.77', '安徽省', '联通', '0', '2011-04-12', '1'), ('14669', '112.64.190.129', '上海市', '联通', '0', '2011-04-12', '1'), ('14670', '58.22.113.91', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14671', '221.221.143.75', '北京市', '联通', '0', '2011-04-12', '1'), ('14672', '218.60.141.118', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('14673', '221.11.61.66', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14674', '120.87.11.237', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('14675', '58.243.250.87', '安徽省', '联通', '0', '2011-04-12', '1'), ('14676', '119.39.248.28', '湖南省', '联通', '0', '2011-04-12', '1'), ('14677', '61.158.152.175', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14678', '218.60.139.64', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14679', '202.99.125.84', '天津市', '联通', '0', '2011-04-12', '1'), ('14680', '61.158.152.32', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14681', '60.4.80.190', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('14682', '115.85.238.136', '甘肃省', '联通', '0', '2011-04-12', '1'), ('14683', '112.224.2.30', '山东省', '联通', '0', '2011-04-12', '1'), ('14684', '61.158.152.80', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14685', '221.194.30.132', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14686', '221.194.31.179', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14687', '58.243.254.3', '安徽省', '联通', '0', '2011-04-12', '1'), ('14688', '113.57.244.42', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14689', '58.22.113.196', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14690', '120.6.156.146', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14691', '112.96.80.44', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14692', '218.26.158.38', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14693', '122.194.0.154', '江苏省', '联通', '0', '2011-04-12', '1'), ('14694', '113.57.244.56', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14695', '118.212.186.56', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('14696', '202.99.125.122', '天津市', '联通', '0', '2011-04-12', '1'), ('14697', '61.158.152.168', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14698', '58.22.114.48', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14699', '119.4.252.64', '四川省', '联通', '0', '2011-04-12', '1'), ('14700', '118.212.171.240', '江西省', '联通', '0', '2011-04-12', '1'), ('14701', '113.57.246.3', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14702', '119.39.248.63', '湖南省', '联通', '0', '2011-04-12', '1'), ('14703', '122.194.2.48', '江苏省', '联通', '0', '2011-04-12', '1'), ('14704', '220.198.149.215', '广东省清远市', '联通', '0', '2011-04-12', '1'), ('14705', '218.60.141.3', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('14706', '112.64.188.42', '上海市', '联通', '0', '2011-04-12', '1'), ('14707', '124.160.208.86', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14708', '122.194.2.198', '江苏省', '联通', '0', '2011-04-12', '1'), ('14709', '202.108.50.76', '北京市', '联通', '0', '2011-04-12', '1'), ('14710', '202.108.50.70', '北京市', '联通', '0', '2011-04-12', '1'), ('14711', '220.198.98.178', '广东省湛江市', '联通', '0', '2011-04-12', '1'), ('14712', '220.198.117.238', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('14713', '122.194.1.203', '江苏省', '联通', '0', '2011-04-12', '1'), ('14714', '122.194.2.226', '江苏省', '联通', '0', '2011-04-12', '1'), ('14715', '58.243.254.26', '安徽省', '联通', '0', '2011-04-12', '1'), ('14716', '58.22.116.114', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14717', '115.85.238.133', '甘肃省', '联通', '0', '2011-04-12', '1'), ('14718', '58.243.254.53', '安徽省', '联通', '0', '2011-04-12', '1'), ('14719', '124.160.209.113', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14720', '58.22.114.57', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14721', '220.198.74.221', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14722', '60.218.223.164', '黑龙江省鸡西市', '联通', '0', '2011-04-12', '1'), ('14723', '122.194.1.32', '江苏省', '联通', '0', '2011-04-12', '1'), ('14724', '124.160.208.114', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14725', '119.4.252.40', '四川省', '联通', '0', '2011-04-12', '1'), ('14726', '211.96.78.238', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('14727', '220.198.183.44', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14728', '113.57.246.79', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14729', '121.31.250.5', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('14730', '60.4.69.132', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('14731', '119.4.252.212', '四川省', '联通', '0', '2011-04-12', '1'), ('14732', '120.1.65.204', '河北省石家庄市', '联通', '0', '2011-04-12', '1'), ('14733', '221.199.9.10', '宁夏自治区银川市', '联通', '0', '2011-04-12', '1'), ('14734', '113.58.24.162', '海南省', '联通', '0', '2011-04-12', '1'), ('14735', '220.250.59.1', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14736', '220.199.209.48', '广东省', '联通', '0', '2011-04-12', '1'), ('14737', '119.183.117.129', '山东省日照市', '联通', '0', '2011-04-12', '1'), ('14738', '122.194.0.116', '江苏省', '联通', '0', '2011-04-12', '1'), ('14739', '122.194.0.188', '江苏省', '联通', '0', '2011-04-12', '1'), ('14740', '113.58.23.202', '海南省', '联通', '0', '2011-04-12', '1'), ('14741', '112.97.93.169', '广东省', '联通', '0', '2011-04-12', '1'), ('14742', '119.183.30.114', '山东省德州市', '联通', '0', '2011-04-12', '1'), ('14743', '123.147.144.126', '重庆市', '联通', '0', '2011-04-12', '1'), ('14744', '112.96.132.243', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14745', '58.243.254.28', '安徽省', '联通', '0', '2011-04-12', '1'), ('14746', '122.194.3.140', '江苏省', '联通', '0', '2011-04-12', '1'), ('14747', '222.133.187.22', '山东省日照市', '联通', '0', '2011-04-12', '1'), ('14748', '123.147.244.59', '重庆市', '联通', '0', '2011-04-12', '1'), ('14749', '218.26.158.34', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14750', '118.212.171.228', '江西省', '联通', '0', '2011-04-12', '1'), ('14751', '221.11.61.50', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14752', '113.58.9.236', '海南省', '联通', '0', '2011-04-12', '1'), ('14753', '58.243.254.31', '安徽省', '联通', '0', '2011-04-12', '1'), ('14754', '124.160.209.247', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14755', '124.160.208.49', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14756', '61.158.152.84', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14757', '220.198.61.125', '广东省梅州市', '联通', '0', '2011-04-12', '1'), ('14758', '58.22.114.61', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14759', '218.26.158.44', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14760', '61.163.78.14', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('14761', '218.26.158.52', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14762', '218.26.158.30', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14763', '122.194.0.85', '江苏省', '联通', '0', '2011-04-12', '1'), ('14764', '220.198.78.82', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14765', '118.212.191.99', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('14766', '119.62.127.206', '云南省', '联通', '0', '2011-04-12', '1'), ('14767', '119.4.252.146', '四川省', '联通', '0', '2011-04-12', '1'), ('14768', '122.194.0.211', '江苏省', '联通', '0', '2011-04-12', '1'), ('14769', '220.198.50.74', '广东省茂名市', '联通', '0', '2011-04-12', '1'), ('14770', '220.199.158.220', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14771', '112.96.255.224', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14772', '119.4.252.169', '四川省', '联通', '0', '2011-04-12', '1'), ('14773', '220.250.59.2', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14774', '221.11.61.98', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14775', '202.99.84.128', '天津市', '联通', '0', '2011-04-12', '1'), ('14776', '123.147.244.6', '重庆市', '联通', '0', '2011-04-12', '1'), ('14777', '124.128.255.134', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14778', '119.4.252.31', '四川省', '联通', '0', '2011-04-12', '1'), ('14779', '122.194.0.15', '江苏省', '联通', '0', '2011-04-12', '1'), ('14780', '123.125.40.250', '北京市', '联通', '0', '2011-04-12', '1'), ('14781', '112.96.137.46', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14782', '112.97.152.58', '广东省', '联通', '0', '2011-04-12', '1'), ('14783', '112.64.190.136', '上海市', '联通', '0', '2011-04-12', '1'), ('14784', '124.160.209.15', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14785', '218.60.139.253', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14786', '124.128.255.142', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14787', '220.199.140.231', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14788', '112.64.188.47', '上海市', '联通', '0', '2011-04-12', '1'), ('14789', '124.160.208.204', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14790', '125.40.153.79', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('14791', '123.147.244.53', '重庆市', '联通', '0', '2011-04-12', '1'), ('14792', '124.160.209.22', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14793', '61.158.152.223', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14794', '120.82.98.255', '广东省', '联通', '0', '2011-04-12', '1'), ('14795', '123.146.10.3', '重庆市', '联通', '0', '2011-04-12', '1'), ('14796', '123.147.244.4', '重庆市', '联通', '0', '2011-04-12', '1'), ('14797', '210.13.203.27', '中国', '联通', '0', '2011-04-12', '1'), ('14798', '115.85.238.130', '甘肃省', '联通', '0', '2011-04-12', '1'), ('14799', '221.11.61.142', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14800', '112.224.3.32', '山东省', '联通', '0', '2011-04-12', '1'), ('14801', '175.43.220.195', '福建省', '联通', '0', '2011-04-12', '1'), ('14802', '119.4.0.245', '四川省成都市', '联通', '0', '2011-04-12', '1'), ('14803', '122.194.2.30', '江苏省', '联通', '0', '2011-04-12', '1'), ('14804', '123.5.239.165', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('14805', '218.60.139.196', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14806', '119.62.127.181', '云南省', '联通', '0', '2011-04-12', '1'), ('14807', '112.96.134.102', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14808', '221.11.61.115', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14809', '123.147.244.15', '重庆市', '联通', '0', '2011-04-12', '1'), ('14810', '61.158.152.242', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14811', '221.7.105.120', '重庆市', '联通', '0', '2011-04-12', '1'), ('14812', '112.96.174.45', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14813', '119.62.127.209', '云南省', '联通', '0', '2011-04-12', '1'), ('14814', '119.62.127.39', '云南省', '联通', '0', '2011-04-12', '1'), ('14815', '113.57.246.65', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14816', '122.194.0.240', '江苏省', '联通', '0', '2011-04-12', '1'), ('14817', '221.194.31.220', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14818', '123.147.244.29', '重庆市', '联通', '0', '2011-04-12', '1'), ('14819', '221.7.7.229', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('14820', '119.62.127.210', '云南省', '联通', '0', '2011-04-12', '1'), ('14821', '61.158.152.116', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14822', '124.88.87.181', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('14823', '113.5.0.60', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('14824', '123.121.10.105', '北京市', '联通', '0', '2011-04-12', '1'), ('14825', '113.57.244.240', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14826', '123.147.244.20', '重庆市', '联通', '0', '2011-04-12', '1'), ('14827', '122.194.0.24', '江苏省', '联通', '0', '2011-04-12', '1'), ('14828', '202.99.125.13', '天津市', '联通', '0', '2011-04-12', '1'), ('14829', '220.199.234.42', '广东省', '联通', '0', '2011-04-12', '1'), ('14830', '220.198.93.10', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14831', '124.160.208.56', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14832', '113.57.244.252', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14833', '113.58.39.191', '海南省', '联通', '0', '2011-04-12', '1'), ('14834', '122.194.2.25', '江苏省', '联通', '0', '2011-04-12', '1'), ('14835', '122.194.0.106', '江苏省', '联通', '0', '2011-04-12', '1'), ('14836', '60.217.232.55', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('14837', '221.194.31.53', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14838', '58.248.122.114', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14839', '118.212.172.195', '江西省', '联通', '0', '2011-04-12', '1'), ('14840', '124.160.209.88', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14841', '123.147.244.55', '重庆市', '联通', '0', '2011-04-12', '1'), ('14842', '112.64.145.2', '上海市', '联通', '0', '2011-04-12', '1'), ('14843', '124.160.208.238', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14844', '221.194.30.64', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14845', '122.194.0.23', '江苏省', '联通', '0', '2011-04-12', '1'), ('14846', '124.160.209.196', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14847', '122.194.2.99', '江苏省', '联通', '0', '2011-04-12', '1'), ('14848', '221.11.61.250', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14849', '221.9.247.23', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('14850', '113.58.23.64', '海南省', '联通', '0', '2011-04-12', '1'), ('14851', '112.96.134.14', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14852', '119.180.60.137', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14853', '61.158.152.186', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14854', '124.160.97.12', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14855', '220.199.236.180', '广东省', '联通', '0', '2011-04-12', '1'), ('14856', '112.224.2.85', '山东省', '联通', '0', '2011-04-12', '1'), ('14857', '122.194.0.190', '江苏省', '联通', '0', '2011-04-12', '1'), ('14858', '202.99.84.150', '天津市', '联通', '0', '2011-04-12', '1'), ('14859', '112.97.111.5', '广东省', '联通', '0', '2011-04-12', '1'), ('14860', '124.160.209.144', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14861', '119.39.248.67', '湖南省', '联通', '0', '2011-04-12', '1'), ('14862', '220.198.70.124', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14863', '221.11.61.33', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14864', '221.194.31.182', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14865', '61.158.152.182', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14866', '122.194.0.100', '江苏省', '联通', '0', '2011-04-12', '1'), ('14867', '58.243.254.51', '安徽省', '联通', '0', '2011-04-12', '1'), ('14868', '218.60.140.84', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14869', '112.109.226.127', '福建省', '联通', '0', '2011-04-12', '1'), ('14870', '124.160.97.37', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14871', '124.160.97.39', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14872', '218.60.141.28', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('14873', '119.179.87.254', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('14874', '202.99.84.140', '天津市', '联通', '0', '2011-04-12', '1'), ('14875', '124.160.97.36', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14876', '122.194.2.27', '江苏省', '联通', '0', '2011-04-12', '1'), ('14877', '112.109.205.186', '福建省', '联通', '0', '2011-04-12', '1'), ('14878', '124.160.97.13', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14879', '61.158.152.215', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14880', '119.39.248.45', '湖南省', '联通', '0', '2011-04-12', '1'), ('14881', '113.58.45.242', '海南省', '联通', '0', '2011-04-12', '1'), ('14882', '123.147.244.14', '重庆市', '联通', '0', '2011-04-12', '1'), ('14883', '221.11.61.24', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14884', '112.96.76.170', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14885', '119.39.248.24', '湖南省', '联通', '0', '2011-04-12', '1'), ('14886', '58.22.113.77', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14887', '123.147.244.38', '重庆市', '联通', '0', '2011-04-12', '1'), ('14888', '221.194.30.123', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14889', '112.64.190.143', '上海市', '联通', '0', '2011-04-12', '1'), ('14890', '218.26.158.58', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14891', '113.57.244.155', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14892', '122.194.3.169', '江苏省', '联通', '0', '2011-04-12', '1'), ('14893', '221.11.61.68', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14894', '112.96.189.188', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14895', '122.194.0.86', '江苏省', '联通', '0', '2011-04-12', '1'), ('14896', '113.57.246.210', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14897', '58.243.250.116', '安徽省', '联通', '0', '2011-04-12', '1'), ('14898', '113.57.244.217', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14899', '124.160.208.239', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14900', '58.20.248.52', '湖南省郴州市', '联通', '0', '2011-04-12', '1'), ('14901', '221.11.61.208', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('14902', '61.158.152.193', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14903', '61.158.152.195', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14904', '124.160.209.109', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14905', '112.224.2.58', '山东省', '联通', '0', '2011-04-12', '1'), ('14906', '221.205.138.182', '山西省长治市', '联通', '0', '2011-04-12', '1'), ('14907', '61.158.152.57', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14908', '112.64.190.47', '上海市', '联通', '0', '2011-04-12', '1'), ('14909', '58.17.252.11', '重庆市', '联通', '0', '2011-04-12', '1'), ('14910', '112.122.9.85', '安徽省合肥市', '联通', '0', '2011-04-12', '1'), ('14911', '218.26.158.40', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('14912', '180.130.212.173', '云南省', '联通', '0', '2011-04-12', '1'), ('14913', '61.158.152.62', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14914', '112.97.161.215', '广东省', '联通', '0', '2011-04-12', '1'), ('14915', '112.109.228.194', '福建省', '联通', '0', '2011-04-12', '1'), ('14916', '113.5.0.57', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('14917', '122.194.0.199', '江苏省', '联通', '0', '2011-04-12', '1'), ('14918', '112.97.166.86', '广东省', '联通', '0', '2011-04-12', '1'), ('14919', '112.96.179.37', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14920', '221.205.136.72', '山西省长治市', '联通', '0', '2011-04-12', '1'), ('14921', '124.160.96.187', '浙江省温州市', '联通', '0', '2011-04-12', '1'), ('14922', '119.4.252.209', '四川省', '联通', '0', '2011-04-12', '1'), ('14923', '221.194.30.109', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14924', '218.60.140.241', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14925', '221.194.30.215', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14926', '112.97.71.14', '广东省', '联通', '0', '2011-04-12', '1'), ('14927', '123.5.166.27', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('14928', '112.224.3.24', '山东省', '联通', '0', '2011-04-12', '1'), ('14929', '112.96.152.21', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14930', '123.147.244.47', '重庆市', '联通', '0', '2011-04-12', '1'), ('14931', '125.43.195.189', '河南省焦作市', '联通', '0', '2011-04-12', '1'), ('14932', '221.207.86.121', '黑龙江省佳木斯市', '联通', '0', '2011-04-12', '1'), ('14933', '112.97.77.31', '广东省', '联通', '0', '2011-04-12', '1'), ('14934', '58.22.113.99', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14935', '124.160.209.244', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14936', '60.4.87.80', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('14937', '119.62.127.124', '云南省', '联通', '0', '2011-04-12', '1'), ('14938', '112.64.190.122', '上海市', '联通', '0', '2011-04-12', '1'), ('14939', '113.57.244.19', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14940', '112.97.123.121', '广东省', '联通', '0', '2011-04-12', '1'), ('14941', '61.158.152.227', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14942', '61.158.152.114', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14943', '119.4.252.137', '四川省', '联通', '0', '2011-04-12', '1'), ('14944', '220.201.8.215', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('14945', '112.97.167.3', '广东省', '联通', '0', '2011-04-12', '1'), ('14946', '61.176.226.254', '辽宁省锦州市', '联通', '0', '2011-04-12', '1'), ('14947', '124.160.209.134', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14948', '113.57.244.141', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14949', '218.60.139.187', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14950', '113.57.246.227', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14951', '113.57.244.191', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14952', '112.64.190.45', '上海市', '联通', '0', '2011-04-12', '1'), ('14953', '113.57.244.143', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14954', '115.85.238.135', '甘肃省', '联通', '0', '2011-04-12', '1'), ('14955', '112.224.3.87', '山东省', '联通', '0', '2011-04-12', '1'), ('14956', '112.64.190.50', '上海市', '联通', '0', '2011-04-12', '1'), ('14957', '61.158.152.202', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14958', '124.164.254.180', '山西省晋城市', '联通', '0', '2011-04-12', '1'), ('14959', '119.4.252.221', '四川省', '联通', '0', '2011-04-12', '1'), ('14960', '123.118.196.128', '北京市', '联通', '0', '2011-04-12', '1'), ('14961', '119.4.252.13', '四川省', '联通', '0', '2011-04-12', '1'), ('14962', '218.60.139.119', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('14963', '124.160.209.218', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14964', '124.160.209.189', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14965', '221.194.30.115', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14966', '221.194.31.125', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14967', '61.158.152.15', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14968', '122.194.0.169', '江苏省', '联通', '0', '2011-04-12', '1'), ('14969', '123.147.244.40', '重庆市', '联通', '0', '2011-04-12', '1'), ('14970', '61.158.152.205', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('14971', '58.22.114.20', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('14972', '220.198.81.27', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14973', '221.194.31.145', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('14974', '114.247.10.66', '北京市', '联通', '0', '2011-04-12', '1'), ('14975', '124.160.208.79', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14976', '119.39.248.62', '湖南省', '联通', '0', '2011-04-12', '1'), ('14977', '119.114.1.199', '辽宁省鞍山市', '联通', '0', '2011-04-12', '1'), ('14978', '123.5.234.38', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('14979', '112.224.3.69', '山东省', '联通', '0', '2011-04-12', '1'), ('14980', '113.58.21.0', '海南省', '联通', '0', '2011-04-12', '1'), ('14981', '123.147.244.21', '重庆市', '联通', '0', '2011-04-12', '1'), ('14982', '113.57.246.223', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14983', '220.199.178.54', '广东省', '联通', '0', '2011-04-12', '1'), ('14984', '112.94.64.237', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('14985', '202.99.125.4', '天津市', '联通', '0', '2011-04-12', '1'), ('14986', '122.194.2.146', '江苏省', '联通', '0', '2011-04-12', '1'), ('14987', '113.57.246.123', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('14988', '112.97.143.127', '广东省', '联通', '0', '2011-04-12', '1'), ('14989', '123.125.156.164', '北京市', '联通', '0', '2011-04-12', '1'), ('14990', '123.125.156.181', '北京市', '联通', '0', '2011-04-12', '1'), ('14991', '202.108.50.72', '北京市', '联通', '0', '2011-04-12', '1'), ('14992', '202.108.50.69', '北京市', '联通', '0', '2011-04-12', '1'), ('14993', '122.194.1.113', '江苏省', '联通', '0', '2011-04-12', '1'), ('14994', '119.4.252.26', '四川省', '联通', '0', '2011-04-12', '1'), ('14995', '112.97.177.162', '广东省', '联通', '0', '2011-04-12', '1'), ('14996', '124.160.208.166', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('14997', '202.99.125.141', '天津市', '联通', '0', '2011-04-12', '1'), ('14998', '220.199.130.158', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('14999', '119.4.252.171', '四川省', '联通', '0', '2011-04-12', '1'), ('15000', '122.194.3.36', '江苏省', '联通', '0', '2011-04-12', '1'), ('15001', '124.160.208.226', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15002', '113.5.0.124', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('15003', '58.22.114.72', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15004', '119.4.252.182', '四川省', '联通', '0', '2011-04-12', '1'), ('15005', '112.224.2.42', '山东省', '联通', '0', '2011-04-12', '1'), ('15006', '61.158.152.158', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15007', '220.198.106.25', '广东省湛江市', '联通', '0', '2011-04-12', '1'), ('15008', '122.194.0.3', '江苏省', '联通', '0', '2011-04-12', '1'), ('15009', '112.224.2.4', '山东省', '联通', '0', '2011-04-12', '1'), ('15010', '58.22.114.31', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15011', '221.194.30.206', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15012', '220.198.121.158', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15013', '61.158.152.180', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15014', '58.16.226.41', '贵州省', '联通', '0', '2011-04-12', '1'), ('15015', '122.194.3.132', '江苏省', '联通', '0', '2011-04-12', '1'), ('15016', '119.181.195.80', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('15017', '218.60.138.156', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15018', '221.194.31.65', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15019', '218.29.116.74', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('15020', '113.57.246.228', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15021', '220.198.167.185', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15022', '120.84.25.99', '广东省', '联通', '0', '2011-04-12', '1'), ('15023', '120.84.27.106', '广东省', '联通', '0', '2011-04-12', '1'), ('15024', '120.84.27.248', '广东省', '联通', '0', '2011-04-12', '1'), ('15025', '120.84.27.90', '广东省', '联通', '0', '2011-04-12', '1'), ('15026', '120.84.27.123', '广东省', '联通', '0', '2011-04-12', '1'), ('15027', '120.84.27.184', '广东省', '联通', '0', '2011-04-12', '1'), ('15028', '120.84.27.154', '广东省', '联通', '0', '2011-04-12', '1'), ('15029', '120.84.27.110', '广东省', '联通', '0', '2011-04-12', '1'), ('15030', '120.84.27.169', '广东省', '联通', '0', '2011-04-12', '1'), ('15031', '120.84.27.24', '广东省', '联通', '0', '2011-04-12', '1'), ('15032', '120.84.27.250', '广东省', '联通', '0', '2011-04-12', '1'), ('15033', '120.84.27.54', '广东省', '联通', '0', '2011-04-12', '1'), ('15034', '120.84.27.26', '广东省', '联通', '0', '2011-04-12', '1'), ('15035', '120.84.27.98', '广东省', '联通', '0', '2011-04-12', '1'), ('15036', '120.84.27.218', '广东省', '联通', '0', '2011-04-12', '1'), ('15037', '120.84.27.238', '广东省', '联通', '0', '2011-04-12', '1'), ('15038', '120.84.27.36', '广东省', '联通', '0', '2011-04-12', '1'), ('15039', '120.84.27.114', '广东省', '联通', '0', '2011-04-12', '1'), ('15040', '120.84.27.58', '广东省', '联通', '0', '2011-04-12', '1'), ('15041', '120.84.27.196', '广东省', '联通', '0', '2011-04-12', '1'), ('15042', '120.84.27.176', '广东省', '联通', '0', '2011-04-12', '1'), ('15043', '120.84.27.66', '广东省', '联通', '0', '2011-04-12', '1'), ('15044', '120.84.27.50', '广东省', '联通', '0', '2011-04-12', '1'), ('15045', '120.84.27.251', '广东省', '联通', '0', '2011-04-12', '1'), ('15046', '120.84.27.28', '广东省', '联通', '0', '2011-04-12', '1'), ('15047', '120.84.27.246', '广东省', '联通', '0', '2011-04-12', '1'), ('15048', '119.179.86.162', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('15049', '120.84.27.73', '广东省', '联通', '0', '2011-04-12', '1'), ('15050', '120.84.27.122', '广东省', '联通', '0', '2011-04-12', '1'), ('15051', '120.84.27.68', '广东省', '联通', '0', '2011-04-12', '1'), ('15052', '113.57.246.241', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15053', '60.23.196.35', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15054', '124.160.208.51', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15055', '119.4.252.175', '四川省', '联通', '0', '2011-04-12', '1'), ('15056', '119.4.252.177', '四川省', '联通', '0', '2011-04-12', '1'), ('15057', '113.57.246.114', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15058', '218.60.141.134', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15059', '220.198.36.190', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15060', '220.198.163.241', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15061', '202.99.125.211', '天津市', '联通', '0', '2011-04-12', '1'), ('15062', '122.194.3.26', '江苏省', '联通', '0', '2011-04-12', '1'), ('15063', '115.85.238.131', '甘肃省', '联通', '0', '2011-04-12', '1'), ('15064', '123.129.218.175', '山东省', '联通', '0', '2011-04-12', '1'), ('15065', '123.147.244.44', '重庆市', '联通', '0', '2011-04-12', '1'), ('15066', '122.194.3.248', '江苏省', '联通', '0', '2011-04-12', '1'), ('15067', '202.99.84.33', '天津市', '联通', '0', '2011-04-12', '1'), ('15068', '221.13.145.37', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15069', '123.234.33.62', '山东省青岛市', '联通', '0', '2011-04-12', '1'), ('15070', '119.62.127.248', '云南省', '联通', '0', '2011-04-12', '1'), ('15071', '202.108.50.75', '北京市', '联通', '0', '2011-04-12', '1'), ('15072', '112.224.3.2', '山东省', '联通', '0', '2011-04-12', '1'), ('15073', '123.5.210.9', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15074', '124.160.209.252', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15075', '218.26.158.55', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('15076', '112.96.123.126', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15077', '119.4.252.213', '四川省', '联通', '0', '2011-04-12', '1'), ('15078', '58.22.114.188', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15079', '122.194.3.42', '江苏省', '联通', '0', '2011-04-12', '1'), ('15080', '112.64.190.54', '上海市', '联通', '0', '2011-04-12', '1'), ('15081', '61.181.40.65', '天津市', '联通', '0', '2011-04-12', '1'), ('15082', '123.5.199.73', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15083', '112.96.69.240', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15084', '58.22.113.115', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15085', '58.243.250.114', '安徽省', '联通', '0', '2011-04-12', '1'), ('15086', '122.194.0.158', '江苏省', '联通', '0', '2011-04-12', '1'), ('15087', '112.90.136.99', '广东省', '联通', '0', '2011-04-12', '1'), ('15088', '61.158.152.99', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15089', '124.160.209.5', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15090', '124.160.208.188', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15091', '113.57.246.2', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15092', '61.163.6.86', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15093', '218.58.133.47', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('15094', '221.11.61.71', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15095', '124.160.208.235', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15096', '218.60.140.162', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15097', '112.90.136.98', '广东省', '联通', '0', '2011-04-12', '1'), ('15098', '113.57.244.229', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15099', '119.163.122.245', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15100', '220.198.54.152', '广东省茂名市', '联通', '0', '2011-04-12', '1'), ('15101', '119.163.122.251', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15102', '124.160.209.86', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15103', '119.39.249.71', '湖南省', '联通', '0', '2011-04-12', '1'), ('15104', '220.199.144.238', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15105', '61.158.152.86', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15106', '116.115.1.168', '内蒙古赤峰市', '联通', '0', '2011-04-12', '1'), ('15107', '119.62.127.104', '云南省', '联通', '0', '2011-04-12', '1'), ('15108', '120.84.204.81', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('15109', '122.194.1.15', '江苏省', '联通', '0', '2011-04-12', '1'), ('15110', '123.147.244.11', '重庆市', '联通', '0', '2011-04-12', '1'), ('15111', '119.4.252.96', '四川省', '联通', '0', '2011-04-12', '1'), ('15112', '122.194.3.238', '江苏省', '联通', '0', '2011-04-12', '1'), ('15113', '221.209.25.58', '黑龙江省齐齐哈尔市', '联通', '0', '2011-04-12', '1'), ('15114', '58.22.114.26', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15115', '119.39.249.1', '湖南省', '联通', '0', '2011-04-12', '1'), ('15116', '123.5.233.72', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15117', '119.4.252.248', '四川省', '联通', '0', '2011-04-12', '1'), ('15118', '119.4.252.220', '四川省', '联通', '0', '2011-04-12', '1'), ('15119', '58.16.226.211', '贵州省', '联通', '0', '2011-04-12', '1'), ('15120', '58.22.114.38', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15121', '124.160.209.16', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15122', '113.58.34.201', '海南省', '联通', '0', '2011-04-12', '1'), ('15123', '112.96.69.21', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15124', '113.57.244.88', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15125', '122.194.0.110', '江苏省', '联通', '0', '2011-04-12', '1'), ('15126', '61.158.152.208', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15127', '113.57.244.105', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15128', '221.9.247.18', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('15129', '113.57.246.63', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15130', '58.243.254.20', '安徽省', '联通', '0', '2011-04-12', '1'), ('15131', '113.57.246.176', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15132', '58.250.158.66', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('15133', '123.5.213.170', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15134', '220.198.108.233', '广东省湛江市', '联通', '0', '2011-04-12', '1'), ('15135', '221.194.31.94', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15136', '218.60.141.173', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15137', '58.243.254.42', '安徽省', '联通', '0', '2011-04-12', '1'), ('15138', '122.194.3.156', '江苏省', '联通', '0', '2011-04-12', '1'), ('15139', '58.243.254.23', '安徽省', '联通', '0', '2011-04-12', '1'), ('15140', '220.198.146.97', '广东省清远市', '联通', '0', '2011-04-12', '1'), ('15141', '112.64.190.46', '上海市', '联通', '0', '2011-04-12', '1'), ('15142', '113.57.246.86', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15143', '118.212.190.146', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15144', '113.58.34.194', '海南省', '联通', '0', '2011-04-12', '1'), ('15145', '61.158.152.174', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15146', '112.97.90.169', '广东省', '联通', '0', '2011-04-12', '1'), ('15147', '60.4.94.113', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('15148', '113.58.55.201', '海南省', '联通', '0', '2011-04-12', '1'), ('15149', '124.133.48.57', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15150', '119.4.252.235', '四川省', '联通', '0', '2011-04-12', '1'), ('15151', '112.64.188.52', '上海市', '联通', '0', '2011-04-12', '1'), ('15152', '122.194.0.21', '江苏省', '联通', '0', '2011-04-12', '1'), ('15153', '116.113.84.200', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('15154', '112.224.2.6', '山东省', '联通', '0', '2011-04-12', '1'), ('15155', '221.194.30.143', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15156', '112.224.2.8', '山东省', '联通', '0', '2011-04-12', '1'), ('15157', '218.26.158.33', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('15158', '110.52.101.152', '湖南省', '联通', '0', '2011-04-12', '1'), ('15159', '112.64.190.164', '上海市', '联通', '0', '2011-04-12', '1'), ('15160', '112.224.2.11', '山东省', '联通', '0', '2011-04-12', '1'), ('15161', '118.76.28.245', '山西省晋中市', '联通', '0', '2011-04-12', '1'), ('15162', '221.1.54.10', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('15163', '58.16.226.142', '贵州省', '联通', '0', '2011-04-12', '1'), ('15164', '218.26.158.23', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('15165', '221.7.7.192', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15166', '123.232.147.143', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15167', '124.160.208.41', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15168', '218.60.138.5', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15169', '122.194.1.176', '江苏省', '联通', '0', '2011-04-12', '1'), ('15170', '58.243.250.98', '安徽省', '联通', '0', '2011-04-12', '1'), ('15171', '220.198.132.125', '广东省', '联通', '0', '2011-04-12', '1'), ('15172', '61.158.152.190', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15173', '211.96.108.191', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('15174', '122.194.5.142', '江苏省', '联通', '0', '2011-04-12', '1'), ('15175', '121.29.4.14', '河北省石家庄市', '联通', '0', '2011-04-12', '1'), ('15176', '113.58.1.14', '海南省', '联通', '0', '2011-04-12', '1'), ('15177', '218.60.139.90', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15178', '112.97.104.88', '广东省', '联通', '0', '2011-04-12', '1'), ('15179', '113.57.246.183', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15180', '119.163.122.199', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15181', '218.60.140.47', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15182', '124.160.209.13', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15183', '122.194.3.173', '江苏省', '联通', '0', '2011-04-12', '1'), ('15184', '115.61.1.46', '河南省', '联通', '0', '2011-04-12', '1'), ('15185', '58.22.113.153', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15186', '112.97.171.215', '广东省', '联通', '0', '2011-04-12', '1'), ('15187', '122.194.5.75', '江苏省', '联通', '0', '2011-04-12', '1'), ('15188', '118.212.172.232', '江西省', '联通', '0', '2011-04-12', '1'), ('15189', '60.0.83.186', '河北省石家庄市', '联通', '0', '2011-04-12', '1'), ('15190', '112.96.173.57', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15191', '112.96.63.15', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15192', '112.224.3.108', '山东省', '联通', '0', '2011-04-12', '1'), ('15193', '112.224.3.126', '山东省', '联通', '0', '2011-04-12', '1'), ('15194', '118.212.190.231', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15195', '58.22.114.149', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15196', '218.60.139.94', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15197', '110.17.170.68', '内蒙古', '联通', '0', '2011-04-12', '1'), ('15198', '113.57.244.64', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15199', '123.234.33.66', '山东省青岛市', '联通', '0', '2011-04-12', '1'), ('15200', '218.60.138.154', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15201', '202.99.84.126', '天津市', '联通', '0', '2011-04-12', '1'), ('15202', '220.198.75.175', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15203', '118.212.190.15', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15204', '121.31.250.1', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('15205', '218.60.141.232', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15206', '120.84.72.15', '广东省', '联通', '0', '2011-04-12', '1'), ('15207', '122.194.3.246', '江苏省', '联通', '0', '2011-04-12', '1'), ('15208', '112.64.190.175', '上海市', '联通', '0', '2011-04-12', '1'), ('15209', '218.60.140.209', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15210', '113.57.244.150', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15211', '218.60.140.251', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15212', '211.96.235.19', '广东省中山市', '联通', '0', '2011-04-12', '1'), ('15213', '118.212.190.230', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15214', '119.4.252.15', '四川省', '联通', '0', '2011-04-12', '1'), ('15215', '124.160.209.33', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15216', '112.224.3.76', '山东省', '联通', '0', '2011-04-12', '1'), ('15217', '119.163.122.45', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15218', '113.58.26.152', '海南省', '联通', '0', '2011-04-12', '1'), ('15219', '221.194.31.132', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15220', '218.60.139.44', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15221', '58.16.226.120', '贵州省', '联通', '0', '2011-04-12', '1'), ('15222', '218.107.7.227', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15223', '58.22.114.152', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15224', '58.22.114.195', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15225', '124.160.209.157', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15226', '113.57.244.196', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15227', '123.147.244.54', '重庆市', '联通', '0', '2011-04-12', '1'), ('15228', '122.194.0.237', '江苏省', '联通', '0', '2011-04-12', '1'), ('15229', '122.194.2.68', '江苏省', '联通', '0', '2011-04-12', '1'), ('15230', '124.160.209.250', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15231', '61.158.152.213', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15232', '119.4.252.250', '四川省', '联通', '0', '2011-04-12', '1'), ('15233', '112.97.192.177', '广东省', '联通', '0', '2011-04-12', '1'), ('15234', '124.67.154.21', '内蒙古呼伦贝尔市', '联通', '0', '2011-04-12', '1'), ('15235', '119.4.252.214', '四川省', '联通', '0', '2011-04-12', '1'), ('15236', '122.194.0.30', '江苏省', '联通', '0', '2011-04-12', '1'), ('15237', '221.194.31.164', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15238', '112.96.196.140', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15239', '113.58.37.127', '海南省', '联通', '0', '2011-04-12', '1'), ('15240', '112.97.192.176', '广东省', '联通', '0', '2011-04-12', '1'), ('15241', '61.158.152.178', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15242', '124.160.209.148', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15243', '58.22.114.80', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15244', '124.160.209.155', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15245', '123.115.117.196', '北京市', '联通', '0', '2011-04-12', '1'), ('15246', '218.60.139.27', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15247', '220.199.58.99', '广东省', '联通', '0', '2011-04-12', '1'), ('15248', '61.158.152.29', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15249', '114.247.10.83', '北京市', '联通', '0', '2011-04-12', '1'), ('15250', '210.73.193.194', '北京市', '联通', '0', '2011-04-12', '1'), ('15251', '61.158.152.237', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15252', '113.57.246.237', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15253', '218.60.138.163', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15254', '61.158.152.147', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15255', '110.17.170.66', '内蒙古', '联通', '0', '2011-04-12', '1'), ('15256', '221.11.61.61', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15257', '218.28.63.99', '河南省平顶山市', '联通', '0', '2011-04-12', '1'), ('15258', '113.57.246.247', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15259', '113.57.246.234', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15260', '218.60.138.82', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15261', '221.11.61.64', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15262', '61.158.152.130', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15263', '113.57.244.2', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15264', '124.133.48.53', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15265', '221.11.61.96', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15266', '58.243.254.70', '安徽省', '联通', '0', '2011-04-12', '1'), ('15267', '202.99.84.148', '天津市', '联通', '0', '2011-04-12', '1'), ('15268', '120.84.33.233', '广东省', '联通', '0', '2011-04-12', '1'), ('15269', '218.60.140.92', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15270', '58.243.250.56', '安徽省', '联通', '0', '2011-04-12', '1');
INSERT INTO `ig_gateway` VALUES ('15271', '113.57.246.246', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15272', '119.180.108.53', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('15273', '61.158.152.165', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15274', '221.11.61.212', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15275', '113.58.61.178', '海南省', '联通', '0', '2011-04-12', '1'), ('15276', '116.113.84.203', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('15277', '124.160.208.187', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15278', '124.160.209.48', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15279', '124.160.208.201', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15280', '218.60.140.155', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15281', '211.96.102.211', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('15282', '58.243.254.120', '安徽省', '联通', '0', '2011-04-12', '1'), ('15283', '113.5.0.59', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('15284', '118.212.190.70', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15285', '58.19.253.19', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15286', '113.57.244.82', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15287', '27.37.133.25', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('15288', '119.4.252.85', '四川省', '联通', '0', '2011-04-12', '1'), ('15289', '220.199.219.237', '广东省', '联通', '0', '2011-04-12', '1'), ('15290', '58.252.30.136', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('15291', '119.4.252.134', '四川省', '联通', '0', '2011-04-12', '1'), ('15292', '112.96.166.175', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15293', '211.96.225.35', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15294', '220.198.34.159', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15295', '119.4.252.225', '四川省', '联通', '0', '2011-04-12', '1'), ('15296', '118.212.190.172', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15297', '119.4.252.67', '四川省', '联通', '0', '2011-04-12', '1'), ('15298', '122.194.3.114', '江苏省', '联通', '0', '2011-04-12', '1'), ('15299', '218.107.4.101', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15300', '58.243.250.6', '安徽省', '联通', '0', '2011-04-12', '1'), ('15301', '113.57.246.67', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15302', '112.224.2.86', '山东省', '联通', '0', '2011-04-12', '1'), ('15303', '220.249.103.228', '湖北省襄樊市', '联通', '0', '2011-04-12', '1'), ('15304', '124.160.208.34', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15305', '61.158.152.91', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15306', '58.243.250.4', '安徽省', '联通', '0', '2011-04-12', '1'), ('15307', '122.194.3.10', '江苏省', '联通', '0', '2011-04-12', '1'), ('15308', '221.11.61.16', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15309', '122.194.0.251', '江苏省', '联通', '0', '2011-04-12', '1'), ('15310', '221.194.30.167', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15311', '61.158.152.172', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15312', '218.26.158.60', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('15313', '123.117.180.58', '北京市', '联通', '0', '2011-04-12', '1'), ('15314', '122.194.0.173', '江苏省', '联通', '0', '2011-04-12', '1'), ('15315', '113.58.47.45', '海南省', '联通', '0', '2011-04-12', '1'), ('15316', '119.184.97.82', '山东省日照市', '联通', '0', '2011-04-12', '1'), ('15317', '123.232.150.86', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15318', '58.248.195.189', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15319', '202.99.84.64', '天津市', '联通', '0', '2011-04-12', '1'), ('15320', '124.160.209.49', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15321', '113.57.246.94', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15322', '202.99.125.93', '天津市', '联通', '0', '2011-04-12', '1'), ('15323', '113.58.31.213', '海南省', '联通', '0', '2011-04-12', '1'), ('15324', '58.243.254.86', '安徽省', '联通', '0', '2011-04-12', '1'), ('15325', '119.191.16.200', '山东省', '联通', '0', '2011-04-12', '1'), ('15326', '122.194.1.108', '江苏省', '联通', '0', '2011-04-12', '1'), ('15327', '124.160.208.132', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15328', '122.194.3.215', '江苏省', '联通', '0', '2011-04-12', '1'), ('15329', '118.81.12.24', '山西省太原市', '联通', '0', '2011-04-12', '1'), ('15330', '218.60.140.224', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15331', '124.160.208.21', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15332', '218.60.140.2', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15333', '112.224.3.53', '山东省', '联通', '0', '2011-04-12', '1'), ('15334', '112.97.192.189', '广东省', '联通', '0', '2011-04-12', '1'), ('15335', '122.194.1.98', '江苏省', '联通', '0', '2011-04-12', '1'), ('15336', '221.194.30.191', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15337', '58.243.250.40', '安徽省', '联通', '0', '2011-04-12', '1'), ('15338', '113.58.11.1', '海南省', '联通', '0', '2011-04-12', '1'), ('15339', '118.212.171.6', '江西省', '联通', '0', '2011-04-12', '1'), ('15340', '112.224.3.5', '山东省', '联通', '0', '2011-04-12', '1'), ('15341', '113.58.43.74', '海南省', '联通', '0', '2011-04-12', '1'), ('15342', '221.194.31.139', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15343', '116.113.84.229', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('15344', '122.194.1.164', '江苏省', '联通', '0', '2011-04-12', '1'), ('15345', '112.96.58.146', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15346', '210.13.67.246', '上海市', '联通', '0', '2011-04-12', '1'), ('15347', '61.158.152.42', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15348', '221.194.30.220', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15349', '124.160.209.229', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15350', '112.224.2.25', '山东省', '联通', '0', '2011-04-12', '1'), ('15351', '119.190.37.198', '山东省潍坊市', '联通', '0', '2011-04-12', '1'), ('15352', '112.97.187.128', '广东省', '联通', '0', '2011-04-12', '1'), ('15353', '118.212.191.194', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15354', '118.212.190.239', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15355', '113.58.45.7', '海南省', '联通', '0', '2011-04-12', '1'), ('15356', '218.60.141.230', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15357', '61.158.152.238', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15358', '112.224.3.37', '山东省', '联通', '0', '2011-04-12', '1'), ('15359', '112.224.3.23', '山东省', '联通', '0', '2011-04-12', '1'), ('15360', '218.60.140.137', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15361', '112.224.2.34', '山东省', '联通', '0', '2011-04-12', '1'), ('15362', '112.96.186.173', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15363', '122.194.1.21', '江苏省', '联通', '0', '2011-04-12', '1'), ('15364', '113.57.246.104', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15365', '220.198.59.137', '广东省梅州市', '联通', '0', '2011-04-12', '1'), ('15366', '112.96.120.30', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15367', '218.60.140.29', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15368', '218.60.139.239', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15369', '218.60.139.59', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15370', '221.194.31.75', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15371', '218.60.138.96', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15372', '124.160.208.165', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15373', '112.224.2.26', '山东省', '联通', '0', '2011-04-12', '1'), ('15374', '202.99.125.113', '天津市', '联通', '0', '2011-04-12', '1'), ('15375', '112.224.2.115', '山东省', '联通', '0', '2011-04-12', '1'), ('15376', '118.212.190.87', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15377', '122.194.1.122', '江苏省', '联通', '0', '2011-04-12', '1'), ('15378', '58.16.226.59', '贵州省', '联通', '0', '2011-04-12', '1'), ('15379', '113.57.246.53', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15380', '27.46.133.96', '广东省', '联通', '0', '2011-04-12', '1'), ('15381', '58.243.254.104', '安徽省', '联通', '0', '2011-04-12', '1'), ('15382', '220.198.70.171', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15383', '211.95.234.247', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15384', '118.212.171.100', '江西省', '联通', '0', '2011-04-12', '1'), ('15385', '119.190.112.171', '山东省', '联通', '0', '2011-04-12', '1'), ('15386', '118.212.190.46', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15387', '58.16.226.85', '贵州省', '联通', '0', '2011-04-12', '1'), ('15388', '114.246.252.28', '北京市', '联通', '0', '2011-04-12', '1'), ('15389', '112.224.3.83', '山东省', '联通', '0', '2011-04-12', '1'), ('15390', '122.194.3.227', '江苏省', '联通', '0', '2011-04-12', '1'), ('15391', '118.212.172.243', '江西省', '联通', '0', '2011-04-12', '1'), ('15392', '221.9.247.12', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('15393', '123.113.159.135', '北京市', '联通', '0', '2011-04-12', '1'), ('15394', '113.57.246.188', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15395', '119.4.252.154', '四川省', '联通', '0', '2011-04-12', '1'), ('15396', '218.60.141.252', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15397', '112.224.2.21', '山东省', '联通', '0', '2011-04-12', '1'), ('15398', '120.87.17.212', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15399', '122.194.3.187', '江苏省', '联通', '0', '2011-04-12', '1'), ('15400', '113.57.244.136', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15401', '202.99.84.146', '天津市', '联通', '0', '2011-04-12', '1'), ('15402', '112.224.3.125', '山东省', '联通', '0', '2011-04-12', '1'), ('15403', '112.96.139.201', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15404', '112.64.188.94', '上海市', '联通', '0', '2011-04-12', '1'), ('15405', '211.96.249.16', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('15406', '118.212.190.7', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15407', '218.60.138.80', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15408', '58.16.226.209', '贵州省', '联通', '0', '2011-04-12', '1'), ('15409', '119.4.252.3', '四川省', '联通', '0', '2011-04-12', '1'), ('15410', '221.7.7.193', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15411', '113.58.49.135', '海南省', '联通', '0', '2011-04-12', '1'), ('15412', '123.147.244.62', '重庆市', '联通', '0', '2011-04-12', '1'), ('15413', '113.57.246.245', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15414', '118.212.191.235', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15415', '61.136.114.162', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('15416', '218.60.140.182', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15417', '124.160.208.60', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15418', '112.244.52.74', '山东省', '联通', '0', '2011-04-12', '1'), ('15419', '58.16.226.5', '贵州省', '联通', '0', '2011-04-12', '1'), ('15420', '118.212.190.69', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15421', '112.224.2.18', '山东省', '联通', '0', '2011-04-12', '1'), ('15422', '220.198.127.54', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15423', '112.224.2.103', '山东省', '联通', '0', '2011-04-12', '1'), ('15424', '113.57.246.48', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15425', '113.57.246.17', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15426', '218.60.138.144', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15427', '124.160.208.174', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15428', '122.194.3.1', '江苏省', '联通', '0', '2011-04-12', '1'), ('15429', '119.48.44.62', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('15430', '210.83.64.156', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('15431', '120.84.55.109', '广东省', '联通', '0', '2011-04-12', '1'), ('15432', '112.224.2.82', '山东省', '联通', '0', '2011-04-12', '1'), ('15433', '119.4.252.17', '四川省', '联通', '0', '2011-04-12', '1'), ('15434', '118.212.190.244', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15435', '211.96.231.25', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15436', '119.177.26.64', '山东省潍坊市', '联通', '0', '2011-04-12', '1'), ('15437', '112.64.188.86', '上海市', '联通', '0', '2011-04-12', '1'), ('15438', '221.194.30.213', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15439', '113.57.244.250', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15440', '113.57.246.239', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15441', '218.60.138.231', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15442', '58.16.226.53', '贵州省', '联通', '0', '2011-04-12', '1'), ('15443', '122.194.1.105', '江苏省', '联通', '0', '2011-04-12', '1'), ('15444', '124.133.48.44', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15445', '27.46.248.242', '广东省', '联通', '0', '2011-04-12', '1'), ('15446', '218.60.140.133', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15447', '112.224.3.14', '山东省', '联通', '0', '2011-04-12', '1'), ('15448', '113.57.244.53', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15449', '112.224.2.46', '山东省', '联通', '0', '2011-04-12', '1'), ('15450', '218.60.138.179', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15451', '211.96.232.189', '广东省中山市', '联通', '0', '2011-04-12', '1'), ('15452', '117.9.158.39', '天津市', '联通', '0', '2011-04-12', '1'), ('15453', '124.160.208.144', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15454', '61.158.152.216', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15455', '118.212.190.200', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15456', '202.99.125.213', '天津市', '联通', '0', '2011-04-12', '1'), ('15457', '113.57.244.132', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15458', '119.177.12.91', '山东省潍坊市', '联通', '0', '2011-04-12', '1'), ('15459', '123.147.244.8', '重庆市', '联通', '0', '2011-04-12', '1'), ('15460', '124.160.209.6', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15461', '60.4.81.183', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('15462', '221.194.33.61', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('15463', '124.160.209.39', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15464', '220.199.105.39', '广东省', '联通', '0', '2011-04-12', '1'), ('15465', '27.46.162.155', '广东省', '联通', '0', '2011-04-12', '1'), ('15466', '112.224.2.45', '山东省', '联通', '0', '2011-04-12', '1'), ('15467', '113.57.244.173', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15468', '124.160.209.62', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15469', '112.96.88.93', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15470', '202.99.84.78', '天津市', '联通', '0', '2011-04-12', '1'), ('15471', '220.198.74.142', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15472', '112.224.2.12', '山东省', '联通', '0', '2011-04-12', '1'), ('15473', '27.46.90.186', '广东省', '联通', '0', '2011-04-12', '1'), ('15474', '124.160.208.74', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15475', '118.212.190.164', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15476', '61.158.152.162', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15477', '124.160.209.116', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15478', '112.224.2.38', '山东省', '联通', '0', '2011-04-12', '1'), ('15479', '119.180.108.225', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('15480', '112.224.2.51', '山东省', '联通', '0', '2011-04-12', '1'), ('15481', '61.49.54.140', '北京市', '联通', '0', '2011-04-12', '1'), ('15482', '27.46.85.150', '广东省', '联通', '0', '2011-04-12', '1'), ('15483', '113.57.244.59', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15484', '119.4.252.201', '四川省', '联通', '0', '2011-04-12', '1'), ('15485', '118.212.190.176', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15486', '221.7.7.115', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15487', '211.96.104.40', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('15488', '220.206.243.9', '中国', '联通', '0', '2011-04-12', '1'), ('15489', '113.57.244.116', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15490', '119.180.109.73', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('15491', '114.246.66.129', '北京市', '联通', '0', '2011-04-12', '1'), ('15492', '58.16.226.23', '贵州省', '联通', '0', '2011-04-12', '1'), ('15493', '123.147.244.48', '重庆市', '联通', '0', '2011-04-12', '1'), ('15494', '118.212.190.71', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15495', '124.160.209.75', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15496', '112.224.3.29', '山东省', '联通', '0', '2011-04-12', '1'), ('15497', '124.160.209.92', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15498', '119.4.252.49', '四川省', '联通', '0', '2011-04-12', '1'), ('15499', '61.179.162.99', '山东省安丘市', '联通', '0', '2011-04-12', '1'), ('15500', '27.46.158.242', '广东省', '联通', '0', '2011-04-12', '1'), ('15501', '220.198.36.163', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15502', '124.160.209.80', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15503', '112.97.171.194', '广东省', '联通', '0', '2011-04-12', '1'), ('15504', '118.81.237.189', '山西省太原市', '联通', '0', '2011-04-12', '1'), ('15505', '112.64.188.48', '上海市', '联通', '0', '2011-04-12', '1'), ('15506', '58.16.226.245', '贵州省', '联通', '0', '2011-04-12', '1'), ('15507', '124.160.209.70', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15508', '123.5.197.55', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15509', '119.4.252.122', '四川省', '联通', '0', '2011-04-12', '1'), ('15510', '218.60.141.227', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15511', '113.57.246.203', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15512', '220.198.36.252', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15513', '123.120.91.207', '北京市', '联通', '0', '2011-04-12', '1'), ('15514', '218.60.141.152', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15515', '220.199.131.45', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15516', '220.199.157.223', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15517', '221.205.139.165', '山西省长治市', '联通', '0', '2011-04-12', '1'), ('15518', '120.84.81.112', '广东省', '联通', '0', '2011-04-12', '1'), ('15519', '124.160.209.209', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15520', '124.160.209.182', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15521', '218.60.139.208', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15522', '113.58.0.193', '海南省', '联通', '0', '2011-04-12', '1'), ('15523', '112.64.188.54', '上海市', '联通', '0', '2011-04-12', '1'), ('15524', '113.5.0.58', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('15525', '124.160.208.217', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15526', '112.224.2.66', '山东省', '联通', '0', '2011-04-12', '1'), ('15527', '61.49.54.133', '北京市', '联通', '0', '2011-04-12', '1'), ('15528', '119.4.252.89', '四川省', '联通', '0', '2011-04-12', '1'), ('15529', '122.194.3.164', '江苏省', '联通', '0', '2011-04-12', '1'), ('15530', '123.147.244.3', '重庆市', '联通', '0', '2011-04-12', '1'), ('15531', '118.212.190.152', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15532', '221.205.138.245', '山西省长治市', '联通', '0', '2011-04-12', '1'), ('15533', '118.212.190.76', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15534', '218.60.140.75', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15535', '113.57.244.160', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15536', '61.158.152.148', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15537', '220.250.16.214', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15538', '120.87.3.19', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15539', '202.99.84.61', '天津市', '联通', '0', '2011-04-12', '1'), ('15540', '221.1.57.147', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('15541', '112.96.168.199', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15542', '61.158.152.90', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15543', '218.60.140.130', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15544', '113.58.34.149', '海南省', '联通', '0', '2011-04-12', '1'), ('15545', '221.194.31.172', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15546', '218.28.57.38', '河南省焦作市', '联通', '0', '2011-04-12', '1'), ('15547', '113.57.246.130', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15548', '113.57.246.173', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15549', '112.224.3.122', '山东省', '联通', '0', '2011-04-12', '1'), ('15550', '210.83.64.157', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('15551', '122.194.1.24', '江苏省', '联通', '0', '2011-04-12', '1'), ('15552', '58.248.122.5', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15553', '112.111.49.246', '福建省', '联通', '0', '2011-04-12', '1'), ('15554', '113.58.41.5', '海南省', '联通', '0', '2011-04-12', '1'), ('15555', '218.60.141.175', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15556', '222.131.242.148', '北京市', '联通', '0', '2011-04-12', '1'), ('15557', '123.139.155.31', '陕西省', '联通', '0', '2011-04-12', '1'), ('15558', '58.243.254.123', '安徽省', '联通', '0', '2011-04-12', '1'), ('15559', '61.158.152.204', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15560', '123.125.156.171', '北京市', '联通', '0', '2011-04-12', '1'), ('15561', '113.58.18.173', '海南省', '联通', '0', '2011-04-12', '1'), ('15562', '221.194.31.193', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15563', '112.64.188.74', '上海市', '联通', '0', '2011-04-12', '1'), ('15564', '118.212.172.79', '江西省', '联通', '0', '2011-04-12', '1'), ('15565', '218.60.140.249', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15566', '58.16.226.117', '贵州省', '联通', '0', '2011-04-12', '1'), ('15567', '118.212.190.203', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15568', '112.224.3.92', '山东省', '联通', '0', '2011-04-12', '1'), ('15569', '125.40.154.191', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15570', '124.160.209.208', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15571', '221.205.137.160', '山西省长治市', '联通', '0', '2011-04-12', '1'), ('15572', '122.194.3.53', '江苏省', '联通', '0', '2011-04-12', '1'), ('15573', '221.194.30.159', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15574', '112.224.3.4', '山东省', '联通', '0', '2011-04-12', '1'), ('15575', '124.160.208.191', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15576', '124.133.48.61', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15577', '221.194.31.51', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15578', '218.60.138.97', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15579', '118.212.190.13', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15580', '114.246.252.225', '北京市', '联通', '0', '2011-04-12', '1'), ('15581', '112.64.190.39', '上海市', '联通', '0', '2011-04-12', '1'), ('15582', '119.4.252.147', '四川省', '联通', '0', '2011-04-12', '1'), ('15583', '113.57.244.249', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15584', '58.243.254.75', '安徽省', '联通', '0', '2011-04-12', '1'), ('15585', '218.60.141.241', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15586', '119.4.252.55', '四川省', '联通', '0', '2011-04-12', '1'), ('15587', '112.224.3.112', '山东省', '联通', '0', '2011-04-12', '1'), ('15588', '218.60.139.174', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15589', '112.224.2.106', '山东省', '联通', '0', '2011-04-12', '1'), ('15590', '218.60.138.216', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15591', '112.96.136.228', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15592', '112.224.2.3', '山东省', '联通', '0', '2011-04-12', '1'), ('15593', '221.11.61.245', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15594', '118.212.190.21', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15595', '113.58.44.83', '海南省', '联通', '0', '2011-04-12', '1'), ('15596', '118.212.172.52', '江西省', '联通', '0', '2011-04-12', '1'), ('15597', '113.57.244.110', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15598', '58.248.195.125', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15599', '112.224.3.43', '山东省', '联通', '0', '2011-04-12', '1'), ('15600', '113.57.246.73', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15601', '125.40.155.172', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15602', '27.46.225.39', '广东省', '联通', '0', '2011-04-12', '1'), ('15603', '61.158.152.24', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15604', '112.96.160.47', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15605', '113.57.246.149', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15606', '124.160.208.5', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15607', '112.224.3.28', '山东省', '联通', '0', '2011-04-12', '1'), ('15608', '220.249.142.188', '福建省宁德市', '联通', '0', '2011-04-12', '1'), ('15609', '218.60.140.76', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15610', '218.60.139.112', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15611', '120.87.30.106', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15612', '123.120.61.129', '北京市', '联通', '0', '2011-04-12', '1'), ('15613', '122.194.0.28', '江苏省', '联通', '0', '2011-04-12', '1'), ('15614', '119.4.252.35', '四川省', '联通', '0', '2011-04-12', '1'), ('15615', '61.158.152.11', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15616', '220.199.217.12', '广东省', '联通', '0', '2011-04-12', '1'), ('15617', '221.11.61.247', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15618', '58.247.188.110', '上海市', '联通', '0', '2011-04-12', '1'), ('15619', '112.64.188.29', '上海市', '联通', '0', '2011-04-12', '1'), ('15620', '112.224.2.62', '山东省', '联通', '0', '2011-04-12', '1'), ('15621', '220.199.37.74', '广东省', '联通', '0', '2011-04-12', '1'), ('15622', '118.212.190.185', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15623', '112.224.2.36', '山东省', '联通', '0', '2011-04-12', '1'), ('15624', '218.60.140.13', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15625', '210.13.77.247', '上海市', '联通', '0', '2011-04-12', '1'), ('15626', '113.57.246.37', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15627', '220.198.51.13', '广东省茂名市', '联通', '0', '2011-04-12', '1'), ('15628', '221.194.30.122', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15629', '113.57.246.120', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15630', '218.60.140.186', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15631', '218.60.138.1', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15632', '112.224.3.82', '山东省', '联通', '0', '2011-04-12', '1'), ('15633', '120.87.13.179', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15634', '202.99.84.32', '天津市', '联通', '0', '2011-04-12', '1'), ('15635', '112.96.195.78', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15636', '110.245.32.254', '河北省承德市', '联通', '0', '2011-04-12', '1'), ('15637', '221.194.31.50', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15638', '119.4.252.23', '四川省', '联通', '0', '2011-04-12', '1'), ('15639', '113.57.244.206', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15640', '122.194.3.109', '江苏省', '联通', '0', '2011-04-12', '1'), ('15641', '120.8.27.195', '河北省邯郸市', '联通', '0', '2011-04-12', '1'), ('15642', '113.57.244.123', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15643', '221.11.61.63', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15644', '119.4.252.4', '四川省', '联通', '0', '2011-04-12', '1'), ('15645', '113.57.246.62', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15646', '125.40.154.206', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15647', '113.57.246.60', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15648', '58.22.113.54', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15649', '58.22.113.120', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15650', '218.60.138.135', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15651', '118.212.190.64', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15652', '112.64.190.133', '上海市', '联通', '0', '2011-04-12', '1'), ('15653', '118.212.190.26', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15654', '113.58.25.59', '海南省', '联通', '0', '2011-04-12', '1'), ('15655', '124.160.208.141', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15656', '118.212.172.84', '江西省', '联通', '0', '2011-04-12', '1'), ('15657', '221.11.61.246', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15658', '27.44.13.250', '广东省', '联通', '0', '2011-04-12', '1'), ('15659', '118.212.190.104', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15660', '118.212.172.197', '江西省', '联通', '0', '2011-04-12', '1'), ('15661', '113.58.7.193', '海南省', '联通', '0', '2011-04-12', '1'), ('15662', '112.224.3.90', '山东省', '联通', '0', '2011-04-12', '1'), ('15663', '221.194.31.90', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15664', '211.95.225.190', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15665', '119.184.100.26', '山东省日照市', '联通', '0', '2011-04-12', '1'), ('15666', '58.22.114.190', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15667', '58.22.114.74', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15668', '118.212.190.165', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15669', '222.160.78.190', '吉林省松原市', '联通', '0', '2011-04-12', '1'), ('15670', '118.212.190.197', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15671', '112.64.188.92', '上海市', '联通', '0', '2011-04-12', '1'), ('15672', '61.158.152.111', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15673', '218.60.141.243', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15674', '121.26.243.6', '河北省承德市', '联通', '0', '2011-04-12', '1'), ('15675', '119.4.252.129', '四川省', '联通', '0', '2011-04-12', '1'), ('15676', '112.224.3.50', '山东省', '联通', '0', '2011-04-12', '1'), ('15677', '119.4.252.101', '四川省', '联通', '0', '2011-04-12', '1'), ('15678', '112.224.2.29', '山东省', '联通', '0', '2011-04-12', '1'), ('15679', '118.212.190.9', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15680', '112.96.164.180', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15681', '221.194.30.212', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15682', '58.22.114.66', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15683', '220.199.236.68', '广东省', '联通', '0', '2011-04-12', '1'), ('15684', '122.194.2.190', '江苏省', '联通', '0', '2011-04-12', '1'), ('15685', '118.212.172.5', '江西省', '联通', '0', '2011-04-12', '1'), ('15686', '112.94.81.144', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15687', '221.11.61.169', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15688', '119.62.127.202', '云南省', '联通', '0', '2011-04-12', '1'), ('15689', '119.4.252.157', '四川省', '联通', '0', '2011-04-12', '1'), ('15690', '119.4.252.103', '四川省', '联通', '0', '2011-04-12', '1'), ('15691', '118.212.190.193', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15692', '122.194.0.92', '江苏省', '联通', '0', '2011-04-12', '1'), ('15693', '58.16.226.39', '贵州省', '联通', '0', '2011-04-12', '1'), ('15694', '118.212.172.231', '江西省', '联通', '0', '2011-04-12', '1'), ('15695', '123.147.244.35', '重庆市', '联通', '0', '2011-04-12', '1'), ('15696', '112.224.2.118', '山东省', '联通', '0', '2011-04-12', '1'), ('15697', '113.57.255.4', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15698', '123.147.244.61', '重庆市', '联通', '0', '2011-04-12', '1'), ('15699', '119.4.252.161', '四川省', '联通', '0', '2011-04-12', '1'), ('15700', '118.212.190.85', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15701', '61.158.152.245', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15702', '220.198.85.211', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15703', '220.198.43.170', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('15704', '221.194.31.228', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15705', '112.94.64.24', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15706', '60.217.206.246', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15707', '211.96.64.147', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('15708', '218.60.138.58', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15709', '220.199.240.54', '广东省', '联通', '0', '2011-04-12', '1'), ('15710', '113.57.246.64', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15711', '122.194.1.169', '江苏省', '联通', '0', '2011-04-12', '1'), ('15712', '221.11.61.204', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15713', '61.158.152.53', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15714', '112.64.190.163', '上海市', '联通', '0', '2011-04-12', '1'), ('15715', '124.160.209.222', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15716', '220.199.244.180', '广东省', '联通', '0', '2011-04-12', '1'), ('15717', '58.243.254.84', '安徽省', '联通', '0', '2011-04-12', '1'), ('15718', '218.60.138.25', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15719', '119.4.252.53', '四川省', '联通', '0', '2011-04-12', '1'), ('15720', '221.194.30.217', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15721', '218.60.139.6', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15722', '118.212.190.114', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15723', '61.158.152.124', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15724', '125.36.239.30', '天津市', '联通', '0', '2011-04-12', '1'), ('15725', '112.96.59.230', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15726', '221.194.30.203', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15727', '124.160.209.178', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15728', '118.212.190.238', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15729', '218.107.3.160', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15730', '113.57.246.77', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15731', '58.22.113.145', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15732', '112.224.2.96', '山东省', '联通', '0', '2011-04-12', '1'), ('15733', '112.224.2.48', '山东省', '联通', '0', '2011-04-12', '1'), ('15734', '112.64.190.177', '上海市', '联通', '0', '2011-04-12', '1'), ('15735', '112.96.57.243', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15736', '123.132.214.147', '山东省临沂市', '联通', '0', '2011-04-12', '1'), ('15737', '118.212.190.212', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15738', '221.11.61.144', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15739', '118.212.190.17', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15740', '221.11.61.147', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15741', '119.4.252.80', '四川省', '联通', '0', '2011-04-12', '1'), ('15742', '120.84.55.229', '广东省', '联通', '0', '2011-04-12', '1'), ('15743', '124.160.209.166', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15744', '58.243.250.2', '安徽省', '联通', '0', '2011-04-12', '1'), ('15745', '58.22.114.161', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15746', '220.199.176.108', '广东省', '联通', '0', '2011-04-12', '1'), ('15747', '123.147.244.56', '重庆市', '联通', '0', '2011-04-12', '1'), ('15748', '118.212.172.70', '江西省', '联通', '0', '2011-04-12', '1'), ('15749', '110.7.68.135', '内蒙古', '联通', '0', '2011-04-12', '1'), ('15750', '112.97.33.118', '广东省', '联通', '0', '2011-04-12', '1'), ('15751', '119.4.252.73', '四川省', '联通', '0', '2011-04-12', '1'), ('15752', '112.224.2.59', '山东省', '联通', '0', '2011-04-12', '1'), ('15753', '58.243.254.122', '安徽省', '联通', '0', '2011-04-12', '1'), ('15754', '122.194.1.208', '江苏省', '联通', '0', '2011-04-12', '1'), ('15755', '58.243.254.50', '安徽省', '联通', '0', '2011-04-12', '1'), ('15756', '221.11.61.119', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15757', '118.212.190.178', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15758', '113.57.246.191', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15759', '119.4.252.216', '四川省', '联通', '0', '2011-04-12', '1'), ('15760', '123.13.175.58', '河南省', '联通', '0', '2011-04-12', '1'), ('15761', '119.162.130.198', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15762', '61.158.152.207', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15763', '120.87.24.92', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15764', '112.64.190.158', '上海市', '联通', '0', '2011-04-12', '1'), ('15765', '118.212.190.147', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15766', '58.16.226.129', '贵州省', '联通', '0', '2011-04-12', '1'), ('15767', '61.158.152.253', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15768', '221.194.30.211', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15769', '58.100.54.168', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('15770', '118.212.190.88', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15771', '112.224.2.102', '山东省', '联通', '0', '2011-04-12', '1'), ('15772', '119.4.252.88', '四川省', '联通', '0', '2011-04-12', '1'), ('15773', '219.82.73.137', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('15774', '112.96.199.55', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15775', '112.64.188.140', '上海市', '联通', '0', '2011-04-12', '1'), ('15776', '61.158.152.249', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15777', '221.11.61.88', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15778', '122.194.2.205', '江苏省', '联通', '0', '2011-04-12', '1'), ('15779', '58.100.59.4', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('15780', '119.4.252.232', '四川省', '联通', '0', '2011-04-12', '1'), ('15781', '220.199.198.227', '广东省', '联通', '0', '2011-04-12', '1'), ('15782', '61.158.152.101', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15783', '220.198.46.32', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('15784', '118.212.190.60', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15785', '118.212.172.225', '江西省', '联通', '0', '2011-04-12', '1'), ('15786', '221.11.61.149', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15787', '112.64.188.119', '上海市', '联通', '0', '2011-04-12', '1'), ('15788', '202.99.84.36', '天津市', '联通', '0', '2011-04-12', '1'), ('15789', '221.11.61.134', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15790', '112.224.2.1', '山东省', '联通', '0', '2011-04-12', '1'), ('15791', '113.57.246.66', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15792', '116.113.84.230', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('15793', '202.99.125.33', '天津市', '联通', '0', '2011-04-12', '1'), ('15794', '61.158.152.58', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15795', '27.46.131.209', '广东省', '联通', '0', '2011-04-12', '1'), ('15796', '61.158.152.196', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15797', '112.64.188.151', '上海市', '联通', '0', '2011-04-12', '1'), ('15798', '113.57.244.94', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15799', '112.122.88.243', '安徽省合肥市', '联通', '0', '2011-04-12', '1'), ('15800', '119.4.252.92', '四川省', '联通', '0', '2011-04-12', '1'), ('15801', '218.60.140.5', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15802', '211.96.229.112', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15803', '124.160.209.23', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15804', '113.57.246.30', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15805', '114.247.10.82', '北京市', '联通', '0', '2011-04-12', '1'), ('15806', '58.243.250.71', '安徽省', '联通', '0', '2011-04-12', '1'), ('15807', '221.194.31.223', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15808', '112.64.188.156', '上海市', '联通', '0', '2011-04-12', '1'), ('15809', '202.99.125.94', '天津市', '联通', '0', '2011-04-12', '1'), ('15810', '61.158.152.225', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15811', '221.11.61.161', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15812', '113.57.246.153', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15813', '113.57.244.40', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15814', '118.212.190.33', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15815', '119.4.252.189', '四川省', '联通', '0', '2011-04-12', '1'), ('15816', '113.57.246.248', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15817', '121.31.24.16', '广西自治区南宁市', '联通', '0', '2011-04-12', '1'), ('15818', '218.25.9.6', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('15819', '122.194.1.239', '江苏省', '联通', '0', '2011-04-12', '1'), ('15820', '112.96.255.226', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15821', '119.163.122.208', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15822', '119.163.122.198', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15823', '120.87.23.218', '广东省韶关市', '联通', '0', '2011-04-12', '1'), ('15824', '119.163.122.194', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15825', '124.160.208.139', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15826', '110.6.208.116', '内蒙古', '联通', '0', '2011-04-12', '1'), ('15827', '221.194.30.145', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15828', '61.158.152.189', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15829', '218.60.141.47', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15830', '124.160.208.210', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15831', '112.96.196.6', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15832', '202.99.84.252', '天津市', '联通', '0', '2011-04-12', '1'), ('15833', '113.57.246.131', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15834', '61.158.152.92', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15835', '118.212.191.77', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15836', '27.46.73.53', '广东省', '联通', '0', '2011-04-12', '1'), ('15837', '118.212.171.134', '江西省', '联通', '0', '2011-04-12', '1'), ('15838', '58.243.254.80', '安徽省', '联通', '0', '2011-04-12', '1'), ('15839', '123.157.82.118', '浙江省', '联通', '0', '2011-04-12', '1'), ('15840', '218.26.158.50', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('15841', '120.84.39.65', '广东省', '联通', '0', '2011-04-12', '1'), ('15842', '60.209.194.42', '山东省青岛市', '联通', '0', '2011-04-12', '1'), ('15843', '220.199.149.161', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15844', '61.158.152.217', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15845', '218.60.140.61', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15846', '220.199.227.242', '广东省', '联通', '0', '2011-04-12', '1'), ('15847', '221.194.31.91', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15848', '118.212.190.97', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15849', '123.147.244.51', '重庆市', '联通', '0', '2011-04-12', '1'), ('15850', '112.96.129.114', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15851', '113.57.244.31', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15852', '211.96.119.130', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('15853', '123.155.254.107', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15854', '122.194.0.223', '江苏省', '联通', '0', '2011-04-12', '1'), ('15855', '119.163.122.201', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15856', '202.99.125.222', '天津市', '联通', '0', '2011-04-12', '1'), ('15857', '122.194.1.31', '江苏省', '联通', '0', '2011-04-12', '1'), ('15858', '124.160.208.121', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15859', '124.160.209.235', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15860', '112.224.2.49', '山东省', '联通', '0', '2011-04-12', '1'), ('15861', '221.194.30.57', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15862', '202.99.84.62', '天津市', '联通', '0', '2011-04-12', '1'), ('15863', '112.224.2.52', '山东省', '联通', '0', '2011-04-12', '1'), ('15864', '221.7.7.201', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15865', '123.155.240.156', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15866', '122.194.1.78', '江苏省', '联通', '0', '2011-04-12', '1'), ('15867', '118.212.190.51', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15868', '58.16.226.17', '贵州省', '联通', '0', '2011-04-12', '1'), ('15869', '124.160.208.63', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15870', '119.163.122.195', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15871', '61.158.152.139', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15872', '27.46.253.77', '广东省', '联通', '0', '2011-04-12', '1'), ('15873', '221.11.61.135', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15874', '123.5.167.125', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15875', '113.57.244.36', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15876', '119.4.252.218', '四川省', '联通', '0', '2011-04-12', '1'), ('15877', '220.199.133.147', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15878', '113.57.246.23', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15879', '221.7.7.6', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15880', '220.199.252.173', '广东省', '联通', '0', '2011-04-12', '1'), ('15881', '112.96.255.3', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15882', '124.160.208.110', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15883', '112.64.190.44', '上海市', '联通', '0', '2011-04-12', '1'), ('15884', '221.194.31.111', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15885', '112.96.255.14', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15886', '119.163.122.211', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15887', '113.57.244.234', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15888', '120.84.49.174', '广东省', '联通', '0', '2011-04-12', '1'), ('15889', '118.212.190.167', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15890', '122.194.3.159', '江苏省', '联通', '0', '2011-04-12', '1'), ('15891', '61.158.152.35', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15892', '221.11.61.190', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15893', '118.212.171.26', '江西省', '联通', '0', '2011-04-12', '1'), ('15894', '125.40.152.134', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15895', '218.60.140.107', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15896', '112.224.2.9', '山东省', '联通', '0', '2011-04-12', '1'), ('15897', '116.113.84.199', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('15898', '118.212.171.9', '江西省', '联通', '0', '2011-04-12', '1'), ('15899', '202.99.125.44', '天津市', '联通', '0', '2011-04-12', '1'), ('15900', '221.7.7.219', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15901', '123.147.244.32', '重庆市', '联通', '0', '2011-04-12', '1'), ('15902', '119.163.122.222', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15903', '122.194.1.66', '江苏省', '联通', '0', '2011-04-12', '1'), ('15904', '119.39.248.27', '湖南省', '联通', '0', '2011-04-12', '1'), ('15905', '118.212.190.2', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15906', '221.11.61.216', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15907', '118.212.172.89', '江西省', '联通', '0', '2011-04-12', '1'), ('15908', '218.60.140.78', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15909', '122.194.1.127', '江苏省', '联通', '0', '2011-04-12', '1'), ('15910', '220.206.243.10', '中国', '联通', '0', '2011-04-12', '1'), ('15911', '221.11.61.120', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15912', '112.97.114.38', '广东省', '联通', '0', '2011-04-12', '1'), ('15913', '113.57.246.181', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15914', '119.4.252.163', '四川省', '联通', '0', '2011-04-12', '1'), ('15915', '221.11.61.187', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15916', '112.96.195.189', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15917', '202.99.125.162', '天津市', '联通', '0', '2011-04-12', '1'), ('15918', '218.26.158.54', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('15919', '124.160.208.153', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15920', '218.60.141.202', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15921', '112.224.3.54', '山东省', '联通', '0', '2011-04-12', '1'), ('15922', '218.26.158.49', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('15923', '119.39.249.66', '湖南省', '联通', '0', '2011-04-12', '1'), ('15924', '124.160.209.151', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15925', '113.57.244.213', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15926', '123.147.244.43', '重庆市', '联通', '0', '2011-04-12', '1'), ('15927', '220.199.136.175', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15928', '218.60.140.40', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15929', '221.7.7.169', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15930', '221.11.61.249', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15931', '124.160.209.38', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15932', '125.40.155.118', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15933', '221.194.31.235', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('15934', '118.212.172.4', '江西省', '联通', '0', '2011-04-12', '1'), ('15935', '118.212.172.214', '江西省', '联通', '0', '2011-04-12', '1'), ('15936', '58.243.254.125', '安徽省', '联通', '0', '2011-04-12', '1'), ('15937', '122.194.3.120', '江苏省', '联通', '0', '2011-04-12', '1'), ('15938', '220.199.248.126', '广东省', '联通', '0', '2011-04-12', '1'), ('15939', '218.60.141.182', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15940', '202.99.84.224', '天津市', '联通', '0', '2011-04-12', '1'), ('15941', '124.160.208.68', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('15942', '113.57.244.151', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15943', '60.4.70.6', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('15944', '218.60.138.161', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15945', '119.163.122.200', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15946', '58.16.226.79', '贵州省', '联通', '0', '2011-04-12', '1'), ('15947', '119.4.252.247', '四川省', '联通', '0', '2011-04-12', '1'), ('15948', '218.60.140.154', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15949', '221.7.7.93', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15950', '61.158.152.13', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15951', '123.5.195.115', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('15952', '122.194.0.137', '江苏省', '联通', '0', '2011-04-12', '1'), ('15953', '218.60.139.153', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15954', '123.121.202.136', '北京市', '联通', '0', '2011-04-12', '1'), ('15955', '202.108.50.77', '北京市', '联通', '0', '2011-04-12', '1'), ('15956', '58.22.113.29', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15957', '221.11.61.46', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15958', '218.60.138.186', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('15959', '61.158.152.27', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15960', '118.212.190.130', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15961', '202.99.125.56', '天津市', '联通', '0', '2011-04-12', '1'), ('15962', '122.194.0.236', '江苏省', '联通', '0', '2011-04-12', '1'), ('15963', '112.96.86.68', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15964', '112.97.218.72', '广东省', '联通', '0', '2011-04-12', '1'), ('15965', '221.11.61.165', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15966', '112.96.118.193', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('15967', '58.22.113.25', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15968', '202.99.125.2', '天津市', '联通', '0', '2011-04-12', '1'), ('15969', '119.163.122.197', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15970', '58.243.254.124', '安徽省', '联通', '0', '2011-04-12', '1'), ('15971', '61.158.152.163', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15972', '123.232.219.217', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('15973', '118.212.186.55', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15974', '118.212.190.150', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15975', '58.22.114.174', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('15976', '113.57.246.91', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15977', '112.97.97.96', '广东省', '联通', '0', '2011-04-12', '1'), ('15978', '113.57.246.198', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15979', '119.4.252.183', '四川省', '联通', '0', '2011-04-12', '1'), ('15980', '221.7.7.217', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('15981', '61.158.152.112', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15982', '221.11.61.108', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15983', '112.224.2.24', '山东省', '联通', '0', '2011-04-12', '1'), ('15984', '112.224.3.85', '山东省', '联通', '0', '2011-04-12', '1'), ('15985', '61.158.152.2', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('15986', '202.99.125.148', '天津市', '联通', '0', '2011-04-12', '1'), ('15987', '112.224.3.6', '山东省', '联通', '0', '2011-04-12', '1'), ('15988', '221.11.61.14', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('15989', '113.57.246.152', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('15990', '218.60.141.203', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15991', '218.60.141.245', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('15992', '112.96.255.15', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15993', '202.99.84.116', '天津市', '联通', '0', '2011-04-12', '1'), ('15994', '112.96.144.57', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('15995', '211.96.229.16', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('15996', '220.199.213.53', '广东省', '联通', '0', '2011-04-12', '1'), ('15997', '118.212.190.3', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('15998', '116.112.48.76', '内蒙古包头市', '联通', '0', '2011-04-12', '1'), ('15999', '123.9.209.111', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16000', '112.64.190.124', '上海市', '联通', '0', '2011-04-12', '1'), ('16001', '221.11.61.15', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16002', '61.158.152.30', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16003', '124.160.209.168', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16004', '61.158.152.176', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16005', '112.64.190.156', '上海市', '联通', '0', '2011-04-12', '1'), ('16006', '220.199.171.98', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16007', '202.99.84.92', '天津市', '联通', '0', '2011-04-12', '1'), ('16008', '119.62.127.113', '云南省', '联通', '0', '2011-04-12', '1'), ('16009', '221.11.61.69', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16010', '124.160.209.50', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16011', '61.158.152.228', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16012', '211.96.226.15', '广东省珠海市', '联通', '0', '2011-04-12', '1'), ('16013', '61.158.152.107', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16014', '123.147.144.176', '重庆市', '联通', '0', '2011-04-12', '1'), ('16015', '112.64.190.162', '上海市', '联通', '0', '2011-04-12', '1'), ('16016', '112.231.65.251', '山东省', '联通', '0', '2011-04-12', '1'), ('16017', '221.11.61.47', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16018', '119.62.127.66', '云南省', '联通', '0', '2011-04-12', '1'), ('16019', '124.160.208.103', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16020', '119.163.122.238', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16021', '218.60.140.143', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16022', '218.60.138.121', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16023', '112.231.65.241', '山东省', '联通', '0', '2011-04-12', '1'), ('16024', '112.231.65.252', '山东省', '联通', '0', '2011-04-12', '1'), ('16025', '61.158.152.113', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16026', '220.199.146.115', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16027', '113.57.246.61', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16028', '58.243.250.12', '安徽省', '联通', '0', '2011-04-12', '1'), ('16029', '112.96.55.115', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16030', '123.5.209.227', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16031', '221.207.235.211', '黑龙江省哈尔滨市', '联通', '0', '2011-04-12', '1'), ('16032', '58.16.226.110', '贵州省', '联通', '0', '2011-04-12', '1'), ('16033', '61.158.152.38', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16034', '122.194.3.66', '江苏省', '联通', '0', '2011-04-12', '1'), ('16035', '112.64.188.152', '上海市', '联通', '0', '2011-04-12', '1'), ('16036', '58.243.254.69', '安徽省', '联通', '0', '2011-04-12', '1'), ('16037', '113.57.246.196', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16038', '112.231.65.254', '山东省', '联通', '0', '2011-04-12', '1'), ('16039', '119.163.122.225', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16040', '58.16.226.187', '贵州省', '联通', '0', '2011-04-12', '1'), ('16041', '112.231.65.240', '山东省', '联通', '0', '2011-04-12', '1'), ('16042', '218.60.140.191', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16043', '120.87.198.227', '广东省中山市', '联通', '0', '2011-04-12', '1'), ('16044', '120.84.38.240', '广东省', '联通', '0', '2011-04-12', '1'), ('16045', '221.9.247.17', '吉林省长春市', '联通', '0', '2011-04-12', '1'), ('16046', '221.11.61.110', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16047', '221.194.30.149', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16048', '112.97.246.151', '广东省', '联通', '0', '2011-04-12', '1'), ('16049', '112.96.154.51', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16050', '221.11.61.62', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16051', '61.158.152.234', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16052', '58.22.114.25', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16053', '221.7.7.32', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16054', '218.60.140.112', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16055', '124.160.208.76', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16056', '211.96.124.17', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16057', '123.5.167.195', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16058', '123.232.150.156', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16059', '112.231.65.250', '山东省', '联通', '0', '2011-04-12', '1'), ('16060', '119.4.252.141', '四川省', '联通', '0', '2011-04-12', '1'), ('16061', '221.11.61.188', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16062', '60.216.71.194', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16063', '61.158.152.133', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16064', '123.147.244.50', '重庆市', '联通', '0', '2011-04-12', '1'), ('16065', '211.96.127.6', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16066', '221.11.61.219', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16067', '112.224.2.55', '山东省', '联通', '0', '2011-04-12', '1'), ('16068', '58.22.113.81', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16069', '221.11.61.130', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16070', '120.84.38.51', '广东省', '联通', '0', '2011-04-12', '1'), ('16071', '122.194.3.83', '江苏省', '联通', '0', '2011-04-12', '1'), ('16072', '58.243.254.43', '安徽省', '联通', '0', '2011-04-12', '1'), ('16073', '112.96.140.204', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16074', '58.22.113.189', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16075', '124.67.151.246', '内蒙古呼伦贝尔市', '联通', '0', '2011-04-12', '1'), ('16076', '202.99.125.214', '天津市', '联通', '0', '2011-04-12', '1'), ('16077', '113.57.246.44', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16078', '123.5.212.65', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16079', '221.11.61.191', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16080', '110.6.213.8', '内蒙古', '联通', '0', '2011-04-12', '1'), ('16081', '220.199.143.239', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16082', '202.99.125.176', '天津市', '联通', '0', '2011-04-12', '1'), ('16083', '221.194.30.232', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16084', '123.159.110.119', '浙江省', '联通', '0', '2011-04-12', '1'), ('16085', '58.22.114.49', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16086', '118.212.190.229', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16087', '122.194.1.29', '江苏省', '联通', '0', '2011-04-12', '1'), ('16088', '221.11.61.5', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16089', '119.163.122.244', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16090', '118.212.190.4', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16091', '61.158.152.135', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16092', '122.194.3.127', '江苏省', '联通', '0', '2011-04-12', '1'), ('16093', '58.22.113.1', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16094', '60.4.70.60', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('16095', '218.60.138.251', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16096', '221.11.61.198', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16097', '221.11.61.89', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16098', '220.198.182.46', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16099', '58.243.250.76', '安徽省', '联通', '0', '2011-04-12', '1'), ('16100', '61.158.152.106', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16101', '124.133.48.45', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16102', '112.231.65.253', '山东省', '联通', '0', '2011-04-12', '1'), ('16103', '123.5.211.101', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16104', '221.11.61.222', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16105', '221.11.61.4', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16106', '61.158.152.230', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16107', '58.22.113.89', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16108', '220.250.49.123', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16109', '202.99.84.14', '天津市', '联通', '0', '2011-04-12', '1'), ('16110', '113.57.244.17', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16111', '220.198.66.145', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16112', '123.130.16.103', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('16113', '124.160.208.249', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16114', '112.64.188.145', '上海市', '联通', '0', '2011-04-12', '1'), ('16115', '123.5.212.30', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16116', '112.96.66.204', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16117', '112.224.2.43', '山东省', '联通', '0', '2011-04-12', '1'), ('16118', '118.212.191.245', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16119', '113.58.42.43', '海南省', '联通', '0', '2011-04-12', '1'), ('16120', '112.96.255.2', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16121', '58.19.97.3', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16122', '112.224.3.67', '山东省', '联通', '0', '2011-04-12', '1'), ('16123', '118.212.190.1', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16124', '58.16.226.185', '贵州省', '联通', '0', '2011-04-12', '1'), ('16125', '220.198.76.235', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16126', '112.96.88.92', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16127', '221.11.61.1', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16128', '113.57.246.214', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16129', '122.194.3.174', '江苏省', '联通', '0', '2011-04-12', '1'), ('16130', '202.99.125.23', '天津市', '联通', '0', '2011-04-12', '1'), ('16131', '202.99.125.206', '天津市', '联通', '0', '2011-04-12', '1'), ('16132', '220.199.224.201', '广东省', '联通', '0', '2011-04-12', '1'), ('16133', '125.40.153.131', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16134', '202.99.125.230', '天津市', '联通', '0', '2011-04-12', '1'), ('16135', '112.96.81.105', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16136', '118.212.190.248', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16137', '58.247.101.42', '上海市', '联通', '0', '2011-04-12', '1'), ('16138', '123.159.80.238', '浙江省', '联通', '0', '2011-04-12', '1'), ('16139', '211.96.100.235', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16140', '122.194.3.177', '江苏省', '联通', '0', '2011-04-12', '1'), ('16141', '115.61.2.147', '河南省', '联通', '0', '2011-04-12', '1'), ('16142', '220.199.85.238', '广东省', '联通', '0', '2011-04-12', '1'), ('16143', '221.11.61.174', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16144', '112.96.78.102', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16145', '124.160.208.12', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16146', '202.99.84.234', '天津市', '联通', '0', '2011-04-12', '1'), ('16147', '61.158.152.211', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16148', '112.224.3.58', '山东省', '联通', '0', '2011-04-12', '1'), ('16149', '122.194.0.171', '江苏省', '联通', '0', '2011-04-12', '1'), ('16150', '122.194.1.72', '江苏省', '联通', '0', '2011-04-12', '1'), ('16151', '58.243.250.85', '安徽省', '联通', '0', '2011-04-12', '1'), ('16152', '112.96.255.16', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16153', '112.64.188.121', '上海市', '联通', '0', '2011-04-12', '1'), ('16154', '123.147.244.34', '重庆市', '联通', '0', '2011-04-12', '1'), ('16155', '58.22.114.82', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16156', '124.160.209.35', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16157', '118.212.172.137', '江西省', '联通', '0', '2011-04-12', '1'), ('16158', '202.99.84.180', '天津市', '联通', '0', '2011-04-12', '1'), ('16159', '112.64.188.103', '上海市', '联通', '0', '2011-04-12', '1'), ('16160', '220.199.177.92', '广东省', '联通', '0', '2011-04-12', '1'), ('16161', '58.22.113.90', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16162', '110.17.170.70', '内蒙古', '联通', '0', '2011-04-12', '1'), ('16163', '118.212.172.233', '江西省', '联通', '0', '2011-04-12', '1'), ('16164', '120.84.86.185', '广东省', '联通', '0', '2011-04-12', '1'), ('16165', '122.194.1.107', '江苏省', '联通', '0', '2011-04-12', '1'), ('16166', '122.194.2.136', '江苏省', '联通', '0', '2011-04-12', '1'), ('16167', '219.156.93.65', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('16168', '120.87.213.65', '广东省中山市', '联通', '0', '2011-04-12', '1'), ('16169', '218.26.158.20', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16170', '118.212.171.217', '江西省', '联通', '0', '2011-04-12', '1'), ('16171', '112.64.190.51', '上海市', '联通', '0', '2011-04-12', '1'), ('16172', '58.19.97.6', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16173', '119.4.252.253', '四川省', '联通', '0', '2011-04-12', '1'), ('16174', '123.130.21.212', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('16175', '112.96.99.156', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16176', '202.99.84.236', '天津市', '联通', '0', '2011-04-12', '1'), ('16177', '123.121.201.182', '北京市', '联通', '0', '2011-04-12', '1'), ('16178', '124.160.208.234', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16179', '119.4.252.60', '四川省', '联通', '0', '2011-04-12', '1'), ('16180', '218.60.140.102', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16181', '123.147.244.25', '重庆市', '联通', '0', '2011-04-12', '1'), ('16182', '58.22.114.90', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16183', '118.212.190.198', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16184', '218.60.138.188', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16185', '221.194.31.195', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16186', '124.160.208.123', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16187', '120.84.138.121', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('16188', '61.158.152.183', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16189', '112.96.255.6', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16190', '119.4.252.98', '四川省', '联通', '0', '2011-04-12', '1'), ('16191', '110.7.219.12', '内蒙古', '联通', '0', '2011-04-12', '1'), ('16192', '124.160.208.126', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16193', '220.199.201.61', '广东省', '联通', '0', '2011-04-12', '1'), ('16194', '119.163.122.220', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16195', '58.22.114.97', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16196', '121.31.254.43', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('16197', '221.11.61.217', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16198', '220.198.103.123', '广东省湛江市', '联通', '0', '2011-04-12', '1'), ('16199', '202.99.84.188', '天津市', '联通', '0', '2011-04-12', '1'), ('16200', '27.46.197.34', '广东省', '联通', '0', '2011-04-12', '1'), ('16201', '58.22.113.94', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16202', '123.147.244.28', '重庆市', '联通', '0', '2011-04-12', '1'), ('16203', '119.4.252.99', '四川省', '联通', '0', '2011-04-12', '1'), ('16204', '211.95.226.11', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16205', '112.224.3.110', '山东省', '联通', '0', '2011-04-12', '1'), ('16206', '58.251.148.152', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16207', '113.229.244.110', '辽宁省丹东市', '联通', '0', '2011-04-12', '1'), ('16208', '112.64.190.174', '上海市', '联通', '0', '2011-04-12', '1'), ('16209', '202.99.84.72', '天津市', '联通', '0', '2011-04-12', '1'), ('16210', '211.96.119.28', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16211', '221.11.61.7', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16212', '112.224.2.105', '山东省', '联通', '0', '2011-04-12', '1'), ('16213', '58.243.254.91', '安徽省', '联通', '0', '2011-04-12', '1'), ('16214', '110.7.211.181', '内蒙古', '联通', '0', '2011-04-12', '1'), ('16215', '211.95.252.229', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16216', '112.64.188.111', '上海市', '联通', '0', '2011-04-12', '1'), ('16217', '202.99.125.28', '天津市', '联通', '0', '2011-04-12', '1'), ('16218', '58.248.195.87', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16219', '124.67.147.156', '内蒙古呼伦贝尔市', '联通', '0', '2011-04-12', '1'), ('16220', '119.4.252.5', '四川省', '联通', '0', '2011-04-12', '1'), ('16221', '120.84.76.65', '广东省', '联通', '0', '2011-04-12', '1'), ('16222', '119.177.91.28', '山东省潍坊市', '联通', '0', '2011-04-12', '1'), ('16223', '221.11.61.39', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16224', '112.96.255.7', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16225', '119.163.122.191', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16226', '112.224.2.32', '山东省', '联通', '0', '2011-04-12', '1'), ('16227', '60.4.77.245', '河北省保定市', '联通', '0', '2011-04-12', '1'), ('16228', '118.212.172.235', '江西省', '联通', '0', '2011-04-12', '1'), ('16229', '221.1.57.254', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('16230', '118.212.191.42', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16231', '119.4.252.115', '四川省', '联通', '0', '2011-04-12', '1'), ('16232', '112.96.147.123', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16233', '58.243.254.92', '安徽省', '联通', '0', '2011-04-12', '1'), ('16234', '118.212.172.171', '江西省', '联通', '0', '2011-04-12', '1'), ('16235', '124.134.125.148', '山东省淄博市', '联通', '0', '2011-04-12', '1'), ('16236', '218.60.138.74', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16237', '119.4.252.50', '四川省', '联通', '0', '2011-04-12', '1'), ('16238', '120.84.87.115', '广东省', '联通', '0', '2011-04-12', '1'), ('16239', '112.96.255.22', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16240', '112.238.193.38', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('16241', '114.249.123.242', '北京市', '联通', '0', '2011-04-12', '1'), ('16242', '27.46.175.125', '广东省', '联通', '0', '2011-04-12', '1'), ('16243', '221.11.61.200', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16244', '221.11.61.162', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16245', '119.163.122.213', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16246', '61.158.152.52', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16247', '113.57.244.177', '湖北省武汉市', '联通', '0', '2011-04-12', '1');
INSERT INTO `ig_gateway` VALUES ('16248', '124.160.209.126', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16249', '112.64.190.146', '上海市', '联通', '0', '2011-04-12', '1'), ('16250', '119.182.133.187', '山东省', '联通', '0', '2011-04-12', '1'), ('16251', '221.11.61.183', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16252', '113.58.72.157', '海南省', '联通', '0', '2011-04-12', '1'), ('16253', '123.139.154.78', '陕西省', '联通', '0', '2011-04-12', '1'), ('16254', '116.112.45.158', '内蒙古包头市', '联通', '0', '2011-04-12', '1'), ('16255', '221.11.61.160', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16256', '220.199.239.181', '广东省', '联通', '0', '2011-04-12', '1'), ('16257', '220.199.208.65', '广东省', '联通', '0', '2011-04-12', '1'), ('16258', '112.64.188.143', '上海市', '联通', '0', '2011-04-12', '1'), ('16259', '119.163.122.239', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16260', '113.57.244.44', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16261', '123.232.222.101', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16262', '123.147.244.16', '重庆市', '联通', '0', '2011-04-12', '1'), ('16263', '58.248.121.38', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16264', '61.135.186.42', '北京市', '联通', '0', '2011-04-12', '1'), ('16265', '221.11.61.104', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16266', '113.57.244.185', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16267', '112.64.188.147', '上海市', '联通', '0', '2011-04-12', '1'), ('16268', '113.57.244.118', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16269', '124.160.209.191', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16270', '112.224.2.53', '山东省', '联通', '0', '2011-04-12', '1'), ('16271', '124.160.209.162', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16272', '118.212.190.119', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16273', '123.125.71.61', '北京市', '联通', '0', '2011-04-12', '1'), ('16274', '113.57.246.139', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16275', '119.163.122.241', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16276', '221.11.61.228', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16277', '220.199.212.231', '广东省', '联通', '0', '2011-04-12', '1'), ('16278', '112.224.3.12', '山东省', '联通', '0', '2011-04-12', '1'), ('16279', '113.57.244.209', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16280', '221.11.61.139', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16281', '121.16.44.59', '河北省沧州市', '联通', '0', '2011-04-12', '1'), ('16282', '221.11.61.189', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16283', '124.160.208.146', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16284', '123.139.154.226', '陕西省', '联通', '0', '2011-04-12', '1'), ('16285', '113.57.244.131', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16286', '218.60.141.64', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('16287', '60.55.0.6', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('16288', '121.16.58.81', '河北省沧州市', '联通', '0', '2011-04-12', '1'), ('16289', '112.96.255.19', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16290', '124.128.255.136', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16291', '58.22.114.17', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16292', '221.7.7.7', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16293', '118.212.190.226', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16294', '119.163.122.252', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16295', '112.224.3.3', '山东省', '联通', '0', '2011-04-12', '1'), ('16296', '122.194.0.90', '江苏省', '联通', '0', '2011-04-12', '1'), ('16297', '113.57.244.57', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16298', '112.96.255.1', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16299', '113.57.244.203', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16300', '221.11.61.202', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16301', '113.57.244.90', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16302', '119.4.252.194', '四川省', '联通', '0', '2011-04-12', '1'), ('16303', '27.46.66.172', '广东省', '联通', '0', '2011-04-12', '1'), ('16304', '125.46.96.216', '河南省', '联通', '0', '2011-04-12', '1'), ('16305', '113.57.244.28', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16306', '222.140.116.152', '河南省济源市', '联通', '0', '2011-04-12', '1'), ('16307', '221.11.61.49', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16308', '119.163.122.223', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16309', '220.198.60.219', '广东省梅州市', '联通', '0', '2011-04-12', '1'), ('16310', '119.163.122.243', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16311', '27.46.26.69', '广东省', '联通', '0', '2011-04-12', '1'), ('16312', '113.57.244.5', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16313', '61.158.152.51', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16314', '113.57.244.246', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16315', '119.163.122.232', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16316', '112.64.188.138', '上海市', '联通', '0', '2011-04-12', '1'), ('16317', '122.194.3.2', '江苏省', '联通', '0', '2011-04-12', '1'), ('16318', '113.57.244.62', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16319', '58.19.97.1', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16320', '58.19.97.5', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16321', '58.19.97.2', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16322', '58.19.97.7', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16323', '112.96.255.21', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16324', '221.194.31.86', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16325', '113.57.246.103', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16326', '58.22.113.47', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16327', '112.224.3.78', '山东省', '联通', '0', '2011-04-12', '1'), ('16328', '112.96.255.23', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16329', '220.198.77.120', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16330', '61.158.152.177', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16331', '120.84.58.12', '广东省', '联通', '0', '2011-04-12', '1'), ('16332', '220.206.243.12', '中国', '联通', '0', '2011-04-12', '1'), ('16333', '113.57.244.70', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16334', '112.64.188.212', '上海市', '联通', '0', '2011-04-12', '1'), ('16335', '221.11.61.100', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16336', '221.11.61.6', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16337', '116.112.51.132', '内蒙古包头市', '联通', '0', '2011-04-12', '1'), ('16338', '113.232.184.182', '辽宁省沈阳市', '联通', '0', '2011-04-12', '1'), ('16339', '122.194.2.222', '江苏省', '联通', '0', '2011-04-12', '1'), ('16340', '202.99.84.200', '天津市', '联通', '0', '2011-04-12', '1'), ('16341', '221.11.61.81', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16342', '118.212.172.194', '江西省', '联通', '0', '2011-04-12', '1'), ('16343', '113.57.244.180', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16344', '221.11.61.133', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16345', '113.57.244.202', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16346', '124.160.208.120', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16347', '122.140.58.253', '吉林省松原市', '联通', '0', '2011-04-12', '1'), ('16348', '58.22.113.93', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16349', '58.22.113.2', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16350', '112.64.190.218', '上海市', '联通', '0', '2011-04-12', '1'), ('16351', '220.206.243.7', '中国', '联通', '0', '2011-04-12', '1'), ('16352', '221.11.61.244', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16353', '119.4.252.90', '四川省', '联通', '0', '2011-04-12', '1'), ('16354', '113.57.244.10', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16355', '119.4.252.149', '四川省', '联通', '0', '2011-04-12', '1'), ('16356', '220.206.243.8', '中国', '联通', '0', '2011-04-12', '1'), ('16357', '122.194.0.224', '江苏省', '联通', '0', '2011-04-12', '1'), ('16358', '122.194.2.4', '江苏省', '联通', '0', '2011-04-12', '1'), ('16359', '112.64.190.188', '上海市', '联通', '0', '2011-04-12', '1'), ('16360', '119.4.252.188', '四川省', '联通', '0', '2011-04-12', '1'), ('16361', '221.11.61.41', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16362', '122.143.95.96', '吉林省', '联通', '0', '2011-04-12', '1'), ('16363', '119.4.252.22', '四川省', '联通', '0', '2011-04-12', '1'), ('16364', '221.194.30.170', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16365', '112.64.188.130', '上海市', '联通', '0', '2011-04-12', '1'), ('16366', '221.11.61.238', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16367', '113.57.244.61', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16368', '118.212.190.10', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16369', '116.113.84.233', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('16370', '124.160.208.109', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16371', '119.4.252.2', '四川省', '联通', '0', '2011-04-12', '1'), ('16372', '27.46.49.67', '广东省', '联通', '0', '2011-04-12', '1'), ('16373', '113.58.62.38', '海南省', '联通', '0', '2011-04-12', '1'), ('16374', '202.99.84.109', '天津市', '联通', '0', '2011-04-12', '1'), ('16375', '123.132.227.26', '山东省', '联通', '0', '2011-04-12', '1'), ('16376', '119.39.248.66', '湖南省', '联通', '0', '2011-04-12', '1'), ('16377', '221.11.61.211', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16378', '27.43.226.212', '广东省揭阳市', '联通', '0', '2011-04-12', '1'), ('16379', '60.31.103.37', '内蒙古呼伦贝尔市', '联通', '0', '2011-04-12', '1'), ('16380', '112.64.188.107', '上海市', '联通', '0', '2011-04-12', '1'), ('16381', '118.212.172.228', '江西省', '联通', '0', '2011-04-12', '1'), ('16382', '222.140.116.107', '河南省济源市', '联通', '0', '2011-04-12', '1'), ('16383', '120.87.89.92', '广东省', '联通', '0', '2011-04-12', '1'), ('16384', '58.254.169.91', '广东省', '联通', '0', '2011-04-12', '1'), ('16385', '113.57.244.38', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16386', '27.46.9.65', '广东省', '联通', '0', '2011-04-12', '1'), ('16387', '118.212.190.8', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16388', '119.39.248.26', '湖南省', '联通', '0', '2011-04-12', '1'), ('16389', '221.194.30.155', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16390', '119.4.252.130', '四川省', '联通', '0', '2011-04-12', '1'), ('16391', '221.203.76.167', '辽宁省抚顺市', '联通', '0', '2011-04-12', '1'), ('16392', '220.206.243.15', '中国', '联通', '0', '2011-04-12', '1'), ('16393', '220.206.243.38', '中国', '联通', '0', '2011-04-12', '1'), ('16394', '119.4.252.191', '四川省', '联通', '0', '2011-04-12', '1'), ('16395', '114.246.162.240', '北京市', '联通', '0', '2011-04-12', '1'), ('16396', '118.212.190.44', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16397', '61.158.152.221', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16398', '118.212.172.18', '江西省', '联通', '0', '2011-04-12', '1'), ('16399', '112.96.64.32', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16400', '221.11.61.22', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16401', '119.39.249.104', '湖南省', '联通', '0', '2011-04-12', '1'), ('16402', '118.212.172.227', '江西省', '联通', '0', '2011-04-12', '1'), ('16403', '58.243.250.13', '安徽省', '联通', '0', '2011-04-12', '1'), ('16404', '114.249.144.90', '北京市', '联通', '0', '2011-04-12', '1'), ('16405', '221.194.31.218', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16406', '221.11.61.251', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16407', '112.96.255.11', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16408', '112.64.191.35', '上海市', '联通', '0', '2011-04-12', '1'), ('16409', '211.90.223.220', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('16410', '218.26.158.51', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16411', '58.243.250.7', '安徽省', '联通', '0', '2011-04-12', '1'), ('16412', '58.243.250.57', '安徽省', '联通', '0', '2011-04-12', '1'), ('16413', '58.22.114.107', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16414', '112.64.188.106', '上海市', '联通', '0', '2011-04-12', '1'), ('16415', '112.64.188.203', '上海市', '联通', '0', '2011-04-12', '1'), ('16416', '118.212.190.43', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16417', '27.46.37.106', '广东省', '联通', '0', '2011-04-12', '1'), ('16418', '113.58.41.9', '海南省', '联通', '0', '2011-04-12', '1'), ('16419', '124.160.208.101', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16420', '221.194.30.59', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16421', '112.96.64.17', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16422', '58.22.114.155', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16423', '124.128.255.128', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16424', '218.67.196.36', '天津市', '联通', '0', '2011-04-12', '1'), ('16425', '112.64.188.205', '上海市', '联通', '0', '2011-04-12', '1'), ('16426', '124.160.209.17', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16427', '113.57.242.183', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16428', '61.158.152.21', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16429', '221.7.7.243', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16430', '112.224.2.16', '山东省', '联通', '0', '2011-04-12', '1'), ('16431', '113.57.244.86', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16432', '112.96.64.2', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16433', '202.99.125.149', '天津市', '联通', '0', '2011-04-12', '1'), ('16434', '221.194.30.91', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16435', '218.60.138.246', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16436', '221.7.7.117', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16437', '118.212.191.79', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16438', '112.96.64.8', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16439', '221.7.7.28', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16440', '60.8.228.154', '河北省张家口市', '联通', '0', '2011-04-12', '1'), ('16441', '221.11.61.225', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16442', '112.64.188.120', '上海市', '联通', '0', '2011-04-12', '1'), ('16443', '202.99.125.3', '天津市', '联通', '0', '2011-04-12', '1'), ('16444', '218.60.139.145', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16445', '182.115.250.133', '河南省', '联通', '0', '2011-04-12', '1'), ('16446', '112.64.190.184', '上海市', '联通', '0', '2011-04-12', '1'), ('16447', '221.11.61.29', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16448', '220.199.192.214', '广东省', '联通', '0', '2011-04-12', '1'), ('16449', '119.39.248.8', '湖南省', '联通', '0', '2011-04-12', '1'), ('16450', '27.46.74.203', '广东省', '联通', '0', '2011-04-12', '1'), ('16451', '115.61.204.245', '河南省', '联通', '0', '2011-04-12', '1'), ('16452', '218.60.138.183', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16453', '221.194.30.219', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16454', '112.96.64.5', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16455', '58.22.113.69', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16456', '113.57.246.58', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16457', '122.194.3.223', '江苏省', '联通', '0', '2011-04-12', '1'), ('16458', '221.11.61.155', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16459', '123.132.179.217', '山东省', '联通', '0', '2011-04-12', '1'), ('16460', '119.250.29.195', '河北省廊坊市', '联通', '0', '2011-04-12', '1'), ('16461', '221.7.7.52', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16462', '115.85.238.134', '甘肃省', '联通', '0', '2011-04-12', '1'), ('16463', '202.99.125.142', '天津市', '联通', '0', '2011-04-12', '1'), ('16464', '218.26.158.61', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16465', '58.22.114.91', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16466', '122.194.0.220', '江苏省', '联通', '0', '2011-04-12', '1'), ('16467', '112.96.64.11', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16468', '112.97.192.188', '广东省', '联通', '0', '2011-04-12', '1'), ('16469', '119.4.252.86', '四川省', '联通', '0', '2011-04-12', '1'), ('16470', '112.64.190.181', '上海市', '联通', '0', '2011-04-12', '1'), ('16471', '218.60.141.94', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('16472', '112.96.64.3', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16473', '112.96.64.23', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16474', '221.7.7.46', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16475', '221.194.31.114', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16476', '118.212.172.215', '江西省', '联通', '0', '2011-04-12', '1'), ('16477', '119.4.252.114', '四川省', '联通', '0', '2011-04-12', '1'), ('16478', '113.57.246.21', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16479', '202.99.84.45', '天津市', '联通', '0', '2011-04-12', '1'), ('16480', '119.39.249.37', '湖南省', '联通', '0', '2011-04-12', '1'), ('16481', '119.4.252.164', '四川省', '联通', '0', '2011-04-12', '1'), ('16482', '221.7.7.19', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16483', '211.96.90.94', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16484', '113.57.244.187', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16485', '112.64.188.221', '上海市', '联通', '0', '2011-04-12', '1'), ('16486', '118.212.190.6', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16487', '220.199.170.6', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16488', '119.39.248.3', '湖南省', '联通', '0', '2011-04-12', '1'), ('16489', '58.243.250.53', '安徽省', '联通', '0', '2011-04-12', '1'), ('16490', '113.57.246.126', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16491', '112.64.191.42', '上海市', '联通', '0', '2011-04-12', '1'), ('16492', '122.194.2.82', '江苏省', '联通', '0', '2011-04-12', '1'), ('16493', '27.46.81.122', '广东省', '联通', '0', '2011-04-12', '1'), ('16494', '115.85.238.162', '甘肃省', '联通', '0', '2011-04-12', '1'), ('16495', '119.4.252.229', '四川省', '联通', '0', '2011-04-12', '1'), ('16496', '112.96.64.9', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16497', '112.64.188.150', '上海市', '联通', '0', '2011-04-12', '1'), ('16498', '122.194.0.187', '江苏省', '联通', '0', '2011-04-12', '1'), ('16499', '119.39.248.5', '湖南省', '联通', '0', '2011-04-12', '1'), ('16500', '118.212.191.105', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16501', '112.224.3.127', '山东省', '联通', '0', '2011-04-12', '1'), ('16502', '202.99.125.22', '天津市', '联通', '0', '2011-04-12', '1'), ('16503', '119.4.252.238', '四川省', '联通', '0', '2011-04-12', '1'), ('16504', '112.97.192.182', '广东省', '联通', '0', '2011-04-12', '1'), ('16505', '27.46.216.75', '广东省', '联通', '0', '2011-04-12', '1'), ('16506', '118.212.191.198', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16507', '119.39.248.4', '湖南省', '联通', '0', '2011-04-12', '1'), ('16508', '118.212.190.169', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16509', '221.11.61.99', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16510', '112.96.64.6', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16511', '27.46.143.93', '广东省', '联通', '0', '2011-04-12', '1'), ('16512', '119.39.249.102', '湖南省', '联通', '0', '2011-04-12', '1'), ('16513', '220.198.143.65', '广东省', '联通', '0', '2011-04-12', '1'), ('16514', '61.158.152.252', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16515', '119.4.252.237', '四川省', '联通', '0', '2011-04-12', '1'), ('16516', '119.4.252.195', '四川省', '联通', '0', '2011-04-12', '1'), ('16517', '122.194.3.206', '江苏省', '联通', '0', '2011-04-12', '1'), ('16518', '202.99.84.113', '天津市', '联通', '0', '2011-04-12', '1'), ('16519', '27.46.158.233', '广东省', '联通', '0', '2011-04-12', '1'), ('16520', '221.7.7.247', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16521', '221.11.61.78', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16522', '112.96.148.57', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16523', '58.242.98.214', '安徽省阜阳市', '联通', '0', '2011-04-12', '1'), ('16524', '118.212.172.173', '江西省', '联通', '0', '2011-04-12', '1'), ('16525', '58.248.193.36', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16526', '112.64.190.216', '上海市', '联通', '0', '2011-04-12', '1'), ('16527', '113.58.80.108', '海南省', '联通', '0', '2011-04-12', '1'), ('16528', '112.96.64.14', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16529', '218.67.199.162', '天津市', '联通', '0', '2011-04-12', '1'), ('16530', '119.39.249.100', '湖南省', '联通', '0', '2011-04-12', '1'), ('16531', '113.57.246.40', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16532', '118.212.172.174', '江西省', '联通', '0', '2011-04-12', '1'), ('16533', '58.243.254.121', '安徽省', '联通', '0', '2011-04-12', '1'), ('16534', '123.5.161.185', '河南省洛阳市', '联通', '0', '2011-04-12', '1'), ('16535', '122.194.3.222', '江苏省', '联通', '0', '2011-04-12', '1'), ('16536', '119.4.252.168', '四川省', '联通', '0', '2011-04-12', '1'), ('16537', '112.64.190.176', '上海市', '联通', '0', '2011-04-12', '1'), ('16538', '118.212.190.36', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16539', '112.224.3.105', '山东省', '联通', '0', '2011-04-12', '1'), ('16540', '113.57.244.72', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16541', '112.224.3.52', '山东省', '联通', '0', '2011-04-12', '1'), ('16542', '114.249.218.232', '北京市', '联通', '0', '2011-04-12', '1'), ('16543', '118.212.190.204', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16544', '218.26.158.12', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16545', '58.16.226.46', '贵州省', '联通', '0', '2011-04-12', '1'), ('16546', '58.22.113.126', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16547', '119.4.252.52', '四川省', '联通', '0', '2011-04-12', '1'), ('16548', '27.46.180.6', '广东省', '联通', '0', '2011-04-12', '1'), ('16549', '123.152.240.136', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('16550', '58.22.114.150', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16551', '58.22.113.134', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16552', '112.64.188.123', '上海市', '联通', '0', '2011-04-12', '1'), ('16553', '112.97.241.183', '广东省', '联通', '0', '2011-04-12', '1'), ('16554', '112.64.191.33', '上海市', '联通', '0', '2011-04-12', '1'), ('16555', '218.60.140.91', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16556', '112.224.3.17', '山东省', '联通', '0', '2011-04-12', '1'), ('16557', '118.212.190.129', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16558', '58.243.250.74', '安徽省', '联通', '0', '2011-04-12', '1'), ('16559', '124.160.209.60', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16560', '112.64.188.146', '上海市', '联通', '0', '2011-04-12', '1'), ('16561', '113.57.244.233', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16562', '61.158.152.179', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16563', '112.96.64.16', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16564', '58.251.132.240', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16565', '112.224.2.122', '山东省', '联通', '0', '2011-04-12', '1'), ('16566', '124.160.209.98', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16567', '112.96.64.22', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16568', '112.64.191.73', '上海市', '联通', '0', '2011-04-12', '1'), ('16569', '118.212.191.113', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16570', '221.194.30.127', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16571', '118.212.172.193', '江西省', '联通', '0', '2011-04-12', '1'), ('16572', '123.152.16.149', '浙江省宁波市', '联通', '0', '2011-04-12', '1'), ('16573', '220.199.236.130', '广东省', '联通', '0', '2011-04-12', '1'), ('16574', '119.4.252.61', '四川省', '联通', '0', '2011-04-12', '1'), ('16575', '112.64.190.171', '上海市', '联通', '0', '2011-04-12', '1'), ('16576', '119.39.249.72', '湖南省', '联通', '0', '2011-04-12', '1'), ('16577', '221.194.31.170', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16578', '112.96.64.21', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16579', '58.243.250.126', '安徽省', '联通', '0', '2011-04-12', '1'), ('16580', '221.194.30.158', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16581', '202.99.125.20', '天津市', '联通', '0', '2011-04-12', '1'), ('16582', '112.96.206.243', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16583', '124.160.208.35', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16584', '119.4.252.162', '四川省', '联通', '0', '2011-04-12', '1'), ('16585', '112.64.190.191', '上海市', '联通', '0', '2011-04-12', '1'), ('16586', '61.158.152.164', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16587', '119.62.127.207', '云南省', '联通', '0', '2011-04-12', '1'), ('16588', '211.96.115.73', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16589', '113.57.244.1', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16590', '113.57.244.195', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16591', '119.4.252.165', '四川省', '联通', '0', '2011-04-12', '1'), ('16592', '220.199.122.60', '广东省', '联通', '0', '2011-04-12', '1'), ('16593', '218.60.138.247', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16594', '112.224.2.41', '山东省', '联通', '0', '2011-04-12', '1'), ('16595', '220.199.34.98', '广东省', '联通', '0', '2011-04-12', '1'), ('16596', '220.198.176.241', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16597', '112.64.190.239', '上海市', '联通', '0', '2011-04-12', '1'), ('16598', '113.57.244.153', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16599', '122.194.1.130', '江苏省', '联通', '0', '2011-04-12', '1'), ('16600', '218.60.138.151', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16601', '112.224.3.111', '山东省', '联通', '0', '2011-04-12', '1'), ('16602', '58.243.250.1', '安徽省', '联通', '0', '2011-04-12', '1'), ('16603', '202.99.84.9', '天津市', '联通', '0', '2011-04-12', '1'), ('16604', '113.57.244.74', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16605', '119.39.249.33', '湖南省', '联通', '0', '2011-04-12', '1'), ('16606', '27.46.28.37', '广东省', '联通', '0', '2011-04-12', '1'), ('16607', '58.243.250.25', '安徽省', '联通', '0', '2011-04-12', '1'), ('16608', '112.96.254.23', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16609', '112.96.255.8', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16610', '113.57.244.241', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16611', '112.97.192.186', '广东省', '联通', '0', '2011-04-12', '1'), ('16612', '112.96.254.18', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16613', '58.254.169.105', '广东省', '联通', '0', '2011-04-12', '1'), ('16614', '119.4.252.173', '四川省', '联通', '0', '2011-04-12', '1'), ('16615', '110.228.254.148', '河北省', '联通', '0', '2011-04-12', '1'), ('16616', '119.4.252.167', '四川省', '联通', '0', '2011-04-12', '1'), ('16617', '125.39.52.166', '天津市', '联通', '0', '2011-04-12', '1'), ('16618', '58.16.226.11', '贵州省', '联通', '0', '2011-04-12', '1'), ('16619', '58.254.169.96', '广东省', '联通', '0', '2011-04-12', '1'), ('16620', '113.57.246.231', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16621', '118.212.171.80', '江西省', '联通', '0', '2011-04-12', '1'), ('16622', '218.60.140.42', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16623', '221.4.196.154', '广东省中山市', '联通', '0', '2011-04-12', '1'), ('16624', '122.194.0.36', '江苏省', '联通', '0', '2011-04-12', '1'), ('16625', '112.96.65.21', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16626', '112.96.254.24', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16627', '121.29.60.41', '河北省石家庄市', '联通', '0', '2011-04-12', '1'), ('16628', '112.97.86.224', '广东省', '联通', '0', '2011-04-12', '1'), ('16629', '122.194.1.14', '江苏省', '联通', '0', '2011-04-12', '1'), ('16630', '61.162.79.58', '山东省济宁市', '联通', '0', '2011-04-12', '1'), ('16631', '58.22.113.50', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16632', '112.64.191.48', '上海市', '联通', '0', '2011-04-12', '1'), ('16633', '58.22.114.56', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16634', '114.250.182.134', '北京市', '联通', '0', '2011-04-12', '1'), ('16635', '112.96.224.13', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16636', '112.96.65.24', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16637', '112.96.65.20', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16638', '119.62.127.72', '云南省', '联通', '0', '2011-04-12', '1'), ('16639', '119.4.252.138', '四川省', '联通', '0', '2011-04-12', '1'), ('16640', '58.16.226.96', '贵州省', '联通', '0', '2011-04-12', '1'), ('16641', '112.96.65.19', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16642', '112.64.191.47', '上海市', '联通', '0', '2011-04-12', '1'), ('16643', '112.96.65.17', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16644', '123.147.244.60', '重庆市', '联通', '0', '2011-04-12', '1'), ('16645', '113.58.72.170', '海南省', '联通', '0', '2011-04-12', '1'), ('16646', '218.60.140.217', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16647', '211.96.93.180', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16648', '112.96.128.15', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16649', '112.64.190.130', '上海市', '联通', '0', '2011-04-12', '1'), ('16650', '122.194.3.202', '江苏省', '联通', '0', '2011-04-12', '1'), ('16651', '119.4.252.123', '四川省', '联通', '0', '2011-04-12', '1'), ('16652', '58.243.250.51', '安徽省', '联通', '0', '2011-04-12', '1'), ('16653', '220.198.149.117', '广东省清远市', '联通', '0', '2011-04-12', '1'), ('16654', '113.57.246.137', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16655', '58.22.114.41', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16656', '221.11.61.237', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16657', '119.4.252.84', '四川省', '联通', '0', '2011-04-12', '1'), ('16658', '112.64.190.213', '上海市', '联通', '0', '2011-04-12', '1'), ('16659', '58.243.254.101', '安徽省', '联通', '0', '2011-04-12', '1'), ('16660', '119.4.252.18', '四川省', '联通', '0', '2011-04-12', '1'), ('16661', '112.64.188.112', '上海市', '联通', '0', '2011-04-12', '1'), ('16662', '112.96.64.7', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16663', '221.194.31.80', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16664', '112.96.65.22', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16665', '113.58.25.151', '海南省', '联通', '0', '2011-04-12', '1'), ('16666', '58.243.254.9', '安徽省', '联通', '0', '2011-04-12', '1'), ('16667', '119.4.252.135', '四川省', '联通', '0', '2011-04-12', '1'), ('16668', '61.158.152.85', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16669', '119.62.127.73', '云南省', '联通', '0', '2011-04-12', '1'), ('16670', '119.4.252.51', '四川省', '联通', '0', '2011-04-12', '1'), ('16671', '221.7.7.157', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16672', '220.199.129.232', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16673', '58.243.250.49', '安徽省', '联通', '0', '2011-04-12', '1'), ('16674', '218.67.203.187', '天津市', '联通', '0', '2011-04-12', '1'), ('16675', '122.194.3.113', '江苏省', '联通', '0', '2011-04-12', '1'), ('16676', '112.64.190.166', '上海市', '联通', '0', '2011-04-12', '1'), ('16677', '122.194.3.33', '江苏省', '联通', '0', '2011-04-12', '1'), ('16678', '119.39.249.2', '湖南省', '联通', '0', '2011-04-12', '1'), ('16679', '119.39.249.97', '湖南省', '联通', '0', '2011-04-12', '1'), ('16680', '218.60.138.196', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16681', '119.4.252.62', '四川省', '联通', '0', '2011-04-12', '1'), ('16682', '113.57.244.107', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16683', '122.194.1.179', '江苏省', '联通', '0', '2011-04-12', '1'), ('16684', '112.64.191.80', '上海市', '联通', '0', '2011-04-12', '1'), ('16685', '121.29.45.128', '河北省石家庄市', '联通', '0', '2011-04-12', '1'), ('16686', '118.212.191.154', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16687', '122.194.3.168', '江苏省', '联通', '0', '2011-04-12', '1'), ('16688', '112.96.255.4', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16689', '123.147.244.52', '重庆市', '联通', '0', '2011-04-12', '1'), ('16690', '58.244.234.22', '吉林省四平市', '联通', '0', '2011-04-12', '1'), ('16691', '119.4.252.233', '四川省', '联通', '0', '2011-04-12', '1'), ('16692', '221.7.7.136', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16693', '122.194.3.45', '江苏省', '联通', '0', '2011-04-12', '1'), ('16694', '115.85.238.165', '甘肃省', '联通', '0', '2011-04-12', '1'), ('16695', '112.96.128.13', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16696', '58.22.114.133', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16697', '58.22.114.189', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16698', '112.64.188.177', '上海市', '联通', '0', '2011-04-12', '1'), ('16699', '221.194.30.235', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16700', '58.22.113.146', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16701', '220.199.161.145', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16702', '119.4.252.14', '四川省', '联通', '0', '2011-04-12', '1'), ('16703', '116.113.84.235', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('16704', '112.97.174.235', '广东省', '联通', '0', '2011-04-12', '1'), ('16705', '218.26.158.3', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16706', '221.194.30.152', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16707', '112.96.108.225', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16708', '122.194.3.188', '江苏省', '联通', '0', '2011-04-12', '1'), ('16709', '122.194.2.15', '江苏省', '联通', '0', '2011-04-12', '1'), ('16710', '116.113.84.201', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('16711', '124.160.208.218', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16712', '221.194.31.231', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16713', '112.96.128.14', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16714', '112.96.224.12', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16715', '112.97.192.178', '广东省', '联通', '0', '2011-04-12', '1'), ('16716', '112.96.254.19', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16717', '221.11.61.118', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16718', '112.96.149.199', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16719', '58.243.254.45', '安徽省', '联通', '0', '2011-04-12', '1'), ('16720', '61.158.152.254', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16721', '112.64.190.208', '上海市', '联通', '0', '2011-04-12', '1'), ('16722', '218.60.141.39', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('16723', '58.243.254.65', '安徽省', '联通', '0', '2011-04-12', '1'), ('16724', '112.64.191.49', '上海市', '联通', '0', '2011-04-12', '1'), ('16725', '221.194.31.214', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16726', '119.4.252.140', '四川省', '联通', '0', '2011-04-12', '1'), ('16727', '121.31.254.114', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('16728', '58.22.114.144', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16729', '221.7.7.213', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16730', '112.64.188.204', '上海市', '联通', '0', '2011-04-12', '1'), ('16731', '112.96.224.10', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16732', '112.96.72.11', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16733', '110.254.30.132', '河北省承德市', '联通', '0', '2011-04-12', '1'), ('16734', '202.99.84.137', '天津市', '联通', '0', '2011-04-12', '1'), ('16735', '113.58.42.77', '海南省', '联通', '0', '2011-04-12', '1'), ('16736', '112.122.9.86', '安徽省合肥市', '联通', '0', '2011-04-12', '1'), ('16737', '58.22.113.173', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16738', '202.99.125.250', '天津市', '联通', '0', '2011-04-12', '1'), ('16739', '110.254.6.8', '河北省承德市', '联通', '0', '2011-04-12', '1'), ('16740', '122.194.3.101', '江苏省', '联通', '0', '2011-04-12', '1'), ('16741', '119.4.252.54', '四川省', '联通', '0', '2011-04-12', '1'), ('16742', '119.62.127.252', '云南省', '联通', '0', '2011-04-12', '1'), ('16743', '116.113.84.196', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('16744', '123.147.244.30', '重庆市', '联通', '0', '2011-04-12', '1'), ('16745', '110.229.195.208', '河北省', '联通', '0', '2011-04-12', '1'), ('16746', '112.64.188.209', '上海市', '联通', '0', '2011-04-12', '1'), ('16747', '221.7.7.173', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16748', '58.243.250.19', '安徽省', '联通', '0', '2011-04-12', '1'), ('16749', '220.199.180.27', '广东省', '联通', '0', '2011-04-12', '1'), ('16750', '113.58.32.39', '海南省', '联通', '0', '2011-04-12', '1'), ('16751', '124.160.209.194', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16752', '112.64.190.160', '上海市', '联通', '0', '2011-04-12', '1'), ('16753', '112.96.97.239', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16754', '220.199.156.238', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16755', '221.11.61.54', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16756', '123.147.244.37', '重庆市', '联通', '0', '2011-04-12', '1'), ('16757', '218.28.92.218', '河南省南阳市', '联通', '0', '2011-04-12', '1'), ('16758', '118.212.172.75', '江西省', '联通', '0', '2011-04-12', '1'), ('16759', '113.57.246.80', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16760', '112.96.128.9', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16761', '221.7.7.100', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16762', '112.97.233.231', '广东省', '联通', '0', '2011-04-12', '1'), ('16763', '119.4.252.124', '四川省', '联通', '0', '2011-04-12', '1'), ('16764', '118.212.191.25', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16765', '221.11.61.129', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16766', '112.64.190.168', '上海市', '联通', '0', '2011-04-12', '1'), ('16767', '124.160.209.154', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16768', '112.97.192.191', '广东省', '联通', '0', '2011-04-12', '1'), ('16769', '119.39.249.7', '湖南省', '联通', '0', '2011-04-12', '1'), ('16770', '119.4.252.75', '四川省', '联通', '0', '2011-04-12', '1'), ('16771', '123.148.23.159', '浙江省丽水市', '联通', '0', '2011-04-12', '1'), ('16772', '27.46.227.185', '广东省', '联通', '0', '2011-04-12', '1'), ('16773', '112.64.190.55', '上海市', '联通', '0', '2011-04-12', '1'), ('16774', '112.64.190.167', '上海市', '联通', '0', '2011-04-12', '1'), ('16775', '112.96.128.16', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16776', '118.212.171.148', '江西省', '联通', '0', '2011-04-12', '1'), ('16777', '218.60.141.199', '辽宁省营口市', '联通', '0', '2011-04-12', '1'), ('16778', '119.39.249.6', '湖南省', '联通', '0', '2011-04-12', '1'), ('16779', '122.194.1.62', '江苏省', '联通', '0', '2011-04-12', '1'), ('16780', '221.11.61.146', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16781', '221.7.7.253', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16782', '112.64.188.137', '上海市', '联通', '0', '2011-04-12', '1'), ('16783', '115.85.238.168', '甘肃省', '联通', '0', '2011-04-12', '1'), ('16784', '58.243.254.54', '安徽省', '联通', '0', '2011-04-12', '1'), ('16785', '218.60.138.232', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16786', '112.96.65.18', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16787', '122.194.2.130', '江苏省', '联通', '0', '2011-04-12', '1'), ('16788', '222.139.39.17', '河南省安阳市', '联通', '0', '2011-04-12', '1'), ('16789', '218.60.139.206', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16790', '202.99.84.115', '天津市', '联通', '0', '2011-04-12', '1'), ('16791', '221.194.30.173', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16792', '112.97.192.50', '广东省', '联通', '0', '2011-04-12', '1'), ('16793', '122.194.1.153', '江苏省', '联通', '0', '2011-04-12', '1'), ('16794', '112.96.224.14', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16795', '58.243.250.38', '安徽省', '联通', '0', '2011-04-12', '1'), ('16796', '124.160.209.83', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16797', '110.229.218.207', '河北省', '联通', '0', '2011-04-12', '1'), ('16798', '202.99.84.233', '天津市', '联通', '0', '2011-04-12', '1'), ('16799', '221.7.7.122', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16800', '115.85.238.167', '甘肃省', '联通', '0', '2011-04-12', '1'), ('16801', '112.64.190.227', '上海市', '联通', '0', '2011-04-12', '1'), ('16802', '119.4.252.179', '四川省', '联通', '0', '2011-04-12', '1'), ('16803', '221.11.61.34', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16804', '122.194.1.100', '江苏省', '联通', '0', '2011-04-12', '1'), ('16805', '112.90.142.210', '广东省', '联通', '0', '2011-04-12', '1'), ('16806', '112.90.142.209', '广东省', '联通', '0', '2011-04-12', '1'), ('16807', '113.57.244.22', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16808', '112.96.224.16', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16809', '58.16.226.54', '贵州省', '联通', '0', '2011-04-12', '1'), ('16810', '202.99.125.182', '天津市', '联通', '0', '2011-04-12', '1'), ('16811', '112.224.3.91', '山东省', '联通', '0', '2011-04-12', '1'), ('16812', '112.96.225.31', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16813', '119.39.248.48', '湖南省', '联通', '0', '2011-04-12', '1'), ('16814', '119.62.127.76', '云南省', '联通', '0', '2011-04-12', '1'), ('16815', '112.64.191.81', '上海市', '联通', '0', '2011-04-12', '1'), ('16816', '112.224.2.72', '山东省', '联通', '0', '2011-04-12', '1'), ('16817', '124.128.158.35', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16818', '61.158.152.9', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16819', '112.64.190.201', '上海市', '联通', '0', '2011-04-12', '1'), ('16820', '221.194.31.128', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16821', '124.128.255.146', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16822', '202.99.84.247', '天津市', '联通', '0', '2011-04-12', '1'), ('16823', '112.93.233.243', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('16824', '112.90.142.208', '广东省', '联通', '0', '2011-04-12', '1'), ('16825', '58.16.226.63', '贵州省', '联通', '0', '2011-04-12', '1'), ('16826', '119.4.252.234', '四川省', '联通', '0', '2011-04-12', '1'), ('16827', '202.99.125.164', '天津市', '联通', '0', '2011-04-12', '1'), ('16828', '112.96.224.15', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16829', '112.224.3.124', '山东省', '联通', '0', '2011-04-12', '1'), ('16830', '202.99.84.39', '天津市', '联通', '0', '2011-04-12', '1'), ('16831', '112.64.188.164', '上海市', '联通', '0', '2011-04-12', '1'), ('16832', '112.224.3.106', '山东省', '联通', '0', '2011-04-12', '1'), ('16833', '218.109.171.123', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('16834', '221.11.61.73', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16835', '113.58.90.65', '海南省', '联通', '0', '2011-04-12', '1'), ('16836', '119.180.160.151', '山东省', '联通', '0', '2011-04-12', '1'), ('16837', '122.194.3.91', '江苏省', '联通', '0', '2011-04-12', '1'), ('16838', '218.8.64.211', '黑龙江省哈尔滨市', '联通', '0', '2011-04-12', '1'), ('16839', '112.97.192.59', '广东省', '联通', '0', '2011-04-12', '1'), ('16840', '122.194.1.146', '江苏省', '联通', '0', '2011-04-12', '1'), ('16841', '122.194.3.95', '江苏省', '联通', '0', '2011-04-12', '1'), ('16842', '124.160.208.186', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16843', '113.58.67.101', '海南省', '联通', '0', '2011-04-12', '1'), ('16844', '113.5.0.126', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('16845', '202.99.125.46', '天津市', '联通', '0', '2011-04-12', '1'), ('16846', '218.60.138.107', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16847', '118.212.191.248', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16848', '218.58.228.98', '山东省枣庄市', '联通', '0', '2011-04-12', '1'), ('16849', '220.199.212.24', '广东省', '联通', '0', '2011-04-12', '1'), ('16850', '112.97.192.23', '广东省', '联通', '0', '2011-04-12', '1'), ('16851', '221.11.61.122', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16852', '119.4.252.11', '四川省', '联通', '0', '2011-04-12', '1'), ('16853', '122.194.1.28', '江苏省', '联通', '0', '2011-04-12', '1'), ('16854', '61.158.152.81', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16855', '112.97.192.62', '广东省', '联通', '0', '2011-04-12', '1'), ('16856', '202.99.84.221', '天津市', '联通', '0', '2011-04-12', '1'), ('16857', '112.96.128.12', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16858', '112.64.190.228', '上海市', '联通', '0', '2011-04-12', '1'), ('16859', '119.4.252.151', '四川省', '联通', '0', '2011-04-12', '1'), ('16860', '220.199.232.242', '广东省', '联通', '0', '2011-04-12', '1'), ('16861', '122.194.3.172', '江苏省', '联通', '0', '2011-04-12', '1'), ('16862', '113.57.246.211', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16863', '202.99.84.173', '天津市', '联通', '0', '2011-04-12', '1'), ('16864', '113.57.246.136', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16865', '115.85.238.166', '甘肃省', '联通', '0', '2011-04-12', '1'), ('16866', '119.39.249.40', '湖南省', '联通', '0', '2011-04-12', '1'), ('16867', '124.160.208.23', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16868', '218.60.138.200', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16869', '119.4.252.128', '四川省', '联通', '0', '2011-04-12', '1'), ('16870', '61.148.90.118', '北京市', '联通', '0', '2011-04-12', '1'), ('16871', '182.88.248.245', '广西自治区南宁市', '联通', '0', '2011-04-12', '1'), ('16872', '58.251.127.107', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16873', '202.99.84.1', '天津市', '联通', '0', '2011-04-12', '1'), ('16874', '218.60.139.200', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16875', '112.97.192.11', '广东省', '联通', '0', '2011-04-12', '1'), ('16876', '221.7.7.66', '新疆乌鲁木齐市', '联通', '0', '2011-04-12', '1'), ('16877', '58.251.126.221', '广东省深圳市', '联通', '0', '2011-04-12', '1'), ('16878', '122.194.3.205', '江苏省', '联通', '0', '2011-04-12', '1'), ('16879', '112.224.3.96', '山东省', '联通', '0', '2011-04-12', '1'), ('16880', '112.224.3.123', '山东省', '联通', '0', '2011-04-12', '1'), ('16881', '112.97.192.1', '广东省', '联通', '0', '2011-04-12', '1'), ('16882', '118.212.171.74', '江西省', '联通', '0', '2011-04-12', '1'), ('16883', '112.238.195.61', '山东省烟台市', '联通', '0', '2011-04-12', '1'), ('16884', '122.194.3.63', '江苏省', '联通', '0', '2011-04-12', '1'), ('16885', '218.60.139.229', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16886', '112.96.224.9', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16887', '202.99.125.252', '天津市', '联通', '0', '2011-04-12', '1'), ('16888', '112.64.188.163', '上海市', '联通', '0', '2011-04-12', '1'), ('16889', '58.22.114.6', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16890', '218.67.197.212', '天津市', '联通', '0', '2011-04-12', '1'), ('16891', '112.96.90.139', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16892', '122.194.1.152', '江苏省', '联通', '0', '2011-04-12', '1'), ('16893', '112.97.192.48', '广东省', '联通', '0', '2011-04-12', '1'), ('16894', '221.11.61.176', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16895', '202.99.125.70', '天津市', '联通', '0', '2011-04-12', '1'), ('16896', '112.96.64.4', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16897', '122.194.1.230', '江苏省', '联通', '0', '2011-04-12', '1'), ('16898', '221.11.61.48', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16899', '218.26.158.13', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16900', '122.194.2.219', '江苏省', '联通', '0', '2011-04-12', '1'), ('16901', '112.64.188.110', '上海市', '联通', '0', '2011-04-12', '1'), ('16902', '112.97.192.13', '广东省', '联通', '0', '2011-04-12', '1'), ('16903', '218.60.138.89', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16904', '118.212.171.139', '江西省', '联通', '0', '2011-04-12', '1'), ('16905', '119.4.252.9', '四川省', '联通', '0', '2011-04-12', '1'), ('16906', '220.199.170.77', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16907', '27.42.184.188', '广东省中山市', '联通', '0', '2011-04-12', '1'), ('16908', '119.162.38.210', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16909', '118.212.171.117', '江西省', '联通', '0', '2011-04-12', '1'), ('16910', '202.99.125.32', '天津市', '联通', '0', '2011-04-12', '1'), ('16911', '124.160.209.223', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16912', '112.96.255.5', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16913', '112.249.89.130', '山东省', '联通', '0', '2011-04-12', '1'), ('16914', '118.212.171.36', '江西省', '联通', '0', '2011-04-12', '1'), ('16915', '122.194.0.47', '江苏省', '联通', '0', '2011-04-12', '1'), ('16916', '112.96.225.32', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16917', '112.83.35.85', '江苏省', '联通', '0', '2011-04-12', '1'), ('16918', '61.158.152.126', '河南省濮阳市', '联通', '0', '2011-04-12', '1'), ('16919', '202.99.125.34', '天津市', '联通', '0', '2011-04-12', '1'), ('16920', '112.64.188.230', '上海市', '联通', '0', '2011-04-12', '1'), ('16921', '119.163.122.246', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16922', '122.194.2.139', '江苏省', '联通', '0', '2011-04-12', '1'), ('16923', '124.160.209.87', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16924', '122.194.3.37', '江苏省', '联通', '0', '2011-04-12', '1'), ('16925', '122.194.1.11', '江苏省', '联通', '0', '2011-04-12', '1'), ('16926', '218.26.158.5', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16927', '202.99.125.244', '天津市', '联通', '0', '2011-04-12', '1'), ('16928', '122.194.0.70', '江苏省', '联通', '0', '2011-04-12', '1'), ('16929', '118.212.171.244', '江西省', '联通', '0', '2011-04-12', '1'), ('16930', '58.16.226.111', '贵州省', '联通', '0', '2011-04-12', '1'), ('16931', '112.97.192.14', '广东省', '联通', '0', '2011-04-12', '1'), ('16932', '112.64.190.157', '上海市', '联通', '0', '2011-04-12', '1'), ('16933', '112.224.2.84', '山东省', '联通', '0', '2011-04-12', '1'), ('16934', '118.212.171.249', '江西省', '联通', '0', '2011-04-12', '1'), ('16935', '119.163.122.236', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16936', '112.97.192.47', '广东省', '联通', '0', '2011-04-12', '1'), ('16937', '118.212.171.183', '江西省', '联通', '0', '2011-04-12', '1'), ('16938', '221.11.61.179', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16939', '61.182.204.198', '河北省石家庄市', '联通', '0', '2011-04-12', '1'), ('16940', '221.11.61.92', '陕西省西安市', '联通', '0', '2011-04-12', '1'), ('16941', '112.96.129.25', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16942', '119.39.249.8', '湖南省', '联通', '0', '2011-04-12', '1'), ('16943', '58.100.115.42', '浙江省杭州市', '联通', '0', '2011-04-12', '1'), ('16944', '119.62.127.94', '云南省', '联通', '0', '2011-04-12', '1'), ('16945', '112.64.191.57', '上海市', '联通', '0', '2011-04-12', '1'), ('16946', '123.233.171.32', '山东省济南市', '联通', '0', '2011-04-12', '1'), ('16947', '58.248.7.187', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16948', '124.89.191.192', '浙江省', '联通', '0', '2011-04-12', '1'), ('16949', '112.64.188.222', '上海市', '联通', '0', '2011-04-12', '1'), ('16950', '124.160.209.105', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16951', '112.224.2.125', '山东省', '联通', '0', '2011-04-12', '1'), ('16952', '118.212.171.13', '江西省', '联通', '0', '2011-04-12', '1'), ('16953', '112.230.115.66', '山东省', '联通', '0', '2011-04-12', '1'), ('16954', '112.64.188.166', '上海市', '联通', '0', '2011-04-12', '1'), ('16955', '112.96.129.32', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16956', '124.89.190.234', '浙江省', '联通', '0', '2011-04-12', '1'), ('16957', '60.7.97.219', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16958', '118.212.191.197', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('16959', '60.10.20.101', '河北省廊坊市', '联通', '0', '2011-04-12', '1'), ('16960', '112.64.188.128', '上海市', '联通', '0', '2011-04-12', '1'), ('16961', '218.60.138.146', '辽宁省大连市', '联通', '0', '2011-04-12', '1'), ('16962', '112.194.55.1', '四川省绵阳市', '联通', '0', '2011-04-12', '1'), ('16963', '221.194.31.186', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16964', '122.194.2.36', '江苏省', '联通', '0', '2011-04-12', '1'), ('16965', '113.57.244.130', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16966', '58.243.254.103', '安徽省', '联通', '0', '2011-04-12', '1'), ('16967', '124.160.209.197', '浙江省嘉兴市', '联通', '0', '2011-04-12', '1'), ('16968', '221.194.30.137', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16969', '182.119.155.244', '河南省郑州市', '联通', '0', '2011-04-12', '1'), ('16970', '112.96.128.10', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16971', '112.96.177.235', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16972', '112.64.190.203', '上海市', '联通', '0', '2011-04-12', '1'), ('16973', '112.96.198.107', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16974', '112.97.192.12', '广东省', '联通', '0', '2011-04-12', '1'), ('16975', '112.64.191.72', '上海市', '联通', '0', '2011-04-12', '1'), ('16976', '221.194.31.219', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('16977', '113.57.246.140', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('16978', '58.248.121.144', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16979', '58.243.254.90', '安徽省', '联通', '0', '2011-04-12', '1'), ('16980', '112.224.2.94', '山东省', '联通', '0', '2011-04-12', '1'), ('16981', '112.64.190.149', '上海市', '联通', '0', '2011-04-12', '1'), ('16982', '121.31.251.2', '广西自治区贵港市', '联通', '0', '2011-04-12', '1'), ('16983', '112.97.192.38', '广东省', '联通', '0', '2011-04-12', '1'), ('16984', '122.194.2.241', '江苏省', '联通', '0', '2011-04-12', '1'), ('16985', '218.26.158.11', '山西省阳泉市', '联通', '0', '2011-04-12', '1'), ('16986', '112.96.225.26', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16987', '221.207.37.3', '青海省西宁市', '联通', '0', '2011-04-12', '1'), ('16988', '122.194.2.161', '江苏省', '联通', '0', '2011-04-12', '1'), ('16989', '58.22.114.179', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16990', '112.224.2.71', '山东省', '联通', '0', '2011-04-12', '1'), ('16991', '113.5.0.127', '黑龙江省', '联通', '0', '2011-04-12', '1'), ('16992', '112.96.64.1', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16993', '202.99.84.195', '天津市', '联通', '0', '2011-04-12', '1'), ('16994', '112.96.65.23', '广东省广州市', '联通', '0', '2011-04-12', '1'), ('16995', '112.96.129.29', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('16996', '112.64.188.201', '上海市', '联通', '0', '2011-04-12', '1'), ('16997', '220.249.173.234', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('16998', '112.111.51.212', '福建省', '联通', '0', '2011-04-12', '1'), ('16999', '58.253.94.51', '广东省东莞市', '联通', '0', '2011-04-12', '1'), ('17000', '221.194.30.67', '河北省秦皇岛市', '联通', '0', '2011-04-12', '1'), ('17001', '116.113.84.226', '内蒙古呼和浩特市', '联通', '0', '2011-04-12', '1'), ('17002', '58.22.113.141', '福建省福州市', '联通', '0', '2011-04-12', '1'), ('17003', '113.57.246.159', '湖北省武汉市', '联通', '0', '2011-04-12', '1'), ('17004', '124.162.128.54', '重庆市', '联通', '0', '2011-04-12', '1'), ('17005', '112.64.188.153', '上海市', '联通', '0', '2011-04-12', '1'), ('17006', '112.224.2.101', '山东省', '联通', '0', '2011-04-12', '1'), ('17007', '112.64.188.193', '上海市', '联通', '0', '2011-04-12', '1'), ('17008', '112.64.191.40', '上海市', '联通', '0', '2011-04-12', '1'), ('17009', '118.212.191.216', '江西省吉安市', '联通', '0', '2011-04-12', '1'), ('17010', '58.243.250.11', '安徽省', '联通', '0', '2011-04-12', '1'), ('17011', '112.96.128.11', '广东省佛山市', '联通', '0', '2011-04-12', '1'), ('17012', '123.146.62.212', '重庆市', '联通', '0', '2011-04-12', '1'), ('17013', '112.97.192.21', '广东省', '联通', '0', '2011-04-12', '1'), ('17014', '122.194.2.59', '江苏省', '联通', '0', '2011-04-12', '1'), ('17015', '112.224.3.38', '山东省', '联通', '0', '2011-04-12', '1'), ('17016', '112.122.9.132', '安徽省合肥市', '联通', '0', '2011-04-13', '1'), ('17017', '124.160.192.117', '浙江省嘉兴市', '联通', '0', '2011-04-13', '1'), ('17018', '123.147.128.34', '重庆市', '联通', '0', '2011-04-13', '1'), ('17019', '112.96.30.30', '广东省广州市', '联通', '0', '2011-04-13', '1'), ('17020', '220.195.15.230', '河北省石家庄市', '联通', '0', '2011-04-13', '1'), ('17021', '122.194.5.191', '江苏省', '联通', '0', '2011-04-13', '1'), ('17022', '61.158.153.244', '河南省安阳市', '联通', '0', '2011-04-13', '1'), ('17023', '211.94.128.22', '北京市', '联通', '0', '2011-04-13', '1'), ('17024', '112.97.30.1', '广东省', '联通', '0', '2011-04-13', '1'), ('17025', '118.212.186.57', '江西省吉安市', '联通', '0', '2011-04-13', '1'), ('17026', '61.139.151.142', '吉林省长春市', '联通', '0', '2011-04-13', '1'), ('17027', '211.90.87.217', '山西省太原市', '联通', '0', '2011-04-13', '1'), ('17028', '220.201.207.140', '黑龙江省哈尔滨市', '联通', '0', '2011-04-13', '1'), ('17029', '123.139.154.73', '陕西省', '联通', '0', '2011-04-13', '1'), ('17030', '112.96.28.7', '广东省广州市', '联通', '0', '2011-04-13', '1'), ('17031', '220.202.103.116', '湖南省长沙市', '联通', '0', '2011-04-13', '1'), ('17032', '113.57.255.1', '湖北省武汉市', '联通', '0', '2011-04-13', '1'), ('17033', '119.62.128.83', '云南省', '联通', '0', '2011-04-13', '1'), ('17034', '124.160.192.23', '浙江省嘉兴市', '联通', '0', '2011-04-13', '1'), ('17035', '221.11.44.41', '陕西省西安市', '联通', '0', '2011-04-13', '1'), ('17036', '112.122.9.90', '安徽省合肥市', '联通', '0', '2011-04-13', '1'), ('17037', '121.31.254.108', '广西自治区贵港市', '联通', '0', '2011-04-13', '1'), ('17038', '220.196.52.251', '上海市', '联通', '0', '2011-04-13', '1'), ('17039', '61.158.153.53', '河南省安阳市', '联通', '0', '2011-04-13', '1'), ('17040', '211.90.87.4', '山西省太原市', '联通', '0', '2011-04-13', '1'), ('17041', '60.13.126.150', '海南省', '联通', '0', '2011-04-13', '1'), ('17042', '221.13.79.31', '西藏拉萨市', '联通', '0', '2011-04-13', '1'), ('17043', '61.139.142.75', '吉林省长春市', '联通', '0', '2011-04-13', '1'), ('17044', '58.22.113.175', '福建省福州市', '联通', '0', '2011-04-13', '1'), ('17045', '124.160.209.91', '浙江省嘉兴市', '联通', '0', '2011-04-13', '1'), ('17046', '58.243.250.108', '安徽省', '联通', '0', '2011-04-13', '1'), ('17047', '118.212.191.129', '江西省吉安市', '联通', '0', '2011-04-13', '1'), ('17048', '61.181.22.119', '天津市', '联通', '0', '2011-04-13', '1'), ('17049', '112.231.65.248', '山东省', '联通', '0', '2011-04-13', '1'), ('17050', '112.231.65.249', '山东省', '联通', '0', '2011-04-13', '1'), ('17051', '58.22.116.148', '福建省福州市', '联通', '0', '2011-04-13', '1'), ('17052', '125.39.173.181', '天津市', '联通', '0', '2011-04-13', '1'), ('17053', '112.96.28.23', '广东省广州市', '联通', '0', '2011-04-13', '1'), ('17054', '58.249.63.9', '广东省广州市', '联通', '0', '2011-04-13', '1'), ('17055', '211.139.60.51', '重庆市', '移动', '0', '2011-04-13', '1'), ('17056', '113.57.246.84', '湖北省武汉市', '联通', '0', '2011-04-13', '1'), ('17057', '211.139.60.54', '重庆市', '移动', '0', '2011-04-13', '1'), ('17058', '112.64.188.211', '上海市', '联通', '0', '2011-04-13', '1'), ('17059', '123.121.216.58', '北京市', '联通', '0', '2011-04-13', '1'), ('17060', '112.4.12.90', '江苏省', '移动', '0', '2011-04-13', '1'), ('17061', '218.26.158.25', '山西省阳泉市', '联通', '0', '2011-04-13', '1'), ('17062', '211.139.60.52', '重庆市', '移动', '0', '2011-04-13', '1'), ('17063', '122.194.0.178', '江苏省', '联通', '0', '2011-04-13', '1'), ('17064', '60.212.34.62', '山东省烟台市', '联通', '0', '2011-04-13', '1'), ('17065', '211.139.60.53', '重庆市', '移动', '0', '2011-04-13', '1'), ('17066', '58.22.114.5', '福建省福州市', '联通', '0', '2011-04-13', '1'), ('17067', '113.58.113.27', '海南省', '联通', '0', '2011-04-13', '1'), ('17068', '113.58.28.119', '海南省', '联通', '0', '2011-04-13', '1'), ('17069', '113.58.117.66', '海南省', '联通', '0', '2011-04-13', '1'), ('17070', '221.11.61.220', '陕西省西安市', '联通', '0', '2011-04-13', '1'), ('17071', '58.22.113.102', '福建省福州市', '联通', '0', '2011-04-13', '1'), ('17072', '117.136.17.61', '中国', '移动', '0', '2011-04-13', '1'), ('17073', '113.58.59.42', '海南省', '联通', '0', '2011-04-14', '1'), ('17074', '117.136.19.124', '中国', '移动', '0', '2011-04-14', '1'), ('17075', '112.96.225.29', '广东省佛山市', '联通', '0', '2011-04-14', '1'), ('17076', '58.243.254.81', '安徽省', '联通', '0', '2011-04-14', '1'), ('17077', '117.136.16.120', '中国', '移动', '0', '2011-04-14', '1'), ('17078', '117.136.16.107', '中国', '移动', '0', '2011-04-14', '1'), ('17079', '113.58.35.229', '海南省', '联通', '0', '2011-04-14', '1'), ('17080', '61.158.152.75', '河南省濮阳市', '联通', '0', '2011-04-14', '1'), ('17081', '117.136.14.86', '中国', '移动', '0', '2011-04-14', '1'), ('17082', '113.58.85.157', '海南省', '联通', '0', '2011-04-14', '1'), ('17083', '112.64.188.190', '上海市', '联通', '0', '2011-04-14', '1'), ('17084', '112.97.192.28', '广东省', '联通', '0', '2011-04-14', '1'), ('17085', '113.57.246.175', '湖北省武汉市', '联通', '0', '2011-04-14', '1'), ('17086', '58.22.113.192', '福建省福州市', '联通', '0', '2011-04-14', '1'), ('17087', '117.136.14.89', '中国', '移动', '0', '2011-04-14', '1'), ('17088', '58.22.114.182', '福建省福州市', '联通', '0', '2011-04-14', '1'), ('17089', '124.160.208.14', '浙江省嘉兴市', '联通', '0', '2011-04-14', '1'), ('17090', '221.194.30.190', '河北省秦皇岛市', '联通', '0', '2011-04-14', '1'), ('17091', '124.160.209.164', '浙江省嘉兴市', '联通', '0', '2011-04-14', '1'), ('17092', '117.139.103.149', '中国', '移动', '0', '2011-04-14', '1'), ('17093', '112.90.142.207', '广东省', '联通', '0', '2011-04-14', '1'), ('17094', '117.136.14.84', '中国', '移动', '0', '2011-04-15', '1'), ('17095', '112.64.188.165', '上海市', '联通', '0', '2011-04-15', '1'), ('17096', '124.160.209.153', '浙江省嘉兴市', '联通', '0', '2011-04-15', '1'), ('17097', '124.160.208.22', '浙江省嘉兴市', '联通', '0', '2011-04-15', '1'), ('17098', '124.160.209.20', '浙江省嘉兴市', '联通', '0', '2011-04-15', '1'), ('17099', '113.57.246.172', '湖北省武汉市', '联通', '0', '2011-04-15', '1'), ('17100', '117.136.9.143', '山东省潍坊市', '移动', '0', '2011-04-15', '1'), ('17101', '112.96.64.33', '广东省广州市', '联通', '0', '2011-04-15', '1'), ('17102', '118.212.171.45', '江西省', '联通', '0', '2011-04-15', '1'), ('17103', '124.160.209.94', '浙江省嘉兴市', '联通', '0', '2011-04-15', '1'), ('17104', '117.136.14.83', '中国', '移动', '0', '2011-04-15', '1'), ('17105', '124.160.208.122', '浙江省嘉兴市', '联通', '0', '2011-04-15', '1'), ('17106', '124.160.208.9', '浙江省嘉兴市', '联通', '0', '2011-04-15', '1'), ('17107', '58.22.113.6', '福建省福州市', '联通', '0', '2011-04-15', '1'), ('17108', '122.194.1.200', '江苏省', '联通', '0', '2011-04-15', '1'), ('17109', '122.194.2.92', '江苏省', '联通', '0', '2011-04-16', '1'), ('17110', '113.57.244.158', '湖北省武汉市', '联通', '0', '2011-04-16', '1'), ('17111', '221.11.61.42', '陕西省西安市', '联通', '0', '2011-04-16', '1'), ('17112', '124.160.208.216', '浙江省嘉兴市', '联通', '0', '2011-04-16', '1'), ('17113', '113.57.246.54', '湖北省武汉市', '联通', '0', '2011-04-16', '1'), ('17114', '119.4.252.190', '四川省', '联通', '0', '2011-04-16', '1'), ('17115', '119.4.252.79', '四川省', '联通', '0', '2011-04-16', '1'), ('17116', '124.128.255.143', '山东省济南市', '联通', '0', '2011-04-16', '1'), ('17117', '221.194.30.188', '河北省秦皇岛市', '联通', '0', '2011-04-16', '1'), ('17118', '27.40.227.216', '广东省', '联通', '0', '2011-04-16', '1'), ('17119', '123.233.193.84', '山东省济南市', '联通', '0', '2011-04-16', '1'), ('17120', '118.212.191.122', '江西省吉安市', '联通', '0', '2011-04-16', '1'), ('17121', '119.4.252.68', '四川省', '联通', '0', '2011-04-16', '1'), ('17122', '112.97.192.4', '广东省', '联通', '0', '2011-04-16', '1'), ('17123', '58.22.114.7', '福建省福州市', '联通', '0', '2011-04-16', '1'), ('17124', '122.194.2.185', '江苏省', '联通', '0', '2011-04-16', '1'), ('17125', '124.160.209.227', '浙江省嘉兴市', '联通', '0', '2011-04-16', '1'), ('17126', '117.136.16.109', '中国', '移动', '0', '2011-04-16', '1'), ('17127', '117.136.6.67', '辽宁省本溪市', '移动', '0', '2011-04-16', '1'), ('17128', '117.136.14.81', '中国', '移动', '0', '2011-04-17', '1'), ('17129', '117.136.14.80', '中国', '移动', '0', '2011-04-17', '1'), ('17130', '112.224.3.21', '山东省', '联通', '0', '2011-04-17', '1'), ('17131', '122.194.0.183', '江苏省', '联通', '0', '2011-04-17', '1'), ('17132', '58.22.113.172', '福建省福州市', '联通', '0', '2011-04-17', '1'), ('17133', '119.4.252.107', '四川省', '联通', '0', '2011-04-17', '1'), ('17134', '112.64.191.66', '上海市', '联通', '0', '2011-04-17', '1'), ('17135', '113.57.244.120', '湖北省武汉市', '联通', '0', '2011-04-17', '1'), ('17136', '115.63.78.63', '河南省信阳市', '联通', '0', '2011-04-17', '1'), ('17137', '118.212.171.198', '江西省', '联通', '0', '2011-04-17', '1'), ('17138', '117.136.9.152', '山东省潍坊市', '移动', '0', '2011-04-17', '1'), ('17139', '119.4.252.19', '四川省', '联通', '0', '2011-04-17', '1'), ('17140', '58.22.114.145', '福建省福州市', '联通', '0', '2011-04-17', '1'), ('17141', '218.60.138.24', '辽宁省大连市', '联通', '0', '2011-04-17', '1'), ('17142', '123.152.232.206', '浙江省宁波市', '联通', '0', '2011-04-17', '1'), ('17143', '119.4.252.240', '四川省', '联通', '0', '2011-04-17', '1'), ('17144', '112.96.225.30', '广东省佛山市', '联通', '0', '2011-04-17', '1'), ('17145', '119.39.248.44', '湖南省', '联通', '0', '2011-04-17', '1'), ('17146', '112.64.191.34', '上海市', '联通', '0', '2011-04-17', '1'), ('17147', '112.224.2.93', '山东省', '联通', '0', '2011-04-17', '1'), ('17148', '58.22.113.40', '福建省福州市', '联通', '0', '2011-04-19', '1'), ('17149', '113.58.47.119', '海南省', '联通', '0', '2011-04-19', '1'), ('17150', '112.64.188.224', '上海市', '联通', '0', '2011-04-19', '1'), ('17151', '124.160.209.219', '浙江省嘉兴市', '联通', '0', '2011-04-19', '1'), ('17152', '58.243.250.102', '安徽省', '联通', '0', '2011-04-19', '1'), ('17153', '117.136.16.118', '中国', '移动', '0', '2011-04-19', '1'), ('17154', '58.22.114.37', '福建省福州市', '联通', '0', '2011-04-19', '1'), ('17155', '112.96.254.17', '广东省佛山市', '联通', '0', '2011-04-19', '1'), ('17156', '117.136.16.114', '中国', '移动', '0', '2011-04-19', '1'), ('17157', '117.136.16.106', '中国', '移动', '0', '2011-04-19', '1'), ('17158', '117.136.19.84', '中国', '移动', '0', '2011-04-19', '1'), ('17159', '119.4.252.63', '四川省', '联通', '0', '2011-04-19', '1'), ('17160', '221.11.61.203', '陕西省西安市', '联通', '0', '2011-04-19', '1'), ('17161', '117.136.19.116', '中国', '移动', '0', '2011-04-19', '1'), ('17162', '114.247.10.81', '北京市', '联通', '0', '2011-04-19', '1'), ('17163', '220.250.15.221', '福建省福州市', '联通', '0', '2011-04-19', '1'), ('17164', '112.97.192.29', '广东省', '联通', '0', '2011-04-19', '1'), ('17165', '117.136.9.229', '山东省潍坊市', '移动', '0', '2011-04-19', '1'), ('17166', '115.63.74.139', '河南省信阳市', '联通', '0', '2011-04-19', '1'), ('17167', '58.22.113.168', '福建省福州市', '联通', '0', '2011-04-19', '1'), ('17168', '119.4.252.102', '四川省', '联通', '0', '2011-04-19', '1'), ('17169', '122.194.1.84', '江苏省', '联通', '0', '2011-04-19', '1'), ('17170', '124.160.209.175', '浙江省嘉兴市', '联通', '0', '2011-04-19', '1'), ('17171', '112.96.225.28', '广东省佛山市', '联通', '0', '2011-04-19', '1'), ('17172', '124.160.209.46', '浙江省嘉兴市', '联通', '0', '2011-04-19', '1'), ('17173', '58.243.254.108', '安徽省', '联通', '0', '2011-04-19', '1'), ('17174', '58.243.254.83', '安徽省', '联通', '0', '2011-04-19', '1'), ('17175', '122.194.3.214', '江苏省', '联通', '0', '2011-04-19', '1'), ('17176', '58.248.127.14', '广东省广州市', '联通', '0', '2011-04-19', '1'), ('17177', '221.11.61.30', '陕西省西安市', '联通', '0', '2011-04-19', '1'), ('17178', '221.194.30.110', '河北省秦皇岛市', '联通', '0', '2011-04-19', '1'), ('17179', '112.96.128.46', '广东省佛山市', '联通', '0', '2011-04-19', '1'), ('17180', '117.136.24.80', '中国', '移动', '0', '2011-04-19', '1'), ('17181', '221.194.30.98', '河北省秦皇岛市', '联通', '0', '2011-04-19', '1'), ('17182', '218.60.141.114', '辽宁省营口市', '联通', '0', '2011-04-19', '1'), ('17183', '58.22.114.151', '福建省福州市', '联通', '0', '2011-04-19', '1'), ('17184', '122.194.0.229', '江苏省', '联通', '0', '2011-04-19', '1'), ('17185', '117.136.31.206', '中国', '移动', '0', '2011-04-19', '1'), ('17186', '124.160.208.119', '浙江省嘉兴市', '联通', '0', '2011-04-20', '1'), ('17187', '112.97.192.49', '广东省', '联通', '0', '2011-04-20', '1'), ('17188', '124.160.209.203', '浙江省嘉兴市', '联通', '0', '2011-04-20', '1'), ('17189', '58.243.250.3', '安徽省', '联通', '0', '2011-04-20', '1'), ('17190', '58.22.113.119', '福建省福州市', '联通', '0', '2011-04-20', '1'), ('17191', '120.196.55.109', '广东省', '移动', '0', '2011-04-20', '1'), ('17192', '211.141.23.24', '中国', '移动', '0', '2011-04-20', '1'), ('17193', '61.158.152.170', '河南省濮阳市', '联通', '0', '2011-04-20', '1'), ('17194', '182.88.109.127', '广西自治区南宁市', '联通', '0', '2011-04-20', '1'), ('17195', '61.158.152.181', '河南省濮阳市', '联通', '0', '2011-04-20', '1'), ('17196', '113.58.140.95', '海南省', '联通', '0', '2011-04-20', '1'), ('17197', '124.160.209.79', '浙江省嘉兴市', '联通', '0', '2011-04-20', '1'), ('17198', '61.158.152.102', '河南省濮阳市', '联通', '0', '2011-04-20', '1'), ('17199', '112.96.225.25', '广东省佛山市', '联通', '0', '2011-04-20', '1'), ('17200', '113.58.37.11', '海南省', '联通', '0', '2011-04-20', '1'), ('17201', '113.58.80.255', '海南省', '联通', '0', '2011-04-20', '1'), ('17202', '113.58.96.83', '海南省', '联通', '0', '2011-04-20', '1'), ('17203', '58.22.114.27', '福建省福州市', '联通', '0', '2011-04-20', '1'), ('17204', '124.89.188.95', '浙江省', '联通', '0', '2011-04-20', '1'), ('17205', '122.194.0.207', '江苏省', '联通', '0', '2011-04-20', '1'), ('17206', '112.96.128.47', '广东省佛山市', '联通', '0', '2011-04-20', '1'), ('17207', '112.93.233.72', '广东省东莞市', '联通', '0', '2011-04-20', '1'), ('17208', '125.39.173.182', '天津市', '联通', '0', '2011-04-21', '1'), ('17209', '218.26.158.19', '山西省阳泉市', '联通', '0', '2011-04-21', '1'), ('17210', '124.160.208.190', '浙江省嘉兴市', '联通', '0', '2011-04-21', '1'), ('17211', '124.160.209.112', '浙江省嘉兴市', '联通', '0', '2011-04-21', '1'), ('17212', '124.160.208.99', '浙江省嘉兴市', '联通', '0', '2011-04-21', '1'), ('17213', '123.139.155.18', '陕西省', '联通', '0', '2011-04-21', '1'), ('17214', '112.64.188.195', '上海市', '联通', '0', '2011-04-21', '1'), ('17215', '58.16.81.13', '贵州省贵阳市', '联通', '0', '2011-04-21', '1'), ('17216', '122.194.3.230', '江苏省', '联通', '0', '2011-04-21', '1'), ('17217', '112.96.128.45', '广东省佛山市', '联通', '0', '2011-04-21', '1'), ('17218', '112.97.192.25', '广东省', '联通', '0', '2011-04-21', '1'), ('17219', '221.11.61.157', '陕西省西安市', '联通', '0', '2011-04-21', '1'), ('17220', '124.160.209.52', '浙江省嘉兴市', '联通', '0', '2011-04-21', '1'), ('17221', '221.11.61.53', '陕西省西安市', '联通', '0', '2011-04-21', '1'), ('17222', '113.58.70.105', '海南省', '联通', '0', '2011-04-21', '1'), ('17223', '112.97.192.9', '广东省', '联通', '0', '2011-04-21', '1'), ('17224', '58.22.114.30', '福建省福州市', '联通', '0', '2011-04-21', '1'), ('17225', '218.60.140.230', '辽宁省大连市', '联通', '0', '2011-04-22', '1'), ('17226', '124.160.209.8', '浙江省嘉兴市', '联通', '0', '2011-04-22', '1'), ('17227', '124.160.209.114', '浙江省嘉兴市', '联通', '0', '2011-04-22', '1'), ('17228', '112.64.190.226', '上海市', '联通', '0', '2011-04-22', '1'), ('17229', '118.212.171.173', '江西省', '联通', '0', '2011-04-22', '1');
INSERT INTO `ig_gateway` VALUES ('17230', '122.194.0.246', '江苏省', '联通', '0', '2011-04-22', '1'), ('17231', '122.194.0.196', '江苏省', '联通', '0', '2011-04-22', '1'), ('17232', '112.96.128.43', '广东省佛山市', '联通', '0', '2011-04-22', '1'), ('17233', '112.96.224.11', '广东省佛山市', '联通', '0', '2011-04-22', '1'), ('17234', '117.136.17.62', '中国', '移动', '0', '2011-04-22', '1'), ('17235', '182.88.98.25', '广西自治区南宁市', '联通', '0', '2011-04-22', '1'), ('17236', '58.22.113.87', '福建省福州市', '联通', '0', '2011-04-22', '1'), ('17237', '112.97.192.6', '广东省', '联通', '0', '2011-04-22', '1'), ('17238', '221.11.61.248', '陕西省西安市', '联通', '0', '2011-04-22', '1'), ('17239', '112.96.225.27', '广东省佛山市', '联通', '0', '2011-04-22', '1'), ('17240', '61.158.152.137', '河南省濮阳市', '联通', '0', '2011-04-22', '1'), ('17241', '124.160.96.232', '浙江省温州市', '联通', '0', '2011-04-23', '1'), ('17242', '122.194.2.97', '江苏省', '联通', '0', '2011-04-23', '1'), ('17243', '117.136.24.78', '中国', '移动', '0', '2011-04-23', '1'), ('17244', '117.136.19.122', '中国', '移动', '0', '2011-04-23', '1'), ('17245', '58.22.113.130', '福建省福州市', '联通', '0', '2011-04-23', '1'), ('17246', '124.160.209.145', '浙江省嘉兴市', '联通', '0', '2011-04-23', '1'), ('17247', '124.160.209.146', '浙江省嘉兴市', '联通', '0', '2011-04-23', '1'), ('17248', '112.96.129.31', '广东省佛山市', '联通', '0', '2011-04-23', '1'), ('17249', '1.26.8.214', '内蒙古', '联通', '0', '2011-04-23', '1'), ('17250', '112.64.188.104', '上海市', '联通', '0', '2011-04-23', '1'), ('17251', '117.136.14.82', '中国', '移动', '0', '2011-04-23', '1'), ('17252', '58.253.157.112', '广东省揭阳市', '联通', '0', '2011-04-23', '1'), ('17253', '211.137.170.19', '天津市', '移动', '0', '2011-04-23', '1'), ('17254', '221.11.61.151', '陕西省西安市', '联通', '0', '2011-04-23', '1'), ('17255', '113.58.76.103', '海南省', '联通', '0', '2011-04-24', '1'), ('17256', '124.160.208.17', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17257', '124.160.209.204', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17258', '124.160.208.80', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17259', '124.160.208.27', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17260', '124.160.208.31', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17261', '124.160.209.242', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17262', '124.160.208.42', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17263', '124.160.209.239', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17264', '124.160.209.129', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17265', '124.160.208.94', '浙江省嘉兴市', '联通', '0', '2011-04-24', '1'), ('17266', '112.97.192.17', '广东省', '联通', '0', '2011-04-24', '1'), ('17267', '117.136.9.132', '山东省潍坊市', '移动', '0', '2011-04-24', '1'), ('17268', '122.194.3.150', '江苏省', '联通', '0', '2011-04-24', '1'), ('17269', '119.4.252.210', '四川省', '联通', '0', '2011-04-24', '1'), ('17270', '120.196.55.3', '广东省', '移动', '0', '2011-04-24', '1'), ('17271', '112.96.254.20', '广东省佛山市', '联通', '0', '2011-04-24', '1'), ('17272', '58.22.113.165', '福建省福州市', '联通', '0', '2011-04-24', '1'), ('17273', '119.39.248.22', '湖南省', '联通', '0', '2011-04-24', '1'), ('17274', '112.96.254.21', '广东省佛山市', '联通', '0', '2011-04-24', '1'), ('17275', '113.57.244.243', '湖北省武汉市', '联通', '0', '2011-04-25', '1'), ('17276', '119.4.252.95', '四川省', '联通', '0', '2011-04-25', '1'), ('17277', '117.136.19.112', '中国', '移动', '0', '2011-04-25', '1'), ('17278', '124.160.208.180', '浙江省嘉兴市', '联通', '0', '2011-04-25', '1'), ('17279', '122.194.1.221', '江苏省', '联通', '0', '2011-04-25', '1'), ('17280', '112.96.129.30', '广东省佛山市', '联通', '0', '2011-04-25', '1'), ('17281', '124.160.208.36', '浙江省嘉兴市', '联通', '0', '2011-04-25', '1'), ('17282', '119.4.252.217', '四川省', '联通', '0', '2011-04-25', '1'), ('17283', '58.243.250.29', '安徽省', '联通', '0', '2011-04-26', '1'), ('17285', '117.136.4.16', '辽宁省本溪市', '移动', '0', '2011-04-26', '1'), ('17286', '122.194.0.119', '江苏省', '联通', '0', '2011-04-26', '1'), ('17287', '124.90.241.192', '浙江省金华市', '联通', '0', '2011-04-26', '1'), ('17288', '118.212.171.50', '江西省', '联通', '0', '2011-04-26', '1'), ('17289', '124.90.8.22', '浙江省杭州市', '联通', '0', '2011-04-26', '1'), ('17290', '221.193.216.236', '河北省邯郸市', '联通', '0', '2011-04-26', '1'), ('17291', '112.64.190.183', '上海市', '联通', '0', '2011-04-26', '1'), ('17292', '112.3.254.72', '中国', '移动', '0', '2011-04-26', '1'), ('17293', '119.4.252.117', '四川省', '联通', '0', '2011-04-26', '1'), ('17294', '58.22.114.73', '福建省福州市', '联通', '0', '2011-04-26', '1'), ('17295', '58.22.113.53', '福建省福州市', '联通', '0', '2011-04-26', '1'), ('17296', '58.22.113.199', '福建省福州市', '联通', '0', '2011-04-26', '1'), ('17297', '118.212.171.169', '江西省', '联通', '0', '2011-04-27', '1'), ('17298', '122.194.3.145', '江苏省', '联通', '0', '2011-04-27', '1'), ('17299', '112.97.192.40', '广东省', '联通', '0', '2011-04-27', '1'), ('17300', '124.160.209.73', '浙江省嘉兴市', '联通', '0', '2011-04-27', '1'), ('17301', '58.248.124.55', '广东省广州市', '联通', '0', '2011-04-27', '1'), ('17302', '112.96.128.48', '广东省佛山市', '联通', '0', '2011-04-27', '1'), ('17303', '58.22.113.183', '福建省福州市', '联通', '0', '2011-04-27', '1'), ('17304', '119.4.252.16', '四川省', '联通', '0', '2011-04-27', '1'), ('17305', '182.88.110.179', '广西自治区南宁市', '联通', '0', '2011-04-27', '1'), ('17306', '58.22.114.187', '福建省福州市', '联通', '0', '2011-04-27', '1'), ('17307', '112.97.192.36', '广东省', '联通', '0', '2011-04-27', '1'), ('17308', '122.194.3.154', '江苏省', '联通', '0', '2011-04-27', '1'), ('17309', '112.64.190.222', '上海市', '联通', '0', '2011-04-28', '1'), ('17310', '218.206.254.181', '河南省', '移动', '0', '2011-04-28', '1'), ('17311', '122.194.0.96', '江苏省', '联通', '0', '2011-04-28', '1'), ('17312', '113.57.244.47', '湖北省武汉市', '联通', '0', '2011-04-28', '1'), ('17313', '122.194.3.100', '江苏省', '联通', '0', '2011-04-28', '1'), ('17314', '122.194.0.254', '江苏省', '联通', '0', '2011-04-28', '1'), ('17315', '122.194.2.102', '江苏省', '联通', '0', '2011-04-28', '1'), ('17316', '122.194.3.51', '江苏省', '联通', '0', '2011-04-28', '1'), ('17317', '122.194.2.12', '江苏省', '联通', '0', '2011-04-28', '1'), ('17318', '113.57.246.221', '湖北省武汉市', '联通', '0', '2011-04-28', '1'), ('17319', '218.206.254.163', '河南省', '移动', '0', '2011-04-28', '1'), ('17320', '218.206.254.183', '河南省', '移动', '0', '2011-04-28', '1'), ('17321', '218.206.254.168', '河南省', '移动', '0', '2011-04-28', '1'), ('17322', '113.58.112.200', '海南省', '联通', '0', '2011-04-28', '1'), ('17323', '117.136.24.200', '中国', '移动', '0', '2011-04-28', '1'), ('17324', '118.212.171.102', '江西省', '联通', '0', '2011-04-28', '1'), ('17325', '119.4.252.230', '四川省', '联通', '0', '2011-04-28', '1'), ('17326', '122.194.3.210', '江苏省', '联通', '0', '2011-04-28', '1'), ('17327', '221.194.30.51', '河北省秦皇岛市', '联通', '0', '2011-04-28', '1'), ('17328', '119.4.252.150', '四川省', '联通', '0', '2011-04-28', '1'), ('17329', '124.160.209.29', '浙江省嘉兴市', '联通', '0', '2011-04-28', '1'), ('17330', '122.194.2.64', '江苏省', '联通', '0', '2011-04-28', '1'), ('17331', '112.97.192.3', '广东省', '联通', '0', '2011-04-28', '1'), ('17332', '112.80.168.186', '江苏省南京市', '联通', '0', '2011-04-28', '1'), ('17333', '122.194.3.96', '江苏省', '联通', '0', '2011-04-28', '1'), ('17334', '122.194.0.59', '江苏省', '联通', '0', '2011-04-28', '1'), ('17335', '218.60.140.167', '辽宁省大连市', '联通', '0', '2011-04-28', '1'), ('17336', '182.88.143.13', '广西自治区南宁市', '联通', '0', '2011-04-28', '1'), ('17337', '124.89.155.189', '浙江省', '联通', '0', '2011-04-28', '1'), ('17338', '112.249.88.35', '山东省', '联通', '0', '2011-04-29', '1'), ('17339', '118.212.187.129', '江西省吉安市', '联通', '0', '2011-04-29', '1'), ('17340', '118.212.171.214', '江西省', '联通', '0', '2011-04-29', '1'), ('17341', '122.194.3.193', '江苏省', '联通', '0', '2011-04-29', '1'), ('17342', '113.57.246.9', '湖北省武汉市', '联通', '0', '2011-04-29', '1'), ('17343', '111.15.50.173', '中国', '移动', '0', '2011-04-29', '1'), ('17344', '112.97.192.52', '广东省', '联通', '0', '2011-04-29', '1'), ('17345', '221.11.61.171', '陕西省西安市', '联通', '0', '2011-04-29', '1'), ('17346', '113.57.246.76', '湖北省武汉市', '联通', '0', '2011-04-29', '1'), ('17347', '113.57.244.78', '湖北省武汉市', '联通', '0', '2011-04-29', '1'), ('17348', '202.99.125.136', '天津市', '联通', '0', '2011-04-29', '1'), ('17349', '112.96.129.27', '广东省佛山市', '联通', '0', '2011-04-29', '1'), ('17350', '218.26.158.8', '山西省阳泉市', '联通', '0', '2011-04-29', '1'), ('17351', '117.136.31.201', '中国', '移动', '0', '2011-04-29', '1'), ('17352', '218.60.139.19', '辽宁省大连市', '联通', '0', '2011-04-29', '1'), ('17353', '113.57.246.35', '湖北省武汉市', '联通', '0', '2011-04-29', '1'), ('17354', '112.96.128.44', '广东省佛山市', '联通', '0', '2011-04-29', '1'), ('17355', '124.160.208.67', '浙江省嘉兴市', '联通', '0', '2011-04-29', '1'), ('17356', '122.194.0.46', '江苏省', '联通', '0', '2011-04-29', '1'), ('17357', '112.3.254.32', '中国', '移动', '0', '2011-04-29', '1'), ('17358', '58.22.113.135', '福建省福州市', '联通', '0', '2011-04-29', '1'), ('17359', '112.97.192.19', '广东省', '联通', '0', '2011-04-29', '1'), ('17360', '112.97.192.45', '广东省', '联通', '0', '2011-04-29', '1'), ('17361', '115.63.109.242', '河南省信阳市', '联通', '0', '2011-04-30', '1'), ('17362', '119.4.252.1', '四川省', '联通', '0', '2011-04-30', '1'), ('17363', '117.136.31.155', '中国', '移动', '0', '2011-04-30', '1'), ('17364', '117.136.19.83', '中国', '移动', '0', '2011-04-30', '1'), ('17365', '118.212.191.33', '江西省吉安市', '联通', '0', '2011-04-30', '1'), ('17366', '122.194.2.244', '江苏省', '联通', '0', '2011-04-30', '1'), ('17367', '117.136.31.159', '中国', '移动', '0', '2011-04-30', '1'), ('17368', '117.136.31.147', '中国', '移动', '0', '2011-04-30', '1'), ('17369', '112.224.3.119', '山东省', '联通', '0', '2011-04-30', '1'), ('17370', '182.119.159.152', '河南省郑州市', '联通', '0', '2011-04-30', '1'), ('17371', '112.3.254.97', '中国', '移动', '0', '2011-04-30', '1'), ('17372', '124.160.208.73', '浙江省嘉兴市', '联通', '0', '2011-04-30', '1'), ('17373', '61.158.152.31', '河南省濮阳市', '联通', '0', '2011-04-30', '1'), ('17374', '119.62.127.190', '云南省', '联通', '0', '2011-04-30', '1'), ('17375', '119.4.252.100', '四川省', '联通', '0', '2011-04-30', '1'), ('17376', '124.160.208.11', '浙江省嘉兴市', '联通', '0', '2011-04-30', '1'), ('17377', '112.97.192.61', '广东省', '联通', '0', '2011-04-30', '1'), ('17378', '221.194.31.206', '河北省秦皇岛市', '联通', '0', '2011-04-30', '1'), ('17379', '58.22.113.125', '福建省福州市', '联通', '0', '2011-04-30', '1'), ('17380', '182.88.108.138', '广西自治区南宁市', '联通', '0', '2011-04-30', '1'), ('17381', '58.22.114.35', '福建省福州市', '联通', '0', '2011-04-30', '1'), ('17382', '113.57.250.106', '湖北省武汉市', '联通', '0', '2011-04-30', '1'), ('17383', '218.206.254.166', '河南省', '移动', '0', '2011-05-01', '1'), ('17384', '112.80.168.141', '江苏省南京市', '联通', '0', '2011-05-01', '1'), ('17385', '221.9.247.20', '吉林省长春市', '联通', '0', '2011-05-01', '1'), ('17386', '124.160.208.10', '浙江省嘉兴市', '联通', '0', '2011-05-01', '1'), ('17387', '211.141.23.19', '中国', '移动', '0', '2011-05-01', '1'), ('17388', '122.194.2.10', '江苏省', '联通', '0', '2011-05-01', '1'), ('17389', '27.42.148.139', '广东省中山市', '联通', '0', '2011-05-01', '1'), ('17390', '112.97.192.34', '广东省', '联通', '0', '2011-05-01', '1'), ('17391', '60.24.7.244', '天津市', '联通', '0', '2011-05-01', '1'), ('17392', '121.31.17.75', '广西自治区南宁市', '联通', '0', '2011-05-01', '1'), ('17393', '58.22.113.181', '福建省福州市', '联通', '0', '2011-05-01', '1'), ('17394', '117.136.1.124', '中国', '移动', '0', '2011-05-01', '1'), ('17395', '218.206.254.176', '河南省', '移动', '0', '2011-05-02', '1'), ('17396', '218.206.254.172', '河南省', '移动', '0', '2011-05-02', '1'), ('17397', '122.194.3.180', '江苏省', '联通', '0', '2011-05-02', '1'), ('17398', '122.194.0.113', '江苏省', '联通', '0', '2011-05-02', '1'), ('17399', '218.206.254.162', '河南省', '移动', '0', '2011-05-02', '1'), ('17400', '117.136.26.3', '中国', '移动', '0', '2011-05-02', '1'), ('17401', '122.194.2.128', '江苏省', '联通', '0', '2011-05-02', '1'), ('17402', '61.158.152.244', '河南省濮阳市', '联通', '0', '2011-05-02', '1'), ('17403', '119.4.252.251', '四川省', '联通', '0', '2011-05-02', '1'), ('17404', '124.160.209.251', '浙江省嘉兴市', '联通', '0', '2011-05-02', '1'), ('17405', '218.206.254.177', '河南省', '移动', '0', '2011-05-02', '1'), ('17406', '221.194.31.99', '河北省秦皇岛市', '联通', '0', '2011-05-02', '1'), ('17407', '122.194.2.248', '江苏省', '联通', '0', '2011-05-02', '1'), ('17408', '113.57.246.36', '湖北省武汉市', '联通', '0', '2011-05-03', '1'), ('17409', '113.58.93.231', '海南省', '联通', '0', '2011-05-03', '1'), ('17410', '112.64.188.226', '上海市', '联通', '0', '2011-05-03', '1'), ('17411', '221.11.61.182', '陕西省西安市', '联通', '0', '2011-05-03', '1'), ('17412', '122.194.2.240', '江苏省', '联通', '0', '2011-05-03', '1'), ('17413', '58.243.254.99', '安徽省', '联通', '0', '2011-05-03', '1'), ('17414', '119.4.252.181', '四川省', '联通', '0', '2011-05-03', '1'), ('17415', '61.158.152.71', '河南省濮阳市', '联通', '0', '2011-05-03', '1'), ('17416', '124.160.208.237', '浙江省嘉兴市', '联通', '0', '2011-05-03', '1'), ('17417', '122.194.3.134', '江苏省', '联通', '0', '2011-05-03', '1'), ('17418', '124.160.209.186', '浙江省嘉兴市', '联通', '0', '2011-05-03', '1'), ('17419', '119.4.252.7', '四川省', '联通', '0', '2011-05-03', '1'), ('17420', '112.97.192.27', '广东省', '联通', '0', '2011-05-03', '1'), ('17421', '218.26.158.24', '山西省阳泉市', '联通', '0', '2011-05-03', '1'), ('17422', '221.182.2.177', '四川省成都市', '移动', '0', '2011-05-03', '1'), ('17423', '118.212.190.133', '江西省吉安市', '联通', '0', '2011-05-03', '1'), ('17424', '118.212.171.56', '江西省', '联通', '0', '2011-05-03', '1'), ('17425', '113.57.244.142', '湖北省武汉市', '联通', '0', '2011-05-03', '1'), ('17426', '119.115.236.158', '辽宁省', '联通', '0', '2011-05-03', '1'), ('17427', '123.15.229.254', '河南省新乡市', '联通', '0', '2011-05-03', '1'), ('17428', '58.22.114.181', '福建省福州市', '联通', '0', '2011-05-03', '1'), ('17429', '58.22.113.33', '福建省福州市', '联通', '0', '2011-05-03', '1'), ('17430', '221.194.30.120', '河北省秦皇岛市', '联通', '0', '2011-05-04', '1'), ('17431', '122.194.2.227', '江苏省', '联通', '0', '2011-05-04', '1'), ('17432', '221.11.61.236', '陕西省西安市', '联通', '0', '2011-05-04', '1'), ('17433', '221.11.61.60', '陕西省西安市', '联通', '0', '2011-05-04', '1'), ('17434', '58.241.75.54', '江苏省常州市', '联通', '0', '2011-05-04', '1'), ('17435', '58.243.254.113', '安徽省', '联通', '0', '2011-05-04', '1'), ('17436', '218.60.138.230', '辽宁省大连市', '联通', '0', '2011-05-04', '1'), ('17437', '218.206.254.156', '河南省', '移动', '0', '2011-05-04', '1'), ('17438', '124.160.208.98', '浙江省嘉兴市', '联通', '0', '2011-05-04', '1'), ('17439', '122.194.0.189', '江苏省', '联通', '0', '2011-05-04', '1'), ('17440', '112.224.3.48', '山东省', '联通', '0', '2011-05-04', '1'), ('17441', '182.88.183.158', '广西自治区南宁市', '联通', '0', '2011-05-04', '1'), ('17442', '119.4.252.45', '四川省', '联通', '0', '2011-05-04', '1'), ('17443', '118.212.191.241', '江西省吉安市', '联通', '0', '2011-05-04', '1'), ('17444', '118.212.191.37', '江西省吉安市', '联通', '0', '2011-05-04', '1'), ('17445', '119.4.252.160', '四川省', '联通', '0', '2011-05-04', '1'), ('17446', '119.4.252.6', '四川省', '联通', '0', '2011-05-04', '1'), ('17447', '113.57.244.228', '湖北省武汉市', '联通', '0', '2011-05-04', '1'), ('17448', '119.4.252.116', '四川省', '联通', '0', '2011-05-04', '1'), ('17449', '61.158.152.78', '河南省濮阳市', '联通', '0', '2011-05-04', '1'), ('17450', '218.60.141.79', '辽宁省营口市', '联通', '0', '2011-05-05', '1'), ('17451', '119.4.252.131', '四川省', '联通', '0', '2011-05-05', '1'), ('17452', '118.212.171.20', '江西省', '联通', '0', '2011-05-05', '1'), ('17453', '221.194.30.52',