<?php
/**
 * Feed存储MongoDB实现
 * User: yzxh24
 * Date: 11-8-13
 * Time: 下午4:21
 * To change this template use File | Settings | File Templates.
 */
require_once 'FAbstract.php';
class FMongo extends FAbstract
{
    /**
     * @var MongoCollection
     */
    private $_collect = null;

    public $condition = array();

    public function __construct()
    {
        $mongo = new Mongo();
        $mdb = $mongo->selectDB('book');
        $this->_collect = $mdb->selectCollection('feed');
    }

    /**
     * @return MongoCollection
     */
    public function getCollect()
    {
        return $this->_collect;
    }

    /**
     * 创建一条feed
     * @param string $feed
     * @param int $uid
     * @return void|int
     */
    public function create($feed, $uid, $type = 'bbs')
    {
        // admin的动态不记录
        if (isGM($uid))
        {
            return;
        }

        $feed = preg_replace('/st=\d/i', '', $feed);
        $feed = preg_replace('/ruid=\d+/i', '', $feed);
        $feed = filter_content('{{time='.CTIME.'}}'.preg_replace('/st=\d/i', '', sFilter($feed)));
        $insert = array(
            'uid' => intval($uid),
            'feed' => $feed,
            'createdate' => CDATETIME,
            'type' => $type,
        );
        $this->getCollect()->insert($insert);
        $this->setOneCache($feed);

        return $insert['id'];
    }

    public function condition($condition = array())
    {
        if (array() === $condition)
        {
            $this->condition = array();
            return $this;
        }

        $query = array();
        foreach ($condition as $key => $value)
        {
            if (is_array($value))
            {
                if ('in' == $value[2])
                {
                    $query[$value[0]] = array('$in' => $value[1]);
                }
                else
                {
                    $query[$value[0]] = $value[1];
                }
            }
            else
            {
                $query[$key] = $value;
            }
        }
        //print_r($query);die;

        $this->condition = $query;

        return $this;
    }

    public function count()
    {
        return $this->getCollect()->count($this->condition);
    }

    public function findAll($fields = '*', $sort = array(), $offset = 0, $limit = 10)
    {
        $fields = '*' == $fields ? array() : $fields;
        $cursor = $this->getCollect()->find($this->condition, $fields);
        if (array() !== $sort)
        {
            $cursor->sort($sort);
        }
        $cursor->skip($offset);
        $cursor->limit($limit);
        $feeds = array();
        while ($cursor->hasNext())
        {
            $feeds[] = $cursor->getNext();
        }

        if (array() !== $feeds)
        {
            foreach ($feeds as &$feed)
            {
                $feed['feed'] = $this->analyzeFeed($feed['feed']);
            }
        }

        return $feeds;
    }

    /**
     * 获取一组UID的动态
     * @param array $uids
     * @return mixed
     */
    public function getFeedsByUids($uids = array())
    {
        $uidList = array();
        if (array() !== $uids)
        {
            foreach ($uids as $uid)
            {
                $uidList[] = (int)$uid;
            }
        }

        $condition[] = array('uid', $uidList, 'in');
        $feeds = $this->condition($condition)->findAll(array(), array('createdate'=>-1), 0, 5);

        return $feeds;
    }

    /**
     * 获取最新的feed
     * @param int $num
     * @return array
     */
    public function getNews($num = 1)
    {
        $cursor = $this->getCollect()->find();
        $cursor->sort(array('createdate'=>-1));
        $result = $cursor->limit($num);

        $feeds = array();
        while ($result->hasNext())
        {
            $feeds[] = $result->getNext();
        }
        if (array() === $feeds)
        {
            return false;
        }

        foreach ($feeds as &$feed)
        {
            $feed['feed'] = $this->analyzeFeed($feed['feed'], true);
        }

        return $feeds;
    }

    /**
     * 获取一条最新的feed
     * @return
     * @return false|string
     */
    public function getOneCache($br = true)
    {
        $feed = $GLOBALS['cache']->get($this->cacheKey());
        if (false === $feed)
        {
            $cursor = $this->getCollect()->find(array(), array('feed'))->sort(array('createdate'=>-1))->limit(1);
            $cursor->next();
            $feeds = $cursor->current();
            $feed = $feeds['feed'];
            if (empty($feed))
            {
                return false;
            }
            $this->setOneCache($feed);
        }

        return $this->analyzeFeed($feed) . ($br ? '<br/>' : '');
    }
}
