<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class iDownload
{
    private $_file = null;
    private $_fileName = null;
    
    public function __construct($file, $fileName)
    {
        $this->_file = $file;
        $this->_fileName = $fileName;
    }
    
    public function getClass()
    {
        $ext = fileext($this->getFile());
        switch ($ext)
        {
            case 'jpg':
            case 'png':
            case 'gif':
            case 'jpeg':
            case 'bmp':
                return 'Image';
                break;
            case 'jar':
                return 'Jar';
            case 'jad':
                return 'Jad';
            case 'sis':
            case 'sisx':
                return 'Sis';
            default:
                return 'Generic';
        }
    }

    public function send()
    {
        $class = $this->getClass();
        $obj = new $class($this->getFile(), $this->getFileName());
        $obj->send();
    }
    
    public function getFile()
    {
        return $this->_file;
    }
    
    public function getFileName()
    {
        return $this->_fileName;
    }
}

abstract class iFile
{
    private $_file;
    
    private $_fileName;
    
    private $_fileSize;
    
    private $_ext;
    
    private $_fileType;
    
    public function __construct($file, $fileName)
    {
        $this->_file = $file;
        $this->_fileName = $fileName;
        $this->_checkFile();
    }
    
    public function getFile()
    {
        return $this->_file;
    }
    
    public function getFileName()
    {
        return $this->_fileName;
    }
    
    public function getFileSize()
    {
        return $this->_fileSize;
    }
    
    public function getFileExt()
    {
        return $this->_ext;
    }
    
    private function _checkFile()
    {
        $file = $this->getFile();
        $this->_fileSize = filesize($file);
        $this->_ext = fileext($file);
    }
    
    public function getFileType()
    {
        return getFileType($this->getFileExt(), 'application/octet-stream');
    }
    
    public function send()
    {
        header('Cache-control: max-age=86400');
        header('Content-Encoding: none');
        header("Content-Disposition: attachment; filename=\"{$this->getFileName()}\"");
        header("Content-type: {$this->getFileType()}");
        header("Content-Transfer-Encoding: binary");
        header("Content-Length: {$this->getFileSize()}");
        readfile($this->getFile());
    } 
}

class Generic extends iFile
{
    public function send()
    {
        parent::send();
    }
}

class Image extends iFile
{
    public function send()
    {
        parent::send();
    }
}

class Jar extends iFile
{
    public function send()
    {
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header('Content-Description: File Transfer');
        header('Content-Type: application/java-archive');
        header('Content-Disposition: attachment; filename="'.$this->getFileName().'"');
        header('Content-Transfer-Encoding: binary');
		readfile($this->getFile());
        exit(0);
    }
}

class Jad extends iFile
{
    public function send()
    {
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Content-Description: File Transfer');
		header('Content-Type: text/vnd.sun.j2me.app-descriptor');
		header('Content-Disposition: attachment; filename="'.$this->getFileName().'"');
		header('Content-Transfer-Encoding: binary');
		readfile($this->getFile());
        exit(0);
    }
}

class Sis extends iFile
{
    public function send()
    {
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header('Content-Description: File Transfer');
        header('Content-Type: '.$this->getFileType());
        header('Content-Disposition: attachment; filename="'.$this->getFileName().'"');
        header("Content-Transfer-Encoding: binary");
		readfile($this->getFile());
        exit(0);
    }
}