<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
require_once 'feed/FMySQL.php';
require_once 'feed/FMongo.php';

class iFeed
{
    /**
     * @var FAbstract
     */
    private $_storage = null;
    
    private function __construct()
    {
        $this->setStorage(new FMySQL());
        //$this->setStorage(new FMongo());
    }

    public function setStorage(FAbstract $storage)
    {
        $this->_storage = $storage;
    }

    public function  getStorage()
    {
        return $this->_storage;
    }

    public function single()
    {
        static $_self = null;
        if (is_null($_self))
        {
            $_self = new self();
        }
        
        return $_self;
    }

    public function condition($conditions)
    {
        $this->getStorage()->condition($conditions);

        return $this;
    }

    public function findAll($fields = '*', $sort = array(), $offset = 0, $limit = 10)
    {
        return $this->getStorage()->findAll($fields, $sort, $offset, $limit);
    }

    public function count()
    {
        return $this->getStorage()->count();
    }

    public function create($feed, $uid, $type = 'bbs')
    {
        if (setting('isfeed'))
        {
            $this->getStorage()->create($feed, $uid, $type);
        }
    }

    public function setOneCache($feed)
    {
        $this->getStorage()->setOneCache($feed);
    }

    public function getOneCache($br = true)
    {
        return $this->getStorage()->getOneCache($br);
    }

    public function time2Units($end, $start = null)
    {
        return time2Units($end, $start);
    }

    public function getNews($num = 1)
    {
        return $this->getStorage()->getNews($num);
    }

    public function getFeedsByUids($uids)
    {
        return $this->getStorage()->getFeedsByUids($uids);
    }

    public function analyzeFeed($feed, $time = false)
    {
        return $this->getStorage()->analyzeFeed($feed, $time);
    }
}