<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class iHtml
{
    public static function select($name, $select, $data, $htmlOptions=array())
    {
        $htmlOptions['name'] = $name;
		if(!isset($htmlOptions['id']))
		{
			$htmlOptions['id'] = self::getIdByName($name);
		}
		else if($htmlOptions['id'] === false)
		{
			unset($htmlOptions['id']);
		}
		
		$options = array();
		foreach ($data as $key => $value)
		{
		    $options[] = "<option value='".$key."'".($key == $select ? ' selected' : '').">{$value}</option>";
		}
		
		return "<select name='".$name."'>".implode("<br/>", $options)."</select>";
    }
    
    public static function monthSelect($name, $select, $htmlOptions=array())
    {
        $array = array(
            '00' => '月份',
            '01' => '1月',
            '02' => '2月',
            '03' => '3月',
            '04' => '4月',
            '05' => '5月',
            '06' => '6月',
            '07' => '7月',
            '08' => '8月',
            '09' => '9月',
        	'10' => '10月',
            '11' => '11月',
            '12' => '12月',
        );
        
        return self::select($name, $select, $array, $htmlOptions);
    }
    
    public static function dateSelect($name, $select, $htmlOptions = array())
    {
        $array = array(
            '00' => '日期',
            '01' => '01日',
            '02' => '02日',
            '03' => '03日',
            '04' => '04日',
            '05' => '05日',
            '06' => '06日',
            '07' => '07日',
            '08' => '08日',
            '09' => '09日',
            '10' => '10日',
            '11' => '11日',
            '12' => '12日',
            '13' => '13日',
            '14' => '14日',
            '15' => '15日',
            '16' => '16日',
            '17' => '17日',
            '18' => '18日',
            '19' => '19日',
            '20' => '20日',
            '21' => '21日',
            '22' => '22日',
            '23' => '23日',
            '24' => '24日',
            '25' => '25日',
            '26' => '26日',
            '27' => '27日',
            '28' => '28日',
            '29' => '29日',
            '30' => '30日',
            '31' => '31日',
        );
        
        return self::select($name, $select, $array, $htmlOptions);
    }
    
    public static function cssFile($url, $media='')
	{
		if($media!=='')
		{
			$media=' media="'.$media.'"';
		}
		
		return '<link rel="stylesheet" type="text/css" href="'.self::encode($url).'"'.$media.' />';
	}
	
    public static function css($text, $media='')
	{
		if($media!=='')
		{
			$media=' media="'.$media.'"';
		}
		
		return "<style type=\"text/css\"{$media}>\n/*<![CDATA[*/\n{$text}\n/*]]>*/\n</style>";
	}
	
    public static function encode($text)
	{
		return htmlspecialchars($text, ENT_QUOTES, 'utf-8');
	}
	
    public static function getIdByName($name)
	{
		return str_replace(array('[]', '][', '[', ']'), array('', '_', '_', ''), $name);
	}
	
    public static function tag($tag,$htmlOptions=array(),$content=false,$closeTag=true)
	{
		$html='<' . $tag . self::renderAttributes($htmlOptions);
		if($content===false)
		{
			return $closeTag ? $html.' />' : $html.'>';
		}
		else
		{
			return $closeTag ? $html.'>'.$content.'</'.$tag.'>' : $html.'>'.$content;
		}
	}
	
    protected static function renderAttributes($htmlOptions)
	{
		if($htmlOptions===array())
		{
			return '';
		}
		$html='';
		$raw = isset($htmlOptions['encode']) && !$htmlOptions['encode'];
		unset($htmlOptions['encode']);
		if($raw)
		{
			foreach($htmlOptions as $name=>$value)
			{
				$html .= ' ' . $name . '="' . $value . '"';
			}
		}
		else
		{
			foreach($htmlOptions as $name=>$value)
			{
				$html .= ' ' . $name . '="' . self::encode($value) . '"';
			}
		}
		
		return $html;
	}
}