<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class iLoginForm
{
    protected $obj;

    private function __construct()
    {
        if (isWapRequest())
        {
            $this->obj = new WapLoginForm();
        }
        else
        {
            $this->obj = new GenericLoginForm();
        }
    }

    public static function getInstance()
    {
        static $_obj = null;
        if (is_null($_obj))
        {
            $_obj = new self();
        }

        return $_obj;
    }

    public function header()
    {
        $this->obj->header();
    }

    public function footer()
    {
        echo ilink('忘记密码', url('mmback')).'|'.ilink('验证会员', url('verify')).'|'.ilink('免费注册', url('system', array('s'=>'member','a'=>'register'))) . '<br/>';
        if (isWapRequest() && isViewAd())
        {
            echo "【精彩内容不容错过】<br/>";
            echo randAd();
            echo randAd();
            echo randAd();
            echo randAd();
            echo randAd();
        }
        $this->obj->footer();
    }

    public function content()
    {
        $this->obj->content();
    }
}

abstract class BaseLoginForm
{
    abstract function header();
    abstract function footer();
    abstract function content();
    public function tips()
    {
        return '<b>[提示]</b>
        <br/>
        登录后将首页保存为书签，以后每次从此书签进网站就不再需要登陆了。
        <br/>
        隐身登录后你的状态将显示为“离线”，每次需消耗100'.setting('creditname').'，直到当前访问退出前都有效。';
    }
}
class GenericLoginForm extends BaseLoginForm
{
    public function header()
    {
        $title = '登录提示';
        include_once tpl('globalHeader');
    }

    public function footer()
    {
        include_once tpl('globalFooter');
    }

    public function content()
    {
        $loginUrl = url('system',array('s'=>'member','a'=>'login'));
        $tips = $this->tips();
        echo <<<EOT
        <br/>
<form action="{$loginUrl}" method="post">
    手机号码:
    <br/>
    <input type="text" format="*N" name="mobile" title="输入手机号" value="" maxlength="20"/>
    <br/>
    登录密码:
    <br/>
    <input type="password" name="password" title="输入密码" value="" maxlength="100"/>
    <br/>
    <input type="radio" name="hidden" value="0" checked="checked" />正常 <input type="radio" name="hidden" value="1" />隐身
    <br/>
    <input type="submit" value="立即登录" />
    </form>
    <div class="block">
        {$tips}
    </div>
EOT;
    }
}

class WapLoginForm extends BaseLoginForm
{
    public function header()
    {
        include_once tpl('header');
        echo <<<EOT
<card title="登录提示">
<p align="left">
EOT;

    }

    public function footer()
    {
        include_once tpl('footer');
    }

    public function content()
    {
        $tips = $this->tips();
        $adContent = '';
        $loginUrl = url('system',array('s'=>'member','a'=>'login'));
        echo <<<EOT
        <br/>
    手机号码:
    <br/>
    <input type="text" format="*N" name="mobile" title="输入手机号" value="" maxlength="20"/>
    <br/>
    登录密码:
    <br/>
    <input type="text" name="password" title="输入密码" value="" maxlength="100"/>
    <br/>
    <anchor title="正常登录">正常登录
    <go method="post" href="{$loginUrl}">
    <postfield name="mobile" value="$(mobile)"/>
    <postfield name="password" value="$(password)"/>
    <postfield name="hidden" value="0"/>
    </go>
    </anchor>|<anchor title="隐身登录">隐身登录
    <go method="post" href="{$loginUrl}">
    <postfield name="mobile" value="$(mobile)"/>
    <postfield name="password" value="$(password)"/>
    <postfield name="hidden" value="1"/>
    </go>
    </anchor>
    <br/>
    {$tips}
    <br/>
EOT;
    }
}