<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class iMedals
{
    private static $_self = null;

    private static $_mdealCache = array();

    private function  __construct()
    {
        $medalList = require ROOT_PATH . 'cache/bbs/medals.php';
        self::$_mdealCache = $medalList;
    }

    public static function single()
    {
        if (is_null(self::$_self))
        {
            self::$_self = new self();
        }
        return self::$_self;
    }
    
    public function getOne($medalId)
    {
        return self::$_mdealCache[$medalId];
    }

    public static function getMedalsString($medals)
    {
        $data = array();
        foreach($medals = explode("\t", $medals) as $key => $medalid)
        {
            list($medalid, $medalexpiration) = explode("|", $medalid);
            if(self::medalExists($medalid) && (!$medalexpiration || $medalexpiration > CTIME))
            {
                $m = self::getMedal($medalid);
                $data['images'][] = '<img src="'. self::getImage($m['image']) . '" alt="'.$m['title'].'"/>';
                $data['honors'][] = self::$_mdealCache[$medalid]['name'] . ' ';
            }
        }

        return empty($data) ? false : $data;
    }

    public static function getMedal($id)
    {
        return array('image' => self::$_mdealCache[$id]['image'], 'title' => self::$_mdealCache[$id]['name']);
    }

    public static function getImage($image)
    {
        return getImageFile('bbs/medals/' . $image, false);
    }

    public static function medalExists($medalId)
    {
        return isset(self::$_mdealCache[$medalId]) ? true : false;
    }
}