<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class iPage
{
    private $_baseUrl = '';
    private $_currentPage;
    private $_pageSize = 5;
    private $_totalRecord;

    public function  __construct()
    {
        $this->_baseUrl = str_replace('&','&amp;', preg_replace('/&page=([0-9]+)/', '', $_SERVER['REQUEST_URI']));
        $this->_currentPage = max(1, intval($_GET['page']));
    }
    
    public function show($showLast = true)
    {
        $pagitation = '';
        if ($this->getCurrentPage() > 0)
        {
            if ($this->getCurrentPage() <= 1)
            {
                $pagitation .= '';
            }
            else
            {
                $showLast && $pagitation .= ilink('&lt;&lt;', $this->getUrl('page', 1));
                $pagitation .= ilink('上页', $this->getUrl('page', $this->getCurrentPage()-1));
            }
        }

        $totalPage = $this->getTotalPage();
        if (1 >= $totalPage)
        {
            return;
        }

        $tmp = '';
        for ($i = ($this->getCurrentPage() - 2); $i < ($this->getCurrentPage() + 3) && $i <= $totalPage; $i++)
        {
            if ($i > 0)
            {
                if ($this->getCurrentPage() == $i)
                {
                    $tmp .= $i . ' ';
                }
                else 
                {
                    $tmp .= ilink(' ' . $i . ' ', $this->getUrl('page', $i));
                }
            }
            $pageTmp = $tmp . ' ';
        }

        if (!empty($pageTmp))
        {
            $pagitation .= $pageTmp;
        }

        if ($this->getTotalRecord())
        {
            if ($this->getCurrentPage() >= $totalPage)
            {
                $pagitation .= '';
            }
            else
            {
                $pagitation .= ilink('下页', $this->getUrl('page', $this->getCurrentPage() + 1));
                $showLast && $pagitation .= ilink('&gt;&gt;', $this->getUrl('page', $this->getTotalPage()));
            }
        }

        return $pagitation;
    }

    public function getUrl($key, $value)
    {
         return $this->getBaseUrl() . ((false === strpos($this->getBaseUrl(), '?')) ? '?' : '&amp;') . $key.'='.$value;
    }

    public function getOffset()
    {
        return ($this->getCurrentPage() - 1) * $this->getPageSize();
    }

    public function getFloor()
    {
        return $this->getTotalRecord() - ($this->getCurrentPage() - 1) * $this->getPageSize();
    }

    public function hasNext()
    {
        return $this->getCurrentPage() > 0 && $this->getCurrentPage() != $this->getTotalPage();
    }

    public function hasPrev()
    {
        return $this->getTotalPage() > 1 && $this->getCurrentPage() > 1;
    }

    public function getPageSize()
    {
        return $this->_pageSize;
    }

    public function setPageSize($pageSize)
    {
        $this->_pageSize = $pageSize;
    }

    public function setTotalRecord($total)
    {
        $this->_totalRecord = $total;
    }

    public function getTotalRecord()
    {
        return $this->_totalRecord;
    }

    public function getTotalPage()
    {
        return ceil($this->getTotalRecord() / $this->getPageSize());
    }
    
    public function setCurrentPage($page)
    {
        $this->_currentPage = $page;
    }

    public function getCurrentPage()
    {
        return $this->_currentPage;
    }

    public function setBaseUrl($url)
    {
        $this->_baseUrl = $url;
    }

    public function getBaseUrl()
    {
        return $this->_baseUrl;
    }
}