<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class iRequest
{
    private static $_scriptUrl;
    private static $_pathInfo;
    private static $_requestUri;
    private static $_baseUrl;
    private static $_hostInfo;
    private static $_securePort;
    private static $_port;
    
    public static function getScriptUrl()
	{
		if(self::$_scriptUrl === null)
		{
			$scriptName = basename($_SERVER['SCRIPT_FILENAME']);
			if(basename($_SERVER['SCRIPT_NAME']) === $scriptName)
			{
				self::$_scriptUrl = $_SERVER['SCRIPT_NAME'];
			}
			else if(basename($_SERVER['PHP_SELF']) === $scriptName)
			{
				self::$_scriptUrl = $_SERVER['PHP_SELF'];
			}
			else if(isset($_SERVER['ORIG_SCRIPT_NAME']) && basename($_SERVER['ORIG_SCRIPT_NAME']) === $scriptName)
			{
				self::$_scriptUrl = $_SERVER['ORIG_SCRIPT_NAME'];
			}
			else if(($pos = strpos($_SERVER['PHP_SELF'], '/'.$scriptName)) !== false)
			{
				self::$_scriptUrl = substr($_SERVER['SCRIPT_NAME'], 0, $pos) . '/' . $scriptName;
			}
			else if(isset($_SERVER['DOCUMENT_ROOT']) && strpos($_SERVER['SCRIPT_FILENAME'],$_SERVER['DOCUMENT_ROOT']) === 0)
			{
				self::$_scriptUrl = str_replace('\\', '/', str_replace($_SERVER['DOCUMENT_ROOT'], '', $_SERVER['SCRIPT_FILENAME']));
			}
			else
			{
				throw new Exception('无法确定入口脚本网址');
			}
		}
		return self::$_scriptUrl;
    }
    
    public static function getPathInfo()
	{
		if(self::$_pathInfo === null)
		{
			$requestUri = urldecode(self::getRequestUri());
			$scriptUrl = self::getScriptUrl();
			$baseUrl = self::getBaseUrl();
			if(strpos($requestUri, $scriptUrl) === 0)
			{
				$pathInfo = substr($requestUri, strlen($scriptUrl));
			}
			else if($baseUrl === '' || strpos($requestUri,$baseUrl) === 0)
			{
				$pathInfo = substr($requestUri,strlen($baseUrl));
			}
			else if(strpos($_SERVER['PHP_SELF'],$scriptUrl) === 0)
			{
				$pathInfo = substr($_SERVER['PHP_SELF'], strlen($scriptUrl));
			}
			else
			{
				throw new Exception('无法确定请求的路径信息');
			}

			if(($pos = strpos($pathInfo,'?')) !== false)
			{
				$pathInfo = substr($pathInfo, 0, $pos);
			}

			self::$_pathInfo = trim($pathInfo, '/');
		}
		return self::$_pathInfo;
	}
	
    public static function getRequestUri()
	{
		if(self::$_requestUri === null)
		{
			if(isset($_SERVER['HTTP_X_REWRITE_URL']))
			{
			    // IIS
				self::$_requestUri = $_SERVER['HTTP_X_REWRITE_URL'];
			}
			else if(isset($_SERVER['REQUEST_URI']))
			{
				self::$_requestUri = $_SERVER['REQUEST_URI'];
				if(strpos(self::$_requestUri,$_SERVER['HTTP_HOST']) !== false)
				{
					self::$_requestUri = preg_replace('/^\w+:\/\/[^\/]+/','',self::$_requestUri);
				}
			}
			else if(isset($_SERVER['ORIG_PATH_INFO']))
			{
			    // IIS 5.0 CGI
				self::$_requestUri = $_SERVER['ORIG_PATH_INFO'];
				if(!empty($_SERVER['QUERY_STRING']))
				{
					self::$_requestUri .= '?'.$_SERVER['QUERY_STRING'];
				}
			}
			else
			{
				throw new Exception('无法确定请求URI');
			}
		}

		return self::$_requestUri;
	}
	
    public static function getHostInfo($schema='')
	{
		if(self::$_hostInfo === null)
		{
			if($secure = self::getIsSecureConnection())
			{
				$http = 'https';
			}
			else
			{
				$http = 'http';
			}
			if(isset($_SERVER['HTTP_HOST']))
			{
				self::$_hostInfo = $http.'://'.$_SERVER['HTTP_HOST'];
			}
			else
			{
				self::$_hostInfo=$http.'://'.$_SERVER['SERVER_NAME'];
				$port=$secure ? self::getSecurePort() : self::getPort();
				if(($port !== 80 && !$secure) || ($port !== 443 && $secure))
				{
					self::$_hostInfo.=':'.$port;
				}
			}
		}
		if($schema!=='')
		{
			$secure=self::getIsSecureConnection();
			if($secure && $schema === 'https' || !$secure && $schema === 'http')
			{
				return self::$_hostInfo;
			}

			$port = $schema === 'https' ? self::getSecurePort() : self::getPort();
			if($port !== 80 && $schema === 'http' || $port !== 443 && $schema === 'https')
			{
				$port = ':' . $port;
			}
			else
			{
				$port='';
			}

			$pos = strpos(self::$_hostInfo,':');
			return $schema.substr(self::$_hostInfo, $pos,strcspn(self::$_hostInfo,':',$pos+1)+1).$port;
		}
		else
			return self::$_hostInfo;
	}
	
    public function getBaseUrl($absolute=false)
	{
		if(self::$_baseUrl === null)
		{
			self::$_baseUrl = rtrim(dirname(self::getScriptUrl()),'\\/');
		}
		return $absolute ? self::getHostInfo() . self::$_baseUrl : self::$_baseUrl;
	}
	
    public static function getIsSecureConnection()
	{
	    return isset($_SERVER['HTTPS']) && !strcasecmp($_SERVER['HTTPS'],'on');
	}
	
    public static function getSecurePort()
	{
		if(self::$_securePort === null)
		{
			self::$_securePort = self::getIsSecureConnection() && isset($_SERVER['SERVER_PORT']) ? (int)$_SERVER['SERVER_PORT'] : 443;
		}
		return self::$_securePort;
	}
	
    public static function getPort()
	{
		if(self::$_port === null)
		{
			self::$_port = !self::getIsSecureConnection() && isset($_SERVER['SERVER_PORT']) ? (int)$_SERVER['SERVER_PORT'] : 80;
		}
		return self::$_port;
	}
	
    public static function isAjaxRequest()
	{
		return isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest';
	}
}