<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class iUrl
{
    public static function Book($bookid, $name = null, $params = null)
    {
        $url = self::Url('bookshow', $params);
        if (is_null($name))
        {
            $book = fetchBookInfo($bookid);
            if (empty($book))
            {
                return '';
            }
            $name = $book['bookname'];
        }
        
        return self::Href($url, $name);
    }

    public static function Bforum($bookid, $name = null, $params = null)
    {
        $url = self::Url('bookforum/index', $params);
        if (is_null($name))
        {
            $bookforum = getBookForum($bookid);
            if (empty($bookforum))
            {
                return '';
            }
            $name = $bookforum['forumname'];
        }

        return self::Href($url, $name);
    }

    public static function Forum()
    {
    }

    public static function Image($url, $alt = '^_^')
    {
        return '<img src="'.$url.'" alt="'.$alt.'" />';
    }

    public static function Href($url, $message)
    {
        return '<a href="'.$url.'">'.$message.'</a>';
    }

    public static function Url($controller, $params = null, $sid = null)
    {
        return url($controller, $params, $sid);
    }
}