<?php
class iWebPage
{
    public $baseUrl = '';
    
    public $currentPage;
    
    public $pageSize = 10;
    
    public $pageVar = '';
    
    protected $_totalRecord;
    
    protected $_controller = '';
    
    protected $_params = array();
    
    public function __construct($controller = 'system', $pageVar = 'page')
    {
        $this->pageVar = $pageVar;
        $this->setParams($_GET);
        $this->setController($controller);
        $this->currentPage = max(1, S::gp($this->pageVar,'G',2));
        //$this->baseUrl = str_replace('&','&amp;', preg_replace('/&'.$this->pageVar.'=([0-9]+)/', '', $_SERVER['REQUEST_URI']));
    }
    
    public function show()
    {
        echo <<<EOT
<style type="text/css">
.pagination {
	margin-top:2px;
	height: 30px;
	line-height: 30px;
}

.pagination a, .pagination strong {
    background-color: #FFFFFF;
    border: 1px solid #E3EDF5;
    color: #0099CC;
    margin-left: 1px;
    padding: 6px 6px;
    text-align: center;
    text-decoration: none;
}
.pagination strong {
    background-color: #0099CC;
    border-color: #0099CC;
    color: #FFFFFF;
    font-weight: 700;
}
.pagination .current {
	background-color:#EEEEEE;
}
.pagination .disabled {
	border: 1px solid #DDDDDD;
	color: #999999;
	padding: 6px 6px; 
}
</style>
EOT;
       
        $pagitation = '<div class="pagination">';
        if ($this->getCurrentPage() > 0)
        {
            if ($this->getCurrentPage() <= 1)
            {
                $pagitation .= '<span class="disabled prev_page">« 上一页</span>';
            }
            else
            {
                $pagitation .= ilink('« 上一页', $this->getUrl('page', $this->getCurrentPage()-1));
                $pagitation .= ilink('«', $this->getUrl('page',1));
            }
        }

        $totalPage = $this->getTotalPage();
        if (1 >= $totalPage)
        {
            return;
        }

        for ($i = ($this->getCurrentPage() - 6); $i < ($this->getCurrentPage() + 10) && $i <= $totalPage; $i++)
        {
            if ($i > 0)
            {
                if ($this->getCurrentPage() == $i)
                {
                    $tmp .= '<strong>'.$i.'</strong>';
                }
                else 
                {
                    $tmp .= ilink($i, $this->getUrl('page', $i));
                }
            }
            $pageTmp = $tmp . '';
        }

        if (!empty($pageTmp))
        {
            $pagitation .= $pageTmp;
        }

        if ($this->getTotalRecord() > ($begin + $this->getPageSize()))
        {
            if ($this->getCurrentPage() >= $totalPage)
            {
                $pagitation .= '<span class="disabled">下一页 »</span>';
            }
            else
            {
                $pagitation .= ilink('»', $this->getUrl('page',$this->getTotalPage()));
                $pagitation .= ilink('下一页 »', $this->getUrl('page', $this->getCurrentPage()+1));
            }
        }

        echo $pagitation .'</div>';
    }
    
    public function getUrl($key, $value)
    {
        $params = $this->getParams();
        $params = array_merge($params, array($key => $value));
        return url($this->getController(), $params);
        //return $this->getBaseUrl() . ((false === strpos($this->getBaseUrl(), '?')) ? '?' : '&amp;') . $key.'='.$value;
    }

    public function getController()
    {
        return $this->_controller;
    }
    
    public function setController($controller)
    {
        $this->_controller = $controller;
    }
    
    public function getOffset()
    {
        return ($this->getCurrentPage() - 1) * $this->getPageSize();
    }

    public function getFloor()
    {
        return $this->getTotalRecord() - ($this->getCurrentPage() - 1) * $this->getPageSize();
    }

    public function getPageSize()
    {
        return $this->pageSize;
    }

    public function setPageSize($pageSize)
    {
        $this->pageSize = $pageSize;
    }

    public function setTotalRecord($total)
    {
        $this->_totalRecord = $total;
    }

    public function getTotalRecord()
    {
        return $this->_totalRecord;
    }

    public function getTotalPage()
    {
        return ceil($this->getTotalRecord() / $this->getPageSize());
    }
    
    public function setCurrentPage($page)
    {
        $this->currentPage = $page;
    }

    public function getCurrentPage()
    {
        return $this->currentPage;
    }

    public function setBaseUrl($url)
    {
        $this->baseUrl = $url;
    }

    public function getBaseUrl()
    {
        return $this->baseUrl;
    }
    
    public function setParams($params)
    {
        $this->_params = $params;
    }
    
    public function getParams()
    {
        // 去掉一下不必要的参数
        $params = $this->_params;
        unset($params[$this->pageVar]);
        unset($params['st']);
        
        return $params;
    }
}