<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class Yeepay
{
    /**
     * Yeepay 实例池
     * @var Array<Yeepay>
     */
    protected static $instances = array();

    /**
     * Yeepay 配置
     * @var Yeepay_Config
     */
    protected $config;

    /**
     * 获取 Yeepay 实例
     * @param string $name
     * @return Yeepay
     */
    public static function getInstance($name = 'default')
    {
        return self::$instances[$name];
    }

    /**
     * 新建 Yeepay 实例并保存到实例池
     * @param Yeepay_Config $config
     * @param string $name 实例名称
     * @return Yeepay
     */
    public function __construct(Yeepay_Config $config, $name = 'default')
    {
        $this->config = $config;
        self::$instances[$name] = $this;
    }

    /**
     * 新建订单请求
     * @param string $type
     * @return Yeepay_Request_ChargeCardDirect
     */
    public function makeOrder($type = 'ChargeCardDirect')
    {
        $classString = 'Yeepay_Request_' . $type;
        return new $classString($this);
    }

    /**
     * 查询订单请求
     * @return Yeepay_Request_Query
     */
    public function queryOrder()
    {
        return new Yeepay_Request_Query($this);
    }

    /**
     * 订单退款请求
     * @return Yeepay_Request_Refund
     */
    public function refundOrder()
    {
        return new Yeepay_Request_Refund($this);
    }

    /**
     * 获取商户编号
     * @return string
     */
    public function getMerchantId()
    {
        return $this->config->getMerchantId();
    }

    /**
     * 对字符串进行 HMAC-MD5 编码
     * @param mixed $string
     * @return string
     */
    public function getHmac($string)
    {
        # 处理编码
        $url = 'http://25800.net/yeehmac.php?k='.$this->config->getMerchantKey().'&s='.urlencode($string);

        return getFile($url);
    }

    /**
     * 获取业务类型的请求地址
     * @param string $command
     * @return string
     */
    public function getRequestUrl($command)
    {
        return $this->config->getCommandUrl($command);
    }
}