<?php

/**
 * Yeepay 类加载器
 *
 * @author Jeffrey
 * @version $Id: Loader.php 42 2010-01-28 16:11:55Z jeffrey $
 */
class Yeepay_Loader extends Exception
{
    /**
     * 加载器实例
     *
     * @var Yeepay_Loader
     */
    protected static $instance = null;

    /**
     * Yeepay 所在路径(自动获取)
     *
     * @var string
     */
    protected $path;

    /**
     * 获取加载器实例
     *
     * @return Yeepay_Loader
     */
    public static function getInstance()
    {
        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     * 注册 Yeepay 加载器到自动加载器列表
     */
    public static function register()
    {
        $instance = self::getInstance();
        spl_autoload_register(array($instance, 'yeeLoad'), false);
    }

    /**
     * 从自动加载器列表解除 Yeepay 加载器注册
     */
    public static function unregister()
    {
        $instance = self::getInstance();
        spl_autoload_unregister(array($instance, 'yeeLoad'));
    }

    /**
     * 创建 Yeepay 加载器实例
     *
     * @return Yeepay_Loader
     */
    public function __construct()
    {
        $di = DIRECTORY_SEPARATOR;
        $this->path = realpath(dirname(__FILE__) . $di . '..') . $di;
    }

    /**
     * 自动加载
     *
     * @param string $className
     */
    public function yeeLoad($className)
    {
        $filename = str_replace('_', DIRECTORY_SEPARATOR, $className);
        $filename = $this->path . $filename . '.php';

        if (file_exists($filename)) {
            require $filename;
        }
    }
}