<?php

/**
 * 易宝支付请求对象
 * @author Jeffrey
 * @version $Id: Buy.php 90 2010-02-25 15:10:21Z jeffrey $
 */
class Yeepay_Request_Buy extends Yeepay_Request
{
    /**
     * 签名字段和顺序
     *
     * @var Array
     */
    protected $hashMap = array(
        'p0_Cmd' => 'command', // 固定值为Buy
        'p1_MerId' => 'merchantId', // 商户在易宝支付系统的唯一身份标识
        'p2_Order' => 'order', // 提交的订单号必须在自身账户交易中唯一
        'p3_Amt' => 'amount', // 支付金额
        'p4_Cur' => 'currency', // 交易币种
        'p5_Pid' => 'productId', // 产品名称
        'p6_Pcat' => 'productCategory', // 产品类型
        'p7_Pdesc' => 'productDescription', // 产品描述
        'p8_Url' => 'callbackUrl', // 商户接收支付成功数据的地址
        'p9_SAF' => 'saf', // 送货地址
        'pa_MP' => 'merchantPersist', // 商户扩展信息
        'pd_FrpId' => 'frpId', // 支付渠道编码
        'pr_NeedResponse' => 'needResponse', // 应答机制
    );

    /**
     * 请求结果对象名称
     * @var string
     */
    protected $responseClass = 'Yeepay_Response_Buy'; # static

    /**
     * 业务类型
     * @var string(20)
     */
    protected $command = 'Buy';

    /**
     * 商户订单号
     * @var string(50)
     */
    public $order;

    /**
     * 支付金额
     *
     * @var decimal(18,2)
     */
    public $amount;

    /**
     * 交易币种
     *
     * @var string(10)
     */
    public $currency = 'CNY';

    /**
     * 商品名称
     *
     * @var string(20)
     */
    public $productId;

    /**
     * 商品种类
     *
     * @var string(20)
     */
    public $productCategory;

    /**
     * 商品描述
     *
     * @var string(20)
     */
    public $productDescription;

    /**
     * 商户接收支付成功数据的地址
     *
     * @var string(200)
     */
    public $callbackUrl;

    /**
     * 送货地址
     *
     * @var string(1)
     */
    public $saf;

    /**
     * 商户扩展信息
     *
     * @var string(200)
     */
    public $merchantPersist;

    /**
     * 支付通道编码
     *
     * @var string(50)
     */
    public $frpId;

    /**
     * 应答机制
     *
     * @var string(1)
     */
    public $needResponse;
}
