<?php
/**
 * 非银行卡专业版实现
 * User: yzxh24
 * Date: 11-9-27
 * Time: 下午3:14
 * To change this template use File | Settings | File Templates.
 */
class Yeepay_Request_ChargeCardDirect extends Yeepay_Request
{
    /**
     * 签名字段和顺序
     * @var Array
     */
    protected $hashMap = array( # static
        'p0_Cmd' => 'command', // 非银行卡专业版支付请求固定值“ChargeCardDirect”
        'p1_MerId' => 'merchantId', // 商户在易宝支付系统的唯一身份标识
        'p2_Order' => 'order', // 提交的订单号必须在自身账户交易中唯一
        'p3_Amt' => 'amount', // 支付金额
        'p4_verifyAmt' => 'verifyAmt', // 是否较验订单金额
        'p5_Pid' => 'productId', // 产品名称
        'p6_Pcat' => 'productCategory', // 产品类型
        'p7_Pdesc' => 'productDescription', // 产品描述
        'p8_Url' => 'callbackUrl', // 商户接收支付成功数据的地址
        'pa_MP' => 'merchantPersist', // 商户扩展信息
        'pa7_cardAmt' => 'cardAmt', // 卡面额组
        'pa8_cardNo' => 'cardNo', // 卡号组
        'pa9_cardPwd' => 'cardPwd', // 卡密组
        'pd_FrpId' => 'frpId', // 支付渠道编码
        'pr_NeedResponse' => 'needResponse', // 应答机制
        'pz_userId' => 'userId', // 用户ID
        'pz1_userRegTime' => 'userRegTime', // 用户在商户处注册的时间
    );

    /**
     * 请求结果对象名称
     * @var string
     */
    protected $responseClass = 'Yeepay_Response_ChargeCardDirect'; # static

    /**
     * 业务类型(非银行卡专业版支付请求固定值“ChargeCardDirect”)
     * @var string(20)
     */
    protected $command = 'ChargeCardDirect';

    /**
     * 商户订单
     * @var string(20)
     */
    public $order;

    /**
     * 订单金额
     * @var string(10)
     */
    public $amount;

    /**
     * 是否较验订单金额
     * true校验金额;  false不校验金额
     * @var string(10)
     */
    public $verifyAmt;

    /**
     * 产品名称(非必须)
     * @var string(20)
     */
    public $productId;

    /**
     * 产品类型(非必须)
     * @var string(20)
     */
    public $productCategory;

    /**
     * 产品描述(非必须)
     * @var string(50)
     */
    public $productDescription;

    /**
     * 支付订单处理完成后易宝支付会向该地址发送支付结果通知
     * @var string(200)
     */
    public $callbackUrl;

    /**
     *  商户扩展信息(非必须)
     * @var string(30)
     */
    public $merchantPersist;

    /**
     * 卡面额组
     * @var string(200)
     */
    public $cardAmt;

    /**
     * 卡号组
     * @var string(200)
     */
    public $cardNo;

    /**
     * 卡密组
     * @var string(200)
     */
    public $cardPwd;

    /**
     * 支付渠道编码
     * @var string(20)
     */
    public $frpId;

    /**
     * 应答机制
     * @var string(2)
     */
    public $needResponse;

    /**
     * 用户ID(非必须)
     * @var string(20)
     */
    public $userId;

    /**
     * 用户注册时间(非必须)
     * @var string(30)
     */
    public $userRegTime;
}
