<?php

/**
 * @author Jeffrey
 * @version $Id: Buy.php 42 2010-01-28 16:11:55Z jeffrey $
 */
class Yeepay_Response_Buy extends Yeepay_Response
{
    /**
     * 签名字段和顺序
     * @var Array
     */
    protected static $hashMap = array(
        'p1_MerId' => 'merchantId', // 商户编号
        'r0_Cmd' => 'command', // 业务类型，固定值 ”Buy”
        'r1_Code' => 'code', // 支付结果,值为“1”, 代表支付成功.非“1”失败。
        'r2_TrxId' => 'tradeId', // 易宝支付交易流水号
        'r3_Amt' => 'realMoney', // 支付金额
        'r4_Cur' => 'currency', // 交易币种,返回时是"RMB"
        'r5_Pid' => 'product', // 商品名称,
        'r6_Order' => 'order', // 易宝支付返回商户订单号
        'r7_Uid' => 'userId', // 易宝支付会员ID
        'r8_MP' => 'merchantPersist', // 商户扩展信息
        'r9_BType' => 'backType', // 交易结果返回类型,为“1”: 浏览器重定向; 为“2”: 服务器点对点通讯.
        'hmac' => 'hmac',
    );

    /**
     * 业务类型
     *
     * @var string(20)
     */
    protected $command = 'Buy';

    /**
     * 商户编号
     *
     * @var string(11)
     */
    public $merchantId;

    /**
     * 支付结果
     *
     * @var string(50)
     */
    public $code;

    /**
     * 易宝支付交易流水号
     *
     * @var string(50)
     */
    public $tradeId;

    /**
     * 支付金额
     *
     * @var string(20)
     */
    public $realMoney;

    /**
     * 交易币种
     *
     * @var string(20)
     */
    public $currency = 'RMB';

    /**
     * 商品名称
     *
     * @var string(20)
     */
    public $product;

    /**
     * 商户订单号
     *
     * @var string(50)
     */
    public $order;

    /**
     * Yeepay 用户编号
     *
     * @var string(50)
     */
    public $userId;

    /**
     * 商户扩展信息
     *
     * @var string(200)
     */
    public $merchantPersist;

    /**
     * 交易结果返回类型
     *
     * @var string(1)
     */
    public $backType;

    /**
     * 服务器返回的签名
     * @var string
     */
    public $hmac;
}