<?php
/**
 * 非专业版卡类支付回调响应
 * User: yzxh24
 * Date: 11-9-30
 * Time: 上午10:09
 * To change this template use File | Settings | File Templates.
 */
class Yeepay_Response_CallBack extends Yeepay_Response
{
    /**
     * 非专业版提交数据成功后返回的响应
     * 签名字段和顺序
     * @var Array
     */
    protected static $hashMap = array(
        'r0_Cmd' => 'command', // 业务类型，固定值 ”ChargeCardDirect”
        'r1_Code' => 'code', // 支付结果,值为“1”, 代表支付成功.非“1”失败。
        'p1_MerId' => 'merchantId', // 商户编号
        'p2_Order' => 'order', // 易宝支付返回商户订单号
        'p3_Amt' => 'amount', // 成功金额,保留两位小数,不足两位小数的将保留一位！(如 0.10 将返回0.1, 0会返回0.0) . 商户收到该返回数据后,一定用自己数据库中存储的金额与该金额进行比较.
        'p4_FrpId' => 'frpId', // 支付卡对应的支付渠道编码
        'p5_CardNo' => 'cardNo', // 卡序列号组,多张卡以半角逗号分隔
        'p6_confirmAmount' => 'confirmAmount', // 确认金额组
        'p7_realAmount' => 'realAmount', // 实际金额组,卡原有的金额组
        'p8_cardStatus' => 'cardStatus', // 卡状态组,0：销卡成功，订单成功 1：销卡成功，订单失败
        'p9_MP' => 'mp', // 扩展信息
        'pb_BalanceAmt' => 'balanceAmt', // 支付余额
        'pc_BalanceAct' => 'balanceAct', // 余额卡号
        'hmac' => 'hmac', // 签名数据
    );

    /**
     * 业务类型，固定值 ”ChargeCardDirect”
     * @var string
     */
    public $command = 'ChargeCardDirect';

    /**
     * 支付结果,值为“1”, 代表支付成功.非“1”失败。
     * @var string
     */
    public $code;

    /**
     * 商户编号
     * @var string
     */
    public $merchantId;

    /**
     * 易宝支付返回商户订单号
     * @var string
     */
    public $order;

    /**
     * 成功金额
     * @var string
     */
    public $amount;

    /**
     * 支付卡对应的支付渠道编码
     * @var string
     */
    public $frpId;

    /**
     * 卡序列号组,多张卡以半角逗号分隔
     * @var string
     */
    public $cardNo;

    /**
     * 确认金额组
     * @var string
     */
    public $confirmAmount;

    /**
     *实际金额组
     * @var string
     */
    public $realAmount;

    /**
     * 卡状态组
     * @var string
     */
    public $cardStatus;

    /**
     * 扩展信息
     * @var string
     */
    public $mp;

    /**
     * 支付余额
     * @var string
     */
    public $balanceAmt;

    /**
     * 余额卡号
     * @var string
     */
    public $balanceAct;

    /**
     * 签名数据
     * @var string
     */
    public $hmac;
}